/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXBuilder {
    private static final String DEFAULT_SAX_DRIVER = "org.apache.xerces.parsers.SAXParser";
    private boolean validate;
    private String saxDriverClass;
    private ErrorHandler saxErrorHandler = null;
    private EntityResolver saxEntityResolver = null;
    private DTDHandler saxDTDHandler = null;

    public SAXBuilder() {
        this(DEFAULT_SAX_DRIVER, false);
    }

    public SAXBuilder(String saxDriverClass) {
        this(saxDriverClass, false);
    }

    public SAXBuilder(String saxDriverClass, boolean validate) {
        this.saxDriverClass = saxDriverClass;
        this.validate = validate;
    }

    public SAXBuilder(boolean validate) {
        this(DEFAULT_SAX_DRIVER, validate);
    }

    public Document build(File file) throws JDOMException {
        try {
            URL url = this.fileToURL(file);
            return this.build(url);
        }
        catch (MalformedURLException e) {
            throw new JDOMException(e.getMessage(), e);
        }
    }

    public Document build(InputStream in) throws JDOMException {
        return this.build(new InputSource(in));
    }

    public Document build(InputStream in, String systemId) throws JDOMException {
        InputSource src = new InputSource(in);
        src.setSystemId(systemId);
        return this.build(src);
    }

    public Document build(Reader characterStream) throws JDOMException {
        return this.build(new InputSource(characterStream));
    }

    public Document build(Reader characterStream, String SystemId) throws JDOMException {
        InputSource src = new InputSource(characterStream);
        src.setSystemId(SystemId);
        return this.build(src);
    }

    public Document build(String systemId) throws JDOMException {
        return this.build(new InputSource(systemId));
    }

    public Document build(URL url) throws JDOMException {
        String systemID = url.toExternalForm();
        return this.build(new InputSource(systemID));
    }

    protected Document build(InputSource in) throws JDOMException {
        Document doc = new Document(null);
        try {
            XMLReader parser;
            block21: {
                parser = XMLReaderFactory.createXMLReader(this.saxDriverClass);
                SAXHandler contentHandler = new SAXHandler(doc);
                parser.setContentHandler(contentHandler);
                if (this.saxEntityResolver != null) {
                    parser.setEntityResolver(this.saxEntityResolver);
                }
                if (this.saxDTDHandler != null) {
                    parser.setDTDHandler(this.saxDTDHandler);
                }
                boolean lexicalReporting = false;
                try {
                    parser.setProperty("http://xml.org/sax/handlers/LexicalHandler", contentHandler);
                    lexicalReporting = true;
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {}
                if (!lexicalReporting) {
                    try {
                        parser.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
                        lexicalReporting = true;
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {}
                }
                try {
                    parser.setFeature("http://xml.org/sax/features/validation", this.validate);
                    parser.setFeature("http://xml.org/sax/features/namespaces", true);
                    parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                    if (this.saxErrorHandler != null) {
                        parser.setErrorHandler(this.saxErrorHandler);
                    } else {
                        parser.setErrorHandler(contentHandler);
                    }
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    if (this.validate) {
                        throw new JDOMException("Validation not supported for " + this.saxDriverClass + " SAX Driver");
                    }
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    if (!this.validate) break block21;
                    throw new JDOMException("Validation feature not recognized for " + this.saxDriverClass + " SAX Driver");
                }
            }
            parser.parse(in);
            return doc;
        }
        catch (Exception e) {
            if (e instanceof SAXParseException) {
                SAXParseException p = (SAXParseException)e;
                String systemId = p.getSystemId();
                if (systemId != null) {
                    throw new JDOMException(e.getMessage(), new JDOMException("Error on line " + p.getLineNumber() + " of document " + systemId + ": " + p.getMessage(), e));
                }
                throw new JDOMException(e.getMessage(), new JDOMException("Error on line " + p.getLineNumber() + ": " + p.getMessage(), e));
            }
            throw new JDOMException(e.getMessage(), e);
        }
    }

    protected URL fileToURL(File f) throws MalformedURLException {
        String path = f.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && f.isDirectory()) {
            path = String.valueOf(path) + "/";
        }
        return new URL("file", "", path);
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.saxDTDHandler = dtdHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.saxEntityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.saxErrorHandler = errorHandler;
    }

    public void setValidation(boolean validate) {
        this.validate = validate;
    }
}

