const HANASystemReplicationModes = {
  Primary: 'HANA Primary',
  Secondary: 'HANA Secondary',
};

export const healthMap = {
  GREEN: 'fill-jungle-green-500',
  YELLOW: 'fill-yellow-500',
  RED: 'fill-red-500',
  GRAY: 'fill-gray-500',
};

export const isHanaInstance = (instance) => instance.systemReplication != '';
export const isHanaSecondary = (instance) =>
  instance.systemReplication == HANASystemReplicationModes.Secondary;
export const isHanaPrimary = (instance) =>
  instance.systemReplication == HANASystemReplicationModes.Primary;

export const availableSAPSystems = [
  {
    sid: 'NWD',
    id: '67b247e4-ab5b-5094-993a-a4fd70d0e8d1',
    health: 'GREEN',
    type: 'ABAP',
    attachedDatabase: {
      sid: 'HDD',
      id: 'f534a4ad-cef7-5234-b196-e67082ffb50c',
      tenant: 'HDD',
      dbAddress: '10.100.1.13',
    },
    instances: [
      {
        sid: 'NWD',
        health: 'GREEN',
        features: 'MESSAGESERVER|ENQUE',
        instanceNumber: '00',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: 'netweaver_cluster',
        clusterID: '',
        hostname: 'vmnwdev01',
        hostID: '7269ee51-5007-5849-aaa7-7c4a98b0c9ce',
      },
      {
        sid: 'NWD',
        health: 'GREEN',
        features: 'ABAP|GATEWAY|ICMAN|IGS',
        instanceNumber: '01',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: '',
        clusterID: '',
        hostname: 'vmnwdev03',
        hostID: '9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f',
      },
      {
        sid: 'NWD',
        health: 'GREEN',
        features: 'ABAP|GATEWAY|ICMAN|IGS',
        instanceNumber: '02',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: '',
        clusterID: '',
        hostname: 'vmnwdev04',
        hostID: '1b0e9297-97dd-55d6-9874-8efde4d84c90',
      },
      {
        sid: 'NWD',
        health: 'GREEN',
        features: 'ENQREP',
        instanceNumber: '10',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: 'netweaver_cluster',
        clusterID: '',
        hostname: 'vmnwdev02',
        hostID: 'fb2c6b8a-9915-5969-a6b7-8b5a42de1971',
      },
      {
        sid: 'HDD',
        health: 'GREEN',
        features: 'HDB|HDB_WORKER',
        instanceNumber: '10',
        systemReplication: HANASystemReplicationModes.Secondary,
        systemReplicationStatus: 'ACTIVE',
        clusterName: 'hana_cluster_1',
        clusterID: '7965f822-0254-5858-abca-f6e8b4c27714',
        hostname: 'vmhdbdev02',
        hostID: '0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4',
      },
      {
        sid: 'HDD',
        health: 'GREEN',
        features: 'HDB|HDB_WORKER',
        instanceNumber: '10',
        systemReplication: HANASystemReplicationModes.Primary,
        systemReplicationStatus: '',
        clusterName: 'hana_cluster_1',
        clusterID: '7965f822-0254-5858-abca-f6e8b4c27714',
        hostname: 'vmhdbdev01',
        hostID: '13e8c25c-3180-5a9a-95c8-51ec38e50cfc',
      },
    ],
    tag: 'env3',
  },
  {
    id: 'eb7bc03e-166f-5ed0-b22d-79672d110d04',
    sid: 'NWP',
    health: 'GREEN',
    type: 'ABAP',
    attachedDatabase: {
      sid: 'HDP',
      id: '6c9208eb-a5bb-57ef-be5c-6422dedab602',
      tenant: 'HDP',
      dbAddress: '10.80.1.13',
    },
    instances: [
      {
        sid: 'NWP',
        health: 'GREEN',
        features: 'MESSAGESERVER|ENQUE',
        instanceNumber: '00',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: 'netweaver_cluster',
        clusterID: '',
        hostname: 'vmnwprd01',
        hostID: '116d49bd-85e1-5e59-b820-83f66db8800c',
      },
      {
        sid: 'NWP',
        health: 'GREEN',
        features: 'ABAP|GATEWAY|ICMAN|IGS',
        instanceNumber: '01',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: '',
        clusterID: '',
        hostname: 'vmnwprd03',
        hostID: 'a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12',
      },
      {
        sid: 'NWP',
        health: 'GREEN',
        features: 'ABAP|GATEWAY|ICMAN|IGS',
        instanceNumber: '02',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: '',
        clusterID: '',
        hostname: 'vmnwprd04',
        hostID: '0fc07435-7ee2-54ca-b0de-fb27ffdc5deb',
      },
      {
        sid: 'NWP',
        health: 'GREEN',
        features: 'ENQREP',
        instanceNumber: '10',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: 'netweaver_cluster',
        clusterID: '',
        hostname: 'vmnwprd02',
        hostID: '4b30a6af-4b52-5bda-bccb-f2248a12c992',
      },
      {
        sid: 'HDP',
        health: 'GREEN',
        features: 'HDB|HDB_WORKER',
        instanceNumber: '10',
        systemReplication: HANASystemReplicationModes.Primary,
        systemReplicationStatus: '',
        clusterName: 'hana_cluster_3',
        clusterID: '469e7be5-4e20-5007-b044-c6f540a87493',
        hostname: 'vmhdbprd01',
        hostID: '9cd46919-5f19-59aa-993e-cf3736c71053',
      },
      {
        sid: 'HDP',
        health: 'GREEN',
        features: 'HDB|HDB_WORKER',
        instanceNumber: '10',
        systemReplication: HANASystemReplicationModes.Secondary,
        systemReplicationStatus: 'ACTIVE',
        clusterName: 'hana_cluster_3',
        clusterID: '469e7be5-4e20-5007-b044-c6f540a87493',
        hostname: 'vmhdbprd02',
        hostID: 'b767b3e9-e802-587e-a442-541d093b86b9',
      },
    ],
    tag: 'env1',
  },
  {
    id: '6748d2dd-b5a1-5599-895c-d1308b2d6541',
    sid: 'NWQ',
    health: 'GREEN',
    type: 'ABAP',
    attachedDatabase: {
      sid: 'HDQ',
      id: 'cd52e571-c897-5bba-b0f9-e155ceca1fff',
      tenant: 'HDQ',
      dbAddress: '10.90.1.13',
    },
    instances: [
      {
        sid: 'NWQ',
        health: 'GREEN',
        features: 'MESSAGESERVER|ENQUE',
        instanceNumber: '00',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: 'netweaver_cluster',
        clusterID: '',
        hostname: 'vmnwqas01',
        hostID: '25677e37-fd33-5005-896c-9275b1284534',
      },
      {
        sid: 'NWQ',
        health: 'GREEN',
        features: 'ABAP|GATEWAY|ICMAN|IGS',
        instanceNumber: '01',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: '',
        clusterID: '',
        hostname: 'vmnwqas03',
        hostID: '098fc159-3ed6-58e7-91be-38fda8a833ea',
      },
      {
        sid: 'NWQ',
        health: 'GREEN',
        features: 'ABAP|GATEWAY|ICMAN|IGS',
        instanceNumber: '02',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: '',
        clusterID: '',
        hostname: 'vmnwqas04',
        hostID: '81e9b629-c1e7-538f-bff1-47d3a6580522',
      },
      {
        sid: 'NWQ',
        health: 'GREEN',
        features: 'ENQREP',
        instanceNumber: '10',
        systemReplication: '',
        systemReplicationStatus: '',
        clusterName: 'netweaver_cluster',
        clusterID: '',
        hostname: 'vmnwqas02',
        hostID: '3711ea88-9ccc-5b07-8f9d-042be449d72b',
      },
      {
        sid: 'HDQ',
        health: 'GREEN',
        features: 'HDB|HDB_WORKER',
        instanceNumber: '10',
        systemReplication: HANASystemReplicationModes.Primary,
        systemReplicationStatus: '',
        clusterName: 'hana_cluster_2',
        clusterID: 'fa0d74a3-9240-5d9e-99fa-61c4137acf81',
        hostname: 'vmhdbqas01',
        hostID: '99cf8a3a-48d6-57a4-b302-6e4482227ab6',
      },
      {
        sid: 'HDQ',
        health: 'GREEN',
        features: 'HDB|HDB_WORKER',
        instanceNumber: '10',
        systemReplication: HANASystemReplicationModes.Secondary,
        systemReplicationStatus: 'ACTIVE',
        clusterName: 'hana_cluster_2',
        clusterID: 'fa0d74a3-9240-5d9e-99fa-61c4137acf81',
        hostname: 'vmhdbqas02',
        hostID: 'e0c182db-32ff-55c6-a9eb-2b82dd21bc8b',
      },
    ],
    tag: 'env2',
  },
];

export const availableJavaSystem = {
  sid: 'NWJ',
  type: 'JAVA',
  instances: [
    { hostID: 'a18a203d-4f2f-4d21-b9a5-e300a9c5eeee' },
    { hostID: '544cbc99-c856-4b0a-88cf-e6b8db4606f6' },
    { hostID: 'c0ecf7d1-bdd3-4c29-b768-cfb97efcc585' },
    { hostID: 'e0564d66-be9e-4763-9917-655af1bb4b58' },
    { hostID: 'edf755fd-abc7-4883-af81-8b06d836db37' },
    { hostID: 'f7a8969b-db9e-4162-b82a-d5cfafe1c4e9' },
  ],
};
