import classNames from 'classnames';
import React from 'react';
import HealthSummaryBox from './HealthSummaryBox';

function HealthSummary({
  passing,
  critical,
  warning,
  className,
  onFilterChange,
  activeFilters = {
    passing: false,
    critical: false,
    warning: false,
  },
}) {
  return (
    <div
      className={classNames(
        className,
        'tn-health-container flex flex-row justify-between space-x-4'
      )}
    >
      <HealthSummaryBox
        health="passing"
        value={passing}
        selected={activeFilters.passing}
        onClick={onFilterChange}
      />
      <HealthSummaryBox
        health="warning"
        value={warning}
        selected={activeFilters.warning}
        onClick={onFilterChange}
      />
      <HealthSummaryBox
        health="critical"
        selected={activeFilters.critical}
        onClick={onFilterChange}
        value={critical}
      />
    </div>
  );
}

export default HealthSummary;
