## Contributing

We want to encourage you to contribute to Floki with documentation, code and ideas.
To do so, you can read the existing docs and take a look at our source code through [closed pull requests](https://github.com/philss/floki/pulls?q=is%3Apr+is%3Aclosed).

Before starting, please read our [Code of Conduct](https://github.com/philss/floki/blob/main/CODE_OF_CONDUCT.md) and our [License](https://github.com/philss/floki/blob/main/LICENSE) files.

### Docs

This project uses the [ExDoc](https://github.com/elixir-lang/ex_doc) tool, which generates documentation based on code docs.
Floki uses the [Elixir style](https://hexdocs.pm/elixir/writing-documentation.html) of writing docs.

Documentation is a very important portion of software. We want to always improve our communication using docs.

### Ideas

To contribute with ideas, you can [open issues](https://github.com/philss/floki/issues/new) using Github. Please write a clear description of
what you want to propose, along with a motivation and examples.

This can make the project very rich, even if your proposal is not accepted. It worth the discussion and possible implementations.

### Code

Contributing with code (and documentation) is easy if you already know how to work with Pull Request (PR) on GitHub.
If you don't know yet, it's basically:

1. Fork the project.
2. Clone your fork using the project URL (git or https).
3. Create a new branch to implement your functionality or code. This can be done with the command:
`git checkout -b your-branch-name-here`
4. Make your changes and add a new commit with a clear message saying **why** this change is being made.
5. Push your code with the command: `git push -u origin your-branch-name-here`.
6. Go to your fork page at GitHub.
7. Open a new PR.

Today we only need a one :shipit: (it's the sign of approval) in order to merge a PR. Unfortunately we can't guarantee that all PRs will be merged.
But we can guarantee that all PRs that are not accepted will have an explanation for that.

If you have questions, security issues or suggestions about the project and prefer to talk privately, please send me an email at: philip.sampaio+flokicontributing@gmail.com.

Thank you.
