defmodule Faker.Address.Ru do
  import Faker, only: [sampler: 2]

  @moduledoc """
  Functions for generating addresses in Russian
  """
  @doc """
  Return country.
  https://ru.wikipedia.org/wiki/Список_государств

  ## Examples

      iex> Faker.Address.Ru.country()
      "Белоруссия"
      iex> Faker.Address.Ru.country()
      "Австрия"
      iex> Faker.Address.Ru.country()
      "Ирландия"
      iex> Faker.Address.Ru.country()
      "Тринидад и Тобаго"
  """
  @spec country() :: String.t()
  sampler(:country, [
    "Австралия",
    "Австрия",
    "Азербайджан",
    "Албания",
    "Алжир",
    "Ангола",
    "Андорра",
    "Антигуа и Барбуда",
    "Аргентина",
    "Армения",
    "Афганистан",
    "Багамские Острова",
    "Бангладеш",
    "Барбадос",
    "Бахрейн",
    "Белоруссия",
    "Белиз",
    "Бельгия",
    "Бенин",
    "Болгария",
    "Боливия",
    "Босния и Герцеговина",
    "Ботсвана",
    "Бразилия",
    "Бруней",
    "Буркина-Фасо",
    "Бурунди",
    "Бутан",
    "Вануату",
    "Великобритания",
    "Венгрия",
    "Венесуэла",
    "Восточный Тимор",
    "Вьетнам",
    "Габон",
    "Гаити",
    "Гайана",
    "Гамбия",
    "Гана",
    "Гватемала",
    "Гвинея",
    "Гвинея-Бисау",
    "Германия",
    "Гондурас",
    "Гренада",
    "Греция",
    "Грузия",
    "Дания",
    "Джибути",
    "Доминика",
    "Доминиканская Республика",
    "Египет",
    "Замбия",
    "Зимбабве",
    "Израиль",
    "Индия",
    "Индонезия",
    "Иордания",
    "Ирак",
    "Иран",
    "Ирландия",
    "Исландия",
    "Испания",
    "Италия",
    "Йемен",
    "Кабо-Верде",
    "Казахстан",
    "Камбоджа",
    "Камерун",
    "Канада",
    "Катар",
    "Кения",
    "Кипр",
    "Киргизия",
    "Кирибати",
    "Китай",
    "Колумбия",
    "Коморы",
    "Республика Конго",
    "Демократическая Республика Конго",
    "КНДР",
    "Республика Корея",
    "Коста-Рика",
    "Кот-д'Ивуар",
    "Куба",
    "Кувейт",
    "Лаос",
    "Латвия",
    "Лесото",
    "Либерия",
    "Ливан",
    "Ливия",
    "Литва",
    "Лихтенштейн",
    "Люксембург",
    "Маврикий",
    "Мавритания",
    "Мадагаскар",
    "Малави",
    "Малайзия",
    "Мали",
    "Мальдивы",
    "Мальта",
    "Марокко",
    "Маршалловы Острова",
    "Мексика",
    "Мозамбик",
    "Молдавия",
    "Монако",
    "Монголия",
    "Мьянма",
    "Намибия",
    "Науру",
    "Непал",
    "Нигер",
    "Нигерия",
    "Нидерланды",
    "Никарагуа",
    "Новая Зеландия",
    "Норвегия",
    "ОАЭ",
    "Оман",
    "Пакистан",
    "Палау",
    "Панама",
    "Папуа",
    "Парагвай",
    "Перу",
    "Польша",
    "Португалия",
    "Россия",
    "Руанда",
    "Румыния",
    "Сальвадор",
    "Самоа",
    "Сан-Марино",
    "Сан-Томе и Принсипи",
    "Саудовская Аравия",
    "Северная Македония",
    "Сейшельские Острова",
    "Сенегал",
    "Сент-Винсент и Гренадины",
    "Сент-Китс и Невис",
    "Сент-Люсия",
    "Сербия",
    "Сингапур",
    "Сирия",
    "Словакия",
    "Словения",
    "США",
    "Соломоновы Острова",
    "Сомали",
    "Судан",
    "Суринам",
    "Сьерра-Леоне",
    "Таджикистан",
    "Таиланд",
    "Танзания",
    "Того",
    "Тонга",
    "Тринидад и Тобаго",
    "Тувалу",
    "Тунис",
    "Туркмения",
    "Турция",
    "Уганда",
    "Узбекистан",
    "Украина",
    "Уругвай",
    "Федеративные Штаты Микронезии",
    "Фиджи",
    "Филиппины",
    "Финляндия",
    "Франция",
    "Хорватия",
    "Центральноафриканская Республика",
    "Чад",
    "Черногория",
    "Чехия",
    "Чили",
    "Швейцария",
    "Швеция",
    "Шри-Ланка",
    "Эквадор",
    "Экваториальная Гвинея",
    "Эритрея",
    "Эсватини",
    "Эстония",
    "Эфиопия",
    "ЮАР",
    "Южный Судан",
    "Ямайка",
    "Япония"
  ])

  @doc """
  Return state.
  https://ru.wikipedia.org/wiki/Субъекты_Российской_Федерации

  ## Examples

      iex> Faker.Address.Ru.state()
      "Самарская область"
      iex> Faker.Address.Ru.state()
      "Орловская область"
      iex> Faker.Address.Ru.state()
      "Рязанская область"
      iex> Faker.Address.Ru.state()
      "Волгоградская область"
  """
  @spec state() :: String.t()
  sampler(:state, [
    "Республика Адыгея",
    "Республика Алтай",
    "Республика Башкортостан",
    "Республика Бурятия",
    "Республика Дагестан",
    "Республика Ингушетия",
    "Кабардино-Балкарская Республика",
    "Республика Калмыкия",
    "Карачаево-Черкесская Республика",
    "Республика Карелия",
    "Республика Коми",
    "Республика Марий Эл",
    "Республика Мордовия",
    "Республика Саха",
    "Республика Северная Осетия",
    "Республика Татарстан",
    "Республика Тыва",
    "Удмуртская Республика",
    "Республика Хакасия",
    "Чеченская Республика",
    "Чувашская Республика",
    "Алтайский край",
    "Забайкальский край",
    "Камчатский край",
    "Краснодарский край",
    "Красноярский край",
    "Пермский край",
    "Приморский край",
    "Ставропольский край",
    "Хабаровский край",
    "Амурская область",
    "Архангельская область",
    "Астраханская область",
    "Белгородская область",
    "Брянская область",
    "Владимирская область",
    "Волгоградская область",
    "Вологодская область",
    "Воронежская область",
    "Ивановская область",
    "Иркутская область",
    "Калининградская область",
    "Калужская область",
    "Кемеровская область",
    "Кировская область",
    "Костромская область",
    "Курганская область",
    "Курская область",
    "Ленинградская область",
    "Липецкая область",
    "Магаданская область",
    "Московская область",
    "Мурманская область",
    "Нижегородская область",
    "Новгородская область",
    "Новосибирская область",
    "Омская область",
    "Оренбургская область",
    "Орловская область",
    "Пензенская область",
    "Псковская область",
    "Ростовская область",
    "Рязанская область",
    "Самарская область",
    "Саратовская область",
    "Сахалинская область",
    "Свердловская область",
    "Смоленская область",
    "Тамбовская область",
    "Тверская область",
    "Томская область",
    "Тульская область",
    "Тюменская область",
    "Ульяновская область",
    "Челябинская область",
    "Ярославская область",
    "Москва",
    "Санкт-Петербург",
    "Еврейская АО",
    "Ненецкий АО",
    "Ханты-Мансийский АО",
    "Чукотский АО",
    "Ямало-Ненецкий АО"
  ])
end
