#ident "@(#)rules.man	1.11 18/08/14 "
###########################################################################
# Written 1997-2018 by J. Schilling
###########################################################################
#
# Manual page building rules
#
###########################################################################
# Copyright (c) J. Schilling
###########################################################################
# The contents of this file are subject to the terms of the
# Common Development and Distribution License, Version 1.0 only
# (the "License").  You may not use this file except in compliance
# with the License.
#
# See the file CDDL.Schily.txt in this distribution for details.
# A copy of the CDDL is also available via the Internet at
# http://www.opensource.org/licenses/cddl1.txt
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file CDDL.Schily.txt from this distribution.
###########################################################################
include		$(SRCROOT)/$(RULESDIR)/man-$(MANSTYLE).def
###########################################################################

INSDIR=		$(MANBASE:%=%/)$(MANDIR)/$(MANSECT)
SUBARCHDIR=	/$(MANDIR)
TARGET=		$(TARGETMAN).$(MANSUFFIX)
SRCFILE=	$(MANFILE)

###########################################################################
include		$(SRCROOT)/$(RULESDIR)/rules.htm


###########################################################################
# The rest is copied from rules.loc
###########################################################################
PTARGET=	$(ARCHDIR)/$(TARGET)
###########################################################################
#
# We are doing a copy to $(ARCHDIR) to be able to have platform dependent
# shell files in future.
#
###########################################################################
_INSMODEI=	$(_UNIQ)$(INSMODE)
__INSMODEI=	$(_INSMODEI:$(_UNIQ)=$(INSMODEF))
INSMODEI=	$(__INSMODEI:$(_UNIQ)%=%)

all man:	$(ARCHDIR) $(WAIT) $(PTARGET)

install installman:	$(ARCHDIR) man

installman:	man install

$(PTARGET):	$(SRCFILE)
		$(LOCALIZE) $(SRCFILE) $@

#
# gmake only. Other make implementations use a no-xxx/ prefix.
# gmake calls prerequisites to the right of | as order-only-prerequisites
# and does not evaluate the time stamp from such prerequisites.
#
$(GMAKE_ONLY)$(PTARGET): | $(ARCHDIR)

$(ARCHDIR):
		$(MKDIR) -p $@

###########################################################################
include		$(SRCROOT)/$(RULESDIR)/rules.clr
include		$(SRCROOT)/$(RULESDIR)/rules.ins
include		$(SRCROOT)/$(RULESDIR)/rules.tag
include		$(SRCROOT)/$(RULESDIR)/rules.hlp
include		$(SRCROOT)/$(RULESDIR)/dummy.dep
###########################################################################
