/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class PropertyFile
extends Task {
    private static final String NEWLINE = System.getProperty("line.separator");
    private String m_comment;
    private Properties m_properties;
    private File m_propertyfile;
    private Vector entries = new Vector();
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Properties;

    public void execute() throws BuildException {
        this.checkParameters();
        this.readFile();
        this.executeOperation();
        this.writeFile();
    }

    public Entry createEntry() {
        Entry entry = new Entry();
        this.entries.addElement(entry);
        return entry;
    }

    private void executeOperation() throws BuildException {
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            entry.executeOn(this.m_properties);
        }
    }

    private void readFile() throws BuildException {
        this.m_properties = new Properties();
        try {
            if (this.m_propertyfile.exists()) {
                this.log("Updating property file: " + this.m_propertyfile.getAbsolutePath());
                this.m_properties.load(new BufferedInputStream(new FileInputStream(this.m_propertyfile)));
            } else {
                this.log("Creating new property file: " + this.m_propertyfile.getAbsolutePath());
                FileOutputStream fileOutputStream = new FileOutputStream(this.m_propertyfile.getAbsolutePath());
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new BuildException(iOException.toString());
        }
    }

    private void checkParameters() throws BuildException {
        if (!this.checkParam(this.m_propertyfile)) {
            throw new BuildException("file token must not be null.", this.location);
        }
    }

    public void setFile(File file) {
        this.m_propertyfile = file;
    }

    public void setComment(String string) {
        this.m_comment = string;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFile() throws BuildException {
        BufferedOutputStream bufferedOutputStream = null;
        bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.m_propertyfile));
        Method method = (class$java$util$Properties == null ? (class$java$util$Properties = PropertyFile.class$("java.util.Properties")) : class$java$util$Properties).getMethod("store", class$java$io$OutputStream == null ? (class$java$io$OutputStream = PropertyFile.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$java$lang$String == null ? (class$java$lang$String = PropertyFile.class$("java.lang.String")) : class$java$lang$String);
        method.invoke((Object)this.m_properties, bufferedOutputStream, this.m_comment);
        Object var7_4 = null;
        if (bufferedOutputStream == null) return;
        try {
            bufferedOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (NoSuchMethodException noSuchMethodException) {
                this.m_properties.save(bufferedOutputStream, this.m_comment);
                Object var7_5 = null;
                if (bufferedOutputStream == null) return;
                try {
                    bufferedOutputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                throw new BuildException(throwable, this.location);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new BuildException((Throwable)illegalAccessException, this.location);
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException, this.location);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (bufferedOutputStream == null) throw throwable;
            try {
                bufferedOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private boolean checkParam(String string) {
        return string != null && !string.equals("null");
    }

    private boolean checkParam(File file) {
        return file != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Entry {
        static final String NOW_VALUE_ = "now";
        static final String NULL_VALUE_ = "never";
        private static final int DEFAULT_INT_VALUE = 1;
        private static final GregorianCalendar DEFAULT_DATE_VALUE = new GregorianCalendar();
        private String m_key = null;
        private int m_type = 2;
        private int m_operation = 2;
        private String m_value = "1";
        private String m_default = null;
        private String m_pattern = null;

        public void setKey(String string) {
            this.m_key = string;
        }

        public void setValue(String string) {
            this.m_value = string;
        }

        public void setOperation(Operation operation) {
            int n = Operation.toOperation(operation.getValue());
            if (n == 3) {
                this.m_operation = 2;
                this.setValue(NOW_VALUE_);
            } else if (n == 4) {
                this.m_operation = 2;
                this.setValue(NULL_VALUE_);
            } else {
                this.m_operation = n;
            }
        }

        public void setType(Type type) {
            this.m_type = Type.toType(type.getValue());
        }

        public void setDefault(String string) {
            this.m_default = string;
        }

        public void setPattern(String string) {
            this.m_pattern = string;
        }

        protected void executeOn(Properties properties) throws BuildException {
            block5: {
                this.checkParameters();
                try {
                    if (this.m_type == 0) {
                        this.executeInteger((String)((Hashtable)properties).get(this.m_key));
                        break block5;
                    }
                    if (this.m_type == 1) {
                        this.executeDate((String)((Hashtable)properties).get(this.m_key));
                        break block5;
                    }
                    if (this.m_type == 2) {
                        this.executeString((String)((Hashtable)properties).get(this.m_key));
                        break block5;
                    }
                    throw new BuildException("Unknown operation type: " + this.m_type + "");
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                }
            }
            ((Hashtable)properties).put(this.m_key, this.m_value);
        }

        private void executeDate(String string) throws BuildException {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            if (this.m_pattern == null) {
                this.m_pattern = "yyyy/MM/dd HH:mm";
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.m_pattern);
            if (this.m_value != null) {
                if (NOW_VALUE_.equals(this.m_value.toLowerCase())) {
                    gregorianCalendar.setTime(new Date());
                } else if (NULL_VALUE_.equals(this.m_value.toLowerCase())) {
                    gregorianCalendar = null;
                } else {
                    try {
                        gregorianCalendar.setTime(simpleDateFormat.parse(this.m_value));
                    }
                    catch (Exception exception) {
                        try {
                            int n = Integer.parseInt(this.m_value);
                            gregorianCalendar.clear();
                            gregorianCalendar.set(6, n);
                        }
                        catch (Exception exception2) {
                            gregorianCalendar.clear();
                            gregorianCalendar.set(6, 1);
                        }
                    }
                }
            }
            if (this.m_default != null && NOW_VALUE_.equals(this.m_default.toLowerCase()) && (this.m_operation == 0 || this.m_operation == 1)) {
                string = null;
            }
            if (string != null) {
                try {
                    gregorianCalendar2.setTime(simpleDateFormat.parse(string));
                }
                catch (ParseException parseException) {}
            } else if (this.m_default != null) {
                if (NOW_VALUE_.equals(this.m_default.toLowerCase())) {
                    gregorianCalendar2.setTime(new Date());
                } else if (NULL_VALUE_.equals(this.m_default.toLowerCase())) {
                    gregorianCalendar2 = null;
                } else {
                    try {
                        gregorianCalendar2.setTime(simpleDateFormat.parse(this.m_default));
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            if (this.m_operation == 2) {
                gregorianCalendar2 = gregorianCalendar;
            } else if (this.m_operation == 0) {
                gregorianCalendar2.add(13, gregorianCalendar.get(13));
                gregorianCalendar2.add(12, gregorianCalendar.get(12));
                gregorianCalendar2.add(11, gregorianCalendar.get(11));
                gregorianCalendar2.add(6, gregorianCalendar.get(6));
            } else if (this.m_operation == 1) {
                gregorianCalendar2.add(13, -1 * gregorianCalendar.get(13));
                gregorianCalendar2.add(12, -1 * gregorianCalendar.get(12));
                gregorianCalendar2.add(11, -1 * gregorianCalendar.get(11));
                gregorianCalendar2.add(6, -1 * gregorianCalendar.get(6));
            }
            this.m_value = gregorianCalendar2 != null ? simpleDateFormat.format(gregorianCalendar2.getTime()) : "";
        }

        private void executeInteger(String string) throws BuildException {
            DecimalFormat decimalFormat;
            int n = 0;
            int n2 = 0;
            DecimalFormat decimalFormat2 = decimalFormat = this.m_pattern != null ? new DecimalFormat(this.m_pattern) : new DecimalFormat();
            if (this.m_value != null) {
                try {
                    n = decimalFormat.parse(this.m_value).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (string != null) {
                try {
                    n2 = decimalFormat.parse(string).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ParseException parseException) {}
            } else if (this.m_default != null) {
                try {
                    n2 = decimalFormat.parse(this.m_default).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (this.m_operation == 2) {
                n2 = n;
            } else if (this.m_operation == 0) {
                n2 += n;
            } else if (this.m_operation == 1) {
                n2 -= n;
            }
            this.m_value = decimalFormat.format(n2);
        }

        private void executeString(String string) throws BuildException {
            String string2 = "";
            String string3 = "";
            if (this.m_value != null) {
                string2 = this.m_value;
            }
            if (string != null) {
                string3 = string;
            } else if (this.m_default != null) {
                string3 = this.m_default;
            }
            if (this.m_operation == 2) {
                string3 = string2;
            } else if (this.m_operation == 0) {
                string3 = string3 + string2;
            }
            this.m_value = string3;
        }

        private void checkParameters() throws BuildException {
            if (this.m_type == 2 && this.m_operation == 1) {
                throw new BuildException("- is not suported for string properties (key:" + this.m_key + ")");
            }
            if (this.m_value == null) {
                throw new BuildException("value is mandatory (key:" + this.m_key + ")");
            }
            if (this.m_key == null) {
                throw new BuildException("key is mandatory");
            }
            if (this.m_type == 2 && this.m_pattern != null) {
                throw new BuildException("pattern is not suported for string properties (key:" + this.m_key + ")");
            }
        }

        public static class Type
        extends EnumeratedAttribute {
            public static final int INTEGER_TYPE = 0;
            public static final int DATE_TYPE = 1;
            public static final int STRING_TYPE = 2;

            public String[] getValues() {
                return new String[]{"int", "date", "string"};
            }

            public static int toType(String string) {
                if ("int".equals(string)) {
                    return 0;
                }
                if ("date".equals(string)) {
                    return 1;
                }
                return 2;
            }
        }

        public static class Operation
        extends EnumeratedAttribute {
            public static final int INCREMENT_OPER = 0;
            public static final int DECREMENT_OPER = 1;
            public static final int EQUALS_OPER = 2;
            public static final int NOW_VALUE = 3;
            public static final int NULL_VALUE = 4;

            public String[] getValues() {
                return new String[]{"+", "-", "=", Entry.NOW_VALUE_, Entry.NULL_VALUE_};
            }

            public static int toOperation(String string) {
                if ("+".equals(string)) {
                    return 0;
                }
                if ("-".equals(string)) {
                    return 1;
                }
                if (Entry.NOW_VALUE_.equals(string)) {
                    return 3;
                }
                if (Entry.NULL_VALUE_.equals(string)) {
                    return 4;
                }
                return 2;
            }
        }
    }
}

