Generating schema templates for commands without JSON implementation
====================================================================

All commands without current JSON support share a similar schema template.
To generate these call `generate_unsupported.sh` in this directory (`templates/`).
It creates JSON schema template files in `./` for all commands listed in the 
variable `UNSUPPORTED_COMMANDS` at the top of the script.

As default `generate_unsupported.sh` will refuse to work until the environment variable 
`FORCE` is set to 1 or 2.
This should be prevent inadvertent changes. Therefore to update the schema files run:

```
FORCE=1 ./generate_unsupported.sh 
```

With `FORCE=1` the script will not override existing templates. To do so use `FORCE=2`.

!!! Update `UNSUPPORTED_COMMANDS` first, if the list of supported commands has changed. !!!
!!! See also table below.                                                               !!!

After creating the templates, the schemas can be generated with `build.py` (see next section).


Generating schema files from templates
======================================

All JSON schema files in `../` are generated by the `build.py` script in this directory.
It will load all files of the pattern `saptune*.template` of the current directory 
and render them (jinja2), resolve all references and put them with the suffix `.template.` 
removed into the parent directory.

Existing files will be overwritten!

As default build.py will refuse to work until the environment variable `FORCE` is set to 1.
This should be prevent inadvertent changes. Therefore to update the schema files run:

```
FORCE=1 ./build.py 
```

Jinja (https://jinja.palletsprojects.com/en/3.0.x/) is used as template engine.



Overview about implemented commands and their schema
====================================================

"JSON?"  --> explicit JSON output implemented
"Schema" --> Schema implemented (requires a yes for "JSON?")

| saptune command                     |JSON?|Schema?|
|:------------------------------------|:---:|:-----:|
| invalid saptune command             | yes |  yes  |  
| saptune daemon start	              | no  |  no   |
| saptune daemon status	              | yes |  yes  |
| saptune daemon stop                 | no  |  no   |
| saptune service status              | yes |  yes  |
| saptune service start               | no  |  no   |
| saptune service reload              | no  |  no   |
| saptune service restart             | no  |  no   |
| saptune service stop                | no  |  no   |
| saptune service enable              | no  |  no   |
| saptune service disable             | no  |  no   |
| saptune service enablestart         | no  |  no   |
| saptune service disablestop         | no  |  no   |
| saptune service apply    	          | no  |  no   |
| saptune service revert              | no  |  no   |
| saptune service takeover            | no  |  no   |
| saptune note list                   | yes |  yes  |
| saptune note verify 	              | yes |  yes  |
| saptune note enabled    	          | yes |  yes  |  
| saptune note applied	              | yes |  yes  |
| saptune note apply                  | no  |  no   |
| saptune note simulate               | no  |  no   |
| saptune note customise|customize    | no  |  no   | 
| saptune note create	              | no  |  no   |
| saptune note edit 	              | no  |  no   |
| saptune note show	                  | no  |  no   |
| saptune note revert	              | no  |  no   |
| saptune note delete	              | no  |  no   |
| saptune note rename	              | no  |  no   |
| saptune note refresh	              | no  |  no   |
| saptune note revertall|revert all   |	no  |  no   |
| saptune solution list  	          | yes |  yes  |   
| saptune solution verify	          | yes |  yes  |
| saptune solution enabled	          | yes |  yes  |
| saptune solution applied            | yes |  yes  |
| saptune solution apply	          | no  |  no   |
| saptune solution change	          | no  |  no   |
| saptune solution simulate	          | no  |  no   |
| saptune solution revert             | no  |  no   | 
| saptune solution create	          | no  |  no   |
| saptune solution edit	              | no  |  no   |
| saptune solution delete	          | no  |  no   |
| saptune solution rename	          | no  |  no   |
| saptune staging status	          | no  |  no   |
| saptune staging is-enabled          | no  |  no   |
| saptune staging enable|disable      | no  |  no   |
| saptune staging list	              | no  |  no   |
| saptune staging diff	              | no  |  no   |
| saptune staging analysis	          | no  |  no   |
| saptune staging release             | no  |  no   |
| saptune configure ...               | no  |  no   |
| saptune refresh ...                 | no  |  no   |
| saptune lock remove    	          | no  |  no   |
| saptune status                      | yes |  yes  | 
| saptune check                       | yes |  yes  |
| saptune verify                      | yes |  yes  |
| saptune version           	      | yes |  yes  |
| saptune help   	                  | no  |  no   |

