sys.version_info(major=3, minor=12, micro=0, releaselevel='final', serial=0)

### Timing comparison of `int` functions

| Input type        | builtin (ms)   | fastnumbers (ms)   |
| ----------------: | -------------: | -----------------: |
|  Small Int String | 24.635 ± 1.615 | **13.154 ± 0.493** |
|        Int String | 26.275 ± 2.502 | **15.228 ± 0.310** |
| Medium Int String | 24.221 ± 3.531 | **15.873 ± 0.395** |
|  Large Int String | 28.414 ± 0.798 | **24.264 ± 0.452** |
|               Int | 11.924 ± 0.178 |  **9.711 ± 0.141** |
|             Float | 24.943 ± 0.228 | **24.780 ± 1.587** |

### Timing comparison of `float` functions

| Input type         | builtin (ms)       | fastnumbers (ms)   |
| -----------------: | -----------------: | -----------------: |
|   Small Int String | **10.457 ± 0.628** |   16.129 ± 0.359   |
|         Int String | **11.090 ± 0.226** |   16.848 ± 2.782   |
|  Medium Int String | **12.364 ± 0.083** |   16.428 ± 0.790   |
|   Large Int String |   43.676 ± 1.631   | **21.551 ± 0.425** |
| Small Float String | **10.528 ± 0.201** |   16.285 ± 0.454   |
|       Float String |   47.880 ± 1.731   | **18.320 ± 0.409** |
| Large Float String |   76.427 ± 2.525   | **18.403 ± 0.273** |
|                Int |  **5.369 ± 0.066** |   13.463 ± 0.144   |
|              Float |  **2.827 ± 0.064** |   10.323 ± 0.140   |

### Timing comparison of `int` functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |  234.845 ± 9.790   |  32.030 ± 0.556 | **26.128 ± 0.145** |
|   Small Int String |   26.855 ± 0.536   |  65.617 ± 0.292 | **23.316 ± 0.019** |
|         Int String | **28.137 ± 0.247** |  72.539 ± 1.459 |   30.087 ± 0.632   |
|  Medium Int String |   30.332 ± 0.534   |  81.970 ± 0.891 | **29.387 ± 0.263** |
|   Large Int String | **34.138 ± 0.019** | 103.190 ± 0.230 |   37.392 ± 0.547   |
| Small Float String |  223.572 ± 9.379   |  35.173 ± 0.337 | **25.469 ± 0.345** |
|       Float String |  224.133 ± 3.795   |  41.812 ± 0.018 | **25.797 ± 0.017** |
| Large Float String |  230.232 ± 2.285   |  40.852 ± 0.439 | **25.921 ± 0.167** |
|                Int | **15.191 ± 0.018** | 180.278 ± 1.367 |   20.281 ± 0.357   |
|              Float | **28.719 ± 0.009** | 192.572 ± 2.780 |   36.727 ± 1.367   |

### Timing comparison of `float` functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |  120.907 ± 2.340   |  39.785 ± 0.194 | **28.419 ± 0.371** |
|   Small Int String | **14.034 ± 0.146** |  69.899 ± 0.962 |   29.339 ± 0.026   |
|         Int String | **14.726 ± 0.009** |  73.257 ± 0.455 |   29.822 ± 0.397   |
|  Medium Int String | **16.318 ± 0.201** |  85.362 ± 1.213 |   31.298 ± 0.602   |
|   Large Int String |   49.533 ± 0.939   | 136.248 ± 2.510 | **36.404 ± 0.323** |
| Small Float String | **14.519 ± 0.040** |  67.837 ± 0.175 |   29.951 ± 0.214   |
|       Float String |   51.618 ± 0.241   | 123.078 ± 2.196 | **31.766 ± 0.017** |
| Large Float String |   80.187 ± 1.307   | 161.382 ± 4.170 | **32.154 ± 0.490** |
|                Int |  **8.298 ± 0.025** | 167.923 ± 3.304 |   26.998 ± 0.194   |
|              Float |  **5.953 ± 0.082** | 165.653 ± 2.242 |   21.980 ± 0.332   |

### Timing comparison of `float` (but coerce to `int` if possible) functions with error handling

| Input type         | try/except (ms) | regex (ms)      | fastnumbers (ms)   |
| -----------------: | --------------: | --------------: | -----------------: |
|  Non-number String | 120.177 ± 1.498 |  75.783 ± 2.725 | **29.731 ± 0.435** |
|   Small Int String |  34.998 ± 0.214 |  69.292 ± 0.148 | **26.041 ± 0.020** |
|         Int String |  39.130 ± 0.289 |  74.957 ± 0.634 | **33.089 ± 0.128** |
|  Medium Int String |  45.075 ± 0.176 |  85.845 ± 1.256 | **32.209 ± 0.554** |
|   Large Int String |  89.449 ± 0.394 | 106.398 ± 0.129 | **40.429 ± 0.734** |
| Small Float String |  34.313 ± 0.007 | 103.443 ± 2.124 | **31.254 ± 0.557** |
|       Float String | 100.799 ± 5.157 | 165.850 ± 1.554 | **40.645 ± 0.033** |
| Large Float String | 162.963 ± 0.989 | 205.402 ± 3.933 | **56.570 ± 0.135** |
|                Int |  30.773 ± 0.008 | 176.851 ± 2.585 | **22.354 ± 0.006** |
|              Float |  57.993 ± 0.337 | 176.594 ± 1.236 | **38.204 ± 0.709** |

### Timing comparison of forced `int` functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |  361.626 ± 10.118  |  64.333 ± 1.189 | **30.101 ± 0.529** |
|   Small Int String |   29.752 ± 0.488   |  70.482 ± 2.336 | **26.093 ± 0.471** |
|         Int String | **29.587 ± 0.468** |  70.930 ± 1.134 |   29.800 ± 0.504   |
|  Medium Int String | **28.801 ± 0.012** | 129.203 ± 1.328 |   31.502 ± 3.941   |
|   Large Int String | **34.385 ± 0.399** | 184.889 ± 2.642 |   39.276 ± 0.680   |
| Small Float String |  259.010 ± 2.715   | 111.569 ± 0.560 | **26.114 ± 0.540** |
|       Float String |  324.894 ± 5.008   | 187.371 ± 5.361 | **37.043 ± 0.023** |
| Large Float String |  376.711 ± 4.473   | 237.102 ± 3.476 | **54.052 ± 0.117** |
|                Int | **15.189 ± 0.019** | 179.399 ± 3.085 |   20.190 ± 0.397   |
|              Float | **28.648 ± 0.009** | 197.071 ± 1.072 |   35.610 ± 0.092   |

### Timing comparison of forced `int` functions with error handling and denoising

| Input type         | Python (ms)        | fastnumbers (ms)    |
| -----------------: | -----------------: | ------------------: |
|   Small Int String |  238.793 ± 4.818   |  **30.758 ± 0.113** |
|         Int String |  241.800 ± 6.548   |  **38.092 ± 0.217** |
|  Medium Int String |  249.927 ± 7.704   |  **37.361 ± 0.013** |
|   Large Int String |  273.811 ± 4.946   |  **44.461 ± 0.016** |
| Small Float String |  327.947 ± 3.197   |  **35.026 ± 0.020** |
|       Float String |  367.330 ± 3.054   |  **85.419 ± 1.314** |
| Large Float String |  890.195 ± 12.167  | **175.610 ± 4.288** |
|                Int | **18.923 ± 0.028** |    27.118 ± 0.060   |
|              Float | **60.149 ± 3.197** |   230.257 ± 2.724   |

### Timing comparison to check if value can be converted to `int`

| Input type         | try/except (ms) | regex (ms)     | fastnumbers (ms)   |
| -----------------: | --------------: | -------------: | -----------------: |
|  Non-number String | 234.396 ± 1.807 | 47.227 ± 0.162 | **11.899 ± 0.057** |
|   Small Int String |  28.570 ± 0.090 | 61.325 ± 3.091 | **13.612 ± 0.173** |
|         Int String |  33.995 ± 2.765 | 69.057 ± 1.706 | **13.713 ± 0.206** |
|  Medium Int String |  32.528 ± 0.051 | 73.625 ± 0.121 | **12.925 ± 0.015** |
|   Large Int String |  37.657 ± 2.669 | 88.492 ± 0.315 | **12.567 ± 0.074** |
| Small Float String | 220.666 ± 1.905 | 52.133 ± 0.021 | **13.335 ± 0.031** |
|       Float String | 226.589 ± 2.125 | 59.331 ± 0.201 | **14.370 ± 0.013** |
| Large Float String | 233.543 ± 4.500 | 60.131 ± 1.853 | **14.470 ± 0.007** |
|                Int |  17.977 ± 0.110 | 17.860 ± 0.026 | **10.760 ± 0.016** |
|              Float |  31.153 ± 0.452 | 14.536 ± 0.005 | **10.426 ± 0.052** |

### Timing comparison to check if value can be converted to `float`

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |  118.843 ± 0.423   |  54.451 ± 0.186 | **13.937 ± 0.207** |
|   Small Int String |   16.787 ± 0.102   |  72.212 ± 1.125 | **13.877 ± 0.181** |
|         Int String |   17.200 ± 0.240   |  74.952 ± 0.182 | **13.685 ± 0.095** |
|  Medium Int String |   18.269 ± 0.133   |  84.894 ± 2.083 | **15.619 ± 1.972** |
|   Large Int String |   53.857 ± 1.116   | 102.449 ± 1.921 | **14.441 ± 1.028** |
| Small Float String |   16.595 ± 0.006   |  70.805 ± 1.416 | **14.999 ± 0.262** |
|       Float String |   53.554 ± 0.015   |  86.999 ± 0.282 | **15.746 ± 0.020** |
| Large Float String |   83.538 ± 0.135   |  95.548 ± 1.228 | **15.819 ± 0.020** |
|                Int | **10.576 ± 0.108** |  17.378 ± 0.013 |   11.717 ± 0.018   |
|              Float |  **7.553 ± 0.041** |  14.692 ± 0.215 |   12.354 ± 0.008   |

### Timing comparison to check if value can be converted to `float` or `int`

| Input type         | try/except (ms)   | regex (ms)      | fastnumbers (ms)   |
| -----------------: | ----------------: | --------------: | -----------------: |
|  Non-number String | 119.408 ± 3.520   |  56.814 ± 0.243 | **13.422 ± 0.191** |
|   Small Int String |  14.879 ± 0.184   |  75.765 ± 1.496 | **12.884 ± 0.026** |
|         Int String |  14.983 ± 0.020   |  77.963 ± 0.696 | **13.394 ± 0.062** |
|  Medium Int String |  16.768 ± 0.514   |  88.410 ± 0.835 | **14.017 ± 0.194** |
|   Large Int String |  51.142 ± 0.296   | 106.822 ± 0.585 | **13.516 ± 0.264** |
| Small Float String |  14.823 ± 0.104   |  72.550 ± 0.437 | **14.253 ± 0.011** |
|       Float String |  51.736 ± 0.012   |  89.724 ± 0.218 | **15.257 ± 0.018** |
| Large Float String |  81.507 ± 0.122   |  97.461 ± 0.348 | **15.089 ± 0.277** |
|                Int | **8.509 ± 0.070** |  15.920 ± 0.023 |   10.879 ± 0.093   |
|              Float | **5.991 ± 0.141** |  13.468 ± 0.028 |   11.178 ± 0.026   |

### Timing comparison to check if value can be coerced losslessly to `int`

| Input type         | try/except (ms) | regex (ms)      | fastnumbers (ms)   |
| -----------------: | --------------: | --------------: | -----------------: |
|  Non-number String | 362.617 ± 9.047 |  65.061 ± 0.714 | **12.042 ± 0.280** |
|   Small Int String |  45.274 ± 0.868 |  45.014 ± 0.264 | **12.991 ± 0.264** |
|         Int String |  47.882 ± 0.988 |  46.900 ± 0.663 | **12.527 ± 0.131** |
|  Medium Int String |  53.543 ± 0.349 |  54.187 ± 0.459 | **12.340 ± 0.058** |
|   Large Int String | 104.963 ± 2.130 |  71.394 ± 0.140 | **12.326 ± 0.045** |
| Small Float String | 246.515 ± 2.137 |  99.012 ± 0.097 | **13.266 ± 0.173** |
|       Float String | 301.467 ± 4.901 | 159.821 ± 2.570 | **14.376 ± 0.062** |
| Large Float String | 341.923 ± 5.082 | 198.709 ± 2.730 | **16.297 ± 4.180** |
|                Int |  26.847 ± 0.014 | 183.745 ± 0.186 | **10.428 ± 0.045** |
|              Float |  59.639 ± 1.208 | 235.879 ± 6.727 | **10.537 ± 0.055** |

### Timing comparison of `map` option vs. iterating over `try_float` for a 50 element list

| Input type         | [try_float(x) for x in iterable] (ms) | list(map(try_float, iterable)) (ms) | list(try_float(iterable, map=True)) (ms) | try_float(iterable, map=list) (ms) |
| -----------------: | ------------------------------------: | ----------------------------------: | ---------------------------------------: | ---------------------------------: |
|  Non-number String |                     1524.104 ± 34.525 |                   1619.076 ± 11.811 |                         662.028 ± 5.512  |               **570.685 ± 7.025**  |
|   Small Int String |                     1576.737 ± 4.754  |                   1683.317 ± 93.867 |                         680.886 ± 12.552 |               **572.546 ± 12.634** |
|         Int String |                     1593.893 ± 18.140 |                   1573.295 ± 79.725 |                         627.236 ± 6.802  |               **547.711 ± 4.216**  |
|  Medium Int String |                     1467.810 ± 24.621 |                   1539.761 ± 8.996  |                         651.809 ± 4.483  |               **562.207 ± 6.680**  |
|   Large Int String |                     1789.221 ± 39.664 |                   1867.075 ± 13.840 |                         917.501 ± 4.393  |               **831.091 ± 5.779**  |
| Small Float String |                     1523.855 ± 6.167  |                   1662.047 ± 17.450 |                         704.741 ± 13.204 |               **604.618 ± 7.060**  |
|       Float String |                     1673.528 ± 28.246 |                   1745.992 ± 14.415 |                         790.421 ± 7.136  |               **690.652 ± 4.371**  |
| Large Float String |                     1738.715 ± 63.422 |                   1764.399 ± 11.072 |                         799.188 ± 11.476 |               **644.781 ± 7.359**  |
|                Int |                     1290.682 ± 5.042  |                   1345.851 ± 3.199  |                         513.471 ± 2.576  |               **420.010 ± 2.399**  |
|              Float |                     1127.292 ± 16.645 |                   1226.058 ± 8.238  |                         378.733 ± 1.439  |               **304.793 ± 2.877**  |

### Timing comparison of `try_array` vs. `map` option for a 50 element list to a numpy array

| Input type         | np.array(try_float(iterable, map=True)) (ms) | try_array(iterable) (ms) | try_array(iterable, output) (ms) |
| -----------------: | -------------------------------------------: | -----------------------: | -------------------------------: |
|   Small Int String |                             855.609 ± 8.659  |          343.081 ± 6.371 |             **324.078 ± 2.348**  |
|         Int String |                             950.831 ± 81.819 |          368.905 ± 6.318 |             **340.684 ± 3.316**  |
|  Medium Int String |                             922.925 ± 4.761  |          382.501 ± 3.953 |             **365.910 ± 11.836** |
|   Large Int String |                            1181.628 ± 6.922  |          596.607 ± 4.288 |             **572.411 ± 6.948**  |
| Small Float String |                             932.115 ± 6.361  |          379.504 ± 3.303 |             **352.595 ± 1.679**  |
|       Float String |                            1028.312 ± 8.358  |          456.616 ± 2.946 |             **432.736 ± 2.315**  |
| Large Float String |                            1034.977 ± 6.418  |          470.888 ± 1.473 |             **446.550 ± 0.928**  |
|                Int |                             811.945 ± 9.017  |          472.875 ± 2.620 |             **448.015 ± 6.498**  |
|              Float |                             659.352 ± 9.414  |          299.986 ± 4.960 |             **273.487 ± 0.411**  |

