Algorithms supported
====================

This page lists all quantum-safe algorithms supported by oqs-provider.

Some algorithms by default may not be enabled for use in the master code-generator template file.

As standardization for these algorithms within TLS is not done, all TLS code points/IDs can be changed from their default values to values set by environment variables. This facilitates interoperability testing with TLS1.3 implementations that use different IDs.

The following list of algorithms may change when loading oqsprovider (version >= 0.9.0) with OpenSSL (version >= 3.5.0); please see [README.md](README.md#using-with-openssl-3.5.0).

# Code points / algorithm IDs

<!--- OQS_TEMPLATE_FRAGMENT_IDS_START -->
|Algorithm name | default ID | enabled | environment variable |
|---------------|:----------:|:-------:|----------------------|
| frodo640aes | 65024 | Yes | OQS_CODEPOINT_FRODO640AES |
| p256_frodo640aes | 65025 | Yes | OQS_CODEPOINT_P256_FRODO640AES |
| x25519_frodo640aes | 65026 | Yes | OQS_CODEPOINT_X25519_FRODO640AES |
| frodo640shake | 65027 | Yes | OQS_CODEPOINT_FRODO640SHAKE |
| p256_frodo640shake | 65028 | Yes | OQS_CODEPOINT_P256_FRODO640SHAKE |
| x25519_frodo640shake | 65029 | Yes | OQS_CODEPOINT_X25519_FRODO640SHAKE |
| frodo976aes | 65030 | Yes | OQS_CODEPOINT_FRODO976AES |
| p384_frodo976aes | 65031 | Yes | OQS_CODEPOINT_P384_FRODO976AES |
| x448_frodo976aes | 65032 | Yes | OQS_CODEPOINT_X448_FRODO976AES |
| frodo976shake | 65033 | Yes | OQS_CODEPOINT_FRODO976SHAKE |
| p384_frodo976shake | 65034 | Yes | OQS_CODEPOINT_P384_FRODO976SHAKE |
| x448_frodo976shake | 65035 | Yes | OQS_CODEPOINT_X448_FRODO976SHAKE |
| frodo1344aes | 65036 | Yes | OQS_CODEPOINT_FRODO1344AES |
| p521_frodo1344aes | 65037 | Yes | OQS_CODEPOINT_P521_FRODO1344AES |
| frodo1344shake | 65038 | Yes | OQS_CODEPOINT_FRODO1344SHAKE |
| p521_frodo1344shake | 65039 | Yes | OQS_CODEPOINT_P521_FRODO1344SHAKE |
| mlkem512 | 512 | Yes | OQS_CODEPOINT_MLKEM512 |
| p256_mlkem512 | 0x2F4B | Yes | OQS_CODEPOINT_P256_MLKEM512 |
| x25519_mlkem512 | 0x2FB6 | Yes | OQS_CODEPOINT_X25519_MLKEM512 |
| mlkem768 | 513 | Yes | OQS_CODEPOINT_MLKEM768 |
| p384_mlkem768 | 0x2F4C | Yes | OQS_CODEPOINT_P384_MLKEM768 |
| x448_mlkem768 | 0x2FB7 | Yes | OQS_CODEPOINT_X448_MLKEM768 |
| X25519MLKEM768 | 0x11ec | Yes | OQS_CODEPOINT_X25519MLKEM768 |
| SecP256r1MLKEM768 | 0x11eb | Yes | OQS_CODEPOINT_SECP256R1MLKEM768 |
| mlkem1024 | 514 | Yes | OQS_CODEPOINT_MLKEM1024 |
| p521_mlkem1024 | 0x2F4D | Yes | OQS_CODEPOINT_P521_MLKEM1024 |
| SecP384r1MLKEM1024 | 0x11ED | Yes | OQS_CODEPOINT_SECP384R1MLKEM1024 |
| bikel1 | 65040 | Yes | OQS_CODEPOINT_BIKEL1 |
| p256_bikel1 | 65041 | Yes | OQS_CODEPOINT_P256_BIKEL1 |
| x25519_bikel1 | 65042 | Yes | OQS_CODEPOINT_X25519_BIKEL1 |
| bikel3 | 65043 | Yes | OQS_CODEPOINT_BIKEL3 |
| p384_bikel3 | 65044 | Yes | OQS_CODEPOINT_P384_BIKEL3 |
| x448_bikel3 | 65045 | Yes | OQS_CODEPOINT_X448_BIKEL3 |
| bikel5 | 65046 | Yes | OQS_CODEPOINT_BIKEL5 |
| p521_bikel5 | 65047 | Yes | OQS_CODEPOINT_P521_BIKEL5 |
| mldsa44 | 0x0904 |Yes| OQS_CODEPOINT_MLDSA44
| p256_mldsa44 | 0xff06 |Yes| OQS_CODEPOINT_P256_MLDSA44
| rsa3072_mldsa44 | 0xff07 |Yes| OQS_CODEPOINT_RSA3072_MLDSA44
| mldsa44_pss2048 | 0x090f |Yes| OQS_CODEPOINT_MLDSA44_pss2048
| mldsa44_rsa2048 | 0x090c |Yes| OQS_CODEPOINT_MLDSA44_rsa2048
| mldsa44_ed25519 | 0x090a |Yes| OQS_CODEPOINT_MLDSA44_ed25519
| mldsa44_p256 | 0x0907 |Yes| OQS_CODEPOINT_MLDSA44_p256
| mldsa44_bp256 | 0xfee5 |Yes| OQS_CODEPOINT_MLDSA44_bp256
| mldsa65 | 0x0905 |Yes| OQS_CODEPOINT_MLDSA65
| p384_mldsa65 | 0xff08 |Yes| OQS_CODEPOINT_P384_MLDSA65
| mldsa65_pss3072 | 0x0910 |Yes| OQS_CODEPOINT_MLDSA65_pss3072
| mldsa65_rsa3072 | 0x090d |Yes| OQS_CODEPOINT_MLDSA65_rsa3072
| mldsa65_p256 | 0x0908 |Yes| OQS_CODEPOINT_MLDSA65_p256
| mldsa65_bp256 | 0xfee9 |Yes| OQS_CODEPOINT_MLDSA65_bp256
| mldsa65_ed25519 | 0x090b |Yes| OQS_CODEPOINT_MLDSA65_ed25519
| mldsa87 | 0x0906 |Yes| OQS_CODEPOINT_MLDSA87
| p521_mldsa87 | 0xff09 |Yes| OQS_CODEPOINT_P521_MLDSA87
| mldsa87_p384 | 0x0909 |Yes| OQS_CODEPOINT_MLDSA87_p384
| mldsa87_bp384 | 0xfeec |Yes| OQS_CODEPOINT_MLDSA87_bp384
| mldsa87_ed448 | 0x0912 |Yes| OQS_CODEPOINT_MLDSA87_ed448
| falcon512 | 0xfed7 |Yes| OQS_CODEPOINT_FALCON512
| p256_falcon512 | 0xfed8 |Yes| OQS_CODEPOINT_P256_FALCON512
| rsa3072_falcon512 | 0xfed9 |Yes| OQS_CODEPOINT_RSA3072_FALCON512
| falconpadded512 | 0xfedc |Yes| OQS_CODEPOINT_FALCONPADDED512
| p256_falconpadded512 | 0xfedd |Yes| OQS_CODEPOINT_P256_FALCONPADDED512
| rsa3072_falconpadded512 | 0xfede |Yes| OQS_CODEPOINT_RSA3072_FALCONPADDED512
| falcon1024 | 0xfeda |Yes| OQS_CODEPOINT_FALCON1024
| p521_falcon1024 | 0xfedb |Yes| OQS_CODEPOINT_P521_FALCON1024
| falconpadded1024 | 0xfedf |Yes| OQS_CODEPOINT_FALCONPADDED1024
| p521_falconpadded1024 | 0xfee0 |Yes| OQS_CODEPOINT_P521_FALCONPADDED1024
| sphincssha2128fsimple | 0xfeb3 |Yes| OQS_CODEPOINT_SPHINCSSHA2128FSIMPLE
| p256_sphincssha2128fsimple | 0xfeb4 |Yes| OQS_CODEPOINT_P256_SPHINCSSHA2128FSIMPLE
| rsa3072_sphincssha2128fsimple | 0xfeb5 |Yes| OQS_CODEPOINT_RSA3072_SPHINCSSHA2128FSIMPLE
| sphincssha2128ssimple | 0xfeb6 |Yes| OQS_CODEPOINT_SPHINCSSHA2128SSIMPLE
| p256_sphincssha2128ssimple | 0xfeb7 |Yes| OQS_CODEPOINT_P256_SPHINCSSHA2128SSIMPLE
| rsa3072_sphincssha2128ssimple | 0xfeb8 |Yes| OQS_CODEPOINT_RSA3072_SPHINCSSHA2128SSIMPLE
| sphincssha2192fsimple | 0xfeb9 |Yes| OQS_CODEPOINT_SPHINCSSHA2192FSIMPLE
| p384_sphincssha2192fsimple | 0xfeba |Yes| OQS_CODEPOINT_P384_SPHINCSSHA2192FSIMPLE
| sphincssha2192ssimple | 0xfebb |No| OQS_CODEPOINT_SPHINCSSHA2192SSIMPLE
| p384_sphincssha2192ssimple | 0xfebc |No| OQS_CODEPOINT_P384_SPHINCSSHA2192SSIMPLE
| sphincssha2256fsimple | 0xfebd |No| OQS_CODEPOINT_SPHINCSSHA2256FSIMPLE
| p521_sphincssha2256fsimple | 0xfebe |No| OQS_CODEPOINT_P521_SPHINCSSHA2256FSIMPLE
| sphincssha2256ssimple | 0xfec0 |No| OQS_CODEPOINT_SPHINCSSHA2256SSIMPLE
| p521_sphincssha2256ssimple | 0xfec1 |No| OQS_CODEPOINT_P521_SPHINCSSHA2256SSIMPLE
| sphincsshake128fsimple | 0xfec2 |Yes| OQS_CODEPOINT_SPHINCSSHAKE128FSIMPLE
| p256_sphincsshake128fsimple | 0xfec3 |Yes| OQS_CODEPOINT_P256_SPHINCSSHAKE128FSIMPLE
| rsa3072_sphincsshake128fsimple | 0xfec4 |Yes| OQS_CODEPOINT_RSA3072_SPHINCSSHAKE128FSIMPLE
| sphincsshake128ssimple | 0xfec5 |No| OQS_CODEPOINT_SPHINCSSHAKE128SSIMPLE
| p256_sphincsshake128ssimple | 0xfec6 |No| OQS_CODEPOINT_P256_SPHINCSSHAKE128SSIMPLE
| rsa3072_sphincsshake128ssimple | 0xfec7 |No| OQS_CODEPOINT_RSA3072_SPHINCSSHAKE128SSIMPLE
| sphincsshake192fsimple | 0xfec8 |No| OQS_CODEPOINT_SPHINCSSHAKE192FSIMPLE
| p384_sphincsshake192fsimple | 0xfec9 |No| OQS_CODEPOINT_P384_SPHINCSSHAKE192FSIMPLE
| sphincsshake192ssimple | 0xfeca |No| OQS_CODEPOINT_SPHINCSSHAKE192SSIMPLE
| p384_sphincsshake192ssimple | 0xfecb |No| OQS_CODEPOINT_P384_SPHINCSSHAKE192SSIMPLE
| sphincsshake256fsimple | 0xfecc |No| OQS_CODEPOINT_SPHINCSSHAKE256FSIMPLE
| p521_sphincsshake256fsimple | 0xfecd |No| OQS_CODEPOINT_P521_SPHINCSSHAKE256FSIMPLE
| sphincsshake256ssimple | 0xfece |No| OQS_CODEPOINT_SPHINCSSHAKE256SSIMPLE
| p521_sphincsshake256ssimple | 0xfecf |No| OQS_CODEPOINT_P521_SPHINCSSHAKE256SSIMPLE
| mayo1 | 0xff32 |Yes| OQS_CODEPOINT_MAYO1
| p256_mayo1 | 0xff36 |Yes| OQS_CODEPOINT_P256_MAYO1
| mayo2 | 0xff33 |Yes| OQS_CODEPOINT_MAYO2
| p256_mayo2 | 0xff37 |Yes| OQS_CODEPOINT_P256_MAYO2
| mayo3 | 0xff34 |Yes| OQS_CODEPOINT_MAYO3
| p384_mayo3 | 0xff38 |Yes| OQS_CODEPOINT_P384_MAYO3
| mayo5 | 0xff35 |Yes| OQS_CODEPOINT_MAYO5
| p521_mayo5 | 0xff39 |Yes| OQS_CODEPOINT_P521_MAYO5
| CROSSrsdp128balanced | 0xff22 |Yes| OQS_CODEPOINT_CROSSRSDP128BALANCED
| CROSSrsdp128fast | 0xff23 |No| OQS_CODEPOINT_CROSSRSDP128FAST
| CROSSrsdp128small | 0xff24 |No| OQS_CODEPOINT_CROSSRSDP128SMALL
| CROSSrsdp192balanced | 0xff25 |No| OQS_CODEPOINT_CROSSRSDP192BALANCED
| CROSSrsdp192fast | 0xff26 |No| OQS_CODEPOINT_CROSSRSDP192FAST
| CROSSrsdp192small | 0xff27 |No| OQS_CODEPOINT_CROSSRSDP192SMALL
| CROSSrsdp256small | 0xff28 |No| OQS_CODEPOINT_CROSSRSDP256SMALL
| CROSSrsdpg128balanced | 0xff29 |No| OQS_CODEPOINT_CROSSRSDPG128BALANCED
| CROSSrsdpg128fast | 0xff2a |No| OQS_CODEPOINT_CROSSRSDPG128FAST
| CROSSrsdpg128small | 0xff2b |No| OQS_CODEPOINT_CROSSRSDPG128SMALL
| CROSSrsdpg192balanced | 0xff2c |No| OQS_CODEPOINT_CROSSRSDPG192BALANCED
| CROSSrsdpg192fast | 0xff2d |No| OQS_CODEPOINT_CROSSRSDPG192FAST
| CROSSrsdpg192small | 0xff2e |No| OQS_CODEPOINT_CROSSRSDPG192SMALL
| CROSSrsdpg256balanced | 0xff2f |No| OQS_CODEPOINT_CROSSRSDPG256BALANCED
| CROSSrsdpg256fast | 0xff30 |No| OQS_CODEPOINT_CROSSRSDPG256FAST
| CROSSrsdpg256small | 0xff31 |No| OQS_CODEPOINT_CROSSRSDPG256SMALL
| OV_Is | 0xff0a |No| OQS_CODEPOINT_OV_IS
| p256_OV_Is | 0xff16 |No| OQS_CODEPOINT_P256_OV_IS
| OV_Ip | 0xff0b |No| OQS_CODEPOINT_OV_IP
| p256_OV_Ip | 0xff17 |No| OQS_CODEPOINT_P256_OV_IP
| OV_III | 0xff0c |No| OQS_CODEPOINT_OV_III
| p384_OV_III | 0xff18 |No| OQS_CODEPOINT_P384_OV_III
| OV_V | 0xff0d |No| OQS_CODEPOINT_OV_V
| p521_OV_V | 0xff19 |No| OQS_CODEPOINT_P521_OV_V
| OV_Is_pkc | 0xff0e |Yes| OQS_CODEPOINT_OV_IS_PKC
| p256_OV_Is_pkc | 0xff1a |Yes| OQS_CODEPOINT_P256_OV_IS_PKC
| OV_Ip_pkc | 0xff0f |Yes| OQS_CODEPOINT_OV_IP_PKC
| p256_OV_Ip_pkc | 0xff1b |Yes| OQS_CODEPOINT_P256_OV_IP_PKC
| OV_III_pkc | 0xff10 |No| OQS_CODEPOINT_OV_III_PKC
| p384_OV_III_pkc | 0xff1c |No| OQS_CODEPOINT_P384_OV_III_PKC
| OV_V_pkc | 0xff11 |No| OQS_CODEPOINT_OV_V_PKC
| p521_OV_V_pkc | 0xff1d |No| OQS_CODEPOINT_P521_OV_V_PKC
| OV_Is_pkc_skc | 0xff12 |Yes| OQS_CODEPOINT_OV_IS_PKC_SKC
| p256_OV_Is_pkc_skc | 0xff1e |Yes| OQS_CODEPOINT_P256_OV_IS_PKC_SKC
| OV_Ip_pkc_skc | 0xff13 |Yes| OQS_CODEPOINT_OV_IP_PKC_SKC
| p256_OV_Ip_pkc_skc | 0xff1f |Yes| OQS_CODEPOINT_P256_OV_IP_PKC_SKC
| OV_III_pkc_skc | 0xff14 |No| OQS_CODEPOINT_OV_III_PKC_SKC
| p384_OV_III_pkc_skc | 0xff20 |No| OQS_CODEPOINT_P384_OV_III_PKC_SKC
| OV_V_pkc_skc | 0xff15 |No| OQS_CODEPOINT_OV_V_PKC_SKC
| p521_OV_V_pkc_skc | 0xff21 |No| OQS_CODEPOINT_P521_OV_V_PKC_SKC
<!--- OQS_TEMPLATE_FRAGMENT_IDS_END -->

Changing code points
--------------------

In order to dynamically change the code point of any one algorithm, the respective
environment variable listed above has to be set to the `INT`eger value of the
desired code point. For example, as Cloudflare has chosen `0xfe30` as the code
point for their hybrid X25519_kyber512 implementation, the following command
can be used to successfully confirm interoperability between the oqs-provider
and the Cloudflare infrastructure using this hybrid classic/quantum-safe algorithm:

```
OQS_CODEPOINT_X25519_KYBER512=65072  ./openssl/apps/openssl s_client -groups x25519_kyber512 -connect cloudflare.com:443 -provider-path _build/oqsprov -provider oqsprovider -provider default
```

# OIDs

Along the same lines as the code points, X.509 OIDs may be subject to change
prior to final standardization. The environment variables below permit
adapting the OIDs of all supported signature algorithms as per the table below.
OIDs denoted with NULL are not maintained and may lead to errors in code
execution. Anyone interested in using an algorithm with such designation is
requested to contribute to the maintenance of these OIDs along the lines
discussed in https://github.com/open-quantum-safe/oqs-provider/issues/351.

<!--- OQS_TEMPLATE_FRAGMENT_OIDS_START -->
|Algorithm name |    default OID    | enabled | environment variable |
|---------------|:-----------------:|:-------:|----------------------|
| mldsa44 | 2.16.840.1.101.3.4.3.17 |Yes| OQS_OID_MLDSA44
| p256_mldsa44 | 1.3.9999.7.5 |Yes| OQS_OID_P256_MLDSA44
| rsa3072_mldsa44 | 1.3.9999.7.6 |Yes| OQS_OID_RSA3072_MLDSA44
| mldsa44_pss2048 | 2.16.840.1.114027.80.8.1.1 |Yes| OQS_OID_MLDSA44_pss2048
| mldsa44_rsa2048 | 2.16.840.1.114027.80.8.1.2 |Yes| OQS_OID_MLDSA44_rsa2048
| mldsa44_ed25519 | 2.16.840.1.114027.80.8.1.3 |Yes| OQS_OID_MLDSA44_ed25519
| mldsa44_p256 | 2.16.840.1.114027.80.8.1.4 |Yes| OQS_OID_MLDSA44_p256
| mldsa44_bp256 | 2.16.840.1.114027.80.8.1.5 |Yes| OQS_OID_MLDSA44_bp256
| mldsa65 | 2.16.840.1.101.3.4.3.18 |Yes| OQS_OID_MLDSA65
| p384_mldsa65 | 1.3.9999.7.7 |Yes| OQS_OID_P384_MLDSA65
| mldsa65_pss3072 | 2.16.840.1.114027.80.8.1.6 |Yes| OQS_OID_MLDSA65_pss3072
| mldsa65_rsa3072 | 2.16.840.1.114027.80.8.1.7 |Yes| OQS_OID_MLDSA65_rsa3072
| mldsa65_p256 | 2.16.840.1.114027.80.8.1.8 |Yes| OQS_OID_MLDSA65_p256
| mldsa65_bp256 | 2.16.840.1.114027.80.8.1.9 |Yes| OQS_OID_MLDSA65_bp256
| mldsa65_ed25519 | 2.16.840.1.114027.80.8.1.10 |Yes| OQS_OID_MLDSA65_ed25519
| mldsa87 | 2.16.840.1.101.3.4.3.19 |Yes| OQS_OID_MLDSA87
| p521_mldsa87 | 1.3.9999.7.8 |Yes| OQS_OID_P521_MLDSA87
| mldsa87_p384 | 2.16.840.1.114027.80.8.1.11 |Yes| OQS_OID_MLDSA87_p384
| mldsa87_bp384 | 2.16.840.1.114027.80.8.1.12 |Yes| OQS_OID_MLDSA87_bp384
| mldsa87_ed448 | 2.16.840.1.114027.80.8.1.13 |Yes| OQS_OID_MLDSA87_ed448
| falcon512 | 1.3.9999.3.11 |Yes| OQS_OID_FALCON512
| p256_falcon512 | 1.3.9999.3.12 |Yes| OQS_OID_P256_FALCON512
| rsa3072_falcon512 | 1.3.9999.3.13 |Yes| OQS_OID_RSA3072_FALCON512
| falconpadded512 | 1.3.9999.3.16 |Yes| OQS_OID_FALCONPADDED512
| p256_falconpadded512 | 1.3.9999.3.17 |Yes| OQS_OID_P256_FALCONPADDED512
| rsa3072_falconpadded512 | 1.3.9999.3.18 |Yes| OQS_OID_RSA3072_FALCONPADDED512
| falcon1024 | 1.3.9999.3.14 |Yes| OQS_OID_FALCON1024
| p521_falcon1024 | 1.3.9999.3.15 |Yes| OQS_OID_P521_FALCON1024
| falconpadded1024 | 1.3.9999.3.19 |Yes| OQS_OID_FALCONPADDED1024
| p521_falconpadded1024 | 1.3.9999.3.20 |Yes| OQS_OID_P521_FALCONPADDED1024
| sphincssha2128fsimple | 1.3.9999.6.4.13 |Yes| OQS_OID_SPHINCSSHA2128FSIMPLE
| p256_sphincssha2128fsimple | 1.3.9999.6.4.14 |Yes| OQS_OID_P256_SPHINCSSHA2128FSIMPLE
| rsa3072_sphincssha2128fsimple | 1.3.9999.6.4.15 |Yes| OQS_OID_RSA3072_SPHINCSSHA2128FSIMPLE
| sphincssha2128ssimple | 1.3.9999.6.4.16 |Yes| OQS_OID_SPHINCSSHA2128SSIMPLE
| p256_sphincssha2128ssimple | 1.3.9999.6.4.17 |Yes| OQS_OID_P256_SPHINCSSHA2128SSIMPLE
| rsa3072_sphincssha2128ssimple | 1.3.9999.6.4.18 |Yes| OQS_OID_RSA3072_SPHINCSSHA2128SSIMPLE
| sphincssha2192fsimple | 1.3.9999.6.5.10 |Yes| OQS_OID_SPHINCSSHA2192FSIMPLE
| p384_sphincssha2192fsimple | 1.3.9999.6.5.11 |Yes| OQS_OID_P384_SPHINCSSHA2192FSIMPLE
| sphincssha2192ssimple | 1.3.9999.6.5.12 |No| OQS_OID_SPHINCSSHA2192SSIMPLE
| p384_sphincssha2192ssimple | 1.3.9999.6.5.13 |No| OQS_OID_P384_SPHINCSSHA2192SSIMPLE
| sphincssha2256fsimple | 1.3.9999.6.6.10 |No| OQS_OID_SPHINCSSHA2256FSIMPLE
| p521_sphincssha2256fsimple | 1.3.9999.6.6.11 |No| OQS_OID_P521_SPHINCSSHA2256FSIMPLE
| sphincssha2256ssimple | 1.3.9999.6.6.12 |No| OQS_OID_SPHINCSSHA2256SSIMPLE
| p521_sphincssha2256ssimple | 1.3.9999.6.6.13 |No| OQS_OID_P521_SPHINCSSHA2256SSIMPLE
| sphincsshake128fsimple | 1.3.9999.6.7.13 |Yes| OQS_OID_SPHINCSSHAKE128FSIMPLE
| p256_sphincsshake128fsimple | 1.3.9999.6.7.14 |Yes| OQS_OID_P256_SPHINCSSHAKE128FSIMPLE
| rsa3072_sphincsshake128fsimple | 1.3.9999.6.7.15 |Yes| OQS_OID_RSA3072_SPHINCSSHAKE128FSIMPLE
| sphincsshake128ssimple | 1.3.9999.6.7.16 |No| OQS_OID_SPHINCSSHAKE128SSIMPLE
| p256_sphincsshake128ssimple | 1.3.9999.6.7.17 |No| OQS_OID_P256_SPHINCSSHAKE128SSIMPLE
| rsa3072_sphincsshake128ssimple | 1.3.9999.6.7.18 |No| OQS_OID_RSA3072_SPHINCSSHAKE128SSIMPLE
| sphincsshake192fsimple | 1.3.9999.6.8.10 |No| OQS_OID_SPHINCSSHAKE192FSIMPLE
| p384_sphincsshake192fsimple | 1.3.9999.6.8.11 |No| OQS_OID_P384_SPHINCSSHAKE192FSIMPLE
| sphincsshake192ssimple | 1.3.9999.6.8.12 |No| OQS_OID_SPHINCSSHAKE192SSIMPLE
| p384_sphincsshake192ssimple | 1.3.9999.6.8.13 |No| OQS_OID_P384_SPHINCSSHAKE192SSIMPLE
| sphincsshake256fsimple | 1.3.9999.6.9.10 |No| OQS_OID_SPHINCSSHAKE256FSIMPLE
| p521_sphincsshake256fsimple | 1.3.9999.6.9.11 |No| OQS_OID_P521_SPHINCSSHAKE256FSIMPLE
| sphincsshake256ssimple | 1.3.9999.6.9.12 |No| OQS_OID_SPHINCSSHAKE256SSIMPLE
| p521_sphincsshake256ssimple | 1.3.9999.6.9.13 |No| OQS_OID_P521_SPHINCSSHAKE256SSIMPLE
| mayo1 | 1.3.9999.8.1.3 |Yes| OQS_OID_MAYO1
| p256_mayo1 | 1.3.9999.8.1.4 |Yes| OQS_OID_P256_MAYO1
| mayo2 | 1.3.9999.8.2.3 |Yes| OQS_OID_MAYO2
| p256_mayo2 | 1.3.9999.8.2.4 |Yes| OQS_OID_P256_MAYO2
| mayo3 | 1.3.9999.8.3.3 |Yes| OQS_OID_MAYO3
| p384_mayo3 | 1.3.9999.8.3.4 |Yes| OQS_OID_P384_MAYO3
| mayo5 | 1.3.9999.8.5.3 |Yes| OQS_OID_MAYO5
| p521_mayo5 | 1.3.9999.8.5.4 |Yes| OQS_OID_P521_MAYO5
| CROSSrsdp128balanced | 1.3.6.1.4.1.62245.2.1.1.2 |Yes| OQS_OID_CROSSRSDP128BALANCED
| CROSSrsdp128fast | 1.3.6.1.4.1.62245.2.1.2.2 |No| OQS_OID_CROSSRSDP128FAST
| CROSSrsdp128small | 1.3.6.1.4.1.62245.2.1.3.2 |No| OQS_OID_CROSSRSDP128SMALL
| CROSSrsdp192balanced | 1.3.6.1.4.1.62245.2.1.4.2 |No| OQS_OID_CROSSRSDP192BALANCED
| CROSSrsdp192fast | 1.3.6.1.4.1.62245.2.1.5.2 |No| OQS_OID_CROSSRSDP192FAST
| CROSSrsdp192small | 1.3.6.1.4.1.62245.2.1.6.2 |No| OQS_OID_CROSSRSDP192SMALL
| CROSSrsdp256small | 1.3.6.1.4.1.62245.2.1.9.2 |No| OQS_OID_CROSSRSDP256SMALL
| CROSSrsdpg128balanced | 1.3.6.1.4.1.62245.2.1.10.2 |No| OQS_OID_CROSSRSDPG128BALANCED
| CROSSrsdpg128fast | 1.3.6.1.4.1.62245.2.1.11.2 |No| OQS_OID_CROSSRSDPG128FAST
| CROSSrsdpg128small | 1.3.6.1.4.1.62245.2.1.12.2 |No| OQS_OID_CROSSRSDPG128SMALL
| CROSSrsdpg192balanced | 1.3.6.1.4.1.62245.2.1.13.2 |No| OQS_OID_CROSSRSDPG192BALANCED
| CROSSrsdpg192fast | 1.3.6.1.4.1.62245.2.1.14.2 |No| OQS_OID_CROSSRSDPG192FAST
| CROSSrsdpg192small | 1.3.6.1.4.1.62245.2.1.15.2 |No| OQS_OID_CROSSRSDPG192SMALL
| CROSSrsdpg256balanced | 1.3.6.1.4.1.62245.2.1.16.2 |No| OQS_OID_CROSSRSDPG256BALANCED
| CROSSrsdpg256fast | 1.3.6.1.4.1.62245.2.1.17.2 |No| OQS_OID_CROSSRSDPG256FAST
| CROSSrsdpg256small | 1.3.6.1.4.1.62245.2.1.18.2 |No| OQS_OID_CROSSRSDPG256SMALL
| OV_Is | 1.3.9999.9.1.1 |No| OQS_OID_OV_IS
| p256_OV_Is | 1.3.9999.9.1.2 |No| OQS_OID_P256_OV_IS
| OV_Ip | 1.3.9999.9.2.1 |No| OQS_OID_OV_IP
| p256_OV_Ip | 1.3.9999.9.2.2 |No| OQS_OID_P256_OV_IP
| OV_III | 1.3.9999.9.3.1 |No| OQS_OID_OV_III
| p384_OV_III | 1.3.9999.9.3.2 |No| OQS_OID_P384_OV_III
| OV_V | 1.3.9999.9.4.1 |No| OQS_OID_OV_V
| p521_OV_V | 1.3.9999.9.4.2 |No| OQS_OID_P521_OV_V
| OV_Is_pkc | 1.3.9999.9.5.1 |Yes| OQS_OID_OV_IS_PKC
| p256_OV_Is_pkc | 1.3.9999.9.5.2 |Yes| OQS_OID_P256_OV_IS_PKC
| OV_Ip_pkc | 1.3.9999.9.6.1 |Yes| OQS_OID_OV_IP_PKC
| p256_OV_Ip_pkc | 1.3.9999.9.6.2 |Yes| OQS_OID_P256_OV_IP_PKC
| OV_III_pkc | 1.3.9999.9.7.1 |No| OQS_OID_OV_III_PKC
| p384_OV_III_pkc | 1.3.9999.9.7.2 |No| OQS_OID_P384_OV_III_PKC
| OV_V_pkc | 1.3.9999.9.8.1 |No| OQS_OID_OV_V_PKC
| p521_OV_V_pkc | 1.3.9999.9.8.2 |No| OQS_OID_P521_OV_V_PKC
| OV_Is_pkc_skc | 1.3.9999.9.9.1 |Yes| OQS_OID_OV_IS_PKC_SKC
| p256_OV_Is_pkc_skc | 1.3.9999.9.9.2 |Yes| OQS_OID_P256_OV_IS_PKC_SKC
| OV_Ip_pkc_skc | 1.3.9999.9.10.1 |Yes| OQS_OID_OV_IP_PKC_SKC
| p256_OV_Ip_pkc_skc | 1.3.9999.9.10.2 |Yes| OQS_OID_P256_OV_IP_PKC_SKC
| OV_III_pkc_skc | 1.3.9999.9.11.1 |No| OQS_OID_OV_III_PKC_SKC
| p384_OV_III_pkc_skc | 1.3.9999.9.11.2 |No| OQS_OID_P384_OV_III_PKC_SKC
| OV_V_pkc_skc | 1.3.9999.9.12.1 |No| OQS_OID_OV_V_PKC_SKC
| p521_OV_V_pkc_skc | 1.3.9999.9.12.2 |No| OQS_OID_P521_OV_V_PKC_SKC

If [OQS_KEM_ENCODERS](CONFIGURE.md#OQS_KEM_ENCODERS) is enabled the following list is also available:

|Algorithm name |    default OID    | environment variable |
|---------------|:-----------------:|----------------------|
| frodo640aes | NULL | OQS_OID_FRODO640AES
| p256_frodo640aes | NULL | OQS_OID_P256_FRODO640AES
| x25519_frodo640aes | NULL | OQS_OID_X25519_FRODO640AES
| frodo640shake | NULL | OQS_OID_FRODO640SHAKE
| p256_frodo640shake | NULL | OQS_OID_P256_FRODO640SHAKE
| x25519_frodo640shake | NULL | OQS_OID_X25519_FRODO640SHAKE
| frodo976aes | NULL | OQS_OID_FRODO976AES
| p384_frodo976aes | NULL | OQS_OID_P384_FRODO976AES
| x448_frodo976aes | NULL | OQS_OID_X448_FRODO976AES
| frodo976shake | NULL | OQS_OID_FRODO976SHAKE
| p384_frodo976shake | NULL | OQS_OID_P384_FRODO976SHAKE
| x448_frodo976shake | NULL | OQS_OID_X448_FRODO976SHAKE
| frodo1344aes | NULL | OQS_OID_FRODO1344AES
| p521_frodo1344aes | NULL | OQS_OID_P521_FRODO1344AES
| frodo1344shake | NULL | OQS_OID_FRODO1344SHAKE
| p521_frodo1344shake | NULL | OQS_OID_P521_FRODO1344SHAKE
| mlkem512 | 2.16.840.1.101.3.4.4.1 | OQS_OID_MLKEM512
| p256_mlkem512 | 1.3.6.1.4.1.22554.5.7.1 | OQS_OID_P256_MLKEM512
| x25519_mlkem512 | 1.3.6.1.4.1.22554.5.8.1 | OQS_OID_X25519_MLKEM512
| mlkem768 | 2.16.840.1.101.3.4.4.2 | OQS_OID_MLKEM768
| p384_mlkem768 | NULL | OQS_OID_P384_MLKEM768
| x448_mlkem768 | NULL | OQS_OID_X448_MLKEM768
| X25519MLKEM768 | NULL | OQS_OID_X25519MLKEM768
| SecP256r1MLKEM768 | NULL | OQS_OID_SECP256R1MLKEM768
| mlkem1024 | 2.16.840.1.101.3.4.4.3 | OQS_OID_MLKEM1024
| p521_mlkem1024 | NULL | OQS_OID_P521_MLKEM1024
| SecP384r1MLKEM1024 | 1.3.6.1.4.1.42235.6 | OQS_OID_SECP384R1MLKEM1024
| bikel1 | NULL | OQS_OID_BIKEL1
| p256_bikel1 | NULL | OQS_OID_P256_BIKEL1
| x25519_bikel1 | NULL | OQS_OID_X25519_BIKEL1
| bikel3 | NULL | OQS_OID_BIKEL3
| p384_bikel3 | NULL | OQS_OID_P384_BIKEL3
| x448_bikel3 | NULL | OQS_OID_X448_BIKEL3
| bikel5 | NULL | OQS_OID_BIKEL5
| p521_bikel5 | NULL | OQS_OID_P521_BIKEL5
<!--- OQS_TEMPLATE_FRAGMENT_OIDS_END -->

