; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Test that the puts library call simplifier works correctly.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:32:64-v64:64:64-v128:128:128-a0:0:64-f80:128:128"

@empty = constant [1 x i8] zeroinitializer

declare i32 @puts(ptr)

; Check puts("") -> putchar('\n').

define void @test_simplify1() {
; CHECK-LABEL: @test_simplify1(
; CHECK-NEXT:    [[PUTCHAR:%.*]] = call i32 @putchar(i32 10)
; CHECK-NEXT:    ret void
;
  call i32 @puts(ptr @empty)
  ret void
}

; Don't simplify if the return value is used.

define i32 @test_no_simplify1() {
; CHECK-LABEL: @test_no_simplify1(
; CHECK-NEXT:    [[RET:%.*]] = call i32 @puts(ptr noundef nonnull dereferenceable(1) @empty)
; CHECK-NEXT:    ret i32 [[RET]]
;
  %ret = call i32 @puts(ptr @empty)
  ret i32 %ret
}
