# Leancrypto Rust Binding

The leancrypto Rust bindings offer a native Rust API. It allows Rust-native access to all leancrypto algorithms including their accelerations.

The the offered interfaces follow the same concepts as provided with the general C API. Nonetheless, not all C APIs are yet provided via the Rust bindings which is purely due to lack of time. Adding the missing interfaces, however, is straight forward. If a Rust API binding is missing, either please open an issue at Github or provide a patch.

## Compile example code

1. Install leancrypto by either building it from the source code tree or install it via the distribution. The installation must include the development header files.

2. Build test code: `cargo build --release`

3. Execute test code: `cargo test --release`

4. Build application `example/lc_hash_sha3_512.rs`: `cargo run --example lc_hash_sha3_512`

## Develop your own code

Use the sample applications in `examples/` as well as test code in `tests/` as
starting point.

The API offered by the Rust bindings is very closely following the general C API. The key differences are:

* Each API category is wrapped into Rust structs with associated implementation.

* The general approach is that caller-data must be imported into the struct with different load functions before they can be operated on.

* Data generated by leancrypto is stored in the struct and can be obtained with different getter functions.

The caller interacts with the API using simple `u8` buffers.

## Auxiliary Guidance

An excellent introduction into the RUST code development with linkage to a
C library is given by [Quin Darcy](https://github.com/Quin-Darcy/rust-c-ffi-guide).
