/*
 * Copyright (C) 2024 - 2025, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#ifndef TEST_HELPER_H
#define TEST_HELPER_H

#include <stdlib.h>
#include <stdint.h>

#include "ret_checkers.h"

#ifdef __cplusplus
extern "C" {
#endif

#define LC_TEST_DATA_LEN (1UL << 30)
#define LC_TEST_DATA_LEN_SHORT (1UL << 26)
static inline int test_mem(uint8_t **mem, size_t *len)
{
	uint8_t *tmp = calloc(1, LC_TEST_DATA_LEN);

	*mem = NULL;
	*len = 0;

	if (!tmp) {
		tmp = calloc(1, LC_TEST_DATA_LEN_SHORT);
		if (!tmp)
			return 77;

		*len = LC_TEST_DATA_LEN_SHORT;
	} else {
		*len = LC_TEST_DATA_LEN;
	}

	*mem = tmp;

	return 0;
}

#ifdef __cplusplus
}
#endif

#endif /* TEST_HELPER_H */
