// Copyright 2023 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// @generated by protoc-gen-es v1.7.2 with parameter "target=js+dts"
// @generated from file livekit_agent.proto (package livekit, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto3 } from "@bufbuild/protobuf";
import type { ParticipantInfo, Room } from "./livekit_models_pb.js";

/**
 * @generated from enum livekit.JobType
 */
export declare enum JobType {
  /**
   * @generated from enum value: JT_ROOM = 0;
   */
  JT_ROOM = 0,

  /**
   * @generated from enum value: JT_PUBLISHER = 1;
   */
  JT_PUBLISHER = 1,
}

/**
 * @generated from enum livekit.WorkerStatus
 */
export declare enum WorkerStatus {
  /**
   * @generated from enum value: WS_AVAILABLE = 0;
   */
  WS_AVAILABLE = 0,

  /**
   * @generated from enum value: WS_FULL = 1;
   */
  WS_FULL = 1,
}

/**
 * @generated from enum livekit.JobStatus
 */
export declare enum JobStatus {
  /**
   * @generated from enum value: JS_UNKNOWN = 0;
   */
  JS_UNKNOWN = 0,

  /**
   * @generated from enum value: JS_SUCCESS = 1;
   */
  JS_SUCCESS = 1,

  /**
   * @generated from enum value: JS_FAILED = 2;
   */
  JS_FAILED = 2,
}

/**
 * @generated from message livekit.AgentInfo
 */
export declare class AgentInfo extends Message<AgentInfo> {
  /**
   * @generated from field: string id = 1;
   */
  id: string;

  /**
   * @generated from field: string name = 2;
   */
  name: string;

  /**
   * @generated from field: string version = 3;
   */
  version: string;

  constructor(data?: PartialMessage<AgentInfo>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.AgentInfo";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AgentInfo;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AgentInfo;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AgentInfo;

  static equals(a: AgentInfo | PlainMessage<AgentInfo> | undefined, b: AgentInfo | PlainMessage<AgentInfo> | undefined): boolean;
}

/**
 * @generated from message livekit.Job
 */
export declare class Job extends Message<Job> {
  /**
   * @generated from field: string id = 1;
   */
  id: string;

  /**
   * @generated from field: livekit.JobType type = 2;
   */
  type: JobType;

  /**
   * @generated from field: livekit.Room room = 3;
   */
  room?: Room;

  /**
   * @generated from field: optional livekit.ParticipantInfo participant = 4;
   */
  participant?: ParticipantInfo;

  constructor(data?: PartialMessage<Job>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.Job";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Job;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Job;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Job;

  static equals(a: Job | PlainMessage<Job> | undefined, b: Job | PlainMessage<Job> | undefined): boolean;
}

/**
 * from Worker to Server
 *
 * @generated from message livekit.WorkerMessage
 */
export declare class WorkerMessage extends Message<WorkerMessage> {
  /**
   * @generated from oneof livekit.WorkerMessage.message
   */
  message: {
    /**
     * agent workers need to register themselves with the server first
     *
     * @generated from field: livekit.RegisterWorkerRequest register = 1;
     */
    value: RegisterWorkerRequest;
    case: "register";
  } | {
    /**
     * worker confirms to server that it's available for a job, or declines it
     *
     * @generated from field: livekit.AvailabilityResponse availability = 2;
     */
    value: AvailabilityResponse;
    case: "availability";
  } | {
    /**
     * worker can update its status to the server, including taking itself out of the pool
     *
     * @generated from field: livekit.UpdateWorkerStatus status = 3;
     */
    value: UpdateWorkerStatus;
    case: "status";
  } | {
    /**
     * @generated from field: livekit.JobStatusUpdate job_update = 4;
     */
    value: JobStatusUpdate;
    case: "jobUpdate";
  } | { case: undefined; value?: undefined };

  constructor(data?: PartialMessage<WorkerMessage>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.WorkerMessage";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WorkerMessage;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WorkerMessage;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WorkerMessage;

  static equals(a: WorkerMessage | PlainMessage<WorkerMessage> | undefined, b: WorkerMessage | PlainMessage<WorkerMessage> | undefined): boolean;
}

/**
 * from Server to Worker
 *
 * @generated from message livekit.ServerMessage
 */
export declare class ServerMessage extends Message<ServerMessage> {
  /**
   * @generated from oneof livekit.ServerMessage.message
   */
  message: {
    /**
     * server confirms the registration, from this moment on, the worker is considered active
     *
     * @generated from field: livekit.RegisterWorkerResponse register = 1;
     */
    value: RegisterWorkerResponse;
    case: "register";
  } | {
    /**
     * server asks worker to confirm availability for a job
     *
     * @generated from field: livekit.AvailabilityRequest availability = 2;
     */
    value: AvailabilityRequest;
    case: "availability";
  } | {
    /**
     * @generated from field: livekit.JobAssignment assignment = 3;
     */
    value: JobAssignment;
    case: "assignment";
  } | { case: undefined; value?: undefined };

  constructor(data?: PartialMessage<ServerMessage>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.ServerMessage";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ServerMessage;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ServerMessage;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ServerMessage;

  static equals(a: ServerMessage | PlainMessage<ServerMessage> | undefined, b: ServerMessage | PlainMessage<ServerMessage> | undefined): boolean;
}

/**
 * @generated from message livekit.RegisterWorkerRequest
 */
export declare class RegisterWorkerRequest extends Message<RegisterWorkerRequest> {
  /**
   * @generated from field: livekit.JobType type = 1;
   */
  type: JobType;

  /**
   * @generated from field: string worker_id = 2;
   */
  workerId: string;

  /**
   * @generated from field: string version = 3;
   */
  version: string;

  /**
   * @generated from field: string name = 4;
   */
  name: string;

  constructor(data?: PartialMessage<RegisterWorkerRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.RegisterWorkerRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): RegisterWorkerRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): RegisterWorkerRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): RegisterWorkerRequest;

  static equals(a: RegisterWorkerRequest | PlainMessage<RegisterWorkerRequest> | undefined, b: RegisterWorkerRequest | PlainMessage<RegisterWorkerRequest> | undefined): boolean;
}

/**
 * @generated from message livekit.RegisterWorkerResponse
 */
export declare class RegisterWorkerResponse extends Message<RegisterWorkerResponse> {
  /**
   * @generated from field: string worker_id = 1;
   */
  workerId: string;

  /**
   * @generated from field: string server_version = 2;
   */
  serverVersion: string;

  constructor(data?: PartialMessage<RegisterWorkerResponse>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.RegisterWorkerResponse";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): RegisterWorkerResponse;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): RegisterWorkerResponse;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): RegisterWorkerResponse;

  static equals(a: RegisterWorkerResponse | PlainMessage<RegisterWorkerResponse> | undefined, b: RegisterWorkerResponse | PlainMessage<RegisterWorkerResponse> | undefined): boolean;
}

/**
 * @generated from message livekit.AvailabilityRequest
 */
export declare class AvailabilityRequest extends Message<AvailabilityRequest> {
  /**
   * @generated from field: livekit.Job job = 1;
   */
  job?: Job;

  constructor(data?: PartialMessage<AvailabilityRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.AvailabilityRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AvailabilityRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AvailabilityRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AvailabilityRequest;

  static equals(a: AvailabilityRequest | PlainMessage<AvailabilityRequest> | undefined, b: AvailabilityRequest | PlainMessage<AvailabilityRequest> | undefined): boolean;
}

/**
 * @generated from message livekit.AvailabilityResponse
 */
export declare class AvailabilityResponse extends Message<AvailabilityResponse> {
  /**
   * @generated from field: string job_id = 1;
   */
  jobId: string;

  /**
   * @generated from field: bool available = 2;
   */
  available: boolean;

  constructor(data?: PartialMessage<AvailabilityResponse>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.AvailabilityResponse";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AvailabilityResponse;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AvailabilityResponse;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AvailabilityResponse;

  static equals(a: AvailabilityResponse | PlainMessage<AvailabilityResponse> | undefined, b: AvailabilityResponse | PlainMessage<AvailabilityResponse> | undefined): boolean;
}

/**
 * @generated from message livekit.JobStatusUpdate
 */
export declare class JobStatusUpdate extends Message<JobStatusUpdate> {
  /**
   * @generated from field: string job_id = 1;
   */
  jobId: string;

  /**
   * @generated from field: livekit.JobStatus status = 2;
   */
  status: JobStatus;

  /**
   * @generated from field: string error = 3;
   */
  error: string;

  /**
   * @generated from field: string user_data = 4;
   */
  userData: string;

  constructor(data?: PartialMessage<JobStatusUpdate>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.JobStatusUpdate";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): JobStatusUpdate;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): JobStatusUpdate;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): JobStatusUpdate;

  static equals(a: JobStatusUpdate | PlainMessage<JobStatusUpdate> | undefined, b: JobStatusUpdate | PlainMessage<JobStatusUpdate> | undefined): boolean;
}

/**
 * @generated from message livekit.JobAssignment
 */
export declare class JobAssignment extends Message<JobAssignment> {
  /**
   * @generated from field: livekit.Job job = 1;
   */
  job?: Job;

  constructor(data?: PartialMessage<JobAssignment>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.JobAssignment";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): JobAssignment;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): JobAssignment;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): JobAssignment;

  static equals(a: JobAssignment | PlainMessage<JobAssignment> | undefined, b: JobAssignment | PlainMessage<JobAssignment> | undefined): boolean;
}

/**
 * @generated from message livekit.UpdateWorkerStatus
 */
export declare class UpdateWorkerStatus extends Message<UpdateWorkerStatus> {
  /**
   * @generated from field: livekit.WorkerStatus status = 1;
   */
  status: WorkerStatus;

  constructor(data?: PartialMessage<UpdateWorkerStatus>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.UpdateWorkerStatus";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): UpdateWorkerStatus;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): UpdateWorkerStatus;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): UpdateWorkerStatus;

  static equals(a: UpdateWorkerStatus | PlainMessage<UpdateWorkerStatus> | undefined, b: UpdateWorkerStatus | PlainMessage<UpdateWorkerStatus> | undefined): boolean;
}

