// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum Error {
    /// <p>Another modification is being made. That modification must complete before you can make your change.</p>
    ConcurrentModificationException(crate::types::error::ConcurrentModificationException),
    /// <p>There was a conflict processing the request. Try your request again.</p>
    ConflictException(crate::types::error::ConflictException),
    /// <p>The confidence that Amazon Comprehend accurately detected the source language is low. If a low confidence level is acceptable for your application, you can use the language in the exception to call Amazon Translate again. For more information, see the <a href="https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html">DetectDominantLanguage</a> operation in the <i>Amazon Comprehend Developer Guide</i>.</p>
    DetectedLanguageLowConfidenceException(crate::types::error::DetectedLanguageLowConfidenceException),
    /// <p>An internal server error occurred. Retry your request.</p>
    InternalServerException(crate::types::error::InternalServerException),
    /// <p>The filter specified for the operation is not valid. Specify a different filter.</p>
    InvalidFilterException(crate::types::error::InvalidFilterException),
    /// <p>The value of the parameter is not valid. Review the value of the parameter you are using to correct it, and then retry your operation.</p>
    InvalidParameterValueException(crate::types::error::InvalidParameterValueException),
    /// <p>The request that you made is not valid. Check your request to determine why it's not valid and then retry the request.</p>
    InvalidRequestException(crate::types::error::InvalidRequestException),
    /// <p>The specified limit has been exceeded. Review your request and retry it with a quantity below the stated limit.</p>
    LimitExceededException(crate::types::error::LimitExceededException),
    /// <p>The resource you are looking for has not been found. Review the resource you're looking for and see if a different resource will accomplish your needs before retrying the revised request.</p>
    ResourceNotFoundException(crate::types::error::ResourceNotFoundException),
    /// <p>The Amazon Translate service is temporarily unavailable. Wait a bit and then retry your request.</p>
    ServiceUnavailableException(crate::types::error::ServiceUnavailableException),
    /// <p>The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller document and then retry your request.</p>
    TextSizeLimitExceededException(crate::types::error::TextSizeLimitExceededException),
    /// <p>You have made too many requests within a short period of time. Wait for a short time and then try your request again.</p>
    TooManyRequestsException(crate::types::error::TooManyRequestsException),
    /// <p>You have added too many tags to this resource. The maximum is 50 tags.</p>
    TooManyTagsException(crate::types::error::TooManyTagsException),
    /// <p>Requested display language code is not supported.</p>
    UnsupportedDisplayLanguageCodeException(crate::types::error::UnsupportedDisplayLanguageCodeException),
    /// <p>Amazon Translate does not support translation from the language of the source text into the requested target language. For more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</p>
    UnsupportedLanguagePairException(crate::types::error::UnsupportedLanguagePairException),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-Error) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl ::std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::ConcurrentModificationException(inner) => inner.fmt(f),
            Error::ConflictException(inner) => inner.fmt(f),
            Error::DetectedLanguageLowConfidenceException(inner) => inner.fmt(f),
            Error::InternalServerException(inner) => inner.fmt(f),
            Error::InvalidFilterException(inner) => inner.fmt(f),
            Error::InvalidParameterValueException(inner) => inner.fmt(f),
            Error::InvalidRequestException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ServiceUnavailableException(inner) => inner.fmt(f),
            Error::TextSizeLimitExceededException(inner) => inner.fmt(f),
            Error::TooManyRequestsException(inner) => inner.fmt(f),
            Error::TooManyTagsException(inner) => inner.fmt(f),
            Error::UnsupportedDisplayLanguageCodeException(inner) => inner.fmt(f),
            Error::UnsupportedLanguagePairException(inner) => inner.fmt(f),
            Error::Unhandled(_) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl From<::aws_smithy_types::error::operation::BuildError> for Error {
    fn from(value: ::aws_smithy_types::error::operation::BuildError) -> Self {
        Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: value.into(),
            meta: ::std::default::Default::default(),
        })
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for Error {
    fn meta(&self) -> &::aws_smithy_types::error::metadata::ErrorMetadata {
        match self {
            Self::ConcurrentModificationException(inner) => inner.meta(),
            Self::ConflictException(inner) => inner.meta(),
            Self::DetectedLanguageLowConfidenceException(inner) => inner.meta(),
            Self::InternalServerException(inner) => inner.meta(),
            Self::InvalidFilterException(inner) => inner.meta(),
            Self::InvalidParameterValueException(inner) => inner.meta(),
            Self::InvalidRequestException(inner) => inner.meta(),
            Self::LimitExceededException(inner) => inner.meta(),
            Self::ResourceNotFoundException(inner) => inner.meta(),
            Self::ServiceUnavailableException(inner) => inner.meta(),
            Self::TextSizeLimitExceededException(inner) => inner.meta(),
            Self::TooManyRequestsException(inner) => inner.meta(),
            Self::TooManyTagsException(inner) => inner.meta(),
            Self::UnsupportedDisplayLanguageCodeException(inner) => inner.meta(),
            Self::UnsupportedLanguagePairException(inner) => inner.meta(),
            Self::Unhandled(inner) => &inner.meta,
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_parallel_data::CreateParallelDataError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_parallel_data::CreateParallelDataError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::create_parallel_data::CreateParallelDataError> for Error {
    fn from(err: crate::operation::create_parallel_data::CreateParallelDataError) -> Self {
        match err {
            crate::operation::create_parallel_data::CreateParallelDataError::ConcurrentModificationException(inner) => {
                Error::ConcurrentModificationException(inner)
            }
            crate::operation::create_parallel_data::CreateParallelDataError::ConflictException(inner) => Error::ConflictException(inner),
            crate::operation::create_parallel_data::CreateParallelDataError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::create_parallel_data::CreateParallelDataError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::create_parallel_data::CreateParallelDataError::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
            crate::operation::create_parallel_data::CreateParallelDataError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::create_parallel_data::CreateParallelDataError::TooManyRequestsException(inner) => {
                Error::TooManyRequestsException(inner)
            }
            crate::operation::create_parallel_data::CreateParallelDataError::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
            crate::operation::create_parallel_data::CreateParallelDataError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_parallel_data::DeleteParallelDataError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_parallel_data::DeleteParallelDataError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_parallel_data::DeleteParallelDataError> for Error {
    fn from(err: crate::operation::delete_parallel_data::DeleteParallelDataError) -> Self {
        match err {
            crate::operation::delete_parallel_data::DeleteParallelDataError::ConcurrentModificationException(inner) => {
                Error::ConcurrentModificationException(inner)
            }
            crate::operation::delete_parallel_data::DeleteParallelDataError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::delete_parallel_data::DeleteParallelDataError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::delete_parallel_data::DeleteParallelDataError::TooManyRequestsException(inner) => {
                Error::TooManyRequestsException(inner)
            }
            crate::operation::delete_parallel_data::DeleteParallelDataError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_terminology::DeleteTerminologyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::delete_terminology::DeleteTerminologyError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::delete_terminology::DeleteTerminologyError> for Error {
    fn from(err: crate::operation::delete_terminology::DeleteTerminologyError) -> Self {
        match err {
            crate::operation::delete_terminology::DeleteTerminologyError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::delete_terminology::DeleteTerminologyError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::delete_terminology::DeleteTerminologyError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::delete_terminology::DeleteTerminologyError::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
            crate::operation::delete_terminology::DeleteTerminologyError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_text_translation_job::DescribeTextTranslationJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::describe_text_translation_job::DescribeTextTranslationJobError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::describe_text_translation_job::DescribeTextTranslationJobError> for Error {
    fn from(err: crate::operation::describe_text_translation_job::DescribeTextTranslationJobError) -> Self {
        match err {
            crate::operation::describe_text_translation_job::DescribeTextTranslationJobError::InternalServerException(inner) => {
                Error::InternalServerException(inner)
            }
            crate::operation::describe_text_translation_job::DescribeTextTranslationJobError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::describe_text_translation_job::DescribeTextTranslationJobError::TooManyRequestsException(inner) => {
                Error::TooManyRequestsException(inner)
            }
            crate::operation::describe_text_translation_job::DescribeTextTranslationJobError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_parallel_data::GetParallelDataError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_parallel_data::GetParallelDataError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_parallel_data::GetParallelDataError> for Error {
    fn from(err: crate::operation::get_parallel_data::GetParallelDataError) -> Self {
        match err {
            crate::operation::get_parallel_data::GetParallelDataError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::get_parallel_data::GetParallelDataError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::get_parallel_data::GetParallelDataError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::get_parallel_data::GetParallelDataError::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
            crate::operation::get_parallel_data::GetParallelDataError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_terminology::GetTerminologyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_terminology::GetTerminologyError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_terminology::GetTerminologyError> for Error {
    fn from(err: crate::operation::get_terminology::GetTerminologyError) -> Self {
        match err {
            crate::operation::get_terminology::GetTerminologyError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::get_terminology::GetTerminologyError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::get_terminology::GetTerminologyError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::get_terminology::GetTerminologyError::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
            crate::operation::get_terminology::GetTerminologyError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::import_terminology::ImportTerminologyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::import_terminology::ImportTerminologyError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::import_terminology::ImportTerminologyError> for Error {
    fn from(err: crate::operation::import_terminology::ImportTerminologyError) -> Self {
        match err {
            crate::operation::import_terminology::ImportTerminologyError::ConcurrentModificationException(inner) => {
                Error::ConcurrentModificationException(inner)
            }
            crate::operation::import_terminology::ImportTerminologyError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::import_terminology::ImportTerminologyError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::import_terminology::ImportTerminologyError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::import_terminology::ImportTerminologyError::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
            crate::operation::import_terminology::ImportTerminologyError::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
            crate::operation::import_terminology::ImportTerminologyError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_languages::ListLanguagesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_languages::ListLanguagesError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_languages::ListLanguagesError> for Error {
    fn from(err: crate::operation::list_languages::ListLanguagesError) -> Self {
        match err {
            crate::operation::list_languages::ListLanguagesError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::list_languages::ListLanguagesError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::list_languages::ListLanguagesError::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
            crate::operation::list_languages::ListLanguagesError::UnsupportedDisplayLanguageCodeException(inner) => {
                Error::UnsupportedDisplayLanguageCodeException(inner)
            }
            crate::operation::list_languages::ListLanguagesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_parallel_data::ListParallelDataError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_parallel_data::ListParallelDataError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_parallel_data::ListParallelDataError> for Error {
    fn from(err: crate::operation::list_parallel_data::ListParallelDataError) -> Self {
        match err {
            crate::operation::list_parallel_data::ListParallelDataError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::list_parallel_data::ListParallelDataError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::list_parallel_data::ListParallelDataError::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
            crate::operation::list_parallel_data::ListParallelDataError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_tags_for_resource::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_tags_for_resource::ListTagsForResourceError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_tags_for_resource::ListTagsForResourceError> for Error {
    fn from(err: crate::operation::list_tags_for_resource::ListTagsForResourceError) -> Self {
        match err {
            crate::operation::list_tags_for_resource::ListTagsForResourceError::InternalServerException(inner) => {
                Error::InternalServerException(inner)
            }
            crate::operation::list_tags_for_resource::ListTagsForResourceError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::list_tags_for_resource::ListTagsForResourceError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::list_tags_for_resource::ListTagsForResourceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_terminologies::ListTerminologiesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_terminologies::ListTerminologiesError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_terminologies::ListTerminologiesError> for Error {
    fn from(err: crate::operation::list_terminologies::ListTerminologiesError) -> Self {
        match err {
            crate::operation::list_terminologies::ListTerminologiesError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::list_terminologies::ListTerminologiesError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::list_terminologies::ListTerminologiesError::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
            crate::operation::list_terminologies::ListTerminologiesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_text_translation_jobs::ListTextTranslationJobsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_text_translation_jobs::ListTextTranslationJobsError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_text_translation_jobs::ListTextTranslationJobsError> for Error {
    fn from(err: crate::operation::list_text_translation_jobs::ListTextTranslationJobsError) -> Self {
        match err {
            crate::operation::list_text_translation_jobs::ListTextTranslationJobsError::InternalServerException(inner) => {
                Error::InternalServerException(inner)
            }
            crate::operation::list_text_translation_jobs::ListTextTranslationJobsError::InvalidFilterException(inner) => {
                Error::InvalidFilterException(inner)
            }
            crate::operation::list_text_translation_jobs::ListTextTranslationJobsError::InvalidRequestException(inner) => {
                Error::InvalidRequestException(inner)
            }
            crate::operation::list_text_translation_jobs::ListTextTranslationJobsError::TooManyRequestsException(inner) => {
                Error::TooManyRequestsException(inner)
            }
            crate::operation::list_text_translation_jobs::ListTextTranslationJobsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_text_translation_job::StartTextTranslationJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_text_translation_job::StartTextTranslationJobError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::start_text_translation_job::StartTextTranslationJobError> for Error {
    fn from(err: crate::operation::start_text_translation_job::StartTextTranslationJobError) -> Self {
        match err {
            crate::operation::start_text_translation_job::StartTextTranslationJobError::InternalServerException(inner) => {
                Error::InternalServerException(inner)
            }
            crate::operation::start_text_translation_job::StartTextTranslationJobError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::start_text_translation_job::StartTextTranslationJobError::InvalidRequestException(inner) => {
                Error::InvalidRequestException(inner)
            }
            crate::operation::start_text_translation_job::StartTextTranslationJobError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::start_text_translation_job::StartTextTranslationJobError::TooManyRequestsException(inner) => {
                Error::TooManyRequestsException(inner)
            }
            crate::operation::start_text_translation_job::StartTextTranslationJobError::UnsupportedLanguagePairException(inner) => {
                Error::UnsupportedLanguagePairException(inner)
            }
            crate::operation::start_text_translation_job::StartTextTranslationJobError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::stop_text_translation_job::StopTextTranslationJobError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::stop_text_translation_job::StopTextTranslationJobError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::stop_text_translation_job::StopTextTranslationJobError> for Error {
    fn from(err: crate::operation::stop_text_translation_job::StopTextTranslationJobError) -> Self {
        match err {
            crate::operation::stop_text_translation_job::StopTextTranslationJobError::InternalServerException(inner) => {
                Error::InternalServerException(inner)
            }
            crate::operation::stop_text_translation_job::StopTextTranslationJobError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::stop_text_translation_job::StopTextTranslationJobError::TooManyRequestsException(inner) => {
                Error::TooManyRequestsException(inner)
            }
            crate::operation::stop_text_translation_job::StopTextTranslationJobError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::tag_resource::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::tag_resource::TagResourceError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::tag_resource::TagResourceError> for Error {
    fn from(err: crate::operation::tag_resource::TagResourceError) -> Self {
        match err {
            crate::operation::tag_resource::TagResourceError::ConcurrentModificationException(inner) => Error::ConcurrentModificationException(inner),
            crate::operation::tag_resource::TagResourceError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::tag_resource::TagResourceError::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
            crate::operation::tag_resource::TagResourceError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::tag_resource::TagResourceError::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
            crate::operation::tag_resource::TagResourceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::translate_document::TranslateDocumentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::translate_document::TranslateDocumentError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::translate_document::TranslateDocumentError> for Error {
    fn from(err: crate::operation::translate_document::TranslateDocumentError) -> Self {
        match err {
            crate::operation::translate_document::TranslateDocumentError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::translate_document::TranslateDocumentError::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
            crate::operation::translate_document::TranslateDocumentError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::translate_document::TranslateDocumentError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::translate_document::TranslateDocumentError::ServiceUnavailableException(inner) => {
                Error::ServiceUnavailableException(inner)
            }
            crate::operation::translate_document::TranslateDocumentError::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
            crate::operation::translate_document::TranslateDocumentError::UnsupportedLanguagePairException(inner) => {
                Error::UnsupportedLanguagePairException(inner)
            }
            crate::operation::translate_document::TranslateDocumentError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::translate_text::TranslateTextError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::translate_text::TranslateTextError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::translate_text::TranslateTextError> for Error {
    fn from(err: crate::operation::translate_text::TranslateTextError) -> Self {
        match err {
            crate::operation::translate_text::TranslateTextError::DetectedLanguageLowConfidenceException(inner) => {
                Error::DetectedLanguageLowConfidenceException(inner)
            }
            crate::operation::translate_text::TranslateTextError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::translate_text::TranslateTextError::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
            crate::operation::translate_text::TranslateTextError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::translate_text::TranslateTextError::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
            crate::operation::translate_text::TranslateTextError::TextSizeLimitExceededException(inner) => {
                Error::TextSizeLimitExceededException(inner)
            }
            crate::operation::translate_text::TranslateTextError::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
            crate::operation::translate_text::TranslateTextError::UnsupportedLanguagePairException(inner) => {
                Error::UnsupportedLanguagePairException(inner)
            }
            crate::operation::translate_text::TranslateTextError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::untag_resource::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::untag_resource::UntagResourceError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::untag_resource::UntagResourceError> for Error {
    fn from(err: crate::operation::untag_resource::UntagResourceError) -> Self {
        match err {
            crate::operation::untag_resource::UntagResourceError::ConcurrentModificationException(inner) => {
                Error::ConcurrentModificationException(inner)
            }
            crate::operation::untag_resource::UntagResourceError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::untag_resource::UntagResourceError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::untag_resource::UntagResourceError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::untag_resource::UntagResourceError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_parallel_data::UpdateParallelDataError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::update_parallel_data::UpdateParallelDataError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::update_parallel_data::UpdateParallelDataError> for Error {
    fn from(err: crate::operation::update_parallel_data::UpdateParallelDataError) -> Self {
        match err {
            crate::operation::update_parallel_data::UpdateParallelDataError::ConcurrentModificationException(inner) => {
                Error::ConcurrentModificationException(inner)
            }
            crate::operation::update_parallel_data::UpdateParallelDataError::ConflictException(inner) => Error::ConflictException(inner),
            crate::operation::update_parallel_data::UpdateParallelDataError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::update_parallel_data::UpdateParallelDataError::InvalidParameterValueException(inner) => {
                Error::InvalidParameterValueException(inner)
            }
            crate::operation::update_parallel_data::UpdateParallelDataError::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
            crate::operation::update_parallel_data::UpdateParallelDataError::LimitExceededException(inner) => Error::LimitExceededException(inner),
            crate::operation::update_parallel_data::UpdateParallelDataError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::update_parallel_data::UpdateParallelDataError::TooManyRequestsException(inner) => {
                Error::TooManyRequestsException(inner)
            }
            crate::operation::update_parallel_data::UpdateParallelDataError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl ::std::error::Error for Error {
    fn source(&self) -> std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Error::ConcurrentModificationException(inner) => inner.source(),
            Error::ConflictException(inner) => inner.source(),
            Error::DetectedLanguageLowConfidenceException(inner) => inner.source(),
            Error::InternalServerException(inner) => inner.source(),
            Error::InvalidFilterException(inner) => inner.source(),
            Error::InvalidParameterValueException(inner) => inner.source(),
            Error::InvalidRequestException(inner) => inner.source(),
            Error::LimitExceededException(inner) => inner.source(),
            Error::ResourceNotFoundException(inner) => inner.source(),
            Error::ServiceUnavailableException(inner) => inner.source(),
            Error::TextSizeLimitExceededException(inner) => inner.source(),
            Error::TooManyRequestsException(inner) => inner.source(),
            Error::TooManyTagsException(inner) => inner.source(),
            Error::UnsupportedDisplayLanguageCodeException(inner) => inner.source(),
            Error::UnsupportedLanguagePairException(inner) => inner.source(),
            Error::Unhandled(inner) => ::std::option::Option::Some(&*inner.source),
        }
    }
}
impl ::aws_types::request_id::RequestId for Error {
    fn request_id(&self) -> Option<&str> {
        match self {
            Self::ConcurrentModificationException(e) => e.request_id(),
            Self::ConflictException(e) => e.request_id(),
            Self::DetectedLanguageLowConfidenceException(e) => e.request_id(),
            Self::InternalServerException(e) => e.request_id(),
            Self::InvalidFilterException(e) => e.request_id(),
            Self::InvalidParameterValueException(e) => e.request_id(),
            Self::InvalidRequestException(e) => e.request_id(),
            Self::LimitExceededException(e) => e.request_id(),
            Self::ResourceNotFoundException(e) => e.request_id(),
            Self::ServiceUnavailableException(e) => e.request_id(),
            Self::TextSizeLimitExceededException(e) => e.request_id(),
            Self::TooManyRequestsException(e) => e.request_id(),
            Self::TooManyTagsException(e) => e.request_id(),
            Self::UnsupportedDisplayLanguageCodeException(e) => e.request_id(),
            Self::UnsupportedLanguagePairException(e) => e.request_id(),
            Self::Unhandled(e) => e.meta.request_id(),
        }
    }
}
