// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_get_object_attributes_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<
    crate::operation::get_object_attributes::GetObjectAttributesOutput,
    crate::operation::get_object_attributes::GetObjectAttributesError,
> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::get_object_attributes::GetObjectAttributesError::unhandled)?;
    generic_builder = crate::s3_request_id::apply_extended_request_id(generic_builder, _response_headers);
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::operation::get_object_attributes::GetObjectAttributesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchKey" => crate::operation::get_object_attributes::GetObjectAttributesError::NoSuchKey({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::NoSuchKeyBuilder::default();
                output = crate::protocol_serde::shape_no_such_key::de_no_such_key_xml_err(_response_body, output)
                    .map_err(crate::operation::get_object_attributes::GetObjectAttributesError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        _ => crate::operation::get_object_attributes::GetObjectAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_get_object_attributes_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<
    crate::operation::get_object_attributes::GetObjectAttributesOutput,
    crate::operation::get_object_attributes::GetObjectAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::get_object_attributes::builders::GetObjectAttributesOutputBuilder::default();
        output = crate::protocol_serde::shape_get_object_attributes::de_get_object_attributes(_response_body, output)
            .map_err(crate::operation::get_object_attributes::GetObjectAttributesError::unhandled)?;
        output = output.set_delete_marker(
            crate::protocol_serde::shape_get_object_attributes_output::de_delete_marker_header(_response_headers).map_err(|_| {
                crate::operation::get_object_attributes::GetObjectAttributesError::unhandled(
                    "Failed to parse DeleteMarker from header `x-amz-delete-marker",
                )
            })?,
        );
        output = output.set_last_modified(
            crate::protocol_serde::shape_get_object_attributes_output::de_last_modified_header(_response_headers).map_err(|_| {
                crate::operation::get_object_attributes::GetObjectAttributesError::unhandled(
                    "Failed to parse LastModified from header `Last-Modified",
                )
            })?,
        );
        output = output.set_request_charged(
            crate::protocol_serde::shape_get_object_attributes_output::de_request_charged_header(_response_headers).map_err(|_| {
                crate::operation::get_object_attributes::GetObjectAttributesError::unhandled(
                    "Failed to parse RequestCharged from header `x-amz-request-charged",
                )
            })?,
        );
        output = output.set_version_id(
            crate::protocol_serde::shape_get_object_attributes_output::de_version_id_header(_response_headers).map_err(|_| {
                crate::operation::get_object_attributes::GetObjectAttributesError::unhandled(
                    "Failed to parse VersionId from header `x-amz-version-id",
                )
            })?,
        );
        output._set_extended_request_id(crate::s3_request_id::RequestIdExt::extended_request_id(_response_headers).map(str::to_string));
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

pub fn ser_get_object_attributes_headers(
    input: &crate::operation::get_object_attributes::GetObjectAttributesInput,
    mut builder: ::http::request::Builder,
) -> std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
    if let ::std::option::Option::Some(inner_1) = &input.max_parts {
        let mut encoder = ::aws_smithy_types::primitive::Encoder::from(*inner_1);
        let formatted_2 = encoder.encode();
        let header_value = formatted_2;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "max_parts",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-max-parts", header_value);
    }
    if let ::std::option::Option::Some(inner_3) = &input.part_number_marker {
        let formatted_4 = inner_3.as_str();
        let header_value = formatted_4;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "part_number_marker",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-part-number-marker", header_value);
    }
    if let ::std::option::Option::Some(inner_5) = &input.sse_customer_algorithm {
        let formatted_6 = inner_5.as_str();
        let header_value = formatted_6;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "sse_customer_algorithm",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-server-side-encryption-customer-algorithm", header_value);
    }
    if let ::std::option::Option::Some(inner_7) = &input.sse_customer_key {
        let formatted_8 = inner_7.as_str();
        let header_value = formatted_8;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "sse_customer_key",
                format!("`{}` cannot be used as a header value: {}", &"*** Sensitive Data Redacted ***", err),
            )
        })?;
        builder = builder.header("x-amz-server-side-encryption-customer-key", header_value);
    }
    if let ::std::option::Option::Some(inner_9) = &input.sse_customer_key_md5 {
        let formatted_10 = inner_9.as_str();
        let header_value = formatted_10;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "sse_customer_key_md5",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-server-side-encryption-customer-key-MD5", header_value);
    }
    if let ::std::option::Option::Some(inner_11) = &input.request_payer {
        let formatted_12 = inner_11.as_str();
        let header_value = formatted_12;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "request_payer",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-request-payer", header_value);
    }
    if let ::std::option::Option::Some(inner_13) = &input.expected_bucket_owner {
        let formatted_14 = inner_13.as_str();
        let header_value = formatted_14;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "expected_bucket_owner",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-expected-bucket-owner", header_value);
    }
    if let ::std::option::Option::Some(inner_15) = &input.object_attributes {
        // Empty vec in header is serialized as an empty string
        if inner_15.is_empty() {
            builder = builder.header("x-amz-object-attributes", "");
        } else {
            for inner_16 in inner_15 {
                let formatted_17 = ::aws_smithy_http::header::quote_header_value(inner_16.as_str());
                let header_value = formatted_17;
                let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                    ::aws_smithy_types::error::operation::BuildError::invalid_field(
                        "object_attributes",
                        format!("`{}` cannot be used as a header value: {}", &header_value, err),
                    )
                })?;
                builder = builder.header("x-amz-object-attributes", header_value);
            }
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn de_get_object_attributes(
    inp: &[u8],
    mut builder: crate::operation::get_object_attributes::builders::GetObjectAttributesOutputBuilder,
) -> Result<crate::operation::get_object_attributes::builders::GetObjectAttributesOutputBuilder, ::aws_smithy_xml::decode::XmlDecodeError> {
    let mut doc = ::aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    #[allow(unused_variables)]
    let start_el = decoder.start_el();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ETag") /* ETag com.amazonaws.s3.synthetic#GetObjectAttributesOutput$ETag */ =>  {
                let var_18 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_e_tag(var_18);
            }
            ,
            s if s.matches("Checksum") /* Checksum com.amazonaws.s3.synthetic#GetObjectAttributesOutput$Checksum */ =>  {
                let var_19 =
                    Some(
                        crate::protocol_serde::shape_checksum::de_checksum(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_checksum(var_19);
            }
            ,
            s if s.matches("StorageClass") /* StorageClass com.amazonaws.s3.synthetic#GetObjectAttributesOutput$StorageClass */ =>  {
                let var_20 =
                    Some(
                        Result::<crate::types::StorageClass, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            crate::types::StorageClass::from(
                                ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_class(var_20);
            }
            ,
            s if s.matches("ObjectSize") /* ObjectSize com.amazonaws.s3.synthetic#GetObjectAttributesOutput$ObjectSize */ =>  {
                let var_21 =
                    Some(
                         {
                            <i64 as ::aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|::aws_smithy_xml::decode::XmlDecodeError::custom("expected (long: `com.amazonaws.s3#ObjectSize`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_object_size(var_21);
            }
            ,
            s if s.matches("ObjectParts") /* ObjectParts com.amazonaws.s3.synthetic#GetObjectAttributesOutput$ObjectParts */ =>  {
                let var_22 =
                    Some(
                        crate::protocol_serde::shape_get_object_attributes_parts::de_get_object_attributes_parts(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_object_parts(var_22);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}
