#[cfg(feature = "Win32_Media_DirectShow_Tv")]
pub mod Tv;
#[cfg(feature = "Win32_Media_DirectShow_Xml")]
pub mod Xml;
#[inline]
pub unsafe fn AMGetErrorTextA(hr: windows_core::HRESULT, pbuffer: &mut [u8]) -> u32 {
    windows_link::link!("quartz.dll" "system" fn AMGetErrorTextA(hr : windows_core::HRESULT, pbuffer : windows_core::PSTR, maxlen : u32) -> u32);
    unsafe { AMGetErrorTextA(hr, core::mem::transmute(pbuffer.as_ptr()), pbuffer.len().try_into().unwrap()) }
}
#[inline]
pub unsafe fn AMGetErrorTextW(hr: windows_core::HRESULT, pbuffer: &mut [u16]) -> u32 {
    windows_link::link!("quartz.dll" "system" fn AMGetErrorTextW(hr : windows_core::HRESULT, pbuffer : windows_core::PWSTR, maxlen : u32) -> u32);
    unsafe { AMGetErrorTextW(hr, core::mem::transmute(pbuffer.as_ptr()), pbuffer.len().try_into().unwrap()) }
}
pub const ADVISE_CLIPPING: ADVISE_TYPE = ADVISE_TYPE(1i32);
pub const ADVISE_COLORKEY: ADVISE_TYPE = ADVISE_TYPE(4i32);
pub const ADVISE_DISPLAY_CHANGE: ADVISE_TYPE = ADVISE_TYPE(16i32);
pub const ADVISE_NONE: ADVISE_TYPE = ADVISE_TYPE(0i32);
pub const ADVISE_PALETTE: ADVISE_TYPE = ADVISE_TYPE(2i32);
pub const ADVISE_POSITION: ADVISE_TYPE = ADVISE_TYPE(8i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ADVISE_TYPE(pub i32);
impl ADVISE_TYPE {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for ADVISE_TYPE {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for ADVISE_TYPE {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for ADVISE_TYPE {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for ADVISE_TYPE {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for ADVISE_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ALLOCATOR_PROPERTIES {
    pub cBuffers: i32,
    pub cbBuffer: i32,
    pub cbAlign: i32,
    pub cbPrefix: i32,
}
impl Default for ALLOCATOR_PROPERTIES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AMAP_3D_TARGET: VMRSurfaceAllocationFlags = VMRSurfaceAllocationFlags(2i32);
pub const AMAP_ALLOW_SYSMEM: VMRSurfaceAllocationFlags = VMRSurfaceAllocationFlags(4i32);
pub const AMAP_DIRECTED_FLIP: VMRSurfaceAllocationFlags = VMRSurfaceAllocationFlags(16i32);
pub const AMAP_DXVA_TARGET: VMRSurfaceAllocationFlags = VMRSurfaceAllocationFlags(32i32);
pub const AMAP_FORCE_SYSMEM: VMRSurfaceAllocationFlags = VMRSurfaceAllocationFlags(8i32);
pub const AMAP_PIXELFORMAT_VALID: VMRSurfaceAllocationFlags = VMRSurfaceAllocationFlags(1i32);
pub const AMCONTROL_COLORINFO_PRESENT: u32 = 128u32;
pub const AMCONTROL_PAD_TO_16x9: u32 = 4u32;
pub const AMCONTROL_PAD_TO_4x3: u32 = 2u32;
pub const AMCONTROL_USED: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMCOPPCommand {
    pub macKDI: windows_core::GUID,
    pub guidCommandID: windows_core::GUID,
    pub dwSequence: u32,
    pub cbSizeData: u32,
    pub CommandData: [u8; 4056],
}
impl Default for AMCOPPCommand {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMCOPPSignature {
    pub Signature: [u8; 256],
}
impl Default for AMCOPPSignature {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMCOPPStatusInput {
    pub rApp: windows_core::GUID,
    pub guidStatusRequestID: windows_core::GUID,
    pub dwSequence: u32,
    pub cbSizeData: u32,
    pub StatusData: [u8; 4056],
}
impl Default for AMCOPPStatusInput {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMCOPPStatusOutput {
    pub macKDI: windows_core::GUID,
    pub cbSizeData: u32,
    pub COPPStatus: [u8; 4076],
}
impl Default for AMCOPPStatusOutput {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AMCOPYPROTECT_RestrictDuplication: u32 = 1u32;
pub const AMDDS_ALL: u32 = 255u32;
pub const AMDDS_DCIPS: u32 = 1u32;
pub const AMDDS_DEFAULT: u32 = 255u32;
pub const AMDDS_NONE: u32 = 0u32;
pub const AMDDS_PS: u32 = 2u32;
pub const AMDDS_RGBFLP: u32 = 64u32;
pub const AMDDS_RGBOFF: u32 = 16u32;
pub const AMDDS_RGBOVR: u32 = 4u32;
pub const AMDDS_YUVFLP: u32 = 128u32;
pub const AMDDS_YUVOFF: u32 = 32u32;
pub const AMDDS_YUVOVR: u32 = 8u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMExtendedSeekingCapabilities(pub i32);
pub const AMF_AUTOMATICGAIN: f64 = -1f64;
pub type AMGETERRORTEXTPROCA = Option<unsafe extern "system" fn(param0: windows_core::HRESULT, param1: windows_core::PCSTR, param2: u32) -> windows_core::BOOL>;
pub type AMGETERRORTEXTPROCW = Option<unsafe extern "system" fn(param0: windows_core::HRESULT, param1: windows_core::PCWSTR, param2: u32) -> windows_core::BOOL>;
pub const AMINTERLACE_1FieldPerSample: u32 = 2u32;
pub const AMINTERLACE_DisplayModeBobOnly: u32 = 0u32;
pub const AMINTERLACE_DisplayModeBobOrWeave: u32 = 128u32;
pub const AMINTERLACE_DisplayModeMask: u32 = 192u32;
pub const AMINTERLACE_DisplayModeWeaveOnly: u32 = 64u32;
pub const AMINTERLACE_Field1First: u32 = 4u32;
pub const AMINTERLACE_FieldPatBothIrregular: u32 = 48u32;
pub const AMINTERLACE_FieldPatBothRegular: u32 = 32u32;
pub const AMINTERLACE_FieldPatField1Only: u32 = 0u32;
pub const AMINTERLACE_FieldPatField2Only: u32 = 16u32;
pub const AMINTERLACE_FieldPatternMask: u32 = 48u32;
pub const AMINTERLACE_IsInterlaced: u32 = 1u32;
pub const AMINTERLACE_UNUSED: u32 = 8u32;
pub const AMMSF_ADDDEFAULTRENDERER: AMMSF_MS_FLAGS = AMMSF_MS_FLAGS(1i32);
pub const AMMSF_CREATEPEER: AMMSF_MS_FLAGS = AMMSF_MS_FLAGS(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMMSF_MMS_INIT_FLAGS(pub i32);
impl AMMSF_MMS_INIT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for AMMSF_MMS_INIT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for AMMSF_MMS_INIT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for AMMSF_MMS_INIT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for AMMSF_MMS_INIT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for AMMSF_MMS_INIT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMMSF_MS_FLAGS(pub i32);
impl AMMSF_MS_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for AMMSF_MS_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for AMMSF_MS_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for AMMSF_MS_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for AMMSF_MS_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for AMMSF_MS_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const AMMSF_NOCLOCK: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(4i32);
pub const AMMSF_NOGRAPHTHREAD: AMMSF_MMS_INIT_FLAGS = AMMSF_MMS_INIT_FLAGS(1i32);
pub const AMMSF_NORENDER: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(2i32);
pub const AMMSF_NOSTALL: AMMSF_MS_FLAGS = AMMSF_MS_FLAGS(8i32);
pub const AMMSF_RENDERALLSTREAMS: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(1i32);
pub const AMMSF_RENDERTOEXISTING: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(0i32);
pub const AMMSF_RENDERTYPEMASK: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(3i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMMSF_RENDER_FLAGS(pub i32);
impl AMMSF_RENDER_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for AMMSF_RENDER_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for AMMSF_RENDER_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for AMMSF_RENDER_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for AMMSF_RENDER_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for AMMSF_RENDER_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const AMMSF_RUN: AMMSF_RENDER_FLAGS = AMMSF_RENDER_FLAGS(8i32);
pub const AMMSF_STOPIFNOSAMPLES: AMMSF_MS_FLAGS = AMMSF_MS_FLAGS(4i32);
pub const AMOVERFX_DEINTERLACE: AMOVERLAYFX = AMOVERLAYFX(8i32);
pub const AMOVERFX_MIRRORLEFTRIGHT: AMOVERLAYFX = AMOVERLAYFX(2i32);
pub const AMOVERFX_MIRRORUPDOWN: AMOVERLAYFX = AMOVERLAYFX(4i32);
pub const AMOVERFX_NOFX: AMOVERLAYFX = AMOVERLAYFX(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMOVERLAYFX(pub i32);
pub const AMPLAYLISTEVENT_BREAK: AMPlayListEventFlags = AMPlayListEventFlags(1i32);
pub const AMPLAYLISTEVENT_MASK: AMPlayListEventFlags = AMPlayListEventFlags(15i32);
pub const AMPLAYLISTEVENT_NEXT: AMPlayListEventFlags = AMPlayListEventFlags(2i32);
pub const AMPLAYLISTEVENT_REFRESH: AMPlayListEventFlags = AMPlayListEventFlags(16i32);
pub const AMPLAYLISTEVENT_RESUME: AMPlayListEventFlags = AMPlayListEventFlags(0i32);
pub const AMPLAYLISTITEM_CANBIND: AMPlayListItemFlags = AMPlayListItemFlags(2i32);
pub const AMPLAYLISTITEM_CANSKIP: AMPlayListItemFlags = AMPlayListItemFlags(1i32);
pub const AMPLAYLIST_FORCEBANNER: AMPlayListFlags = AMPlayListFlags(2i32);
pub const AMPLAYLIST_STARTINSCANMODE: AMPlayListFlags = AMPlayListFlags(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMPROPERTY_PIN(pub i32);
pub const AMPROPERTY_PIN_CATEGORY: AMPROPERTY_PIN = AMPROPERTY_PIN(0i32);
pub const AMPROPERTY_PIN_MEDIUM: AMPROPERTY_PIN = AMPROPERTY_PIN(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMPlayListEventFlags(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMPlayListFlags(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMPlayListItemFlags(pub i32);
pub const AMRESCTL_RESERVEFLAGS_RESERVE: _AMRESCTL_RESERVEFLAGS = _AMRESCTL_RESERVEFLAGS(0i32);
pub const AMRESCTL_RESERVEFLAGS_UNRESERVE: _AMRESCTL_RESERVEFLAGS = _AMRESCTL_RESERVEFLAGS(1i32);
pub const AMSTREAMSELECTENABLE_ENABLE: _AMSTREAMSELECTENABLEFLAGS = _AMSTREAMSELECTENABLEFLAGS(1i32);
pub const AMSTREAMSELECTENABLE_ENABLEALL: _AMSTREAMSELECTENABLEFLAGS = _AMSTREAMSELECTENABLEFLAGS(2i32);
pub const AMSTREAMSELECTINFO_ENABLED: _AMSTREAMSELECTINFOFLAGS = _AMSTREAMSELECTINFOFLAGS(1i32);
pub const AMSTREAMSELECTINFO_EXCLUSIVE: _AMSTREAMSELECTINFOFLAGS = _AMSTREAMSELECTINFOFLAGS(2i32);
pub const AMTUNER_EVENT_CHANGED: AMTunerEventType = AMTunerEventType(1i32);
pub const AMTUNER_HASNOSIGNALSTRENGTH: AMTunerSignalStrength = AMTunerSignalStrength(-1i32);
pub const AMTUNER_MODE_AM_RADIO: AMTunerModeType = AMTunerModeType(4i32);
pub const AMTUNER_MODE_DEFAULT: AMTunerModeType = AMTunerModeType(0i32);
pub const AMTUNER_MODE_DSS: AMTunerModeType = AMTunerModeType(8i32);
pub const AMTUNER_MODE_FM_RADIO: AMTunerModeType = AMTunerModeType(2i32);
pub const AMTUNER_MODE_TV: AMTunerModeType = AMTunerModeType(1i32);
pub const AMTUNER_NOSIGNAL: AMTunerSignalStrength = AMTunerSignalStrength(0i32);
pub const AMTUNER_SIGNALPRESENT: AMTunerSignalStrength = AMTunerSignalStrength(1i32);
pub const AMTUNER_SUBCHAN_DEFAULT: AMTunerSubChannel = AMTunerSubChannel(-1i32);
pub const AMTUNER_SUBCHAN_NO_TUNE: AMTunerSubChannel = AMTunerSubChannel(-2i32);
pub const AMTVAUDIO_EVENT_CHANGED: AMTVAudioEventType = AMTVAudioEventType(1i32);
pub const AMTVAUDIO_MODE_LANG_A: TVAudioMode = TVAudioMode(16i32);
pub const AMTVAUDIO_MODE_LANG_B: TVAudioMode = TVAudioMode(32i32);
pub const AMTVAUDIO_MODE_LANG_C: TVAudioMode = TVAudioMode(64i32);
pub const AMTVAUDIO_MODE_MONO: TVAudioMode = TVAudioMode(1i32);
pub const AMTVAUDIO_MODE_STEREO: TVAudioMode = TVAudioMode(2i32);
pub const AMTVAUDIO_PRESET_LANG_A: TVAudioMode = TVAudioMode(4096i32);
pub const AMTVAUDIO_PRESET_LANG_B: TVAudioMode = TVAudioMode(8192i32);
pub const AMTVAUDIO_PRESET_LANG_C: TVAudioMode = TVAudioMode(16384i32);
pub const AMTVAUDIO_PRESET_STEREO: TVAudioMode = TVAudioMode(512i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMTVAudioEventType(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMTunerEventType(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMTunerModeType(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMTunerSignalStrength(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMTunerSubChannel(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMVABUFFERINFO {
    pub dwTypeIndex: u32,
    pub dwBufferIndex: u32,
    pub dwDataOffset: u32,
    pub dwDataSize: u32,
}
impl Default for AMVABUFFERINFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMVABeginFrameInfo {
    pub dwDestSurfaceIndex: u32,
    pub pInputData: *mut core::ffi::c_void,
    pub dwSizeInputData: u32,
    pub pOutputData: *mut core::ffi::c_void,
    pub dwSizeOutputData: u32,
}
impl Default for AMVABeginFrameInfo {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_DirectDraw")]
#[derive(Clone, Copy)]
pub struct AMVACompBufferInfo {
    pub dwNumCompBuffers: u32,
    pub dwWidthToCreate: u32,
    pub dwHeightToCreate: u32,
    pub dwBytesToAllocate: u32,
    pub ddCompCaps: super::super::Graphics::DirectDraw::DDSCAPS2,
    pub ddPixelFormat: super::super::Graphics::DirectDraw::DDPIXELFORMAT,
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl Default for AMVACompBufferInfo {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMVAEndFrameInfo {
    pub dwSizeMiscData: u32,
    pub pMiscData: *mut core::ffi::c_void,
}
impl Default for AMVAEndFrameInfo {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMVAInternalMemInfo {
    pub dwScratchMemAlloc: u32,
}
impl Default for AMVAInternalMemInfo {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_DirectDraw")]
#[derive(Clone, Copy)]
pub struct AMVAUncompBufferInfo {
    pub dwMinNumSurfaces: u32,
    pub dwMaxNumSurfaces: u32,
    pub ddUncompPixelFormat: super::super::Graphics::DirectDraw::DDPIXELFORMAT,
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl Default for AMVAUncompBufferInfo {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_DirectDraw")]
#[derive(Clone, Copy)]
pub struct AMVAUncompDataInfo {
    pub dwUncompWidth: u32,
    pub dwUncompHeight: u32,
    pub ddUncompPixelFormat: super::super::Graphics::DirectDraw::DDPIXELFORMAT,
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl Default for AMVAUncompDataInfo {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AMVA_QUERYRENDERSTATUSF_READ: u32 = 1u32;
pub const AMVA_TYPEINDEX_OUTPUTFRAME: u32 = 4294967295u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMVPDATAINFO {
    pub dwSize: u32,
    pub dwMicrosecondsPerField: u32,
    pub amvpDimInfo: AMVPDIMINFO,
    pub dwPictAspectRatioX: u32,
    pub dwPictAspectRatioY: u32,
    pub bEnableDoubleClock: windows_core::BOOL,
    pub bEnableVACT: windows_core::BOOL,
    pub bDataIsInterlaced: windows_core::BOOL,
    pub lHalfLinesOdd: i32,
    pub bFieldPolarityInverted: windows_core::BOOL,
    pub dwNumLinesInVREF: u32,
    pub lHalfLinesEven: i32,
    pub dwReserved1: u32,
}
impl Default for AMVPDATAINFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMVPDIMINFO {
    pub dwFieldWidth: u32,
    pub dwFieldHeight: u32,
    pub dwVBIWidth: u32,
    pub dwVBIHeight: u32,
    pub rcValidRegion: super::super::Foundation::RECT,
}
impl Default for AMVPDIMINFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AMVPSIZE {
    pub dwWidth: u32,
    pub dwHeight: u32,
}
impl Default for AMVPSIZE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AMVP_BEST_BANDWIDTH: AMVP_SELECT_FORMAT_BY = AMVP_SELECT_FORMAT_BY(1i32);
pub const AMVP_DO_NOT_CARE: AMVP_SELECT_FORMAT_BY = AMVP_SELECT_FORMAT_BY(0i32);
pub const AMVP_INPUT_SAME_AS_OUTPUT: AMVP_SELECT_FORMAT_BY = AMVP_SELECT_FORMAT_BY(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMVP_MODE(pub i32);
pub const AMVP_MODE_BOBINTERLEAVED: AMVP_MODE = AMVP_MODE(1i32);
pub const AMVP_MODE_BOBNONINTERLEAVED: AMVP_MODE = AMVP_MODE(2i32);
pub const AMVP_MODE_SKIPEVEN: AMVP_MODE = AMVP_MODE(3i32);
pub const AMVP_MODE_SKIPODD: AMVP_MODE = AMVP_MODE(4i32);
pub const AMVP_MODE_WEAVE: AMVP_MODE = AMVP_MODE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AMVP_SELECT_FORMAT_BY(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_AC3_ALTERNATE_AUDIO {
    pub fStereo: windows_core::BOOL,
    pub DualMode: u32,
}
impl Default for AM_AC3_ALTERNATE_AUDIO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AM_AC3_ALTERNATE_AUDIO_1: u32 = 1u32;
pub const AM_AC3_ALTERNATE_AUDIO_2: u32 = 2u32;
pub const AM_AC3_ALTERNATE_AUDIO_BOTH: u32 = 3u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_AC3_BIT_STREAM_MODE {
    pub BitStreamMode: i32,
}
impl Default for AM_AC3_BIT_STREAM_MODE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_AC3_DIALOGUE_LEVEL {
    pub DialogueLevel: u32,
}
impl Default for AM_AC3_DIALOGUE_LEVEL {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_AC3_DOWNMIX {
    pub fDownMix: windows_core::BOOL,
    pub fDolbySurround: windows_core::BOOL,
}
impl Default for AM_AC3_DOWNMIX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_AC3_ERROR_CONCEALMENT {
    pub fRepeatPreviousBlock: windows_core::BOOL,
    pub fErrorInCurrentBlock: windows_core::BOOL,
}
impl Default for AM_AC3_ERROR_CONCEALMENT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_AC3_ROOM_TYPE {
    pub fLargeRoom: windows_core::BOOL,
}
impl Default for AM_AC3_ROOM_TYPE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AM_AC3_SERVICE_COMMENTARY: u32 = 5u32;
pub const AM_AC3_SERVICE_DIALOG_ONLY: u32 = 4u32;
pub const AM_AC3_SERVICE_EMERGENCY_FLASH: u32 = 6u32;
pub const AM_AC3_SERVICE_HEARING_IMPAIRED: u32 = 3u32;
pub const AM_AC3_SERVICE_MAIN_AUDIO: u32 = 0u32;
pub const AM_AC3_SERVICE_NO_DIALOG: u32 = 1u32;
pub const AM_AC3_SERVICE_VISUALLY_IMPAIRED: u32 = 2u32;
pub const AM_AC3_SERVICE_VOICE_OVER: u32 = 7u32;
pub const AM_ARMODE_CROP: AM_ASPECT_RATIO_MODE = AM_ASPECT_RATIO_MODE(2i32);
pub const AM_ARMODE_LETTER_BOX: AM_ASPECT_RATIO_MODE = AM_ASPECT_RATIO_MODE(1i32);
pub const AM_ARMODE_STRETCHED: AM_ASPECT_RATIO_MODE = AM_ASPECT_RATIO_MODE(0i32);
pub const AM_ARMODE_STRETCHED_AS_PRIMARY: AM_ASPECT_RATIO_MODE = AM_ASPECT_RATIO_MODE(3i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_ASPECT_RATIO_MODE(pub i32);
pub const AM_AUDREND_STAT_PARAM_BREAK_COUNT: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(1i32);
pub const AM_AUDREND_STAT_PARAM_BUFFERFULLNESS: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(11i32);
pub const AM_AUDREND_STAT_PARAM_DISCONTINUITIES: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(5i32);
pub const AM_AUDREND_STAT_PARAM_JITTER: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(12i32);
pub const AM_AUDREND_STAT_PARAM_LAST_BUFFER_DUR: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(4i32);
pub const AM_AUDREND_STAT_PARAM_SILENCE_DUR: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(3i32);
pub const AM_AUDREND_STAT_PARAM_SLAVE_ACCUMERROR: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(10i32);
pub const AM_AUDREND_STAT_PARAM_SLAVE_DROPWRITE_DUR: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(7i32);
pub const AM_AUDREND_STAT_PARAM_SLAVE_HIGHLOWERROR: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(8i32);
pub const AM_AUDREND_STAT_PARAM_SLAVE_LASTHIGHLOWERROR: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(9i32);
pub const AM_AUDREND_STAT_PARAM_SLAVE_MODE: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(2i32);
pub const AM_AUDREND_STAT_PARAM_SLAVE_RATE: _AM_AUDIO_RENDERER_STAT_PARAM = _AM_AUDIO_RENDERER_STAT_PARAM(6i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_COLCON {
    pub _bitfield1: u8,
    pub _bitfield2: u8,
    pub _bitfield3: u8,
    pub _bitfield4: u8,
}
impl Default for AM_COLCON {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AM_CONTENTPROPERTY_AUTHOR: u32 = 2u32;
pub const AM_CONTENTPROPERTY_COPYRIGHT: u32 = 4u32;
pub const AM_CONTENTPROPERTY_DESCRIPTION: u32 = 8u32;
pub const AM_CONTENTPROPERTY_TITLE: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_COPY_MACROVISION {
    pub MACROVISIONLevel: u32,
}
impl Default for AM_COPY_MACROVISION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_COPY_MACROVISION_LEVEL(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_DIGITAL_CP(pub i32);
pub const AM_DIGITAL_CP_DVD_COMPLIANT: AM_DIGITAL_CP = AM_DIGITAL_CP(2i32);
pub const AM_DIGITAL_CP_OFF: AM_DIGITAL_CP = AM_DIGITAL_CP(0i32);
pub const AM_DIGITAL_CP_ON: AM_DIGITAL_CP = AM_DIGITAL_CP(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_DVDCOPYSTATE(pub i32);
pub const AM_DVDCOPYSTATE_AUTHENTICATION_NOT_REQUIRED: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(2i32);
pub const AM_DVDCOPYSTATE_AUTHENTICATION_REQUIRED: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(3i32);
pub const AM_DVDCOPYSTATE_DONE: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(4i32);
pub const AM_DVDCOPYSTATE_INITIALIZE: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(0i32);
pub const AM_DVDCOPYSTATE_INITIALIZE_TITLE: AM_DVDCOPYSTATE = AM_DVDCOPYSTATE(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_DVDCOPY_BUSKEY {
    pub BusKey: [u8; 5],
    pub Reserved: [u8; 1],
}
impl Default for AM_DVDCOPY_BUSKEY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_DVDCOPY_CHLGKEY {
    pub ChlgKey: [u8; 10],
    pub Reserved: [u8; 2],
}
impl Default for AM_DVDCOPY_CHLGKEY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_DVDCOPY_DISCKEY {
    pub DiscKey: [u8; 2048],
}
impl Default for AM_DVDCOPY_DISCKEY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_DVDCOPY_SET_COPY_STATE {
    pub DVDCopyState: u32,
}
impl Default for AM_DVDCOPY_SET_COPY_STATE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_DVDCOPY_TITLEKEY {
    pub KeyFlags: u32,
    pub Reserved1: [u32; 2],
    pub TitleKey: [u8; 6],
    pub Reserved2: [u8; 2],
}
impl Default for AM_DVDCOPY_TITLEKEY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AM_DVD_ADAPT_GRAPH: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(16384i32);
pub const AM_DVD_CGMS_COPY_ONCE: u32 = 16u32;
pub const AM_DVD_CGMS_COPY_PERMITTED: u32 = 0u32;
pub const AM_DVD_CGMS_COPY_PROTECT_MASK: u32 = 24u32;
pub const AM_DVD_CGMS_NO_COPY: u32 = 24u32;
pub const AM_DVD_CGMS_RESERVED_MASK: u32 = 120u32;
pub const AM_DVD_COPYRIGHTED: u32 = 64u32;
pub const AM_DVD_COPYRIGHT_MASK: u32 = 64u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_DVD_ChangeRate {
    pub StartInTime: i64,
    pub StartOutTime: i64,
    pub Rate: i32,
}
impl Default for AM_DVD_ChangeRate {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AM_DVD_DO_NOT_CLEAR: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(512i32);
pub const AM_DVD_EVR_ONLY: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(4096i32);
pub const AM_DVD_EVR_QOS: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(8192i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_DVD_GRAPH_FLAGS(pub i32);
pub const AM_DVD_HWDEC_ONLY: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(2i32);
pub const AM_DVD_HWDEC_PREFER: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(1i32);
pub const AM_DVD_MASK: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(65535i32);
pub const AM_DVD_NOT_COPYRIGHTED: u32 = 0u32;
pub const AM_DVD_NOVPE: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(256i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_DVD_RENDERSTATUS {
    pub hrVPEStatus: windows_core::HRESULT,
    pub bDvdVolInvalid: windows_core::BOOL,
    pub bDvdVolUnknown: windows_core::BOOL,
    pub bNoLine21In: windows_core::BOOL,
    pub bNoLine21Out: windows_core::BOOL,
    pub iNumStreams: i32,
    pub iNumStreamsFailed: i32,
    pub dwFailedStreamsFlag: u32,
}
impl Default for AM_DVD_RENDERSTATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AM_DVD_SECTOR_NOT_PROTECTED: u32 = 0u32;
pub const AM_DVD_SECTOR_PROTECTED: u32 = 32u32;
pub const AM_DVD_SECTOR_PROTECT_MASK: u32 = 32u32;
pub const AM_DVD_STREAM_AUDIO: AM_DVD_STREAM_FLAGS = AM_DVD_STREAM_FLAGS(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_DVD_STREAM_FLAGS(pub i32);
pub const AM_DVD_STREAM_SUBPIC: AM_DVD_STREAM_FLAGS = AM_DVD_STREAM_FLAGS(4i32);
pub const AM_DVD_STREAM_VIDEO: AM_DVD_STREAM_FLAGS = AM_DVD_STREAM_FLAGS(1i32);
pub const AM_DVD_SWDEC_ONLY: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(8i32);
pub const AM_DVD_SWDEC_PREFER: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(4i32);
pub const AM_DVD_VMR9_ONLY: AM_DVD_GRAPH_FLAGS = AM_DVD_GRAPH_FLAGS(2048i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_DVD_YUV {
    pub Reserved: u8,
    pub Y: u8,
    pub U: u8,
    pub V: u8,
}
impl Default for AM_DVD_YUV {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_DvdKaraokeData {
    pub dwDownmix: u32,
    pub dwSpeakerAssignment: u32,
}
impl Default for AM_DvdKaraokeData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AM_EXSEEK_BUFFERING: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(32i32);
pub const AM_EXSEEK_CANSCAN: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(2i32);
pub const AM_EXSEEK_CANSEEK: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(1i32);
pub const AM_EXSEEK_MARKERSEEK: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(4i32);
pub const AM_EXSEEK_NOSTANDARDREPAINT: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(16i32);
pub const AM_EXSEEK_SCANWITHOUTCLOCK: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(8i32);
pub const AM_EXSEEK_SENDS_VIDEOFRAMEREADY: AMExtendedSeekingCapabilities = AMExtendedSeekingCapabilities(64i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_ExactRateChange {
    pub OutputZeroTime: i64,
    pub Rate: i32,
}
impl Default for AM_ExactRateChange {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_FILESINK_FLAGS(pub i32);
pub const AM_FILE_OVERWRITE: AM_FILESINK_FLAGS = AM_FILESINK_FLAGS(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_FILTER_FLAGS(pub i32);
pub const AM_FILTER_FLAGS_REMOVABLE: AM_FILTER_FLAGS = AM_FILTER_FLAGS(1i32);
pub const AM_FILTER_MISC_FLAGS_IS_RENDERER: _AM_FILTER_MISC_FLAGS = _AM_FILTER_MISC_FLAGS(1i32);
pub const AM_FILTER_MISC_FLAGS_IS_SOURCE: _AM_FILTER_MISC_FLAGS = _AM_FILTER_MISC_FLAGS(2i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_FRAMESTEP_STEP {
    pub dwFramesToStep: u32,
}
impl Default for AM_FRAMESTEP_STEP {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AM_GBF_NODDSURFACELOCK: u32 = 8u32;
pub const AM_GBF_NOTASYNCPOINT: u32 = 2u32;
pub const AM_GBF_NOWAIT: u32 = 4u32;
pub const AM_GBF_PREVFRAMESKIPPED: u32 = 1u32;
pub const AM_GETDECODERCAP_QUERY_EVR_SUPPORT: u32 = 7u32;
pub const AM_GETDECODERCAP_QUERY_VMR9_SUPPORT: u32 = 6u32;
pub const AM_GETDECODERCAP_QUERY_VMR_SUPPORT: u32 = 1u32;
pub const AM_GRAPH_CONFIG_RECONNECT_CACHE_REMOVED_FILTERS: AM_GRAPH_CONFIG_RECONNECT_FLAGS = AM_GRAPH_CONFIG_RECONNECT_FLAGS(2i32);
pub const AM_GRAPH_CONFIG_RECONNECT_DIRECTCONNECT: AM_GRAPH_CONFIG_RECONNECT_FLAGS = AM_GRAPH_CONFIG_RECONNECT_FLAGS(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_GRAPH_CONFIG_RECONNECT_FLAGS(pub i32);
pub const AM_GRAPH_CONFIG_RECONNECT_USE_ONLY_CACHED_FILTERS: AM_GRAPH_CONFIG_RECONNECT_FLAGS = AM_GRAPH_CONFIG_RECONNECT_FLAGS(4i32);
pub const AM_INTERFACESETID_Standard: windows_core::GUID = windows_core::GUID::from_u128(0x1a8766a0_62ce_11cf_a5d6_28db04c10000);
pub const AM_INTF_SEARCH_FILTER: _AM_INTF_SEARCH_FLAGS = _AM_INTF_SEARCH_FLAGS(4i32);
pub const AM_INTF_SEARCH_INPUT_PIN: _AM_INTF_SEARCH_FLAGS = _AM_INTF_SEARCH_FLAGS(1i32);
pub const AM_INTF_SEARCH_OUTPUT_PIN: _AM_INTF_SEARCH_FLAGS = _AM_INTF_SEARCH_FLAGS(2i32);
pub const AM_KSCATEGORY_AUDIO: windows_core::GUID = windows_core::GUID::from_u128(0x6994ad04_93ef_11d0_a3cc_00a0c9223196);
pub const AM_KSCATEGORY_CAPTURE: windows_core::GUID = windows_core::GUID::from_u128(0x65e8773d_8f56_11d0_a3b9_00a0c9223196);
pub const AM_KSCATEGORY_CROSSBAR: windows_core::GUID = windows_core::GUID::from_u128(0xa799a801_a46d_11d0_a18c_00a02401dcd4);
pub const AM_KSCATEGORY_DATACOMPRESSOR: windows_core::GUID = windows_core::GUID::from_u128(0x1e84c900_7e70_11d0_a5d6_28db04c10000);
pub const AM_KSCATEGORY_RENDER: windows_core::GUID = windows_core::GUID::from_u128(0x65e8773e_8f56_11d0_a3b9_00a0c9223196);
pub const AM_KSCATEGORY_SPLITTER: windows_core::GUID = windows_core::GUID::from_u128(0x0a4252a0_7e70_11d0_a5d6_28db04c10000);
pub const AM_KSCATEGORY_TVAUDIO: windows_core::GUID = windows_core::GUID::from_u128(0xa799a802_a46d_11d0_a18c_00a02401dcd4);
pub const AM_KSCATEGORY_TVTUNER: windows_core::GUID = windows_core::GUID::from_u128(0xa799a800_a46d_11d0_a18c_00a02401dcd4);
pub const AM_KSCATEGORY_VBICODEC: windows_core::GUID = windows_core::GUID::from_u128(0x07dad660_22f1_11d1_a9f4_00c04fbbde8f);
pub const AM_KSCATEGORY_VBICODEC_MI: windows_core::GUID = windows_core::GUID::from_u128(0x9c24a977_0951_451a_8006_0e49bd28cd5f);
pub const AM_KSCATEGORY_VIDEO: windows_core::GUID = windows_core::GUID::from_u128(0x6994ad05_93ef_11d0_a3cc_00a0c9223196);
pub const AM_KSPROPSETID_AC3: windows_core::GUID = windows_core::GUID::from_u128(0xbfabe720_6e1f_11d0_bcf2_444553540000);
pub const AM_KSPROPSETID_CopyProt: windows_core::GUID = windows_core::GUID::from_u128(0x0e8a0a40_6aef_11d0_9ed0_00a024ca19b3);
pub const AM_KSPROPSETID_DVD_RateChange: windows_core::GUID = windows_core::GUID::from_u128(0x3577eb09_9582_477f_b29c_b0c452a4ff9a);
pub const AM_KSPROPSETID_DvdKaraoke: windows_core::GUID = windows_core::GUID::from_u128(0xae4720ae_aa71_42d8_b82a_fffdf58b76fd);
pub const AM_KSPROPSETID_DvdSubPic: windows_core::GUID = windows_core::GUID::from_u128(0xac390460_43af_11d0_bd6a_003505c103a9);
pub const AM_KSPROPSETID_FrameStep: windows_core::GUID = windows_core::GUID::from_u128(0xc830acbd_ab07_492f_8852_45b6987c2979);
pub const AM_KSPROPSETID_MPEG4_MediaType_Attributes: windows_core::GUID = windows_core::GUID::from_u128(0xff6c4bfa_07a9_4c7b_a237_672f9d68065f);
pub const AM_KSPROPSETID_TSRateChange: windows_core::GUID = windows_core::GUID::from_u128(0xa503c5c0_1d1d_11d1_ad80_444553540000);
pub const AM_L21_CCLEVEL_TC2: AM_LINE21_CCLEVEL = AM_LINE21_CCLEVEL(0i32);
pub const AM_L21_CCSERVICE_Caption1: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(1i32);
pub const AM_L21_CCSERVICE_Caption2: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(2i32);
pub const AM_L21_CCSERVICE_DefChannel: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(10i32);
pub const AM_L21_CCSERVICE_Invalid: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(11i32);
pub const AM_L21_CCSERVICE_None: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(0i32);
pub const AM_L21_CCSERVICE_Text1: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(3i32);
pub const AM_L21_CCSERVICE_Text2: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(4i32);
pub const AM_L21_CCSERVICE_XDS: AM_LINE21_CCSERVICE = AM_LINE21_CCSERVICE(5i32);
pub const AM_L21_CCSTATE_Off: AM_LINE21_CCSTATE = AM_LINE21_CCSTATE(0i32);
pub const AM_L21_CCSTATE_On: AM_LINE21_CCSTATE = AM_LINE21_CCSTATE(1i32);
pub const AM_L21_CCSTYLE_None: AM_LINE21_CCSTYLE = AM_LINE21_CCSTYLE(0i32);
pub const AM_L21_CCSTYLE_PaintOn: AM_LINE21_CCSTYLE = AM_LINE21_CCSTYLE(2i32);
pub const AM_L21_CCSTYLE_PopOn: AM_LINE21_CCSTYLE = AM_LINE21_CCSTYLE(1i32);
pub const AM_L21_CCSTYLE_RollUp: AM_LINE21_CCSTYLE = AM_LINE21_CCSTYLE(3i32);
pub const AM_L21_DRAWBGMODE_Opaque: AM_LINE21_DRAWBGMODE = AM_LINE21_DRAWBGMODE(0i32);
pub const AM_L21_DRAWBGMODE_Transparent: AM_LINE21_DRAWBGMODE = AM_LINE21_DRAWBGMODE(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_LINE21_CCLEVEL(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_LINE21_CCSERVICE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_LINE21_CCSTATE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_LINE21_CCSTYLE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_LINE21_DRAWBGMODE(pub i32);
pub const AM_LOADSTATUS_CLOSED: u32 = 0u32;
pub const AM_LOADSTATUS_CONNECTING: u32 = 4u32;
pub const AM_LOADSTATUS_LOADINGDESCR: u32 = 1u32;
pub const AM_LOADSTATUS_LOADINGMCAST: u32 = 2u32;
pub const AM_LOADSTATUS_LOCATING: u32 = 3u32;
pub const AM_LOADSTATUS_OPEN: u32 = 6u32;
pub const AM_LOADSTATUS_OPENING: u32 = 5u32;
pub const AM_MACROVISION_DISABLED: AM_COPY_MACROVISION_LEVEL = AM_COPY_MACROVISION_LEVEL(0i32);
pub const AM_MACROVISION_LEVEL1: AM_COPY_MACROVISION_LEVEL = AM_COPY_MACROVISION_LEVEL(1i32);
pub const AM_MACROVISION_LEVEL2: AM_COPY_MACROVISION_LEVEL = AM_COPY_MACROVISION_LEVEL(2i32);
pub const AM_MACROVISION_LEVEL3: AM_COPY_MACROVISION_LEVEL = AM_COPY_MACROVISION_LEVEL(3i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_MEDIAEVENT_FLAGS(pub i32);
pub const AM_MEDIAEVENT_NONOTIFY: AM_MEDIAEVENT_FLAGS = AM_MEDIAEVENT_FLAGS(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_MPEG2Level(pub i32);
pub const AM_MPEG2Level_High: AM_MPEG2Level = AM_MPEG2Level(4i32);
pub const AM_MPEG2Level_High1440: AM_MPEG2Level = AM_MPEG2Level(3i32);
pub const AM_MPEG2Level_Low: AM_MPEG2Level = AM_MPEG2Level(1i32);
pub const AM_MPEG2Level_Main: AM_MPEG2Level = AM_MPEG2Level(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_MPEG2Profile(pub i32);
pub const AM_MPEG2Profile_High: AM_MPEG2Profile = AM_MPEG2Profile(5i32);
pub const AM_MPEG2Profile_Main: AM_MPEG2Profile = AM_MPEG2Profile(2i32);
pub const AM_MPEG2Profile_SNRScalable: AM_MPEG2Profile = AM_MPEG2Profile(3i32);
pub const AM_MPEG2Profile_Simple: AM_MPEG2Profile = AM_MPEG2Profile(1i32);
pub const AM_MPEG2Profile_SpatiallyScalable: AM_MPEG2Profile = AM_MPEG2Profile(4i32);
#[repr(C)]
#[cfg(feature = "Win32_Media_MediaFoundation")]
#[derive(Clone, Debug, PartialEq)]
pub struct AM_MPEGSTREAMTYPE {
    pub dwStreamId: u32,
    pub dwReserved: u32,
    pub mt: super::MediaFoundation::AM_MEDIA_TYPE,
    pub bFormat: [u8; 1],
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl Default for AM_MPEGSTREAMTYPE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Media_MediaFoundation")]
#[derive(Clone, Debug, PartialEq)]
pub struct AM_MPEGSYSTEMTYPE {
    pub dwBitRate: u32,
    pub cStreams: u32,
    pub Streams: [AM_MPEGSTREAMTYPE; 1],
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl Default for AM_MPEGSYSTEMTYPE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AM_MPEG_AUDIO_DUAL_LEFT: u32 = 1u32;
pub const AM_MPEG_AUDIO_DUAL_MERGE: u32 = 0u32;
pub const AM_MPEG_AUDIO_DUAL_RIGHT: u32 = 2u32;
pub const AM_OVERLAY_NOTIFY_DEST_CHANGE: _AM_OVERLAY_NOTIFY_FLAGS = _AM_OVERLAY_NOTIFY_FLAGS(4i32);
pub const AM_OVERLAY_NOTIFY_SOURCE_CHANGE: _AM_OVERLAY_NOTIFY_FLAGS = _AM_OVERLAY_NOTIFY_FLAGS(2i32);
pub const AM_OVERLAY_NOTIFY_VISIBLE_CHANGE: _AM_OVERLAY_NOTIFY_FLAGS = _AM_OVERLAY_NOTIFY_FLAGS(1i32);
pub const AM_PIN_FLOW_CONTROL_BLOCK: _AM_PIN_FLOW_CONTROL_BLOCK_FLAGS = _AM_PIN_FLOW_CONTROL_BLOCK_FLAGS(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_PROPERTY_AC3(pub i32);
pub const AM_PROPERTY_AC3_ALTERNATE_AUDIO: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(2i32);
pub const AM_PROPERTY_AC3_BIT_STREAM_MODE: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(4i32);
pub const AM_PROPERTY_AC3_DIALOGUE_LEVEL: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(5i32);
pub const AM_PROPERTY_AC3_DOWNMIX: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(3i32);
pub const AM_PROPERTY_AC3_ERROR_CONCEALMENT: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(1i32);
pub const AM_PROPERTY_AC3_LANGUAGE_CODE: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(6i32);
pub const AM_PROPERTY_AC3_ROOM_TYPE: AM_PROPERTY_AC3 = AM_PROPERTY_AC3(7i32);
pub const AM_PROPERTY_COPY_ANALOG_COMPONENT: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(8i32);
pub const AM_PROPERTY_COPY_DIGITAL_CP: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(9i32);
pub const AM_PROPERTY_COPY_DVD_SRM: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(10i32);
pub const AM_PROPERTY_COPY_MACROVISION: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(5i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_PROPERTY_DVDCOPYPROT(pub i32);
pub const AM_PROPERTY_DVDCOPY_CHLG_KEY: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(1i32);
pub const AM_PROPERTY_DVDCOPY_DEC_KEY2: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(3i32);
pub const AM_PROPERTY_DVDCOPY_DISC_KEY: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(128i32);
pub const AM_PROPERTY_DVDCOPY_DVD_KEY1: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(2i32);
pub const AM_PROPERTY_DVDCOPY_REGION: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(6i32);
pub const AM_PROPERTY_DVDCOPY_SET_COPY_STATE: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(7i32);
pub const AM_PROPERTY_DVDCOPY_SUPPORTS_NEW_KEYCOUNT: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(11i32);
pub const AM_PROPERTY_DVDCOPY_TITLE_KEY: AM_PROPERTY_DVDCOPYPROT = AM_PROPERTY_DVDCOPYPROT(4i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_PROPERTY_DVDKARAOKE(pub i32);
pub const AM_PROPERTY_DVDKARAOKE_DATA: AM_PROPERTY_DVDKARAOKE = AM_PROPERTY_DVDKARAOKE(1i32);
pub const AM_PROPERTY_DVDKARAOKE_ENABLE: AM_PROPERTY_DVDKARAOKE = AM_PROPERTY_DVDKARAOKE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_PROPERTY_DVDSUBPIC(pub i32);
pub const AM_PROPERTY_DVDSUBPIC_COMPOSIT_ON: AM_PROPERTY_DVDSUBPIC = AM_PROPERTY_DVDSUBPIC(2i32);
pub const AM_PROPERTY_DVDSUBPIC_HLI: AM_PROPERTY_DVDSUBPIC = AM_PROPERTY_DVDSUBPIC(1i32);
pub const AM_PROPERTY_DVDSUBPIC_PALETTE: AM_PROPERTY_DVDSUBPIC = AM_PROPERTY_DVDSUBPIC(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_PROPERTY_DVD_RATE_CHANGE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_PROPERTY_FRAMESTEP(pub i32);
pub const AM_PROPERTY_FRAMESTEP_CANCEL: AM_PROPERTY_FRAMESTEP = AM_PROPERTY_FRAMESTEP(2i32);
pub const AM_PROPERTY_FRAMESTEP_CANSTEP: AM_PROPERTY_FRAMESTEP = AM_PROPERTY_FRAMESTEP(3i32);
pub const AM_PROPERTY_FRAMESTEP_CANSTEPMULTIPLE: AM_PROPERTY_FRAMESTEP = AM_PROPERTY_FRAMESTEP(4i32);
pub const AM_PROPERTY_FRAMESTEP_STEP: AM_PROPERTY_FRAMESTEP = AM_PROPERTY_FRAMESTEP(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_PROPERTY_SPHLI {
    pub HLISS: u16,
    pub Reserved: u16,
    pub StartPTM: u32,
    pub EndPTM: u32,
    pub StartX: u16,
    pub StartY: u16,
    pub StopX: u16,
    pub StopY: u16,
    pub ColCon: AM_COLCON,
}
impl Default for AM_PROPERTY_SPHLI {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_PROPERTY_SPPAL {
    pub sppal: [AM_DVD_YUV; 16],
}
impl Default for AM_PROPERTY_SPPAL {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_PROPERTY_TS_RATE_CHANGE(pub i32);
pub const AM_PUSHSOURCECAPS_INTERNAL_RM: _AM_PUSHSOURCE_FLAGS = _AM_PUSHSOURCE_FLAGS(1i32);
pub const AM_PUSHSOURCECAPS_NOT_LIVE: _AM_PUSHSOURCE_FLAGS = _AM_PUSHSOURCE_FLAGS(2i32);
pub const AM_PUSHSOURCECAPS_PRIVATE_CLOCK: _AM_PUSHSOURCE_FLAGS = _AM_PUSHSOURCE_FLAGS(4i32);
pub const AM_PUSHSOURCEREQS_USE_CLOCK_CHAIN: _AM_PUSHSOURCE_FLAGS = _AM_PUSHSOURCE_FLAGS(131072i32);
pub const AM_PUSHSOURCEREQS_USE_STREAM_CLOCK: _AM_PUSHSOURCE_FLAGS = _AM_PUSHSOURCE_FLAGS(65536i32);
pub const AM_QUERY_DECODER_ATSC_HD_SUPPORT: u32 = 5u32;
pub const AM_QUERY_DECODER_ATSC_SD_SUPPORT: u32 = 4u32;
pub const AM_QUERY_DECODER_DVD_SUPPORT: u32 = 3u32;
pub const AM_QUERY_DECODER_DXVA_1_SUPPORT: u32 = 2u32;
pub const AM_QUERY_DECODER_VMR_SUPPORT: u32 = 1u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_QueryRate {
    pub lMaxForwardFullFrame: i32,
    pub lMaxReverseFullFrame: i32,
}
impl Default for AM_QueryRate {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AM_RATE_ChangeRate: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(1i32);
pub const AM_RATE_CorrectTS: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(8i32);
pub const AM_RATE_DecoderPosition: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(4i32);
pub const AM_RATE_DecoderVersion: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(5i32);
pub const AM_RATE_ExactRateChange: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(2i32);
pub const AM_RATE_FullDataRateMax: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(2i32);
pub const AM_RATE_MaxFullDataRate: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(3i32);
pub const AM_RATE_QueryFullFrameRate: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(6i32);
pub const AM_RATE_QueryLastRateSegPTS: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(7i32);
pub const AM_RATE_QueryMapping: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(11i32);
pub const AM_RATE_ResetOnTimeDisc: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(10i32);
pub const AM_RATE_ReverseDecode: AM_PROPERTY_DVD_RATE_CHANGE = AM_PROPERTY_DVD_RATE_CHANGE(3i32);
pub const AM_RATE_ReverseMaxFullDataRate: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(9i32);
pub const AM_RATE_SimpleRateChange: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(1i32);
pub const AM_RATE_Step: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(4i32);
pub const AM_RATE_UseRateVersion: AM_PROPERTY_TS_RATE_CHANGE = AM_PROPERTY_TS_RATE_CHANGE(5i32);
pub const AM_RENDEREX_RENDERTOEXISTINGRENDERERS: _AM_RENSDEREXFLAGS = _AM_RENSDEREXFLAGS(1i32);
pub const AM_ReverseBlockEnd: u32 = 4u32;
pub const AM_ReverseBlockStart: u32 = 2u32;
#[repr(C)]
#[cfg(feature = "Win32_Media_MediaFoundation")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_SAMPLE2_PROPERTIES {
    pub cbData: u32,
    pub dwTypeSpecificFlags: u32,
    pub dwSampleFlags: u32,
    pub lActual: i32,
    pub tStart: i64,
    pub tStop: i64,
    pub dwStreamId: u32,
    pub pMediaType: *mut super::MediaFoundation::AM_MEDIA_TYPE,
    pub pbBuffer: *mut u8,
    pub cbBuffer: i32,
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl Default for AM_SAMPLE2_PROPERTIES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AM_SAMPLE_DATADISCONTINUITY: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(4i32);
pub const AM_SAMPLE_ENDOFSTREAM: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(512i32);
pub const AM_SAMPLE_FLUSH_ON_PAUSE: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(128i32);
pub const AM_SAMPLE_PREROLL: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_SAMPLE_PROPERTY_FLAGS(pub i32);
pub const AM_SAMPLE_SPLICEPOINT: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(1i32);
pub const AM_SAMPLE_STOPVALID: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(256i32);
pub const AM_SAMPLE_TIMEDISCONTINUITY: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(64i32);
pub const AM_SAMPLE_TIMEVALID: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(16i32);
pub const AM_SAMPLE_TYPECHANGED: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(8i32);
pub const AM_SEEKING_AbsolutePositioning: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(1i32);
pub const AM_SEEKING_CanDoSegments: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(128i32);
pub const AM_SEEKING_CanGetCurrentPos: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(8i32);
pub const AM_SEEKING_CanGetDuration: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(32i32);
pub const AM_SEEKING_CanGetStopPos: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(16i32);
pub const AM_SEEKING_CanPlayBackwards: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(64i32);
pub const AM_SEEKING_CanSeekAbsolute: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(1i32);
pub const AM_SEEKING_CanSeekBackwards: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(4i32);
pub const AM_SEEKING_CanSeekForwards: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(2i32);
pub const AM_SEEKING_IncrementalPositioning: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(3i32);
pub const AM_SEEKING_NoFlush: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(32i32);
pub const AM_SEEKING_NoPositioning: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(0i32);
pub const AM_SEEKING_PositioningBitsMask: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(3i32);
pub const AM_SEEKING_RelativePositioning: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(2i32);
pub const AM_SEEKING_ReturnTime: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(8i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_SEEKING_SEEKING_CAPABILITIES(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_SEEKING_SEEKING_FLAGS(pub i32);
pub const AM_SEEKING_SeekToKeyFrame: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(4i32);
pub const AM_SEEKING_Segment: AM_SEEKING_SEEKING_FLAGS = AM_SEEKING_SEEKING_FLAGS(16i32);
pub const AM_SEEKING_Source: AM_SEEKING_SEEKING_CAPABILITIES = AM_SEEKING_SEEKING_CAPABILITIES(256i32);
pub const AM_STREAM_CONTROL: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_STREAM_INFO {
    pub tStart: i64,
    pub tStop: i64,
    pub dwStartCookie: u32,
    pub dwStopCookie: u32,
    pub dwFlags: u32,
}
impl Default for AM_STREAM_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AM_STREAM_INFO_DISCARDING: AM_STREAM_INFO_FLAGS = AM_STREAM_INFO_FLAGS(4i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_STREAM_INFO_FLAGS(pub i32);
pub const AM_STREAM_INFO_START_DEFINED: AM_STREAM_INFO_FLAGS = AM_STREAM_INFO_FLAGS(1i32);
pub const AM_STREAM_INFO_STOP_DEFINED: AM_STREAM_INFO_FLAGS = AM_STREAM_INFO_FLAGS(2i32);
pub const AM_STREAM_INFO_STOP_SEND_EXTRA: AM_STREAM_INFO_FLAGS = AM_STREAM_INFO_FLAGS(16i32);
pub const AM_STREAM_MEDIA: AM_SAMPLE_PROPERTY_FLAGS = AM_SAMPLE_PROPERTY_FLAGS(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_SimpleRateChange {
    pub StartTime: i64,
    pub Rate: i32,
}
impl Default for AM_SimpleRateChange {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AM_UseNewCSSKey: u32 = 1u32;
pub const AM_VIDEO_FLAG_B_SAMPLE: i32 = 32i32;
pub const AM_VIDEO_FLAG_FIELD1: i32 = 1i32;
pub const AM_VIDEO_FLAG_FIELD1FIRST: i32 = 4i32;
pub const AM_VIDEO_FLAG_FIELD2: i32 = 2i32;
pub const AM_VIDEO_FLAG_FIELD_MASK: i32 = 3i32;
pub const AM_VIDEO_FLAG_INTERLEAVED_FRAME: i32 = 0i32;
pub const AM_VIDEO_FLAG_IPB_MASK: i32 = 48i32;
pub const AM_VIDEO_FLAG_I_SAMPLE: i32 = 0i32;
pub const AM_VIDEO_FLAG_P_SAMPLE: i32 = 16i32;
pub const AM_VIDEO_FLAG_REPEAT_FIELD: i32 = 64i32;
pub const AM_VIDEO_FLAG_WEAVE: i32 = 8i32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_WST_DRAWBGMODE(pub i32);
pub const AM_WST_DRAWBGMODE_Opaque: AM_WST_DRAWBGMODE = AM_WST_DRAWBGMODE(0i32);
pub const AM_WST_DRAWBGMODE_Transparent: AM_WST_DRAWBGMODE = AM_WST_DRAWBGMODE(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_WST_LEVEL(pub i32);
pub const AM_WST_LEVEL_1_5: AM_WST_LEVEL = AM_WST_LEVEL(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AM_WST_PAGE {
    pub dwPageNr: u32,
    pub dwSubPageNr: u32,
    pub pucPageData: *mut u8,
}
impl Default for AM_WST_PAGE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_WST_SERVICE(pub i32);
pub const AM_WST_SERVICE_IDS: AM_WST_SERVICE = AM_WST_SERVICE(2i32);
pub const AM_WST_SERVICE_Invalid: AM_WST_SERVICE = AM_WST_SERVICE(3i32);
pub const AM_WST_SERVICE_None: AM_WST_SERVICE = AM_WST_SERVICE(0i32);
pub const AM_WST_SERVICE_Text: AM_WST_SERVICE = AM_WST_SERVICE(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_WST_STATE(pub i32);
pub const AM_WST_STATE_Off: AM_WST_STATE = AM_WST_STATE(0i32);
pub const AM_WST_STATE_On: AM_WST_STATE = AM_WST_STATE(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AM_WST_STYLE(pub i32);
pub const AM_WST_STYLE_Invers: AM_WST_STYLE = AM_WST_STYLE(1i32);
pub const AM_WST_STYLE_None: AM_WST_STYLE = AM_WST_STYLE(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct ANALOGVIDEOINFO {
    pub rcSource: super::super::Foundation::RECT,
    pub rcTarget: super::super::Foundation::RECT,
    pub dwActiveWidth: u32,
    pub dwActiveHeight: u32,
    pub AvgTimePerFrame: i64,
}
impl Default for ANALOGVIDEOINFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const ANNEX_A_DSM_CC: MPEG2StreamType = MPEG2StreamType(8i32);
pub const ATSCCT_AC3: ATSCComponentTypeFlags = ATSCComponentTypeFlags(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ATSCComponentTypeFlags(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AUDIO_STREAM_CONFIG_CAPS {
    pub guid: windows_core::GUID,
    pub MinimumChannels: u32,
    pub MaximumChannels: u32,
    pub ChannelsGranularity: u32,
    pub MinimumBitsPerSample: u32,
    pub MaximumBitsPerSample: u32,
    pub BitsPerSampleGranularity: u32,
    pub MinimumSampleFrequency: u32,
    pub MaximumSampleFrequency: u32,
    pub SampleFrequencyGranularity: u32,
}
impl Default for AUDIO_STREAM_CONFIG_CAPS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVIEXTHEADER {
    pub fcc: u32,
    pub cb: u32,
    pub dwGrandFrames: u32,
    pub dwFuture: [u32; 61],
}
impl Default for AVIEXTHEADER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVIFIELDINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub qwBaseOffset: u64,
    pub dwReserved3: u32,
    pub aIndex: [AVIFIELDINDEX_0; 1],
}
impl Default for AVIFIELDINDEX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVIFIELDINDEX_0 {
    pub dwOffset: u32,
    pub dwSize: u32,
    pub dwOffsetField2: u32,
}
impl Default for AVIFIELDINDEX_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AVIF_COPYRIGHTED: u32 = 131072u32;
pub const AVIF_HASINDEX: u32 = 16u32;
pub const AVIF_ISINTERLEAVED: u32 = 256u32;
pub const AVIF_MUSTUSEINDEX: u32 = 32u32;
pub const AVIF_TRUSTCKTYPE: u32 = 2048u32;
pub const AVIF_WASCAPTUREFILE: u32 = 65536u32;
pub const AVIIF_COMPRESSOR: u32 = 268369920u32;
pub const AVIIF_COMPUSE: i32 = 268369920i32;
pub const AVIIF_FIRSTPART: i32 = 32i32;
pub const AVIIF_KEYFRAME: i32 = 16i32;
pub const AVIIF_LASTPART: i32 = 64i32;
pub const AVIIF_LIST: i32 = 1i32;
pub const AVIIF_NOTIME: i32 = 256i32;
pub const AVIIF_NO_TIME: u32 = 256u32;
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AVIINDEXENTRY {
    pub ckid: u32,
    pub dwFlags: u32,
    pub dwChunkOffset: u32,
    pub dwChunkLength: u32,
}
impl Default for AVIINDEXENTRY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVIMAINHEADER {
    pub fcc: u32,
    pub cb: u32,
    pub dwMicroSecPerFrame: u32,
    pub dwMaxBytesPerSec: u32,
    pub dwPaddingGranularity: u32,
    pub dwFlags: u32,
    pub dwTotalFrames: u32,
    pub dwInitialFrames: u32,
    pub dwStreams: u32,
    pub dwSuggestedBufferSize: u32,
    pub dwWidth: u32,
    pub dwHeight: u32,
    pub dwReserved: [u32; 4],
}
impl Default for AVIMAINHEADER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVIMETAINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub dwReserved: [u32; 3],
    pub adwIndex: [u32; 1],
}
impl Default for AVIMETAINDEX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVIOLDINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub aIndex: [AVIOLDINDEX_0; 1],
}
impl Default for AVIOLDINDEX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVIOLDINDEX_0 {
    pub dwChunkId: u32,
    pub dwFlags: u32,
    pub dwOffset: u32,
    pub dwSize: u32,
}
impl Default for AVIOLDINDEX_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AVIPALCHANGE {
    pub bFirstEntry: u8,
    pub bNumEntries: u8,
    pub wFlags: u16,
    pub peNew: [super::super::Graphics::Gdi::PALETTEENTRY; 1],
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl Default for AVIPALCHANGE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AVISF_DISABLED: u32 = 1u32;
pub const AVISF_VIDEO_PALCHANGES: u32 = 65536u32;
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVISTDINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub qwBaseOffset: u64,
    pub dwReserved_3: u32,
    pub aIndex: [AVISTDINDEX_ENTRY; 2044],
}
impl Default for AVISTDINDEX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AVISTDINDEX_DELTAFRAME: u32 = 2147483648u32;
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVISTDINDEX_ENTRY {
    pub dwOffset: u32,
    pub dwSize: u32,
}
impl Default for AVISTDINDEX_ENTRY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVISTREAMHEADER {
    pub fcc: u32,
    pub cb: u32,
    pub fccType: u32,
    pub fccHandler: u32,
    pub dwFlags: u32,
    pub wPriority: u16,
    pub wLanguage: u16,
    pub dwInitialFrames: u32,
    pub dwScale: u32,
    pub dwRate: u32,
    pub dwStart: u32,
    pub dwLength: u32,
    pub dwSuggestedBufferSize: u32,
    pub dwQuality: u32,
    pub dwSampleSize: u32,
    pub rcFrame: AVISTREAMHEADER_0,
}
impl Default for AVISTREAMHEADER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AVISTREAMHEADER_0 {
    pub left: i16,
    pub top: i16,
    pub right: i16,
    pub bottom: i16,
}
impl Default for AVISTREAMHEADER_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVISUPERINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub dwReserved: [u32; 3],
    pub aIndex: [AVISUPERINDEX_0; 1022],
}
impl Default for AVISUPERINDEX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVISUPERINDEX_0 {
    pub qwOffset: u64,
    pub dwSize: u32,
    pub dwDuration: u32,
}
impl Default for AVISUPERINDEX_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AVIStreamHeader {
    pub fccType: u32,
    pub fccHandler: u32,
    pub dwFlags: u32,
    pub wPriority: u16,
    pub wLanguage: u16,
    pub dwInitialFrames: u32,
    pub dwScale: u32,
    pub dwRate: u32,
    pub dwStart: u32,
    pub dwLength: u32,
    pub dwSuggestedBufferSize: u32,
    pub dwQuality: u32,
    pub dwSampleSize: u32,
    pub rcFrame: super::super::Foundation::RECT,
}
impl Default for AVIStreamHeader {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVITCDLINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub dwReserved: [u32; 3],
    pub aIndex: [AVITCDLINDEX_ENTRY; 584],
    pub adwTrailingFill: [u32; 3512],
}
impl Default for AVITCDLINDEX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVITCDLINDEX_ENTRY {
    pub dwTick: u32,
    pub time: super::TIMECODE,
    pub dwSMPTEflags: u32,
    pub dwUser: u32,
    pub szReelId: [i8; 12],
}
impl Default for AVITCDLINDEX_ENTRY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVITIMECODEINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub dwReserved: [u32; 3],
    pub aIndex: [TIMECODEDATA; 1022],
}
impl Default for AVITIMECODEINDEX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVITIMEDINDEX {
    pub fcc: u32,
    pub cb: u32,
    pub wLongsPerEntry: u16,
    pub bIndexSubType: u8,
    pub bIndexType: u8,
    pub nEntriesInUse: u32,
    pub dwChunkId: u32,
    pub qwBaseOffset: u64,
    pub dwReserved_3: u32,
    pub aIndex: [AVITIMEDINDEX_ENTRY; 1362],
    pub adwTrailingFill: [u32; 2734],
}
impl Default for AVITIMEDINDEX {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct AVITIMEDINDEX_ENTRY {
    pub dwOffset: u32,
    pub dwSize: u32,
    pub dwDuration: u32,
}
impl Default for AVITIMEDINDEX_ENTRY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const AVI_HEADERSIZE: u32 = 2048u32;
pub const AVI_INDEX_IS_DATA: u32 = 128u32;
pub const AVI_INDEX_OF_CHUNKS: u32 = 1u32;
pub const AVI_INDEX_OF_INDEXES: u32 = 0u32;
pub const AVI_INDEX_OF_SUB_2FIELD: u32 = 3u32;
pub const AVI_INDEX_OF_TIMED_CHUNKS: u32 = 2u32;
pub const AVI_INDEX_SUB_2FIELD: u32 = 1u32;
pub const AVI_INDEX_SUB_DEFAULT: u32 = 0u32;
pub const AnalogVideoMask_MCE_NTSC: AnalogVideoStandard = AnalogVideoStandard(1052167i32);
pub const AnalogVideoMask_MCE_PAL: AnalogVideoStandard = AnalogVideoStandard(496i32);
pub const AnalogVideoMask_MCE_SECAM: AnalogVideoStandard = AnalogVideoStandard(1044480i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct AnalogVideoStandard(pub i32);
pub const AnalogVideo_NTSC_433: AnalogVideoStandard = AnalogVideoStandard(4i32);
pub const AnalogVideo_NTSC_M: AnalogVideoStandard = AnalogVideoStandard(1i32);
pub const AnalogVideo_NTSC_M_J: AnalogVideoStandard = AnalogVideoStandard(2i32);
pub const AnalogVideo_NTSC_Mask: u32 = 7u32;
pub const AnalogVideo_None: AnalogVideoStandard = AnalogVideoStandard(0i32);
pub const AnalogVideo_PAL_60: AnalogVideoStandard = AnalogVideoStandard(2048i32);
pub const AnalogVideo_PAL_B: AnalogVideoStandard = AnalogVideoStandard(16i32);
pub const AnalogVideo_PAL_D: AnalogVideoStandard = AnalogVideoStandard(32i32);
pub const AnalogVideo_PAL_G: AnalogVideoStandard = AnalogVideoStandard(64i32);
pub const AnalogVideo_PAL_H: AnalogVideoStandard = AnalogVideoStandard(128i32);
pub const AnalogVideo_PAL_I: AnalogVideoStandard = AnalogVideoStandard(256i32);
pub const AnalogVideo_PAL_M: AnalogVideoStandard = AnalogVideoStandard(512i32);
pub const AnalogVideo_PAL_Mask: u32 = 1052656u32;
pub const AnalogVideo_PAL_N: AnalogVideoStandard = AnalogVideoStandard(1024i32);
pub const AnalogVideo_PAL_N_COMBO: AnalogVideoStandard = AnalogVideoStandard(1048576i32);
pub const AnalogVideo_SECAM_B: AnalogVideoStandard = AnalogVideoStandard(4096i32);
pub const AnalogVideo_SECAM_D: AnalogVideoStandard = AnalogVideoStandard(8192i32);
pub const AnalogVideo_SECAM_G: AnalogVideoStandard = AnalogVideoStandard(16384i32);
pub const AnalogVideo_SECAM_H: AnalogVideoStandard = AnalogVideoStandard(32768i32);
pub const AnalogVideo_SECAM_K: AnalogVideoStandard = AnalogVideoStandard(65536i32);
pub const AnalogVideo_SECAM_K1: AnalogVideoStandard = AnalogVideoStandard(131072i32);
pub const AnalogVideo_SECAM_L: AnalogVideoStandard = AnalogVideoStandard(262144i32);
pub const AnalogVideo_SECAM_L1: AnalogVideoStandard = AnalogVideoStandard(524288i32);
pub const AnalogVideo_SECAM_Mask: u32 = 1044480u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ApplicationTypeType(pub i32);
pub const Associated: SmartCardAssociationType = SmartCardAssociationType(1i32);
pub const AssociationUnknown: SmartCardAssociationType = SmartCardAssociationType(2i32);
pub const BDACOMP_EXCLUDE_TS_FROM_TR: BDA_Comp_Flags = BDA_Comp_Flags(1i32);
pub const BDACOMP_INCLUDE_COMPONENTS_IN_TR: BDA_Comp_Flags = BDA_Comp_Flags(4i32);
pub const BDACOMP_INCLUDE_LOCATOR_IN_TR: BDA_Comp_Flags = BDA_Comp_Flags(2i32);
pub const BDACOMP_NOT_DEFINED: BDA_Comp_Flags = BDA_Comp_Flags(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDANODE_DESCRIPTOR {
    pub ulBdaNodeType: u32,
    pub guidFunction: windows_core::GUID,
    pub guidName: windows_core::GUID,
}
impl Default for BDANODE_DESCRIPTOR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_BCC_RATE_1_2: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(1i32);
pub const BDA_BCC_RATE_1_3: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(10i32);
pub const BDA_BCC_RATE_1_4: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(9i32);
pub const BDA_BCC_RATE_2_3: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(2i32);
pub const BDA_BCC_RATE_2_5: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(11i32);
pub const BDA_BCC_RATE_3_4: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(3i32);
pub const BDA_BCC_RATE_3_5: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(4i32);
pub const BDA_BCC_RATE_4_5: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(5i32);
pub const BDA_BCC_RATE_5_11: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(7i32);
pub const BDA_BCC_RATE_5_6: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(6i32);
pub const BDA_BCC_RATE_6_7: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(12i32);
pub const BDA_BCC_RATE_7_8: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(8i32);
pub const BDA_BCC_RATE_8_9: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(13i32);
pub const BDA_BCC_RATE_9_10: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(14i32);
pub const BDA_BCC_RATE_MAX: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(15i32);
pub const BDA_BCC_RATE_NOT_DEFINED: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(0i32);
pub const BDA_BCC_RATE_NOT_SET: BinaryConvolutionCodeRate = BinaryConvolutionCodeRate(-1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_BUFFER {
    pub lResult: i32,
    pub ulBufferSize: u32,
    pub argbBuffer: [u8; 1],
}
impl Default for BDA_BUFFER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_CAS_CHECK_ENTITLEMENTTOKEN {
    pub lResult: i32,
    pub ulDescrambleStatus: u32,
}
impl Default for BDA_CAS_CHECK_ENTITLEMENTTOKEN {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_CAS_CLOSEMMIDATA {
    pub ulDialogNumber: u32,
}
impl Default for BDA_CAS_CLOSEMMIDATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_CAS_CLOSE_MMIDIALOG {
    pub lResult: i32,
    pub SessionResult: u32,
}
impl Default for BDA_CAS_CLOSE_MMIDIALOG {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_CAS_OPENMMIDATA {
    pub ulDialogNumber: u32,
    pub ulDialogRequest: u32,
    pub uuidDialogType: windows_core::GUID,
    pub usDialogDataLength: u16,
    pub argbDialogData: [u8; 1],
}
impl Default for BDA_CAS_OPENMMIDATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_CAS_REQUESTTUNERDATA {
    pub ucRequestPriority: u8,
    pub ucRequestReason: u8,
    pub ucRequestConsequences: u8,
    pub ulEstimatedTime: u32,
}
impl Default for BDA_CAS_REQUESTTUNERDATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_CA_MODULE_UI {
    pub ulFormat: u32,
    pub ulbcDesc: u32,
    pub ulDesc: [u32; 1],
}
impl Default for BDA_CA_MODULE_UI {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_CHANGES_COMPLETE: BDA_CHANGE_STATE = BDA_CHANGE_STATE(0i32);
pub const BDA_CHANGES_PENDING: BDA_CHANGE_STATE = BDA_CHANGE_STATE(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_CHANGE_STATE(pub i32);
pub const BDA_CHAN_BANDWITH_NOT_DEFINED: BDA_Channel_Bandwidth = BDA_Channel_Bandwidth(0i32);
pub const BDA_CHAN_BANDWITH_NOT_SET: BDA_Channel_Bandwidth = BDA_Channel_Bandwidth(-1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_CONDITIONALACCESS_MMICLOSEREASON(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_CONDITIONALACCESS_REQUESTTYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_CONDITIONALACCESS_SESSION_RESULT(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_Channel(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_Channel_Bandwidth(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_Comp_Flags(pub i32);
pub const BDA_DISCOVERY_COMPLETE: BDA_DISCOVERY_STATE = BDA_DISCOVERY_STATE(2i32);
pub const BDA_DISCOVERY_REQUIRED: BDA_DISCOVERY_STATE = BDA_DISCOVERY_STATE(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_DISCOVERY_STATE(pub i32);
pub const BDA_DISCOVERY_UNSPECIFIED: BDA_DISCOVERY_STATE = BDA_DISCOVERY_STATE(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_DISEQC_RESPONSE {
    pub ulRequestId: u32,
    pub ulPacketLength: u32,
    pub argbPacketData: [u8; 8],
}
impl Default for BDA_DISEQC_RESPONSE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_DISEQC_SEND {
    pub ulRequestId: u32,
    pub ulPacketLength: u32,
    pub argbPacketData: [u8; 8],
}
impl Default for BDA_DISEQC_SEND {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_DRM_DRMSTATUS {
    pub lResult: i32,
    pub DRMuuid: windows_core::GUID,
    pub ulDrmUuidListStringSize: u32,
    pub argbDrmUuidListString: [windows_core::GUID; 1],
}
impl Default for BDA_DRM_DRMSTATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_DVBT2_L1_SIGNALLING_DATA {
    pub L1Pre_TYPE: u8,
    pub L1Pre_BWT_S1_S2: u8,
    pub L1Pre_REPETITION_GUARD_PAPR: u8,
    pub L1Pre_MOD_COD_FEC: u8,
    pub L1Pre_POSTSIZE_INFO_PILOT: [u8; 5],
    pub L1Pre_TX_ID_AVAIL: u8,
    pub L1Pre_CELL_ID: [u8; 2],
    pub L1Pre_NETWORK_ID: [u8; 2],
    pub L1Pre_T2SYSTEM_ID: [u8; 2],
    pub L1Pre_NUM_T2_FRAMES: u8,
    pub L1Pre_NUM_DATA_REGENFLAG_L1POSTEXT: [u8; 2],
    pub L1Pre_NUMRF_CURRENTRF_RESERVED: [u8; 2],
    pub L1Pre_CRC32: [u8; 4],
    pub L1PostData: [u8; 1],
}
impl Default for BDA_DVBT2_L1_SIGNALLING_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_DrmPairingError(pub i32);
pub const BDA_DrmPairing_Aborted: BDA_DrmPairingError = BDA_DrmPairingError(8i32);
pub const BDA_DrmPairing_DrmInitFailed: BDA_DrmPairingError = BDA_DrmPairingError(5i32);
pub const BDA_DrmPairing_DrmNotPaired: BDA_DrmPairingError = BDA_DrmPairingError(6i32);
pub const BDA_DrmPairing_DrmRePairSoon: BDA_DrmPairingError = BDA_DrmPairingError(7i32);
pub const BDA_DrmPairing_HardwareFailure: BDA_DrmPairingError = BDA_DrmPairingError(1i32);
pub const BDA_DrmPairing_NeedIndiv: BDA_DrmPairingError = BDA_DrmPairingError(3i32);
pub const BDA_DrmPairing_NeedRevocationData: BDA_DrmPairingError = BDA_DrmPairingError(2i32);
pub const BDA_DrmPairing_NeedSDKUpdate: BDA_DrmPairingError = BDA_DrmPairingError(9i32);
pub const BDA_DrmPairing_Other: BDA_DrmPairingError = BDA_DrmPairingError(4i32);
pub const BDA_DrmPairing_Succeeded: BDA_DrmPairingError = BDA_DrmPairingError(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_ETHERNET_ADDRESS {
    pub rgbAddress: [u8; 6],
}
impl Default for BDA_ETHERNET_ADDRESS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_ETHERNET_ADDRESS_LIST {
    pub ulcAddresses: u32,
    pub rgAddressl: [BDA_ETHERNET_ADDRESS; 1],
}
impl Default for BDA_ETHERNET_ADDRESS_LIST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_EVENT_ACCESS_DENIED: BDA_EVENT_ID = BDA_EVENT_ID(15i32);
pub const BDA_EVENT_ACCESS_GRANTED: BDA_EVENT_ID = BDA_EVENT_ID(14i32);
pub const BDA_EVENT_CHANNEL_ACQUIRED: BDA_EVENT_ID = BDA_EVENT_ID(4i32);
pub const BDA_EVENT_CHANNEL_ACTIVATED: BDA_EVENT_ID = BDA_EVENT_ID(7i32);
pub const BDA_EVENT_CHANNEL_DEACTIVATED: BDA_EVENT_ID = BDA_EVENT_ID(8i32);
pub const BDA_EVENT_CHANNEL_LOST: BDA_EVENT_ID = BDA_EVENT_ID(5i32);
pub const BDA_EVENT_CHANNEL_SOURCE_CHANGED: BDA_EVENT_ID = BDA_EVENT_ID(6i32);
pub const BDA_EVENT_DATA_START: BDA_EVENT_ID = BDA_EVENT_ID(2i32);
pub const BDA_EVENT_DATA_STOP: BDA_EVENT_ID = BDA_EVENT_ID(3i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_EVENT_ID(pub i32);
pub const BDA_EVENT_OFFER_EXTENDED: BDA_EVENT_ID = BDA_EVENT_ID(16i32);
pub const BDA_EVENT_PURCHASE_COMPLETED: BDA_EVENT_ID = BDA_EVENT_ID(17i32);
pub const BDA_EVENT_SIGNAL_LOCK: BDA_EVENT_ID = BDA_EVENT_ID(1i32);
pub const BDA_EVENT_SIGNAL_LOSS: BDA_EVENT_ID = BDA_EVENT_ID(0i32);
pub const BDA_EVENT_SMART_CARD_INSERTED: BDA_EVENT_ID = BDA_EVENT_ID(18i32);
pub const BDA_EVENT_SMART_CARD_REMOVED: BDA_EVENT_ID = BDA_EVENT_ID(19i32);
pub const BDA_EVENT_SUBCHANNEL_ACQUIRED: BDA_EVENT_ID = BDA_EVENT_ID(9i32);
pub const BDA_EVENT_SUBCHANNEL_ACTIVATED: BDA_EVENT_ID = BDA_EVENT_ID(12i32);
pub const BDA_EVENT_SUBCHANNEL_DEACTIVATED: BDA_EVENT_ID = BDA_EVENT_ID(13i32);
pub const BDA_EVENT_SUBCHANNEL_LOST: BDA_EVENT_ID = BDA_EVENT_ID(10i32);
pub const BDA_EVENT_SUBCHANNEL_SOURCE_CHANGED: BDA_EVENT_ID = BDA_EVENT_ID(11i32);
pub const BDA_E_ACCESS_DENIED: windows_core::HRESULT = windows_core::HRESULT(0xC0040009_u32 as _);
pub const BDA_E_BUFFER_TOO_SMALL: windows_core::HRESULT = windows_core::HRESULT(0xC004000B_u32 as _);
pub const BDA_E_DISABLED: windows_core::HRESULT = windows_core::HRESULT(0xC004000E_u32 as _);
pub const BDA_E_FAILURE: windows_core::HRESULT = windows_core::HRESULT(0xC0040001_u32 as _);
pub const BDA_E_INVALID_CAPTURE_TOKEN: windows_core::HRESULT = windows_core::HRESULT(0xC0044002_u32 as _);
pub const BDA_E_INVALID_ENTITLEMENT_TOKEN: windows_core::HRESULT = windows_core::HRESULT(0xC0044001_u32 as _);
pub const BDA_E_INVALID_HANDLE: windows_core::HRESULT = windows_core::HRESULT(0xC0040006_u32 as _);
pub const BDA_E_INVALID_LANGUAGE: windows_core::HRESULT = windows_core::HRESULT(0xC0040010_u32 as _);
pub const BDA_E_INVALID_PURCHASE_TOKEN: windows_core::HRESULT = windows_core::HRESULT(0xC0044004_u32 as _);
pub const BDA_E_INVALID_SCHEMA: windows_core::HRESULT = windows_core::HRESULT(0xC0040005_u32 as _);
pub const BDA_E_INVALID_TUNE_REQUEST: windows_core::HRESULT = windows_core::HRESULT(0xC0043004_u32 as _);
pub const BDA_E_INVALID_TYPE: windows_core::HRESULT = windows_core::HRESULT(0xC0040007_u32 as _);
pub const BDA_E_IPNETWORK_ADDRESS_NOT_FOUND: windows_core::HRESULT = windows_core::HRESULT(0xC0045002_u32 as _);
pub const BDA_E_IPNETWORK_ERROR: windows_core::HRESULT = windows_core::HRESULT(0xC0045001_u32 as _);
pub const BDA_E_IPNETWORK_TIMEOUT: windows_core::HRESULT = windows_core::HRESULT(0xC0045003_u32 as _);
pub const BDA_E_IPNETWORK_UNAVAILABLE: windows_core::HRESULT = windows_core::HRESULT(0xC0045004_u32 as _);
pub const BDA_E_NOT_FOUND: windows_core::HRESULT = windows_core::HRESULT(0xC004000A_u32 as _);
pub const BDA_E_NOT_IMPLEMENTED: windows_core::HRESULT = windows_core::HRESULT(0xC0040002_u32 as _);
pub const BDA_E_NO_HANDLER: windows_core::HRESULT = windows_core::HRESULT(0xC004000F_u32 as _);
pub const BDA_E_NO_MORE_DATA: windows_core::HRESULT = windows_core::HRESULT(0xC0041002_u32 as _);
pub const BDA_E_NO_MORE_EVENTS: windows_core::HRESULT = windows_core::HRESULT(0xC0041001_u32 as _);
pub const BDA_E_NO_SUCH_COMMAND: windows_core::HRESULT = windows_core::HRESULT(0xC0040003_u32 as _);
pub const BDA_E_OUT_OF_BOUNDS: windows_core::HRESULT = windows_core::HRESULT(0xC0040004_u32 as _);
pub const BDA_E_OUT_OF_MEMORY: windows_core::HRESULT = windows_core::HRESULT(0xC004000D_u32 as _);
pub const BDA_E_OUT_OF_RESOURCES: windows_core::HRESULT = windows_core::HRESULT(0xC004000C_u32 as _);
pub const BDA_E_READ_ONLY: windows_core::HRESULT = windows_core::HRESULT(0xC0040008_u32 as _);
pub const BDA_E_TIMEOUT_ELAPSED: windows_core::HRESULT = windows_core::HRESULT(0xC0040011_u32 as _);
pub const BDA_E_TUNER_CONFLICT: windows_core::HRESULT = windows_core::HRESULT(0xC0043003_u32 as _);
pub const BDA_E_TUNER_INITIALIZING: windows_core::HRESULT = windows_core::HRESULT(0xC0043001_u32 as _);
pub const BDA_E_TUNER_REQUIRED: windows_core::HRESULT = windows_core::HRESULT(0xC0043002_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV01: windows_core::HRESULT = windows_core::HRESULT(0xC0046001_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV02: windows_core::HRESULT = windows_core::HRESULT(0xC0046002_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV03: windows_core::HRESULT = windows_core::HRESULT(0xC0046003_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV04: windows_core::HRESULT = windows_core::HRESULT(0xC0046004_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV05: windows_core::HRESULT = windows_core::HRESULT(0xC0046005_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV06: windows_core::HRESULT = windows_core::HRESULT(0xC0046006_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV07: windows_core::HRESULT = windows_core::HRESULT(0xC0046007_u32 as _);
pub const BDA_E_TUNE_FAILED_SDV08: windows_core::HRESULT = windows_core::HRESULT(0xC0046008_u32 as _);
pub const BDA_E_TUNE_FAILED_SDVFF: windows_core::HRESULT = windows_core::HRESULT(0xC00460FF_u32 as _);
pub const BDA_E_WMDRM_INVALID_CERTIFICATE: windows_core::HRESULT = windows_core::HRESULT(0xC004F002_u32 as _);
pub const BDA_E_WMDRM_INVALID_DATE: windows_core::HRESULT = windows_core::HRESULT(0xC004F005_u32 as _);
pub const BDA_E_WMDRM_INVALID_PROXIMITY: windows_core::HRESULT = windows_core::HRESULT(0xC004F006_u32 as _);
pub const BDA_E_WMDRM_INVALID_SIGNATURE: windows_core::HRESULT = windows_core::HRESULT(0xC004F001_u32 as _);
pub const BDA_E_WMDRM_INVALID_VERSION: windows_core::HRESULT = windows_core::HRESULT(0xC004F004_u32 as _);
pub const BDA_E_WMDRM_KEY_ID_NOT_FOUND: windows_core::HRESULT = windows_core::HRESULT(0xC004F008_u32 as _);
pub const BDA_E_WOULD_DISRUPT_STREAMING: windows_core::HRESULT = windows_core::HRESULT(0xC0044003_u32 as _);
pub const BDA_FEC_BCH: FECMethod = FECMethod(4i32);
pub const BDA_FEC_LDPC: FECMethod = FECMethod(3i32);
pub const BDA_FEC_MAX: FECMethod = FECMethod(6i32);
pub const BDA_FEC_METHOD_NOT_DEFINED: FECMethod = FECMethod(0i32);
pub const BDA_FEC_METHOD_NOT_SET: FECMethod = FECMethod(-1i32);
pub const BDA_FEC_RS_147_130: FECMethod = FECMethod(5i32);
pub const BDA_FEC_RS_204_188: FECMethod = FECMethod(2i32);
pub const BDA_FEC_VITERBI: FECMethod = FECMethod(1i32);
pub const BDA_FILTERED_MULTICAST: BDA_MULTICAST_MODE = BDA_MULTICAST_MODE(1i32);
pub const BDA_FREQUENCY_MULTIPLIER_NOT_DEFINED: BDA_Frequency_Multiplier = BDA_Frequency_Multiplier(0i32);
pub const BDA_FREQUENCY_MULTIPLIER_NOT_SET: BDA_Frequency_Multiplier = BDA_Frequency_Multiplier(-1i32);
pub const BDA_FREQUENCY_NOT_DEFINED: BDA_Frequency = BDA_Frequency(0i32);
pub const BDA_FREQUENCY_NOT_SET: BDA_Frequency = BDA_Frequency(-1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_Frequency(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_Frequency_Multiplier(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_GDDS_DATA {
    pub lResult: i32,
    pub ulDataLength: u32,
    pub ulPercentageProgress: u32,
    pub argbData: [u8; 1],
}
impl Default for BDA_GDDS_DATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_GDDS_DATATYPE {
    pub lResult: i32,
    pub uuidDataType: windows_core::GUID,
}
impl Default for BDA_GDDS_DATATYPE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_GUARD_19_128: GuardInterval = GuardInterval(6i32);
pub const BDA_GUARD_19_256: GuardInterval = GuardInterval(7i32);
pub const BDA_GUARD_1_128: GuardInterval = GuardInterval(5i32);
pub const BDA_GUARD_1_16: GuardInterval = GuardInterval(2i32);
pub const BDA_GUARD_1_32: GuardInterval = GuardInterval(1i32);
pub const BDA_GUARD_1_4: GuardInterval = GuardInterval(4i32);
pub const BDA_GUARD_1_8: GuardInterval = GuardInterval(3i32);
pub const BDA_GUARD_MAX: GuardInterval = GuardInterval(8i32);
pub const BDA_GUARD_NOT_DEFINED: GuardInterval = GuardInterval(0i32);
pub const BDA_GUARD_NOT_SET: GuardInterval = GuardInterval(-1i32);
pub const BDA_HALPHA_1: HierarchyAlpha = HierarchyAlpha(1i32);
pub const BDA_HALPHA_2: HierarchyAlpha = HierarchyAlpha(2i32);
pub const BDA_HALPHA_4: HierarchyAlpha = HierarchyAlpha(3i32);
pub const BDA_HALPHA_MAX: HierarchyAlpha = HierarchyAlpha(4i32);
pub const BDA_HALPHA_NOT_DEFINED: HierarchyAlpha = HierarchyAlpha(0i32);
pub const BDA_HALPHA_NOT_SET: HierarchyAlpha = HierarchyAlpha(-1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_IPv4_ADDRESS {
    pub rgbAddress: [u8; 4],
}
impl Default for BDA_IPv4_ADDRESS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_IPv4_ADDRESS_LIST {
    pub ulcAddresses: u32,
    pub rgAddressl: [BDA_IPv4_ADDRESS; 1],
}
impl Default for BDA_IPv4_ADDRESS_LIST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_IPv6_ADDRESS {
    pub rgbAddress: [u8; 6],
}
impl Default for BDA_IPv6_ADDRESS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_IPv6_ADDRESS_LIST {
    pub ulcAddresses: u32,
    pub rgAddressl: [BDA_IPv6_ADDRESS; 1],
}
impl Default for BDA_IPv6_ADDRESS_LIST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_ISDBCAS_EMG_REQ {
    pub bCLA: u8,
    pub bINS: u8,
    pub bP1: u8,
    pub bP2: u8,
    pub bLC: u8,
    pub bCardId: [u8; 6],
    pub bProtocol: u8,
    pub bCABroadcasterGroupId: u8,
    pub bMessageControl: u8,
    pub bMessageCode: [u8; 1],
}
impl Default for BDA_ISDBCAS_EMG_REQ {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct BDA_ISDBCAS_REQUESTHEADER {
    pub bInstruction: u8,
    pub bReserved: [u8; 3],
    pub ulDataLength: u32,
    pub argbIsdbCommand: [u8; 1],
}
impl Default for BDA_ISDBCAS_REQUESTHEADER {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct BDA_ISDBCAS_RESPONSEDATA {
    pub lResult: i32,
    pub ulRequestID: u32,
    pub ulIsdbStatus: u32,
    pub ulIsdbDataSize: u32,
    pub argbIsdbCommandData: [u8; 1],
}
impl Default for BDA_ISDBCAS_RESPONSEDATA {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_LNB_SOURCE_A: LNB_Source = LNB_Source(1i32);
pub const BDA_LNB_SOURCE_B: LNB_Source = LNB_Source(2i32);
pub const BDA_LNB_SOURCE_C: LNB_Source = LNB_Source(3i32);
pub const BDA_LNB_SOURCE_D: LNB_Source = LNB_Source(4i32);
pub const BDA_LNB_SOURCE_MAX: LNB_Source = LNB_Source(5i32);
pub const BDA_LNB_SOURCE_NOT_DEFINED: LNB_Source = LNB_Source(0i32);
pub const BDA_LNB_SOURCE_NOT_SET: LNB_Source = LNB_Source(-1i32);
pub const BDA_MOD_1024QAM: ModulationType = ModulationType(19i32);
pub const BDA_MOD_112QAM: ModulationType = ModulationType(6i32);
pub const BDA_MOD_128QAM: ModulationType = ModulationType(7i32);
pub const BDA_MOD_160QAM: ModulationType = ModulationType(8i32);
pub const BDA_MOD_16APSK: ModulationType = ModulationType(29i32);
pub const BDA_MOD_16QAM: ModulationType = ModulationType(1i32);
pub const BDA_MOD_16VSB: ModulationType = ModulationType(24i32);
pub const BDA_MOD_192QAM: ModulationType = ModulationType(9i32);
pub const BDA_MOD_224QAM: ModulationType = ModulationType(10i32);
pub const BDA_MOD_256QAM: ModulationType = ModulationType(11i32);
pub const BDA_MOD_320QAM: ModulationType = ModulationType(12i32);
pub const BDA_MOD_32APSK: ModulationType = ModulationType(30i32);
pub const BDA_MOD_32QAM: ModulationType = ModulationType(2i32);
pub const BDA_MOD_384QAM: ModulationType = ModulationType(13i32);
pub const BDA_MOD_448QAM: ModulationType = ModulationType(14i32);
pub const BDA_MOD_512QAM: ModulationType = ModulationType(15i32);
pub const BDA_MOD_640QAM: ModulationType = ModulationType(16i32);
pub const BDA_MOD_64QAM: ModulationType = ModulationType(3i32);
pub const BDA_MOD_768QAM: ModulationType = ModulationType(17i32);
pub const BDA_MOD_80QAM: ModulationType = ModulationType(4i32);
pub const BDA_MOD_896QAM: ModulationType = ModulationType(18i32);
pub const BDA_MOD_8PSK: ModulationType = ModulationType(27i32);
pub const BDA_MOD_8VSB: ModulationType = ModulationType(23i32);
pub const BDA_MOD_96QAM: ModulationType = ModulationType(5i32);
pub const BDA_MOD_ANALOG_AMPLITUDE: ModulationType = ModulationType(25i32);
pub const BDA_MOD_ANALOG_FREQUENCY: ModulationType = ModulationType(26i32);
pub const BDA_MOD_BPSK: ModulationType = ModulationType(21i32);
pub const BDA_MOD_DIRECTV: ModulationType = ModulationType(33i32);
pub const BDA_MOD_ISDB_S_TMCC: ModulationType = ModulationType(35i32);
pub const BDA_MOD_ISDB_T_TMCC: ModulationType = ModulationType(34i32);
pub const BDA_MOD_MAX: ModulationType = ModulationType(36i32);
pub const BDA_MOD_NBC_8PSK: ModulationType = ModulationType(32i32);
pub const BDA_MOD_NBC_QPSK: ModulationType = ModulationType(31i32);
pub const BDA_MOD_NOT_DEFINED: ModulationType = ModulationType(0i32);
pub const BDA_MOD_NOT_SET: ModulationType = ModulationType(-1i32);
pub const BDA_MOD_OQPSK: ModulationType = ModulationType(22i32);
pub const BDA_MOD_QPSK: ModulationType = ModulationType(20i32);
pub const BDA_MOD_RF: ModulationType = ModulationType(28i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_MULTICAST_MODE(pub i32);
#[repr(C, packed(2))]
#[derive(Clone, Copy)]
pub struct BDA_MUX_PIDLISTITEM {
    pub usPIDNumber: u16,
    pub usProgramNumber: u16,
    pub ePIDType: MUX_PID_TYPE,
}
impl Default for BDA_MUX_PIDLISTITEM {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_NO_MULTICAST: BDA_MULTICAST_MODE = BDA_MULTICAST_MODE(2i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_PID_MAP {
    pub MediaSampleContent: MEDIA_SAMPLE_CONTENT,
    pub ulcPIDs: u32,
    pub aulPIDs: [u32; 1],
}
impl Default for BDA_PID_MAP {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_PID_UNMAP {
    pub ulcPIDs: u32,
    pub aulPIDs: [u32; 1],
}
impl Default for BDA_PID_UNMAP {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_PILOT_MAX: Pilot = Pilot(3i32);
pub const BDA_PILOT_NOT_DEFINED: Pilot = Pilot(0i32);
pub const BDA_PILOT_NOT_SET: Pilot = Pilot(-1i32);
pub const BDA_PILOT_OFF: Pilot = Pilot(1i32);
pub const BDA_PILOT_ON: Pilot = Pilot(2i32);
pub const BDA_PLP_ID_NOT_SET: i32 = -1i32;
pub const BDA_POLARISATION_CIRCULAR_L: Polarisation = Polarisation(3i32);
pub const BDA_POLARISATION_CIRCULAR_R: Polarisation = Polarisation(4i32);
pub const BDA_POLARISATION_LINEAR_H: Polarisation = Polarisation(1i32);
pub const BDA_POLARISATION_LINEAR_V: Polarisation = Polarisation(2i32);
pub const BDA_POLARISATION_MAX: Polarisation = Polarisation(5i32);
pub const BDA_POLARISATION_NOT_DEFINED: Polarisation = Polarisation(0i32);
pub const BDA_POLARISATION_NOT_SET: Polarisation = Polarisation(-1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_PROGRAM_PID_LIST {
    pub ulProgramNumber: u32,
    pub ulcPIDs: u32,
    pub ulPID: [u32; 1],
}
impl Default for BDA_PROGRAM_PID_LIST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_PROMISCUOUS_MULTICAST: BDA_MULTICAST_MODE = BDA_MULTICAST_MODE(0i32);
pub const BDA_RANGE_NOT_DEFINED: BDA_Range = BDA_Range(0i32);
pub const BDA_RANGE_NOT_SET: BDA_Range = BDA_Range(-1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_RATING_PINRESET {
    pub bPinLength: u8,
    pub argbNewPin: [u8; 1],
}
impl Default for BDA_RATING_PINRESET {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_ROLL_OFF_20: RollOff = RollOff(1i32);
pub const BDA_ROLL_OFF_25: RollOff = RollOff(2i32);
pub const BDA_ROLL_OFF_35: RollOff = RollOff(3i32);
pub const BDA_ROLL_OFF_MAX: RollOff = RollOff(4i32);
pub const BDA_ROLL_OFF_NOT_DEFINED: RollOff = RollOff(0i32);
pub const BDA_ROLL_OFF_NOT_SET: RollOff = RollOff(-1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_Range(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_SCAN_CAPABILTIES {
    pub lResult: i32,
    pub ul64AnalogStandardsSupported: u64,
}
impl Default for BDA_SCAN_CAPABILTIES {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_SCAN_MOD_1024QAM: ScanModulationTypes = ScanModulationTypes(262144i32);
pub const BDA_SCAN_MOD_112QAM: ScanModulationTypes = ScanModulationTypes(32i32);
pub const BDA_SCAN_MOD_128QAM: ScanModulationTypes = ScanModulationTypes(64i32);
pub const BDA_SCAN_MOD_160QAM: ScanModulationTypes = ScanModulationTypes(128i32);
pub const BDA_SCAN_MOD_16APSK: ScanModulationTypes = ScanModulationTypes(268435456i32);
pub const BDA_SCAN_MOD_16QAM: ScanModulationTypes = ScanModulationTypes(1i32);
pub const BDA_SCAN_MOD_16VSB: ScanModulationTypes = ScanModulationTypes(8388608i32);
pub const BDA_SCAN_MOD_192QAM: ScanModulationTypes = ScanModulationTypes(256i32);
pub const BDA_SCAN_MOD_224QAM: ScanModulationTypes = ScanModulationTypes(512i32);
pub const BDA_SCAN_MOD_256QAM: ScanModulationTypes = ScanModulationTypes(1024i32);
pub const BDA_SCAN_MOD_320QAM: ScanModulationTypes = ScanModulationTypes(2048i32);
pub const BDA_SCAN_MOD_32APSK: ScanModulationTypes = ScanModulationTypes(536870912i32);
pub const BDA_SCAN_MOD_32QAM: ScanModulationTypes = ScanModulationTypes(2i32);
pub const BDA_SCAN_MOD_384QAM: ScanModulationTypes = ScanModulationTypes(4096i32);
pub const BDA_SCAN_MOD_448QAM: ScanModulationTypes = ScanModulationTypes(8192i32);
pub const BDA_SCAN_MOD_512QAM: ScanModulationTypes = ScanModulationTypes(16384i32);
pub const BDA_SCAN_MOD_640QAM: ScanModulationTypes = ScanModulationTypes(32768i32);
pub const BDA_SCAN_MOD_64QAM: ScanModulationTypes = ScanModulationTypes(4i32);
pub const BDA_SCAN_MOD_768QAM: ScanModulationTypes = ScanModulationTypes(65536i32);
pub const BDA_SCAN_MOD_80QAM: ScanModulationTypes = ScanModulationTypes(8i32);
pub const BDA_SCAN_MOD_896QAM: ScanModulationTypes = ScanModulationTypes(131072i32);
pub const BDA_SCAN_MOD_8PSK: ScanModulationTypes = ScanModulationTypes(67108864i32);
pub const BDA_SCAN_MOD_8VSB: ScanModulationTypes = ScanModulationTypes(4194304i32);
pub const BDA_SCAN_MOD_96QAM: ScanModulationTypes = ScanModulationTypes(16i32);
pub const BDA_SCAN_MOD_AM_RADIO: ScanModulationTypes = ScanModulationTypes(16777216i32);
pub const BDA_SCAN_MOD_BPSK: ScanModulationTypes = ScanModulationTypes(1048576i32);
pub const BDA_SCAN_MOD_FM_RADIO: ScanModulationTypes = ScanModulationTypes(33554432i32);
pub const BDA_SCAN_MOD_OQPSK: ScanModulationTypes = ScanModulationTypes(2097152i32);
pub const BDA_SCAN_MOD_QPSK: ScanModulationTypes = ScanModulationTypes(524288i32);
pub const BDA_SCAN_MOD_RF: ScanModulationTypes = ScanModulationTypes(134217728i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_SCAN_START {
    pub lResult: i32,
    pub LowerFrequency: u32,
    pub HigerFrequency: u32,
}
impl Default for BDA_SCAN_START {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_SCAN_STATE {
    pub lResult: i32,
    pub ulSignalLock: u32,
    pub ulSecondsLeft: u32,
    pub ulCurrentFrequency: u32,
}
impl Default for BDA_SCAN_STATE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_SIGNAL_ACTIVE: BDA_SIGNAL_STATE = BDA_SIGNAL_STATE(2i32);
pub const BDA_SIGNAL_INACTIVE: BDA_SIGNAL_STATE = BDA_SIGNAL_STATE(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BDA_SIGNAL_STATE(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_SIGNAL_TIMEOUTS {
    pub ulCarrierTimeoutMs: u32,
    pub ulScanningTimeoutMs: u32,
    pub ulTuningTimeoutMs: u32,
}
impl Default for BDA_SIGNAL_TIMEOUTS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_SIGNAL_UNAVAILABLE: BDA_SIGNAL_STATE = BDA_SIGNAL_STATE(0i32);
pub const BDA_SPECTRAL_INVERSION_AUTOMATIC: SpectralInversion = SpectralInversion(1i32);
pub const BDA_SPECTRAL_INVERSION_INVERTED: SpectralInversion = SpectralInversion(3i32);
pub const BDA_SPECTRAL_INVERSION_MAX: SpectralInversion = SpectralInversion(4i32);
pub const BDA_SPECTRAL_INVERSION_NORMAL: SpectralInversion = SpectralInversion(2i32);
pub const BDA_SPECTRAL_INVERSION_NOT_DEFINED: SpectralInversion = SpectralInversion(0i32);
pub const BDA_SPECTRAL_INVERSION_NOT_SET: SpectralInversion = SpectralInversion(-1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_STRING {
    pub lResult: i32,
    pub ulStringSize: u32,
    pub argbString: [u8; 1],
}
impl Default for BDA_STRING {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_TABLE_SECTION {
    pub ulPrimarySectionId: u32,
    pub ulSecondarySectionId: u32,
    pub ulcbSectionLength: u32,
    pub argbSectionData: [u32; 1],
}
impl Default for BDA_TABLE_SECTION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_TEMPLATE_CONNECTION {
    pub FromNodeType: u32,
    pub FromNodePinType: u32,
    pub ToNodeType: u32,
    pub ToNodePinType: u32,
}
impl Default for BDA_TEMPLATE_CONNECTION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_TEMPLATE_PIN_JOINT {
    pub uliTemplateConnection: u32,
    pub ulcInstancesMax: u32,
}
impl Default for BDA_TEMPLATE_PIN_JOINT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[derive(Clone, Copy)]
pub struct BDA_TS_SELECTORINFO {
    pub bTSInfolength: u8,
    pub bReserved: [u8; 2],
    pub guidNetworkType: windows_core::GUID,
    pub bTSIDCount: u8,
    pub usTSID: [u16; 1],
}
impl Default for BDA_TS_SELECTORINFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_TS_SELECTORINFO_ISDBS_EXT {
    pub bTMCC: [u8; 48],
}
impl Default for BDA_TS_SELECTORINFO_ISDBS_EXT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_TUNER_DIAGNOSTICS {
    pub lResult: i32,
    pub ulSignalLevel: u32,
    pub ulSignalLevelQuality: u32,
    pub ulSignalNoiseRatio: u32,
}
impl Default for BDA_TUNER_DIAGNOSTICS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_TUNER_TUNERSTATE {
    pub lResult: i32,
    pub ulTuneLength: u32,
    pub argbTuneData: [u8; 1],
}
impl Default for BDA_TUNER_TUNERSTATE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_UNDEFINED_CHANNEL: BDA_Channel = BDA_Channel(-1i32);
pub const BDA_UNITIALIZED_MPEG2STREAMTYPE: MPEG2StreamType = MPEG2StreamType(-1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_USERACTIVITY_INTERVAL {
    pub lResult: i32,
    pub ulActivityInterval: u32,
}
impl Default for BDA_USERACTIVITY_INTERVAL {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_WMDRMTUNER_PIDPROTECTION {
    pub lResult: i32,
    pub uuidKeyID: windows_core::GUID,
}
impl Default for BDA_WMDRMTUNER_PIDPROTECTION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_WMDRMTUNER_PURCHASEENTITLEMENT {
    pub lResult: i32,
    pub ulDescrambleStatus: u32,
    pub ulCaptureTokenLength: u32,
    pub argbCaptureTokenBuffer: [u8; 1],
}
impl Default for BDA_WMDRMTUNER_PURCHASEENTITLEMENT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_WMDRM_KEYINFOLIST {
    pub lResult: i32,
    pub ulKeyuuidBufferLen: u32,
    pub argKeyuuidBuffer: [windows_core::GUID; 1],
}
impl Default for BDA_WMDRM_KEYINFOLIST {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_WMDRM_RENEWLICENSE {
    pub lResult: i32,
    pub ulDescrambleStatus: u32,
    pub ulXmrLicenseOutputLength: u32,
    pub argbXmrLicenceOutputBuffer: [u8; 1],
}
impl Default for BDA_WMDRM_RENEWLICENSE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct BDA_WMDRM_STATUS {
    pub lResult: i32,
    pub ulMaxCaptureTokenSize: u32,
    pub uMaxStreamingPid: u32,
    pub ulMaxLicense: u32,
    pub ulMinSecurityLevel: u32,
    pub ulRevInfoSequenceNumber: u32,
    pub ulRevInfoIssuedTime: u64,
    pub ulRevListVersion: u32,
    pub ulRevInfoTTL: u32,
    pub ulState: u32,
}
impl Default for BDA_WMDRM_STATUS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const BDA_XMIT_MODE_16K: TransmissionMode = TransmissionMode(7i32);
pub const BDA_XMIT_MODE_1K: TransmissionMode = TransmissionMode(6i32);
pub const BDA_XMIT_MODE_2K: TransmissionMode = TransmissionMode(1i32);
pub const BDA_XMIT_MODE_2K_INTERLEAVED: TransmissionMode = TransmissionMode(4i32);
pub const BDA_XMIT_MODE_32K: TransmissionMode = TransmissionMode(8i32);
pub const BDA_XMIT_MODE_4K: TransmissionMode = TransmissionMode(3i32);
pub const BDA_XMIT_MODE_4K_INTERLEAVED: TransmissionMode = TransmissionMode(5i32);
pub const BDA_XMIT_MODE_8K: TransmissionMode = TransmissionMode(2i32);
pub const BDA_XMIT_MODE_MAX: TransmissionMode = TransmissionMode(9i32);
pub const BDA_XMIT_MODE_NOT_DEFINED: TransmissionMode = TransmissionMode(0i32);
pub const BDA_XMIT_MODE_NOT_SET: TransmissionMode = TransmissionMode(-1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct BinaryConvolutionCodeRate(pub i32);
pub const CATEGORY_COUNT: ComponentCategory = ComponentCategory(8i32);
pub const CDEF_BYPASS_CLASS_MANAGER: u32 = 2u32;
pub const CDEF_CLASS_DEFAULT: u32 = 1u32;
pub const CDEF_DEVMON_CMGR_DEVICE: u32 = 16u32;
pub const CDEF_DEVMON_DMO: u32 = 32u32;
pub const CDEF_DEVMON_FILTER: u32 = 128u32;
pub const CDEF_DEVMON_PNP_DEVICE: u32 = 64u32;
pub const CDEF_DEVMON_SELECTIVE_MASK: u32 = 240u32;
pub const CDEF_MERIT_ABOVE_DO_NOT_USE: u32 = 8u32;
pub const CFSTR_VFW_FILTERLIST: windows_core::PCSTR = windows_core::s!("Video for Windows 4 Filters");
pub const CHARS_IN_GUID: u32 = 39u32;
pub const CK_INDEX: COLORKEY_TYPE = COLORKEY_TYPE(1i32);
pub const CK_NOCOLORKEY: COLORKEY_TYPE = COLORKEY_TYPE(0i32);
pub const CK_RGB: COLORKEY_TYPE = COLORKEY_TYPE(2i32);
pub const CLSID_AMAudioData: windows_core::GUID = windows_core::GUID::from_u128(0xf2468580_af8a_11d0_8212_00c04fc32c45);
pub const CLSID_AMAudioStream: windows_core::GUID = windows_core::GUID::from_u128(0x8496e040_af4c_11d0_8212_00c04fc32c45);
pub const CLSID_AMDirectDrawStream: windows_core::GUID = windows_core::GUID::from_u128(0x49c47ce4_9ba4_11d0_8212_00c04fc32c45);
pub const CLSID_AMMediaTypeStream: windows_core::GUID = windows_core::GUID::from_u128(0xcf0f2f7c_f7bf_11d0_900d_00c04fd9189d);
pub const CLSID_AMMultiMediaStream: windows_core::GUID = windows_core::GUID::from_u128(0x49c47ce5_9ba4_11d0_8212_00c04fc32c45);
pub const CLSID_DMOFilterCategory: windows_core::GUID = windows_core::GUID::from_u128(0xbcd5796c_bd52_4d30_ab76_70f975b89199);
pub const CLSID_DMOWrapperFilter: windows_core::GUID = windows_core::GUID::from_u128(0x94297043_bd82_4dfd_b0de_8177739c6d20);
pub const CLSID_PBDA_AUX_DATA_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0xfd456373_3323_4090_adca_8ed45f55cf10);
pub const CLSID_PBDA_Encoder_DATA_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0x728fd6bc_5546_4716_b103_f899f5a1fa68);
pub const CLSID_PBDA_FDC_DATA_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0xe7dbf9a0_22ab_4047_8e67_ef9ad504e729);
pub const CLSID_PBDA_GDDS_DATA_TYPE: windows_core::GUID = windows_core::GUID::from_u128(0xc80c0df3_6052_4c16_9f56_c44c21f73c45);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct COLORKEY {
    pub KeyType: u32,
    pub PaletteIndex: u32,
    pub LowColorValue: super::super::Foundation::COLORREF,
    pub HighColorValue: super::super::Foundation::COLORREF,
}
impl Default for COLORKEY {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct COLORKEY_TYPE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct COMPLETION_STATUS_FLAGS(pub i32);
pub const COMPSTAT_ABORT: COMPLETION_STATUS_FLAGS = COMPLETION_STATUS_FLAGS(4i32);
pub const COMPSTAT_NOUPDATEOK: COMPLETION_STATUS_FLAGS = COMPLETION_STATUS_FLAGS(1i32);
pub const COMPSTAT_WAIT: COMPLETION_STATUS_FLAGS = COMPLETION_STATUS_FLAGS(2i32);
pub const CONDITIONALACCESS_ABORTED: BDA_CONDITIONALACCESS_SESSION_RESULT = BDA_CONDITIONALACCESS_SESSION_RESULT(2i32);
pub const CONDITIONALACCESS_ACCESS_NOT_POSSIBLE: BDA_CONDITIONALACCESS_REQUESTTYPE = BDA_CONDITIONALACCESS_REQUESTTYPE(1i32);
pub const CONDITIONALACCESS_ACCESS_POSSIBLE: BDA_CONDITIONALACCESS_REQUESTTYPE = BDA_CONDITIONALACCESS_REQUESTTYPE(2i32);
pub const CONDITIONALACCESS_ACCESS_POSSIBLE_NO_STREAMING_DISRUPTION: BDA_CONDITIONALACCESS_REQUESTTYPE = BDA_CONDITIONALACCESS_REQUESTTYPE(3i32);
pub const CONDITIONALACCESS_ACCESS_UNSPECIFIED: BDA_CONDITIONALACCESS_REQUESTTYPE = BDA_CONDITIONALACCESS_REQUESTTYPE(0i32);
pub const CONDITIONALACCESS_CLOSED_ITSELF: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(1i32);
pub const CONDITIONALACCESS_DIALOG_FOCUS_CHANGE: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(4i32);
pub const CONDITIONALACCESS_DIALOG_TIMEOUT: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(3i32);
pub const CONDITIONALACCESS_DIALOG_USER_DISMISSED: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(5i32);
pub const CONDITIONALACCESS_DIALOG_USER_NOT_AVAILABLE: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(6i32);
pub const CONDITIONALACCESS_ENDED_NOCHANGE: BDA_CONDITIONALACCESS_SESSION_RESULT = BDA_CONDITIONALACCESS_SESSION_RESULT(1i32);
pub const CONDITIONALACCESS_SUCCESSFULL: BDA_CONDITIONALACCESS_SESSION_RESULT = BDA_CONDITIONALACCESS_SESSION_RESULT(0i32);
pub const CONDITIONALACCESS_TUNER_REQUESTED_CLOSE: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(2i32);
pub const CONDITIONALACCESS_UNSPECIFIED: BDA_CONDITIONALACCESS_MMICLOSEREASON = BDA_CONDITIONALACCESS_MMICLOSEREASON(0i32);
pub const COPP_ACP_ForceDWORD: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(2147483647i32);
pub const COPP_ACP_Level0: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(0i32);
pub const COPP_ACP_Level1: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(1i32);
pub const COPP_ACP_Level2: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(2i32);
pub const COPP_ACP_Level3: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(3i32);
pub const COPP_ACP_LevelMax: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(3i32);
pub const COPP_ACP_LevelMin: COPP_ACP_Protection_Level = COPP_ACP_Protection_Level(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct COPP_ACP_Protection_Level(pub i32);
pub const COPP_AspectRatio_EN300294_Box14by9Center: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(1i32);
pub const COPP_AspectRatio_EN300294_Box14by9Top: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(2i32);
pub const COPP_AspectRatio_EN300294_Box16by9Center: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(3i32);
pub const COPP_AspectRatio_EN300294_Box16by9Top: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(4i32);
pub const COPP_AspectRatio_EN300294_BoxGT16by9Center: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(5i32);
pub const COPP_AspectRatio_EN300294_FullFormat16by9Anamorphic: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(7i32);
pub const COPP_AspectRatio_EN300294_FullFormat4by3: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(0i32);
pub const COPP_AspectRatio_EN300294_FullFormat4by3ProtectedCenter: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(6i32);
pub const COPP_AspectRatio_ForceDWORD: COPP_ImageAspectRatio_EN300294 = COPP_ImageAspectRatio_EN300294(2147483647i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct COPP_BusType(pub i32);
pub const COPP_BusType_AGP: COPP_BusType = COPP_BusType(4i32);
pub const COPP_BusType_ForceDWORD: COPP_BusType = COPP_BusType(2147483647i32);
pub const COPP_BusType_Integrated: COPP_BusType = COPP_BusType(-2147483648i32);
pub const COPP_BusType_PCI: COPP_BusType = COPP_BusType(1i32);
pub const COPP_BusType_PCIExpress: COPP_BusType = COPP_BusType(3i32);
pub const COPP_BusType_PCIX: COPP_BusType = COPP_BusType(2i32);
pub const COPP_BusType_Unknown: COPP_BusType = COPP_BusType(0i32);
pub const COPP_CGMSA_CopyFreely: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(1i32);
pub const COPP_CGMSA_CopyNever: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(4i32);
pub const COPP_CGMSA_CopyNoMore: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(2i32);
pub const COPP_CGMSA_CopyOneGeneration: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(3i32);
pub const COPP_CGMSA_Disabled: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(0i32);
pub const COPP_CGMSA_ForceDWORD: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(2147483647i32);
pub const COPP_CGMSA_LevelMax: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(12i32);
pub const COPP_CGMSA_LevelMin: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct COPP_CGMSA_Protection_Level(pub i32);
pub const COPP_CGMSA_RedistributionControlRequired: COPP_CGMSA_Protection_Level = COPP_CGMSA_Protection_Level(8i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct COPP_ConnectorType(pub i32);
pub const COPP_ConnectorType_ComponentVideo: COPP_ConnectorType = COPP_ConnectorType(3i32);
pub const COPP_ConnectorType_CompositeVideo: COPP_ConnectorType = COPP_ConnectorType(2i32);
pub const COPP_ConnectorType_DVI: COPP_ConnectorType = COPP_ConnectorType(4i32);
pub const COPP_ConnectorType_D_JPN: COPP_ConnectorType = COPP_ConnectorType(8i32);
pub const COPP_ConnectorType_ForceDWORD: COPP_ConnectorType = COPP_ConnectorType(2147483647i32);
pub const COPP_ConnectorType_HDMI: COPP_ConnectorType = COPP_ConnectorType(5i32);
pub const COPP_ConnectorType_Internal: COPP_ConnectorType = COPP_ConnectorType(-2147483648i32);
pub const COPP_ConnectorType_LVDS: COPP_ConnectorType = COPP_ConnectorType(6i32);
pub const COPP_ConnectorType_SVideo: COPP_ConnectorType = COPP_ConnectorType(1i32);
pub const COPP_ConnectorType_TMDS: COPP_ConnectorType = COPP_ConnectorType(7i32);
pub const COPP_ConnectorType_Unknown: COPP_ConnectorType = COPP_ConnectorType(-1i32);
pub const COPP_ConnectorType_VGA: COPP_ConnectorType = COPP_ConnectorType(0i32);
pub const COPP_DefaultProtectionLevel: u32 = 0u32;
pub const COPP_HDCPFlagsReserved: COPP_StatusHDCPFlags = COPP_StatusHDCPFlags(-2i32);
pub const COPP_HDCPRepeater: COPP_StatusHDCPFlags = COPP_StatusHDCPFlags(1i32);
pub const COPP_HDCP_ForceDWORD: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(2147483647i32);
pub const COPP_HDCP_Level0: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(0i32);
pub const COPP_HDCP_Level1: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(1i32);
pub const COPP_HDCP_LevelMax: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(1i32);
pub const COPP_HDCP_LevelMin: COPP_HDCP_Protection_Level = COPP_HDCP_Protection_Level(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct COPP_HDCP_Protection_Level(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct COPP_ImageAspectRatio_EN300294(pub i32);
pub const COPP_ImageAspectRatio_EN300294_Mask: u32 = 7u32;
pub const COPP_LinkLost: COPP_StatusFlags = COPP_StatusFlags(1i32);
pub const COPP_NoProtectionLevelAvailable: i32 = -1i32;
pub const COPP_ProtectionStandard_ARIBTRB15_1125i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(16384i32);
pub const COPP_ProtectionStandard_ARIBTRB15_525i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(2048i32);
pub const COPP_ProtectionStandard_ARIBTRB15_525p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(4096i32);
pub const COPP_ProtectionStandard_ARIBTRB15_750p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(8192i32);
pub const COPP_ProtectionStandard_CEA805A_TypeA_1125i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(128i32);
pub const COPP_ProtectionStandard_CEA805A_TypeA_525p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(32i32);
pub const COPP_ProtectionStandard_CEA805A_TypeA_750p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(64i32);
pub const COPP_ProtectionStandard_CEA805A_TypeB_1125i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(1024i32);
pub const COPP_ProtectionStandard_CEA805A_TypeB_525p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(256i32);
pub const COPP_ProtectionStandard_CEA805A_TypeB_750p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(512i32);
pub const COPP_ProtectionStandard_EIA608B_525: COPP_TVProtectionStandard = COPP_TVProtectionStandard(8i32);
pub const COPP_ProtectionStandard_EN300294_625i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(16i32);
pub const COPP_ProtectionStandard_IEC61880_2_525i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(2i32);
pub const COPP_ProtectionStandard_IEC61880_525i: COPP_TVProtectionStandard = COPP_TVProtectionStandard(1i32);
pub const COPP_ProtectionStandard_IEC62375_625p: COPP_TVProtectionStandard = COPP_TVProtectionStandard(4i32);
pub const COPP_ProtectionStandard_Mask: COPP_TVProtectionStandard = COPP_TVProtectionStandard(-2147450881i32);
pub const COPP_ProtectionStandard_None: COPP_TVProtectionStandard = COPP_TVProtectionStandard(0i32);
pub const COPP_ProtectionStandard_Reserved: COPP_TVProtectionStandard = COPP_TVProtectionStandard(2147450880i32);
pub const COPP_ProtectionStandard_Unknown: COPP_TVProtectionStandard = COPP_TVProtectionStandard(-2147483648i32);
pub const COPP_RenegotiationRequired: COPP_StatusFlags = COPP_StatusFlags(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct COPP_StatusFlags(pub i32);
pub const COPP_StatusFlagsReserved: COPP_StatusFlags = COPP_StatusFlags(-4i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct COPP_StatusHDCPFlags(pub i32);
pub const COPP_StatusNormal: COPP_StatusFlags = COPP_StatusFlags(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct COPP_TVProtectionStandard(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CameraControlFlags(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CameraControlProperty(pub i32);
pub const CameraControl_Exposure: CameraControlProperty = CameraControlProperty(4i32);
pub const CameraControl_Flags_Auto: CameraControlFlags = CameraControlFlags(1i32);
pub const CameraControl_Flags_Manual: CameraControlFlags = CameraControlFlags(2i32);
pub const CameraControl_Focus: CameraControlProperty = CameraControlProperty(6i32);
pub const CameraControl_Iris: CameraControlProperty = CameraControlProperty(5i32);
pub const CameraControl_Pan: CameraControlProperty = CameraControlProperty(0i32);
pub const CameraControl_Roll: CameraControlProperty = CameraControlProperty(2i32);
pub const CameraControl_Tilt: CameraControlProperty = CameraControlProperty(1i32);
pub const CameraControl_Zoom: CameraControlProperty = CameraControlProperty(3i32);
pub const CardDataChanged: SmartCardStatusType = SmartCardStatusType(3i32);
pub const CardError: SmartCardStatusType = SmartCardStatusType(2i32);
pub const CardFirmwareUpgrade: SmartCardStatusType = SmartCardStatusType(4i32);
pub const CardInserted: SmartCardStatusType = SmartCardStatusType(0i32);
pub const CardRemoved: SmartCardStatusType = SmartCardStatusType(1i32);
pub const CategoryAudio: ComponentCategory = ComponentCategory(2i32);
pub const CategoryCaptions: ComponentCategory = ComponentCategory(5i32);
pub const CategoryData: ComponentCategory = ComponentCategory(7i32);
pub const CategoryNotSet: ComponentCategory = ComponentCategory(-1i32);
pub const CategoryOther: ComponentCategory = ComponentCategory(0i32);
pub const CategorySubtitles: ComponentCategory = ComponentCategory(4i32);
pub const CategorySuperimpose: ComponentCategory = ComponentCategory(6i32);
pub const CategoryText: ComponentCategory = ComponentCategory(3i32);
pub const CategoryVideo: ComponentCategory = ComponentCategory(1i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ComponentCategory(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct ComponentStatus(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct CompressionCaps(pub i32);
pub const CompressionCaps_CanBFrame: CompressionCaps = CompressionCaps(8i32);
pub const CompressionCaps_CanCrunch: CompressionCaps = CompressionCaps(2i32);
pub const CompressionCaps_CanKeyFrame: CompressionCaps = CompressionCaps(4i32);
pub const CompressionCaps_CanQuality: CompressionCaps = CompressionCaps(1i32);
pub const CompressionCaps_CanWindow: CompressionCaps = CompressionCaps(16i32);
pub const ConstantBitRate: VIDEOENCODER_BITRATE_MODE = VIDEOENCODER_BITRATE_MODE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DDSFF_FLAGS(pub i32);
impl DDSFF_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl core::ops::BitOr for DDSFF_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl core::ops::BitAnd for DDSFF_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl core::ops::BitOrAssign for DDSFF_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl core::ops::BitAndAssign for DDSFF_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl core::ops::Not for DDSFF_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const DDSFF_PROGRESSIVERENDER: DDSFF_FLAGS = DDSFF_FLAGS(1i32);
pub const DECIMATION_DEFAULT: DECIMATION_USAGE = DECIMATION_USAGE(4i32);
pub const DECIMATION_LEGACY: DECIMATION_USAGE = DECIMATION_USAGE(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DECIMATION_USAGE(pub i32);
pub const DECIMATION_USE_DECODER_ONLY: DECIMATION_USAGE = DECIMATION_USAGE(1i32);
pub const DECIMATION_USE_OVERLAY_ONLY: DECIMATION_USAGE = DECIMATION_USAGE(3i32);
pub const DECIMATION_USE_VIDEOPORT_ONLY: DECIMATION_USAGE = DECIMATION_USAGE(2i32);
pub const DECODER_CAP_NOTSUPPORTED: u32 = 0u32;
pub const DECODER_CAP_SUPPORTED: u32 = 1u32;
pub const DISPLAY_16x9: DVD_PREFERRED_DISPLAY_MODE = DVD_PREFERRED_DISPLAY_MODE(1i32);
pub const DISPLAY_4x3_LETTERBOX_PREFERRED: DVD_PREFERRED_DISPLAY_MODE = DVD_PREFERRED_DISPLAY_MODE(3i32);
pub const DISPLAY_4x3_PANSCAN_PREFERRED: DVD_PREFERRED_DISPLAY_MODE = DVD_PREFERRED_DISPLAY_MODE(2i32);
pub const DISPLAY_CONTENT_DEFAULT: DVD_PREFERRED_DISPLAY_MODE = DVD_PREFERRED_DISPLAY_MODE(0i32);
pub const DOLBY_AC3_AUDIO: MPEG2StreamType = MPEG2StreamType(129i32);
pub const DOLBY_DIGITAL_PLUS_AUDIO_ATSC: MPEG2StreamType = MPEG2StreamType(135i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVBSystemType(pub i32);
pub const DVB_Cable: DVBSystemType = DVBSystemType(0i32);
pub const DVB_Satellite: DVBSystemType = DVBSystemType(2i32);
pub const DVB_Terrestrial: DVBSystemType = DVBSystemType(1i32);
pub const DVDECODERRESOLUTION_180x120: _DVDECODERRESOLUTION = _DVDECODERRESOLUTION(1002i32);
pub const DVDECODERRESOLUTION_360x240: _DVDECODERRESOLUTION = _DVDECODERRESOLUTION(1001i32);
pub const DVDECODERRESOLUTION_720x480: _DVDECODERRESOLUTION = _DVDECODERRESOLUTION(1000i32);
pub const DVDECODERRESOLUTION_88x60: _DVDECODERRESOLUTION = _DVDECODERRESOLUTION(1003i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVD_ATR {
    pub ulCAT: u32,
    pub pbATRI: [u8; 768],
}
impl Default for DVD_ATR {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_AUDIO_APPMODE(pub i32);
pub const DVD_AUDIO_CAPS_AC3: u32 = 1u32;
pub const DVD_AUDIO_CAPS_DTS: u32 = 8u32;
pub const DVD_AUDIO_CAPS_LPCM: u32 = 4u32;
pub const DVD_AUDIO_CAPS_MPEG2: u32 = 2u32;
pub const DVD_AUDIO_CAPS_SDDS: u32 = 16u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_AUDIO_FORMAT(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_AUDIO_LANG_EXT(pub i32);
pub const DVD_AUD_EXT_Captions: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(1i32);
pub const DVD_AUD_EXT_DirectorComments1: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(3i32);
pub const DVD_AUD_EXT_DirectorComments2: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(4i32);
pub const DVD_AUD_EXT_NotSpecified: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(0i32);
pub const DVD_AUD_EXT_VisuallyImpaired: DVD_AUDIO_LANG_EXT = DVD_AUDIO_LANG_EXT(2i32);
pub const DVD_AppMode_Karaoke: DVD_TITLE_APPMODE = DVD_TITLE_APPMODE(1i32);
pub const DVD_AppMode_Not_Specified: DVD_TITLE_APPMODE = DVD_TITLE_APPMODE(0i32);
pub const DVD_AppMode_Other: DVD_TITLE_APPMODE = DVD_TITLE_APPMODE(3i32);
pub const DVD_Assignment_LR: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(2i32);
pub const DVD_Assignment_LR1: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(4i32);
pub const DVD_Assignment_LR12: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(6i32);
pub const DVD_Assignment_LRM: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(3i32);
pub const DVD_Assignment_LRM1: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(5i32);
pub const DVD_Assignment_LRM12: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(7i32);
pub const DVD_Assignment_reserved0: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(0i32);
pub const DVD_Assignment_reserved1: DVD_KARAOKE_ASSIGNMENT = DVD_KARAOKE_ASSIGNMENT(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVD_AudioAttributes {
    pub AppMode: DVD_AUDIO_APPMODE,
    pub AppModeData: u8,
    pub AudioFormat: DVD_AUDIO_FORMAT,
    pub Language: u32,
    pub LanguageExtension: DVD_AUDIO_LANG_EXT,
    pub fHasMultichannelInfo: windows_core::BOOL,
    pub dwFrequency: u32,
    pub bQuantization: u8,
    pub bNumberOfChannels: u8,
    pub dwReserved: [u32; 2],
}
impl Default for DVD_AudioAttributes {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DVD_AudioDuringFFwdRew: DVD_OPTION_FLAG = DVD_OPTION_FLAG(4i32);
pub const DVD_AudioFormat_AC3: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(0i32);
pub const DVD_AudioFormat_DTS: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(6i32);
pub const DVD_AudioFormat_LPCM: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(5i32);
pub const DVD_AudioFormat_MPEG1: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(1i32);
pub const DVD_AudioFormat_MPEG1_DRC: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(2i32);
pub const DVD_AudioFormat_MPEG2: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(3i32);
pub const DVD_AudioFormat_MPEG2_DRC: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(4i32);
pub const DVD_AudioFormat_Other: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(8i32);
pub const DVD_AudioFormat_SDDS: DVD_AUDIO_FORMAT = DVD_AUDIO_FORMAT(7i32);
pub const DVD_AudioMode_Karaoke: DVD_AUDIO_APPMODE = DVD_AUDIO_APPMODE(1i32);
pub const DVD_AudioMode_None: DVD_AUDIO_APPMODE = DVD_AUDIO_APPMODE(0i32);
pub const DVD_AudioMode_Other: DVD_AUDIO_APPMODE = DVD_AUDIO_APPMODE(3i32);
pub const DVD_AudioMode_Surround: DVD_AUDIO_APPMODE = DVD_AUDIO_APPMODE(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_CMD_FLAGS(pub i32);
pub const DVD_CMD_FLAG_Block: DVD_CMD_FLAGS = DVD_CMD_FLAGS(4i32);
pub const DVD_CMD_FLAG_EndAfterRendered: DVD_CMD_FLAGS = DVD_CMD_FLAGS(16i32);
pub const DVD_CMD_FLAG_Flush: DVD_CMD_FLAGS = DVD_CMD_FLAGS(1i32);
pub const DVD_CMD_FLAG_None: DVD_CMD_FLAGS = DVD_CMD_FLAGS(0i32);
pub const DVD_CMD_FLAG_SendEvents: DVD_CMD_FLAGS = DVD_CMD_FLAGS(2i32);
pub const DVD_CMD_FLAG_StartWhenRendered: DVD_CMD_FLAGS = DVD_CMD_FLAGS(8i32);
pub const DVD_CacheSizeInMB: DVD_OPTION_FLAG = DVD_OPTION_FLAG(6i32);
pub const DVD_Channel_Audio: DVD_TextStringType = DVD_TextStringType(32i32);
pub const DVD_CharSet_ISO646: DVD_TextCharSet = DVD_TextCharSet(1i32);
pub const DVD_CharSet_ISO8859_1: DVD_TextCharSet = DVD_TextCharSet(3i32);
pub const DVD_CharSet_JIS_Roman_Kanji: DVD_TextCharSet = DVD_TextCharSet(2i32);
pub const DVD_CharSet_ShiftJIS_Kanji_Roman_Katakana: DVD_TextCharSet = DVD_TextCharSet(4i32);
pub const DVD_CharSet_Unicode: DVD_TextCharSet = DVD_TextCharSet(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVD_DECODER_CAPS {
    pub dwSize: u32,
    pub dwAudioCaps: u32,
    pub dFwdMaxRateVideo: f64,
    pub dFwdMaxRateAudio: f64,
    pub dFwdMaxRateSP: f64,
    pub dBwdMaxRateVideo: f64,
    pub dBwdMaxRateAudio: f64,
    pub dBwdMaxRateSP: f64,
    pub dwRes1: u32,
    pub dwRes2: u32,
    pub dwRes3: u32,
    pub dwRes4: u32,
}
impl Default for DVD_DECODER_CAPS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DVD_DEFAULT_AUDIO_STREAM: u32 = 15u32;
pub const DVD_DIR_BACKWARD: DVD_PLAY_DIRECTION = DVD_PLAY_DIRECTION(1i32);
pub const DVD_DIR_FORWARD: DVD_PLAY_DIRECTION = DVD_PLAY_DIRECTION(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_DISC_SIDE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_DOMAIN(pub i32);
pub const DVD_DOMAIN_FirstPlay: DVD_DOMAIN = DVD_DOMAIN(1i32);
pub const DVD_DOMAIN_Stop: DVD_DOMAIN = DVD_DOMAIN(5i32);
pub const DVD_DOMAIN_Title: DVD_DOMAIN = DVD_DOMAIN(4i32);
pub const DVD_DOMAIN_VideoManagerMenu: DVD_DOMAIN = DVD_DOMAIN(2i32);
pub const DVD_DOMAIN_VideoTitleSetMenu: DVD_DOMAIN = DVD_DOMAIN(3i32);
pub const DVD_DisableStillThrottle: DVD_OPTION_FLAG = DVD_OPTION_FLAG(14i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_ERROR(pub i32);
pub const DVD_ERROR_CopyProtectFail: DVD_ERROR = DVD_ERROR(2i32);
pub const DVD_ERROR_CopyProtectOutputFail: DVD_ERROR = DVD_ERROR(9i32);
pub const DVD_ERROR_CopyProtectOutputNotSupported: DVD_ERROR = DVD_ERROR(10i32);
pub const DVD_ERROR_IncompatibleDiscAndDecoderRegions: DVD_ERROR = DVD_ERROR(8i32);
pub const DVD_ERROR_IncompatibleSystemAndDecoderRegions: DVD_ERROR = DVD_ERROR(7i32);
pub const DVD_ERROR_InvalidDVD1_0Disc: DVD_ERROR = DVD_ERROR(3i32);
pub const DVD_ERROR_InvalidDiscRegion: DVD_ERROR = DVD_ERROR(4i32);
pub const DVD_ERROR_LowParentalLevel: DVD_ERROR = DVD_ERROR(5i32);
pub const DVD_ERROR_MacrovisionFail: DVD_ERROR = DVD_ERROR(6i32);
pub const DVD_ERROR_Unexpected: DVD_ERROR = DVD_ERROR(1i32);
pub const DVD_EnableCC: DVD_OPTION_FLAG = DVD_OPTION_FLAG(19i32);
pub const DVD_EnableESOutput: DVD_OPTION_FLAG = DVD_OPTION_FLAG(12i32);
pub const DVD_EnableExtendedCopyProtectErrors: DVD_OPTION_FLAG = DVD_OPTION_FLAG(8i32);
pub const DVD_EnableLoggingEvents: DVD_OPTION_FLAG = DVD_OPTION_FLAG(15i32);
pub const DVD_EnableNonblockingAPIs: DVD_OPTION_FLAG = DVD_OPTION_FLAG(5i32);
pub const DVD_EnablePortableBookmarks: DVD_OPTION_FLAG = DVD_OPTION_FLAG(7i32);
pub const DVD_EnableStreaming: DVD_OPTION_FLAG = DVD_OPTION_FLAG(11i32);
pub const DVD_EnableTitleLength: DVD_OPTION_FLAG = DVD_OPTION_FLAG(13i32);
pub const DVD_FPS_25: DVD_FRAMERATE = DVD_FRAMERATE(1i32);
pub const DVD_FPS_30NonDrop: DVD_FRAMERATE = DVD_FRAMERATE(3i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_FRAMERATE(pub i32);
pub const DVD_General_Comments: DVD_TextStringType = DVD_TextStringType(49i32);
pub const DVD_General_Name: DVD_TextStringType = DVD_TextStringType(48i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVD_HMSF_TIMECODE {
    pub bHours: u8,
    pub bMinutes: u8,
    pub bSeconds: u8,
    pub bFrames: u8,
}
impl Default for DVD_HMSF_TIMECODE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DVD_HMSF_TimeCodeEvents: DVD_OPTION_FLAG = DVD_OPTION_FLAG(3i32);
pub const DVD_IncreaseOutputControl: DVD_OPTION_FLAG = DVD_OPTION_FLAG(10i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_KARAOKE_ASSIGNMENT(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_KARAOKE_CONTENTS(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_KARAOKE_DOWNMIX(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVD_KaraokeAttributes {
    pub bVersion: u8,
    pub fMasterOfCeremoniesInGuideVocal1: windows_core::BOOL,
    pub fDuet: windows_core::BOOL,
    pub ChannelAssignment: DVD_KARAOKE_ASSIGNMENT,
    pub wChannelContents: [u16; 8],
}
impl Default for DVD_KaraokeAttributes {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DVD_Karaoke_GuideMelody1: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(4i32);
pub const DVD_Karaoke_GuideMelody2: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(8i32);
pub const DVD_Karaoke_GuideMelodyA: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(16i32);
pub const DVD_Karaoke_GuideMelodyB: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(32i32);
pub const DVD_Karaoke_GuideVocal1: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(1i32);
pub const DVD_Karaoke_GuideVocal2: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(2i32);
pub const DVD_Karaoke_SoundEffectA: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(64i32);
pub const DVD_Karaoke_SoundEffectB: DVD_KARAOKE_CONTENTS = DVD_KARAOKE_CONTENTS(128i32);
pub const DVD_MENU_Angle: DVD_MENU_ID = DVD_MENU_ID(6i32);
pub const DVD_MENU_Audio: DVD_MENU_ID = DVD_MENU_ID(5i32);
pub const DVD_MENU_Chapter: DVD_MENU_ID = DVD_MENU_ID(7i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_MENU_ID(pub i32);
pub const DVD_MENU_Root: DVD_MENU_ID = DVD_MENU_ID(3i32);
pub const DVD_MENU_Subpicture: DVD_MENU_ID = DVD_MENU_ID(4i32);
pub const DVD_MENU_Title: DVD_MENU_ID = DVD_MENU_ID(2i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVD_MUA_Coeff {
    pub log2_alpha: f64,
    pub log2_beta: f64,
}
impl Default for DVD_MUA_Coeff {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVD_MUA_MixingInfo {
    pub fMixTo0: windows_core::BOOL,
    pub fMixTo1: windows_core::BOOL,
    pub fMix0InPhase: windows_core::BOOL,
    pub fMix1InPhase: windows_core::BOOL,
    pub dwSpeakerPosition: u32,
}
impl Default for DVD_MUA_MixingInfo {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DVD_MaxReadBurstInKB: DVD_OPTION_FLAG = DVD_OPTION_FLAG(16i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVD_MenuAttributes {
    pub fCompatibleRegion: [windows_core::BOOL; 8],
    pub VideoAttributes: DVD_VideoAttributes,
    pub fAudioPresent: windows_core::BOOL,
    pub AudioAttributes: DVD_AudioAttributes,
    pub fSubpicturePresent: windows_core::BOOL,
    pub SubpictureAttributes: DVD_SubpictureAttributes,
}
impl Default for DVD_MenuAttributes {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DVD_Mix_0to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(1i32);
pub const DVD_Mix_0to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(256i32);
pub const DVD_Mix_1to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(2i32);
pub const DVD_Mix_1to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(512i32);
pub const DVD_Mix_2to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(4i32);
pub const DVD_Mix_2to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(1024i32);
pub const DVD_Mix_3to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(8i32);
pub const DVD_Mix_3to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(2048i32);
pub const DVD_Mix_4to0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(16i32);
pub const DVD_Mix_4to1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(4096i32);
pub const DVD_Mix_Lto0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(32i32);
pub const DVD_Mix_Lto1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(8192i32);
pub const DVD_Mix_Rto0: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(64i32);
pub const DVD_Mix_Rto1: DVD_KARAOKE_DOWNMIX = DVD_KARAOKE_DOWNMIX(16384i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVD_MultichannelAudioAttributes {
    pub Info: [DVD_MUA_MixingInfo; 8],
    pub Coeff: [DVD_MUA_Coeff; 8],
}
impl Default for DVD_MultichannelAudioAttributes {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_NavCmdType(pub i32);
pub const DVD_NavCmdType_Button: DVD_NavCmdType = DVD_NavCmdType(4i32);
pub const DVD_NavCmdType_Cell: DVD_NavCmdType = DVD_NavCmdType(3i32);
pub const DVD_NavCmdType_Post: DVD_NavCmdType = DVD_NavCmdType(2i32);
pub const DVD_NavCmdType_Pre: DVD_NavCmdType = DVD_NavCmdType(1i32);
pub const DVD_NotifyParentalLevelChange: DVD_OPTION_FLAG = DVD_OPTION_FLAG(2i32);
pub const DVD_NotifyPositionChange: DVD_OPTION_FLAG = DVD_OPTION_FLAG(9i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_OPTION_FLAG(pub i32);
pub const DVD_Other_Cut: DVD_TextStringType = DVD_TextStringType(81i32);
pub const DVD_Other_Scene: DVD_TextStringType = DVD_TextStringType(80i32);
pub const DVD_Other_Take: DVD_TextStringType = DVD_TextStringType(82i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_PARENTAL_LEVEL(pub i32);
pub const DVD_PARENTAL_LEVEL_1: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(256i32);
pub const DVD_PARENTAL_LEVEL_2: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(512i32);
pub const DVD_PARENTAL_LEVEL_3: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(1024i32);
pub const DVD_PARENTAL_LEVEL_4: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(2048i32);
pub const DVD_PARENTAL_LEVEL_5: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(4096i32);
pub const DVD_PARENTAL_LEVEL_6: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(8192i32);
pub const DVD_PARENTAL_LEVEL_7: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(16384i32);
pub const DVD_PARENTAL_LEVEL_8: DVD_PARENTAL_LEVEL = DVD_PARENTAL_LEVEL(32768i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_PB_STOPPED(pub i32);
pub const DVD_PB_STOPPED_CopyProtectFailure: DVD_PB_STOPPED = DVD_PB_STOPPED(13i32);
pub const DVD_PB_STOPPED_CopyProtectOutputFailure: DVD_PB_STOPPED = DVD_PB_STOPPED(14i32);
pub const DVD_PB_STOPPED_CopyProtectOutputNotSupported: DVD_PB_STOPPED = DVD_PB_STOPPED(15i32);
pub const DVD_PB_STOPPED_DiscEjected: DVD_PB_STOPPED = DVD_PB_STOPPED(5i32);
pub const DVD_PB_STOPPED_DiscReadError: DVD_PB_STOPPED = DVD_PB_STOPPED(12i32);
pub const DVD_PB_STOPPED_IllegalNavCommand: DVD_PB_STOPPED = DVD_PB_STOPPED(6i32);
pub const DVD_PB_STOPPED_MacrovisionFailure: DVD_PB_STOPPED = DVD_PB_STOPPED(11i32);
pub const DVD_PB_STOPPED_NoBranch: DVD_PB_STOPPED = DVD_PB_STOPPED(1i32);
pub const DVD_PB_STOPPED_NoFirstPlayDomain: DVD_PB_STOPPED = DVD_PB_STOPPED(2i32);
pub const DVD_PB_STOPPED_Other: DVD_PB_STOPPED = DVD_PB_STOPPED(0i32);
pub const DVD_PB_STOPPED_ParentalFailure: DVD_PB_STOPPED = DVD_PB_STOPPED(9i32);
pub const DVD_PB_STOPPED_PlayChapterAutoStop: DVD_PB_STOPPED = DVD_PB_STOPPED(8i32);
pub const DVD_PB_STOPPED_PlayPeriodAutoStop: DVD_PB_STOPPED = DVD_PB_STOPPED(7i32);
pub const DVD_PB_STOPPED_RegionFailure: DVD_PB_STOPPED = DVD_PB_STOPPED(10i32);
pub const DVD_PB_STOPPED_Reset: DVD_PB_STOPPED = DVD_PB_STOPPED(4i32);
pub const DVD_PB_STOPPED_StopCommand: DVD_PB_STOPPED = DVD_PB_STOPPED(3i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVD_PLAYBACK_LOCATION {
    pub TitleNum: u32,
    pub ChapterNum: u32,
    pub TimeCode: u32,
}
impl Default for DVD_PLAYBACK_LOCATION {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVD_PLAYBACK_LOCATION2 {
    pub TitleNum: u32,
    pub ChapterNum: u32,
    pub TimeCode: DVD_HMSF_TIMECODE,
    pub TimeCodeFlags: u32,
}
impl Default for DVD_PLAYBACK_LOCATION2 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_PLAY_DIRECTION(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_PREFERRED_DISPLAY_MODE(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_RELATIVE_BUTTON(pub i32);
pub const DVD_ReadBurstPeriodInMS: DVD_OPTION_FLAG = DVD_OPTION_FLAG(17i32);
pub const DVD_Relative_Left: DVD_RELATIVE_BUTTON = DVD_RELATIVE_BUTTON(3i32);
pub const DVD_Relative_Lower: DVD_RELATIVE_BUTTON = DVD_RELATIVE_BUTTON(2i32);
pub const DVD_Relative_Right: DVD_RELATIVE_BUTTON = DVD_RELATIVE_BUTTON(4i32);
pub const DVD_Relative_Upper: DVD_RELATIVE_BUTTON = DVD_RELATIVE_BUTTON(1i32);
pub const DVD_ResetOnStop: DVD_OPTION_FLAG = DVD_OPTION_FLAG(1i32);
pub const DVD_RestartDisc: DVD_OPTION_FLAG = DVD_OPTION_FLAG(18i32);
pub const DVD_SIDE_A: DVD_DISC_SIDE = DVD_DISC_SIDE(1i32);
pub const DVD_SIDE_B: DVD_DISC_SIDE = DVD_DISC_SIDE(2i32);
pub const DVD_SPCoding_Extended: DVD_SUBPICTURE_CODING = DVD_SUBPICTURE_CODING(1i32);
pub const DVD_SPCoding_Other: DVD_SUBPICTURE_CODING = DVD_SUBPICTURE_CODING(2i32);
pub const DVD_SPCoding_RunLength: DVD_SUBPICTURE_CODING = DVD_SUBPICTURE_CODING(0i32);
pub const DVD_SPType_Language: DVD_SUBPICTURE_TYPE = DVD_SUBPICTURE_TYPE(1i32);
pub const DVD_SPType_NotSpecified: DVD_SUBPICTURE_TYPE = DVD_SUBPICTURE_TYPE(0i32);
pub const DVD_SPType_Other: DVD_SUBPICTURE_TYPE = DVD_SUBPICTURE_TYPE(2i32);
pub const DVD_SP_EXT_CC_Big: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(6i32);
pub const DVD_SP_EXT_CC_Children: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(7i32);
pub const DVD_SP_EXT_CC_Normal: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(5i32);
pub const DVD_SP_EXT_Caption_Big: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(2i32);
pub const DVD_SP_EXT_Caption_Children: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(3i32);
pub const DVD_SP_EXT_Caption_Normal: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(1i32);
pub const DVD_SP_EXT_DirectorComments_Big: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(14i32);
pub const DVD_SP_EXT_DirectorComments_Children: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(15i32);
pub const DVD_SP_EXT_DirectorComments_Normal: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(13i32);
pub const DVD_SP_EXT_Forced: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(9i32);
pub const DVD_SP_EXT_NotSpecified: DVD_SUBPICTURE_LANG_EXT = DVD_SUBPICTURE_LANG_EXT(0i32);
pub const DVD_STREAM_DATA_CURRENT: u32 = 2048u32;
pub const DVD_STREAM_DATA_VMGM: u32 = 1024u32;
pub const DVD_STREAM_DATA_VTSM: u32 = 1025u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_SUBPICTURE_CODING(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_SUBPICTURE_LANG_EXT(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_SUBPICTURE_TYPE(pub i32);
pub const DVD_Stream_Angle: DVD_TextStringType = DVD_TextStringType(18i32);
pub const DVD_Stream_Audio: DVD_TextStringType = DVD_TextStringType(16i32);
pub const DVD_Stream_Subpicture: DVD_TextStringType = DVD_TextStringType(17i32);
pub const DVD_Struct_Cell: DVD_TextStringType = DVD_TextStringType(5i32);
pub const DVD_Struct_ParentalID: DVD_TextStringType = DVD_TextStringType(3i32);
pub const DVD_Struct_PartOfTitle: DVD_TextStringType = DVD_TextStringType(4i32);
pub const DVD_Struct_Title: DVD_TextStringType = DVD_TextStringType(2i32);
pub const DVD_Struct_Volume: DVD_TextStringType = DVD_TextStringType(1i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVD_SubpictureAttributes {
    pub Type: DVD_SUBPICTURE_TYPE,
    pub CodingMode: DVD_SUBPICTURE_CODING,
    pub Language: u32,
    pub LanguageExtension: DVD_SUBPICTURE_LANG_EXT,
}
impl Default for DVD_SubpictureAttributes {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DVD_TC_FLAG_25fps: DVD_TIMECODE_FLAGS = DVD_TIMECODE_FLAGS(1i32);
pub const DVD_TC_FLAG_30fps: DVD_TIMECODE_FLAGS = DVD_TIMECODE_FLAGS(2i32);
pub const DVD_TC_FLAG_DropFrame: DVD_TIMECODE_FLAGS = DVD_TIMECODE_FLAGS(4i32);
pub const DVD_TC_FLAG_Interpolated: DVD_TIMECODE_FLAGS = DVD_TIMECODE_FLAGS(8i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVD_TIMECODE {
    pub _bitfield: u32,
}
impl Default for DVD_TIMECODE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_TIMECODE_FLAGS(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_TITLE_APPMODE(pub i32);
pub const DVD_TITLE_MENU: u32 = 0u32;
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_TextCharSet(pub i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_TextStringType(pub i32);
#[repr(C)]
#[derive(Clone, Copy)]
pub struct DVD_TitleAttributes {
    pub Anonymous: DVD_TitleAttributes_0,
    pub VideoAttributes: DVD_VideoAttributes,
    pub ulNumberOfAudioStreams: u32,
    pub AudioAttributes: [DVD_AudioAttributes; 8],
    pub MultichannelAudioAttributes: [DVD_MultichannelAudioAttributes; 8],
    pub ulNumberOfSubpictureStreams: u32,
    pub SubpictureAttributes: [DVD_SubpictureAttributes; 32],
}
impl Default for DVD_TitleAttributes {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy)]
pub union DVD_TitleAttributes_0 {
    pub AppMode: DVD_TITLE_APPMODE,
    pub TitleLength: DVD_HMSF_TIMECODE,
}
impl Default for DVD_TitleAttributes_0 {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DVD_Title_Album: DVD_TextStringType = DVD_TextStringType(59i32);
pub const DVD_Title_Movie: DVD_TextStringType = DVD_TextStringType(57i32);
pub const DVD_Title_Orig_Album: DVD_TextStringType = DVD_TextStringType(75i32);
pub const DVD_Title_Orig_Movie: DVD_TextStringType = DVD_TextStringType(73i32);
pub const DVD_Title_Orig_Other: DVD_TextStringType = DVD_TextStringType(79i32);
pub const DVD_Title_Orig_Series: DVD_TextStringType = DVD_TextStringType(72i32);
pub const DVD_Title_Orig_Song: DVD_TextStringType = DVD_TextStringType(76i32);
pub const DVD_Title_Orig_Video: DVD_TextStringType = DVD_TextStringType(74i32);
pub const DVD_Title_Other: DVD_TextStringType = DVD_TextStringType(63i32);
pub const DVD_Title_Series: DVD_TextStringType = DVD_TextStringType(56i32);
pub const DVD_Title_Song: DVD_TextStringType = DVD_TextStringType(60i32);
pub const DVD_Title_Sub_Album: DVD_TextStringType = DVD_TextStringType(67i32);
pub const DVD_Title_Sub_Movie: DVD_TextStringType = DVD_TextStringType(65i32);
pub const DVD_Title_Sub_Other: DVD_TextStringType = DVD_TextStringType(71i32);
pub const DVD_Title_Sub_Series: DVD_TextStringType = DVD_TextStringType(64i32);
pub const DVD_Title_Sub_Song: DVD_TextStringType = DVD_TextStringType(68i32);
pub const DVD_Title_Sub_Video: DVD_TextStringType = DVD_TextStringType(66i32);
pub const DVD_Title_Video: DVD_TextStringType = DVD_TextStringType(58i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_VIDEO_COMPRESSION(pub i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVD_VideoAttributes {
    pub fPanscanPermitted: windows_core::BOOL,
    pub fLetterboxPermitted: windows_core::BOOL,
    pub ulAspectX: u32,
    pub ulAspectY: u32,
    pub ulFrameRate: u32,
    pub ulFrameHeight: u32,
    pub Compression: DVD_VIDEO_COMPRESSION,
    pub fLine21Field1InGOP: windows_core::BOOL,
    pub fLine21Field2InGOP: windows_core::BOOL,
    pub ulSourceResolutionX: u32,
    pub ulSourceResolutionY: u32,
    pub fIsSourceLetterboxed: windows_core::BOOL,
    pub fIsFilmMode: windows_core::BOOL,
}
impl Default for DVD_VideoAttributes {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DVD_VideoCompression_MPEG1: DVD_VIDEO_COMPRESSION = DVD_VIDEO_COMPRESSION(1i32);
pub const DVD_VideoCompression_MPEG2: DVD_VIDEO_COMPRESSION = DVD_VIDEO_COMPRESSION(2i32);
pub const DVD_VideoCompression_Other: DVD_VIDEO_COMPRESSION = DVD_VIDEO_COMPRESSION(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DVD_WARNING(pub i32);
pub const DVD_WARNING_FormatNotSupported: DVD_WARNING = DVD_WARNING(2i32);
pub const DVD_WARNING_IllegalNavCommand: DVD_WARNING = DVD_WARNING(3i32);
pub const DVD_WARNING_InvalidDVD1_0Disc: DVD_WARNING = DVD_WARNING(1i32);
pub const DVD_WARNING_Open: DVD_WARNING = DVD_WARNING(4i32);
pub const DVD_WARNING_Read: DVD_WARNING = DVD_WARNING(6i32);
pub const DVD_WARNING_Seek: DVD_WARNING = DVD_WARNING(5i32);
pub const DVENCODERFORMAT_DVHD: _DVENCODERFORMAT = _DVENCODERFORMAT(2008i32);
pub const DVENCODERFORMAT_DVSD: _DVENCODERFORMAT = _DVENCODERFORMAT(2007i32);
pub const DVENCODERFORMAT_DVSL: _DVENCODERFORMAT = _DVENCODERFORMAT(2009i32);
pub const DVENCODERRESOLUTION_180x120: _DVENCODERRESOLUTION = _DVENCODERRESOLUTION(2014i32);
pub const DVENCODERRESOLUTION_360x240: _DVENCODERRESOLUTION = _DVENCODERRESOLUTION(2013i32);
pub const DVENCODERRESOLUTION_720x480: _DVENCODERRESOLUTION = _DVENCODERRESOLUTION(2012i32);
pub const DVENCODERRESOLUTION_88x60: _DVENCODERRESOLUTION = _DVENCODERRESOLUTION(2015i32);
pub const DVENCODERVIDEOFORMAT_NTSC: _DVENCODERVIDEOFORMAT = _DVENCODERVIDEOFORMAT(2000i32);
pub const DVENCODERVIDEOFORMAT_PAL: _DVENCODERVIDEOFORMAT = _DVENCODERVIDEOFORMAT(2001i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DVINFO {
    pub dwDVAAuxSrc: u32,
    pub dwDVAAuxCtl: u32,
    pub dwDVAAuxSrc1: u32,
    pub dwDVAAuxCtl1: u32,
    pub dwDVVAuxSrc: u32,
    pub dwDVVAuxCtl: u32,
    pub dwDVReserved: [u32; 2],
}
impl Default for DVINFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DVRESOLUTION_DC: _DVRESOLUTION = _DVRESOLUTION(1003i32);
pub const DVRESOLUTION_FULL: _DVRESOLUTION = _DVRESOLUTION(1000i32);
pub const DVRESOLUTION_HALF: _DVRESOLUTION = _DVRESOLUTION(1001i32);
pub const DVRESOLUTION_QUARTER: _DVRESOLUTION = _DVRESOLUTION(1002i32);
pub const DWORD_ALLPARAMS: i32 = -1i32;
#[repr(C)]
#[cfg(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA2SW_CALLBACKS {
    pub Size: u32,
    pub GetVideoProcessorRenderTargetCount: PDXVA2SW_GETVIDEOPROCESSORRENDERTARGETCOUNT,
    pub GetVideoProcessorRenderTargets: PDXVA2SW_GETVIDEOPROCESSORRENDERTARGETS,
    pub GetVideoProcessorCaps: PDXVA2SW_GETVIDEOPROCESSORCAPS,
    pub GetVideoProcessorSubStreamFormatCount: PDXVA2SW_GETVIDEOPROCESSORSUBSTREAMFORMATCOUNT,
    pub GetVideoProcessorSubStreamFormats: PDXVA2SW_GETVIDEOPROCESSORSUBSTREAMFORMATS,
    pub GetProcAmpRange: PDXVA2SW_GETPROCAMPRANGE,
    pub GetFilterPropertyRange: PDXVA2SW_GETFILTERPROPERTYRANGE,
    pub CreateVideoProcessDevice: PDXVA2SW_CREATEVIDEOPROCESSDEVICE,
    pub DestroyVideoProcessDevice: PDXVA2SW_DESTROYVIDEOPROCESSDEVICE,
    pub VideoProcessBeginFrame: PDXVA2SW_VIDEOPROCESSBEGINFRAME,
    pub VideoProcessEndFrame: PDXVA2SW_VIDEOPROCESSENDFRAME,
    pub VideoProcessSetRenderTarget: PDXVA2SW_VIDEOPROCESSSETRENDERTARGET,
    pub VideoProcessBlt: PDXVA2SW_VIDEOPROCESSBLT,
}
#[cfg(all(feature = "Win32_Graphics_Direct3D9", feature = "Win32_Media_MediaFoundation"))]
impl Default for DXVA2SW_CALLBACKS {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[derive(Clone, Copy)]
pub struct DXVA2TraceVideoProcessBltData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub pRenderTarget: u64,
    pub TargetFrameTime: u64,
    pub TargetRect: super::super::Foundation::RECT,
    pub Enter: windows_core::BOOL,
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
impl Default for DXVA2TraceVideoProcessBltData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA2Trace_Control: windows_core::GUID = windows_core::GUID::from_u128(0xa0386e75_f70c_464c_a9ce_33c44e091623);
pub const DXVA2Trace_DecodeDevBeginFrame: windows_core::GUID = windows_core::GUID::from_u128(0x9fd1acf6_44cb_4637_bc62_2c11a9608f90);
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[derive(Clone, Copy)]
pub struct DXVA2Trace_DecodeDevBeginFrameData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub pRenderTarget: u64,
    pub Enter: windows_core::BOOL,
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
impl Default for DXVA2Trace_DecodeDevBeginFrameData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA2Trace_DecodeDevCreated: windows_core::GUID = windows_core::GUID::from_u128(0xb4de17a1_c5b2_44fe_86d5_d97a648114ff);
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[derive(Clone, Copy)]
pub struct DXVA2Trace_DecodeDevCreatedData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub pD3DDevice: u64,
    pub DeviceGuid: windows_core::GUID,
    pub Width: u32,
    pub Height: u32,
    pub Enter: windows_core::BOOL,
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
impl Default for DXVA2Trace_DecodeDevCreatedData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA2Trace_DecodeDevDestroyed: windows_core::GUID = windows_core::GUID::from_u128(0x853ebdf2_4160_421d_8893_63dcea4f18bb);
pub const DXVA2Trace_DecodeDevEndFrame: windows_core::GUID = windows_core::GUID::from_u128(0x9fb3cb33_47dc_4899_98c8_c0c6cd7cd3cb);
pub const DXVA2Trace_DecodeDevExecute: windows_core::GUID = windows_core::GUID::from_u128(0x850aeb4c_d19a_4609_b3b4_bcbf0e22121e);
pub const DXVA2Trace_DecodeDevGetBuffer: windows_core::GUID = windows_core::GUID::from_u128(0x57b128fb_72cb_4137_a575_d91fa3160897);
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[derive(Clone, Copy)]
pub struct DXVA2Trace_DecodeDevGetBufferData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub BufferType: u32,
    pub Enter: windows_core::BOOL,
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
impl Default for DXVA2Trace_DecodeDevGetBufferData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[derive(Clone, Copy)]
pub struct DXVA2Trace_DecodeDeviceData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub Enter: windows_core::BOOL,
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
impl Default for DXVA2Trace_DecodeDeviceData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA2Trace_VideoProcessBlt: windows_core::GUID = windows_core::GUID::from_u128(0x69089cc0_71ab_42d0_953a_2887bf05a8af);
pub const DXVA2Trace_VideoProcessDevCreated: windows_core::GUID = windows_core::GUID::from_u128(0x895508c6_540d_4c87_98f8_8dcbf2dabb2a);
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[derive(Clone, Copy)]
pub struct DXVA2Trace_VideoProcessDevCreatedData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub pD3DDevice: u64,
    pub DeviceGuid: windows_core::GUID,
    pub RTFourCC: u32,
    pub Width: u32,
    pub Height: u32,
    pub Enter: windows_core::BOOL,
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
impl Default for DXVA2Trace_VideoProcessDevCreatedData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA2Trace_VideoProcessDevDestroyed: windows_core::GUID = windows_core::GUID::from_u128(0xf97f30b1_fb49_42c7_8ee8_88bdfa92d4e2);
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[derive(Clone, Copy)]
pub struct DXVA2Trace_VideoProcessDeviceData {
    pub wmiHeader: super::super::System::Diagnostics::Etw::EVENT_TRACE_HEADER,
    pub pObject: u64,
    pub Enter: windows_core::BOOL,
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
impl Default for DXVA2Trace_VideoProcessDeviceData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA2_DestinationFlagMask: DXVA2_DestinationFlags = DXVA2_DestinationFlags(-65521i32);
pub const DXVA2_DestinationFlag_Alpha_Changed: DXVA2_DestinationFlags = DXVA2_DestinationFlags(8i32);
pub const DXVA2_DestinationFlag_Background_Changed: DXVA2_DestinationFlags = DXVA2_DestinationFlags(1i32);
pub const DXVA2_DestinationFlag_ColorData_Changed: DXVA2_DestinationFlags = DXVA2_DestinationFlags(4i32);
pub const DXVA2_DestinationFlag_RFF: DXVA2_DestinationFlags = DXVA2_DestinationFlags(65536i32);
pub const DXVA2_DestinationFlag_RFF_TFF_Present: DXVA2_DestinationFlags = DXVA2_DestinationFlags(262144i32);
pub const DXVA2_DestinationFlag_TFF: DXVA2_DestinationFlags = DXVA2_DestinationFlags(131072i32);
pub const DXVA2_DestinationFlag_TargetRect_Changed: DXVA2_DestinationFlags = DXVA2_DestinationFlags(2i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_DestinationFlags(pub i32);
pub const DXVA2_SampleFlag_ColorData_Changed: DXVA2_SampleFlags = DXVA2_SampleFlags(8i32);
pub const DXVA2_SampleFlag_DstRect_Changed: DXVA2_SampleFlags = DXVA2_SampleFlags(4i32);
pub const DXVA2_SampleFlag_Palette_Changed: DXVA2_SampleFlags = DXVA2_SampleFlags(1i32);
pub const DXVA2_SampleFlag_PlanarAlpha_Changed: DXVA2_SampleFlags = DXVA2_SampleFlags(16i32);
pub const DXVA2_SampleFlag_RFF: DXVA2_SampleFlags = DXVA2_SampleFlags(65536i32);
pub const DXVA2_SampleFlag_RFF_TFF_Present: DXVA2_SampleFlags = DXVA2_SampleFlags(262144i32);
pub const DXVA2_SampleFlag_SrcRect_Changed: DXVA2_SampleFlags = DXVA2_SampleFlags(2i32);
pub const DXVA2_SampleFlag_TFF: DXVA2_SampleFlags = DXVA2_SampleFlags(131072i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct DXVA2_SampleFlags(pub i32);
pub const DXVA2_SampleFlagsMask: DXVA2_SampleFlags = DXVA2_SampleFlags(-65505i32);
#[repr(C)]
#[cfg(feature = "Win32_Media_MediaFoundation")]
#[derive(Clone, Copy)]
pub struct DXVA2_VIDEOPROCESSBLT {
    pub TargetFrame: i64,
    pub TargetRect: super::super::Foundation::RECT,
    pub ConstrictionSize: super::super::Foundation::SIZE,
    pub StreamingFlags: u32,
    pub BackgroundColor: super::MediaFoundation::DXVA2_AYUVSample16,
    pub DestFormat: super::MediaFoundation::DXVA2_ExtendedFormat,
    pub DestFlags: u32,
    pub ProcAmpValues: super::MediaFoundation::DXVA2_ProcAmpValues,
    pub Alpha: super::MediaFoundation::DXVA2_Fixed32,
    pub NoiseFilterLuma: super::MediaFoundation::DXVA2_FilterValues,
    pub NoiseFilterChroma: super::MediaFoundation::DXVA2_FilterValues,
    pub DetailFilterLuma: super::MediaFoundation::DXVA2_FilterValues,
    pub DetailFilterChroma: super::MediaFoundation::DXVA2_FilterValues,
    pub pSrcSurfaces: *mut DXVA2_VIDEOSAMPLE,
    pub NumSrcSurfaces: u32,
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl Default for DXVA2_VIDEOPROCESSBLT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Media_MediaFoundation")]
#[derive(Clone, Copy)]
pub struct DXVA2_VIDEOSAMPLE {
    pub Start: i64,
    pub End: i64,
    pub SampleFormat: super::MediaFoundation::DXVA2_ExtendedFormat,
    pub SampleFlags: u32,
    pub SrcResource: *mut core::ffi::c_void,
    pub SrcRect: super::super::Foundation::RECT,
    pub DstRect: super::super::Foundation::RECT,
    pub Pal: [super::MediaFoundation::DXVA2_AYUVSample8; 16],
    pub PlanarAlpha: super::MediaFoundation::DXVA2_Fixed32,
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl Default for DXVA2_VIDEOSAMPLE {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA_ALPHA_BLEND_COMBINATION_BUFFER: u32 = 13u32;
pub const DXVA_ALPHA_BLEND_COMBINATION_FUNCTION: u32 = 3u32;
pub const DXVA_ALPHA_BLEND_DATA_LOAD_FUNCTION: u32 = 2u32;
pub const DXVA_AYUV_BUFFER: u32 = 8u32;
pub const DXVA_BIDIRECTIONAL_AVERAGING_H263_TRUNC: u32 = 1u32;
pub const DXVA_BIDIRECTIONAL_AVERAGING_MPEG2_ROUND: u32 = 0u32;
pub const DXVA_BITSTREAM_CONCEALMENT_METHOD_BACKWARD: u32 = 3u32;
pub const DXVA_BITSTREAM_CONCEALMENT_METHOD_FORWARD: u32 = 2u32;
pub const DXVA_BITSTREAM_CONCEALMENT_METHOD_INTRA: u32 = 1u32;
pub const DXVA_BITSTREAM_CONCEALMENT_METHOD_UNSPECIFIED: u32 = 0u32;
pub const DXVA_BITSTREAM_CONCEALMENT_NEED_LIKELY: u32 = 2u32;
pub const DXVA_BITSTREAM_CONCEALMENT_NEED_MILD: u32 = 1u32;
pub const DXVA_BITSTREAM_CONCEALMENT_NEED_SEVERE: u32 = 3u32;
pub const DXVA_BITSTREAM_CONCEALMENT_NEED_UNLIKELY: u32 = 0u32;
pub const DXVA_BITSTREAM_DATA_BUFFER: u32 = 7u32;
pub const DXVA_CHROMA_FORMAT_420: u32 = 1u32;
pub const DXVA_CHROMA_FORMAT_422: u32 = 2u32;
pub const DXVA_CHROMA_FORMAT_444: u32 = 3u32;
pub const DXVA_COMPBUFFER_TYPE_THAT_IS_NOT_USED: u32 = 0u32;
pub const DXVA_CONFIG_BLEND_TYPE_BACK_HARDWARE: u32 = 1u32;
pub const DXVA_CONFIG_BLEND_TYPE_FRONT_BUFFER: u32 = 0u32;
pub const DXVA_CONFIG_DATA_TYPE_AI44: u32 = 1u32;
pub const DXVA_CONFIG_DATA_TYPE_AYUV: u32 = 3u32;
pub const DXVA_CONFIG_DATA_TYPE_DPXD: u32 = 2u32;
pub const DXVA_CONFIG_DATA_TYPE_IA44: u32 = 0u32;
pub const DXVA_COPPCommandFnCode: u32 = 4u32;
pub const DXVA_COPPDevice: windows_core::GUID = windows_core::GUID::from_u128(0xd2457add_8999_45ed_8a8a_d1aa047ba4d5);
pub const DXVA_COPPGetCertificateLengthFnCode: u32 = 1u32;
pub const DXVA_COPPKeyExchangeFnCode: u32 = 2u32;
pub const DXVA_COPPQueryBusData: windows_core::GUID = windows_core::GUID::from_u128(0xc6f4d673_6174_4184_8e35_f6db5200bcba);
pub const DXVA_COPPQueryConnectorType: windows_core::GUID = windows_core::GUID::from_u128(0x81d0bfd5_6afe_48c2_99c0_95a08f97c5da);
pub const DXVA_COPPQueryDisplayData: windows_core::GUID = windows_core::GUID::from_u128(0xd7bf1ba3_ad13_4f8e_af98_0dcb3ca204cc);
pub const DXVA_COPPQueryGlobalProtectionLevel: windows_core::GUID = windows_core::GUID::from_u128(0x1957210a_7766_452a_b99a_d27aed54f03a);
pub const DXVA_COPPQueryHDCPKeyData: windows_core::GUID = windows_core::GUID::from_u128(0x0db59d74_a992_492e_a0bd_c23fda564e00);
pub const DXVA_COPPQueryLocalProtectionLevel: windows_core::GUID = windows_core::GUID::from_u128(0xb2075857_3eda_4d5d_88db_748f8c1a0549);
pub const DXVA_COPPQueryProtectionType: windows_core::GUID = windows_core::GUID::from_u128(0x38f2a801_9a6c_48bb_9107_b6696e6f1797);
pub const DXVA_COPPQuerySignaling: windows_core::GUID = windows_core::GUID::from_u128(0x6629a591_3b79_4cf3_924a_11e8e7811671);
pub const DXVA_COPPQueryStatusFnCode: u32 = 5u32;
pub const DXVA_COPPSequenceStartFnCode: u32 = 3u32;
pub const DXVA_COPPSetProtectionLevel: windows_core::GUID = windows_core::GUID::from_u128(0x9bb9327c_4eb5_4727_9f00_b42b0919c0da);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_COPPSetProtectionLevelCmdData {
    pub ProtType: u32,
    pub ProtLevel: u32,
    pub ExtendedInfoChangeMask: u32,
    pub ExtendedInfoData: u32,
}
impl Default for DXVA_COPPSetProtectionLevelCmdData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA_COPPSetSignaling: windows_core::GUID = windows_core::GUID::from_u128(0x09a631a5_d684_4c60_8e4d_d3bb0f0be3ee);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_COPPSetSignalingCmdData {
    pub ActiveTVProtectionStandard: u32,
    pub AspectRatioChangeMask1: u32,
    pub AspectRatioData1: u32,
    pub AspectRatioChangeMask2: u32,
    pub AspectRatioData2: u32,
    pub AspectRatioChangeMask3: u32,
    pub AspectRatioData3: u32,
    pub ExtendedInfoChangeMask: [u32; 4],
    pub ExtendedInfoData: [u32; 4],
    pub Reserved: u32,
}
impl Default for DXVA_COPPSetSignalingCmdData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_COPPStatusData {
    pub rApp: windows_core::GUID,
    pub dwFlags: u32,
    pub dwData: u32,
    pub ExtendedInfoValidMask: u32,
    pub ExtendedInfoData: u32,
}
impl Default for DXVA_COPPStatusData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_COPPStatusDisplayData {
    pub rApp: windows_core::GUID,
    pub dwFlags: u32,
    pub DisplayWidth: u32,
    pub DisplayHeight: u32,
    pub Format: u32,
    pub d3dFormat: u32,
    pub FreqNumerator: u32,
    pub FreqDenominator: u32,
}
impl Default for DXVA_COPPStatusDisplayData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_COPPStatusHDCPKeyData {
    pub rApp: windows_core::GUID,
    pub dwFlags: u32,
    pub dwHDCPFlags: u32,
    pub BKey: windows_core::GUID,
    pub Reserved1: windows_core::GUID,
    pub Reserved2: windows_core::GUID,
}
impl Default for DXVA_COPPStatusHDCPKeyData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct DXVA_COPPStatusSignalingCmdData {
    pub rApp: windows_core::GUID,
    pub dwFlags: u32,
    pub AvailableTVProtectionStandards: u32,
    pub ActiveTVProtectionStandard: u32,
    pub TVType: u32,
    pub AspectRatioValidMask1: u32,
    pub AspectRatioData1: u32,
    pub AspectRatioValidMask2: u32,
    pub AspectRatioData2: u32,
    pub AspectRatioValidMask3: u32,
    pub AspectRatioData3: u32,
    pub ExtendedInfoValidMask: [u32; 4],
    pub ExtendedInfoData: [u32; 4],
}
impl Default for DXVA_COPPStatusSignalingCmdData {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const DXVA_DCCMD_SURFACE_BUFFER: u32 = 12u32;
pub const DXVA_DEBLOCKING_CONTROL_BUFFER: u32 = 4u32;
pub const DXVA_DEBLOCKING_FILTER_FUNCTION: u32 = 5u32;
pub const DXVA_DPXD_SURFACE_BUFFER: u32 = 10u32;
pub const DXVA_DeinterlaceBltExFnCode: u32 = 2u32;
pub const DXVA_DeinterlaceBltFnCode: u32 = 1u32;
pub const DXVA_DeinterlaceBobDevice: windows_core::GUID = windows_core::GUID::from_u128(0x335aa36e_7884_43a4_9c91_7f87faf3e37e);
pub const DXVA_DeinterlaceContainerDevice: windows_core::GUID = windows_core::GUID::from_u128(0x0e85cb93_3046_4ff0_aecc_d58cb5f035fd);
pub const DXVA_DeinterlaceQueryAvailableModesFnCode: u32 = 1u32;
pub const DXVA_DeinterlaceQueryModeCapsFnCode: u32 = 2u32;
pub const DXVA_ENCRYPTPROTOCOLFUNCFLAG_ACCEL: u32 = 16776968u32;
pub const DXVA_ENCRYPTPROTOCOLFUNCFLAG_HOST: u32 = 16776960u32;
pub const DXVA_EXECUTE_RETURN_DATA_ERROR_MINOR: u32 = 1u32;
pub const DXVA_EXECUTE_RETURN_DATA_ERROR_SEVERE: u32 = 3u32;
pub const DXVA_EXECUTE_RETURN_DATA_ERROR_SIGNIF: u32 = 2u32;
pub const DXVA_EXECUTE_RETURN_OK: u32 = 0u32;
pub const DXVA_EXECUTE_RETURN_OTHER_ERROR_SEVERE: u32 = 4u32;
pub const DXVA_ExtColorData_ShiftBase: u32 = 8u32;
pub const DXVA_FILM_GRAIN_BUFFER: u32 = 17u32;
pub const DXVA_FILM_GRAIN_SYNTHESIS_FUNCTION: u32 = 6u32;
pub const DXVA_HIGHLIGHT_BUFFER: u32 = 11u32;
pub const DXVA_IA44_SURFACE_BUFFER: u32 = 9u32;
pub const DXVA_INVERSE_QUANTIZATION_MATRIX_BUFFER: u32 = 5u32;
pub const DXVA_MACROBLOCK_CONTROL_BUFFER: u32 = 2u32;
pub const DXVA_MOTION_VECTOR_BUFFER: u32 = 16u32;
pub const DXVA_MV_PRECISION_AND_CHROMA_RELATION_H261: u32 = 2u32;
pub const DXVA_MV_PRECISION_AND_CHROMA_RELATION_H263: u32 = 1u32;
pub const DXVA_MV_PRECISION_AND_CHROMA_RELATION_MPEG2: u32 = 0u32;
pub const DXVA_ModeAV1_VLD_12bit_Profile2: windows_core::GUID = windows_core::GUID::from_u128(0x17127009_a00f_4ce1_994e_bf4081f6f3f0);
pub const DXVA_ModeAV1_VLD_12bit_Profile2_420: windows_core::GUID = windows_core::GUID::from_u128(0x2d80bed6_9cac_4835_9e91_327bbc4f9ee8);
pub const DXVA_ModeAV1_VLD_Profile0: windows_core::GUID = windows_core::GUID::from_u128(0xb8be4ccb_cf53_46ba_8d59_d6b8a6da5d2a);
pub const DXVA_ModeAV1_VLD_Profile1: windows_core::GUID = windows_core::GUID::from_u128(0x6936ff0f_45b1_4163_9cc1_646ef6946108);
pub const DXVA_ModeAV1_VLD_Profile2: windows_core::GUID = windows_core::GUID::from_u128(0x0c5f2aa1_e541_4089_bb7b_98110a19d7c8);
pub const DXVA_ModeH261_A: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be01_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH261_B: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be02_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH263_A: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be03_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH263_B: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be04_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH263_C: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be05_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH263_D: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be06_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH263_E: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be07_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH263_F: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be08_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH264_A: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be64_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH264_B: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be65_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH264_C: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be66_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH264_D: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be67_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH264_E: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be68_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH264_F: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be69_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeH264_VLD_Multiview_NoFGT: windows_core::GUID = windows_core::GUID::from_u128(0x705b9d82_76cf_49d6_b7e6_ac8872db013c);
pub const DXVA_ModeH264_VLD_Stereo_NoFGT: windows_core::GUID = windows_core::GUID::from_u128(0xf9aaccbb_c2b6_4cfc_8779_5707b1760552);
pub const DXVA_ModeH264_VLD_Stereo_Progressive_NoFGT: windows_core::GUID = windows_core::GUID::from_u128(0xd79be8da_0cf1_4c81_b82a_69a4e236f43d);
pub const DXVA_ModeH264_VLD_WithFMOASO_NoFGT: windows_core::GUID = windows_core::GUID::from_u128(0xd5f04ff9_3418_45d8_9561_32a76aae2ddd);
pub const DXVA_ModeHEVC_VLD_Main: windows_core::GUID = windows_core::GUID::from_u128(0x5b11d51b_2f4c_4452_bcc3_09f2a1160cc0);
pub const DXVA_ModeHEVC_VLD_Main10: windows_core::GUID = windows_core::GUID::from_u128(0x107af0e0_ef1a_4d19_aba8_67a163073d13);
pub const DXVA_ModeMPEG1_A: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be09_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeMPEG1_VLD: windows_core::GUID = windows_core::GUID::from_u128(0x6f3ec719_3735_42cc_8063_65cc3cb36616);
pub const DXVA_ModeMPEG2_A: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be0a_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeMPEG2_B: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be0b_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeMPEG2_C: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be0c_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeMPEG2_D: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be0d_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeMPEG2and1_VLD: windows_core::GUID = windows_core::GUID::from_u128(0x86695f12_340e_4f04_9fd3_9253dd327460);
pub const DXVA_ModeMPEG4pt2_VLD_AdvSimple_GMC: windows_core::GUID = windows_core::GUID::from_u128(0xab998b5b_4258_44a9_9feb_94e597a6baae);
pub const DXVA_ModeMPEG4pt2_VLD_AdvSimple_NoGMC: windows_core::GUID = windows_core::GUID::from_u128(0xed418a9f_010d_4eda_9ae3_9a65358d8d2e);
pub const DXVA_ModeMPEG4pt2_VLD_Simple: windows_core::GUID = windows_core::GUID::from_u128(0xefd64d74_c9e8_41d7_a5e9_e9b0e39fa319);
pub const DXVA_ModeNone: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be00_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeVC1_A: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bea0_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeVC1_B: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bea1_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeVC1_C: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bea2_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeVC1_D: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bea3_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeVC1_D2010: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bea4_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeVP8_VLD: windows_core::GUID = windows_core::GUID::from_u128(0x90b899ea_3a62_4705_88b3_8df04b2744e7);
pub const DXVA_ModeVP9_VLD_10bit_Profile2: windows_core::GUID = windows_core::GUID::from_u128(0xa4c749ef_6ecf_48aa_8448_50a7a1165ff7);
pub const DXVA_ModeVP9_VLD_Profile0: windows_core::GUID = windows_core::GUID::from_u128(0x463707f8_a1d0_4585_876d_83aa6d60b89e);
pub const DXVA_ModeWMV8_A: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be80_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeWMV8_B: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be81_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeWMV9_A: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be90_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeWMV9_B: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be91_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_ModeWMV9_C: windows_core::GUID = windows_core::GUID::from_u128(0x1b81be94_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_NUM_TYPES_COMP_BUFFERS: u32 = 18u32;
pub const DXVA_NoEncrypt: windows_core::GUID = windows_core::GUID::from_u128(0x1b81bed0_a0c7_11d3_b984_00c04f2e73c5);
pub const DXVA_NumMV_OBMC_off_BinPBwith4MV_off: u32 = 4u32;
pub const DXVA_NumMV_OBMC_off_BinPBwith4MV_on: u32 = 5u32;
pub const DXVA_NumMV_OBMC_on__BinPB_off: u32 = 10u32;
pub const DXVA_NumMV_OBMC_on__BinPB_on: u32 = 11u32;
pub const DXVA_PICTURE_DECODE_BUFFER: u32 = 1u32;
pub const DXVA_PICTURE_DECODING_FUNCTION: u32 = 1u32;
pub const DXVA_PICTURE_RESAMPLE_BUFFER: u32 = 14u32;
pub const DXVA_PICTURE_RESAMPLE_FUNCTION: u32 = 4u32;
pub const DXVA_PICTURE_STRUCTURE_BOTTOM_FIELD: u32 = 2u32;
pub const DXVA_PICTURE_STRUCTURE_FRAME: u32 = 3u32;
pub const DXVA_PICTURE_STRUCTURE_TOP_FIELD: u32 = 1u32;
pub const DXVA_ProcAmpControlBltFnCode: u32 = 1u32;
pub const DXVA_ProcAmpControlDevice: windows_core::GUID = windows_core::GUID::from_u128(0x9f200913_2ffd_4056_9f1e_e1b508f22dcf);
pub const DXVA_ProcAmpControlQueryCapsFnCode: u32 = 3u32;
pub const DXVA_ProcAmpControlQueryRangeFnCode: u32 = 4u32;
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_LOCK_FALSE_PLUS: u32 = 16777215u32;
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_LOCK_OK_COPY: u32 = 16777212u32;
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_FALSE_PLUS: u32 = 16777211u32;
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_OK_COPY: u32 = 16777208u32;
pub const DXVA_QUERYORREPLYFUNCFLAG_ACCEL_PROBE_OK_PLUS: u32 = 16777209u32;
pub const DXVA_QUERYORREPLYFUNCFLAG_DECODER_LOCK_QUERY: u32 = 16777205u32;
pub const DXVA_QUERYORREPLYFUNCFLAG_DECODER_PROBE_QUERY: u32 = 16777201u32;
pub const DXVA_READ_BACK_BUFFER: u32 = 15u32;
pub const DXVA_RESIDUAL_DIFFERENCE_BUFFER: u32 = 3u32;
pub const DXVA_RESTRICTED_MODE_H261_A: u32 = 1u32;
pub const DXVA_RESTRICTED_MODE_H261_B: u32 = 2u32;
pub const DXVA_RESTRICTED_MODE_H263_A: u32 = 3u32;
pub const DXVA_RESTRICTED_MODE_H263_B: u32 = 4u32;
pub const DXVA_RESTRICTED_MODE_H263_C: u32 = 5u32;
pub const DXVA_RESTRICTED_MODE_H263_D: u32 = 6u32;
pub const DXVA_RESTRICTED_MODE_H263_E: u32 = 7u32;
pub const DXVA_RESTRICTED_MODE_H263_F: u32 = 8u32;
pub const DXVA_RESTRICTED_MODE_H264_A: u32 = 100u32;
pub const DXVA_RESTRICTED_MODE_H264_B: u32 = 101u32;
pub const DXVA_RESTRICTED_MODE_H264_C: u32 = 102u32;
pub const DXVA_RESTRICTED_MODE_H264_D: u32 = 103u32;
pub const DXVA_RESTRICTED_MODE_H264_E: u32 = 104u32;
pub const DXVA_RESTRICTED_MODE_H264_F: u32 = 105u32;
pub const DXVA_RESTRICTED_MODE_H264_IDCT_FGT: u32 = 103u32;
pub const DXVA_RESTRICTED_MODE_H264_IDCT_NOFGT: u32 = 102u32;
pub const DXVA_RESTRICTED_MODE_H264_MOCOMP_FGT: u32 = 101u32;
pub const DXVA_RESTRICTED_MODE_H264_MOCOMP_NOFGT: u32 = 100u32;
pub const DXVA_RESTRICTED_MODE_H264_VLD_FGT: u32 = 105u32;
pub const DXVA_RESTRICTED_MODE_H264_VLD_MULTIVIEW_NOFGT: u32 = 115u32;
pub const DXVA_RESTRICTED_MODE_H264_VLD_NOFGT: u32 = 104u32;
pub const DXVA_RESTRICTED_MODE_H264_VLD_STEREO_NOFGT: u32 = 114u32;
pub const DXVA_RESTRICTED_MODE_H264_VLD_STEREO_PROGRESSIVE_NOFGT: u32 = 113u32;
pub const DXVA_RESTRICTED_MODE_H264_VLD_WITHFMOASO_NOFGT: u32 = 112u32;
pub const DXVA_RESTRICTED_MODE_MPEG1_A: u32 = 9u32;
pub const DXVA_RESTRICTED_MODE_MPEG1_VLD: u32 = 16u32;
pub const DXVA_RESTRICTED_MODE_MPEG2_A: u32 = 10u32;
pub const DXVA_RESTRICTED_MODE_MPEG2_B: u32 = 11u32;
pub const DXVA_RESTRICTED_MODE_MPEG2_C: u32 = 12u32;
pub const DXVA_RESTRICTED_MODE_MPEG2_D: u32 = 13u32;
pub const DXVA_RESTRICTED_MODE_MPEG2and1_VLD: u32 = 17u32;
pub const DXVA_RESTRICTED_MODE_MPEG4PT2_VLD_ADV_SIMPLE_GMC: u32 = 178u32;
pub const DXVA_RESTRICTED_MODE_MPEG4PT2_VLD_ADV_SIMPLE_NOGMC: u32 = 177u32;
pub const DXVA_RESTRICTED_MODE_MPEG4PT2_VLD_SIMPLE: u32 = 176u32;
pub const DXVA_RESTRICTED_MODE_UNRESTRICTED: u32 = 65535u32;
pub const DXVA_RESTRICTED_MODE_VC1_A: u32 = 160u32;
pub const DXVA_RESTRICTED_MODE_VC1_B: u32 = 161u32;
pub const DXVA_RESTRICTED_MODE_VC1_C: u32 = 162u32;
pub const DXVA_RESTRICTED_MODE_VC1_D: u32 = 163u32;
pub const DXVA_RESTRICTED_MODE_VC1_D2010: u32 = 164u32;
pub const DXVA_RESTRICTED_MODE_VC1_IDCT: u32 = 162u32;
pub const DXVA_RESTRICTED_MODE_VC1_MOCOMP: u32 = 161u32;
pub const DXVA_RESTRICTED_MODE_VC1_POSTPROC: u32 = 160u32;
pub const DXVA_RESTRICTED_MODE_VC1_VLD: u32 = 163u32;
pub const DXVA_RESTRICTED_MODE_WMV8_A: u32 = 128u32;
pub const DXVA_RESTRICTED_MODE_WMV8_B: u32 = 129u32;
pub const DXVA_RESTRICTED_MODE_WMV8_MOCOMP: u32 = 129u32;
pub const DXVA_RESTRICTED_MODE_WMV8_POSTPROC: u32 = 128u32;
pub const DXVA_RESTRICTED_MODE_WMV9_A: u32 = 144u32;
pub const DXVA_RESTRICTED_MODE_WMV9_B: u32 = 145u32;
pub const DXVA_RESTRICTED_MODE_WMV9_C: u32 = 148u32;
pub const DXVA_RESTRICTED_MODE_WMV9_IDCT: u32 = 148u32;
pub const DXVA_RESTRICTED_MODE_WMV9_MOCOMP: u32 = 145u32;
pub const DXVA_RESTRICTED_MODE_WMV9_POSTPROC: u32 = 144u32;
pub const DXVA_SCAN_METHOD_ALTERNATE_HORIZONTAL: u32 = 2u32;
pub const DXVA_SCAN_METHOD_ALTERNATE_VERTICAL: u32 = 1u32;
pub const DXVA_SCAN_METHOD_ARBITRARY: u32 = 3u32;
pub const DXVA_SCAN_METHOD_ZIG_ZAG: u32 = 0u32;
pub const DXVA_SLICE_CONTROL_BUFFER: u32 = 6u32;
pub const DXVA_STATUS_REPORTING_FUNCTION: u32 = 7u32;
pub const DXVA_USUAL_BLOCK_HEIGHT: u32 = 8u32;
pub const DXVA_USUAL_BLOCK_WIDTH: u32 = 8u32;
pub const DeinterlacePref9_BOB: VMR9DeinterlacePrefs = VMR9DeinterlacePrefs(2i32);
pub const DeinterlacePref9_Mask: VMR9DeinterlacePrefs = VMR9DeinterlacePrefs(7i32);
pub const DeinterlacePref9_NextBest: VMR9DeinterlacePrefs = VMR9DeinterlacePrefs(1i32);
pub const DeinterlacePref9_Weave: VMR9DeinterlacePrefs = VMR9DeinterlacePrefs(4i32);
pub const DeinterlacePref_BOB: VMRDeinterlacePrefs = VMRDeinterlacePrefs(2i32);
pub const DeinterlacePref_Mask: VMRDeinterlacePrefs = VMRDeinterlacePrefs(7i32);
pub const DeinterlacePref_NextBest: VMRDeinterlacePrefs = VMRDeinterlacePrefs(1i32);
pub const DeinterlacePref_Weave: VMRDeinterlacePrefs = VMRDeinterlacePrefs(4i32);
pub const DeinterlaceTech9_BOBLineReplicate: VMR9DeinterlaceTech = VMR9DeinterlaceTech(1i32);
pub const DeinterlaceTech9_BOBVerticalStretch: VMR9DeinterlaceTech = VMR9DeinterlaceTech(2i32);
pub const DeinterlaceTech9_EdgeFiltering: VMR9DeinterlaceTech = VMR9DeinterlaceTech(16i32);
pub const DeinterlaceTech9_FieldAdaptive: VMR9DeinterlaceTech = VMR9DeinterlaceTech(32i32);
pub const DeinterlaceTech9_MedianFiltering: VMR9DeinterlaceTech = VMR9DeinterlaceTech(4i32);
pub const DeinterlaceTech9_MotionVectorSteered: VMR9DeinterlaceTech = VMR9DeinterlaceTech(128i32);
pub const DeinterlaceTech9_PixelAdaptive: VMR9DeinterlaceTech = VMR9DeinterlaceTech(64i32);
pub const DeinterlaceTech9_Unknown: VMR9DeinterlaceTech = VMR9DeinterlaceTech(0i32);
pub const DeinterlaceTech_BOBLineReplicate: VMRDeinterlaceTech = VMRDeinterlaceTech(1i32);
pub const DeinterlaceTech_BOBVerticalStretch: VMRDeinterlaceTech = VMRDeinterlaceTech(2i32);
pub const DeinterlaceTech_EdgeFiltering: VMRDeinterlaceTech = VMRDeinterlaceTech(16i32);
pub const DeinterlaceTech_FieldAdaptive: VMRDeinterlaceTech = VMRDeinterlaceTech(32i32);
pub const DeinterlaceTech_MedianFiltering: VMRDeinterlaceTech = VMRDeinterlaceTech(4i32);
pub const DeinterlaceTech_MotionVectorSteered: VMRDeinterlaceTech = VMRDeinterlaceTech(128i32);
pub const DeinterlaceTech_PixelAdaptive: VMRDeinterlaceTech = VMRDeinterlaceTech(64i32);
pub const DeinterlaceTech_Unknown: VMRDeinterlaceTech = VMRDeinterlaceTech(0i32);
pub const DeviceClosed: UICloseReasonType = UICloseReasonType(3i32);
pub const Disabled: OUTPUT_STATE = OUTPUT_STATE(0i32);
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct EALocationCodeType {
    pub LocationCodeScheme: LocationCodeSchemeType,
    pub state_code: u8,
    pub county_subdivision: u8,
    pub county_code: u16,
}
impl Default for EALocationCodeType {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const EC_ACTIVATE: u32 = 19u32;
pub const EC_BANDWIDTHCHANGE: u32 = 72u32;
pub const EC_BUFFERING_DATA: u32 = 17u32;
pub const EC_BUILT: u32 = 768u32;
pub const EC_CLOCK_CHANGED: u32 = 13u32;
pub const EC_CLOCK_UNSET: u32 = 81u32;
pub const EC_CODECAPI_EVENT: u32 = 87u32;
pub const EC_COMPLETE: u32 = 1u32;
pub const EC_CONTENTPROPERTY_CHANGED: u32 = 71u32;
pub const EC_DEVICE_LOST: u32 = 31u32;
pub const EC_DISPLAY_CHANGED: u32 = 22u32;
pub const EC_DVDBASE: u32 = 256u32;
pub const EC_DVD_ANGLES_AVAILABLE: u32 = 275u32;
pub const EC_DVD_ANGLE_CHANGE: u32 = 262u32;
pub const EC_DVD_AUDIO_STREAM_CHANGE: u32 = 260u32;
pub const EC_DVD_BUTTON_AUTO_ACTIVATED: u32 = 277u32;
pub const EC_DVD_BUTTON_CHANGE: u32 = 263u32;
pub const EC_DVD_BeginNavigationCommands: u32 = 291u32;
pub const EC_DVD_CHAPTER_AUTOSTOP: u32 = 270u32;
pub const EC_DVD_CHAPTER_START: u32 = 259u32;
pub const EC_DVD_CMD_END: u32 = 279u32;
pub const EC_DVD_CMD_START: u32 = 278u32;
pub const EC_DVD_CURRENT_HMSF_TIME: u32 = 282u32;
pub const EC_DVD_CURRENT_TIME: u32 = 267u32;
pub const EC_DVD_DISC_EJECTED: u32 = 280u32;
pub const EC_DVD_DISC_INSERTED: u32 = 281u32;
pub const EC_DVD_DOMAIN_CHANGE: u32 = 257u32;
pub const EC_DVD_ERROR: u32 = 268u32;
pub const EC_DVD_GPRM_Change: u32 = 289u32;
pub const EC_DVD_KARAOKE_MODE: u32 = 283u32;
pub const EC_DVD_NO_FP_PGC: u32 = 271u32;
pub const EC_DVD_NavigationCommand: u32 = 292u32;
pub const EC_DVD_PARENTAL_LEVEL_CHANGE: u32 = 273u32;
pub const EC_DVD_PLAYBACK_RATE_CHANGE: u32 = 272u32;
pub const EC_DVD_PLAYBACK_STOPPED: u32 = 274u32;
pub const EC_DVD_PLAYPERIOD_AUTOSTOP: u32 = 276u32;
pub const EC_DVD_PROGRAM_CELL_CHANGE: u32 = 284u32;
pub const EC_DVD_PROGRAM_CHAIN_CHANGE: u32 = 286u32;
pub const EC_DVD_SPRM_Change: u32 = 290u32;
pub const EC_DVD_STILL_OFF: u32 = 266u32;
pub const EC_DVD_STILL_ON: u32 = 265u32;
pub const EC_DVD_SUBPICTURE_STREAM_CHANGE: u32 = 261u32;
pub const EC_DVD_TITLE_CHANGE: u32 = 258u32;
pub const EC_DVD_TITLE_SET_CHANGE: u32 = 285u32;
pub const EC_DVD_VALID_UOPS_CHANGE: u32 = 264u32;
pub const EC_DVD_VOBU_Offset: u32 = 287u32;
pub const EC_DVD_VOBU_Timestamp: u32 = 288u32;
pub const EC_DVD_WARNING: u32 = 269u32;
pub const EC_END_OF_SEGMENT: u32 = 28u32;
pub const EC_EOS_SOON: u32 = 70u32;
pub const EC_ERRORABORT: u32 = 3u32;
pub const EC_ERRORABORTEX: u32 = 69u32;
pub const EC_ERROR_STILLPLAYING: u32 = 8u32;
pub const EC_EXTDEVICE_MODE_CHANGE: u32 = 49u32;
pub const EC_FILE_CLOSED: u32 = 68u32;
pub const EC_FULLSCREEN_LOST: u32 = 18u32;
pub const EC_GRAPH_CHANGED: u32 = 80u32;
pub const EC_LENGTH_CHANGED: u32 = 30u32;
pub const EC_LOADSTATUS: u32 = 67u32;
pub const EC_MARKER_HIT: u32 = 66u32;
pub const EC_NEED_RESTART: u32 = 20u32;
pub const EC_NEW_PIN: u32 = 32u32;
pub const EC_NOTIFY_WINDOW: u32 = 25u32;
pub const EC_OLE_EVENT: u32 = 24u32;
pub const EC_OPENING_FILE: u32 = 16u32;
pub const EC_PALETTE_CHANGED: u32 = 9u32;
pub const EC_PAUSED: u32 = 14u32;
pub const EC_PLEASE_REOPEN: u32 = 64u32;
pub const EC_PREPROCESS_COMPLETE: u32 = 86u32;
pub const EC_PROCESSING_LATENCY: u32 = 33u32;
pub const EC_QUALITY_CHANGE: u32 = 11u32;
pub const EC_RENDER_FINISHED: u32 = 33u32;
pub const EC_REPAINT: u32 = 5u32;
pub const EC_SAMPLE_LATENCY: u32 = 34u32;
pub const EC_SAMPLE_NEEDED: u32 = 32u32;
pub const EC_SCRUB_TIME: u32 = 35u32;
pub const EC_SEGMENT_STARTED: u32 = 29u32;
pub const EC_SHUTTING_DOWN: u32 = 12u32;
pub const EC_SKIP_FRAMES: u32 = 37u32;
pub const EC_SNDDEV_IN_ERROR: u32 = 512u32;
pub const EC_SNDDEV_OUT_ERROR: u32 = 513u32;
pub const EC_SND_DEVICE_ERROR_BASE: u32 = 512u32;
pub const EC_STARVATION: u32 = 23u32;
pub const EC_STATE_CHANGE: u32 = 50u32;
pub const EC_STATUS: u32 = 65u32;
pub const EC_STEP_COMPLETE: u32 = 36u32;
pub const EC_STREAM_CONTROL_STARTED: u32 = 27u32;
pub const EC_STREAM_CONTROL_STOPPED: u32 = 26u32;
pub const EC_STREAM_ERROR_STILLPLAYING: u32 = 7u32;
pub const EC_STREAM_ERROR_STOPPED: u32 = 6u32;
pub const EC_SYSTEMBASE: u32 = 0u32;
pub const EC_TIME: u32 = 4u32;
pub const EC_TIMECODE_AVAILABLE: u32 = 48u32;
pub const EC_UNBUILT: u32 = 769u32;
pub const EC_USER: u32 = 32768u32;
pub const EC_USERABORT: u32 = 2u32;
pub const EC_VIDEOFRAMEREADY: u32 = 73u32;
pub const EC_VIDEO_SIZE_CHANGED: u32 = 10u32;
pub const EC_VMR_RECONNECTION_FAILED: u32 = 85u32;
pub const EC_VMR_RENDERDEVICE_SET: u32 = 83u32;
pub const EC_VMR_SURFACE_FLIPPED: u32 = 84u32;
pub const EC_WINDOW_DESTROYED: u32 = 21u32;
pub const EC_WMT_EVENT: u32 = 594u32;
pub const EC_WMT_EVENT_BASE: u32 = 593u32;
pub const EC_WMT_INDEX_EVENT: u32 = 593u32;
pub const E_PROP_ID_UNSUPPORTED: windows_core::HRESULT = windows_core::HRESULT(0x80070490_u32 as _);
pub const E_PROP_SET_UNSUPPORTED: windows_core::HRESULT = windows_core::HRESULT(0x80070492_u32 as _);
pub const Entitled: EntitlementType = EntitlementType(0i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct EntitlementType(pub i32);
pub const ErrorClosed: UICloseReasonType = UICloseReasonType(4i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FECMethod(pub i32);
#[repr(C)]
#[derive(Clone, Debug, PartialEq)]
pub struct FILTER_INFO {
    pub achName: [u16; 128],
    pub pGraph: core::mem::ManuallyDrop<Option<IFilterGraph>>,
}
impl Default for FILTER_INFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct FILTER_STATE(pub i32);
pub const FORMAT_DVD_LPCMAudio: windows_core::GUID = windows_core::GUID::from_u128(0xe06d80e6_db46_11cf_b4d1_00805f6cbbea);
pub const FORMAT_DolbyAC3: windows_core::GUID = windows_core::GUID::from_u128(0xe06d80e4_db46_11cf_b4d1_00805f6cbbea);
pub const FORMAT_Image: windows_core::GUID = windows_core::GUID::from_u128(0x692fa379_d3e8_4651_b5b4_0b94b013eeaf);
pub const FORMAT_JPEGImage: windows_core::GUID = windows_core::GUID::from_u128(0x692fa379_d3e8_4651_b5b4_0b94b013eeaf);
pub const FORMAT_MPEG2Audio: windows_core::GUID = windows_core::GUID::from_u128(0xe06d80e5_db46_11cf_b4d1_00805f6cbbea);
pub const FORMAT_MPEG2Video: windows_core::GUID = windows_core::GUID::from_u128(0xe06d80e3_db46_11cf_b4d1_00805f6cbbea);
pub const FORMAT_MPEG2_VIDEO: windows_core::GUID = windows_core::GUID::from_u128(0xe06d80e3_db46_11cf_b4d1_00805f6cbbea);
pub const FORMAT_UVCH264Video: windows_core::GUID = windows_core::GUID::from_u128(0x2017be05_6629_4248_aaed_7e1a47bc9b9c);
pub const Famine: QualityMessageType = QualityMessageType(0i32);
pub const FilgraphManager: windows_core::GUID = windows_core::GUID::from_u128(0xe436ebb3_524f_11ce_9f53_0020af0ba770);
pub const Flood: QualityMessageType = QualityMessageType(1i32);
pub const GUID_TIME_MUSIC: windows_core::GUID = windows_core::GUID::from_u128(0x0574c49d_5b04_4b15_a542_ae282030117b);
pub const GUID_TIME_REFERENCE: windows_core::GUID = windows_core::GUID::from_u128(0x93ad712b_daa0_4ffe_bc81_b0ce500fcdd9);
pub const GUID_TIME_SAMPLES: windows_core::GUID = windows_core::GUID::from_u128(0xa8593d05_0c43_4984_9a63_97af9e02c4c0);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct GuardInterval(pub i32);
#[repr(C)]
#[cfg(feature = "Win32_Media_Audio")]
#[derive(Clone, Copy)]
pub struct HEAACWAVEFORMAT {
    pub wfInfo: HEAACWAVEINFO,
    pub pbAudioSpecificConfig: [u8; 1],
}
#[cfg(feature = "Win32_Media_Audio")]
impl Default for HEAACWAVEFORMAT {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Media_Audio")]
#[derive(Clone, Copy)]
pub struct HEAACWAVEINFO {
    pub wfx: super::Audio::WAVEFORMATEX,
    pub wPayloadType: u16,
    pub wAudioProfileLevelIndication: u16,
    pub wStructType: u16,
    pub wReserved1: u16,
    pub dwReserved2: u32,
}
#[cfg(feature = "Win32_Media_Audio")]
impl Default for HEAACWAVEINFO {
    fn default() -> Self {
        unsafe { core::mem::zeroed() }
    }
}
pub const HEVC_TEMPORAL_VIDEO_SUBSET: MPEG2StreamType = MPEG2StreamType(37i32);
pub const HEVC_VIDEO_OR_TEMPORAL_VIDEO: MPEG2StreamType = MPEG2StreamType(36i32);
#[repr(transparent)]
#[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
pub struct HierarchyAlpha(pub i32);
windows_core::imp::define_interface!(IAMAnalogVideoDecoder, IAMAnalogVideoDecoder_Vtbl, 0xc6e13350_30ac_11d0_a18c_00a0c9118956);
windows_core::imp::interface_hierarchy!(IAMAnalogVideoDecoder, windows_core::IUnknown);
impl IAMAnalogVideoDecoder {
    pub unsafe fn AvailableTVFormats(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AvailableTVFormats)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTVFormat(&self, lanalogvideostandard: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTVFormat)(windows_core::Interface::as_raw(self), lanalogvideostandard).ok() }
    }
    pub unsafe fn TVFormat(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).TVFormat)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn HorizontalLocked(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).HorizontalLocked)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetVCRHorizontalLocking(&self, lvcrhorizontallocking: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetVCRHorizontalLocking)(windows_core::Interface::as_raw(self), lvcrhorizontallocking).ok() }
    }
    pub unsafe fn VCRHorizontalLocking(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).VCRHorizontalLocking)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn NumberOfLines(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).NumberOfLines)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOutputEnable(&self, loutputenable: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputEnable)(windows_core::Interface::as_raw(self), loutputenable).ok() }
    }
    pub unsafe fn OutputEnable(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).OutputEnable)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAMAnalogVideoDecoder_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AvailableTVFormats: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetTVFormat: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub TVFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub HorizontalLocked: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetVCRHorizontalLocking: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub VCRHorizontalLocking: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub NumberOfLines: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetOutputEnable: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub OutputEnable: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
}
pub trait IAMAnalogVideoDecoder_Impl: windows_core::IUnknownImpl {
    fn AvailableTVFormats(&self) -> windows_core::Result<i32>;
    fn SetTVFormat(&self, lanalogvideostandard: i32) -> windows_core::Result<()>;
    fn TVFormat(&self) -> windows_core::Result<i32>;
    fn HorizontalLocked(&self) -> windows_core::Result<i32>;
    fn SetVCRHorizontalLocking(&self, lvcrhorizontallocking: i32) -> windows_core::Result<()>;
    fn VCRHorizontalLocking(&self) -> windows_core::Result<i32>;
    fn NumberOfLines(&self) -> windows_core::Result<i32>;
    fn SetOutputEnable(&self, loutputenable: i32) -> windows_core::Result<()>;
    fn OutputEnable(&self) -> windows_core::Result<i32>;
}
impl IAMAnalogVideoDecoder_Vtbl {
    pub const fn new<Identity: IAMAnalogVideoDecoder_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AvailableTVFormats<Identity: IAMAnalogVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lanalogvideostandard: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAnalogVideoDecoder_Impl::AvailableTVFormats(this) {
                    Ok(ok__) => {
                        lanalogvideostandard.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTVFormat<Identity: IAMAnalogVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lanalogvideostandard: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAnalogVideoDecoder_Impl::SetTVFormat(this, core::mem::transmute_copy(&lanalogvideostandard)).into()
            }
        }
        unsafe extern "system" fn TVFormat<Identity: IAMAnalogVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, planalogvideostandard: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAnalogVideoDecoder_Impl::TVFormat(this) {
                    Ok(ok__) => {
                        planalogvideostandard.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn HorizontalLocked<Identity: IAMAnalogVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pllocked: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAnalogVideoDecoder_Impl::HorizontalLocked(this) {
                    Ok(ok__) => {
                        pllocked.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetVCRHorizontalLocking<Identity: IAMAnalogVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lvcrhorizontallocking: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAnalogVideoDecoder_Impl::SetVCRHorizontalLocking(this, core::mem::transmute_copy(&lvcrhorizontallocking)).into()
            }
        }
        unsafe extern "system" fn VCRHorizontalLocking<Identity: IAMAnalogVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plvcrhorizontallocking: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAnalogVideoDecoder_Impl::VCRHorizontalLocking(this) {
                    Ok(ok__) => {
                        plvcrhorizontallocking.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn NumberOfLines<Identity: IAMAnalogVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plnumberoflines: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAnalogVideoDecoder_Impl::NumberOfLines(this) {
                    Ok(ok__) => {
                        plnumberoflines.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOutputEnable<Identity: IAMAnalogVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, loutputenable: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAnalogVideoDecoder_Impl::SetOutputEnable(this, core::mem::transmute_copy(&loutputenable)).into()
            }
        }
        unsafe extern "system" fn OutputEnable<Identity: IAMAnalogVideoDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ploutputenable: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAnalogVideoDecoder_Impl::OutputEnable(this) {
                    Ok(ok__) => {
                        ploutputenable.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            AvailableTVFormats: AvailableTVFormats::<Identity, OFFSET>,
            SetTVFormat: SetTVFormat::<Identity, OFFSET>,
            TVFormat: TVFormat::<Identity, OFFSET>,
            HorizontalLocked: HorizontalLocked::<Identity, OFFSET>,
            SetVCRHorizontalLocking: SetVCRHorizontalLocking::<Identity, OFFSET>,
            VCRHorizontalLocking: VCRHorizontalLocking::<Identity, OFFSET>,
            NumberOfLines: NumberOfLines::<Identity, OFFSET>,
            SetOutputEnable: SetOutputEnable::<Identity, OFFSET>,
            OutputEnable: OutputEnable::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMAnalogVideoDecoder as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMAnalogVideoDecoder {}
windows_core::imp::define_interface!(IAMAnalogVideoEncoder, IAMAnalogVideoEncoder_Vtbl, 0xc6e133b0_30ac_11d0_a18c_00a0c9118956);
windows_core::imp::interface_hierarchy!(IAMAnalogVideoEncoder, windows_core::IUnknown);
impl IAMAnalogVideoEncoder {
    pub unsafe fn AvailableTVFormats(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AvailableTVFormats)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTVFormat(&self, lanalogvideostandard: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTVFormat)(windows_core::Interface::as_raw(self), lanalogvideostandard).ok() }
    }
    pub unsafe fn TVFormat(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).TVFormat)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetCopyProtection(&self, lvideocopyprotection: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCopyProtection)(windows_core::Interface::as_raw(self), lvideocopyprotection).ok() }
    }
    pub unsafe fn CopyProtection(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CopyProtection)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetCCEnable(&self, lccenable: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCCEnable)(windows_core::Interface::as_raw(self), lccenable).ok() }
    }
    pub unsafe fn CCEnable(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CCEnable)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAMAnalogVideoEncoder_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AvailableTVFormats: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetTVFormat: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub TVFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetCopyProtection: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub CopyProtection: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetCCEnable: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub CCEnable: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
}
pub trait IAMAnalogVideoEncoder_Impl: windows_core::IUnknownImpl {
    fn AvailableTVFormats(&self) -> windows_core::Result<i32>;
    fn SetTVFormat(&self, lanalogvideostandard: i32) -> windows_core::Result<()>;
    fn TVFormat(&self) -> windows_core::Result<i32>;
    fn SetCopyProtection(&self, lvideocopyprotection: i32) -> windows_core::Result<()>;
    fn CopyProtection(&self) -> windows_core::Result<i32>;
    fn SetCCEnable(&self, lccenable: i32) -> windows_core::Result<()>;
    fn CCEnable(&self) -> windows_core::Result<i32>;
}
impl IAMAnalogVideoEncoder_Vtbl {
    pub const fn new<Identity: IAMAnalogVideoEncoder_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AvailableTVFormats<Identity: IAMAnalogVideoEncoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lanalogvideostandard: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAnalogVideoEncoder_Impl::AvailableTVFormats(this) {
                    Ok(ok__) => {
                        lanalogvideostandard.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTVFormat<Identity: IAMAnalogVideoEncoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lanalogvideostandard: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAnalogVideoEncoder_Impl::SetTVFormat(this, core::mem::transmute_copy(&lanalogvideostandard)).into()
            }
        }
        unsafe extern "system" fn TVFormat<Identity: IAMAnalogVideoEncoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, planalogvideostandard: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAnalogVideoEncoder_Impl::TVFormat(this) {
                    Ok(ok__) => {
                        planalogvideostandard.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetCopyProtection<Identity: IAMAnalogVideoEncoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lvideocopyprotection: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAnalogVideoEncoder_Impl::SetCopyProtection(this, core::mem::transmute_copy(&lvideocopyprotection)).into()
            }
        }
        unsafe extern "system" fn CopyProtection<Identity: IAMAnalogVideoEncoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lvideocopyprotection: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAnalogVideoEncoder_Impl::CopyProtection(this) {
                    Ok(ok__) => {
                        lvideocopyprotection.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetCCEnable<Identity: IAMAnalogVideoEncoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lccenable: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAnalogVideoEncoder_Impl::SetCCEnable(this, core::mem::transmute_copy(&lccenable)).into()
            }
        }
        unsafe extern "system" fn CCEnable<Identity: IAMAnalogVideoEncoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lccenable: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAnalogVideoEncoder_Impl::CCEnable(this) {
                    Ok(ok__) => {
                        lccenable.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            AvailableTVFormats: AvailableTVFormats::<Identity, OFFSET>,
            SetTVFormat: SetTVFormat::<Identity, OFFSET>,
            TVFormat: TVFormat::<Identity, OFFSET>,
            SetCopyProtection: SetCopyProtection::<Identity, OFFSET>,
            CopyProtection: CopyProtection::<Identity, OFFSET>,
            SetCCEnable: SetCCEnable::<Identity, OFFSET>,
            CCEnable: CCEnable::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMAnalogVideoEncoder as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMAnalogVideoEncoder {}
windows_core::imp::define_interface!(IAMAsyncReaderTimestampScaling, IAMAsyncReaderTimestampScaling_Vtbl, 0xcf7b26fc_9a00_485b_8147_3e789d5e8f67);
windows_core::imp::interface_hierarchy!(IAMAsyncReaderTimestampScaling, windows_core::IUnknown);
impl IAMAsyncReaderTimestampScaling {
    pub unsafe fn GetTimestampMode(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTimestampMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTimestampMode(&self, fraw: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTimestampMode)(windows_core::Interface::as_raw(self), fraw.into()).ok() }
    }
}
#[repr(C)]
pub struct IAMAsyncReaderTimestampScaling_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTimestampMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub SetTimestampMode: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
}
pub trait IAMAsyncReaderTimestampScaling_Impl: windows_core::IUnknownImpl {
    fn GetTimestampMode(&self) -> windows_core::Result<windows_core::BOOL>;
    fn SetTimestampMode(&self, fraw: windows_core::BOOL) -> windows_core::Result<()>;
}
impl IAMAsyncReaderTimestampScaling_Vtbl {
    pub const fn new<Identity: IAMAsyncReaderTimestampScaling_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTimestampMode<Identity: IAMAsyncReaderTimestampScaling_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfraw: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAsyncReaderTimestampScaling_Impl::GetTimestampMode(this) {
                    Ok(ok__) => {
                        pfraw.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTimestampMode<Identity: IAMAsyncReaderTimestampScaling_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fraw: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAsyncReaderTimestampScaling_Impl::SetTimestampMode(this, core::mem::transmute_copy(&fraw)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTimestampMode: GetTimestampMode::<Identity, OFFSET>,
            SetTimestampMode: SetTimestampMode::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMAsyncReaderTimestampScaling as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMAsyncReaderTimestampScaling {}
windows_core::imp::define_interface!(IAMAudioInputMixer, IAMAudioInputMixer_Vtbl, 0x54c39221_8380_11d0_b3f0_00aa003761c5);
windows_core::imp::interface_hierarchy!(IAMAudioInputMixer, windows_core::IUnknown);
impl IAMAudioInputMixer {
    pub unsafe fn SetEnable(&self, fenable: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetEnable)(windows_core::Interface::as_raw(self), fenable.into()).ok() }
    }
    pub unsafe fn Enable(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Enable)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMono(&self, fmono: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMono)(windows_core::Interface::as_raw(self), fmono.into()).ok() }
    }
    pub unsafe fn Mono(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Mono)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMixLevel(&self, level: f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMixLevel)(windows_core::Interface::as_raw(self), level).ok() }
    }
    pub unsafe fn MixLevel(&self) -> windows_core::Result<f64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MixLevel)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetPan(&self, pan: f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPan)(windows_core::Interface::as_raw(self), pan).ok() }
    }
    pub unsafe fn Pan(&self) -> windows_core::Result<f64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Pan)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetLoudness(&self, floudness: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetLoudness)(windows_core::Interface::as_raw(self), floudness.into()).ok() }
    }
    pub unsafe fn Loudness(&self) -> windows_core::Result<windows_core::BOOL> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Loudness)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTreble(&self, treble: f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTreble)(windows_core::Interface::as_raw(self), treble).ok() }
    }
    pub unsafe fn Treble(&self) -> windows_core::Result<f64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Treble)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn TrebleRange(&self) -> windows_core::Result<f64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).TrebleRange)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetBass(&self, bass: f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetBass)(windows_core::Interface::as_raw(self), bass).ok() }
    }
    pub unsafe fn Bass(&self) -> windows_core::Result<f64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Bass)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn BassRange(&self) -> windows_core::Result<f64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).BassRange)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAMAudioInputMixer_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetEnable: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub Enable: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub SetMono: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub Mono: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub SetMixLevel: unsafe extern "system" fn(*mut core::ffi::c_void, f64) -> windows_core::HRESULT,
    pub MixLevel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f64) -> windows_core::HRESULT,
    pub SetPan: unsafe extern "system" fn(*mut core::ffi::c_void, f64) -> windows_core::HRESULT,
    pub Pan: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f64) -> windows_core::HRESULT,
    pub SetLoudness: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub Loudness: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub SetTreble: unsafe extern "system" fn(*mut core::ffi::c_void, f64) -> windows_core::HRESULT,
    pub Treble: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f64) -> windows_core::HRESULT,
    pub TrebleRange: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f64) -> windows_core::HRESULT,
    pub SetBass: unsafe extern "system" fn(*mut core::ffi::c_void, f64) -> windows_core::HRESULT,
    pub Bass: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f64) -> windows_core::HRESULT,
    pub BassRange: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f64) -> windows_core::HRESULT,
}
pub trait IAMAudioInputMixer_Impl: windows_core::IUnknownImpl {
    fn SetEnable(&self, fenable: windows_core::BOOL) -> windows_core::Result<()>;
    fn Enable(&self) -> windows_core::Result<windows_core::BOOL>;
    fn SetMono(&self, fmono: windows_core::BOOL) -> windows_core::Result<()>;
    fn Mono(&self) -> windows_core::Result<windows_core::BOOL>;
    fn SetMixLevel(&self, level: f64) -> windows_core::Result<()>;
    fn MixLevel(&self) -> windows_core::Result<f64>;
    fn SetPan(&self, pan: f64) -> windows_core::Result<()>;
    fn Pan(&self) -> windows_core::Result<f64>;
    fn SetLoudness(&self, floudness: windows_core::BOOL) -> windows_core::Result<()>;
    fn Loudness(&self) -> windows_core::Result<windows_core::BOOL>;
    fn SetTreble(&self, treble: f64) -> windows_core::Result<()>;
    fn Treble(&self) -> windows_core::Result<f64>;
    fn TrebleRange(&self) -> windows_core::Result<f64>;
    fn SetBass(&self, bass: f64) -> windows_core::Result<()>;
    fn Bass(&self) -> windows_core::Result<f64>;
    fn BassRange(&self) -> windows_core::Result<f64>;
}
impl IAMAudioInputMixer_Vtbl {
    pub const fn new<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetEnable<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fenable: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAudioInputMixer_Impl::SetEnable(this, core::mem::transmute_copy(&fenable)).into()
            }
        }
        unsafe extern "system" fn Enable<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfenable: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAudioInputMixer_Impl::Enable(this) {
                    Ok(ok__) => {
                        pfenable.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMono<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fmono: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAudioInputMixer_Impl::SetMono(this, core::mem::transmute_copy(&fmono)).into()
            }
        }
        unsafe extern "system" fn Mono<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfmono: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAudioInputMixer_Impl::Mono(this) {
                    Ok(ok__) => {
                        pfmono.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMixLevel<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, level: f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAudioInputMixer_Impl::SetMixLevel(this, core::mem::transmute_copy(&level)).into()
            }
        }
        unsafe extern "system" fn MixLevel<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plevel: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAudioInputMixer_Impl::MixLevel(this) {
                    Ok(ok__) => {
                        plevel.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetPan<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pan: f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAudioInputMixer_Impl::SetPan(this, core::mem::transmute_copy(&pan)).into()
            }
        }
        unsafe extern "system" fn Pan<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppan: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAudioInputMixer_Impl::Pan(this) {
                    Ok(ok__) => {
                        ppan.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetLoudness<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, floudness: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAudioInputMixer_Impl::SetLoudness(this, core::mem::transmute_copy(&floudness)).into()
            }
        }
        unsafe extern "system" fn Loudness<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfloudness: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAudioInputMixer_Impl::Loudness(this) {
                    Ok(ok__) => {
                        pfloudness.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTreble<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, treble: f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAudioInputMixer_Impl::SetTreble(this, core::mem::transmute_copy(&treble)).into()
            }
        }
        unsafe extern "system" fn Treble<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptreble: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAudioInputMixer_Impl::Treble(this) {
                    Ok(ok__) => {
                        ptreble.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn TrebleRange<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prange: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAudioInputMixer_Impl::TrebleRange(this) {
                    Ok(ok__) => {
                        prange.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetBass<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bass: f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAudioInputMixer_Impl::SetBass(this, core::mem::transmute_copy(&bass)).into()
            }
        }
        unsafe extern "system" fn Bass<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbass: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAudioInputMixer_Impl::Bass(this) {
                    Ok(ok__) => {
                        pbass.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn BassRange<Identity: IAMAudioInputMixer_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prange: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMAudioInputMixer_Impl::BassRange(this) {
                    Ok(ok__) => {
                        prange.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetEnable: SetEnable::<Identity, OFFSET>,
            Enable: Enable::<Identity, OFFSET>,
            SetMono: SetMono::<Identity, OFFSET>,
            Mono: Mono::<Identity, OFFSET>,
            SetMixLevel: SetMixLevel::<Identity, OFFSET>,
            MixLevel: MixLevel::<Identity, OFFSET>,
            SetPan: SetPan::<Identity, OFFSET>,
            Pan: Pan::<Identity, OFFSET>,
            SetLoudness: SetLoudness::<Identity, OFFSET>,
            Loudness: Loudness::<Identity, OFFSET>,
            SetTreble: SetTreble::<Identity, OFFSET>,
            Treble: Treble::<Identity, OFFSET>,
            TrebleRange: TrebleRange::<Identity, OFFSET>,
            SetBass: SetBass::<Identity, OFFSET>,
            Bass: Bass::<Identity, OFFSET>,
            BassRange: BassRange::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMAudioInputMixer as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMAudioInputMixer {}
windows_core::imp::define_interface!(IAMAudioRendererStats, IAMAudioRendererStats_Vtbl, 0x22320cb2_d41a_11d2_bf7c_d7cb9df0bf93);
windows_core::imp::interface_hierarchy!(IAMAudioRendererStats, windows_core::IUnknown);
impl IAMAudioRendererStats {
    pub unsafe fn GetStatParam(&self, dwparam: u32, pdwparam1: *mut u32, pdwparam2: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetStatParam)(windows_core::Interface::as_raw(self), dwparam, pdwparam1 as _, pdwparam2 as _).ok() }
    }
}
#[repr(C)]
pub struct IAMAudioRendererStats_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetStatParam: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32, *mut u32) -> windows_core::HRESULT,
}
pub trait IAMAudioRendererStats_Impl: windows_core::IUnknownImpl {
    fn GetStatParam(&self, dwparam: u32, pdwparam1: *mut u32, pdwparam2: *mut u32) -> windows_core::Result<()>;
}
impl IAMAudioRendererStats_Vtbl {
    pub const fn new<Identity: IAMAudioRendererStats_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetStatParam<Identity: IAMAudioRendererStats_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwparam: u32, pdwparam1: *mut u32, pdwparam2: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMAudioRendererStats_Impl::GetStatParam(this, core::mem::transmute_copy(&dwparam), core::mem::transmute_copy(&pdwparam1), core::mem::transmute_copy(&pdwparam2)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), GetStatParam: GetStatParam::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMAudioRendererStats as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMAudioRendererStats {}
windows_core::imp::define_interface!(IAMBufferNegotiation, IAMBufferNegotiation_Vtbl, 0x56ed71a0_af5f_11d0_b3f0_00aa003761c5);
windows_core::imp::interface_hierarchy!(IAMBufferNegotiation, windows_core::IUnknown);
impl IAMBufferNegotiation {
    pub unsafe fn SuggestAllocatorProperties(&self, pprop: *const ALLOCATOR_PROPERTIES) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SuggestAllocatorProperties)(windows_core::Interface::as_raw(self), pprop).ok() }
    }
    pub unsafe fn GetAllocatorProperties(&self) -> windows_core::Result<ALLOCATOR_PROPERTIES> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetAllocatorProperties)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAMBufferNegotiation_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SuggestAllocatorProperties: unsafe extern "system" fn(*mut core::ffi::c_void, *const ALLOCATOR_PROPERTIES) -> windows_core::HRESULT,
    pub GetAllocatorProperties: unsafe extern "system" fn(*mut core::ffi::c_void, *mut ALLOCATOR_PROPERTIES) -> windows_core::HRESULT,
}
pub trait IAMBufferNegotiation_Impl: windows_core::IUnknownImpl {
    fn SuggestAllocatorProperties(&self, pprop: *const ALLOCATOR_PROPERTIES) -> windows_core::Result<()>;
    fn GetAllocatorProperties(&self) -> windows_core::Result<ALLOCATOR_PROPERTIES>;
}
impl IAMBufferNegotiation_Vtbl {
    pub const fn new<Identity: IAMBufferNegotiation_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SuggestAllocatorProperties<Identity: IAMBufferNegotiation_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pprop: *const ALLOCATOR_PROPERTIES) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMBufferNegotiation_Impl::SuggestAllocatorProperties(this, core::mem::transmute_copy(&pprop)).into()
            }
        }
        unsafe extern "system" fn GetAllocatorProperties<Identity: IAMBufferNegotiation_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pprop: *mut ALLOCATOR_PROPERTIES) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMBufferNegotiation_Impl::GetAllocatorProperties(this) {
                    Ok(ok__) => {
                        pprop.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SuggestAllocatorProperties: SuggestAllocatorProperties::<Identity, OFFSET>,
            GetAllocatorProperties: GetAllocatorProperties::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMBufferNegotiation as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMBufferNegotiation {}
windows_core::imp::define_interface!(IAMCameraControl, IAMCameraControl_Vtbl, 0xc6e13370_30ac_11d0_a18c_00a0c9118956);
windows_core::imp::interface_hierarchy!(IAMCameraControl, windows_core::IUnknown);
impl IAMCameraControl {
    pub unsafe fn GetRange(&self, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRange)(windows_core::Interface::as_raw(self), property, pmin as _, pmax as _, psteppingdelta as _, pdefault as _, pcapsflags as _).ok() }
    }
    pub unsafe fn Set(&self, property: i32, lvalue: i32, flags: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Set)(windows_core::Interface::as_raw(self), property, lvalue, flags).ok() }
    }
    pub unsafe fn Get(&self, property: i32, lvalue: *mut i32, flags: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Get)(windows_core::Interface::as_raw(self), property, lvalue as _, flags as _).ok() }
    }
}
#[repr(C)]
pub struct IAMCameraControl_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetRange: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> windows_core::HRESULT,
    pub Set: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32, i32) -> windows_core::HRESULT,
    pub Get: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32, *mut i32) -> windows_core::HRESULT,
}
pub trait IAMCameraControl_Impl: windows_core::IUnknownImpl {
    fn GetRange(&self, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> windows_core::Result<()>;
    fn Set(&self, property: i32, lvalue: i32, flags: i32) -> windows_core::Result<()>;
    fn Get(&self, property: i32, lvalue: *mut i32, flags: *mut i32) -> windows_core::Result<()>;
}
impl IAMCameraControl_Vtbl {
    pub const fn new<Identity: IAMCameraControl_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetRange<Identity: IAMCameraControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMCameraControl_Impl::GetRange(this, core::mem::transmute_copy(&property), core::mem::transmute_copy(&pmin), core::mem::transmute_copy(&pmax), core::mem::transmute_copy(&psteppingdelta), core::mem::transmute_copy(&pdefault), core::mem::transmute_copy(&pcapsflags)).into()
            }
        }
        unsafe extern "system" fn Set<Identity: IAMCameraControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, property: i32, lvalue: i32, flags: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMCameraControl_Impl::Set(this, core::mem::transmute_copy(&property), core::mem::transmute_copy(&lvalue), core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn Get<Identity: IAMCameraControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, property: i32, lvalue: *mut i32, flags: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMCameraControl_Impl::Get(this, core::mem::transmute_copy(&property), core::mem::transmute_copy(&lvalue), core::mem::transmute_copy(&flags)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetRange: GetRange::<Identity, OFFSET>,
            Set: Set::<Identity, OFFSET>,
            Get: Get::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMCameraControl as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMCameraControl {}
windows_core::imp::define_interface!(IAMCertifiedOutputProtection, IAMCertifiedOutputProtection_Vtbl, 0x6feded3e_0ff1_4901_a2f1_43f7012c8515);
windows_core::imp::interface_hierarchy!(IAMCertifiedOutputProtection, windows_core::IUnknown);
impl IAMCertifiedOutputProtection {
    pub unsafe fn KeyExchange(&self, prandom: *mut windows_core::GUID, varlencertgh: *mut *mut u8, pdwlengthcertgh: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).KeyExchange)(windows_core::Interface::as_raw(self), prandom as _, varlencertgh as _, pdwlengthcertgh as _).ok() }
    }
    pub unsafe fn SessionSequenceStart(&self, psig: *const AMCOPPSignature) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SessionSequenceStart)(windows_core::Interface::as_raw(self), psig).ok() }
    }
    pub unsafe fn ProtectionCommand(&self, cmd: *const AMCOPPCommand) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ProtectionCommand)(windows_core::Interface::as_raw(self), cmd).ok() }
    }
    pub unsafe fn ProtectionStatus(&self, pstatusinput: *const AMCOPPStatusInput, pstatusoutput: *mut AMCOPPStatusOutput) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ProtectionStatus)(windows_core::Interface::as_raw(self), pstatusinput, pstatusoutput as _).ok() }
    }
}
#[repr(C)]
pub struct IAMCertifiedOutputProtection_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub KeyExchange: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID, *mut *mut u8, *mut u32) -> windows_core::HRESULT,
    pub SessionSequenceStart: unsafe extern "system" fn(*mut core::ffi::c_void, *const AMCOPPSignature) -> windows_core::HRESULT,
    pub ProtectionCommand: unsafe extern "system" fn(*mut core::ffi::c_void, *const AMCOPPCommand) -> windows_core::HRESULT,
    pub ProtectionStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *const AMCOPPStatusInput, *mut AMCOPPStatusOutput) -> windows_core::HRESULT,
}
pub trait IAMCertifiedOutputProtection_Impl: windows_core::IUnknownImpl {
    fn KeyExchange(&self, prandom: *mut windows_core::GUID, varlencertgh: *mut *mut u8, pdwlengthcertgh: *mut u32) -> windows_core::Result<()>;
    fn SessionSequenceStart(&self, psig: *const AMCOPPSignature) -> windows_core::Result<()>;
    fn ProtectionCommand(&self, cmd: *const AMCOPPCommand) -> windows_core::Result<()>;
    fn ProtectionStatus(&self, pstatusinput: *const AMCOPPStatusInput, pstatusoutput: *mut AMCOPPStatusOutput) -> windows_core::Result<()>;
}
impl IAMCertifiedOutputProtection_Vtbl {
    pub const fn new<Identity: IAMCertifiedOutputProtection_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn KeyExchange<Identity: IAMCertifiedOutputProtection_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prandom: *mut windows_core::GUID, varlencertgh: *mut *mut u8, pdwlengthcertgh: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMCertifiedOutputProtection_Impl::KeyExchange(this, core::mem::transmute_copy(&prandom), core::mem::transmute_copy(&varlencertgh), core::mem::transmute_copy(&pdwlengthcertgh)).into()
            }
        }
        unsafe extern "system" fn SessionSequenceStart<Identity: IAMCertifiedOutputProtection_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psig: *const AMCOPPSignature) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMCertifiedOutputProtection_Impl::SessionSequenceStart(this, core::mem::transmute_copy(&psig)).into()
            }
        }
        unsafe extern "system" fn ProtectionCommand<Identity: IAMCertifiedOutputProtection_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, cmd: *const AMCOPPCommand) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMCertifiedOutputProtection_Impl::ProtectionCommand(this, core::mem::transmute_copy(&cmd)).into()
            }
        }
        unsafe extern "system" fn ProtectionStatus<Identity: IAMCertifiedOutputProtection_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pstatusinput: *const AMCOPPStatusInput, pstatusoutput: *mut AMCOPPStatusOutput) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMCertifiedOutputProtection_Impl::ProtectionStatus(this, core::mem::transmute_copy(&pstatusinput), core::mem::transmute_copy(&pstatusoutput)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            KeyExchange: KeyExchange::<Identity, OFFSET>,
            SessionSequenceStart: SessionSequenceStart::<Identity, OFFSET>,
            ProtectionCommand: ProtectionCommand::<Identity, OFFSET>,
            ProtectionStatus: ProtectionStatus::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMCertifiedOutputProtection as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMCertifiedOutputProtection {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAMChannelInfo, IAMChannelInfo_Vtbl, 0xfa2aa8f2_8b62_11d0_a520_000000000000);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAMChannelInfo {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAMChannelInfo, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMChannelInfo {
    pub unsafe fn ChannelName(&self, pbstrchannelname: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ChannelName)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrchannelname)).ok() }
    }
    pub unsafe fn ChannelDescription(&self, pbstrchanneldescription: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ChannelDescription)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrchanneldescription)).ok() }
    }
    pub unsafe fn ChannelURL(&self, pbstrchannelurl: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ChannelURL)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrchannelurl)).ok() }
    }
    pub unsafe fn ContactAddress(&self, pbstrcontactaddress: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ContactAddress)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrcontactaddress)).ok() }
    }
    pub unsafe fn ContactPhone(&self, pbstrcontactphone: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ContactPhone)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrcontactphone)).ok() }
    }
    pub unsafe fn ContactEmail(&self, pbstrcontactemail: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ContactEmail)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrcontactemail)).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMChannelInfo_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ChannelName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ChannelDescription: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ChannelURL: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ContactAddress: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ContactPhone: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ContactEmail: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAMChannelInfo_Impl: super::super::System::Com::IDispatch_Impl {
    fn ChannelName(&self, pbstrchannelname: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn ChannelDescription(&self, pbstrchanneldescription: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn ChannelURL(&self, pbstrchannelurl: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn ContactAddress(&self, pbstrcontactaddress: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn ContactPhone(&self, pbstrcontactphone: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn ContactEmail(&self, pbstrcontactemail: *mut windows_core::BSTR) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAMChannelInfo_Vtbl {
    pub const fn new<Identity: IAMChannelInfo_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ChannelName<Identity: IAMChannelInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrchannelname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMChannelInfo_Impl::ChannelName(this, core::mem::transmute_copy(&pbstrchannelname)).into()
            }
        }
        unsafe extern "system" fn ChannelDescription<Identity: IAMChannelInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrchanneldescription: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMChannelInfo_Impl::ChannelDescription(this, core::mem::transmute_copy(&pbstrchanneldescription)).into()
            }
        }
        unsafe extern "system" fn ChannelURL<Identity: IAMChannelInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrchannelurl: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMChannelInfo_Impl::ChannelURL(this, core::mem::transmute_copy(&pbstrchannelurl)).into()
            }
        }
        unsafe extern "system" fn ContactAddress<Identity: IAMChannelInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrcontactaddress: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMChannelInfo_Impl::ContactAddress(this, core::mem::transmute_copy(&pbstrcontactaddress)).into()
            }
        }
        unsafe extern "system" fn ContactPhone<Identity: IAMChannelInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrcontactphone: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMChannelInfo_Impl::ContactPhone(this, core::mem::transmute_copy(&pbstrcontactphone)).into()
            }
        }
        unsafe extern "system" fn ContactEmail<Identity: IAMChannelInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrcontactemail: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMChannelInfo_Impl::ContactEmail(this, core::mem::transmute_copy(&pbstrcontactemail)).into()
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            ChannelName: ChannelName::<Identity, OFFSET>,
            ChannelDescription: ChannelDescription::<Identity, OFFSET>,
            ChannelURL: ChannelURL::<Identity, OFFSET>,
            ContactAddress: ContactAddress::<Identity, OFFSET>,
            ContactPhone: ContactPhone::<Identity, OFFSET>,
            ContactEmail: ContactEmail::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMChannelInfo as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAMChannelInfo {}
windows_core::imp::define_interface!(IAMClockAdjust, IAMClockAdjust_Vtbl, 0x4d5466b0_a49c_11d1_abe8_00a0c905f375);
windows_core::imp::interface_hierarchy!(IAMClockAdjust, windows_core::IUnknown);
impl IAMClockAdjust {
    pub unsafe fn SetClockDelta(&self, rtdelta: i64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetClockDelta)(windows_core::Interface::as_raw(self), rtdelta).ok() }
    }
}
#[repr(C)]
pub struct IAMClockAdjust_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetClockDelta: unsafe extern "system" fn(*mut core::ffi::c_void, i64) -> windows_core::HRESULT,
}
pub trait IAMClockAdjust_Impl: windows_core::IUnknownImpl {
    fn SetClockDelta(&self, rtdelta: i64) -> windows_core::Result<()>;
}
impl IAMClockAdjust_Vtbl {
    pub const fn new<Identity: IAMClockAdjust_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetClockDelta<Identity: IAMClockAdjust_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, rtdelta: i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMClockAdjust_Impl::SetClockDelta(this, core::mem::transmute_copy(&rtdelta)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), SetClockDelta: SetClockDelta::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMClockAdjust as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMClockAdjust {}
windows_core::imp::define_interface!(IAMClockSlave, IAMClockSlave_Vtbl, 0x9fd52741_176d_4b36_8f51_ca8f933223be);
windows_core::imp::interface_hierarchy!(IAMClockSlave, windows_core::IUnknown);
impl IAMClockSlave {
    pub unsafe fn SetErrorTolerance(&self, dwtolerance: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetErrorTolerance)(windows_core::Interface::as_raw(self), dwtolerance).ok() }
    }
    pub unsafe fn GetErrorTolerance(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetErrorTolerance)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAMClockSlave_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetErrorTolerance: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetErrorTolerance: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IAMClockSlave_Impl: windows_core::IUnknownImpl {
    fn SetErrorTolerance(&self, dwtolerance: u32) -> windows_core::Result<()>;
    fn GetErrorTolerance(&self) -> windows_core::Result<u32>;
}
impl IAMClockSlave_Vtbl {
    pub const fn new<Identity: IAMClockSlave_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetErrorTolerance<Identity: IAMClockSlave_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwtolerance: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMClockSlave_Impl::SetErrorTolerance(this, core::mem::transmute_copy(&dwtolerance)).into()
            }
        }
        unsafe extern "system" fn GetErrorTolerance<Identity: IAMClockSlave_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwtolerance: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMClockSlave_Impl::GetErrorTolerance(this) {
                    Ok(ok__) => {
                        pdwtolerance.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetErrorTolerance: SetErrorTolerance::<Identity, OFFSET>,
            GetErrorTolerance: GetErrorTolerance::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMClockSlave as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMClockSlave {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAMCollection, IAMCollection_Vtbl, 0x56a868b9_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAMCollection {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAMCollection, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMCollection {
    pub unsafe fn Count(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Count)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Item(&self, litem: i32) -> windows_core::Result<windows_core::IUnknown> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Item)(windows_core::Interface::as_raw(self), litem, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn _NewEnum(&self) -> windows_core::Result<windows_core::IUnknown> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self)._NewEnum)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMCollection_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub Item: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAMCollection_Impl: super::super::System::Com::IDispatch_Impl {
    fn Count(&self) -> windows_core::Result<i32>;
    fn Item(&self, litem: i32) -> windows_core::Result<windows_core::IUnknown>;
    fn _NewEnum(&self) -> windows_core::Result<windows_core::IUnknown>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAMCollection_Vtbl {
    pub const fn new<Identity: IAMCollection_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Count<Identity: IAMCollection_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plcount: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMCollection_Impl::Count(this) {
                    Ok(ok__) => {
                        plcount.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Item<Identity: IAMCollection_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, litem: i32, ppunk: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMCollection_Impl::Item(this, core::mem::transmute_copy(&litem)) {
                    Ok(ok__) => {
                        ppunk.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn _NewEnum<Identity: IAMCollection_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppunk: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMCollection_Impl::_NewEnum(this) {
                    Ok(ok__) => {
                        ppunk.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            Count: Count::<Identity, OFFSET>,
            Item: Item::<Identity, OFFSET>,
            _NewEnum: _NewEnum::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMCollection as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAMCollection {}
windows_core::imp::define_interface!(IAMCopyCaptureFileProgress, IAMCopyCaptureFileProgress_Vtbl, 0x670d1d20_a068_11d0_b3f0_00aa003761c5);
windows_core::imp::interface_hierarchy!(IAMCopyCaptureFileProgress, windows_core::IUnknown);
impl IAMCopyCaptureFileProgress {
    pub unsafe fn Progress(&self, iprogress: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Progress)(windows_core::Interface::as_raw(self), iprogress).ok() }
    }
}
#[repr(C)]
pub struct IAMCopyCaptureFileProgress_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Progress: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
pub trait IAMCopyCaptureFileProgress_Impl: windows_core::IUnknownImpl {
    fn Progress(&self, iprogress: i32) -> windows_core::Result<()>;
}
impl IAMCopyCaptureFileProgress_Vtbl {
    pub const fn new<Identity: IAMCopyCaptureFileProgress_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Progress<Identity: IAMCopyCaptureFileProgress_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, iprogress: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMCopyCaptureFileProgress_Impl::Progress(this, core::mem::transmute_copy(&iprogress)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Progress: Progress::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMCopyCaptureFileProgress as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMCopyCaptureFileProgress {}
windows_core::imp::define_interface!(IAMCrossbar, IAMCrossbar_Vtbl, 0xc6e13380_30ac_11d0_a18c_00a0c9118956);
windows_core::imp::interface_hierarchy!(IAMCrossbar, windows_core::IUnknown);
impl IAMCrossbar {
    pub unsafe fn get_PinCounts(&self, outputpincount: *mut i32, inputpincount: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_PinCounts)(windows_core::Interface::as_raw(self), outputpincount as _, inputpincount as _).ok() }
    }
    pub unsafe fn CanRoute(&self, outputpinindex: i32, inputpinindex: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CanRoute)(windows_core::Interface::as_raw(self), outputpinindex, inputpinindex).ok() }
    }
    pub unsafe fn Route(&self, outputpinindex: i32, inputpinindex: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Route)(windows_core::Interface::as_raw(self), outputpinindex, inputpinindex).ok() }
    }
    pub unsafe fn get_IsRoutedTo(&self, outputpinindex: i32) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).get_IsRoutedTo)(windows_core::Interface::as_raw(self), outputpinindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn get_CrossbarPinInfo(&self, isinputpin: bool, pinindex: i32, pinindexrelated: *mut i32, physicaltype: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_CrossbarPinInfo)(windows_core::Interface::as_raw(self), isinputpin.into(), pinindex, pinindexrelated as _, physicaltype as _).ok() }
    }
}
#[repr(C)]
pub struct IAMCrossbar_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub get_PinCounts: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32, *mut i32) -> windows_core::HRESULT,
    pub CanRoute: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32) -> windows_core::HRESULT,
    pub Route: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32) -> windows_core::HRESULT,
    pub get_IsRoutedTo: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32) -> windows_core::HRESULT,
    pub get_CrossbarPinInfo: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL, i32, *mut i32, *mut i32) -> windows_core::HRESULT,
}
pub trait IAMCrossbar_Impl: windows_core::IUnknownImpl {
    fn get_PinCounts(&self, outputpincount: *mut i32, inputpincount: *mut i32) -> windows_core::Result<()>;
    fn CanRoute(&self, outputpinindex: i32, inputpinindex: i32) -> windows_core::Result<()>;
    fn Route(&self, outputpinindex: i32, inputpinindex: i32) -> windows_core::Result<()>;
    fn get_IsRoutedTo(&self, outputpinindex: i32) -> windows_core::Result<i32>;
    fn get_CrossbarPinInfo(&self, isinputpin: windows_core::BOOL, pinindex: i32, pinindexrelated: *mut i32, physicaltype: *mut i32) -> windows_core::Result<()>;
}
impl IAMCrossbar_Vtbl {
    pub const fn new<Identity: IAMCrossbar_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn get_PinCounts<Identity: IAMCrossbar_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputpincount: *mut i32, inputpincount: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMCrossbar_Impl::get_PinCounts(this, core::mem::transmute_copy(&outputpincount), core::mem::transmute_copy(&inputpincount)).into()
            }
        }
        unsafe extern "system" fn CanRoute<Identity: IAMCrossbar_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputpinindex: i32, inputpinindex: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMCrossbar_Impl::CanRoute(this, core::mem::transmute_copy(&outputpinindex), core::mem::transmute_copy(&inputpinindex)).into()
            }
        }
        unsafe extern "system" fn Route<Identity: IAMCrossbar_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputpinindex: i32, inputpinindex: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMCrossbar_Impl::Route(this, core::mem::transmute_copy(&outputpinindex), core::mem::transmute_copy(&inputpinindex)).into()
            }
        }
        unsafe extern "system" fn get_IsRoutedTo<Identity: IAMCrossbar_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, outputpinindex: i32, inputpinindex: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMCrossbar_Impl::get_IsRoutedTo(this, core::mem::transmute_copy(&outputpinindex)) {
                    Ok(ok__) => {
                        inputpinindex.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn get_CrossbarPinInfo<Identity: IAMCrossbar_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, isinputpin: windows_core::BOOL, pinindex: i32, pinindexrelated: *mut i32, physicaltype: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMCrossbar_Impl::get_CrossbarPinInfo(this, core::mem::transmute_copy(&isinputpin), core::mem::transmute_copy(&pinindex), core::mem::transmute_copy(&pinindexrelated), core::mem::transmute_copy(&physicaltype)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            get_PinCounts: get_PinCounts::<Identity, OFFSET>,
            CanRoute: CanRoute::<Identity, OFFSET>,
            Route: Route::<Identity, OFFSET>,
            get_IsRoutedTo: get_IsRoutedTo::<Identity, OFFSET>,
            get_CrossbarPinInfo: get_CrossbarPinInfo::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMCrossbar as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMCrossbar {}
windows_core::imp::define_interface!(IAMDecoderCaps, IAMDecoderCaps_Vtbl, 0xc0dff467_d499_4986_972b_e1d9090fa941);
windows_core::imp::interface_hierarchy!(IAMDecoderCaps, windows_core::IUnknown);
impl IAMDecoderCaps {
    pub unsafe fn GetDecoderCaps(&self, dwcapindex: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDecoderCaps)(windows_core::Interface::as_raw(self), dwcapindex, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAMDecoderCaps_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDecoderCaps: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
}
pub trait IAMDecoderCaps_Impl: windows_core::IUnknownImpl {
    fn GetDecoderCaps(&self, dwcapindex: u32) -> windows_core::Result<u32>;
}
impl IAMDecoderCaps_Vtbl {
    pub const fn new<Identity: IAMDecoderCaps_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDecoderCaps<Identity: IAMDecoderCaps_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwcapindex: u32, lpdwcap: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMDecoderCaps_Impl::GetDecoderCaps(this, core::mem::transmute_copy(&dwcapindex)) {
                    Ok(ok__) => {
                        lpdwcap.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), GetDecoderCaps: GetDecoderCaps::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMDecoderCaps as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMDecoderCaps {}
windows_core::imp::define_interface!(IAMDevMemoryAllocator, IAMDevMemoryAllocator_Vtbl, 0xc6545bf0_e76b_11d0_bd52_00a0c911ce86);
windows_core::imp::interface_hierarchy!(IAMDevMemoryAllocator, windows_core::IUnknown);
impl IAMDevMemoryAllocator {
    pub unsafe fn GetInfo(&self, pdwcbtotalfree: *mut u32, pdwcblargestfree: *mut u32, pdwcbtotalmemory: *mut u32, pdwcbminimumchunk: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetInfo)(windows_core::Interface::as_raw(self), pdwcbtotalfree as _, pdwcblargestfree as _, pdwcbtotalmemory as _, pdwcbminimumchunk as _).ok() }
    }
    pub unsafe fn CheckMemory(&self, pbuffer: *const u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CheckMemory)(windows_core::Interface::as_raw(self), pbuffer).ok() }
    }
    pub unsafe fn Alloc(&self, ppbuffer: *mut *mut u8, pdwcbbuffer: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Alloc)(windows_core::Interface::as_raw(self), ppbuffer as _, pdwcbbuffer as _).ok() }
    }
    pub unsafe fn Free(&self, pbuffer: *const u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Free)(windows_core::Interface::as_raw(self), pbuffer).ok() }
    }
    pub unsafe fn GetDevMemoryObject<P1>(&self, ppunkinnner: *mut Option<windows_core::IUnknown>, punkouter: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetDevMemoryObject)(windows_core::Interface::as_raw(self), core::mem::transmute(ppunkinnner), punkouter.param().abi()).ok() }
    }
}
#[repr(C)]
pub struct IAMDevMemoryAllocator_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub CheckMemory: unsafe extern "system" fn(*mut core::ffi::c_void, *const u8) -> windows_core::HRESULT,
    pub Alloc: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut u8, *mut u32) -> windows_core::HRESULT,
    pub Free: unsafe extern "system" fn(*mut core::ffi::c_void, *const u8) -> windows_core::HRESULT,
    pub GetDevMemoryObject: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAMDevMemoryAllocator_Impl: windows_core::IUnknownImpl {
    fn GetInfo(&self, pdwcbtotalfree: *mut u32, pdwcblargestfree: *mut u32, pdwcbtotalmemory: *mut u32, pdwcbminimumchunk: *mut u32) -> windows_core::Result<()>;
    fn CheckMemory(&self, pbuffer: *const u8) -> windows_core::Result<()>;
    fn Alloc(&self, ppbuffer: *mut *mut u8, pdwcbbuffer: *mut u32) -> windows_core::Result<()>;
    fn Free(&self, pbuffer: *const u8) -> windows_core::Result<()>;
    fn GetDevMemoryObject(&self, ppunkinnner: windows_core::OutRef<'_, windows_core::IUnknown>, punkouter: windows_core::Ref<'_, windows_core::IUnknown>) -> windows_core::Result<()>;
}
impl IAMDevMemoryAllocator_Vtbl {
    pub const fn new<Identity: IAMDevMemoryAllocator_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetInfo<Identity: IAMDevMemoryAllocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwcbtotalfree: *mut u32, pdwcblargestfree: *mut u32, pdwcbtotalmemory: *mut u32, pdwcbminimumchunk: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDevMemoryAllocator_Impl::GetInfo(this, core::mem::transmute_copy(&pdwcbtotalfree), core::mem::transmute_copy(&pdwcblargestfree), core::mem::transmute_copy(&pdwcbtotalmemory), core::mem::transmute_copy(&pdwcbminimumchunk)).into()
            }
        }
        unsafe extern "system" fn CheckMemory<Identity: IAMDevMemoryAllocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbuffer: *const u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDevMemoryAllocator_Impl::CheckMemory(this, core::mem::transmute_copy(&pbuffer)).into()
            }
        }
        unsafe extern "system" fn Alloc<Identity: IAMDevMemoryAllocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppbuffer: *mut *mut u8, pdwcbbuffer: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDevMemoryAllocator_Impl::Alloc(this, core::mem::transmute_copy(&ppbuffer), core::mem::transmute_copy(&pdwcbbuffer)).into()
            }
        }
        unsafe extern "system" fn Free<Identity: IAMDevMemoryAllocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbuffer: *const u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDevMemoryAllocator_Impl::Free(this, core::mem::transmute_copy(&pbuffer)).into()
            }
        }
        unsafe extern "system" fn GetDevMemoryObject<Identity: IAMDevMemoryAllocator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppunkinnner: *mut *mut core::ffi::c_void, punkouter: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDevMemoryAllocator_Impl::GetDevMemoryObject(this, core::mem::transmute_copy(&ppunkinnner), core::mem::transmute_copy(&punkouter)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetInfo: GetInfo::<Identity, OFFSET>,
            CheckMemory: CheckMemory::<Identity, OFFSET>,
            Alloc: Alloc::<Identity, OFFSET>,
            Free: Free::<Identity, OFFSET>,
            GetDevMemoryObject: GetDevMemoryObject::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMDevMemoryAllocator as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMDevMemoryAllocator {}
windows_core::imp::define_interface!(IAMDevMemoryControl, IAMDevMemoryControl_Vtbl, 0xc6545bf1_e76b_11d0_bd52_00a0c911ce86);
windows_core::imp::interface_hierarchy!(IAMDevMemoryControl, windows_core::IUnknown);
impl IAMDevMemoryControl {
    pub unsafe fn QueryWriteSync(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).QueryWriteSync)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn WriteSync(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).WriteSync)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetDevId(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDevId)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAMDevMemoryControl_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub QueryWriteSync: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WriteSync: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetDevId: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IAMDevMemoryControl_Impl: windows_core::IUnknownImpl {
    fn QueryWriteSync(&self) -> windows_core::Result<()>;
    fn WriteSync(&self) -> windows_core::Result<()>;
    fn GetDevId(&self) -> windows_core::Result<u32>;
}
impl IAMDevMemoryControl_Vtbl {
    pub const fn new<Identity: IAMDevMemoryControl_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn QueryWriteSync<Identity: IAMDevMemoryControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDevMemoryControl_Impl::QueryWriteSync(this).into()
            }
        }
        unsafe extern "system" fn WriteSync<Identity: IAMDevMemoryControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDevMemoryControl_Impl::WriteSync(this).into()
            }
        }
        unsafe extern "system" fn GetDevId<Identity: IAMDevMemoryControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwdevid: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMDevMemoryControl_Impl::GetDevId(this) {
                    Ok(ok__) => {
                        pdwdevid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            QueryWriteSync: QueryWriteSync::<Identity, OFFSET>,
            WriteSync: WriteSync::<Identity, OFFSET>,
            GetDevId: GetDevId::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMDevMemoryControl as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMDevMemoryControl {}
windows_core::imp::define_interface!(IAMDeviceRemoval, IAMDeviceRemoval_Vtbl, 0xf90a6130_b658_11d2_ae49_0000f8754b99);
windows_core::imp::interface_hierarchy!(IAMDeviceRemoval, windows_core::IUnknown);
impl IAMDeviceRemoval {
    pub unsafe fn DeviceInfo(&self, pclsidinterfaceclass: *mut windows_core::GUID, pwszsymboliclink: *mut windows_core::PWSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DeviceInfo)(windows_core::Interface::as_raw(self), pclsidinterfaceclass as _, pwszsymboliclink as _).ok() }
    }
    pub unsafe fn Reassociate(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Reassociate)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Disassociate(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Disassociate)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
pub struct IAMDeviceRemoval_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub DeviceInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub Reassociate: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Disassociate: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAMDeviceRemoval_Impl: windows_core::IUnknownImpl {
    fn DeviceInfo(&self, pclsidinterfaceclass: *mut windows_core::GUID, pwszsymboliclink: *mut windows_core::PWSTR) -> windows_core::Result<()>;
    fn Reassociate(&self) -> windows_core::Result<()>;
    fn Disassociate(&self) -> windows_core::Result<()>;
}
impl IAMDeviceRemoval_Vtbl {
    pub const fn new<Identity: IAMDeviceRemoval_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn DeviceInfo<Identity: IAMDeviceRemoval_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pclsidinterfaceclass: *mut windows_core::GUID, pwszsymboliclink: *mut windows_core::PWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDeviceRemoval_Impl::DeviceInfo(this, core::mem::transmute_copy(&pclsidinterfaceclass), core::mem::transmute_copy(&pwszsymboliclink)).into()
            }
        }
        unsafe extern "system" fn Reassociate<Identity: IAMDeviceRemoval_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDeviceRemoval_Impl::Reassociate(this).into()
            }
        }
        unsafe extern "system" fn Disassociate<Identity: IAMDeviceRemoval_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDeviceRemoval_Impl::Disassociate(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            DeviceInfo: DeviceInfo::<Identity, OFFSET>,
            Reassociate: Reassociate::<Identity, OFFSET>,
            Disassociate: Disassociate::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMDeviceRemoval as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMDeviceRemoval {}
windows_core::imp::define_interface!(IAMDirectSound, IAMDirectSound_Vtbl, 0x546f4260_d53e_11cf_b3f0_00aa003761c5);
windows_core::imp::interface_hierarchy!(IAMDirectSound, windows_core::IUnknown);
impl IAMDirectSound {
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn GetDirectSoundInterface(&self) -> windows_core::Result<super::Audio::DirectSound::IDirectSound> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDirectSoundInterface)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn GetPrimaryBufferInterface(&self) -> windows_core::Result<super::Audio::DirectSound::IDirectSoundBuffer> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPrimaryBufferInterface)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn GetSecondaryBufferInterface(&self) -> windows_core::Result<super::Audio::DirectSound::IDirectSoundBuffer> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSecondaryBufferInterface)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn ReleaseDirectSoundInterface<P0>(&self, lpds: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::Audio::DirectSound::IDirectSound>,
    {
        unsafe { (windows_core::Interface::vtable(self).ReleaseDirectSoundInterface)(windows_core::Interface::as_raw(self), lpds.param().abi()).ok() }
    }
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn ReleasePrimaryBufferInterface<P0>(&self, lpdsb: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::Audio::DirectSound::IDirectSoundBuffer>,
    {
        unsafe { (windows_core::Interface::vtable(self).ReleasePrimaryBufferInterface)(windows_core::Interface::as_raw(self), lpdsb.param().abi()).ok() }
    }
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn ReleaseSecondaryBufferInterface<P0>(&self, lpdsb: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::Audio::DirectSound::IDirectSoundBuffer>,
    {
        unsafe { (windows_core::Interface::vtable(self).ReleaseSecondaryBufferInterface)(windows_core::Interface::as_raw(self), lpdsb.param().abi()).ok() }
    }
    pub unsafe fn SetFocusWindow(&self, param0: super::super::Foundation::HWND, param1: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFocusWindow)(windows_core::Interface::as_raw(self), param0, param1.into()).ok() }
    }
    pub unsafe fn GetFocusWindow(&self, param0: *mut super::super::Foundation::HWND, param1: *mut windows_core::BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetFocusWindow)(windows_core::Interface::as_raw(self), param0 as _, param1 as _).ok() }
    }
}
#[repr(C)]
pub struct IAMDirectSound_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub GetDirectSoundInterface: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    GetDirectSoundInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub GetPrimaryBufferInterface: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    GetPrimaryBufferInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub GetSecondaryBufferInterface: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    GetSecondaryBufferInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub ReleaseDirectSoundInterface: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    ReleaseDirectSoundInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub ReleasePrimaryBufferInterface: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    ReleasePrimaryBufferInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub ReleaseSecondaryBufferInterface: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    ReleaseSecondaryBufferInterface: usize,
    pub SetFocusWindow: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HWND, windows_core::BOOL) -> windows_core::HRESULT,
    pub GetFocusWindow: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::HWND, *mut windows_core::BOOL) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Media_Audio_DirectSound")]
pub trait IAMDirectSound_Impl: windows_core::IUnknownImpl {
    fn GetDirectSoundInterface(&self) -> windows_core::Result<super::Audio::DirectSound::IDirectSound>;
    fn GetPrimaryBufferInterface(&self) -> windows_core::Result<super::Audio::DirectSound::IDirectSoundBuffer>;
    fn GetSecondaryBufferInterface(&self) -> windows_core::Result<super::Audio::DirectSound::IDirectSoundBuffer>;
    fn ReleaseDirectSoundInterface(&self, lpds: windows_core::Ref<'_, super::Audio::DirectSound::IDirectSound>) -> windows_core::Result<()>;
    fn ReleasePrimaryBufferInterface(&self, lpdsb: windows_core::Ref<'_, super::Audio::DirectSound::IDirectSoundBuffer>) -> windows_core::Result<()>;
    fn ReleaseSecondaryBufferInterface(&self, lpdsb: windows_core::Ref<'_, super::Audio::DirectSound::IDirectSoundBuffer>) -> windows_core::Result<()>;
    fn SetFocusWindow(&self, param0: super::super::Foundation::HWND, param1: windows_core::BOOL) -> windows_core::Result<()>;
    fn GetFocusWindow(&self, param0: *mut super::super::Foundation::HWND, param1: *mut windows_core::BOOL) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Media_Audio_DirectSound")]
impl IAMDirectSound_Vtbl {
    pub const fn new<Identity: IAMDirectSound_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDirectSoundInterface<Identity: IAMDirectSound_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lplpds: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMDirectSound_Impl::GetDirectSoundInterface(this) {
                    Ok(ok__) => {
                        lplpds.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetPrimaryBufferInterface<Identity: IAMDirectSound_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lplpdsb: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMDirectSound_Impl::GetPrimaryBufferInterface(this) {
                    Ok(ok__) => {
                        lplpdsb.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSecondaryBufferInterface<Identity: IAMDirectSound_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lplpdsb: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMDirectSound_Impl::GetSecondaryBufferInterface(this) {
                    Ok(ok__) => {
                        lplpdsb.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn ReleaseDirectSoundInterface<Identity: IAMDirectSound_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpds: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDirectSound_Impl::ReleaseDirectSoundInterface(this, core::mem::transmute_copy(&lpds)).into()
            }
        }
        unsafe extern "system" fn ReleasePrimaryBufferInterface<Identity: IAMDirectSound_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpdsb: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDirectSound_Impl::ReleasePrimaryBufferInterface(this, core::mem::transmute_copy(&lpdsb)).into()
            }
        }
        unsafe extern "system" fn ReleaseSecondaryBufferInterface<Identity: IAMDirectSound_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpdsb: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDirectSound_Impl::ReleaseSecondaryBufferInterface(this, core::mem::transmute_copy(&lpdsb)).into()
            }
        }
        unsafe extern "system" fn SetFocusWindow<Identity: IAMDirectSound_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, param0: super::super::Foundation::HWND, param1: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDirectSound_Impl::SetFocusWindow(this, core::mem::transmute_copy(&param0), core::mem::transmute_copy(&param1)).into()
            }
        }
        unsafe extern "system" fn GetFocusWindow<Identity: IAMDirectSound_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, param0: *mut super::super::Foundation::HWND, param1: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDirectSound_Impl::GetFocusWindow(this, core::mem::transmute_copy(&param0), core::mem::transmute_copy(&param1)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetDirectSoundInterface: GetDirectSoundInterface::<Identity, OFFSET>,
            GetPrimaryBufferInterface: GetPrimaryBufferInterface::<Identity, OFFSET>,
            GetSecondaryBufferInterface: GetSecondaryBufferInterface::<Identity, OFFSET>,
            ReleaseDirectSoundInterface: ReleaseDirectSoundInterface::<Identity, OFFSET>,
            ReleasePrimaryBufferInterface: ReleasePrimaryBufferInterface::<Identity, OFFSET>,
            ReleaseSecondaryBufferInterface: ReleaseSecondaryBufferInterface::<Identity, OFFSET>,
            SetFocusWindow: SetFocusWindow::<Identity, OFFSET>,
            GetFocusWindow: GetFocusWindow::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMDirectSound as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Media_Audio_DirectSound")]
impl windows_core::RuntimeName for IAMDirectSound {}
windows_core::imp::define_interface!(IAMDroppedFrames, IAMDroppedFrames_Vtbl, 0xc6e13344_30ac_11d0_a18c_00a0c9118956);
windows_core::imp::interface_hierarchy!(IAMDroppedFrames, windows_core::IUnknown);
impl IAMDroppedFrames {
    pub unsafe fn GetNumDropped(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumDropped)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetNumNotDropped(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetNumNotDropped)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetDroppedInfo(&self, lsize: i32, plarray: *mut i32, plnumcopied: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDroppedInfo)(windows_core::Interface::as_raw(self), lsize, plarray as _, plnumcopied as _).ok() }
    }
    pub unsafe fn GetAverageFrameSize(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetAverageFrameSize)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAMDroppedFrames_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetNumDropped: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub GetNumNotDropped: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub GetDroppedInfo: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32, *mut i32) -> windows_core::HRESULT,
    pub GetAverageFrameSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
}
pub trait IAMDroppedFrames_Impl: windows_core::IUnknownImpl {
    fn GetNumDropped(&self) -> windows_core::Result<i32>;
    fn GetNumNotDropped(&self) -> windows_core::Result<i32>;
    fn GetDroppedInfo(&self, lsize: i32, plarray: *mut i32, plnumcopied: *mut i32) -> windows_core::Result<()>;
    fn GetAverageFrameSize(&self) -> windows_core::Result<i32>;
}
impl IAMDroppedFrames_Vtbl {
    pub const fn new<Identity: IAMDroppedFrames_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetNumDropped<Identity: IAMDroppedFrames_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pldropped: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMDroppedFrames_Impl::GetNumDropped(this) {
                    Ok(ok__) => {
                        pldropped.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetNumNotDropped<Identity: IAMDroppedFrames_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plnotdropped: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMDroppedFrames_Impl::GetNumNotDropped(this) {
                    Ok(ok__) => {
                        plnotdropped.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetDroppedInfo<Identity: IAMDroppedFrames_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lsize: i32, plarray: *mut i32, plnumcopied: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMDroppedFrames_Impl::GetDroppedInfo(this, core::mem::transmute_copy(&lsize), core::mem::transmute_copy(&plarray), core::mem::transmute_copy(&plnumcopied)).into()
            }
        }
        unsafe extern "system" fn GetAverageFrameSize<Identity: IAMDroppedFrames_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plaveragesize: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMDroppedFrames_Impl::GetAverageFrameSize(this) {
                    Ok(ok__) => {
                        plaveragesize.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetNumDropped: GetNumDropped::<Identity, OFFSET>,
            GetNumNotDropped: GetNumNotDropped::<Identity, OFFSET>,
            GetDroppedInfo: GetDroppedInfo::<Identity, OFFSET>,
            GetAverageFrameSize: GetAverageFrameSize::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMDroppedFrames as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMDroppedFrames {}
windows_core::imp::define_interface!(IAMExtDevice, IAMExtDevice_Vtbl, 0xb5730a90_1a2c_11cf_8c23_00aa006b6814);
windows_core::imp::interface_hierarchy!(IAMExtDevice, windows_core::IUnknown);
impl IAMExtDevice {
    pub unsafe fn GetCapability(&self, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCapability)(windows_core::Interface::as_raw(self), capability, pvalue as _, pdblvalue as _).ok() }
    }
    pub unsafe fn ExternalDeviceID(&self) -> windows_core::Result<windows_core::PWSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ExternalDeviceID)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn ExternalDeviceVersion(&self) -> windows_core::Result<windows_core::PWSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ExternalDeviceVersion)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetDevicePower(&self, powermode: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDevicePower)(windows_core::Interface::as_raw(self), powermode).ok() }
    }
    pub unsafe fn DevicePower(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).DevicePower)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Calibrate(&self, hevent: usize, mode: i32) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Calibrate)(windows_core::Interface::as_raw(self), hevent, mode, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetDevicePort(&self, deviceport: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDevicePort)(windows_core::Interface::as_raw(self), deviceport).ok() }
    }
    pub unsafe fn DevicePort(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).DevicePort)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAMExtDevice_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetCapability: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32, *mut f64) -> windows_core::HRESULT,
    pub ExternalDeviceID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub ExternalDeviceVersion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub SetDevicePower: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub DevicePower: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub Calibrate: unsafe extern "system" fn(*mut core::ffi::c_void, usize, i32, *mut i32) -> windows_core::HRESULT,
    pub SetDevicePort: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub DevicePort: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
}
pub trait IAMExtDevice_Impl: windows_core::IUnknownImpl {
    fn GetCapability(&self, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> windows_core::Result<()>;
    fn ExternalDeviceID(&self) -> windows_core::Result<windows_core::PWSTR>;
    fn ExternalDeviceVersion(&self) -> windows_core::Result<windows_core::PWSTR>;
    fn SetDevicePower(&self, powermode: i32) -> windows_core::Result<()>;
    fn DevicePower(&self) -> windows_core::Result<i32>;
    fn Calibrate(&self, hevent: usize, mode: i32) -> windows_core::Result<i32>;
    fn SetDevicePort(&self, deviceport: i32) -> windows_core::Result<()>;
    fn DevicePort(&self) -> windows_core::Result<i32>;
}
impl IAMExtDevice_Vtbl {
    pub const fn new<Identity: IAMExtDevice_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetCapability<Identity: IAMExtDevice_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtDevice_Impl::GetCapability(this, core::mem::transmute_copy(&capability), core::mem::transmute_copy(&pvalue), core::mem::transmute_copy(&pdblvalue)).into()
            }
        }
        unsafe extern "system" fn ExternalDeviceID<Identity: IAMExtDevice_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppszdata: *mut windows_core::PWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtDevice_Impl::ExternalDeviceID(this) {
                    Ok(ok__) => {
                        ppszdata.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn ExternalDeviceVersion<Identity: IAMExtDevice_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppszdata: *mut windows_core::PWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtDevice_Impl::ExternalDeviceVersion(this) {
                    Ok(ok__) => {
                        ppszdata.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetDevicePower<Identity: IAMExtDevice_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, powermode: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtDevice_Impl::SetDevicePower(this, core::mem::transmute_copy(&powermode)).into()
            }
        }
        unsafe extern "system" fn DevicePower<Identity: IAMExtDevice_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppowermode: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtDevice_Impl::DevicePower(this) {
                    Ok(ok__) => {
                        ppowermode.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Calibrate<Identity: IAMExtDevice_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hevent: usize, mode: i32, pstatus: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtDevice_Impl::Calibrate(this, core::mem::transmute_copy(&hevent), core::mem::transmute_copy(&mode)) {
                    Ok(ok__) => {
                        pstatus.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetDevicePort<Identity: IAMExtDevice_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, deviceport: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtDevice_Impl::SetDevicePort(this, core::mem::transmute_copy(&deviceport)).into()
            }
        }
        unsafe extern "system" fn DevicePort<Identity: IAMExtDevice_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdeviceport: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtDevice_Impl::DevicePort(this) {
                    Ok(ok__) => {
                        pdeviceport.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetCapability: GetCapability::<Identity, OFFSET>,
            ExternalDeviceID: ExternalDeviceID::<Identity, OFFSET>,
            ExternalDeviceVersion: ExternalDeviceVersion::<Identity, OFFSET>,
            SetDevicePower: SetDevicePower::<Identity, OFFSET>,
            DevicePower: DevicePower::<Identity, OFFSET>,
            Calibrate: Calibrate::<Identity, OFFSET>,
            SetDevicePort: SetDevicePort::<Identity, OFFSET>,
            DevicePort: DevicePort::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMExtDevice as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMExtDevice {}
windows_core::imp::define_interface!(IAMExtTransport, IAMExtTransport_Vtbl, 0xa03cd5f0_3045_11cf_8c44_00aa006b6814);
windows_core::imp::interface_hierarchy!(IAMExtTransport, windows_core::IUnknown);
impl IAMExtTransport {
    pub unsafe fn GetCapability(&self, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCapability)(windows_core::Interface::as_raw(self), capability, pvalue as _, pdblvalue as _).ok() }
    }
    pub unsafe fn SetMediaState(&self, state: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMediaState)(windows_core::Interface::as_raw(self), state).ok() }
    }
    pub unsafe fn MediaState(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).MediaState)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetLocalControl(&self, state: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetLocalControl)(windows_core::Interface::as_raw(self), state).ok() }
    }
    pub unsafe fn LocalControl(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).LocalControl)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetStatus(&self, statusitem: i32) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetStatus)(windows_core::Interface::as_raw(self), statusitem, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTransportBasicParameters(&self, param: i32, pvalue: *mut i32, ppszdata: *mut windows_core::PWSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTransportBasicParameters)(windows_core::Interface::as_raw(self), param, pvalue as _, ppszdata as _).ok() }
    }
    pub unsafe fn SetTransportBasicParameters<P2>(&self, param: i32, value: i32, pszdata: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetTransportBasicParameters)(windows_core::Interface::as_raw(self), param, value, pszdata.param().abi()).ok() }
    }
    pub unsafe fn GetTransportVideoParameters(&self, param: i32) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTransportVideoParameters)(windows_core::Interface::as_raw(self), param, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTransportVideoParameters(&self, param: i32, value: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTransportVideoParameters)(windows_core::Interface::as_raw(self), param, value).ok() }
    }
    pub unsafe fn GetTransportAudioParameters(&self, param: i32) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTransportAudioParameters)(windows_core::Interface::as_raw(self), param, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTransportAudioParameters(&self, param: i32, value: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTransportAudioParameters)(windows_core::Interface::as_raw(self), param, value).ok() }
    }
    pub unsafe fn SetMode(&self, mode: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMode)(windows_core::Interface::as_raw(self), mode).ok() }
    }
    pub unsafe fn Mode(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Mode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetRate(&self, dblrate: f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetRate)(windows_core::Interface::as_raw(self), dblrate).ok() }
    }
    pub unsafe fn Rate(&self) -> windows_core::Result<f64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Rate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetChase(&self, penabled: *mut i32, poffset: *mut i32, phevent: *mut usize) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetChase)(windows_core::Interface::as_raw(self), penabled as _, poffset as _, phevent as _).ok() }
    }
    pub unsafe fn SetChase(&self, enable: i32, offset: i32, hevent: usize) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetChase)(windows_core::Interface::as_raw(self), enable, offset, hevent).ok() }
    }
    pub unsafe fn GetBump(&self, pspeed: *mut i32, pduration: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetBump)(windows_core::Interface::as_raw(self), pspeed as _, pduration as _).ok() }
    }
    pub unsafe fn SetBump(&self, speed: i32, duration: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetBump)(windows_core::Interface::as_raw(self), speed, duration).ok() }
    }
    pub unsafe fn AntiClogControl(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AntiClogControl)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetAntiClogControl(&self, enable: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetAntiClogControl)(windows_core::Interface::as_raw(self), enable).ok() }
    }
    pub unsafe fn GetEditPropertySet(&self, editid: i32) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEditPropertySet)(windows_core::Interface::as_raw(self), editid, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetEditPropertySet(&self, peditid: *mut i32, state: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetEditPropertySet)(windows_core::Interface::as_raw(self), peditid as _, state).ok() }
    }
    pub unsafe fn GetEditProperty(&self, editid: i32, param: i32) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetEditProperty)(windows_core::Interface::as_raw(self), editid, param, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetEditProperty(&self, editid: i32, param: i32, value: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetEditProperty)(windows_core::Interface::as_raw(self), editid, param, value).ok() }
    }
    pub unsafe fn EditStart(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EditStart)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetEditStart(&self, value: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetEditStart)(windows_core::Interface::as_raw(self), value).ok() }
    }
}
#[repr(C)]
pub struct IAMExtTransport_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetCapability: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32, *mut f64) -> windows_core::HRESULT,
    pub SetMediaState: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub MediaState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetLocalControl: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub LocalControl: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub GetStatus: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32) -> windows_core::HRESULT,
    pub GetTransportBasicParameters: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32, *mut windows_core::PWSTR) -> windows_core::HRESULT,
    pub SetTransportBasicParameters: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub GetTransportVideoParameters: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32) -> windows_core::HRESULT,
    pub SetTransportVideoParameters: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32) -> windows_core::HRESULT,
    pub GetTransportAudioParameters: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32) -> windows_core::HRESULT,
    pub SetTransportAudioParameters: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32) -> windows_core::HRESULT,
    pub SetMode: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub Mode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetRate: unsafe extern "system" fn(*mut core::ffi::c_void, f64) -> windows_core::HRESULT,
    pub Rate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f64) -> windows_core::HRESULT,
    pub GetChase: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32, *mut i32, *mut usize) -> windows_core::HRESULT,
    pub SetChase: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32, usize) -> windows_core::HRESULT,
    pub GetBump: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32, *mut i32) -> windows_core::HRESULT,
    pub SetBump: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32) -> windows_core::HRESULT,
    pub AntiClogControl: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetAntiClogControl: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub GetEditPropertySet: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32) -> windows_core::HRESULT,
    pub SetEditPropertySet: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32, i32) -> windows_core::HRESULT,
    pub GetEditProperty: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32, *mut i32) -> windows_core::HRESULT,
    pub SetEditProperty: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32, i32) -> windows_core::HRESULT,
    pub EditStart: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetEditStart: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
}
pub trait IAMExtTransport_Impl: windows_core::IUnknownImpl {
    fn GetCapability(&self, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> windows_core::Result<()>;
    fn SetMediaState(&self, state: i32) -> windows_core::Result<()>;
    fn MediaState(&self) -> windows_core::Result<i32>;
    fn SetLocalControl(&self, state: i32) -> windows_core::Result<()>;
    fn LocalControl(&self) -> windows_core::Result<i32>;
    fn GetStatus(&self, statusitem: i32) -> windows_core::Result<i32>;
    fn GetTransportBasicParameters(&self, param: i32, pvalue: *mut i32, ppszdata: *mut windows_core::PWSTR) -> windows_core::Result<()>;
    fn SetTransportBasicParameters(&self, param: i32, value: i32, pszdata: &windows_core::PCWSTR) -> windows_core::Result<()>;
    fn GetTransportVideoParameters(&self, param: i32) -> windows_core::Result<i32>;
    fn SetTransportVideoParameters(&self, param: i32, value: i32) -> windows_core::Result<()>;
    fn GetTransportAudioParameters(&self, param: i32) -> windows_core::Result<i32>;
    fn SetTransportAudioParameters(&self, param: i32, value: i32) -> windows_core::Result<()>;
    fn SetMode(&self, mode: i32) -> windows_core::Result<()>;
    fn Mode(&self) -> windows_core::Result<i32>;
    fn SetRate(&self, dblrate: f64) -> windows_core::Result<()>;
    fn Rate(&self) -> windows_core::Result<f64>;
    fn GetChase(&self, penabled: *mut i32, poffset: *mut i32, phevent: *mut usize) -> windows_core::Result<()>;
    fn SetChase(&self, enable: i32, offset: i32, hevent: usize) -> windows_core::Result<()>;
    fn GetBump(&self, pspeed: *mut i32, pduration: *mut i32) -> windows_core::Result<()>;
    fn SetBump(&self, speed: i32, duration: i32) -> windows_core::Result<()>;
    fn AntiClogControl(&self) -> windows_core::Result<i32>;
    fn SetAntiClogControl(&self, enable: i32) -> windows_core::Result<()>;
    fn GetEditPropertySet(&self, editid: i32) -> windows_core::Result<i32>;
    fn SetEditPropertySet(&self, peditid: *mut i32, state: i32) -> windows_core::Result<()>;
    fn GetEditProperty(&self, editid: i32, param: i32) -> windows_core::Result<i32>;
    fn SetEditProperty(&self, editid: i32, param: i32, value: i32) -> windows_core::Result<()>;
    fn EditStart(&self) -> windows_core::Result<i32>;
    fn SetEditStart(&self, value: i32) -> windows_core::Result<()>;
}
impl IAMExtTransport_Vtbl {
    pub const fn new<Identity: IAMExtTransport_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetCapability<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::GetCapability(this, core::mem::transmute_copy(&capability), core::mem::transmute_copy(&pvalue), core::mem::transmute_copy(&pdblvalue)).into()
            }
        }
        unsafe extern "system" fn SetMediaState<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, state: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::SetMediaState(this, core::mem::transmute_copy(&state)).into()
            }
        }
        unsafe extern "system" fn MediaState<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pstate: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtTransport_Impl::MediaState(this) {
                    Ok(ok__) => {
                        pstate.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetLocalControl<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, state: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::SetLocalControl(this, core::mem::transmute_copy(&state)).into()
            }
        }
        unsafe extern "system" fn LocalControl<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pstate: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtTransport_Impl::LocalControl(this) {
                    Ok(ok__) => {
                        pstate.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetStatus<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, statusitem: i32, pvalue: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtTransport_Impl::GetStatus(this, core::mem::transmute_copy(&statusitem)) {
                    Ok(ok__) => {
                        pvalue.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTransportBasicParameters<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, param: i32, pvalue: *mut i32, ppszdata: *mut windows_core::PWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::GetTransportBasicParameters(this, core::mem::transmute_copy(&param), core::mem::transmute_copy(&pvalue), core::mem::transmute_copy(&ppszdata)).into()
            }
        }
        unsafe extern "system" fn SetTransportBasicParameters<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, param: i32, value: i32, pszdata: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::SetTransportBasicParameters(this, core::mem::transmute_copy(&param), core::mem::transmute_copy(&value), core::mem::transmute(&pszdata)).into()
            }
        }
        unsafe extern "system" fn GetTransportVideoParameters<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, param: i32, pvalue: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtTransport_Impl::GetTransportVideoParameters(this, core::mem::transmute_copy(&param)) {
                    Ok(ok__) => {
                        pvalue.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTransportVideoParameters<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, param: i32, value: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::SetTransportVideoParameters(this, core::mem::transmute_copy(&param), core::mem::transmute_copy(&value)).into()
            }
        }
        unsafe extern "system" fn GetTransportAudioParameters<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, param: i32, pvalue: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtTransport_Impl::GetTransportAudioParameters(this, core::mem::transmute_copy(&param)) {
                    Ok(ok__) => {
                        pvalue.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTransportAudioParameters<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, param: i32, value: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::SetTransportAudioParameters(this, core::mem::transmute_copy(&param), core::mem::transmute_copy(&value)).into()
            }
        }
        unsafe extern "system" fn SetMode<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mode: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::SetMode(this, core::mem::transmute_copy(&mode)).into()
            }
        }
        unsafe extern "system" fn Mode<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmode: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtTransport_Impl::Mode(this) {
                    Ok(ok__) => {
                        pmode.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetRate<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dblrate: f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::SetRate(this, core::mem::transmute_copy(&dblrate)).into()
            }
        }
        unsafe extern "system" fn Rate<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdblrate: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtTransport_Impl::Rate(this) {
                    Ok(ok__) => {
                        pdblrate.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetChase<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, penabled: *mut i32, poffset: *mut i32, phevent: *mut usize) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::GetChase(this, core::mem::transmute_copy(&penabled), core::mem::transmute_copy(&poffset), core::mem::transmute_copy(&phevent)).into()
            }
        }
        unsafe extern "system" fn SetChase<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, enable: i32, offset: i32, hevent: usize) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::SetChase(this, core::mem::transmute_copy(&enable), core::mem::transmute_copy(&offset), core::mem::transmute_copy(&hevent)).into()
            }
        }
        unsafe extern "system" fn GetBump<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pspeed: *mut i32, pduration: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::GetBump(this, core::mem::transmute_copy(&pspeed), core::mem::transmute_copy(&pduration)).into()
            }
        }
        unsafe extern "system" fn SetBump<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, speed: i32, duration: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::SetBump(this, core::mem::transmute_copy(&speed), core::mem::transmute_copy(&duration)).into()
            }
        }
        unsafe extern "system" fn AntiClogControl<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, penabled: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtTransport_Impl::AntiClogControl(this) {
                    Ok(ok__) => {
                        penabled.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetAntiClogControl<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, enable: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::SetAntiClogControl(this, core::mem::transmute_copy(&enable)).into()
            }
        }
        unsafe extern "system" fn GetEditPropertySet<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, editid: i32, pstate: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtTransport_Impl::GetEditPropertySet(this, core::mem::transmute_copy(&editid)) {
                    Ok(ok__) => {
                        pstate.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetEditPropertySet<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, peditid: *mut i32, state: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::SetEditPropertySet(this, core::mem::transmute_copy(&peditid), core::mem::transmute_copy(&state)).into()
            }
        }
        unsafe extern "system" fn GetEditProperty<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, editid: i32, param: i32, pvalue: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtTransport_Impl::GetEditProperty(this, core::mem::transmute_copy(&editid), core::mem::transmute_copy(&param)) {
                    Ok(ok__) => {
                        pvalue.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetEditProperty<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, editid: i32, param: i32, value: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::SetEditProperty(this, core::mem::transmute_copy(&editid), core::mem::transmute_copy(&param), core::mem::transmute_copy(&value)).into()
            }
        }
        unsafe extern "system" fn EditStart<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pvalue: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMExtTransport_Impl::EditStart(this) {
                    Ok(ok__) => {
                        pvalue.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetEditStart<Identity: IAMExtTransport_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, value: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtTransport_Impl::SetEditStart(this, core::mem::transmute_copy(&value)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetCapability: GetCapability::<Identity, OFFSET>,
            SetMediaState: SetMediaState::<Identity, OFFSET>,
            MediaState: MediaState::<Identity, OFFSET>,
            SetLocalControl: SetLocalControl::<Identity, OFFSET>,
            LocalControl: LocalControl::<Identity, OFFSET>,
            GetStatus: GetStatus::<Identity, OFFSET>,
            GetTransportBasicParameters: GetTransportBasicParameters::<Identity, OFFSET>,
            SetTransportBasicParameters: SetTransportBasicParameters::<Identity, OFFSET>,
            GetTransportVideoParameters: GetTransportVideoParameters::<Identity, OFFSET>,
            SetTransportVideoParameters: SetTransportVideoParameters::<Identity, OFFSET>,
            GetTransportAudioParameters: GetTransportAudioParameters::<Identity, OFFSET>,
            SetTransportAudioParameters: SetTransportAudioParameters::<Identity, OFFSET>,
            SetMode: SetMode::<Identity, OFFSET>,
            Mode: Mode::<Identity, OFFSET>,
            SetRate: SetRate::<Identity, OFFSET>,
            Rate: Rate::<Identity, OFFSET>,
            GetChase: GetChase::<Identity, OFFSET>,
            SetChase: SetChase::<Identity, OFFSET>,
            GetBump: GetBump::<Identity, OFFSET>,
            SetBump: SetBump::<Identity, OFFSET>,
            AntiClogControl: AntiClogControl::<Identity, OFFSET>,
            SetAntiClogControl: SetAntiClogControl::<Identity, OFFSET>,
            GetEditPropertySet: GetEditPropertySet::<Identity, OFFSET>,
            SetEditPropertySet: SetEditPropertySet::<Identity, OFFSET>,
            GetEditProperty: GetEditProperty::<Identity, OFFSET>,
            SetEditProperty: SetEditProperty::<Identity, OFFSET>,
            EditStart: EditStart::<Identity, OFFSET>,
            SetEditStart: SetEditStart::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMExtTransport as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMExtTransport {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAMExtendedErrorInfo, IAMExtendedErrorInfo_Vtbl, 0xfa2aa8f6_8b62_11d0_a520_000000000000);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAMExtendedErrorInfo {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAMExtendedErrorInfo, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMExtendedErrorInfo {
    pub unsafe fn HasError(&self, phaserror: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).HasError)(windows_core::Interface::as_raw(self), phaserror as _).ok() }
    }
    pub unsafe fn ErrorDescription(&self, pbstrerrordescription: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ErrorDescription)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrerrordescription)).ok() }
    }
    pub unsafe fn ErrorCode(&self, perrorcode: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ErrorCode)(windows_core::Interface::as_raw(self), perrorcode as _).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMExtendedErrorInfo_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub HasError: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub ErrorDescription: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub ErrorCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAMExtendedErrorInfo_Impl: super::super::System::Com::IDispatch_Impl {
    fn HasError(&self, phaserror: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn ErrorDescription(&self, pbstrerrordescription: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn ErrorCode(&self, perrorcode: *mut i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAMExtendedErrorInfo_Vtbl {
    pub const fn new<Identity: IAMExtendedErrorInfo_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn HasError<Identity: IAMExtendedErrorInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, phaserror: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtendedErrorInfo_Impl::HasError(this, core::mem::transmute_copy(&phaserror)).into()
            }
        }
        unsafe extern "system" fn ErrorDescription<Identity: IAMExtendedErrorInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrerrordescription: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtendedErrorInfo_Impl::ErrorDescription(this, core::mem::transmute_copy(&pbstrerrordescription)).into()
            }
        }
        unsafe extern "system" fn ErrorCode<Identity: IAMExtendedErrorInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, perrorcode: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtendedErrorInfo_Impl::ErrorCode(this, core::mem::transmute_copy(&perrorcode)).into()
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            HasError: HasError::<Identity, OFFSET>,
            ErrorDescription: ErrorDescription::<Identity, OFFSET>,
            ErrorCode: ErrorCode::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMExtendedErrorInfo as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAMExtendedErrorInfo {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAMExtendedSeeking, IAMExtendedSeeking_Vtbl, 0xfa2aa8f9_8b62_11d0_a520_000000000000);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAMExtendedSeeking {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAMExtendedSeeking, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMExtendedSeeking {
    pub unsafe fn ExSeekCapabilities(&self, pexcapabilities: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ExSeekCapabilities)(windows_core::Interface::as_raw(self), pexcapabilities as _).ok() }
    }
    pub unsafe fn MarkerCount(&self, pmarkercount: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).MarkerCount)(windows_core::Interface::as_raw(self), pmarkercount as _).ok() }
    }
    pub unsafe fn CurrentMarker(&self, pcurrentmarker: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CurrentMarker)(windows_core::Interface::as_raw(self), pcurrentmarker as _).ok() }
    }
    pub unsafe fn GetMarkerTime(&self, markernum: i32, pmarkertime: *mut f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetMarkerTime)(windows_core::Interface::as_raw(self), markernum, pmarkertime as _).ok() }
    }
    pub unsafe fn GetMarkerName(&self, markernum: i32, pbstrmarkername: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetMarkerName)(windows_core::Interface::as_raw(self), markernum, core::mem::transmute(pbstrmarkername)).ok() }
    }
    pub unsafe fn SetPlaybackSpeed(&self, speed: f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPlaybackSpeed)(windows_core::Interface::as_raw(self), speed).ok() }
    }
    pub unsafe fn PlaybackSpeed(&self, pspeed: *mut f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PlaybackSpeed)(windows_core::Interface::as_raw(self), pspeed as _).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMExtendedSeeking_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ExSeekCapabilities: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub MarkerCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub CurrentMarker: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub GetMarkerTime: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut f64) -> windows_core::HRESULT,
    pub GetMarkerName: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetPlaybackSpeed: unsafe extern "system" fn(*mut core::ffi::c_void, f64) -> windows_core::HRESULT,
    pub PlaybackSpeed: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f64) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAMExtendedSeeking_Impl: super::super::System::Com::IDispatch_Impl {
    fn ExSeekCapabilities(&self, pexcapabilities: *mut i32) -> windows_core::Result<()>;
    fn MarkerCount(&self, pmarkercount: *mut i32) -> windows_core::Result<()>;
    fn CurrentMarker(&self, pcurrentmarker: *mut i32) -> windows_core::Result<()>;
    fn GetMarkerTime(&self, markernum: i32, pmarkertime: *mut f64) -> windows_core::Result<()>;
    fn GetMarkerName(&self, markernum: i32, pbstrmarkername: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn SetPlaybackSpeed(&self, speed: f64) -> windows_core::Result<()>;
    fn PlaybackSpeed(&self, pspeed: *mut f64) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAMExtendedSeeking_Vtbl {
    pub const fn new<Identity: IAMExtendedSeeking_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ExSeekCapabilities<Identity: IAMExtendedSeeking_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pexcapabilities: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtendedSeeking_Impl::ExSeekCapabilities(this, core::mem::transmute_copy(&pexcapabilities)).into()
            }
        }
        unsafe extern "system" fn MarkerCount<Identity: IAMExtendedSeeking_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmarkercount: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtendedSeeking_Impl::MarkerCount(this, core::mem::transmute_copy(&pmarkercount)).into()
            }
        }
        unsafe extern "system" fn CurrentMarker<Identity: IAMExtendedSeeking_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcurrentmarker: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtendedSeeking_Impl::CurrentMarker(this, core::mem::transmute_copy(&pcurrentmarker)).into()
            }
        }
        unsafe extern "system" fn GetMarkerTime<Identity: IAMExtendedSeeking_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, markernum: i32, pmarkertime: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtendedSeeking_Impl::GetMarkerTime(this, core::mem::transmute_copy(&markernum), core::mem::transmute_copy(&pmarkertime)).into()
            }
        }
        unsafe extern "system" fn GetMarkerName<Identity: IAMExtendedSeeking_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, markernum: i32, pbstrmarkername: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtendedSeeking_Impl::GetMarkerName(this, core::mem::transmute_copy(&markernum), core::mem::transmute_copy(&pbstrmarkername)).into()
            }
        }
        unsafe extern "system" fn SetPlaybackSpeed<Identity: IAMExtendedSeeking_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, speed: f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtendedSeeking_Impl::SetPlaybackSpeed(this, core::mem::transmute_copy(&speed)).into()
            }
        }
        unsafe extern "system" fn PlaybackSpeed<Identity: IAMExtendedSeeking_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pspeed: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMExtendedSeeking_Impl::PlaybackSpeed(this, core::mem::transmute_copy(&pspeed)).into()
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            ExSeekCapabilities: ExSeekCapabilities::<Identity, OFFSET>,
            MarkerCount: MarkerCount::<Identity, OFFSET>,
            CurrentMarker: CurrentMarker::<Identity, OFFSET>,
            GetMarkerTime: GetMarkerTime::<Identity, OFFSET>,
            GetMarkerName: GetMarkerName::<Identity, OFFSET>,
            SetPlaybackSpeed: SetPlaybackSpeed::<Identity, OFFSET>,
            PlaybackSpeed: PlaybackSpeed::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMExtendedSeeking as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAMExtendedSeeking {}
windows_core::imp::define_interface!(IAMFilterGraphCallback, IAMFilterGraphCallback_Vtbl, 0x56a868fd_0ad4_11ce_b0a3_0020af0ba770);
windows_core::imp::interface_hierarchy!(IAMFilterGraphCallback, windows_core::IUnknown);
impl IAMFilterGraphCallback {
    pub unsafe fn UnableToRender<P0>(&self, ppin: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IPin>,
    {
        unsafe { (windows_core::Interface::vtable(self).UnableToRender)(windows_core::Interface::as_raw(self), ppin.param().abi()).ok() }
    }
}
#[repr(C)]
pub struct IAMFilterGraphCallback_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub UnableToRender: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAMFilterGraphCallback_Impl: windows_core::IUnknownImpl {
    fn UnableToRender(&self, ppin: windows_core::Ref<'_, IPin>) -> windows_core::Result<()>;
}
impl IAMFilterGraphCallback_Vtbl {
    pub const fn new<Identity: IAMFilterGraphCallback_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn UnableToRender<Identity: IAMFilterGraphCallback_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppin: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMFilterGraphCallback_Impl::UnableToRender(this, core::mem::transmute_copy(&ppin)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), UnableToRender: UnableToRender::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMFilterGraphCallback as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMFilterGraphCallback {}
windows_core::imp::define_interface!(IAMFilterMiscFlags, IAMFilterMiscFlags_Vtbl, 0x2dd74950_a890_11d1_abe8_00a0c905f375);
windows_core::imp::interface_hierarchy!(IAMFilterMiscFlags, windows_core::IUnknown);
impl IAMFilterMiscFlags {
    pub unsafe fn GetMiscFlags(&self) -> u32 {
        unsafe { (windows_core::Interface::vtable(self).GetMiscFlags)(windows_core::Interface::as_raw(self)) }
    }
}
#[repr(C)]
pub struct IAMFilterMiscFlags_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetMiscFlags: unsafe extern "system" fn(*mut core::ffi::c_void) -> u32,
}
pub trait IAMFilterMiscFlags_Impl: windows_core::IUnknownImpl {
    fn GetMiscFlags(&self) -> u32;
}
impl IAMFilterMiscFlags_Vtbl {
    pub const fn new<Identity: IAMFilterMiscFlags_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetMiscFlags<Identity: IAMFilterMiscFlags_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> u32 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMFilterMiscFlags_Impl::GetMiscFlags(this)
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), GetMiscFlags: GetMiscFlags::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMFilterMiscFlags as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMFilterMiscFlags {}
windows_core::imp::define_interface!(IAMGraphBuilderCallback, IAMGraphBuilderCallback_Vtbl, 0x4995f511_9ddb_4f12_bd3b_f04611807b79);
windows_core::imp::interface_hierarchy!(IAMGraphBuilderCallback, windows_core::IUnknown);
impl IAMGraphBuilderCallback {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SelectedFilter<P0>(&self, pmon: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IMoniker>,
    {
        unsafe { (windows_core::Interface::vtable(self).SelectedFilter)(windows_core::Interface::as_raw(self), pmon.param().abi()).ok() }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreatedFilter<P0>(&self, pfil: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IBaseFilter>,
    {
        unsafe { (windows_core::Interface::vtable(self).CreatedFilter)(windows_core::Interface::as_raw(self), pfil.param().abi()).ok() }
    }
}
#[repr(C)]
pub struct IAMGraphBuilderCallback_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub SelectedFilter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SelectedFilter: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CreatedFilter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreatedFilter: usize,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IAMGraphBuilderCallback_Impl: windows_core::IUnknownImpl {
    fn SelectedFilter(&self, pmon: windows_core::Ref<'_, super::super::System::Com::IMoniker>) -> windows_core::Result<()>;
    fn CreatedFilter(&self, pfil: windows_core::Ref<'_, IBaseFilter>) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_System_Com")]
impl IAMGraphBuilderCallback_Vtbl {
    pub const fn new<Identity: IAMGraphBuilderCallback_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SelectedFilter<Identity: IAMGraphBuilderCallback_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmon: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMGraphBuilderCallback_Impl::SelectedFilter(this, core::mem::transmute_copy(&pmon)).into()
            }
        }
        unsafe extern "system" fn CreatedFilter<Identity: IAMGraphBuilderCallback_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfil: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMGraphBuilderCallback_Impl::CreatedFilter(this, core::mem::transmute_copy(&pfil)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SelectedFilter: SelectedFilter::<Identity, OFFSET>,
            CreatedFilter: CreatedFilter::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMGraphBuilderCallback as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IAMGraphBuilderCallback {}
windows_core::imp::define_interface!(IAMGraphStreams, IAMGraphStreams_Vtbl, 0x632105fa_072e_11d3_8af9_00c04fb6bd3d);
windows_core::imp::interface_hierarchy!(IAMGraphStreams, windows_core::IUnknown);
impl IAMGraphStreams {
    pub unsafe fn FindUpstreamInterface<P0>(&self, ppin: P0, riid: *const windows_core::GUID, ppvinterface: *mut *mut core::ffi::c_void, dwflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IPin>,
    {
        unsafe { (windows_core::Interface::vtable(self).FindUpstreamInterface)(windows_core::Interface::as_raw(self), ppin.param().abi(), riid, ppvinterface as _, dwflags).ok() }
    }
    pub unsafe fn SyncUsingStreamOffset(&self, busestreamoffset: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SyncUsingStreamOffset)(windows_core::Interface::as_raw(self), busestreamoffset.into()).ok() }
    }
    pub unsafe fn SetMaxGraphLatency(&self, rtmaxgraphlatency: i64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMaxGraphLatency)(windows_core::Interface::as_raw(self), rtmaxgraphlatency).ok() }
    }
}
#[repr(C)]
pub struct IAMGraphStreams_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub FindUpstreamInterface: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const windows_core::GUID, *mut *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SyncUsingStreamOffset: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub SetMaxGraphLatency: unsafe extern "system" fn(*mut core::ffi::c_void, i64) -> windows_core::HRESULT,
}
pub trait IAMGraphStreams_Impl: windows_core::IUnknownImpl {
    fn FindUpstreamInterface(&self, ppin: windows_core::Ref<'_, IPin>, riid: *const windows_core::GUID, ppvinterface: *mut *mut core::ffi::c_void, dwflags: u32) -> windows_core::Result<()>;
    fn SyncUsingStreamOffset(&self, busestreamoffset: windows_core::BOOL) -> windows_core::Result<()>;
    fn SetMaxGraphLatency(&self, rtmaxgraphlatency: i64) -> windows_core::Result<()>;
}
impl IAMGraphStreams_Vtbl {
    pub const fn new<Identity: IAMGraphStreams_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn FindUpstreamInterface<Identity: IAMGraphStreams_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppin: *mut core::ffi::c_void, riid: *const windows_core::GUID, ppvinterface: *mut *mut core::ffi::c_void, dwflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMGraphStreams_Impl::FindUpstreamInterface(this, core::mem::transmute_copy(&ppin), core::mem::transmute_copy(&riid), core::mem::transmute_copy(&ppvinterface), core::mem::transmute_copy(&dwflags)).into()
            }
        }
        unsafe extern "system" fn SyncUsingStreamOffset<Identity: IAMGraphStreams_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, busestreamoffset: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMGraphStreams_Impl::SyncUsingStreamOffset(this, core::mem::transmute_copy(&busestreamoffset)).into()
            }
        }
        unsafe extern "system" fn SetMaxGraphLatency<Identity: IAMGraphStreams_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, rtmaxgraphlatency: i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMGraphStreams_Impl::SetMaxGraphLatency(this, core::mem::transmute_copy(&rtmaxgraphlatency)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            FindUpstreamInterface: FindUpstreamInterface::<Identity, OFFSET>,
            SyncUsingStreamOffset: SyncUsingStreamOffset::<Identity, OFFSET>,
            SetMaxGraphLatency: SetMaxGraphLatency::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMGraphStreams as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMGraphStreams {}
windows_core::imp::define_interface!(IAMLatency, IAMLatency_Vtbl, 0x62ea93ba_ec62_11d2_b770_00c04fb6bd3d);
windows_core::imp::interface_hierarchy!(IAMLatency, windows_core::IUnknown);
impl IAMLatency {
    pub unsafe fn GetLatency(&self) -> windows_core::Result<i64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLatency)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAMLatency_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetLatency: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i64) -> windows_core::HRESULT,
}
pub trait IAMLatency_Impl: windows_core::IUnknownImpl {
    fn GetLatency(&self) -> windows_core::Result<i64>;
}
impl IAMLatency_Vtbl {
    pub const fn new<Identity: IAMLatency_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetLatency<Identity: IAMLatency_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prtlatency: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMLatency_Impl::GetLatency(this) {
                    Ok(ok__) => {
                        prtlatency.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), GetLatency: GetLatency::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMLatency as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMLatency {}
windows_core::imp::define_interface!(IAMLine21Decoder, IAMLine21Decoder_Vtbl, 0x6e8d4a21_310c_11d0_b79a_00aa003767a7);
windows_core::imp::interface_hierarchy!(IAMLine21Decoder, windows_core::IUnknown);
impl IAMLine21Decoder {
    pub unsafe fn GetDecoderLevel(&self, lplevel: *mut AM_LINE21_CCLEVEL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDecoderLevel)(windows_core::Interface::as_raw(self), lplevel as _).ok() }
    }
    pub unsafe fn GetCurrentService(&self, lpservice: *mut AM_LINE21_CCSERVICE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCurrentService)(windows_core::Interface::as_raw(self), lpservice as _).ok() }
    }
    pub unsafe fn SetCurrentService(&self, service: AM_LINE21_CCSERVICE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCurrentService)(windows_core::Interface::as_raw(self), service).ok() }
    }
    pub unsafe fn GetServiceState(&self, lpstate: *mut AM_LINE21_CCSTATE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetServiceState)(windows_core::Interface::as_raw(self), lpstate as _).ok() }
    }
    pub unsafe fn SetServiceState(&self, state: AM_LINE21_CCSTATE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetServiceState)(windows_core::Interface::as_raw(self), state).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetOutputFormat(&self, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOutputFormat)(windows_core::Interface::as_raw(self), lpbmih as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetOutputFormat(&self, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputFormat)(windows_core::Interface::as_raw(self), lpbmi as _).ok() }
    }
    pub unsafe fn GetBackgroundColor(&self, pdwphyscolor: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetBackgroundColor)(windows_core::Interface::as_raw(self), pdwphyscolor as _).ok() }
    }
    pub unsafe fn SetBackgroundColor(&self, dwphyscolor: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetBackgroundColor)(windows_core::Interface::as_raw(self), dwphyscolor).ok() }
    }
    pub unsafe fn GetRedrawAlways(&self, lpboption: *mut windows_core::BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRedrawAlways)(windows_core::Interface::as_raw(self), lpboption as _).ok() }
    }
    pub unsafe fn SetRedrawAlways(&self, boption: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetRedrawAlways)(windows_core::Interface::as_raw(self), boption.into()).ok() }
    }
    pub unsafe fn GetDrawBackgroundMode(&self, lpmode: *mut AM_LINE21_DRAWBGMODE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDrawBackgroundMode)(windows_core::Interface::as_raw(self), lpmode as _).ok() }
    }
    pub unsafe fn SetDrawBackgroundMode(&self, mode: AM_LINE21_DRAWBGMODE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDrawBackgroundMode)(windows_core::Interface::as_raw(self), mode).ok() }
    }
}
#[repr(C)]
pub struct IAMLine21Decoder_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDecoderLevel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut AM_LINE21_CCLEVEL) -> windows_core::HRESULT,
    pub GetCurrentService: unsafe extern "system" fn(*mut core::ffi::c_void, *mut AM_LINE21_CCSERVICE) -> windows_core::HRESULT,
    pub SetCurrentService: unsafe extern "system" fn(*mut core::ffi::c_void, AM_LINE21_CCSERVICE) -> windows_core::HRESULT,
    pub GetServiceState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut AM_LINE21_CCSTATE) -> windows_core::HRESULT,
    pub SetServiceState: unsafe extern "system" fn(*mut core::ffi::c_void, AM_LINE21_CCSTATE) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetOutputFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetOutputFormat: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetOutputFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::Gdi::BITMAPINFO) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetOutputFormat: usize,
    pub GetBackgroundColor: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetBackgroundColor: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetRedrawAlways: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub SetRedrawAlways: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub GetDrawBackgroundMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut AM_LINE21_DRAWBGMODE) -> windows_core::HRESULT,
    pub SetDrawBackgroundMode: unsafe extern "system" fn(*mut core::ffi::c_void, AM_LINE21_DRAWBGMODE) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub trait IAMLine21Decoder_Impl: windows_core::IUnknownImpl {
    fn GetDecoderLevel(&self, lplevel: *mut AM_LINE21_CCLEVEL) -> windows_core::Result<()>;
    fn GetCurrentService(&self, lpservice: *mut AM_LINE21_CCSERVICE) -> windows_core::Result<()>;
    fn SetCurrentService(&self, service: AM_LINE21_CCSERVICE) -> windows_core::Result<()>;
    fn GetServiceState(&self, lpstate: *mut AM_LINE21_CCSTATE) -> windows_core::Result<()>;
    fn SetServiceState(&self, state: AM_LINE21_CCSTATE) -> windows_core::Result<()>;
    fn GetOutputFormat(&self, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> windows_core::Result<()>;
    fn SetOutputFormat(&self, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> windows_core::Result<()>;
    fn GetBackgroundColor(&self, pdwphyscolor: *mut u32) -> windows_core::Result<()>;
    fn SetBackgroundColor(&self, dwphyscolor: u32) -> windows_core::Result<()>;
    fn GetRedrawAlways(&self, lpboption: *mut windows_core::BOOL) -> windows_core::Result<()>;
    fn SetRedrawAlways(&self, boption: windows_core::BOOL) -> windows_core::Result<()>;
    fn GetDrawBackgroundMode(&self, lpmode: *mut AM_LINE21_DRAWBGMODE) -> windows_core::Result<()>;
    fn SetDrawBackgroundMode(&self, mode: AM_LINE21_DRAWBGMODE) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl IAMLine21Decoder_Vtbl {
    pub const fn new<Identity: IAMLine21Decoder_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDecoderLevel<Identity: IAMLine21Decoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lplevel: *mut AM_LINE21_CCLEVEL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMLine21Decoder_Impl::GetDecoderLevel(this, core::mem::transmute_copy(&lplevel)).into()
            }
        }
        unsafe extern "system" fn GetCurrentService<Identity: IAMLine21Decoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpservice: *mut AM_LINE21_CCSERVICE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMLine21Decoder_Impl::GetCurrentService(this, core::mem::transmute_copy(&lpservice)).into()
            }
        }
        unsafe extern "system" fn SetCurrentService<Identity: IAMLine21Decoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, service: AM_LINE21_CCSERVICE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMLine21Decoder_Impl::SetCurrentService(this, core::mem::transmute_copy(&service)).into()
            }
        }
        unsafe extern "system" fn GetServiceState<Identity: IAMLine21Decoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpstate: *mut AM_LINE21_CCSTATE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMLine21Decoder_Impl::GetServiceState(this, core::mem::transmute_copy(&lpstate)).into()
            }
        }
        unsafe extern "system" fn SetServiceState<Identity: IAMLine21Decoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, state: AM_LINE21_CCSTATE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMLine21Decoder_Impl::SetServiceState(this, core::mem::transmute_copy(&state)).into()
            }
        }
        unsafe extern "system" fn GetOutputFormat<Identity: IAMLine21Decoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMLine21Decoder_Impl::GetOutputFormat(this, core::mem::transmute_copy(&lpbmih)).into()
            }
        }
        unsafe extern "system" fn SetOutputFormat<Identity: IAMLine21Decoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMLine21Decoder_Impl::SetOutputFormat(this, core::mem::transmute_copy(&lpbmi)).into()
            }
        }
        unsafe extern "system" fn GetBackgroundColor<Identity: IAMLine21Decoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwphyscolor: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMLine21Decoder_Impl::GetBackgroundColor(this, core::mem::transmute_copy(&pdwphyscolor)).into()
            }
        }
        unsafe extern "system" fn SetBackgroundColor<Identity: IAMLine21Decoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwphyscolor: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMLine21Decoder_Impl::SetBackgroundColor(this, core::mem::transmute_copy(&dwphyscolor)).into()
            }
        }
        unsafe extern "system" fn GetRedrawAlways<Identity: IAMLine21Decoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpboption: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMLine21Decoder_Impl::GetRedrawAlways(this, core::mem::transmute_copy(&lpboption)).into()
            }
        }
        unsafe extern "system" fn SetRedrawAlways<Identity: IAMLine21Decoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, boption: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMLine21Decoder_Impl::SetRedrawAlways(this, core::mem::transmute_copy(&boption)).into()
            }
        }
        unsafe extern "system" fn GetDrawBackgroundMode<Identity: IAMLine21Decoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpmode: *mut AM_LINE21_DRAWBGMODE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMLine21Decoder_Impl::GetDrawBackgroundMode(this, core::mem::transmute_copy(&lpmode)).into()
            }
        }
        unsafe extern "system" fn SetDrawBackgroundMode<Identity: IAMLine21Decoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mode: AM_LINE21_DRAWBGMODE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMLine21Decoder_Impl::SetDrawBackgroundMode(this, core::mem::transmute_copy(&mode)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetDecoderLevel: GetDecoderLevel::<Identity, OFFSET>,
            GetCurrentService: GetCurrentService::<Identity, OFFSET>,
            SetCurrentService: SetCurrentService::<Identity, OFFSET>,
            GetServiceState: GetServiceState::<Identity, OFFSET>,
            SetServiceState: SetServiceState::<Identity, OFFSET>,
            GetOutputFormat: GetOutputFormat::<Identity, OFFSET>,
            SetOutputFormat: SetOutputFormat::<Identity, OFFSET>,
            GetBackgroundColor: GetBackgroundColor::<Identity, OFFSET>,
            SetBackgroundColor: SetBackgroundColor::<Identity, OFFSET>,
            GetRedrawAlways: GetRedrawAlways::<Identity, OFFSET>,
            SetRedrawAlways: SetRedrawAlways::<Identity, OFFSET>,
            GetDrawBackgroundMode: GetDrawBackgroundMode::<Identity, OFFSET>,
            SetDrawBackgroundMode: SetDrawBackgroundMode::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMLine21Decoder as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl windows_core::RuntimeName for IAMLine21Decoder {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAMMediaContent, IAMMediaContent_Vtbl, 0xfa2aa8f4_8b62_11d0_a520_000000000000);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAMMediaContent {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAMMediaContent, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMMediaContent {
    pub unsafe fn AuthorName(&self, pbstrauthorname: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AuthorName)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrauthorname)).ok() }
    }
    pub unsafe fn Title(&self, pbstrtitle: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Title)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrtitle)).ok() }
    }
    pub unsafe fn Rating(&self, pbstrrating: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Rating)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrrating)).ok() }
    }
    pub unsafe fn Description(&self, pbstrdescription: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Description)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrdescription)).ok() }
    }
    pub unsafe fn Copyright(&self, pbstrcopyright: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Copyright)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrcopyright)).ok() }
    }
    pub unsafe fn BaseURL(&self, pbstrbaseurl: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).BaseURL)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrbaseurl)).ok() }
    }
    pub unsafe fn LogoURL(&self, pbstrlogourl: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).LogoURL)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrlogourl)).ok() }
    }
    pub unsafe fn LogoIconURL(&self, pbstrlogourl: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).LogoIconURL)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrlogourl)).ok() }
    }
    pub unsafe fn WatermarkURL(&self, pbstrwatermarkurl: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).WatermarkURL)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrwatermarkurl)).ok() }
    }
    pub unsafe fn MoreInfoURL(&self, pbstrmoreinfourl: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).MoreInfoURL)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrmoreinfourl)).ok() }
    }
    pub unsafe fn MoreInfoBannerImage(&self, pbstrmoreinfobannerimage: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).MoreInfoBannerImage)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrmoreinfobannerimage)).ok() }
    }
    pub unsafe fn MoreInfoBannerURL(&self, pbstrmoreinfobannerurl: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).MoreInfoBannerURL)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrmoreinfobannerurl)).ok() }
    }
    pub unsafe fn MoreInfoText(&self, pbstrmoreinfotext: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).MoreInfoText)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrmoreinfotext)).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMMediaContent_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub AuthorName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Title: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Rating: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Description: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Copyright: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub BaseURL: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub LogoURL: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub LogoIconURL: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub WatermarkURL: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub MoreInfoURL: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub MoreInfoBannerImage: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub MoreInfoBannerURL: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub MoreInfoText: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAMMediaContent_Impl: super::super::System::Com::IDispatch_Impl {
    fn AuthorName(&self, pbstrauthorname: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn Title(&self, pbstrtitle: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn Rating(&self, pbstrrating: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn Description(&self, pbstrdescription: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn Copyright(&self, pbstrcopyright: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn BaseURL(&self, pbstrbaseurl: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn LogoURL(&self, pbstrlogourl: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn LogoIconURL(&self, pbstrlogourl: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn WatermarkURL(&self, pbstrwatermarkurl: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn MoreInfoURL(&self, pbstrmoreinfourl: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn MoreInfoBannerImage(&self, pbstrmoreinfobannerimage: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn MoreInfoBannerURL(&self, pbstrmoreinfobannerurl: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn MoreInfoText(&self, pbstrmoreinfotext: *mut windows_core::BSTR) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAMMediaContent_Vtbl {
    pub const fn new<Identity: IAMMediaContent_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AuthorName<Identity: IAMMediaContent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrauthorname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent_Impl::AuthorName(this, core::mem::transmute_copy(&pbstrauthorname)).into()
            }
        }
        unsafe extern "system" fn Title<Identity: IAMMediaContent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrtitle: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent_Impl::Title(this, core::mem::transmute_copy(&pbstrtitle)).into()
            }
        }
        unsafe extern "system" fn Rating<Identity: IAMMediaContent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrrating: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent_Impl::Rating(this, core::mem::transmute_copy(&pbstrrating)).into()
            }
        }
        unsafe extern "system" fn Description<Identity: IAMMediaContent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrdescription: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent_Impl::Description(this, core::mem::transmute_copy(&pbstrdescription)).into()
            }
        }
        unsafe extern "system" fn Copyright<Identity: IAMMediaContent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrcopyright: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent_Impl::Copyright(this, core::mem::transmute_copy(&pbstrcopyright)).into()
            }
        }
        unsafe extern "system" fn BaseURL<Identity: IAMMediaContent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrbaseurl: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent_Impl::BaseURL(this, core::mem::transmute_copy(&pbstrbaseurl)).into()
            }
        }
        unsafe extern "system" fn LogoURL<Identity: IAMMediaContent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrlogourl: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent_Impl::LogoURL(this, core::mem::transmute_copy(&pbstrlogourl)).into()
            }
        }
        unsafe extern "system" fn LogoIconURL<Identity: IAMMediaContent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrlogourl: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent_Impl::LogoIconURL(this, core::mem::transmute_copy(&pbstrlogourl)).into()
            }
        }
        unsafe extern "system" fn WatermarkURL<Identity: IAMMediaContent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrwatermarkurl: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent_Impl::WatermarkURL(this, core::mem::transmute_copy(&pbstrwatermarkurl)).into()
            }
        }
        unsafe extern "system" fn MoreInfoURL<Identity: IAMMediaContent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrmoreinfourl: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent_Impl::MoreInfoURL(this, core::mem::transmute_copy(&pbstrmoreinfourl)).into()
            }
        }
        unsafe extern "system" fn MoreInfoBannerImage<Identity: IAMMediaContent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrmoreinfobannerimage: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent_Impl::MoreInfoBannerImage(this, core::mem::transmute_copy(&pbstrmoreinfobannerimage)).into()
            }
        }
        unsafe extern "system" fn MoreInfoBannerURL<Identity: IAMMediaContent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrmoreinfobannerurl: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent_Impl::MoreInfoBannerURL(this, core::mem::transmute_copy(&pbstrmoreinfobannerurl)).into()
            }
        }
        unsafe extern "system" fn MoreInfoText<Identity: IAMMediaContent_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrmoreinfotext: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent_Impl::MoreInfoText(this, core::mem::transmute_copy(&pbstrmoreinfotext)).into()
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            AuthorName: AuthorName::<Identity, OFFSET>,
            Title: Title::<Identity, OFFSET>,
            Rating: Rating::<Identity, OFFSET>,
            Description: Description::<Identity, OFFSET>,
            Copyright: Copyright::<Identity, OFFSET>,
            BaseURL: BaseURL::<Identity, OFFSET>,
            LogoURL: LogoURL::<Identity, OFFSET>,
            LogoIconURL: LogoIconURL::<Identity, OFFSET>,
            WatermarkURL: WatermarkURL::<Identity, OFFSET>,
            MoreInfoURL: MoreInfoURL::<Identity, OFFSET>,
            MoreInfoBannerImage: MoreInfoBannerImage::<Identity, OFFSET>,
            MoreInfoBannerURL: MoreInfoBannerURL::<Identity, OFFSET>,
            MoreInfoText: MoreInfoText::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMMediaContent as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAMMediaContent {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAMMediaContent2, IAMMediaContent2_Vtbl, 0xce8f78c1_74d9_11d2_b09d_00a0c9a81117);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAMMediaContent2 {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAMMediaContent2, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMMediaContent2 {
    pub unsafe fn get_MediaParameter(&self, entrynum: i32, bstrname: &windows_core::BSTR, pbstrvalue: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_MediaParameter)(windows_core::Interface::as_raw(self), entrynum, core::mem::transmute_copy(bstrname), core::mem::transmute(pbstrvalue)).ok() }
    }
    pub unsafe fn get_MediaParameterName(&self, entrynum: i32, index: i32, pbstrname: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_MediaParameterName)(windows_core::Interface::as_raw(self), entrynum, index, core::mem::transmute(pbstrname)).ok() }
    }
    pub unsafe fn PlaylistCount(&self, pnumberentries: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PlaylistCount)(windows_core::Interface::as_raw(self), pnumberentries as _).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMMediaContent2_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub get_MediaParameter: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub get_MediaParameterName: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub PlaylistCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAMMediaContent2_Impl: super::super::System::Com::IDispatch_Impl {
    fn get_MediaParameter(&self, entrynum: i32, bstrname: &windows_core::BSTR, pbstrvalue: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn get_MediaParameterName(&self, entrynum: i32, index: i32, pbstrname: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn PlaylistCount(&self, pnumberentries: *mut i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAMMediaContent2_Vtbl {
    pub const fn new<Identity: IAMMediaContent2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn get_MediaParameter<Identity: IAMMediaContent2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, entrynum: i32, bstrname: *mut core::ffi::c_void, pbstrvalue: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent2_Impl::get_MediaParameter(this, core::mem::transmute_copy(&entrynum), core::mem::transmute(&bstrname), core::mem::transmute_copy(&pbstrvalue)).into()
            }
        }
        unsafe extern "system" fn get_MediaParameterName<Identity: IAMMediaContent2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, entrynum: i32, index: i32, pbstrname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent2_Impl::get_MediaParameterName(this, core::mem::transmute_copy(&entrynum), core::mem::transmute_copy(&index), core::mem::transmute_copy(&pbstrname)).into()
            }
        }
        unsafe extern "system" fn PlaylistCount<Identity: IAMMediaContent2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pnumberentries: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaContent2_Impl::PlaylistCount(this, core::mem::transmute_copy(&pnumberentries)).into()
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            get_MediaParameter: get_MediaParameter::<Identity, OFFSET>,
            get_MediaParameterName: get_MediaParameterName::<Identity, OFFSET>,
            PlaylistCount: PlaylistCount::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMMediaContent2 as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAMMediaContent2 {}
windows_core::imp::define_interface!(IAMMediaStream, IAMMediaStream_Vtbl, 0xbebe595d_9a6f_11d0_8fde_00c04fd9189d);
impl core::ops::Deref for IAMMediaStream {
    type Target = IMediaStream;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAMMediaStream, windows_core::IUnknown, IMediaStream);
impl IAMMediaStream {
    pub unsafe fn Initialize<P0>(&self, psourceobject: P0, dwflags: u32, purposeid: *const windows_core::GUID, streamtype: STREAM_TYPE) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), psourceobject.param().abi(), dwflags, purposeid, streamtype).ok() }
    }
    pub unsafe fn SetState(&self, state: FILTER_STATE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetState)(windows_core::Interface::as_raw(self), state).ok() }
    }
    pub unsafe fn JoinAMMultiMediaStream<P0>(&self, pammultimediastream: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IAMMultiMediaStream>,
    {
        unsafe { (windows_core::Interface::vtable(self).JoinAMMultiMediaStream)(windows_core::Interface::as_raw(self), pammultimediastream.param().abi()).ok() }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn JoinFilter<P0>(&self, pmediastreamfilter: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IMediaStreamFilter>,
    {
        unsafe { (windows_core::Interface::vtable(self).JoinFilter)(windows_core::Interface::as_raw(self), pmediastreamfilter.param().abi()).ok() }
    }
    pub unsafe fn JoinFilterGraph<P0>(&self, pfiltergraph: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IFilterGraph>,
    {
        unsafe { (windows_core::Interface::vtable(self).JoinFilterGraph)(windows_core::Interface::as_raw(self), pfiltergraph.param().abi()).ok() }
    }
}
#[repr(C)]
pub struct IAMMediaStream_Vtbl {
    pub base__: IMediaStream_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, *const windows_core::GUID, STREAM_TYPE) -> windows_core::HRESULT,
    pub SetState: unsafe extern "system" fn(*mut core::ffi::c_void, FILTER_STATE) -> windows_core::HRESULT,
    pub JoinAMMultiMediaStream: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub JoinFilter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    JoinFilter: usize,
    pub JoinFilterGraph: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IAMMediaStream_Impl: IMediaStream_Impl {
    fn Initialize(&self, psourceobject: windows_core::Ref<'_, windows_core::IUnknown>, dwflags: u32, purposeid: *const windows_core::GUID, streamtype: STREAM_TYPE) -> windows_core::Result<()>;
    fn SetState(&self, state: FILTER_STATE) -> windows_core::Result<()>;
    fn JoinAMMultiMediaStream(&self, pammultimediastream: windows_core::Ref<'_, IAMMultiMediaStream>) -> windows_core::Result<()>;
    fn JoinFilter(&self, pmediastreamfilter: windows_core::Ref<'_, IMediaStreamFilter>) -> windows_core::Result<()>;
    fn JoinFilterGraph(&self, pfiltergraph: windows_core::Ref<'_, IFilterGraph>) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_System_Com")]
impl IAMMediaStream_Vtbl {
    pub const fn new<Identity: IAMMediaStream_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IAMMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psourceobject: *mut core::ffi::c_void, dwflags: u32, purposeid: *const windows_core::GUID, streamtype: STREAM_TYPE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaStream_Impl::Initialize(this, core::mem::transmute_copy(&psourceobject), core::mem::transmute_copy(&dwflags), core::mem::transmute_copy(&purposeid), core::mem::transmute_copy(&streamtype)).into()
            }
        }
        unsafe extern "system" fn SetState<Identity: IAMMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, state: FILTER_STATE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaStream_Impl::SetState(this, core::mem::transmute_copy(&state)).into()
            }
        }
        unsafe extern "system" fn JoinAMMultiMediaStream<Identity: IAMMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pammultimediastream: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaStream_Impl::JoinAMMultiMediaStream(this, core::mem::transmute_copy(&pammultimediastream)).into()
            }
        }
        unsafe extern "system" fn JoinFilter<Identity: IAMMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmediastreamfilter: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaStream_Impl::JoinFilter(this, core::mem::transmute_copy(&pmediastreamfilter)).into()
            }
        }
        unsafe extern "system" fn JoinFilterGraph<Identity: IAMMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfiltergraph: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaStream_Impl::JoinFilterGraph(this, core::mem::transmute_copy(&pfiltergraph)).into()
            }
        }
        Self {
            base__: IMediaStream_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            SetState: SetState::<Identity, OFFSET>,
            JoinAMMultiMediaStream: JoinAMMultiMediaStream::<Identity, OFFSET>,
            JoinFilter: JoinFilter::<Identity, OFFSET>,
            JoinFilterGraph: JoinFilterGraph::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMMediaStream as windows_core::Interface>::IID || iid == &<IMediaStream as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IAMMediaStream {}
windows_core::imp::define_interface!(IAMMediaTypeSample, IAMMediaTypeSample_Vtbl, 0xab6b4afb_f6e4_11d0_900d_00c04fd9189d);
impl core::ops::Deref for IAMMediaTypeSample {
    type Target = IStreamSample;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAMMediaTypeSample, windows_core::IUnknown, IStreamSample);
impl IAMMediaTypeSample {
    pub unsafe fn SetPointer(&self, pbuffer: &[u8]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPointer)(windows_core::Interface::as_raw(self), core::mem::transmute(pbuffer.as_ptr()), pbuffer.len().try_into().unwrap()).ok() }
    }
    pub unsafe fn GetPointer(&self) -> windows_core::Result<*mut u8> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPointer)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetSize(&self) -> i32 {
        unsafe { (windows_core::Interface::vtable(self).GetSize)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn GetTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTime)(windows_core::Interface::as_raw(self), ptimestart as _, ptimeend as _).ok() }
    }
    pub unsafe fn SetTime(&self, ptimestart: *const i64, ptimeend: *const i64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTime)(windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok() }
    }
    pub unsafe fn IsSyncPoint(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IsSyncPoint)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn SetSyncPoint(&self, bissyncpoint: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSyncPoint)(windows_core::Interface::as_raw(self), bissyncpoint.into()).ok() }
    }
    pub unsafe fn IsPreroll(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IsPreroll)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn SetPreroll(&self, bispreroll: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPreroll)(windows_core::Interface::as_raw(self), bispreroll.into()).ok() }
    }
    pub unsafe fn GetActualDataLength(&self) -> i32 {
        unsafe { (windows_core::Interface::vtable(self).GetActualDataLength)(windows_core::Interface::as_raw(self)) }
    }
    pub unsafe fn SetActualDataLength(&self, __midl__iammediatypesample0000: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetActualDataLength)(windows_core::Interface::as_raw(self), __midl__iammediatypesample0000).ok() }
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn GetMediaType(&self) -> windows_core::Result<*mut super::MediaFoundation::AM_MEDIA_TYPE> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetMediaType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetMediaType(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMediaType)(windows_core::Interface::as_raw(self), core::mem::transmute(pmediatype)).ok() }
    }
    pub unsafe fn IsDiscontinuity(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IsDiscontinuity)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn SetDiscontinuity(&self, bdiscontinuity: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDiscontinuity)(windows_core::Interface::as_raw(self), bdiscontinuity.into()).ok() }
    }
    pub unsafe fn GetMediaTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetMediaTime)(windows_core::Interface::as_raw(self), ptimestart as _, ptimeend as _).ok() }
    }
    pub unsafe fn SetMediaTime(&self, ptimestart: *const i64, ptimeend: *const i64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMediaTime)(windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok() }
    }
}
#[repr(C)]
pub struct IAMMediaTypeSample_Vtbl {
    pub base__: IStreamSample_Vtbl,
    pub SetPointer: unsafe extern "system" fn(*mut core::ffi::c_void, *const u8, i32) -> windows_core::HRESULT,
    pub GetPointer: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut u8) -> windows_core::HRESULT,
    pub GetSize: unsafe extern "system" fn(*mut core::ffi::c_void) -> i32,
    pub GetTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i64, *mut i64) -> windows_core::HRESULT,
    pub SetTime: unsafe extern "system" fn(*mut core::ffi::c_void, *const i64, *const i64) -> windows_core::HRESULT,
    pub IsSyncPoint: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetSyncPoint: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub IsPreroll: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetPreroll: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub GetActualDataLength: unsafe extern "system" fn(*mut core::ffi::c_void) -> i32,
    pub SetActualDataLength: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub GetMediaType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    GetMediaType: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub SetMediaType: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    SetMediaType: usize,
    pub IsDiscontinuity: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetDiscontinuity: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub GetMediaTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i64, *mut i64) -> windows_core::HRESULT,
    pub SetMediaTime: unsafe extern "system" fn(*mut core::ffi::c_void, *const i64, *const i64) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
pub trait IAMMediaTypeSample_Impl: IStreamSample_Impl {
    fn SetPointer(&self, pbuffer: *const u8, lsize: i32) -> windows_core::Result<()>;
    fn GetPointer(&self) -> windows_core::Result<*mut u8>;
    fn GetSize(&self) -> i32;
    fn GetTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> windows_core::Result<()>;
    fn SetTime(&self, ptimestart: *const i64, ptimeend: *const i64) -> windows_core::Result<()>;
    fn IsSyncPoint(&self) -> windows_core::Result<()>;
    fn SetSyncPoint(&self, bissyncpoint: windows_core::BOOL) -> windows_core::Result<()>;
    fn IsPreroll(&self) -> windows_core::Result<()>;
    fn SetPreroll(&self, bispreroll: windows_core::BOOL) -> windows_core::Result<()>;
    fn GetActualDataLength(&self) -> i32;
    fn SetActualDataLength(&self, __midl__iammediatypesample0000: i32) -> windows_core::Result<()>;
    fn GetMediaType(&self) -> windows_core::Result<*mut super::MediaFoundation::AM_MEDIA_TYPE>;
    fn SetMediaType(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::Result<()>;
    fn IsDiscontinuity(&self) -> windows_core::Result<()>;
    fn SetDiscontinuity(&self, bdiscontinuity: windows_core::BOOL) -> windows_core::Result<()>;
    fn GetMediaTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> windows_core::Result<()>;
    fn SetMediaTime(&self, ptimestart: *const i64, ptimeend: *const i64) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl IAMMediaTypeSample_Vtbl {
    pub const fn new<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetPointer<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbuffer: *const u8, lsize: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::SetPointer(this, core::mem::transmute_copy(&pbuffer), core::mem::transmute_copy(&lsize)).into()
            }
        }
        unsafe extern "system" fn GetPointer<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppbuffer: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMMediaTypeSample_Impl::GetPointer(this) {
                    Ok(ok__) => {
                        ppbuffer.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSize<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> i32 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::GetSize(this)
            }
        }
        unsafe extern "system" fn GetTime<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptimestart: *mut i64, ptimeend: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::GetTime(this, core::mem::transmute_copy(&ptimestart), core::mem::transmute_copy(&ptimeend)).into()
            }
        }
        unsafe extern "system" fn SetTime<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptimestart: *const i64, ptimeend: *const i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::SetTime(this, core::mem::transmute_copy(&ptimestart), core::mem::transmute_copy(&ptimeend)).into()
            }
        }
        unsafe extern "system" fn IsSyncPoint<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::IsSyncPoint(this).into()
            }
        }
        unsafe extern "system" fn SetSyncPoint<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bissyncpoint: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::SetSyncPoint(this, core::mem::transmute_copy(&bissyncpoint)).into()
            }
        }
        unsafe extern "system" fn IsPreroll<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::IsPreroll(this).into()
            }
        }
        unsafe extern "system" fn SetPreroll<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bispreroll: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::SetPreroll(this, core::mem::transmute_copy(&bispreroll)).into()
            }
        }
        unsafe extern "system" fn GetActualDataLength<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> i32 {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::GetActualDataLength(this)
            }
        }
        unsafe extern "system" fn SetActualDataLength<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, __midl__iammediatypesample0000: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::SetActualDataLength(this, core::mem::transmute_copy(&__midl__iammediatypesample0000)).into()
            }
        }
        unsafe extern "system" fn GetMediaType<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppmediatype: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMMediaTypeSample_Impl::GetMediaType(this) {
                    Ok(ok__) => {
                        ppmediatype.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMediaType<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::SetMediaType(this, core::mem::transmute_copy(&pmediatype)).into()
            }
        }
        unsafe extern "system" fn IsDiscontinuity<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::IsDiscontinuity(this).into()
            }
        }
        unsafe extern "system" fn SetDiscontinuity<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bdiscontinuity: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::SetDiscontinuity(this, core::mem::transmute_copy(&bdiscontinuity)).into()
            }
        }
        unsafe extern "system" fn GetMediaTime<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptimestart: *mut i64, ptimeend: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::GetMediaTime(this, core::mem::transmute_copy(&ptimestart), core::mem::transmute_copy(&ptimeend)).into()
            }
        }
        unsafe extern "system" fn SetMediaTime<Identity: IAMMediaTypeSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptimestart: *const i64, ptimeend: *const i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeSample_Impl::SetMediaTime(this, core::mem::transmute_copy(&ptimestart), core::mem::transmute_copy(&ptimeend)).into()
            }
        }
        Self {
            base__: IStreamSample_Vtbl::new::<Identity, OFFSET>(),
            SetPointer: SetPointer::<Identity, OFFSET>,
            GetPointer: GetPointer::<Identity, OFFSET>,
            GetSize: GetSize::<Identity, OFFSET>,
            GetTime: GetTime::<Identity, OFFSET>,
            SetTime: SetTime::<Identity, OFFSET>,
            IsSyncPoint: IsSyncPoint::<Identity, OFFSET>,
            SetSyncPoint: SetSyncPoint::<Identity, OFFSET>,
            IsPreroll: IsPreroll::<Identity, OFFSET>,
            SetPreroll: SetPreroll::<Identity, OFFSET>,
            GetActualDataLength: GetActualDataLength::<Identity, OFFSET>,
            SetActualDataLength: SetActualDataLength::<Identity, OFFSET>,
            GetMediaType: GetMediaType::<Identity, OFFSET>,
            SetMediaType: SetMediaType::<Identity, OFFSET>,
            IsDiscontinuity: IsDiscontinuity::<Identity, OFFSET>,
            SetDiscontinuity: SetDiscontinuity::<Identity, OFFSET>,
            GetMediaTime: GetMediaTime::<Identity, OFFSET>,
            SetMediaTime: SetMediaTime::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMMediaTypeSample as windows_core::Interface>::IID || iid == &<IStreamSample as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl windows_core::RuntimeName for IAMMediaTypeSample {}
windows_core::imp::define_interface!(IAMMediaTypeStream, IAMMediaTypeStream_Vtbl, 0xab6b4afa_f6e4_11d0_900d_00c04fd9189d);
impl core::ops::Deref for IAMMediaTypeStream {
    type Target = IMediaStream;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAMMediaTypeStream, windows_core::IUnknown, IMediaStream);
impl IAMMediaTypeStream {
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn GetFormat(&self, pmediatype: *mut super::MediaFoundation::AM_MEDIA_TYPE, dwflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetFormat)(windows_core::Interface::as_raw(self), core::mem::transmute(pmediatype), dwflags).ok() }
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetFormat(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE, dwflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFormat)(windows_core::Interface::as_raw(self), core::mem::transmute(pmediatype), dwflags).ok() }
    }
    pub unsafe fn CreateSample<P3>(&self, lsamplesize: i32, pbbuffer: *const u8, dwflags: u32, punkouter: P3) -> windows_core::Result<IAMMediaTypeSample>
    where
        P3: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateSample)(windows_core::Interface::as_raw(self), lsamplesize, pbbuffer, dwflags, punkouter.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetStreamAllocatorRequirements(&self) -> windows_core::Result<ALLOCATOR_PROPERTIES> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetStreamAllocatorRequirements)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetStreamAllocatorRequirements(&self, pprops: *const ALLOCATOR_PROPERTIES) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetStreamAllocatorRequirements)(windows_core::Interface::as_raw(self), pprops).ok() }
    }
}
#[repr(C)]
pub struct IAMMediaTypeStream_Vtbl {
    pub base__: IMediaStream_Vtbl,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub GetFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::MediaFoundation::AM_MEDIA_TYPE, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    GetFormat: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub SetFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    SetFormat: usize,
    pub CreateSample: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *const u8, u32, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetStreamAllocatorRequirements: unsafe extern "system" fn(*mut core::ffi::c_void, *mut ALLOCATOR_PROPERTIES) -> windows_core::HRESULT,
    pub SetStreamAllocatorRequirements: unsafe extern "system" fn(*mut core::ffi::c_void, *const ALLOCATOR_PROPERTIES) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
pub trait IAMMediaTypeStream_Impl: IMediaStream_Impl {
    fn GetFormat(&self, pmediatype: *mut super::MediaFoundation::AM_MEDIA_TYPE, dwflags: u32) -> windows_core::Result<()>;
    fn SetFormat(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE, dwflags: u32) -> windows_core::Result<()>;
    fn CreateSample(&self, lsamplesize: i32, pbbuffer: *const u8, dwflags: u32, punkouter: windows_core::Ref<'_, windows_core::IUnknown>) -> windows_core::Result<IAMMediaTypeSample>;
    fn GetStreamAllocatorRequirements(&self) -> windows_core::Result<ALLOCATOR_PROPERTIES>;
    fn SetStreamAllocatorRequirements(&self, pprops: *const ALLOCATOR_PROPERTIES) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl IAMMediaTypeStream_Vtbl {
    pub const fn new<Identity: IAMMediaTypeStream_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetFormat<Identity: IAMMediaTypeStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmediatype: *mut super::MediaFoundation::AM_MEDIA_TYPE, dwflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeStream_Impl::GetFormat(this, core::mem::transmute_copy(&pmediatype), core::mem::transmute_copy(&dwflags)).into()
            }
        }
        unsafe extern "system" fn SetFormat<Identity: IAMMediaTypeStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE, dwflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeStream_Impl::SetFormat(this, core::mem::transmute_copy(&pmediatype), core::mem::transmute_copy(&dwflags)).into()
            }
        }
        unsafe extern "system" fn CreateSample<Identity: IAMMediaTypeStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lsamplesize: i32, pbbuffer: *const u8, dwflags: u32, punkouter: *mut core::ffi::c_void, ppammediatypesample: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMMediaTypeStream_Impl::CreateSample(this, core::mem::transmute_copy(&lsamplesize), core::mem::transmute_copy(&pbbuffer), core::mem::transmute_copy(&dwflags), core::mem::transmute_copy(&punkouter)) {
                    Ok(ok__) => {
                        ppammediatypesample.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetStreamAllocatorRequirements<Identity: IAMMediaTypeStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pprops: *mut ALLOCATOR_PROPERTIES) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMMediaTypeStream_Impl::GetStreamAllocatorRequirements(this) {
                    Ok(ok__) => {
                        pprops.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetStreamAllocatorRequirements<Identity: IAMMediaTypeStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pprops: *const ALLOCATOR_PROPERTIES) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMediaTypeStream_Impl::SetStreamAllocatorRequirements(this, core::mem::transmute_copy(&pprops)).into()
            }
        }
        Self {
            base__: IMediaStream_Vtbl::new::<Identity, OFFSET>(),
            GetFormat: GetFormat::<Identity, OFFSET>,
            SetFormat: SetFormat::<Identity, OFFSET>,
            CreateSample: CreateSample::<Identity, OFFSET>,
            GetStreamAllocatorRequirements: GetStreamAllocatorRequirements::<Identity, OFFSET>,
            SetStreamAllocatorRequirements: SetStreamAllocatorRequirements::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMMediaTypeStream as windows_core::Interface>::IID || iid == &<IMediaStream as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl windows_core::RuntimeName for IAMMediaTypeStream {}
windows_core::imp::define_interface!(IAMMultiMediaStream, IAMMultiMediaStream_Vtbl, 0xbebe595c_9a6f_11d0_8fde_00c04fd9189d);
impl core::ops::Deref for IAMMultiMediaStream {
    type Target = IMultiMediaStream;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAMMultiMediaStream, windows_core::IUnknown, IMultiMediaStream);
impl IAMMultiMediaStream {
    pub unsafe fn Initialize<P2>(&self, streamtype: STREAM_TYPE, dwflags: AMMSF_MMS_INIT_FLAGS, pfiltergraph: P2) -> windows_core::Result<()>
    where
        P2: windows_core::Param<IGraphBuilder>,
    {
        unsafe { (windows_core::Interface::vtable(self).Initialize)(windows_core::Interface::as_raw(self), streamtype, dwflags.0 as _, pfiltergraph.param().abi()).ok() }
    }
    pub unsafe fn GetFilterGraph(&self) -> windows_core::Result<IGraphBuilder> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFilterGraph)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetFilter(&self) -> windows_core::Result<IMediaStreamFilter> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFilter)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn AddMediaStream<P0>(&self, pstreamobject: P0, purposeid: *const windows_core::GUID, dwflags: AMMSF_MS_FLAGS) -> windows_core::Result<IMediaStream>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AddMediaStream)(windows_core::Interface::as_raw(self), pstreamobject.param().abi(), purposeid, dwflags.0 as _, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn OpenFile<P0>(&self, pszfilename: P0, dwflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).OpenFile)(windows_core::Interface::as_raw(self), pszfilename.param().abi(), dwflags).ok() }
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OpenMoniker<P0, P1>(&self, pctx: P0, pmoniker: P1, dwflags: u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::super::System::Com::IBindCtx>,
        P1: windows_core::Param<super::super::System::Com::IMoniker>,
    {
        unsafe { (windows_core::Interface::vtable(self).OpenMoniker)(windows_core::Interface::as_raw(self), pctx.param().abi(), pmoniker.param().abi(), dwflags).ok() }
    }
    pub unsafe fn Render(&self, dwflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Render)(windows_core::Interface::as_raw(self), dwflags).ok() }
    }
}
#[repr(C)]
pub struct IAMMultiMediaStream_Vtbl {
    pub base__: IMultiMediaStream_Vtbl,
    pub Initialize: unsafe extern "system" fn(*mut core::ffi::c_void, STREAM_TYPE, u32, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetFilterGraph: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetFilter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetFilter: usize,
    pub AddMediaStream: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const windows_core::GUID, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub OpenFile: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub OpenMoniker: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    OpenMoniker: usize,
    pub Render: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_System_Com")]
pub trait IAMMultiMediaStream_Impl: IMultiMediaStream_Impl {
    fn Initialize(&self, streamtype: STREAM_TYPE, dwflags: &AMMSF_MMS_INIT_FLAGS, pfiltergraph: windows_core::Ref<'_, IGraphBuilder>) -> windows_core::Result<()>;
    fn GetFilterGraph(&self) -> windows_core::Result<IGraphBuilder>;
    fn GetFilter(&self) -> windows_core::Result<IMediaStreamFilter>;
    fn AddMediaStream(&self, pstreamobject: windows_core::Ref<'_, windows_core::IUnknown>, purposeid: *const windows_core::GUID, dwflags: &AMMSF_MS_FLAGS) -> windows_core::Result<IMediaStream>;
    fn OpenFile(&self, pszfilename: &windows_core::PCWSTR, dwflags: u32) -> windows_core::Result<()>;
    fn OpenMoniker(&self, pctx: windows_core::Ref<'_, super::super::System::Com::IBindCtx>, pmoniker: windows_core::Ref<'_, super::super::System::Com::IMoniker>, dwflags: u32) -> windows_core::Result<()>;
    fn Render(&self, dwflags: u32) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_System_Com")]
impl IAMMultiMediaStream_Vtbl {
    pub const fn new<Identity: IAMMultiMediaStream_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Initialize<Identity: IAMMultiMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, streamtype: STREAM_TYPE, dwflags: u32, pfiltergraph: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMultiMediaStream_Impl::Initialize(this, core::mem::transmute_copy(&streamtype), core::mem::transmute(&dwflags), core::mem::transmute_copy(&pfiltergraph)).into()
            }
        }
        unsafe extern "system" fn GetFilterGraph<Identity: IAMMultiMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppgraphbuilder: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMMultiMediaStream_Impl::GetFilterGraph(this) {
                    Ok(ok__) => {
                        ppgraphbuilder.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFilter<Identity: IAMMultiMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppfilter: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMMultiMediaStream_Impl::GetFilter(this) {
                    Ok(ok__) => {
                        ppfilter.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn AddMediaStream<Identity: IAMMultiMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pstreamobject: *mut core::ffi::c_void, purposeid: *const windows_core::GUID, dwflags: u32, ppnewstream: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMMultiMediaStream_Impl::AddMediaStream(this, core::mem::transmute_copy(&pstreamobject), core::mem::transmute_copy(&purposeid), core::mem::transmute(&dwflags)) {
                    Ok(ok__) => {
                        ppnewstream.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn OpenFile<Identity: IAMMultiMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszfilename: windows_core::PCWSTR, dwflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMultiMediaStream_Impl::OpenFile(this, core::mem::transmute(&pszfilename), core::mem::transmute_copy(&dwflags)).into()
            }
        }
        unsafe extern "system" fn OpenMoniker<Identity: IAMMultiMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pctx: *mut core::ffi::c_void, pmoniker: *mut core::ffi::c_void, dwflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMultiMediaStream_Impl::OpenMoniker(this, core::mem::transmute_copy(&pctx), core::mem::transmute_copy(&pmoniker), core::mem::transmute_copy(&dwflags)).into()
            }
        }
        unsafe extern "system" fn Render<Identity: IAMMultiMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMMultiMediaStream_Impl::Render(this, core::mem::transmute_copy(&dwflags)).into()
            }
        }
        Self {
            base__: IMultiMediaStream_Vtbl::new::<Identity, OFFSET>(),
            Initialize: Initialize::<Identity, OFFSET>,
            GetFilterGraph: GetFilterGraph::<Identity, OFFSET>,
            GetFilter: GetFilter::<Identity, OFFSET>,
            AddMediaStream: AddMediaStream::<Identity, OFFSET>,
            OpenFile: OpenFile::<Identity, OFFSET>,
            OpenMoniker: OpenMoniker::<Identity, OFFSET>,
            Render: Render::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMMultiMediaStream as windows_core::Interface>::IID || iid == &<IMultiMediaStream as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_System_Com")]
impl windows_core::RuntimeName for IAMMultiMediaStream {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAMNetShowConfig, IAMNetShowConfig_Vtbl, 0xfa2aa8f1_8b62_11d0_a520_000000000000);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAMNetShowConfig {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAMNetShowConfig, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMNetShowConfig {
    pub unsafe fn BufferingTime(&self, pbufferingtime: *mut f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).BufferingTime)(windows_core::Interface::as_raw(self), pbufferingtime as _).ok() }
    }
    pub unsafe fn SetBufferingTime(&self, bufferingtime: f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetBufferingTime)(windows_core::Interface::as_raw(self), bufferingtime).ok() }
    }
    pub unsafe fn UseFixedUDPPort(&self, pusefixedudpport: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).UseFixedUDPPort)(windows_core::Interface::as_raw(self), pusefixedudpport as _).ok() }
    }
    pub unsafe fn SetUseFixedUDPPort(&self, usefixedudpport: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetUseFixedUDPPort)(windows_core::Interface::as_raw(self), usefixedudpport).ok() }
    }
    pub unsafe fn FixedUDPPort(&self, pfixedudpport: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).FixedUDPPort)(windows_core::Interface::as_raw(self), pfixedudpport as _).ok() }
    }
    pub unsafe fn SetFixedUDPPort(&self, fixedudpport: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFixedUDPPort)(windows_core::Interface::as_raw(self), fixedudpport).ok() }
    }
    pub unsafe fn UseHTTPProxy(&self, pusehttpproxy: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).UseHTTPProxy)(windows_core::Interface::as_raw(self), pusehttpproxy as _).ok() }
    }
    pub unsafe fn SetUseHTTPProxy(&self, usehttpproxy: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetUseHTTPProxy)(windows_core::Interface::as_raw(self), usehttpproxy).ok() }
    }
    pub unsafe fn EnableAutoProxy(&self, penableautoproxy: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EnableAutoProxy)(windows_core::Interface::as_raw(self), penableautoproxy as _).ok() }
    }
    pub unsafe fn SetEnableAutoProxy(&self, enableautoproxy: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetEnableAutoProxy)(windows_core::Interface::as_raw(self), enableautoproxy).ok() }
    }
    pub unsafe fn HTTPProxyHost(&self, pbstrhttpproxyhost: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).HTTPProxyHost)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrhttpproxyhost)).ok() }
    }
    pub unsafe fn SetHTTPProxyHost(&self, bstrhttpproxyhost: &windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetHTTPProxyHost)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(bstrhttpproxyhost)).ok() }
    }
    pub unsafe fn HTTPProxyPort(&self, phttpproxyport: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).HTTPProxyPort)(windows_core::Interface::as_raw(self), phttpproxyport as _).ok() }
    }
    pub unsafe fn SetHTTPProxyPort(&self, httpproxyport: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetHTTPProxyPort)(windows_core::Interface::as_raw(self), httpproxyport).ok() }
    }
    pub unsafe fn EnableMulticast(&self, penablemulticast: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EnableMulticast)(windows_core::Interface::as_raw(self), penablemulticast as _).ok() }
    }
    pub unsafe fn SetEnableMulticast(&self, enablemulticast: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetEnableMulticast)(windows_core::Interface::as_raw(self), enablemulticast).ok() }
    }
    pub unsafe fn EnableUDP(&self, penableudp: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EnableUDP)(windows_core::Interface::as_raw(self), penableudp as _).ok() }
    }
    pub unsafe fn SetEnableUDP(&self, enableudp: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetEnableUDP)(windows_core::Interface::as_raw(self), enableudp).ok() }
    }
    pub unsafe fn EnableTCP(&self, penabletcp: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EnableTCP)(windows_core::Interface::as_raw(self), penabletcp as _).ok() }
    }
    pub unsafe fn SetEnableTCP(&self, enabletcp: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetEnableTCP)(windows_core::Interface::as_raw(self), enabletcp).ok() }
    }
    pub unsafe fn EnableHTTP(&self, penablehttp: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EnableHTTP)(windows_core::Interface::as_raw(self), penablehttp as _).ok() }
    }
    pub unsafe fn SetEnableHTTP(&self, enablehttp: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetEnableHTTP)(windows_core::Interface::as_raw(self), enablehttp).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMNetShowConfig_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub BufferingTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f64) -> windows_core::HRESULT,
    pub SetBufferingTime: unsafe extern "system" fn(*mut core::ffi::c_void, f64) -> windows_core::HRESULT,
    pub UseFixedUDPPort: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub SetUseFixedUDPPort: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub FixedUDPPort: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetFixedUDPPort: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub UseHTTPProxy: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub SetUseHTTPProxy: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub EnableAutoProxy: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub SetEnableAutoProxy: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub HTTPProxyHost: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetHTTPProxyHost: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub HTTPProxyPort: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetHTTPProxyPort: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub EnableMulticast: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub SetEnableMulticast: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub EnableUDP: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub SetEnableUDP: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub EnableTCP: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub SetEnableTCP: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub EnableHTTP: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub SetEnableHTTP: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAMNetShowConfig_Impl: super::super::System::Com::IDispatch_Impl {
    fn BufferingTime(&self, pbufferingtime: *mut f64) -> windows_core::Result<()>;
    fn SetBufferingTime(&self, bufferingtime: f64) -> windows_core::Result<()>;
    fn UseFixedUDPPort(&self, pusefixedudpport: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn SetUseFixedUDPPort(&self, usefixedudpport: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn FixedUDPPort(&self, pfixedudpport: *mut i32) -> windows_core::Result<()>;
    fn SetFixedUDPPort(&self, fixedudpport: i32) -> windows_core::Result<()>;
    fn UseHTTPProxy(&self, pusehttpproxy: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn SetUseHTTPProxy(&self, usehttpproxy: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn EnableAutoProxy(&self, penableautoproxy: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn SetEnableAutoProxy(&self, enableautoproxy: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn HTTPProxyHost(&self, pbstrhttpproxyhost: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn SetHTTPProxyHost(&self, bstrhttpproxyhost: &windows_core::BSTR) -> windows_core::Result<()>;
    fn HTTPProxyPort(&self, phttpproxyport: *mut i32) -> windows_core::Result<()>;
    fn SetHTTPProxyPort(&self, httpproxyport: i32) -> windows_core::Result<()>;
    fn EnableMulticast(&self, penablemulticast: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn SetEnableMulticast(&self, enablemulticast: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn EnableUDP(&self, penableudp: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn SetEnableUDP(&self, enableudp: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn EnableTCP(&self, penabletcp: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn SetEnableTCP(&self, enabletcp: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn EnableHTTP(&self, penablehttp: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn SetEnableHTTP(&self, enablehttp: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAMNetShowConfig_Vtbl {
    pub const fn new<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn BufferingTime<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbufferingtime: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::BufferingTime(this, core::mem::transmute_copy(&pbufferingtime)).into()
            }
        }
        unsafe extern "system" fn SetBufferingTime<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bufferingtime: f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::SetBufferingTime(this, core::mem::transmute_copy(&bufferingtime)).into()
            }
        }
        unsafe extern "system" fn UseFixedUDPPort<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pusefixedudpport: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::UseFixedUDPPort(this, core::mem::transmute_copy(&pusefixedudpport)).into()
            }
        }
        unsafe extern "system" fn SetUseFixedUDPPort<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, usefixedudpport: super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::SetUseFixedUDPPort(this, core::mem::transmute_copy(&usefixedudpport)).into()
            }
        }
        unsafe extern "system" fn FixedUDPPort<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfixedudpport: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::FixedUDPPort(this, core::mem::transmute_copy(&pfixedudpport)).into()
            }
        }
        unsafe extern "system" fn SetFixedUDPPort<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fixedudpport: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::SetFixedUDPPort(this, core::mem::transmute_copy(&fixedudpport)).into()
            }
        }
        unsafe extern "system" fn UseHTTPProxy<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pusehttpproxy: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::UseHTTPProxy(this, core::mem::transmute_copy(&pusehttpproxy)).into()
            }
        }
        unsafe extern "system" fn SetUseHTTPProxy<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, usehttpproxy: super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::SetUseHTTPProxy(this, core::mem::transmute_copy(&usehttpproxy)).into()
            }
        }
        unsafe extern "system" fn EnableAutoProxy<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, penableautoproxy: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::EnableAutoProxy(this, core::mem::transmute_copy(&penableautoproxy)).into()
            }
        }
        unsafe extern "system" fn SetEnableAutoProxy<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, enableautoproxy: super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::SetEnableAutoProxy(this, core::mem::transmute_copy(&enableautoproxy)).into()
            }
        }
        unsafe extern "system" fn HTTPProxyHost<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrhttpproxyhost: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::HTTPProxyHost(this, core::mem::transmute_copy(&pbstrhttpproxyhost)).into()
            }
        }
        unsafe extern "system" fn SetHTTPProxyHost<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bstrhttpproxyhost: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::SetHTTPProxyHost(this, core::mem::transmute(&bstrhttpproxyhost)).into()
            }
        }
        unsafe extern "system" fn HTTPProxyPort<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, phttpproxyport: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::HTTPProxyPort(this, core::mem::transmute_copy(&phttpproxyport)).into()
            }
        }
        unsafe extern "system" fn SetHTTPProxyPort<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, httpproxyport: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::SetHTTPProxyPort(this, core::mem::transmute_copy(&httpproxyport)).into()
            }
        }
        unsafe extern "system" fn EnableMulticast<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, penablemulticast: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::EnableMulticast(this, core::mem::transmute_copy(&penablemulticast)).into()
            }
        }
        unsafe extern "system" fn SetEnableMulticast<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, enablemulticast: super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::SetEnableMulticast(this, core::mem::transmute_copy(&enablemulticast)).into()
            }
        }
        unsafe extern "system" fn EnableUDP<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, penableudp: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::EnableUDP(this, core::mem::transmute_copy(&penableudp)).into()
            }
        }
        unsafe extern "system" fn SetEnableUDP<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, enableudp: super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::SetEnableUDP(this, core::mem::transmute_copy(&enableudp)).into()
            }
        }
        unsafe extern "system" fn EnableTCP<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, penabletcp: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::EnableTCP(this, core::mem::transmute_copy(&penabletcp)).into()
            }
        }
        unsafe extern "system" fn SetEnableTCP<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, enabletcp: super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::SetEnableTCP(this, core::mem::transmute_copy(&enabletcp)).into()
            }
        }
        unsafe extern "system" fn EnableHTTP<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, penablehttp: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::EnableHTTP(this, core::mem::transmute_copy(&penablehttp)).into()
            }
        }
        unsafe extern "system" fn SetEnableHTTP<Identity: IAMNetShowConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, enablehttp: super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowConfig_Impl::SetEnableHTTP(this, core::mem::transmute_copy(&enablehttp)).into()
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            BufferingTime: BufferingTime::<Identity, OFFSET>,
            SetBufferingTime: SetBufferingTime::<Identity, OFFSET>,
            UseFixedUDPPort: UseFixedUDPPort::<Identity, OFFSET>,
            SetUseFixedUDPPort: SetUseFixedUDPPort::<Identity, OFFSET>,
            FixedUDPPort: FixedUDPPort::<Identity, OFFSET>,
            SetFixedUDPPort: SetFixedUDPPort::<Identity, OFFSET>,
            UseHTTPProxy: UseHTTPProxy::<Identity, OFFSET>,
            SetUseHTTPProxy: SetUseHTTPProxy::<Identity, OFFSET>,
            EnableAutoProxy: EnableAutoProxy::<Identity, OFFSET>,
            SetEnableAutoProxy: SetEnableAutoProxy::<Identity, OFFSET>,
            HTTPProxyHost: HTTPProxyHost::<Identity, OFFSET>,
            SetHTTPProxyHost: SetHTTPProxyHost::<Identity, OFFSET>,
            HTTPProxyPort: HTTPProxyPort::<Identity, OFFSET>,
            SetHTTPProxyPort: SetHTTPProxyPort::<Identity, OFFSET>,
            EnableMulticast: EnableMulticast::<Identity, OFFSET>,
            SetEnableMulticast: SetEnableMulticast::<Identity, OFFSET>,
            EnableUDP: EnableUDP::<Identity, OFFSET>,
            SetEnableUDP: SetEnableUDP::<Identity, OFFSET>,
            EnableTCP: EnableTCP::<Identity, OFFSET>,
            SetEnableTCP: SetEnableTCP::<Identity, OFFSET>,
            EnableHTTP: EnableHTTP::<Identity, OFFSET>,
            SetEnableHTTP: SetEnableHTTP::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMNetShowConfig as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAMNetShowConfig {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAMNetShowExProps, IAMNetShowExProps_Vtbl, 0xfa2aa8f5_8b62_11d0_a520_000000000000);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAMNetShowExProps {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAMNetShowExProps, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMNetShowExProps {
    pub unsafe fn SourceProtocol(&self, psourceprotocol: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SourceProtocol)(windows_core::Interface::as_raw(self), psourceprotocol as _).ok() }
    }
    pub unsafe fn Bandwidth(&self, pbandwidth: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Bandwidth)(windows_core::Interface::as_raw(self), pbandwidth as _).ok() }
    }
    pub unsafe fn ErrorCorrection(&self, pbstrerrorcorrection: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ErrorCorrection)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrerrorcorrection)).ok() }
    }
    pub unsafe fn CodecCount(&self, pcodeccount: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CodecCount)(windows_core::Interface::as_raw(self), pcodeccount as _).ok() }
    }
    pub unsafe fn GetCodecInstalled(&self, codecnum: i32, pcodecinstalled: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCodecInstalled)(windows_core::Interface::as_raw(self), codecnum, pcodecinstalled as _).ok() }
    }
    pub unsafe fn GetCodecDescription(&self, codecnum: i32, pbstrcodecdescription: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCodecDescription)(windows_core::Interface::as_raw(self), codecnum, core::mem::transmute(pbstrcodecdescription)).ok() }
    }
    pub unsafe fn GetCodecURL(&self, codecnum: i32, pbstrcodecurl: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCodecURL)(windows_core::Interface::as_raw(self), codecnum, core::mem::transmute(pbstrcodecurl)).ok() }
    }
    pub unsafe fn CreationDate(&self, pcreationdate: *mut f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CreationDate)(windows_core::Interface::as_raw(self), pcreationdate as _).ok() }
    }
    pub unsafe fn SourceLink(&self, pbstrsourcelink: *mut windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SourceLink)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrsourcelink)).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMNetShowExProps_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub SourceProtocol: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub Bandwidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub ErrorCorrection: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CodecCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub GetCodecInstalled: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub GetCodecDescription: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetCodecURL: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CreationDate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f64) -> windows_core::HRESULT,
    pub SourceLink: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAMNetShowExProps_Impl: super::super::System::Com::IDispatch_Impl {
    fn SourceProtocol(&self, psourceprotocol: *mut i32) -> windows_core::Result<()>;
    fn Bandwidth(&self, pbandwidth: *mut i32) -> windows_core::Result<()>;
    fn ErrorCorrection(&self, pbstrerrorcorrection: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn CodecCount(&self, pcodeccount: *mut i32) -> windows_core::Result<()>;
    fn GetCodecInstalled(&self, codecnum: i32, pcodecinstalled: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn GetCodecDescription(&self, codecnum: i32, pbstrcodecdescription: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn GetCodecURL(&self, codecnum: i32, pbstrcodecurl: *mut windows_core::BSTR) -> windows_core::Result<()>;
    fn CreationDate(&self, pcreationdate: *mut f64) -> windows_core::Result<()>;
    fn SourceLink(&self, pbstrsourcelink: *mut windows_core::BSTR) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAMNetShowExProps_Vtbl {
    pub const fn new<Identity: IAMNetShowExProps_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SourceProtocol<Identity: IAMNetShowExProps_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psourceprotocol: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowExProps_Impl::SourceProtocol(this, core::mem::transmute_copy(&psourceprotocol)).into()
            }
        }
        unsafe extern "system" fn Bandwidth<Identity: IAMNetShowExProps_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbandwidth: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowExProps_Impl::Bandwidth(this, core::mem::transmute_copy(&pbandwidth)).into()
            }
        }
        unsafe extern "system" fn ErrorCorrection<Identity: IAMNetShowExProps_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrerrorcorrection: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowExProps_Impl::ErrorCorrection(this, core::mem::transmute_copy(&pbstrerrorcorrection)).into()
            }
        }
        unsafe extern "system" fn CodecCount<Identity: IAMNetShowExProps_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcodeccount: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowExProps_Impl::CodecCount(this, core::mem::transmute_copy(&pcodeccount)).into()
            }
        }
        unsafe extern "system" fn GetCodecInstalled<Identity: IAMNetShowExProps_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, codecnum: i32, pcodecinstalled: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowExProps_Impl::GetCodecInstalled(this, core::mem::transmute_copy(&codecnum), core::mem::transmute_copy(&pcodecinstalled)).into()
            }
        }
        unsafe extern "system" fn GetCodecDescription<Identity: IAMNetShowExProps_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, codecnum: i32, pbstrcodecdescription: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowExProps_Impl::GetCodecDescription(this, core::mem::transmute_copy(&codecnum), core::mem::transmute_copy(&pbstrcodecdescription)).into()
            }
        }
        unsafe extern "system" fn GetCodecURL<Identity: IAMNetShowExProps_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, codecnum: i32, pbstrcodecurl: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowExProps_Impl::GetCodecURL(this, core::mem::transmute_copy(&codecnum), core::mem::transmute_copy(&pbstrcodecurl)).into()
            }
        }
        unsafe extern "system" fn CreationDate<Identity: IAMNetShowExProps_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcreationdate: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowExProps_Impl::CreationDate(this, core::mem::transmute_copy(&pcreationdate)).into()
            }
        }
        unsafe extern "system" fn SourceLink<Identity: IAMNetShowExProps_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrsourcelink: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowExProps_Impl::SourceLink(this, core::mem::transmute_copy(&pbstrsourcelink)).into()
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            SourceProtocol: SourceProtocol::<Identity, OFFSET>,
            Bandwidth: Bandwidth::<Identity, OFFSET>,
            ErrorCorrection: ErrorCorrection::<Identity, OFFSET>,
            CodecCount: CodecCount::<Identity, OFFSET>,
            GetCodecInstalled: GetCodecInstalled::<Identity, OFFSET>,
            GetCodecDescription: GetCodecDescription::<Identity, OFFSET>,
            GetCodecURL: GetCodecURL::<Identity, OFFSET>,
            CreationDate: CreationDate::<Identity, OFFSET>,
            SourceLink: SourceLink::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMNetShowExProps as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAMNetShowExProps {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAMNetShowPreroll, IAMNetShowPreroll_Vtbl, 0xaae7e4e2_6388_11d1_8d93_006097c9a2b2);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAMNetShowPreroll {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAMNetShowPreroll, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMNetShowPreroll {
    pub unsafe fn SetPreroll(&self, fpreroll: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPreroll)(windows_core::Interface::as_raw(self), fpreroll).ok() }
    }
    pub unsafe fn Preroll(&self, pfpreroll: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Preroll)(windows_core::Interface::as_raw(self), pfpreroll as _).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMNetShowPreroll_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub SetPreroll: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub Preroll: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAMNetShowPreroll_Impl: super::super::System::Com::IDispatch_Impl {
    fn SetPreroll(&self, fpreroll: super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn Preroll(&self, pfpreroll: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAMNetShowPreroll_Vtbl {
    pub const fn new<Identity: IAMNetShowPreroll_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetPreroll<Identity: IAMNetShowPreroll_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fpreroll: super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowPreroll_Impl::SetPreroll(this, core::mem::transmute_copy(&fpreroll)).into()
            }
        }
        unsafe extern "system" fn Preroll<Identity: IAMNetShowPreroll_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfpreroll: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetShowPreroll_Impl::Preroll(this, core::mem::transmute_copy(&pfpreroll)).into()
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            SetPreroll: SetPreroll::<Identity, OFFSET>,
            Preroll: Preroll::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMNetShowPreroll as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAMNetShowPreroll {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAMNetworkStatus, IAMNetworkStatus_Vtbl, 0xfa2aa8f3_8b62_11d0_a520_000000000000);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAMNetworkStatus {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAMNetworkStatus, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMNetworkStatus {
    pub unsafe fn ReceivedPackets(&self, preceivedpackets: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ReceivedPackets)(windows_core::Interface::as_raw(self), preceivedpackets as _).ok() }
    }
    pub unsafe fn RecoveredPackets(&self, precoveredpackets: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RecoveredPackets)(windows_core::Interface::as_raw(self), precoveredpackets as _).ok() }
    }
    pub unsafe fn LostPackets(&self, plostpackets: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).LostPackets)(windows_core::Interface::as_raw(self), plostpackets as _).ok() }
    }
    pub unsafe fn ReceptionQuality(&self, preceptionquality: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ReceptionQuality)(windows_core::Interface::as_raw(self), preceptionquality as _).ok() }
    }
    pub unsafe fn BufferingCount(&self, pbufferingcount: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).BufferingCount)(windows_core::Interface::as_raw(self), pbufferingcount as _).ok() }
    }
    pub unsafe fn IsBroadcast(&self, pisbroadcast: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IsBroadcast)(windows_core::Interface::as_raw(self), pisbroadcast as _).ok() }
    }
    pub unsafe fn BufferingProgress(&self, pbufferingprogress: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).BufferingProgress)(windows_core::Interface::as_raw(self), pbufferingprogress as _).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMNetworkStatus_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ReceivedPackets: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub RecoveredPackets: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub LostPackets: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub ReceptionQuality: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub BufferingCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub IsBroadcast: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub BufferingProgress: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAMNetworkStatus_Impl: super::super::System::Com::IDispatch_Impl {
    fn ReceivedPackets(&self, preceivedpackets: *mut i32) -> windows_core::Result<()>;
    fn RecoveredPackets(&self, precoveredpackets: *mut i32) -> windows_core::Result<()>;
    fn LostPackets(&self, plostpackets: *mut i32) -> windows_core::Result<()>;
    fn ReceptionQuality(&self, preceptionquality: *mut i32) -> windows_core::Result<()>;
    fn BufferingCount(&self, pbufferingcount: *mut i32) -> windows_core::Result<()>;
    fn IsBroadcast(&self, pisbroadcast: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn BufferingProgress(&self, pbufferingprogress: *mut i32) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAMNetworkStatus_Vtbl {
    pub const fn new<Identity: IAMNetworkStatus_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ReceivedPackets<Identity: IAMNetworkStatus_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, preceivedpackets: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetworkStatus_Impl::ReceivedPackets(this, core::mem::transmute_copy(&preceivedpackets)).into()
            }
        }
        unsafe extern "system" fn RecoveredPackets<Identity: IAMNetworkStatus_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, precoveredpackets: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetworkStatus_Impl::RecoveredPackets(this, core::mem::transmute_copy(&precoveredpackets)).into()
            }
        }
        unsafe extern "system" fn LostPackets<Identity: IAMNetworkStatus_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plostpackets: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetworkStatus_Impl::LostPackets(this, core::mem::transmute_copy(&plostpackets)).into()
            }
        }
        unsafe extern "system" fn ReceptionQuality<Identity: IAMNetworkStatus_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, preceptionquality: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetworkStatus_Impl::ReceptionQuality(this, core::mem::transmute_copy(&preceptionquality)).into()
            }
        }
        unsafe extern "system" fn BufferingCount<Identity: IAMNetworkStatus_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbufferingcount: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetworkStatus_Impl::BufferingCount(this, core::mem::transmute_copy(&pbufferingcount)).into()
            }
        }
        unsafe extern "system" fn IsBroadcast<Identity: IAMNetworkStatus_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pisbroadcast: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetworkStatus_Impl::IsBroadcast(this, core::mem::transmute_copy(&pisbroadcast)).into()
            }
        }
        unsafe extern "system" fn BufferingProgress<Identity: IAMNetworkStatus_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbufferingprogress: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMNetworkStatus_Impl::BufferingProgress(this, core::mem::transmute_copy(&pbufferingprogress)).into()
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            ReceivedPackets: ReceivedPackets::<Identity, OFFSET>,
            RecoveredPackets: RecoveredPackets::<Identity, OFFSET>,
            LostPackets: LostPackets::<Identity, OFFSET>,
            ReceptionQuality: ReceptionQuality::<Identity, OFFSET>,
            BufferingCount: BufferingCount::<Identity, OFFSET>,
            IsBroadcast: IsBroadcast::<Identity, OFFSET>,
            BufferingProgress: BufferingProgress::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMNetworkStatus as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAMNetworkStatus {}
windows_core::imp::define_interface!(IAMOpenProgress, IAMOpenProgress_Vtbl, 0x8e1c39a1_de53_11cf_aa63_0080c744528d);
windows_core::imp::interface_hierarchy!(IAMOpenProgress, windows_core::IUnknown);
impl IAMOpenProgress {
    pub unsafe fn QueryProgress(&self, plltotal: *mut i64, pllcurrent: *mut i64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).QueryProgress)(windows_core::Interface::as_raw(self), plltotal as _, pllcurrent as _).ok() }
    }
    pub unsafe fn AbortOperation(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AbortOperation)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
pub struct IAMOpenProgress_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub QueryProgress: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i64, *mut i64) -> windows_core::HRESULT,
    pub AbortOperation: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAMOpenProgress_Impl: windows_core::IUnknownImpl {
    fn QueryProgress(&self, plltotal: *mut i64, pllcurrent: *mut i64) -> windows_core::Result<()>;
    fn AbortOperation(&self) -> windows_core::Result<()>;
}
impl IAMOpenProgress_Vtbl {
    pub const fn new<Identity: IAMOpenProgress_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn QueryProgress<Identity: IAMOpenProgress_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plltotal: *mut i64, pllcurrent: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMOpenProgress_Impl::QueryProgress(this, core::mem::transmute_copy(&plltotal), core::mem::transmute_copy(&pllcurrent)).into()
            }
        }
        unsafe extern "system" fn AbortOperation<Identity: IAMOpenProgress_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMOpenProgress_Impl::AbortOperation(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            QueryProgress: QueryProgress::<Identity, OFFSET>,
            AbortOperation: AbortOperation::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMOpenProgress as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMOpenProgress {}
windows_core::imp::define_interface!(IAMOverlayFX, IAMOverlayFX_Vtbl, 0x62fae250_7e65_4460_bfc9_6398b322073c);
windows_core::imp::interface_hierarchy!(IAMOverlayFX, windows_core::IUnknown);
impl IAMOverlayFX {
    pub unsafe fn QueryOverlayFXCaps(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).QueryOverlayFXCaps)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetOverlayFX(&self, dwoverlayfx: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOverlayFX)(windows_core::Interface::as_raw(self), dwoverlayfx).ok() }
    }
    pub unsafe fn GetOverlayFX(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetOverlayFX)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAMOverlayFX_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub QueryOverlayFXCaps: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetOverlayFX: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetOverlayFX: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IAMOverlayFX_Impl: windows_core::IUnknownImpl {
    fn QueryOverlayFXCaps(&self) -> windows_core::Result<u32>;
    fn SetOverlayFX(&self, dwoverlayfx: u32) -> windows_core::Result<()>;
    fn GetOverlayFX(&self) -> windows_core::Result<u32>;
}
impl IAMOverlayFX_Vtbl {
    pub const fn new<Identity: IAMOverlayFX_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn QueryOverlayFXCaps<Identity: IAMOverlayFX_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpdwoverlayfxcaps: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMOverlayFX_Impl::QueryOverlayFXCaps(this) {
                    Ok(ok__) => {
                        lpdwoverlayfxcaps.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetOverlayFX<Identity: IAMOverlayFX_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwoverlayfx: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMOverlayFX_Impl::SetOverlayFX(this, core::mem::transmute_copy(&dwoverlayfx)).into()
            }
        }
        unsafe extern "system" fn GetOverlayFX<Identity: IAMOverlayFX_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpdwoverlayfx: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMOverlayFX_Impl::GetOverlayFX(this) {
                    Ok(ok__) => {
                        lpdwoverlayfx.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            QueryOverlayFXCaps: QueryOverlayFXCaps::<Identity, OFFSET>,
            SetOverlayFX: SetOverlayFX::<Identity, OFFSET>,
            GetOverlayFX: GetOverlayFX::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMOverlayFX as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMOverlayFX {}
windows_core::imp::define_interface!(IAMParse, IAMParse_Vtbl, 0xc47a3420_005c_11d2_9038_00a0c9697298);
windows_core::imp::interface_hierarchy!(IAMParse, windows_core::IUnknown);
impl IAMParse {
    pub unsafe fn GetParseTime(&self) -> windows_core::Result<i64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetParseTime)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetParseTime(&self, rtcurrent: i64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetParseTime)(windows_core::Interface::as_raw(self), rtcurrent).ok() }
    }
    pub unsafe fn Flush(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Flush)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
pub struct IAMParse_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetParseTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i64) -> windows_core::HRESULT,
    pub SetParseTime: unsafe extern "system" fn(*mut core::ffi::c_void, i64) -> windows_core::HRESULT,
    pub Flush: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAMParse_Impl: windows_core::IUnknownImpl {
    fn GetParseTime(&self) -> windows_core::Result<i64>;
    fn SetParseTime(&self, rtcurrent: i64) -> windows_core::Result<()>;
    fn Flush(&self) -> windows_core::Result<()>;
}
impl IAMParse_Vtbl {
    pub const fn new<Identity: IAMParse_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetParseTime<Identity: IAMParse_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prtcurrent: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMParse_Impl::GetParseTime(this) {
                    Ok(ok__) => {
                        prtcurrent.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetParseTime<Identity: IAMParse_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, rtcurrent: i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMParse_Impl::SetParseTime(this, core::mem::transmute_copy(&rtcurrent)).into()
            }
        }
        unsafe extern "system" fn Flush<Identity: IAMParse_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMParse_Impl::Flush(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetParseTime: GetParseTime::<Identity, OFFSET>,
            SetParseTime: SetParseTime::<Identity, OFFSET>,
            Flush: Flush::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMParse as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMParse {}
windows_core::imp::define_interface!(IAMPhysicalPinInfo, IAMPhysicalPinInfo_Vtbl, 0xf938c991_3029_11cf_8c44_00aa006b6814);
windows_core::imp::interface_hierarchy!(IAMPhysicalPinInfo, windows_core::IUnknown);
impl IAMPhysicalPinInfo {
    pub unsafe fn GetPhysicalType(&self, ptype: *mut i32, ppsztype: *mut windows_core::PWSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetPhysicalType)(windows_core::Interface::as_raw(self), ptype as _, ppsztype as _).ok() }
    }
}
#[repr(C)]
pub struct IAMPhysicalPinInfo_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetPhysicalType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32, *mut windows_core::PWSTR) -> windows_core::HRESULT,
}
pub trait IAMPhysicalPinInfo_Impl: windows_core::IUnknownImpl {
    fn GetPhysicalType(&self, ptype: *mut i32, ppsztype: *mut windows_core::PWSTR) -> windows_core::Result<()>;
}
impl IAMPhysicalPinInfo_Vtbl {
    pub const fn new<Identity: IAMPhysicalPinInfo_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetPhysicalType<Identity: IAMPhysicalPinInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptype: *mut i32, ppsztype: *mut windows_core::PWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMPhysicalPinInfo_Impl::GetPhysicalType(this, core::mem::transmute_copy(&ptype), core::mem::transmute_copy(&ppsztype)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), GetPhysicalType: GetPhysicalType::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMPhysicalPinInfo as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMPhysicalPinInfo {}
windows_core::imp::define_interface!(IAMPlayList, IAMPlayList_Vtbl, 0x56a868fe_0ad4_11ce_b03a_0020af0ba770);
windows_core::imp::interface_hierarchy!(IAMPlayList, windows_core::IUnknown);
impl IAMPlayList {
    pub unsafe fn GetFlags(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetItemCount(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetItemCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetItem(&self, dwitemindex: u32) -> windows_core::Result<IAMPlayListItem> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetItem)(windows_core::Interface::as_raw(self), dwitemindex, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn GetNamedEvent<P0>(&self, pwszeventname: P0, dwitemindex: u32, ppitem: *mut Option<IAMPlayListItem>, pdwflags: *mut u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetNamedEvent)(windows_core::Interface::as_raw(self), pwszeventname.param().abi(), dwitemindex, core::mem::transmute(ppitem), pdwflags as _).ok() }
    }
    pub unsafe fn GetRepeatInfo(&self, pdwrepeatcount: *mut u32, pdwrepeatstart: *mut u32, pdwrepeatend: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRepeatInfo)(windows_core::Interface::as_raw(self), pdwrepeatcount as _, pdwrepeatstart as _, pdwrepeatend as _).ok() }
    }
}
#[repr(C)]
pub struct IAMPlayList_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetItemCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetItem: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetNamedEvent: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, u32, *mut *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetRepeatInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
}
pub trait IAMPlayList_Impl: windows_core::IUnknownImpl {
    fn GetFlags(&self) -> windows_core::Result<u32>;
    fn GetItemCount(&self) -> windows_core::Result<u32>;
    fn GetItem(&self, dwitemindex: u32) -> windows_core::Result<IAMPlayListItem>;
    fn GetNamedEvent(&self, pwszeventname: &windows_core::PCWSTR, dwitemindex: u32, ppitem: windows_core::OutRef<'_, IAMPlayListItem>, pdwflags: *mut u32) -> windows_core::Result<()>;
    fn GetRepeatInfo(&self, pdwrepeatcount: *mut u32, pdwrepeatstart: *mut u32, pdwrepeatend: *mut u32) -> windows_core::Result<()>;
}
impl IAMPlayList_Vtbl {
    pub const fn new<Identity: IAMPlayList_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetFlags<Identity: IAMPlayList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwflags: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPlayList_Impl::GetFlags(this) {
                    Ok(ok__) => {
                        pdwflags.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetItemCount<Identity: IAMPlayList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwitems: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPlayList_Impl::GetItemCount(this) {
                    Ok(ok__) => {
                        pdwitems.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetItem<Identity: IAMPlayList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwitemindex: u32, ppitem: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPlayList_Impl::GetItem(this, core::mem::transmute_copy(&dwitemindex)) {
                    Ok(ok__) => {
                        ppitem.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetNamedEvent<Identity: IAMPlayList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwszeventname: windows_core::PCWSTR, dwitemindex: u32, ppitem: *mut *mut core::ffi::c_void, pdwflags: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMPlayList_Impl::GetNamedEvent(this, core::mem::transmute(&pwszeventname), core::mem::transmute_copy(&dwitemindex), core::mem::transmute_copy(&ppitem), core::mem::transmute_copy(&pdwflags)).into()
            }
        }
        unsafe extern "system" fn GetRepeatInfo<Identity: IAMPlayList_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwrepeatcount: *mut u32, pdwrepeatstart: *mut u32, pdwrepeatend: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMPlayList_Impl::GetRepeatInfo(this, core::mem::transmute_copy(&pdwrepeatcount), core::mem::transmute_copy(&pdwrepeatstart), core::mem::transmute_copy(&pdwrepeatend)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetFlags: GetFlags::<Identity, OFFSET>,
            GetItemCount: GetItemCount::<Identity, OFFSET>,
            GetItem: GetItem::<Identity, OFFSET>,
            GetNamedEvent: GetNamedEvent::<Identity, OFFSET>,
            GetRepeatInfo: GetRepeatInfo::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMPlayList as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMPlayList {}
windows_core::imp::define_interface!(IAMPlayListItem, IAMPlayListItem_Vtbl, 0x56a868ff_0ad4_11ce_b03a_0020af0ba770);
windows_core::imp::interface_hierarchy!(IAMPlayListItem, windows_core::IUnknown);
impl IAMPlayListItem {
    pub unsafe fn GetFlags(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetSourceCount(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSourceCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetSourceURL(&self, dwsourceindex: u32) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSourceURL)(windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetSourceStart(&self, dwsourceindex: u32) -> windows_core::Result<i64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSourceStart)(windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetSourceDuration(&self, dwsourceindex: u32) -> windows_core::Result<i64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSourceDuration)(windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetSourceStartMarker(&self, dwsourceindex: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSourceStartMarker)(windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetSourceEndMarker(&self, dwsourceindex: u32) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSourceEndMarker)(windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetSourceStartMarkerName(&self, dwsourceindex: u32) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSourceStartMarkerName)(windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetSourceEndMarkerName(&self, dwsourceindex: u32) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetSourceEndMarkerName)(windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetLinkURL(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetLinkURL)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetScanDuration(&self, dwsourceindex: u32) -> windows_core::Result<i64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetScanDuration)(windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAMPlayListItem_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSourceCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetSourceURL: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetSourceStart: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut i64) -> windows_core::HRESULT,
    pub GetSourceDuration: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut i64) -> windows_core::HRESULT,
    pub GetSourceStartMarker: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSourceEndMarker: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub GetSourceStartMarkerName: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetSourceEndMarkerName: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetLinkURL: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetScanDuration: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut i64) -> windows_core::HRESULT,
}
pub trait IAMPlayListItem_Impl: windows_core::IUnknownImpl {
    fn GetFlags(&self) -> windows_core::Result<u32>;
    fn GetSourceCount(&self) -> windows_core::Result<u32>;
    fn GetSourceURL(&self, dwsourceindex: u32) -> windows_core::Result<windows_core::BSTR>;
    fn GetSourceStart(&self, dwsourceindex: u32) -> windows_core::Result<i64>;
    fn GetSourceDuration(&self, dwsourceindex: u32) -> windows_core::Result<i64>;
    fn GetSourceStartMarker(&self, dwsourceindex: u32) -> windows_core::Result<u32>;
    fn GetSourceEndMarker(&self, dwsourceindex: u32) -> windows_core::Result<u32>;
    fn GetSourceStartMarkerName(&self, dwsourceindex: u32) -> windows_core::Result<windows_core::BSTR>;
    fn GetSourceEndMarkerName(&self, dwsourceindex: u32) -> windows_core::Result<windows_core::BSTR>;
    fn GetLinkURL(&self) -> windows_core::Result<windows_core::BSTR>;
    fn GetScanDuration(&self, dwsourceindex: u32) -> windows_core::Result<i64>;
}
impl IAMPlayListItem_Vtbl {
    pub const fn new<Identity: IAMPlayListItem_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetFlags<Identity: IAMPlayListItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwflags: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPlayListItem_Impl::GetFlags(this) {
                    Ok(ok__) => {
                        pdwflags.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSourceCount<Identity: IAMPlayListItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwsources: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPlayListItem_Impl::GetSourceCount(this) {
                    Ok(ok__) => {
                        pdwsources.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSourceURL<Identity: IAMPlayListItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwsourceindex: u32, pbstrurl: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPlayListItem_Impl::GetSourceURL(this, core::mem::transmute_copy(&dwsourceindex)) {
                    Ok(ok__) => {
                        pbstrurl.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSourceStart<Identity: IAMPlayListItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwsourceindex: u32, prtstart: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPlayListItem_Impl::GetSourceStart(this, core::mem::transmute_copy(&dwsourceindex)) {
                    Ok(ok__) => {
                        prtstart.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSourceDuration<Identity: IAMPlayListItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwsourceindex: u32, prtduration: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPlayListItem_Impl::GetSourceDuration(this, core::mem::transmute_copy(&dwsourceindex)) {
                    Ok(ok__) => {
                        prtduration.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSourceStartMarker<Identity: IAMPlayListItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwsourceindex: u32, pdwmarker: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPlayListItem_Impl::GetSourceStartMarker(this, core::mem::transmute_copy(&dwsourceindex)) {
                    Ok(ok__) => {
                        pdwmarker.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSourceEndMarker<Identity: IAMPlayListItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwsourceindex: u32, pdwmarker: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPlayListItem_Impl::GetSourceEndMarker(this, core::mem::transmute_copy(&dwsourceindex)) {
                    Ok(ok__) => {
                        pdwmarker.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSourceStartMarkerName<Identity: IAMPlayListItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwsourceindex: u32, pbstrstartmarker: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPlayListItem_Impl::GetSourceStartMarkerName(this, core::mem::transmute_copy(&dwsourceindex)) {
                    Ok(ok__) => {
                        pbstrstartmarker.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetSourceEndMarkerName<Identity: IAMPlayListItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwsourceindex: u32, pbstrendmarker: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPlayListItem_Impl::GetSourceEndMarkerName(this, core::mem::transmute_copy(&dwsourceindex)) {
                    Ok(ok__) => {
                        pbstrendmarker.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetLinkURL<Identity: IAMPlayListItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrurl: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPlayListItem_Impl::GetLinkURL(this) {
                    Ok(ok__) => {
                        pbstrurl.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetScanDuration<Identity: IAMPlayListItem_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwsourceindex: u32, prtscanduration: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPlayListItem_Impl::GetScanDuration(this, core::mem::transmute_copy(&dwsourceindex)) {
                    Ok(ok__) => {
                        prtscanduration.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetFlags: GetFlags::<Identity, OFFSET>,
            GetSourceCount: GetSourceCount::<Identity, OFFSET>,
            GetSourceURL: GetSourceURL::<Identity, OFFSET>,
            GetSourceStart: GetSourceStart::<Identity, OFFSET>,
            GetSourceDuration: GetSourceDuration::<Identity, OFFSET>,
            GetSourceStartMarker: GetSourceStartMarker::<Identity, OFFSET>,
            GetSourceEndMarker: GetSourceEndMarker::<Identity, OFFSET>,
            GetSourceStartMarkerName: GetSourceStartMarkerName::<Identity, OFFSET>,
            GetSourceEndMarkerName: GetSourceEndMarkerName::<Identity, OFFSET>,
            GetLinkURL: GetLinkURL::<Identity, OFFSET>,
            GetScanDuration: GetScanDuration::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMPlayListItem as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMPlayListItem {}
windows_core::imp::define_interface!(IAMPluginControl, IAMPluginControl_Vtbl, 0x0e26a181_f40c_4635_8786_976284b52981);
windows_core::imp::interface_hierarchy!(IAMPluginControl, windows_core::IUnknown);
impl IAMPluginControl {
    pub unsafe fn GetPreferredClsid(&self, subtype: *const windows_core::GUID) -> windows_core::Result<windows_core::GUID> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPreferredClsid)(windows_core::Interface::as_raw(self), subtype, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetPreferredClsidByIndex(&self, index: u32, subtype: *mut windows_core::GUID, clsid: *mut windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetPreferredClsidByIndex)(windows_core::Interface::as_raw(self), index, subtype as _, clsid as _).ok() }
    }
    pub unsafe fn SetPreferredClsid(&self, subtype: *const windows_core::GUID, clsid: Option<*const windows_core::GUID>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPreferredClsid)(windows_core::Interface::as_raw(self), subtype, clsid.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn IsDisabled(&self, clsid: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IsDisabled)(windows_core::Interface::as_raw(self), clsid).ok() }
    }
    pub unsafe fn GetDisabledByIndex(&self, index: u32) -> windows_core::Result<windows_core::GUID> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetDisabledByIndex)(windows_core::Interface::as_raw(self), index, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetDisabled(&self, clsid: *const windows_core::GUID, disabled: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDisabled)(windows_core::Interface::as_raw(self), clsid, disabled.into()).ok() }
    }
    pub unsafe fn IsLegacyDisabled<P0>(&self, dllname: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).IsLegacyDisabled)(windows_core::Interface::as_raw(self), dllname.param().abi()).ok() }
    }
}
#[repr(C)]
pub struct IAMPluginControl_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetPreferredClsid: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub GetPreferredClsidByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::GUID, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub SetPreferredClsid: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const windows_core::GUID) -> windows_core::HRESULT,
    pub IsDisabled: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub GetDisabledByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub SetDisabled: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, windows_core::BOOL) -> windows_core::HRESULT,
    pub IsLegacyDisabled: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
}
pub trait IAMPluginControl_Impl: windows_core::IUnknownImpl {
    fn GetPreferredClsid(&self, subtype: *const windows_core::GUID) -> windows_core::Result<windows_core::GUID>;
    fn GetPreferredClsidByIndex(&self, index: u32, subtype: *mut windows_core::GUID, clsid: *mut windows_core::GUID) -> windows_core::Result<()>;
    fn SetPreferredClsid(&self, subtype: *const windows_core::GUID, clsid: *const windows_core::GUID) -> windows_core::Result<()>;
    fn IsDisabled(&self, clsid: *const windows_core::GUID) -> windows_core::Result<()>;
    fn GetDisabledByIndex(&self, index: u32) -> windows_core::Result<windows_core::GUID>;
    fn SetDisabled(&self, clsid: *const windows_core::GUID, disabled: windows_core::BOOL) -> windows_core::Result<()>;
    fn IsLegacyDisabled(&self, dllname: &windows_core::PCWSTR) -> windows_core::Result<()>;
}
impl IAMPluginControl_Vtbl {
    pub const fn new<Identity: IAMPluginControl_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetPreferredClsid<Identity: IAMPluginControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, subtype: *const windows_core::GUID, clsid: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPluginControl_Impl::GetPreferredClsid(this, core::mem::transmute_copy(&subtype)) {
                    Ok(ok__) => {
                        clsid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetPreferredClsidByIndex<Identity: IAMPluginControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: u32, subtype: *mut windows_core::GUID, clsid: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMPluginControl_Impl::GetPreferredClsidByIndex(this, core::mem::transmute_copy(&index), core::mem::transmute_copy(&subtype), core::mem::transmute_copy(&clsid)).into()
            }
        }
        unsafe extern "system" fn SetPreferredClsid<Identity: IAMPluginControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, subtype: *const windows_core::GUID, clsid: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMPluginControl_Impl::SetPreferredClsid(this, core::mem::transmute_copy(&subtype), core::mem::transmute_copy(&clsid)).into()
            }
        }
        unsafe extern "system" fn IsDisabled<Identity: IAMPluginControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, clsid: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMPluginControl_Impl::IsDisabled(this, core::mem::transmute_copy(&clsid)).into()
            }
        }
        unsafe extern "system" fn GetDisabledByIndex<Identity: IAMPluginControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, index: u32, clsid: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPluginControl_Impl::GetDisabledByIndex(this, core::mem::transmute_copy(&index)) {
                    Ok(ok__) => {
                        clsid.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetDisabled<Identity: IAMPluginControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, clsid: *const windows_core::GUID, disabled: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMPluginControl_Impl::SetDisabled(this, core::mem::transmute_copy(&clsid), core::mem::transmute_copy(&disabled)).into()
            }
        }
        unsafe extern "system" fn IsLegacyDisabled<Identity: IAMPluginControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dllname: windows_core::PCWSTR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMPluginControl_Impl::IsLegacyDisabled(this, core::mem::transmute(&dllname)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetPreferredClsid: GetPreferredClsid::<Identity, OFFSET>,
            GetPreferredClsidByIndex: GetPreferredClsidByIndex::<Identity, OFFSET>,
            SetPreferredClsid: SetPreferredClsid::<Identity, OFFSET>,
            IsDisabled: IsDisabled::<Identity, OFFSET>,
            GetDisabledByIndex: GetDisabledByIndex::<Identity, OFFSET>,
            SetDisabled: SetDisabled::<Identity, OFFSET>,
            IsLegacyDisabled: IsLegacyDisabled::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMPluginControl as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMPluginControl {}
windows_core::imp::define_interface!(IAMPushSource, IAMPushSource_Vtbl, 0xf185fe76_e64e_11d2_b76e_00c04fb6bd3d);
impl core::ops::Deref for IAMPushSource {
    type Target = IAMLatency;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAMPushSource, windows_core::IUnknown, IAMLatency);
impl IAMPushSource {
    pub unsafe fn GetPushSourceFlags(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPushSourceFlags)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetPushSourceFlags(&self, flags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPushSourceFlags)(windows_core::Interface::as_raw(self), flags).ok() }
    }
    pub unsafe fn SetStreamOffset(&self, rtoffset: i64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetStreamOffset)(windows_core::Interface::as_raw(self), rtoffset).ok() }
    }
    pub unsafe fn GetStreamOffset(&self) -> windows_core::Result<i64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetStreamOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetMaxStreamOffset(&self) -> windows_core::Result<i64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetMaxStreamOffset)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMaxStreamOffset(&self, rtmaxoffset: i64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMaxStreamOffset)(windows_core::Interface::as_raw(self), rtmaxoffset).ok() }
    }
}
#[repr(C)]
pub struct IAMPushSource_Vtbl {
    pub base__: IAMLatency_Vtbl,
    pub GetPushSourceFlags: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetPushSourceFlags: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetStreamOffset: unsafe extern "system" fn(*mut core::ffi::c_void, i64) -> windows_core::HRESULT,
    pub GetStreamOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i64) -> windows_core::HRESULT,
    pub GetMaxStreamOffset: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i64) -> windows_core::HRESULT,
    pub SetMaxStreamOffset: unsafe extern "system" fn(*mut core::ffi::c_void, i64) -> windows_core::HRESULT,
}
pub trait IAMPushSource_Impl: IAMLatency_Impl {
    fn GetPushSourceFlags(&self) -> windows_core::Result<u32>;
    fn SetPushSourceFlags(&self, flags: u32) -> windows_core::Result<()>;
    fn SetStreamOffset(&self, rtoffset: i64) -> windows_core::Result<()>;
    fn GetStreamOffset(&self) -> windows_core::Result<i64>;
    fn GetMaxStreamOffset(&self) -> windows_core::Result<i64>;
    fn SetMaxStreamOffset(&self, rtmaxoffset: i64) -> windows_core::Result<()>;
}
impl IAMPushSource_Vtbl {
    pub const fn new<Identity: IAMPushSource_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetPushSourceFlags<Identity: IAMPushSource_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pflags: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPushSource_Impl::GetPushSourceFlags(this) {
                    Ok(ok__) => {
                        pflags.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetPushSourceFlags<Identity: IAMPushSource_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMPushSource_Impl::SetPushSourceFlags(this, core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn SetStreamOffset<Identity: IAMPushSource_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, rtoffset: i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMPushSource_Impl::SetStreamOffset(this, core::mem::transmute_copy(&rtoffset)).into()
            }
        }
        unsafe extern "system" fn GetStreamOffset<Identity: IAMPushSource_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prtoffset: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPushSource_Impl::GetStreamOffset(this) {
                    Ok(ok__) => {
                        prtoffset.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetMaxStreamOffset<Identity: IAMPushSource_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prtmaxoffset: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMPushSource_Impl::GetMaxStreamOffset(this) {
                    Ok(ok__) => {
                        prtmaxoffset.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMaxStreamOffset<Identity: IAMPushSource_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, rtmaxoffset: i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMPushSource_Impl::SetMaxStreamOffset(this, core::mem::transmute_copy(&rtmaxoffset)).into()
            }
        }
        Self {
            base__: IAMLatency_Vtbl::new::<Identity, OFFSET>(),
            GetPushSourceFlags: GetPushSourceFlags::<Identity, OFFSET>,
            SetPushSourceFlags: SetPushSourceFlags::<Identity, OFFSET>,
            SetStreamOffset: SetStreamOffset::<Identity, OFFSET>,
            GetStreamOffset: GetStreamOffset::<Identity, OFFSET>,
            GetMaxStreamOffset: GetMaxStreamOffset::<Identity, OFFSET>,
            SetMaxStreamOffset: SetMaxStreamOffset::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMPushSource as windows_core::Interface>::IID || iid == &<IAMLatency as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMPushSource {}
windows_core::imp::define_interface!(IAMRebuild, IAMRebuild_Vtbl, 0x02ef04dd_7580_11d1_bece_00c04fb6e937);
windows_core::imp::interface_hierarchy!(IAMRebuild, windows_core::IUnknown);
impl IAMRebuild {
    pub unsafe fn RebuildNow(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RebuildNow)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
pub struct IAMRebuild_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub RebuildNow: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAMRebuild_Impl: windows_core::IUnknownImpl {
    fn RebuildNow(&self) -> windows_core::Result<()>;
}
impl IAMRebuild_Vtbl {
    pub const fn new<Identity: IAMRebuild_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn RebuildNow<Identity: IAMRebuild_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMRebuild_Impl::RebuildNow(this).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), RebuildNow: RebuildNow::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMRebuild as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMRebuild {}
windows_core::imp::define_interface!(IAMResourceControl, IAMResourceControl_Vtbl, 0x8389d2d0_77d7_11d1_abe6_00a0c905f375);
windows_core::imp::interface_hierarchy!(IAMResourceControl, windows_core::IUnknown);
impl IAMResourceControl {
    pub unsafe fn Reserve(&self, dwflags: u32, pvreserved: Option<*const core::ffi::c_void>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Reserve)(windows_core::Interface::as_raw(self), dwflags, pvreserved.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
}
#[repr(C)]
pub struct IAMResourceControl_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Reserve: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAMResourceControl_Impl: windows_core::IUnknownImpl {
    fn Reserve(&self, dwflags: u32, pvreserved: *const core::ffi::c_void) -> windows_core::Result<()>;
}
impl IAMResourceControl_Vtbl {
    pub const fn new<Identity: IAMResourceControl_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Reserve<Identity: IAMResourceControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwflags: u32, pvreserved: *const core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMResourceControl_Impl::Reserve(this, core::mem::transmute_copy(&dwflags), core::mem::transmute_copy(&pvreserved)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Reserve: Reserve::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMResourceControl as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMResourceControl {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IAMStats, IAMStats_Vtbl, 0xbc9bcf80_dcd2_11d2_abf6_00a0c905f375);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IAMStats {
    type Target = super::super::System::Com::IDispatch;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IAMStats, windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl IAMStats {
    pub unsafe fn Reset(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Reset)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Count(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Count)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetValueByIndex(&self, lindex: i32, szname: *mut windows_core::BSTR, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetValueByIndex)(windows_core::Interface::as_raw(self), lindex, core::mem::transmute(szname), lcount as _, dlast as _, daverage as _, dstddev as _, dmin as _, dmax as _).ok() }
    }
    pub unsafe fn GetValueByName(&self, szname: &windows_core::BSTR, lindex: *mut i32, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetValueByName)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(szname), lindex as _, lcount as _, dlast as _, daverage as _, dstddev as _, dmin as _, dmax as _).ok() }
    }
    pub unsafe fn GetIndex(&self, szname: &windows_core::BSTR, lcreate: i32) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetIndex)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(szname), lcreate, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn AddValue(&self, lindex: i32, dvalue: f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddValue)(windows_core::Interface::as_raw(self), lindex, dvalue).ok() }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IAMStats_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Reset: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Count: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub GetValueByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut *mut core::ffi::c_void, *mut i32, *mut f64, *mut f64, *mut f64, *mut f64, *mut f64) -> windows_core::HRESULT,
    pub GetValueByName: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut i32, *mut i32, *mut f64, *mut f64, *mut f64, *mut f64, *mut f64) -> windows_core::HRESULT,
    pub GetIndex: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, i32, *mut i32) -> windows_core::HRESULT,
    pub AddValue: unsafe extern "system" fn(*mut core::ffi::c_void, i32, f64) -> windows_core::HRESULT,
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IAMStats_Impl: super::super::System::Com::IDispatch_Impl {
    fn Reset(&self) -> windows_core::Result<()>;
    fn Count(&self) -> windows_core::Result<i32>;
    fn GetValueByIndex(&self, lindex: i32, szname: *mut windows_core::BSTR, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> windows_core::Result<()>;
    fn GetValueByName(&self, szname: &windows_core::BSTR, lindex: *mut i32, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> windows_core::Result<()>;
    fn GetIndex(&self, szname: &windows_core::BSTR, lcreate: i32) -> windows_core::Result<i32>;
    fn AddValue(&self, lindex: i32, dvalue: f64) -> windows_core::Result<()>;
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IAMStats_Vtbl {
    pub const fn new<Identity: IAMStats_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Reset<Identity: IAMStats_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMStats_Impl::Reset(this).into()
            }
        }
        unsafe extern "system" fn Count<Identity: IAMStats_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plcount: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMStats_Impl::Count(this) {
                    Ok(ok__) => {
                        plcount.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetValueByIndex<Identity: IAMStats_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lindex: i32, szname: *mut *mut core::ffi::c_void, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMStats_Impl::GetValueByIndex(this, core::mem::transmute_copy(&lindex), core::mem::transmute_copy(&szname), core::mem::transmute_copy(&lcount), core::mem::transmute_copy(&dlast), core::mem::transmute_copy(&daverage), core::mem::transmute_copy(&dstddev), core::mem::transmute_copy(&dmin), core::mem::transmute_copy(&dmax)).into()
            }
        }
        unsafe extern "system" fn GetValueByName<Identity: IAMStats_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, szname: *mut core::ffi::c_void, lindex: *mut i32, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMStats_Impl::GetValueByName(this, core::mem::transmute(&szname), core::mem::transmute_copy(&lindex), core::mem::transmute_copy(&lcount), core::mem::transmute_copy(&dlast), core::mem::transmute_copy(&daverage), core::mem::transmute_copy(&dstddev), core::mem::transmute_copy(&dmin), core::mem::transmute_copy(&dmax)).into()
            }
        }
        unsafe extern "system" fn GetIndex<Identity: IAMStats_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, szname: *mut core::ffi::c_void, lcreate: i32, plindex: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMStats_Impl::GetIndex(this, core::mem::transmute(&szname), core::mem::transmute_copy(&lcreate)) {
                    Ok(ok__) => {
                        plindex.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn AddValue<Identity: IAMStats_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lindex: i32, dvalue: f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMStats_Impl::AddValue(this, core::mem::transmute_copy(&lindex), core::mem::transmute_copy(&dvalue)).into()
            }
        }
        Self {
            base__: super::super::System::Com::IDispatch_Vtbl::new::<Identity, OFFSET>(),
            Reset: Reset::<Identity, OFFSET>,
            Count: Count::<Identity, OFFSET>,
            GetValueByIndex: GetValueByIndex::<Identity, OFFSET>,
            GetValueByName: GetValueByName::<Identity, OFFSET>,
            GetIndex: GetIndex::<Identity, OFFSET>,
            AddValue: AddValue::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMStats as windows_core::Interface>::IID || iid == &<super::super::System::Com::IDispatch as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IAMStats {}
windows_core::imp::define_interface!(IAMStreamConfig, IAMStreamConfig_Vtbl, 0xc6e13340_30ac_11d0_a18c_00a0c9118956);
windows_core::imp::interface_hierarchy!(IAMStreamConfig, windows_core::IUnknown);
impl IAMStreamConfig {
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetFormat(&self, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFormat)(windows_core::Interface::as_raw(self), core::mem::transmute(pmt)).ok() }
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn GetFormat(&self) -> windows_core::Result<*mut super::MediaFoundation::AM_MEDIA_TYPE> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetFormat)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetNumberOfCapabilities(&self, picount: *mut i32, pisize: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetNumberOfCapabilities)(windows_core::Interface::as_raw(self), picount as _, pisize as _).ok() }
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn GetStreamCaps(&self, iindex: i32, ppmt: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, pscc: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetStreamCaps)(windows_core::Interface::as_raw(self), iindex, ppmt as _, pscc as _).ok() }
    }
}
#[repr(C)]
pub struct IAMStreamConfig_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub SetFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    SetFormat: usize,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub GetFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    GetFormat: usize,
    pub GetNumberOfCapabilities: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32, *mut i32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub GetStreamCaps: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, *mut u8) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    GetStreamCaps: usize,
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
pub trait IAMStreamConfig_Impl: windows_core::IUnknownImpl {
    fn SetFormat(&self, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::Result<()>;
    fn GetFormat(&self) -> windows_core::Result<*mut super::MediaFoundation::AM_MEDIA_TYPE>;
    fn GetNumberOfCapabilities(&self, picount: *mut i32, pisize: *mut i32) -> windows_core::Result<()>;
    fn GetStreamCaps(&self, iindex: i32, ppmt: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, pscc: *mut u8) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl IAMStreamConfig_Vtbl {
    pub const fn new<Identity: IAMStreamConfig_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetFormat<Identity: IAMStreamConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMStreamConfig_Impl::SetFormat(this, core::mem::transmute_copy(&pmt)).into()
            }
        }
        unsafe extern "system" fn GetFormat<Identity: IAMStreamConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppmt: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMStreamConfig_Impl::GetFormat(this) {
                    Ok(ok__) => {
                        ppmt.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetNumberOfCapabilities<Identity: IAMStreamConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, picount: *mut i32, pisize: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMStreamConfig_Impl::GetNumberOfCapabilities(this, core::mem::transmute_copy(&picount), core::mem::transmute_copy(&pisize)).into()
            }
        }
        unsafe extern "system" fn GetStreamCaps<Identity: IAMStreamConfig_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, iindex: i32, ppmt: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, pscc: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMStreamConfig_Impl::GetStreamCaps(this, core::mem::transmute_copy(&iindex), core::mem::transmute_copy(&ppmt), core::mem::transmute_copy(&pscc)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetFormat: SetFormat::<Identity, OFFSET>,
            GetFormat: GetFormat::<Identity, OFFSET>,
            GetNumberOfCapabilities: GetNumberOfCapabilities::<Identity, OFFSET>,
            GetStreamCaps: GetStreamCaps::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMStreamConfig as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl windows_core::RuntimeName for IAMStreamConfig {}
windows_core::imp::define_interface!(IAMStreamControl, IAMStreamControl_Vtbl, 0x36b73881_c2c8_11cf_8b46_00805f6cef60);
windows_core::imp::interface_hierarchy!(IAMStreamControl, windows_core::IUnknown);
impl IAMStreamControl {
    pub unsafe fn StartAt(&self, ptstart: Option<*const i64>, dwcookie: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).StartAt)(windows_core::Interface::as_raw(self), ptstart.unwrap_or(core::mem::zeroed()) as _, dwcookie).ok() }
    }
    pub unsafe fn StopAt(&self, ptstop: Option<*const i64>, bsendextra: bool, dwcookie: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).StopAt)(windows_core::Interface::as_raw(self), ptstop.unwrap_or(core::mem::zeroed()) as _, bsendextra.into(), dwcookie).ok() }
    }
    pub unsafe fn GetInfo(&self, pinfo: *mut AM_STREAM_INFO) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetInfo)(windows_core::Interface::as_raw(self), pinfo as _).ok() }
    }
}
#[repr(C)]
pub struct IAMStreamControl_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub StartAt: unsafe extern "system" fn(*mut core::ffi::c_void, *const i64, u32) -> windows_core::HRESULT,
    pub StopAt: unsafe extern "system" fn(*mut core::ffi::c_void, *const i64, windows_core::BOOL, u32) -> windows_core::HRESULT,
    pub GetInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut AM_STREAM_INFO) -> windows_core::HRESULT,
}
pub trait IAMStreamControl_Impl: windows_core::IUnknownImpl {
    fn StartAt(&self, ptstart: *const i64, dwcookie: u32) -> windows_core::Result<()>;
    fn StopAt(&self, ptstop: *const i64, bsendextra: windows_core::BOOL, dwcookie: u32) -> windows_core::Result<()>;
    fn GetInfo(&self, pinfo: *mut AM_STREAM_INFO) -> windows_core::Result<()>;
}
impl IAMStreamControl_Vtbl {
    pub const fn new<Identity: IAMStreamControl_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn StartAt<Identity: IAMStreamControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptstart: *const i64, dwcookie: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMStreamControl_Impl::StartAt(this, core::mem::transmute_copy(&ptstart), core::mem::transmute_copy(&dwcookie)).into()
            }
        }
        unsafe extern "system" fn StopAt<Identity: IAMStreamControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptstop: *const i64, bsendextra: windows_core::BOOL, dwcookie: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMStreamControl_Impl::StopAt(this, core::mem::transmute_copy(&ptstop), core::mem::transmute_copy(&bsendextra), core::mem::transmute_copy(&dwcookie)).into()
            }
        }
        unsafe extern "system" fn GetInfo<Identity: IAMStreamControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pinfo: *mut AM_STREAM_INFO) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMStreamControl_Impl::GetInfo(this, core::mem::transmute_copy(&pinfo)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            StartAt: StartAt::<Identity, OFFSET>,
            StopAt: StopAt::<Identity, OFFSET>,
            GetInfo: GetInfo::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMStreamControl as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMStreamControl {}
windows_core::imp::define_interface!(IAMStreamSelect, IAMStreamSelect_Vtbl, 0xc1960960_17f5_11d1_abe1_00a0c905f375);
windows_core::imp::interface_hierarchy!(IAMStreamSelect, windows_core::IUnknown);
impl IAMStreamSelect {
    pub unsafe fn Count(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Count)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn Info(&self, lindex: i32, ppmt: Option<*mut *mut super::MediaFoundation::AM_MEDIA_TYPE>, pdwflags: Option<*mut u32>, plcid: Option<*mut u32>, pdwgroup: Option<*mut u32>, ppszname: Option<*mut windows_core::PWSTR>, ppobject: Option<*mut Option<windows_core::IUnknown>>, ppunk: Option<*mut Option<windows_core::IUnknown>>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Info)(windows_core::Interface::as_raw(self), lindex, ppmt.unwrap_or(core::mem::zeroed()) as _, pdwflags.unwrap_or(core::mem::zeroed()) as _, plcid.unwrap_or(core::mem::zeroed()) as _, pdwgroup.unwrap_or(core::mem::zeroed()) as _, ppszname.unwrap_or(core::mem::zeroed()) as _, ppobject.unwrap_or(core::mem::zeroed()) as _, ppunk.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn Enable(&self, lindex: i32, dwflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Enable)(windows_core::Interface::as_raw(self), lindex, dwflags).ok() }
    }
}
#[repr(C)]
pub struct IAMStreamSelect_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Count: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub Info: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, *mut u32, *mut u32, *mut u32, *mut windows_core::PWSTR, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    Info: usize,
    pub Enable: unsafe extern "system" fn(*mut core::ffi::c_void, i32, u32) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
pub trait IAMStreamSelect_Impl: windows_core::IUnknownImpl {
    fn Count(&self) -> windows_core::Result<u32>;
    fn Info(&self, lindex: i32, ppmt: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, pdwflags: *mut u32, plcid: *mut u32, pdwgroup: *mut u32, ppszname: *mut windows_core::PWSTR, ppobject: windows_core::OutRef<'_, windows_core::IUnknown>, ppunk: windows_core::OutRef<'_, windows_core::IUnknown>) -> windows_core::Result<()>;
    fn Enable(&self, lindex: i32, dwflags: u32) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl IAMStreamSelect_Vtbl {
    pub const fn new<Identity: IAMStreamSelect_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Count<Identity: IAMStreamSelect_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcstreams: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMStreamSelect_Impl::Count(this) {
                    Ok(ok__) => {
                        pcstreams.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Info<Identity: IAMStreamSelect_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lindex: i32, ppmt: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, pdwflags: *mut u32, plcid: *mut u32, pdwgroup: *mut u32, ppszname: *mut windows_core::PWSTR, ppobject: *mut *mut core::ffi::c_void, ppunk: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMStreamSelect_Impl::Info(this, core::mem::transmute_copy(&lindex), core::mem::transmute_copy(&ppmt), core::mem::transmute_copy(&pdwflags), core::mem::transmute_copy(&plcid), core::mem::transmute_copy(&pdwgroup), core::mem::transmute_copy(&ppszname), core::mem::transmute_copy(&ppobject), core::mem::transmute_copy(&ppunk)).into()
            }
        }
        unsafe extern "system" fn Enable<Identity: IAMStreamSelect_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lindex: i32, dwflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMStreamSelect_Impl::Enable(this, core::mem::transmute_copy(&lindex), core::mem::transmute_copy(&dwflags)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Count: Count::<Identity, OFFSET>,
            Info: Info::<Identity, OFFSET>,
            Enable: Enable::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMStreamSelect as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl windows_core::RuntimeName for IAMStreamSelect {}
windows_core::imp::define_interface!(IAMTVAudio, IAMTVAudio_Vtbl, 0x83ec1c30_23d1_11d1_99e6_00a0c9560266);
windows_core::imp::interface_hierarchy!(IAMTVAudio, windows_core::IUnknown);
impl IAMTVAudio {
    pub unsafe fn GetHardwareSupportedTVAudioModes(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetHardwareSupportedTVAudioModes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetAvailableTVAudioModes(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetAvailableTVAudioModes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn TVAudioMode(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).TVAudioMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTVAudioMode(&self, lmode: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTVAudioMode)(windows_core::Interface::as_raw(self), lmode).ok() }
    }
    pub unsafe fn RegisterNotificationCallBack<P0>(&self, pnotify: P0, levents: i32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IAMTunerNotification>,
    {
        unsafe { (windows_core::Interface::vtable(self).RegisterNotificationCallBack)(windows_core::Interface::as_raw(self), pnotify.param().abi(), levents).ok() }
    }
    pub unsafe fn UnRegisterNotificationCallBack<P0>(&self, pnotify: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IAMTunerNotification>,
    {
        unsafe { (windows_core::Interface::vtable(self).UnRegisterNotificationCallBack)(windows_core::Interface::as_raw(self), pnotify.param().abi()).ok() }
    }
}
#[repr(C)]
pub struct IAMTVAudio_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetHardwareSupportedTVAudioModes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub GetAvailableTVAudioModes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub TVAudioMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetTVAudioMode: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub RegisterNotificationCallBack: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub UnRegisterNotificationCallBack: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAMTVAudio_Impl: windows_core::IUnknownImpl {
    fn GetHardwareSupportedTVAudioModes(&self) -> windows_core::Result<i32>;
    fn GetAvailableTVAudioModes(&self) -> windows_core::Result<i32>;
    fn TVAudioMode(&self) -> windows_core::Result<i32>;
    fn SetTVAudioMode(&self, lmode: i32) -> windows_core::Result<()>;
    fn RegisterNotificationCallBack(&self, pnotify: windows_core::Ref<'_, IAMTunerNotification>, levents: i32) -> windows_core::Result<()>;
    fn UnRegisterNotificationCallBack(&self, pnotify: windows_core::Ref<'_, IAMTunerNotification>) -> windows_core::Result<()>;
}
impl IAMTVAudio_Vtbl {
    pub const fn new<Identity: IAMTVAudio_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetHardwareSupportedTVAudioModes<Identity: IAMTVAudio_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plmodes: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTVAudio_Impl::GetHardwareSupportedTVAudioModes(this) {
                    Ok(ok__) => {
                        plmodes.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetAvailableTVAudioModes<Identity: IAMTVAudio_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plmodes: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTVAudio_Impl::GetAvailableTVAudioModes(this) {
                    Ok(ok__) => {
                        plmodes.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn TVAudioMode<Identity: IAMTVAudio_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plmode: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTVAudio_Impl::TVAudioMode(this) {
                    Ok(ok__) => {
                        plmode.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTVAudioMode<Identity: IAMTVAudio_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lmode: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTVAudio_Impl::SetTVAudioMode(this, core::mem::transmute_copy(&lmode)).into()
            }
        }
        unsafe extern "system" fn RegisterNotificationCallBack<Identity: IAMTVAudio_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pnotify: *mut core::ffi::c_void, levents: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTVAudio_Impl::RegisterNotificationCallBack(this, core::mem::transmute_copy(&pnotify), core::mem::transmute_copy(&levents)).into()
            }
        }
        unsafe extern "system" fn UnRegisterNotificationCallBack<Identity: IAMTVAudio_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pnotify: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTVAudio_Impl::UnRegisterNotificationCallBack(this, core::mem::transmute_copy(&pnotify)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetHardwareSupportedTVAudioModes: GetHardwareSupportedTVAudioModes::<Identity, OFFSET>,
            GetAvailableTVAudioModes: GetAvailableTVAudioModes::<Identity, OFFSET>,
            TVAudioMode: TVAudioMode::<Identity, OFFSET>,
            SetTVAudioMode: SetTVAudioMode::<Identity, OFFSET>,
            RegisterNotificationCallBack: RegisterNotificationCallBack::<Identity, OFFSET>,
            UnRegisterNotificationCallBack: UnRegisterNotificationCallBack::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMTVAudio as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMTVAudio {}
windows_core::imp::define_interface!(IAMTVAudioNotification, IAMTVAudioNotification_Vtbl, 0x83ec1c33_23d1_11d1_99e6_00a0c9560266);
windows_core::imp::interface_hierarchy!(IAMTVAudioNotification, windows_core::IUnknown);
impl IAMTVAudioNotification {
    pub unsafe fn OnEvent(&self, event: AMTVAudioEventType) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).OnEvent)(windows_core::Interface::as_raw(self), event).ok() }
    }
}
#[repr(C)]
pub struct IAMTVAudioNotification_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub OnEvent: unsafe extern "system" fn(*mut core::ffi::c_void, AMTVAudioEventType) -> windows_core::HRESULT,
}
pub trait IAMTVAudioNotification_Impl: windows_core::IUnknownImpl {
    fn OnEvent(&self, event: AMTVAudioEventType) -> windows_core::Result<()>;
}
impl IAMTVAudioNotification_Vtbl {
    pub const fn new<Identity: IAMTVAudioNotification_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn OnEvent<Identity: IAMTVAudioNotification_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, event: AMTVAudioEventType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTVAudioNotification_Impl::OnEvent(this, core::mem::transmute_copy(&event)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), OnEvent: OnEvent::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMTVAudioNotification as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMTVAudioNotification {}
windows_core::imp::define_interface!(IAMTVTuner, IAMTVTuner_Vtbl, 0x211a8766_03ac_11d1_8d13_00aa00bd8339);
impl core::ops::Deref for IAMTVTuner {
    type Target = IAMTuner;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAMTVTuner, windows_core::IUnknown, IAMTuner);
impl IAMTVTuner {
    pub unsafe fn AvailableTVFormats(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AvailableTVFormats)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn TVFormat(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).TVFormat)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn AutoTune(&self, lchannel: i32) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AutoTune)(windows_core::Interface::as_raw(self), lchannel, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn StoreAutoTune(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).StoreAutoTune)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn NumInputConnections(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).NumInputConnections)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn put_InputType(&self, lindex: i32, inputtype: TunerInputType) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).put_InputType)(windows_core::Interface::as_raw(self), lindex, inputtype).ok() }
    }
    pub unsafe fn get_InputType(&self, lindex: i32) -> windows_core::Result<TunerInputType> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).get_InputType)(windows_core::Interface::as_raw(self), lindex, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetConnectInput(&self, lindex: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetConnectInput)(windows_core::Interface::as_raw(self), lindex).ok() }
    }
    pub unsafe fn ConnectInput(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).ConnectInput)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn VideoFrequency(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).VideoFrequency)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn AudioFrequency(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AudioFrequency)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IAMTVTuner_Vtbl {
    pub base__: IAMTuner_Vtbl,
    pub AvailableTVFormats: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub TVFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub AutoTune: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32) -> windows_core::HRESULT,
    pub StoreAutoTune: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub NumInputConnections: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub put_InputType: unsafe extern "system" fn(*mut core::ffi::c_void, i32, TunerInputType) -> windows_core::HRESULT,
    pub get_InputType: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut TunerInputType) -> windows_core::HRESULT,
    pub SetConnectInput: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub ConnectInput: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub VideoFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub AudioFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
}
pub trait IAMTVTuner_Impl: IAMTuner_Impl {
    fn AvailableTVFormats(&self) -> windows_core::Result<i32>;
    fn TVFormat(&self) -> windows_core::Result<i32>;
    fn AutoTune(&self, lchannel: i32) -> windows_core::Result<i32>;
    fn StoreAutoTune(&self) -> windows_core::Result<()>;
    fn NumInputConnections(&self) -> windows_core::Result<i32>;
    fn put_InputType(&self, lindex: i32, inputtype: TunerInputType) -> windows_core::Result<()>;
    fn get_InputType(&self, lindex: i32) -> windows_core::Result<TunerInputType>;
    fn SetConnectInput(&self, lindex: i32) -> windows_core::Result<()>;
    fn ConnectInput(&self) -> windows_core::Result<i32>;
    fn VideoFrequency(&self) -> windows_core::Result<i32>;
    fn AudioFrequency(&self) -> windows_core::Result<i32>;
}
impl IAMTVTuner_Vtbl {
    pub const fn new<Identity: IAMTVTuner_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AvailableTVFormats<Identity: IAMTVTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lanalogvideostandard: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTVTuner_Impl::AvailableTVFormats(this) {
                    Ok(ok__) => {
                        lanalogvideostandard.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn TVFormat<Identity: IAMTVTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, planalogvideostandard: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTVTuner_Impl::TVFormat(this) {
                    Ok(ok__) => {
                        planalogvideostandard.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn AutoTune<Identity: IAMTVTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lchannel: i32, plfoundsignal: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTVTuner_Impl::AutoTune(this, core::mem::transmute_copy(&lchannel)) {
                    Ok(ok__) => {
                        plfoundsignal.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn StoreAutoTune<Identity: IAMTVTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTVTuner_Impl::StoreAutoTune(this).into()
            }
        }
        unsafe extern "system" fn NumInputConnections<Identity: IAMTVTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plnuminputconnections: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTVTuner_Impl::NumInputConnections(this) {
                    Ok(ok__) => {
                        plnuminputconnections.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn put_InputType<Identity: IAMTVTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lindex: i32, inputtype: TunerInputType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTVTuner_Impl::put_InputType(this, core::mem::transmute_copy(&lindex), core::mem::transmute_copy(&inputtype)).into()
            }
        }
        unsafe extern "system" fn get_InputType<Identity: IAMTVTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lindex: i32, pinputtype: *mut TunerInputType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTVTuner_Impl::get_InputType(this, core::mem::transmute_copy(&lindex)) {
                    Ok(ok__) => {
                        pinputtype.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetConnectInput<Identity: IAMTVTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lindex: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTVTuner_Impl::SetConnectInput(this, core::mem::transmute_copy(&lindex)).into()
            }
        }
        unsafe extern "system" fn ConnectInput<Identity: IAMTVTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plindex: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTVTuner_Impl::ConnectInput(this) {
                    Ok(ok__) => {
                        plindex.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn VideoFrequency<Identity: IAMTVTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lfreq: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTVTuner_Impl::VideoFrequency(this) {
                    Ok(ok__) => {
                        lfreq.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn AudioFrequency<Identity: IAMTVTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lfreq: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTVTuner_Impl::AudioFrequency(this) {
                    Ok(ok__) => {
                        lfreq.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: IAMTuner_Vtbl::new::<Identity, OFFSET>(),
            AvailableTVFormats: AvailableTVFormats::<Identity, OFFSET>,
            TVFormat: TVFormat::<Identity, OFFSET>,
            AutoTune: AutoTune::<Identity, OFFSET>,
            StoreAutoTune: StoreAutoTune::<Identity, OFFSET>,
            NumInputConnections: NumInputConnections::<Identity, OFFSET>,
            put_InputType: put_InputType::<Identity, OFFSET>,
            get_InputType: get_InputType::<Identity, OFFSET>,
            SetConnectInput: SetConnectInput::<Identity, OFFSET>,
            ConnectInput: ConnectInput::<Identity, OFFSET>,
            VideoFrequency: VideoFrequency::<Identity, OFFSET>,
            AudioFrequency: AudioFrequency::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMTVTuner as windows_core::Interface>::IID || iid == &<IAMTuner as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMTVTuner {}
windows_core::imp::define_interface!(IAMTimecodeDisplay, IAMTimecodeDisplay_Vtbl, 0x9b496ce2_811b_11cf_8c77_00aa006b6814);
windows_core::imp::interface_hierarchy!(IAMTimecodeDisplay, windows_core::IUnknown);
impl IAMTimecodeDisplay {
    pub unsafe fn GetTCDisplayEnable(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTCDisplayEnable)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTCDisplayEnable(&self, state: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTCDisplayEnable)(windows_core::Interface::as_raw(self), state).ok() }
    }
    pub unsafe fn GetTCDisplay(&self, param: i32) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTCDisplay)(windows_core::Interface::as_raw(self), param, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTCDisplay(&self, param: i32, value: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTCDisplay)(windows_core::Interface::as_raw(self), param, value).ok() }
    }
}
#[repr(C)]
pub struct IAMTimecodeDisplay_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTCDisplayEnable: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetTCDisplayEnable: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub GetTCDisplay: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32) -> windows_core::HRESULT,
    pub SetTCDisplay: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32) -> windows_core::HRESULT,
}
pub trait IAMTimecodeDisplay_Impl: windows_core::IUnknownImpl {
    fn GetTCDisplayEnable(&self) -> windows_core::Result<i32>;
    fn SetTCDisplayEnable(&self, state: i32) -> windows_core::Result<()>;
    fn GetTCDisplay(&self, param: i32) -> windows_core::Result<i32>;
    fn SetTCDisplay(&self, param: i32, value: i32) -> windows_core::Result<()>;
}
impl IAMTimecodeDisplay_Vtbl {
    pub const fn new<Identity: IAMTimecodeDisplay_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTCDisplayEnable<Identity: IAMTimecodeDisplay_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pstate: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTimecodeDisplay_Impl::GetTCDisplayEnable(this) {
                    Ok(ok__) => {
                        pstate.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTCDisplayEnable<Identity: IAMTimecodeDisplay_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, state: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTimecodeDisplay_Impl::SetTCDisplayEnable(this, core::mem::transmute_copy(&state)).into()
            }
        }
        unsafe extern "system" fn GetTCDisplay<Identity: IAMTimecodeDisplay_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, param: i32, pvalue: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTimecodeDisplay_Impl::GetTCDisplay(this, core::mem::transmute_copy(&param)) {
                    Ok(ok__) => {
                        pvalue.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTCDisplay<Identity: IAMTimecodeDisplay_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, param: i32, value: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTimecodeDisplay_Impl::SetTCDisplay(this, core::mem::transmute_copy(&param), core::mem::transmute_copy(&value)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTCDisplayEnable: GetTCDisplayEnable::<Identity, OFFSET>,
            SetTCDisplayEnable: SetTCDisplayEnable::<Identity, OFFSET>,
            GetTCDisplay: GetTCDisplay::<Identity, OFFSET>,
            SetTCDisplay: SetTCDisplay::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMTimecodeDisplay as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMTimecodeDisplay {}
windows_core::imp::define_interface!(IAMTimecodeGenerator, IAMTimecodeGenerator_Vtbl, 0x9b496ce0_811b_11cf_8c77_00aa006b6814);
windows_core::imp::interface_hierarchy!(IAMTimecodeGenerator, windows_core::IUnknown);
impl IAMTimecodeGenerator {
    pub unsafe fn GetTCGMode(&self, param: i32) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTCGMode)(windows_core::Interface::as_raw(self), param, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTCGMode(&self, param: i32, value: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTCGMode)(windows_core::Interface::as_raw(self), param, value).ok() }
    }
    pub unsafe fn SetVITCLine(&self, line: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetVITCLine)(windows_core::Interface::as_raw(self), line).ok() }
    }
    pub unsafe fn VITCLine(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).VITCLine)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTimecode(&self, ptimecodesample: *const super::TIMECODE_SAMPLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTimecode)(windows_core::Interface::as_raw(self), ptimecodesample).ok() }
    }
    pub unsafe fn GetTimecode(&self, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTimecode)(windows_core::Interface::as_raw(self), ptimecodesample as _).ok() }
    }
}
#[repr(C)]
pub struct IAMTimecodeGenerator_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTCGMode: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32) -> windows_core::HRESULT,
    pub SetTCGMode: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32) -> windows_core::HRESULT,
    pub SetVITCLine: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub VITCLine: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetTimecode: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::TIMECODE_SAMPLE) -> windows_core::HRESULT,
    pub GetTimecode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::TIMECODE_SAMPLE) -> windows_core::HRESULT,
}
pub trait IAMTimecodeGenerator_Impl: windows_core::IUnknownImpl {
    fn GetTCGMode(&self, param: i32) -> windows_core::Result<i32>;
    fn SetTCGMode(&self, param: i32, value: i32) -> windows_core::Result<()>;
    fn SetVITCLine(&self, line: i32) -> windows_core::Result<()>;
    fn VITCLine(&self) -> windows_core::Result<i32>;
    fn SetTimecode(&self, ptimecodesample: *const super::TIMECODE_SAMPLE) -> windows_core::Result<()>;
    fn GetTimecode(&self, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> windows_core::Result<()>;
}
impl IAMTimecodeGenerator_Vtbl {
    pub const fn new<Identity: IAMTimecodeGenerator_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTCGMode<Identity: IAMTimecodeGenerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, param: i32, pvalue: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTimecodeGenerator_Impl::GetTCGMode(this, core::mem::transmute_copy(&param)) {
                    Ok(ok__) => {
                        pvalue.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTCGMode<Identity: IAMTimecodeGenerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, param: i32, value: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTimecodeGenerator_Impl::SetTCGMode(this, core::mem::transmute_copy(&param), core::mem::transmute_copy(&value)).into()
            }
        }
        unsafe extern "system" fn SetVITCLine<Identity: IAMTimecodeGenerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, line: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTimecodeGenerator_Impl::SetVITCLine(this, core::mem::transmute_copy(&line)).into()
            }
        }
        unsafe extern "system" fn VITCLine<Identity: IAMTimecodeGenerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pline: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTimecodeGenerator_Impl::VITCLine(this) {
                    Ok(ok__) => {
                        pline.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTimecode<Identity: IAMTimecodeGenerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptimecodesample: *const super::TIMECODE_SAMPLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTimecodeGenerator_Impl::SetTimecode(this, core::mem::transmute_copy(&ptimecodesample)).into()
            }
        }
        unsafe extern "system" fn GetTimecode<Identity: IAMTimecodeGenerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTimecodeGenerator_Impl::GetTimecode(this, core::mem::transmute_copy(&ptimecodesample)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTCGMode: GetTCGMode::<Identity, OFFSET>,
            SetTCGMode: SetTCGMode::<Identity, OFFSET>,
            SetVITCLine: SetVITCLine::<Identity, OFFSET>,
            VITCLine: VITCLine::<Identity, OFFSET>,
            SetTimecode: SetTimecode::<Identity, OFFSET>,
            GetTimecode: GetTimecode::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMTimecodeGenerator as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMTimecodeGenerator {}
windows_core::imp::define_interface!(IAMTimecodeReader, IAMTimecodeReader_Vtbl, 0x9b496ce1_811b_11cf_8c77_00aa006b6814);
windows_core::imp::interface_hierarchy!(IAMTimecodeReader, windows_core::IUnknown);
impl IAMTimecodeReader {
    pub unsafe fn GetTCRMode(&self, param: i32) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTCRMode)(windows_core::Interface::as_raw(self), param, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTCRMode(&self, param: i32, value: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTCRMode)(windows_core::Interface::as_raw(self), param, value).ok() }
    }
    pub unsafe fn SetVITCLine(&self, line: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetVITCLine)(windows_core::Interface::as_raw(self), line).ok() }
    }
    pub unsafe fn VITCLine(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).VITCLine)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetTimecode(&self, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTimecode)(windows_core::Interface::as_raw(self), ptimecodesample as _).ok() }
    }
}
#[repr(C)]
pub struct IAMTimecodeReader_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetTCRMode: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32) -> windows_core::HRESULT,
    pub SetTCRMode: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32) -> windows_core::HRESULT,
    pub SetVITCLine: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub VITCLine: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub GetTimecode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::TIMECODE_SAMPLE) -> windows_core::HRESULT,
}
pub trait IAMTimecodeReader_Impl: windows_core::IUnknownImpl {
    fn GetTCRMode(&self, param: i32) -> windows_core::Result<i32>;
    fn SetTCRMode(&self, param: i32, value: i32) -> windows_core::Result<()>;
    fn SetVITCLine(&self, line: i32) -> windows_core::Result<()>;
    fn VITCLine(&self) -> windows_core::Result<i32>;
    fn GetTimecode(&self, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> windows_core::Result<()>;
}
impl IAMTimecodeReader_Vtbl {
    pub const fn new<Identity: IAMTimecodeReader_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetTCRMode<Identity: IAMTimecodeReader_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, param: i32, pvalue: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTimecodeReader_Impl::GetTCRMode(this, core::mem::transmute_copy(&param)) {
                    Ok(ok__) => {
                        pvalue.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTCRMode<Identity: IAMTimecodeReader_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, param: i32, value: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTimecodeReader_Impl::SetTCRMode(this, core::mem::transmute_copy(&param), core::mem::transmute_copy(&value)).into()
            }
        }
        unsafe extern "system" fn SetVITCLine<Identity: IAMTimecodeReader_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, line: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTimecodeReader_Impl::SetVITCLine(this, core::mem::transmute_copy(&line)).into()
            }
        }
        unsafe extern "system" fn VITCLine<Identity: IAMTimecodeReader_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pline: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTimecodeReader_Impl::VITCLine(this) {
                    Ok(ok__) => {
                        pline.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetTimecode<Identity: IAMTimecodeReader_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTimecodeReader_Impl::GetTimecode(this, core::mem::transmute_copy(&ptimecodesample)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetTCRMode: GetTCRMode::<Identity, OFFSET>,
            SetTCRMode: SetTCRMode::<Identity, OFFSET>,
            SetVITCLine: SetVITCLine::<Identity, OFFSET>,
            VITCLine: VITCLine::<Identity, OFFSET>,
            GetTimecode: GetTimecode::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMTimecodeReader as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMTimecodeReader {}
windows_core::imp::define_interface!(IAMTuner, IAMTuner_Vtbl, 0x211a8761_03ac_11d1_8d13_00aa00bd8339);
windows_core::imp::interface_hierarchy!(IAMTuner, windows_core::IUnknown);
impl IAMTuner {
    pub unsafe fn put_Channel(&self, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).put_Channel)(windows_core::Interface::as_raw(self), lchannel, lvideosubchannel, laudiosubchannel).ok() }
    }
    pub unsafe fn get_Channel(&self, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_Channel)(windows_core::Interface::as_raw(self), plchannel as _, plvideosubchannel as _, plaudiosubchannel as _).ok() }
    }
    pub unsafe fn ChannelMinMax(&self, lchannelmin: *mut i32, lchannelmax: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ChannelMinMax)(windows_core::Interface::as_raw(self), lchannelmin as _, lchannelmax as _).ok() }
    }
    pub unsafe fn SetCountryCode(&self, lcountrycode: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCountryCode)(windows_core::Interface::as_raw(self), lcountrycode).ok() }
    }
    pub unsafe fn CountryCode(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CountryCode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetTuningSpace(&self, ltuningspace: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTuningSpace)(windows_core::Interface::as_raw(self), ltuningspace).ok() }
    }
    pub unsafe fn TuningSpace(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).TuningSpace)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn Logon(&self, hcurrentuser: super::super::Foundation::HANDLE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Logon)(windows_core::Interface::as_raw(self), hcurrentuser).ok() }
    }
    pub unsafe fn Logout(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Logout)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn SignalPresent(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).SignalPresent)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMode(&self, lmode: AMTunerModeType) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMode)(windows_core::Interface::as_raw(self), lmode).ok() }
    }
    pub unsafe fn Mode(&self) -> windows_core::Result<AMTunerModeType> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Mode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetAvailableModes(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetAvailableModes)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn RegisterNotificationCallBack<P0>(&self, pnotify: P0, levents: i32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IAMTunerNotification>,
    {
        unsafe { (windows_core::Interface::vtable(self).RegisterNotificationCallBack)(windows_core::Interface::as_raw(self), pnotify.param().abi(), levents).ok() }
    }
    pub unsafe fn UnRegisterNotificationCallBack<P0>(&self, pnotify: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IAMTunerNotification>,
    {
        unsafe { (windows_core::Interface::vtable(self).UnRegisterNotificationCallBack)(windows_core::Interface::as_raw(self), pnotify.param().abi()).ok() }
    }
}
#[repr(C)]
pub struct IAMTuner_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub put_Channel: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32, i32) -> windows_core::HRESULT,
    pub get_Channel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32, *mut i32, *mut i32) -> windows_core::HRESULT,
    pub ChannelMinMax: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32, *mut i32) -> windows_core::HRESULT,
    pub SetCountryCode: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub CountryCode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetTuningSpace: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub TuningSpace: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub Logon: unsafe extern "system" fn(*mut core::ffi::c_void, super::super::Foundation::HANDLE) -> windows_core::HRESULT,
    pub Logout: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SignalPresent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMode: unsafe extern "system" fn(*mut core::ffi::c_void, AMTunerModeType) -> windows_core::HRESULT,
    pub Mode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut AMTunerModeType) -> windows_core::HRESULT,
    pub GetAvailableModes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub RegisterNotificationCallBack: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub UnRegisterNotificationCallBack: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAMTuner_Impl: windows_core::IUnknownImpl {
    fn put_Channel(&self, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> windows_core::Result<()>;
    fn get_Channel(&self, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> windows_core::Result<()>;
    fn ChannelMinMax(&self, lchannelmin: *mut i32, lchannelmax: *mut i32) -> windows_core::Result<()>;
    fn SetCountryCode(&self, lcountrycode: i32) -> windows_core::Result<()>;
    fn CountryCode(&self) -> windows_core::Result<i32>;
    fn SetTuningSpace(&self, ltuningspace: i32) -> windows_core::Result<()>;
    fn TuningSpace(&self) -> windows_core::Result<i32>;
    fn Logon(&self, hcurrentuser: super::super::Foundation::HANDLE) -> windows_core::Result<()>;
    fn Logout(&self) -> windows_core::Result<()>;
    fn SignalPresent(&self) -> windows_core::Result<i32>;
    fn SetMode(&self, lmode: AMTunerModeType) -> windows_core::Result<()>;
    fn Mode(&self) -> windows_core::Result<AMTunerModeType>;
    fn GetAvailableModes(&self) -> windows_core::Result<i32>;
    fn RegisterNotificationCallBack(&self, pnotify: windows_core::Ref<'_, IAMTunerNotification>, levents: i32) -> windows_core::Result<()>;
    fn UnRegisterNotificationCallBack(&self, pnotify: windows_core::Ref<'_, IAMTunerNotification>) -> windows_core::Result<()>;
}
impl IAMTuner_Vtbl {
    pub const fn new<Identity: IAMTuner_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn put_Channel<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTuner_Impl::put_Channel(this, core::mem::transmute_copy(&lchannel), core::mem::transmute_copy(&lvideosubchannel), core::mem::transmute_copy(&laudiosubchannel)).into()
            }
        }
        unsafe extern "system" fn get_Channel<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTuner_Impl::get_Channel(this, core::mem::transmute_copy(&plchannel), core::mem::transmute_copy(&plvideosubchannel), core::mem::transmute_copy(&plaudiosubchannel)).into()
            }
        }
        unsafe extern "system" fn ChannelMinMax<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lchannelmin: *mut i32, lchannelmax: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTuner_Impl::ChannelMinMax(this, core::mem::transmute_copy(&lchannelmin), core::mem::transmute_copy(&lchannelmax)).into()
            }
        }
        unsafe extern "system" fn SetCountryCode<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lcountrycode: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTuner_Impl::SetCountryCode(this, core::mem::transmute_copy(&lcountrycode)).into()
            }
        }
        unsafe extern "system" fn CountryCode<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plcountrycode: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTuner_Impl::CountryCode(this) {
                    Ok(ok__) => {
                        plcountrycode.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetTuningSpace<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ltuningspace: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTuner_Impl::SetTuningSpace(this, core::mem::transmute_copy(&ltuningspace)).into()
            }
        }
        unsafe extern "system" fn TuningSpace<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pltuningspace: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTuner_Impl::TuningSpace(this) {
                    Ok(ok__) => {
                        pltuningspace.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Logon<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hcurrentuser: super::super::Foundation::HANDLE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTuner_Impl::Logon(this, core::mem::transmute_copy(&hcurrentuser)).into()
            }
        }
        unsafe extern "system" fn Logout<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTuner_Impl::Logout(this).into()
            }
        }
        unsafe extern "system" fn SignalPresent<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plsignalstrength: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTuner_Impl::SignalPresent(this) {
                    Ok(ok__) => {
                        plsignalstrength.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMode<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lmode: AMTunerModeType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTuner_Impl::SetMode(this, core::mem::transmute_copy(&lmode)).into()
            }
        }
        unsafe extern "system" fn Mode<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plmode: *mut AMTunerModeType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTuner_Impl::Mode(this) {
                    Ok(ok__) => {
                        plmode.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetAvailableModes<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plmodes: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMTuner_Impl::GetAvailableModes(this) {
                    Ok(ok__) => {
                        plmodes.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn RegisterNotificationCallBack<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pnotify: *mut core::ffi::c_void, levents: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTuner_Impl::RegisterNotificationCallBack(this, core::mem::transmute_copy(&pnotify), core::mem::transmute_copy(&levents)).into()
            }
        }
        unsafe extern "system" fn UnRegisterNotificationCallBack<Identity: IAMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pnotify: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTuner_Impl::UnRegisterNotificationCallBack(this, core::mem::transmute_copy(&pnotify)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            put_Channel: put_Channel::<Identity, OFFSET>,
            get_Channel: get_Channel::<Identity, OFFSET>,
            ChannelMinMax: ChannelMinMax::<Identity, OFFSET>,
            SetCountryCode: SetCountryCode::<Identity, OFFSET>,
            CountryCode: CountryCode::<Identity, OFFSET>,
            SetTuningSpace: SetTuningSpace::<Identity, OFFSET>,
            TuningSpace: TuningSpace::<Identity, OFFSET>,
            Logon: Logon::<Identity, OFFSET>,
            Logout: Logout::<Identity, OFFSET>,
            SignalPresent: SignalPresent::<Identity, OFFSET>,
            SetMode: SetMode::<Identity, OFFSET>,
            Mode: Mode::<Identity, OFFSET>,
            GetAvailableModes: GetAvailableModes::<Identity, OFFSET>,
            RegisterNotificationCallBack: RegisterNotificationCallBack::<Identity, OFFSET>,
            UnRegisterNotificationCallBack: UnRegisterNotificationCallBack::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMTuner as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMTuner {}
windows_core::imp::define_interface!(IAMTunerNotification, IAMTunerNotification_Vtbl, 0x211a8760_03ac_11d1_8d13_00aa00bd8339);
windows_core::imp::interface_hierarchy!(IAMTunerNotification, windows_core::IUnknown);
impl IAMTunerNotification {
    pub unsafe fn OnEvent(&self, event: AMTunerEventType) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).OnEvent)(windows_core::Interface::as_raw(self), event).ok() }
    }
}
#[repr(C)]
pub struct IAMTunerNotification_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub OnEvent: unsafe extern "system" fn(*mut core::ffi::c_void, AMTunerEventType) -> windows_core::HRESULT,
}
pub trait IAMTunerNotification_Impl: windows_core::IUnknownImpl {
    fn OnEvent(&self, event: AMTunerEventType) -> windows_core::Result<()>;
}
impl IAMTunerNotification_Vtbl {
    pub const fn new<Identity: IAMTunerNotification_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn OnEvent<Identity: IAMTunerNotification_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, event: AMTunerEventType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMTunerNotification_Impl::OnEvent(this, core::mem::transmute_copy(&event)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), OnEvent: OnEvent::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMTunerNotification as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMTunerNotification {}
windows_core::imp::define_interface!(IAMVfwCaptureDialogs, IAMVfwCaptureDialogs_Vtbl, 0xd8d715a0_6e5e_11d0_b3f0_00aa003761c5);
windows_core::imp::interface_hierarchy!(IAMVfwCaptureDialogs, windows_core::IUnknown);
impl IAMVfwCaptureDialogs {
    pub unsafe fn HasDialog(&self, idialog: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).HasDialog)(windows_core::Interface::as_raw(self), idialog).ok() }
    }
    pub unsafe fn ShowDialog(&self, idialog: i32, hwnd: super::super::Foundation::HWND) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ShowDialog)(windows_core::Interface::as_raw(self), idialog, hwnd).ok() }
    }
    pub unsafe fn SendDriverMessage(&self, idialog: i32, umsg: i32, dw1: i32, dw2: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SendDriverMessage)(windows_core::Interface::as_raw(self), idialog, umsg, dw1, dw2).ok() }
    }
}
#[repr(C)]
pub struct IAMVfwCaptureDialogs_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub HasDialog: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub ShowDialog: unsafe extern "system" fn(*mut core::ffi::c_void, i32, super::super::Foundation::HWND) -> windows_core::HRESULT,
    pub SendDriverMessage: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32, i32, i32) -> windows_core::HRESULT,
}
pub trait IAMVfwCaptureDialogs_Impl: windows_core::IUnknownImpl {
    fn HasDialog(&self, idialog: i32) -> windows_core::Result<()>;
    fn ShowDialog(&self, idialog: i32, hwnd: super::super::Foundation::HWND) -> windows_core::Result<()>;
    fn SendDriverMessage(&self, idialog: i32, umsg: i32, dw1: i32, dw2: i32) -> windows_core::Result<()>;
}
impl IAMVfwCaptureDialogs_Vtbl {
    pub const fn new<Identity: IAMVfwCaptureDialogs_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn HasDialog<Identity: IAMVfwCaptureDialogs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, idialog: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVfwCaptureDialogs_Impl::HasDialog(this, core::mem::transmute_copy(&idialog)).into()
            }
        }
        unsafe extern "system" fn ShowDialog<Identity: IAMVfwCaptureDialogs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, idialog: i32, hwnd: super::super::Foundation::HWND) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVfwCaptureDialogs_Impl::ShowDialog(this, core::mem::transmute_copy(&idialog), core::mem::transmute_copy(&hwnd)).into()
            }
        }
        unsafe extern "system" fn SendDriverMessage<Identity: IAMVfwCaptureDialogs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, idialog: i32, umsg: i32, dw1: i32, dw2: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVfwCaptureDialogs_Impl::SendDriverMessage(this, core::mem::transmute_copy(&idialog), core::mem::transmute_copy(&umsg), core::mem::transmute_copy(&dw1), core::mem::transmute_copy(&dw2)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            HasDialog: HasDialog::<Identity, OFFSET>,
            ShowDialog: ShowDialog::<Identity, OFFSET>,
            SendDriverMessage: SendDriverMessage::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMVfwCaptureDialogs as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMVfwCaptureDialogs {}
windows_core::imp::define_interface!(IAMVfwCompressDialogs, IAMVfwCompressDialogs_Vtbl, 0xd8d715a3_6e5e_11d0_b3f0_00aa003761c5);
windows_core::imp::interface_hierarchy!(IAMVfwCompressDialogs, windows_core::IUnknown);
impl IAMVfwCompressDialogs {
    pub unsafe fn ShowDialog(&self, idialog: i32, hwnd: super::super::Foundation::HWND) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ShowDialog)(windows_core::Interface::as_raw(self), idialog, hwnd).ok() }
    }
    pub unsafe fn GetState(&self, pstate: *mut core::ffi::c_void, pcbstate: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetState)(windows_core::Interface::as_raw(self), pstate as _, pcbstate as _).ok() }
    }
    pub unsafe fn SetState(&self, pstate: *const core::ffi::c_void, cbstate: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetState)(windows_core::Interface::as_raw(self), pstate, cbstate).ok() }
    }
    pub unsafe fn SendDriverMessage(&self, umsg: i32, dw1: i32, dw2: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SendDriverMessage)(windows_core::Interface::as_raw(self), umsg, dw1, dw2).ok() }
    }
}
#[repr(C)]
pub struct IAMVfwCompressDialogs_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub ShowDialog: unsafe extern "system" fn(*mut core::ffi::c_void, i32, super::super::Foundation::HWND) -> windows_core::HRESULT,
    pub GetState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetState: unsafe extern "system" fn(*mut core::ffi::c_void, *const core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub SendDriverMessage: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32, i32) -> windows_core::HRESULT,
}
pub trait IAMVfwCompressDialogs_Impl: windows_core::IUnknownImpl {
    fn ShowDialog(&self, idialog: i32, hwnd: super::super::Foundation::HWND) -> windows_core::Result<()>;
    fn GetState(&self, pstate: *mut core::ffi::c_void, pcbstate: *mut i32) -> windows_core::Result<()>;
    fn SetState(&self, pstate: *const core::ffi::c_void, cbstate: i32) -> windows_core::Result<()>;
    fn SendDriverMessage(&self, umsg: i32, dw1: i32, dw2: i32) -> windows_core::Result<()>;
}
impl IAMVfwCompressDialogs_Vtbl {
    pub const fn new<Identity: IAMVfwCompressDialogs_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn ShowDialog<Identity: IAMVfwCompressDialogs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, idialog: i32, hwnd: super::super::Foundation::HWND) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVfwCompressDialogs_Impl::ShowDialog(this, core::mem::transmute_copy(&idialog), core::mem::transmute_copy(&hwnd)).into()
            }
        }
        unsafe extern "system" fn GetState<Identity: IAMVfwCompressDialogs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pstate: *mut core::ffi::c_void, pcbstate: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVfwCompressDialogs_Impl::GetState(this, core::mem::transmute_copy(&pstate), core::mem::transmute_copy(&pcbstate)).into()
            }
        }
        unsafe extern "system" fn SetState<Identity: IAMVfwCompressDialogs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pstate: *const core::ffi::c_void, cbstate: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVfwCompressDialogs_Impl::SetState(this, core::mem::transmute_copy(&pstate), core::mem::transmute_copy(&cbstate)).into()
            }
        }
        unsafe extern "system" fn SendDriverMessage<Identity: IAMVfwCompressDialogs_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, umsg: i32, dw1: i32, dw2: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVfwCompressDialogs_Impl::SendDriverMessage(this, core::mem::transmute_copy(&umsg), core::mem::transmute_copy(&dw1), core::mem::transmute_copy(&dw2)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            ShowDialog: ShowDialog::<Identity, OFFSET>,
            GetState: GetState::<Identity, OFFSET>,
            SetState: SetState::<Identity, OFFSET>,
            SendDriverMessage: SendDriverMessage::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMVfwCompressDialogs as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMVfwCompressDialogs {}
windows_core::imp::define_interface!(IAMVideoAccelerator, IAMVideoAccelerator_Vtbl, 0x256a6a22_fbad_11d1_82bf_00a0c9696c8f);
windows_core::imp::interface_hierarchy!(IAMVideoAccelerator, windows_core::IUnknown);
impl IAMVideoAccelerator {
    pub unsafe fn GetVideoAcceleratorGUIDs(&self, pdwnumguidssupported: *mut u32, pguidssupported: Option<*mut windows_core::GUID>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetVideoAcceleratorGUIDs)(windows_core::Interface::as_raw(self), pdwnumguidssupported as _, pguidssupported.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetUncompFormatsSupported(&self, pguid: *const windows_core::GUID, pdwnumformatssupported: *mut u32, pformatssupported: Option<*mut super::super::Graphics::DirectDraw::DDPIXELFORMAT>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetUncompFormatsSupported)(windows_core::Interface::as_raw(self), pguid, pdwnumformatssupported as _, pformatssupported.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetInternalMemInfo(&self, pguid: *const windows_core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pamvainternalmeminfo: *mut AMVAInternalMemInfo) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetInternalMemInfo)(windows_core::Interface::as_raw(self), pguid, pamvauncompdatainfo, pamvainternalmeminfo as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetCompBufferInfo(&self, pguid: *const windows_core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: Option<*mut AMVACompBufferInfo>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCompBufferInfo)(windows_core::Interface::as_raw(self), pguid, pamvauncompdatainfo, pdwnumtypescompbuffers as _, pamvacompbufferinfo.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetInternalCompBufferInfo(&self, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: Option<*mut AMVACompBufferInfo>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetInternalCompBufferInfo)(windows_core::Interface::as_raw(self), pdwnumtypescompbuffers as _, pamvacompbufferinfo.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn BeginFrame(&self, amvabeginframeinfo: *const AMVABeginFrameInfo) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).BeginFrame)(windows_core::Interface::as_raw(self), amvabeginframeinfo).ok() }
    }
    pub unsafe fn EndFrame(&self, pendframeinfo: *const AMVAEndFrameInfo) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndFrame)(windows_core::Interface::as_raw(self), pendframeinfo).ok() }
    }
    pub unsafe fn GetBuffer(&self, dwtypeindex: u32, dwbufferindex: u32, breadonly: bool, ppbuffer: *mut *mut core::ffi::c_void, lpstride: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetBuffer)(windows_core::Interface::as_raw(self), dwtypeindex, dwbufferindex, breadonly.into(), ppbuffer as _, lpstride as _).ok() }
    }
    pub unsafe fn ReleaseBuffer(&self, dwtypeindex: u32, dwbufferindex: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ReleaseBuffer)(windows_core::Interface::as_raw(self), dwtypeindex, dwbufferindex).ok() }
    }
    pub unsafe fn Execute(&self, dwfunction: u32, lpprivateinputdata: *const core::ffi::c_void, cbprivateinputdata: u32, lpprivateoutputdat: *const core::ffi::c_void, cbprivateoutputdata: u32, pamvabufferinfo: &[AMVABUFFERINFO]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Execute)(windows_core::Interface::as_raw(self), dwfunction, lpprivateinputdata, cbprivateinputdata, lpprivateoutputdat, cbprivateoutputdata, pamvabufferinfo.len().try_into().unwrap(), core::mem::transmute(pamvabufferinfo.as_ptr())).ok() }
    }
    pub unsafe fn QueryRenderStatus(&self, dwtypeindex: u32, dwbufferindex: u32, dwflags: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).QueryRenderStatus)(windows_core::Interface::as_raw(self), dwtypeindex, dwbufferindex, dwflags).ok() }
    }
    pub unsafe fn DisplayFrame<P1>(&self, dwfliptoindex: u32, pmediasample: P1) -> windows_core::Result<()>
    where
        P1: windows_core::Param<IMediaSample>,
    {
        unsafe { (windows_core::Interface::vtable(self).DisplayFrame)(windows_core::Interface::as_raw(self), dwfliptoindex, pmediasample.param().abi()).ok() }
    }
}
#[repr(C)]
pub struct IAMVideoAccelerator_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetVideoAcceleratorGUIDs: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut windows_core::GUID) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetUncompFormatsSupported: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut u32, *mut super::super::Graphics::DirectDraw::DDPIXELFORMAT) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetUncompFormatsSupported: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetInternalMemInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const AMVAUncompDataInfo, *mut AMVAInternalMemInfo) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetInternalMemInfo: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetCompBufferInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *const AMVAUncompDataInfo, *mut u32, *mut AMVACompBufferInfo) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetCompBufferInfo: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetInternalCompBufferInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut AMVACompBufferInfo) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetInternalCompBufferInfo: usize,
    pub BeginFrame: unsafe extern "system" fn(*mut core::ffi::c_void, *const AMVABeginFrameInfo) -> windows_core::HRESULT,
    pub EndFrame: unsafe extern "system" fn(*mut core::ffi::c_void, *const AMVAEndFrameInfo) -> windows_core::HRESULT,
    pub GetBuffer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, windows_core::BOOL, *mut *mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub ReleaseBuffer: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub Execute: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const core::ffi::c_void, u32, *const core::ffi::c_void, u32, u32, *const AMVABUFFERINFO) -> windows_core::HRESULT,
    pub QueryRenderStatus: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32) -> windows_core::HRESULT,
    pub DisplayFrame: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
pub trait IAMVideoAccelerator_Impl: windows_core::IUnknownImpl {
    fn GetVideoAcceleratorGUIDs(&self, pdwnumguidssupported: *mut u32, pguidssupported: *mut windows_core::GUID) -> windows_core::Result<()>;
    fn GetUncompFormatsSupported(&self, pguid: *const windows_core::GUID, pdwnumformatssupported: *mut u32, pformatssupported: *mut super::super::Graphics::DirectDraw::DDPIXELFORMAT) -> windows_core::Result<()>;
    fn GetInternalMemInfo(&self, pguid: *const windows_core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pamvainternalmeminfo: *mut AMVAInternalMemInfo) -> windows_core::Result<()>;
    fn GetCompBufferInfo(&self, pguid: *const windows_core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: *mut AMVACompBufferInfo) -> windows_core::Result<()>;
    fn GetInternalCompBufferInfo(&self, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: *mut AMVACompBufferInfo) -> windows_core::Result<()>;
    fn BeginFrame(&self, amvabeginframeinfo: *const AMVABeginFrameInfo) -> windows_core::Result<()>;
    fn EndFrame(&self, pendframeinfo: *const AMVAEndFrameInfo) -> windows_core::Result<()>;
    fn GetBuffer(&self, dwtypeindex: u32, dwbufferindex: u32, breadonly: windows_core::BOOL, ppbuffer: *mut *mut core::ffi::c_void, lpstride: *mut i32) -> windows_core::Result<()>;
    fn ReleaseBuffer(&self, dwtypeindex: u32, dwbufferindex: u32) -> windows_core::Result<()>;
    fn Execute(&self, dwfunction: u32, lpprivateinputdata: *const core::ffi::c_void, cbprivateinputdata: u32, lpprivateoutputdat: *const core::ffi::c_void, cbprivateoutputdata: u32, dwnumbuffers: u32, pamvabufferinfo: *const AMVABUFFERINFO) -> windows_core::Result<()>;
    fn QueryRenderStatus(&self, dwtypeindex: u32, dwbufferindex: u32, dwflags: u32) -> windows_core::Result<()>;
    fn DisplayFrame(&self, dwfliptoindex: u32, pmediasample: windows_core::Ref<'_, IMediaSample>) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl IAMVideoAccelerator_Vtbl {
    pub const fn new<Identity: IAMVideoAccelerator_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetVideoAcceleratorGUIDs<Identity: IAMVideoAccelerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwnumguidssupported: *mut u32, pguidssupported: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAccelerator_Impl::GetVideoAcceleratorGUIDs(this, core::mem::transmute_copy(&pdwnumguidssupported), core::mem::transmute_copy(&pguidssupported)).into()
            }
        }
        unsafe extern "system" fn GetUncompFormatsSupported<Identity: IAMVideoAccelerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguid: *const windows_core::GUID, pdwnumformatssupported: *mut u32, pformatssupported: *mut super::super::Graphics::DirectDraw::DDPIXELFORMAT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAccelerator_Impl::GetUncompFormatsSupported(this, core::mem::transmute_copy(&pguid), core::mem::transmute_copy(&pdwnumformatssupported), core::mem::transmute_copy(&pformatssupported)).into()
            }
        }
        unsafe extern "system" fn GetInternalMemInfo<Identity: IAMVideoAccelerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguid: *const windows_core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pamvainternalmeminfo: *mut AMVAInternalMemInfo) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAccelerator_Impl::GetInternalMemInfo(this, core::mem::transmute_copy(&pguid), core::mem::transmute_copy(&pamvauncompdatainfo), core::mem::transmute_copy(&pamvainternalmeminfo)).into()
            }
        }
        unsafe extern "system" fn GetCompBufferInfo<Identity: IAMVideoAccelerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguid: *const windows_core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: *mut AMVACompBufferInfo) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAccelerator_Impl::GetCompBufferInfo(this, core::mem::transmute_copy(&pguid), core::mem::transmute_copy(&pamvauncompdatainfo), core::mem::transmute_copy(&pdwnumtypescompbuffers), core::mem::transmute_copy(&pamvacompbufferinfo)).into()
            }
        }
        unsafe extern "system" fn GetInternalCompBufferInfo<Identity: IAMVideoAccelerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: *mut AMVACompBufferInfo) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAccelerator_Impl::GetInternalCompBufferInfo(this, core::mem::transmute_copy(&pdwnumtypescompbuffers), core::mem::transmute_copy(&pamvacompbufferinfo)).into()
            }
        }
        unsafe extern "system" fn BeginFrame<Identity: IAMVideoAccelerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, amvabeginframeinfo: *const AMVABeginFrameInfo) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAccelerator_Impl::BeginFrame(this, core::mem::transmute_copy(&amvabeginframeinfo)).into()
            }
        }
        unsafe extern "system" fn EndFrame<Identity: IAMVideoAccelerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pendframeinfo: *const AMVAEndFrameInfo) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAccelerator_Impl::EndFrame(this, core::mem::transmute_copy(&pendframeinfo)).into()
            }
        }
        unsafe extern "system" fn GetBuffer<Identity: IAMVideoAccelerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwtypeindex: u32, dwbufferindex: u32, breadonly: windows_core::BOOL, ppbuffer: *mut *mut core::ffi::c_void, lpstride: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAccelerator_Impl::GetBuffer(this, core::mem::transmute_copy(&dwtypeindex), core::mem::transmute_copy(&dwbufferindex), core::mem::transmute_copy(&breadonly), core::mem::transmute_copy(&ppbuffer), core::mem::transmute_copy(&lpstride)).into()
            }
        }
        unsafe extern "system" fn ReleaseBuffer<Identity: IAMVideoAccelerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwtypeindex: u32, dwbufferindex: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAccelerator_Impl::ReleaseBuffer(this, core::mem::transmute_copy(&dwtypeindex), core::mem::transmute_copy(&dwbufferindex)).into()
            }
        }
        unsafe extern "system" fn Execute<Identity: IAMVideoAccelerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwfunction: u32, lpprivateinputdata: *const core::ffi::c_void, cbprivateinputdata: u32, lpprivateoutputdat: *const core::ffi::c_void, cbprivateoutputdata: u32, dwnumbuffers: u32, pamvabufferinfo: *const AMVABUFFERINFO) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAccelerator_Impl::Execute(this, core::mem::transmute_copy(&dwfunction), core::mem::transmute_copy(&lpprivateinputdata), core::mem::transmute_copy(&cbprivateinputdata), core::mem::transmute_copy(&lpprivateoutputdat), core::mem::transmute_copy(&cbprivateoutputdata), core::mem::transmute_copy(&dwnumbuffers), core::mem::transmute_copy(&pamvabufferinfo)).into()
            }
        }
        unsafe extern "system" fn QueryRenderStatus<Identity: IAMVideoAccelerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwtypeindex: u32, dwbufferindex: u32, dwflags: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAccelerator_Impl::QueryRenderStatus(this, core::mem::transmute_copy(&dwtypeindex), core::mem::transmute_copy(&dwbufferindex), core::mem::transmute_copy(&dwflags)).into()
            }
        }
        unsafe extern "system" fn DisplayFrame<Identity: IAMVideoAccelerator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwfliptoindex: u32, pmediasample: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAccelerator_Impl::DisplayFrame(this, core::mem::transmute_copy(&dwfliptoindex), core::mem::transmute_copy(&pmediasample)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetVideoAcceleratorGUIDs: GetVideoAcceleratorGUIDs::<Identity, OFFSET>,
            GetUncompFormatsSupported: GetUncompFormatsSupported::<Identity, OFFSET>,
            GetInternalMemInfo: GetInternalMemInfo::<Identity, OFFSET>,
            GetCompBufferInfo: GetCompBufferInfo::<Identity, OFFSET>,
            GetInternalCompBufferInfo: GetInternalCompBufferInfo::<Identity, OFFSET>,
            BeginFrame: BeginFrame::<Identity, OFFSET>,
            EndFrame: EndFrame::<Identity, OFFSET>,
            GetBuffer: GetBuffer::<Identity, OFFSET>,
            ReleaseBuffer: ReleaseBuffer::<Identity, OFFSET>,
            Execute: Execute::<Identity, OFFSET>,
            QueryRenderStatus: QueryRenderStatus::<Identity, OFFSET>,
            DisplayFrame: DisplayFrame::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMVideoAccelerator as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl windows_core::RuntimeName for IAMVideoAccelerator {}
windows_core::imp::define_interface!(IAMVideoAcceleratorNotify, IAMVideoAcceleratorNotify_Vtbl, 0x256a6a21_fbad_11d1_82bf_00a0c9696c8f);
windows_core::imp::interface_hierarchy!(IAMVideoAcceleratorNotify, windows_core::IUnknown);
impl IAMVideoAcceleratorNotify {
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetUncompSurfacesInfo(&self, pguid: *const windows_core::GUID, puncompbufferinfo: *mut AMVAUncompBufferInfo) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetUncompSurfacesInfo)(windows_core::Interface::as_raw(self), pguid, puncompbufferinfo as _).ok() }
    }
    pub unsafe fn SetUncompSurfacesInfo(&self, dwactualuncompsurfacesallocated: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetUncompSurfacesInfo)(windows_core::Interface::as_raw(self), dwactualuncompsurfacesallocated).ok() }
    }
    pub unsafe fn GetCreateVideoAcceleratorData(&self, pguid: *const windows_core::GUID, pdwsizemiscdata: *mut u32, ppmiscdata: *mut *mut core::ffi::c_void) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCreateVideoAcceleratorData)(windows_core::Interface::as_raw(self), pguid, pdwsizemiscdata as _, ppmiscdata as _).ok() }
    }
}
#[repr(C)]
pub struct IAMVideoAcceleratorNotify_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetUncompSurfacesInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut AMVAUncompBufferInfo) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetUncompSurfacesInfo: usize,
    pub SetUncompSurfacesInfo: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetCreateVideoAcceleratorData: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
pub trait IAMVideoAcceleratorNotify_Impl: windows_core::IUnknownImpl {
    fn GetUncompSurfacesInfo(&self, pguid: *const windows_core::GUID, puncompbufferinfo: *mut AMVAUncompBufferInfo) -> windows_core::Result<()>;
    fn SetUncompSurfacesInfo(&self, dwactualuncompsurfacesallocated: u32) -> windows_core::Result<()>;
    fn GetCreateVideoAcceleratorData(&self, pguid: *const windows_core::GUID, pdwsizemiscdata: *mut u32, ppmiscdata: *mut *mut core::ffi::c_void) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl IAMVideoAcceleratorNotify_Vtbl {
    pub const fn new<Identity: IAMVideoAcceleratorNotify_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetUncompSurfacesInfo<Identity: IAMVideoAcceleratorNotify_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguid: *const windows_core::GUID, puncompbufferinfo: *mut AMVAUncompBufferInfo) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAcceleratorNotify_Impl::GetUncompSurfacesInfo(this, core::mem::transmute_copy(&pguid), core::mem::transmute_copy(&puncompbufferinfo)).into()
            }
        }
        unsafe extern "system" fn SetUncompSurfacesInfo<Identity: IAMVideoAcceleratorNotify_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwactualuncompsurfacesallocated: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAcceleratorNotify_Impl::SetUncompSurfacesInfo(this, core::mem::transmute_copy(&dwactualuncompsurfacesallocated)).into()
            }
        }
        unsafe extern "system" fn GetCreateVideoAcceleratorData<Identity: IAMVideoAcceleratorNotify_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguid: *const windows_core::GUID, pdwsizemiscdata: *mut u32, ppmiscdata: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoAcceleratorNotify_Impl::GetCreateVideoAcceleratorData(this, core::mem::transmute_copy(&pguid), core::mem::transmute_copy(&pdwsizemiscdata), core::mem::transmute_copy(&ppmiscdata)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetUncompSurfacesInfo: GetUncompSurfacesInfo::<Identity, OFFSET>,
            SetUncompSurfacesInfo: SetUncompSurfacesInfo::<Identity, OFFSET>,
            GetCreateVideoAcceleratorData: GetCreateVideoAcceleratorData::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMVideoAcceleratorNotify as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_DirectDraw")]
impl windows_core::RuntimeName for IAMVideoAcceleratorNotify {}
windows_core::imp::define_interface!(IAMVideoCompression, IAMVideoCompression_Vtbl, 0xc6e13343_30ac_11d0_a18c_00a0c9118956);
windows_core::imp::interface_hierarchy!(IAMVideoCompression, windows_core::IUnknown);
impl IAMVideoCompression {
    pub unsafe fn SetKeyFrameRate(&self, keyframerate: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetKeyFrameRate)(windows_core::Interface::as_raw(self), keyframerate).ok() }
    }
    pub unsafe fn KeyFrameRate(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).KeyFrameRate)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetPFramesPerKeyFrame(&self, pframesperkeyframe: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPFramesPerKeyFrame)(windows_core::Interface::as_raw(self), pframesperkeyframe).ok() }
    }
    pub unsafe fn PFramesPerKeyFrame(&self) -> windows_core::Result<i32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).PFramesPerKeyFrame)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetQuality(&self, quality: f64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetQuality)(windows_core::Interface::as_raw(self), quality).ok() }
    }
    pub unsafe fn Quality(&self) -> windows_core::Result<f64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).Quality)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetWindowSize(&self, windowsize: u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetWindowSize)(windows_core::Interface::as_raw(self), windowsize).ok() }
    }
    pub unsafe fn WindowSize(&self) -> windows_core::Result<u64> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).WindowSize)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetInfo(&self, pszversion: Option<windows_core::PWSTR>, pcbversion: Option<*mut i32>, pszdescription: Option<windows_core::PWSTR>, pcbdescription: Option<*mut i32>, pdefaultkeyframerate: Option<*mut i32>, pdefaultpframesperkey: Option<*mut i32>, pdefaultquality: Option<*mut f64>, pcapabilities: Option<*mut i32>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetInfo)(windows_core::Interface::as_raw(self), pszversion.unwrap_or(core::mem::zeroed()) as _, pcbversion.unwrap_or(core::mem::zeroed()) as _, pszdescription.unwrap_or(core::mem::zeroed()) as _, pcbdescription.unwrap_or(core::mem::zeroed()) as _, pdefaultkeyframerate.unwrap_or(core::mem::zeroed()) as _, pdefaultpframesperkey.unwrap_or(core::mem::zeroed()) as _, pdefaultquality.unwrap_or(core::mem::zeroed()) as _, pcapabilities.unwrap_or(core::mem::zeroed()) as _).ok() }
    }
    pub unsafe fn OverrideKeyFrame(&self, framenumber: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).OverrideKeyFrame)(windows_core::Interface::as_raw(self), framenumber).ok() }
    }
    pub unsafe fn OverrideFrameSize(&self, framenumber: i32, size: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).OverrideFrameSize)(windows_core::Interface::as_raw(self), framenumber, size).ok() }
    }
}
#[repr(C)]
pub struct IAMVideoCompression_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetKeyFrameRate: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub KeyFrameRate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetPFramesPerKeyFrame: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub PFramesPerKeyFrame: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetQuality: unsafe extern "system" fn(*mut core::ffi::c_void, f64) -> windows_core::HRESULT,
    pub Quality: unsafe extern "system" fn(*mut core::ffi::c_void, *mut f64) -> windows_core::HRESULT,
    pub SetWindowSize: unsafe extern "system" fn(*mut core::ffi::c_void, u64) -> windows_core::HRESULT,
    pub WindowSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u64) -> windows_core::HRESULT,
    pub GetInfo: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PWSTR, *mut i32, windows_core::PWSTR, *mut i32, *mut i32, *mut i32, *mut f64, *mut i32) -> windows_core::HRESULT,
    pub OverrideKeyFrame: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub OverrideFrameSize: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32) -> windows_core::HRESULT,
}
pub trait IAMVideoCompression_Impl: windows_core::IUnknownImpl {
    fn SetKeyFrameRate(&self, keyframerate: i32) -> windows_core::Result<()>;
    fn KeyFrameRate(&self) -> windows_core::Result<i32>;
    fn SetPFramesPerKeyFrame(&self, pframesperkeyframe: i32) -> windows_core::Result<()>;
    fn PFramesPerKeyFrame(&self) -> windows_core::Result<i32>;
    fn SetQuality(&self, quality: f64) -> windows_core::Result<()>;
    fn Quality(&self) -> windows_core::Result<f64>;
    fn SetWindowSize(&self, windowsize: u64) -> windows_core::Result<()>;
    fn WindowSize(&self) -> windows_core::Result<u64>;
    fn GetInfo(&self, pszversion: windows_core::PWSTR, pcbversion: *mut i32, pszdescription: windows_core::PWSTR, pcbdescription: *mut i32, pdefaultkeyframerate: *mut i32, pdefaultpframesperkey: *mut i32, pdefaultquality: *mut f64, pcapabilities: *mut i32) -> windows_core::Result<()>;
    fn OverrideKeyFrame(&self, framenumber: i32) -> windows_core::Result<()>;
    fn OverrideFrameSize(&self, framenumber: i32, size: i32) -> windows_core::Result<()>;
}
impl IAMVideoCompression_Vtbl {
    pub const fn new<Identity: IAMVideoCompression_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetKeyFrameRate<Identity: IAMVideoCompression_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, keyframerate: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoCompression_Impl::SetKeyFrameRate(this, core::mem::transmute_copy(&keyframerate)).into()
            }
        }
        unsafe extern "system" fn KeyFrameRate<Identity: IAMVideoCompression_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pkeyframerate: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMVideoCompression_Impl::KeyFrameRate(this) {
                    Ok(ok__) => {
                        pkeyframerate.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetPFramesPerKeyFrame<Identity: IAMVideoCompression_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pframesperkeyframe: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoCompression_Impl::SetPFramesPerKeyFrame(this, core::mem::transmute_copy(&pframesperkeyframe)).into()
            }
        }
        unsafe extern "system" fn PFramesPerKeyFrame<Identity: IAMVideoCompression_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppframesperkeyframe: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMVideoCompression_Impl::PFramesPerKeyFrame(this) {
                    Ok(ok__) => {
                        ppframesperkeyframe.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetQuality<Identity: IAMVideoCompression_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, quality: f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoCompression_Impl::SetQuality(this, core::mem::transmute_copy(&quality)).into()
            }
        }
        unsafe extern "system" fn Quality<Identity: IAMVideoCompression_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pquality: *mut f64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMVideoCompression_Impl::Quality(this) {
                    Ok(ok__) => {
                        pquality.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetWindowSize<Identity: IAMVideoCompression_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, windowsize: u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoCompression_Impl::SetWindowSize(this, core::mem::transmute_copy(&windowsize)).into()
            }
        }
        unsafe extern "system" fn WindowSize<Identity: IAMVideoCompression_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwindowsize: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMVideoCompression_Impl::WindowSize(this) {
                    Ok(ok__) => {
                        pwindowsize.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetInfo<Identity: IAMVideoCompression_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pszversion: windows_core::PWSTR, pcbversion: *mut i32, pszdescription: windows_core::PWSTR, pcbdescription: *mut i32, pdefaultkeyframerate: *mut i32, pdefaultpframesperkey: *mut i32, pdefaultquality: *mut f64, pcapabilities: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoCompression_Impl::GetInfo(this, core::mem::transmute_copy(&pszversion), core::mem::transmute_copy(&pcbversion), core::mem::transmute_copy(&pszdescription), core::mem::transmute_copy(&pcbdescription), core::mem::transmute_copy(&pdefaultkeyframerate), core::mem::transmute_copy(&pdefaultpframesperkey), core::mem::transmute_copy(&pdefaultquality), core::mem::transmute_copy(&pcapabilities)).into()
            }
        }
        unsafe extern "system" fn OverrideKeyFrame<Identity: IAMVideoCompression_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, framenumber: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoCompression_Impl::OverrideKeyFrame(this, core::mem::transmute_copy(&framenumber)).into()
            }
        }
        unsafe extern "system" fn OverrideFrameSize<Identity: IAMVideoCompression_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, framenumber: i32, size: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoCompression_Impl::OverrideFrameSize(this, core::mem::transmute_copy(&framenumber), core::mem::transmute_copy(&size)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetKeyFrameRate: SetKeyFrameRate::<Identity, OFFSET>,
            KeyFrameRate: KeyFrameRate::<Identity, OFFSET>,
            SetPFramesPerKeyFrame: SetPFramesPerKeyFrame::<Identity, OFFSET>,
            PFramesPerKeyFrame: PFramesPerKeyFrame::<Identity, OFFSET>,
            SetQuality: SetQuality::<Identity, OFFSET>,
            Quality: Quality::<Identity, OFFSET>,
            SetWindowSize: SetWindowSize::<Identity, OFFSET>,
            WindowSize: WindowSize::<Identity, OFFSET>,
            GetInfo: GetInfo::<Identity, OFFSET>,
            OverrideKeyFrame: OverrideKeyFrame::<Identity, OFFSET>,
            OverrideFrameSize: OverrideFrameSize::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMVideoCompression as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMVideoCompression {}
windows_core::imp::define_interface!(IAMVideoControl, IAMVideoControl_Vtbl, 0x6a2e0670_28e4_11d0_a18c_00a0c9118956);
windows_core::imp::interface_hierarchy!(IAMVideoControl, windows_core::IUnknown);
impl IAMVideoControl {
    pub unsafe fn GetCaps<P0>(&self, ppin: P0) -> windows_core::Result<i32>
    where
        P0: windows_core::Param<IPin>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCaps)(windows_core::Interface::as_raw(self), ppin.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetMode<P0>(&self, ppin: P0, mode: i32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IPin>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetMode)(windows_core::Interface::as_raw(self), ppin.param().abi(), mode).ok() }
    }
    pub unsafe fn GetMode<P0>(&self, ppin: P0) -> windows_core::Result<i32>
    where
        P0: windows_core::Param<IPin>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetMode)(windows_core::Interface::as_raw(self), ppin.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetCurrentActualFrameRate<P0>(&self, ppin: P0) -> windows_core::Result<i64>
    where
        P0: windows_core::Param<IPin>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetCurrentActualFrameRate)(windows_core::Interface::as_raw(self), ppin.param().abi(), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetMaxAvailableFrameRate<P0>(&self, ppin: P0, iindex: i32, dimensions: super::super::Foundation::SIZE) -> windows_core::Result<i64>
    where
        P0: windows_core::Param<IPin>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetMaxAvailableFrameRate)(windows_core::Interface::as_raw(self), ppin.param().abi(), iindex, core::mem::transmute(dimensions), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetFrameRateList<P0>(&self, ppin: P0, iindex: i32, dimensions: super::super::Foundation::SIZE, listsize: *mut i32, framerates: *mut *mut i64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IPin>,
    {
        unsafe { (windows_core::Interface::vtable(self).GetFrameRateList)(windows_core::Interface::as_raw(self), ppin.param().abi(), iindex, core::mem::transmute(dimensions), listsize as _, framerates as _).ok() }
    }
}
#[repr(C)]
pub struct IAMVideoControl_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetCaps: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub GetMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub GetCurrentActualFrameRate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut i64) -> windows_core::HRESULT,
    pub GetMaxAvailableFrameRate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, i32, super::super::Foundation::SIZE, *mut i64) -> windows_core::HRESULT,
    pub GetFrameRateList: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, i32, super::super::Foundation::SIZE, *mut i32, *mut *mut i64) -> windows_core::HRESULT,
}
pub trait IAMVideoControl_Impl: windows_core::IUnknownImpl {
    fn GetCaps(&self, ppin: windows_core::Ref<'_, IPin>) -> windows_core::Result<i32>;
    fn SetMode(&self, ppin: windows_core::Ref<'_, IPin>, mode: i32) -> windows_core::Result<()>;
    fn GetMode(&self, ppin: windows_core::Ref<'_, IPin>) -> windows_core::Result<i32>;
    fn GetCurrentActualFrameRate(&self, ppin: windows_core::Ref<'_, IPin>) -> windows_core::Result<i64>;
    fn GetMaxAvailableFrameRate(&self, ppin: windows_core::Ref<'_, IPin>, iindex: i32, dimensions: &super::super::Foundation::SIZE) -> windows_core::Result<i64>;
    fn GetFrameRateList(&self, ppin: windows_core::Ref<'_, IPin>, iindex: i32, dimensions: &super::super::Foundation::SIZE, listsize: *mut i32, framerates: *mut *mut i64) -> windows_core::Result<()>;
}
impl IAMVideoControl_Vtbl {
    pub const fn new<Identity: IAMVideoControl_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetCaps<Identity: IAMVideoControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppin: *mut core::ffi::c_void, pcapsflags: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMVideoControl_Impl::GetCaps(this, core::mem::transmute_copy(&ppin)) {
                    Ok(ok__) => {
                        pcapsflags.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetMode<Identity: IAMVideoControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppin: *mut core::ffi::c_void, mode: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoControl_Impl::SetMode(this, core::mem::transmute_copy(&ppin), core::mem::transmute_copy(&mode)).into()
            }
        }
        unsafe extern "system" fn GetMode<Identity: IAMVideoControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppin: *mut core::ffi::c_void, mode: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMVideoControl_Impl::GetMode(this, core::mem::transmute_copy(&ppin)) {
                    Ok(ok__) => {
                        mode.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetCurrentActualFrameRate<Identity: IAMVideoControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppin: *mut core::ffi::c_void, actualframerate: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMVideoControl_Impl::GetCurrentActualFrameRate(this, core::mem::transmute_copy(&ppin)) {
                    Ok(ok__) => {
                        actualframerate.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetMaxAvailableFrameRate<Identity: IAMVideoControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppin: *mut core::ffi::c_void, iindex: i32, dimensions: super::super::Foundation::SIZE, maxavailableframerate: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMVideoControl_Impl::GetMaxAvailableFrameRate(this, core::mem::transmute_copy(&ppin), core::mem::transmute_copy(&iindex), core::mem::transmute(&dimensions)) {
                    Ok(ok__) => {
                        maxavailableframerate.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetFrameRateList<Identity: IAMVideoControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppin: *mut core::ffi::c_void, iindex: i32, dimensions: super::super::Foundation::SIZE, listsize: *mut i32, framerates: *mut *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoControl_Impl::GetFrameRateList(this, core::mem::transmute_copy(&ppin), core::mem::transmute_copy(&iindex), core::mem::transmute(&dimensions), core::mem::transmute_copy(&listsize), core::mem::transmute_copy(&framerates)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetCaps: GetCaps::<Identity, OFFSET>,
            SetMode: SetMode::<Identity, OFFSET>,
            GetMode: GetMode::<Identity, OFFSET>,
            GetCurrentActualFrameRate: GetCurrentActualFrameRate::<Identity, OFFSET>,
            GetMaxAvailableFrameRate: GetMaxAvailableFrameRate::<Identity, OFFSET>,
            GetFrameRateList: GetFrameRateList::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMVideoControl as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMVideoControl {}
windows_core::imp::define_interface!(IAMVideoDecimationProperties, IAMVideoDecimationProperties_Vtbl, 0x60d32930_13da_11d3_9ec6_c4fcaef5c7be);
windows_core::imp::interface_hierarchy!(IAMVideoDecimationProperties, windows_core::IUnknown);
impl IAMVideoDecimationProperties {
    pub unsafe fn QueryDecimationUsage(&self) -> windows_core::Result<DECIMATION_USAGE> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).QueryDecimationUsage)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetDecimationUsage(&self, usage: DECIMATION_USAGE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDecimationUsage)(windows_core::Interface::as_raw(self), usage).ok() }
    }
}
#[repr(C)]
pub struct IAMVideoDecimationProperties_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub QueryDecimationUsage: unsafe extern "system" fn(*mut core::ffi::c_void, *mut DECIMATION_USAGE) -> windows_core::HRESULT,
    pub SetDecimationUsage: unsafe extern "system" fn(*mut core::ffi::c_void, DECIMATION_USAGE) -> windows_core::HRESULT,
}
pub trait IAMVideoDecimationProperties_Impl: windows_core::IUnknownImpl {
    fn QueryDecimationUsage(&self) -> windows_core::Result<DECIMATION_USAGE>;
    fn SetDecimationUsage(&self, usage: DECIMATION_USAGE) -> windows_core::Result<()>;
}
impl IAMVideoDecimationProperties_Vtbl {
    pub const fn new<Identity: IAMVideoDecimationProperties_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn QueryDecimationUsage<Identity: IAMVideoDecimationProperties_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpusage: *mut DECIMATION_USAGE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAMVideoDecimationProperties_Impl::QueryDecimationUsage(this) {
                    Ok(ok__) => {
                        lpusage.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetDecimationUsage<Identity: IAMVideoDecimationProperties_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, usage: DECIMATION_USAGE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoDecimationProperties_Impl::SetDecimationUsage(this, core::mem::transmute_copy(&usage)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            QueryDecimationUsage: QueryDecimationUsage::<Identity, OFFSET>,
            SetDecimationUsage: SetDecimationUsage::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMVideoDecimationProperties as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMVideoDecimationProperties {}
windows_core::imp::define_interface!(IAMVideoProcAmp, IAMVideoProcAmp_Vtbl, 0xc6e13360_30ac_11d0_a18c_00a0c9118956);
windows_core::imp::interface_hierarchy!(IAMVideoProcAmp, windows_core::IUnknown);
impl IAMVideoProcAmp {
    pub unsafe fn GetRange(&self, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRange)(windows_core::Interface::as_raw(self), property, pmin as _, pmax as _, psteppingdelta as _, pdefault as _, pcapsflags as _).ok() }
    }
    pub unsafe fn Set(&self, property: i32, lvalue: i32, flags: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Set)(windows_core::Interface::as_raw(self), property, lvalue, flags).ok() }
    }
    pub unsafe fn Get(&self, property: i32, lvalue: *mut i32, flags: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Get)(windows_core::Interface::as_raw(self), property, lvalue as _, flags as _).ok() }
    }
}
#[repr(C)]
pub struct IAMVideoProcAmp_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetRange: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32, *mut i32, *mut i32, *mut i32, *mut i32) -> windows_core::HRESULT,
    pub Set: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32, i32) -> windows_core::HRESULT,
    pub Get: unsafe extern "system" fn(*mut core::ffi::c_void, i32, *mut i32, *mut i32) -> windows_core::HRESULT,
}
pub trait IAMVideoProcAmp_Impl: windows_core::IUnknownImpl {
    fn GetRange(&self, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> windows_core::Result<()>;
    fn Set(&self, property: i32, lvalue: i32, flags: i32) -> windows_core::Result<()>;
    fn Get(&self, property: i32, lvalue: *mut i32, flags: *mut i32) -> windows_core::Result<()>;
}
impl IAMVideoProcAmp_Vtbl {
    pub const fn new<Identity: IAMVideoProcAmp_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetRange<Identity: IAMVideoProcAmp_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoProcAmp_Impl::GetRange(this, core::mem::transmute_copy(&property), core::mem::transmute_copy(&pmin), core::mem::transmute_copy(&pmax), core::mem::transmute_copy(&psteppingdelta), core::mem::transmute_copy(&pdefault), core::mem::transmute_copy(&pcapsflags)).into()
            }
        }
        unsafe extern "system" fn Set<Identity: IAMVideoProcAmp_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, property: i32, lvalue: i32, flags: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoProcAmp_Impl::Set(this, core::mem::transmute_copy(&property), core::mem::transmute_copy(&lvalue), core::mem::transmute_copy(&flags)).into()
            }
        }
        unsafe extern "system" fn Get<Identity: IAMVideoProcAmp_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, property: i32, lvalue: *mut i32, flags: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMVideoProcAmp_Impl::Get(this, core::mem::transmute_copy(&property), core::mem::transmute_copy(&lvalue), core::mem::transmute_copy(&flags)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetRange: GetRange::<Identity, OFFSET>,
            Set: Set::<Identity, OFFSET>,
            Get: Get::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMVideoProcAmp as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMVideoProcAmp {}
windows_core::imp::define_interface!(IAMWMBufferPass, IAMWMBufferPass_Vtbl, 0x6dd816d7_e740_4123_9e24_2444412644d8);
windows_core::imp::interface_hierarchy!(IAMWMBufferPass, windows_core::IUnknown);
impl IAMWMBufferPass {
    pub unsafe fn SetNotify<P0>(&self, pcallback: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IAMWMBufferPassCallback>,
    {
        unsafe { (windows_core::Interface::vtable(self).SetNotify)(windows_core::Interface::as_raw(self), pcallback.param().abi()).ok() }
    }
}
#[repr(C)]
pub struct IAMWMBufferPass_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetNotify: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAMWMBufferPass_Impl: windows_core::IUnknownImpl {
    fn SetNotify(&self, pcallback: windows_core::Ref<'_, IAMWMBufferPassCallback>) -> windows_core::Result<()>;
}
impl IAMWMBufferPass_Vtbl {
    pub const fn new<Identity: IAMWMBufferPass_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetNotify<Identity: IAMWMBufferPass_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcallback: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWMBufferPass_Impl::SetNotify(this, core::mem::transmute_copy(&pcallback)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), SetNotify: SetNotify::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMWMBufferPass as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMWMBufferPass {}
windows_core::imp::define_interface!(IAMWMBufferPassCallback, IAMWMBufferPassCallback_Vtbl, 0xb25b8372_d2d2_44b2_8653_1b8dae332489);
windows_core::imp::interface_hierarchy!(IAMWMBufferPassCallback, windows_core::IUnknown);
impl IAMWMBufferPassCallback {
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub unsafe fn Notify<P0, P1>(&self, pnssbuffer3: P0, ppin: P1, prtstart: *const i64, prtend: *const i64) -> windows_core::Result<()>
    where
        P0: windows_core::Param<super::WindowsMediaFormat::INSSBuffer3>,
        P1: windows_core::Param<IPin>,
    {
        unsafe { (windows_core::Interface::vtable(self).Notify)(windows_core::Interface::as_raw(self), pnssbuffer3.param().abi(), ppin.param().abi(), prtstart, prtend).ok() }
    }
}
#[repr(C)]
pub struct IAMWMBufferPassCallback_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub Notify: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *const i64, *const i64) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_WindowsMediaFormat"))]
    Notify: usize,
}
#[cfg(feature = "Win32_Media_WindowsMediaFormat")]
pub trait IAMWMBufferPassCallback_Impl: windows_core::IUnknownImpl {
    fn Notify(&self, pnssbuffer3: windows_core::Ref<'_, super::WindowsMediaFormat::INSSBuffer3>, ppin: windows_core::Ref<'_, IPin>, prtstart: *const i64, prtend: *const i64) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Media_WindowsMediaFormat")]
impl IAMWMBufferPassCallback_Vtbl {
    pub const fn new<Identity: IAMWMBufferPassCallback_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Notify<Identity: IAMWMBufferPassCallback_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pnssbuffer3: *mut core::ffi::c_void, ppin: *mut core::ffi::c_void, prtstart: *const i64, prtend: *const i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWMBufferPassCallback_Impl::Notify(this, core::mem::transmute_copy(&pnssbuffer3), core::mem::transmute_copy(&ppin), core::mem::transmute_copy(&prtstart), core::mem::transmute_copy(&prtend)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Notify: Notify::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMWMBufferPassCallback as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Media_WindowsMediaFormat")]
impl windows_core::RuntimeName for IAMWMBufferPassCallback {}
windows_core::imp::define_interface!(IAMWstDecoder, IAMWstDecoder_Vtbl, 0xc056de21_75c2_11d3_a184_00105aef9f33);
windows_core::imp::interface_hierarchy!(IAMWstDecoder, windows_core::IUnknown);
impl IAMWstDecoder {
    pub unsafe fn GetDecoderLevel(&self, lplevel: *mut AM_WST_LEVEL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDecoderLevel)(windows_core::Interface::as_raw(self), lplevel as _).ok() }
    }
    pub unsafe fn GetCurrentService(&self, lpservice: *mut AM_WST_SERVICE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCurrentService)(windows_core::Interface::as_raw(self), lpservice as _).ok() }
    }
    pub unsafe fn GetServiceState(&self, lpstate: *mut AM_WST_STATE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetServiceState)(windows_core::Interface::as_raw(self), lpstate as _).ok() }
    }
    pub unsafe fn SetServiceState(&self, state: AM_WST_STATE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetServiceState)(windows_core::Interface::as_raw(self), state).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetOutputFormat(&self, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetOutputFormat)(windows_core::Interface::as_raw(self), lpbmih as _).ok() }
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetOutputFormat(&self, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOutputFormat)(windows_core::Interface::as_raw(self), lpbmi as _).ok() }
    }
    pub unsafe fn GetBackgroundColor(&self, pdwphyscolor: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetBackgroundColor)(windows_core::Interface::as_raw(self), pdwphyscolor as _).ok() }
    }
    pub unsafe fn SetBackgroundColor(&self, dwphyscolor: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetBackgroundColor)(windows_core::Interface::as_raw(self), dwphyscolor).ok() }
    }
    pub unsafe fn GetRedrawAlways(&self, lpboption: *mut windows_core::BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetRedrawAlways)(windows_core::Interface::as_raw(self), lpboption as _).ok() }
    }
    pub unsafe fn SetRedrawAlways(&self, boption: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetRedrawAlways)(windows_core::Interface::as_raw(self), boption.into()).ok() }
    }
    pub unsafe fn GetDrawBackgroundMode(&self, lpmode: *mut AM_WST_DRAWBGMODE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDrawBackgroundMode)(windows_core::Interface::as_raw(self), lpmode as _).ok() }
    }
    pub unsafe fn SetDrawBackgroundMode(&self, mode: AM_WST_DRAWBGMODE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDrawBackgroundMode)(windows_core::Interface::as_raw(self), mode).ok() }
    }
    pub unsafe fn SetAnswerMode(&self, banswer: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetAnswerMode)(windows_core::Interface::as_raw(self), banswer.into()).ok() }
    }
    pub unsafe fn GetAnswerMode(&self, pbanswer: *mut windows_core::BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetAnswerMode)(windows_core::Interface::as_raw(self), pbanswer as _).ok() }
    }
    pub unsafe fn SetHoldPage(&self, bholdpage: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetHoldPage)(windows_core::Interface::as_raw(self), bholdpage.into()).ok() }
    }
    pub unsafe fn GetHoldPage(&self, pbholdpage: *mut windows_core::BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetHoldPage)(windows_core::Interface::as_raw(self), pbholdpage as _).ok() }
    }
    pub unsafe fn GetCurrentPage(&self, pwstpage: *mut AM_WST_PAGE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetCurrentPage)(windows_core::Interface::as_raw(self), pwstpage as _).ok() }
    }
    pub unsafe fn SetCurrentPage(&self, wstpage: AM_WST_PAGE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCurrentPage)(windows_core::Interface::as_raw(self), core::mem::transmute(wstpage)).ok() }
    }
}
#[repr(C)]
pub struct IAMWstDecoder_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDecoderLevel: unsafe extern "system" fn(*mut core::ffi::c_void, *mut AM_WST_LEVEL) -> windows_core::HRESULT,
    pub GetCurrentService: unsafe extern "system" fn(*mut core::ffi::c_void, *mut AM_WST_SERVICE) -> windows_core::HRESULT,
    pub GetServiceState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut AM_WST_STATE) -> windows_core::HRESULT,
    pub SetServiceState: unsafe extern "system" fn(*mut core::ffi::c_void, AM_WST_STATE) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetOutputFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetOutputFormat: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetOutputFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::super::Graphics::Gdi::BITMAPINFO) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetOutputFormat: usize,
    pub GetBackgroundColor: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetBackgroundColor: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetRedrawAlways: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub SetRedrawAlways: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub GetDrawBackgroundMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut AM_WST_DRAWBGMODE) -> windows_core::HRESULT,
    pub SetDrawBackgroundMode: unsafe extern "system" fn(*mut core::ffi::c_void, AM_WST_DRAWBGMODE) -> windows_core::HRESULT,
    pub SetAnswerMode: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub GetAnswerMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub SetHoldPage: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
    pub GetHoldPage: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub GetCurrentPage: unsafe extern "system" fn(*mut core::ffi::c_void, *mut AM_WST_PAGE) -> windows_core::HRESULT,
    pub SetCurrentPage: unsafe extern "system" fn(*mut core::ffi::c_void, AM_WST_PAGE) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub trait IAMWstDecoder_Impl: windows_core::IUnknownImpl {
    fn GetDecoderLevel(&self, lplevel: *mut AM_WST_LEVEL) -> windows_core::Result<()>;
    fn GetCurrentService(&self, lpservice: *mut AM_WST_SERVICE) -> windows_core::Result<()>;
    fn GetServiceState(&self, lpstate: *mut AM_WST_STATE) -> windows_core::Result<()>;
    fn SetServiceState(&self, state: AM_WST_STATE) -> windows_core::Result<()>;
    fn GetOutputFormat(&self, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> windows_core::Result<()>;
    fn SetOutputFormat(&self, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> windows_core::Result<()>;
    fn GetBackgroundColor(&self, pdwphyscolor: *mut u32) -> windows_core::Result<()>;
    fn SetBackgroundColor(&self, dwphyscolor: u32) -> windows_core::Result<()>;
    fn GetRedrawAlways(&self, lpboption: *mut windows_core::BOOL) -> windows_core::Result<()>;
    fn SetRedrawAlways(&self, boption: windows_core::BOOL) -> windows_core::Result<()>;
    fn GetDrawBackgroundMode(&self, lpmode: *mut AM_WST_DRAWBGMODE) -> windows_core::Result<()>;
    fn SetDrawBackgroundMode(&self, mode: AM_WST_DRAWBGMODE) -> windows_core::Result<()>;
    fn SetAnswerMode(&self, banswer: windows_core::BOOL) -> windows_core::Result<()>;
    fn GetAnswerMode(&self, pbanswer: *mut windows_core::BOOL) -> windows_core::Result<()>;
    fn SetHoldPage(&self, bholdpage: windows_core::BOOL) -> windows_core::Result<()>;
    fn GetHoldPage(&self, pbholdpage: *mut windows_core::BOOL) -> windows_core::Result<()>;
    fn GetCurrentPage(&self, pwstpage: *mut AM_WST_PAGE) -> windows_core::Result<()>;
    fn SetCurrentPage(&self, wstpage: &AM_WST_PAGE) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl IAMWstDecoder_Vtbl {
    pub const fn new<Identity: IAMWstDecoder_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDecoderLevel<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lplevel: *mut AM_WST_LEVEL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::GetDecoderLevel(this, core::mem::transmute_copy(&lplevel)).into()
            }
        }
        unsafe extern "system" fn GetCurrentService<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpservice: *mut AM_WST_SERVICE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::GetCurrentService(this, core::mem::transmute_copy(&lpservice)).into()
            }
        }
        unsafe extern "system" fn GetServiceState<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpstate: *mut AM_WST_STATE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::GetServiceState(this, core::mem::transmute_copy(&lpstate)).into()
            }
        }
        unsafe extern "system" fn SetServiceState<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, state: AM_WST_STATE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::SetServiceState(this, core::mem::transmute_copy(&state)).into()
            }
        }
        unsafe extern "system" fn GetOutputFormat<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::GetOutputFormat(this, core::mem::transmute_copy(&lpbmih)).into()
            }
        }
        unsafe extern "system" fn SetOutputFormat<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::SetOutputFormat(this, core::mem::transmute_copy(&lpbmi)).into()
            }
        }
        unsafe extern "system" fn GetBackgroundColor<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwphyscolor: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::GetBackgroundColor(this, core::mem::transmute_copy(&pdwphyscolor)).into()
            }
        }
        unsafe extern "system" fn SetBackgroundColor<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwphyscolor: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::SetBackgroundColor(this, core::mem::transmute_copy(&dwphyscolor)).into()
            }
        }
        unsafe extern "system" fn GetRedrawAlways<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpboption: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::GetRedrawAlways(this, core::mem::transmute_copy(&lpboption)).into()
            }
        }
        unsafe extern "system" fn SetRedrawAlways<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, boption: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::SetRedrawAlways(this, core::mem::transmute_copy(&boption)).into()
            }
        }
        unsafe extern "system" fn GetDrawBackgroundMode<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpmode: *mut AM_WST_DRAWBGMODE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::GetDrawBackgroundMode(this, core::mem::transmute_copy(&lpmode)).into()
            }
        }
        unsafe extern "system" fn SetDrawBackgroundMode<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, mode: AM_WST_DRAWBGMODE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::SetDrawBackgroundMode(this, core::mem::transmute_copy(&mode)).into()
            }
        }
        unsafe extern "system" fn SetAnswerMode<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, banswer: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::SetAnswerMode(this, core::mem::transmute_copy(&banswer)).into()
            }
        }
        unsafe extern "system" fn GetAnswerMode<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbanswer: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::GetAnswerMode(this, core::mem::transmute_copy(&pbanswer)).into()
            }
        }
        unsafe extern "system" fn SetHoldPage<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bholdpage: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::SetHoldPage(this, core::mem::transmute_copy(&bholdpage)).into()
            }
        }
        unsafe extern "system" fn GetHoldPage<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbholdpage: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::GetHoldPage(this, core::mem::transmute_copy(&pbholdpage)).into()
            }
        }
        unsafe extern "system" fn GetCurrentPage<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwstpage: *mut AM_WST_PAGE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::GetCurrentPage(this, core::mem::transmute_copy(&pwstpage)).into()
            }
        }
        unsafe extern "system" fn SetCurrentPage<Identity: IAMWstDecoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, wstpage: AM_WST_PAGE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMWstDecoder_Impl::SetCurrentPage(this, core::mem::transmute(&wstpage)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetDecoderLevel: GetDecoderLevel::<Identity, OFFSET>,
            GetCurrentService: GetCurrentService::<Identity, OFFSET>,
            GetServiceState: GetServiceState::<Identity, OFFSET>,
            SetServiceState: SetServiceState::<Identity, OFFSET>,
            GetOutputFormat: GetOutputFormat::<Identity, OFFSET>,
            SetOutputFormat: SetOutputFormat::<Identity, OFFSET>,
            GetBackgroundColor: GetBackgroundColor::<Identity, OFFSET>,
            SetBackgroundColor: SetBackgroundColor::<Identity, OFFSET>,
            GetRedrawAlways: GetRedrawAlways::<Identity, OFFSET>,
            SetRedrawAlways: SetRedrawAlways::<Identity, OFFSET>,
            GetDrawBackgroundMode: GetDrawBackgroundMode::<Identity, OFFSET>,
            SetDrawBackgroundMode: SetDrawBackgroundMode::<Identity, OFFSET>,
            SetAnswerMode: SetAnswerMode::<Identity, OFFSET>,
            GetAnswerMode: GetAnswerMode::<Identity, OFFSET>,
            SetHoldPage: SetHoldPage::<Identity, OFFSET>,
            GetHoldPage: GetHoldPage::<Identity, OFFSET>,
            GetCurrentPage: GetCurrentPage::<Identity, OFFSET>,
            SetCurrentPage: SetCurrentPage::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMWstDecoder as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl windows_core::RuntimeName for IAMWstDecoder {}
windows_core::imp::define_interface!(IAMovieSetup, IAMovieSetup_Vtbl, 0xa3d8cec0_7e5a_11cf_bbc5_00805f6cef20);
windows_core::imp::interface_hierarchy!(IAMovieSetup, windows_core::IUnknown);
impl IAMovieSetup {
    pub unsafe fn Register(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Register)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Unregister(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Unregister)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
pub struct IAMovieSetup_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Register: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Unregister: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAMovieSetup_Impl: windows_core::IUnknownImpl {
    fn Register(&self) -> windows_core::Result<()>;
    fn Unregister(&self) -> windows_core::Result<()>;
}
impl IAMovieSetup_Vtbl {
    pub const fn new<Identity: IAMovieSetup_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Register<Identity: IAMovieSetup_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMovieSetup_Impl::Register(this).into()
            }
        }
        unsafe extern "system" fn Unregister<Identity: IAMovieSetup_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAMovieSetup_Impl::Unregister(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            Register: Register::<Identity, OFFSET>,
            Unregister: Unregister::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAMovieSetup as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAMovieSetup {}
windows_core::imp::define_interface!(IAsyncReader, IAsyncReader_Vtbl, 0x56a868aa_0ad4_11ce_b03a_0020af0ba770);
windows_core::imp::interface_hierarchy!(IAsyncReader, windows_core::IUnknown);
impl IAsyncReader {
    pub unsafe fn RequestAllocator<P0>(&self, ppreferred: P0, pprops: *const ALLOCATOR_PROPERTIES) -> windows_core::Result<IMemAllocator>
    where
        P0: windows_core::Param<IMemAllocator>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).RequestAllocator)(windows_core::Interface::as_raw(self), ppreferred.param().abi(), pprops, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn Request<P0>(&self, psample: P0, dwuser: usize) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IMediaSample>,
    {
        unsafe { (windows_core::Interface::vtable(self).Request)(windows_core::Interface::as_raw(self), psample.param().abi(), dwuser).ok() }
    }
    pub unsafe fn WaitForNext(&self, dwtimeout: u32, ppsample: Option<*mut Option<IMediaSample>>, pdwuser: *mut usize) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).WaitForNext)(windows_core::Interface::as_raw(self), dwtimeout, ppsample.unwrap_or(core::mem::zeroed()) as _, pdwuser as _).ok() }
    }
    pub unsafe fn SyncReadAligned<P0>(&self, psample: P0) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IMediaSample>,
    {
        unsafe { (windows_core::Interface::vtable(self).SyncReadAligned)(windows_core::Interface::as_raw(self), psample.param().abi()).ok() }
    }
    pub unsafe fn SyncRead(&self, llposition: i64, pbuffer: &mut [u8]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SyncRead)(windows_core::Interface::as_raw(self), llposition, pbuffer.len().try_into().unwrap(), core::mem::transmute(pbuffer.as_ptr())).ok() }
    }
    pub unsafe fn Length(&self, ptotal: *mut i64, pavailable: *mut i64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Length)(windows_core::Interface::as_raw(self), ptotal as _, pavailable as _).ok() }
    }
    pub unsafe fn BeginFlush(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).BeginFlush)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn EndFlush(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EndFlush)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
pub struct IAsyncReader_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub RequestAllocator: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *const ALLOCATOR_PROPERTIES, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Request: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, usize) -> windows_core::HRESULT,
    pub WaitForNext: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void, *mut usize) -> windows_core::HRESULT,
    pub SyncReadAligned: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SyncRead: unsafe extern "system" fn(*mut core::ffi::c_void, i64, i32, *mut u8) -> windows_core::HRESULT,
    pub Length: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i64, *mut i64) -> windows_core::HRESULT,
    pub BeginFlush: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub EndFlush: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAsyncReader_Impl: windows_core::IUnknownImpl {
    fn RequestAllocator(&self, ppreferred: windows_core::Ref<'_, IMemAllocator>, pprops: *const ALLOCATOR_PROPERTIES) -> windows_core::Result<IMemAllocator>;
    fn Request(&self, psample: windows_core::Ref<'_, IMediaSample>, dwuser: usize) -> windows_core::Result<()>;
    fn WaitForNext(&self, dwtimeout: u32, ppsample: windows_core::OutRef<'_, IMediaSample>, pdwuser: *mut usize) -> windows_core::Result<()>;
    fn SyncReadAligned(&self, psample: windows_core::Ref<'_, IMediaSample>) -> windows_core::Result<()>;
    fn SyncRead(&self, llposition: i64, llength: i32, pbuffer: *mut u8) -> windows_core::Result<()>;
    fn Length(&self, ptotal: *mut i64, pavailable: *mut i64) -> windows_core::Result<()>;
    fn BeginFlush(&self) -> windows_core::Result<()>;
    fn EndFlush(&self) -> windows_core::Result<()>;
}
impl IAsyncReader_Vtbl {
    pub const fn new<Identity: IAsyncReader_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn RequestAllocator<Identity: IAsyncReader_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppreferred: *mut core::ffi::c_void, pprops: *const ALLOCATOR_PROPERTIES, ppactual: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAsyncReader_Impl::RequestAllocator(this, core::mem::transmute_copy(&ppreferred), core::mem::transmute_copy(&pprops)) {
                    Ok(ok__) => {
                        ppactual.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn Request<Identity: IAsyncReader_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psample: *mut core::ffi::c_void, dwuser: usize) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAsyncReader_Impl::Request(this, core::mem::transmute_copy(&psample), core::mem::transmute_copy(&dwuser)).into()
            }
        }
        unsafe extern "system" fn WaitForNext<Identity: IAsyncReader_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwtimeout: u32, ppsample: *mut *mut core::ffi::c_void, pdwuser: *mut usize) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAsyncReader_Impl::WaitForNext(this, core::mem::transmute_copy(&dwtimeout), core::mem::transmute_copy(&ppsample), core::mem::transmute_copy(&pdwuser)).into()
            }
        }
        unsafe extern "system" fn SyncReadAligned<Identity: IAsyncReader_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psample: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAsyncReader_Impl::SyncReadAligned(this, core::mem::transmute_copy(&psample)).into()
            }
        }
        unsafe extern "system" fn SyncRead<Identity: IAsyncReader_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, llposition: i64, llength: i32, pbuffer: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAsyncReader_Impl::SyncRead(this, core::mem::transmute_copy(&llposition), core::mem::transmute_copy(&llength), core::mem::transmute_copy(&pbuffer)).into()
            }
        }
        unsafe extern "system" fn Length<Identity: IAsyncReader_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptotal: *mut i64, pavailable: *mut i64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAsyncReader_Impl::Length(this, core::mem::transmute_copy(&ptotal), core::mem::transmute_copy(&pavailable)).into()
            }
        }
        unsafe extern "system" fn BeginFlush<Identity: IAsyncReader_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAsyncReader_Impl::BeginFlush(this).into()
            }
        }
        unsafe extern "system" fn EndFlush<Identity: IAsyncReader_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAsyncReader_Impl::EndFlush(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            RequestAllocator: RequestAllocator::<Identity, OFFSET>,
            Request: Request::<Identity, OFFSET>,
            WaitForNext: WaitForNext::<Identity, OFFSET>,
            SyncReadAligned: SyncReadAligned::<Identity, OFFSET>,
            SyncRead: SyncRead::<Identity, OFFSET>,
            Length: Length::<Identity, OFFSET>,
            BeginFlush: BeginFlush::<Identity, OFFSET>,
            EndFlush: EndFlush::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAsyncReader as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAsyncReader {}
windows_core::imp::define_interface!(IAudioData, IAudioData_Vtbl, 0x54c719c0_af60_11d0_8212_00c04fc32c45);
impl core::ops::Deref for IAudioData {
    type Target = IMemoryData;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAudioData, windows_core::IUnknown, IMemoryData);
impl IAudioData {
    #[cfg(feature = "Win32_Media_Audio")]
    pub unsafe fn GetFormat(&self, pwaveformatcurrent: *mut super::Audio::WAVEFORMATEX) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetFormat)(windows_core::Interface::as_raw(self), pwaveformatcurrent as _).ok() }
    }
    #[cfg(feature = "Win32_Media_Audio")]
    pub unsafe fn SetFormat(&self, lpwaveformat: *const super::Audio::WAVEFORMATEX) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFormat)(windows_core::Interface::as_raw(self), lpwaveformat).ok() }
    }
}
#[repr(C)]
pub struct IAudioData_Vtbl {
    pub base__: IMemoryData_Vtbl,
    #[cfg(feature = "Win32_Media_Audio")]
    pub GetFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::Audio::WAVEFORMATEX) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio"))]
    GetFormat: usize,
    #[cfg(feature = "Win32_Media_Audio")]
    pub SetFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::Audio::WAVEFORMATEX) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio"))]
    SetFormat: usize,
}
#[cfg(feature = "Win32_Media_Audio")]
pub trait IAudioData_Impl: IMemoryData_Impl {
    fn GetFormat(&self, pwaveformatcurrent: *mut super::Audio::WAVEFORMATEX) -> windows_core::Result<()>;
    fn SetFormat(&self, lpwaveformat: *const super::Audio::WAVEFORMATEX) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Media_Audio")]
impl IAudioData_Vtbl {
    pub const fn new<Identity: IAudioData_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetFormat<Identity: IAudioData_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwaveformatcurrent: *mut super::Audio::WAVEFORMATEX) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAudioData_Impl::GetFormat(this, core::mem::transmute_copy(&pwaveformatcurrent)).into()
            }
        }
        unsafe extern "system" fn SetFormat<Identity: IAudioData_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpwaveformat: *const super::Audio::WAVEFORMATEX) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAudioData_Impl::SetFormat(this, core::mem::transmute_copy(&lpwaveformat)).into()
            }
        }
        Self { base__: IMemoryData_Vtbl::new::<Identity, OFFSET>(), GetFormat: GetFormat::<Identity, OFFSET>, SetFormat: SetFormat::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAudioData as windows_core::Interface>::IID || iid == &<IMemoryData as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Media_Audio")]
impl windows_core::RuntimeName for IAudioData {}
windows_core::imp::define_interface!(IAudioMediaStream, IAudioMediaStream_Vtbl, 0xf7537560_a3be_11d0_8212_00c04fc32c45);
impl core::ops::Deref for IAudioMediaStream {
    type Target = IMediaStream;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAudioMediaStream, windows_core::IUnknown, IMediaStream);
impl IAudioMediaStream {
    #[cfg(feature = "Win32_Media_Audio")]
    pub unsafe fn GetFormat(&self, pwaveformatcurrent: *mut super::Audio::WAVEFORMATEX) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetFormat)(windows_core::Interface::as_raw(self), pwaveformatcurrent as _).ok() }
    }
    #[cfg(feature = "Win32_Media_Audio")]
    pub unsafe fn SetFormat(&self, lpwaveformat: *const super::Audio::WAVEFORMATEX) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFormat)(windows_core::Interface::as_raw(self), lpwaveformat).ok() }
    }
    pub unsafe fn CreateSample<P0>(&self, paudiodata: P0, dwflags: u32) -> windows_core::Result<IAudioStreamSample>
    where
        P0: windows_core::Param<IAudioData>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateSample)(windows_core::Interface::as_raw(self), paudiodata.param().abi(), dwflags, &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
pub struct IAudioMediaStream_Vtbl {
    pub base__: IMediaStream_Vtbl,
    #[cfg(feature = "Win32_Media_Audio")]
    pub GetFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *mut super::Audio::WAVEFORMATEX) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio"))]
    GetFormat: usize,
    #[cfg(feature = "Win32_Media_Audio")]
    pub SetFormat: unsafe extern "system" fn(*mut core::ffi::c_void, *const super::Audio::WAVEFORMATEX) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio"))]
    SetFormat: usize,
    pub CreateSample: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Media_Audio")]
pub trait IAudioMediaStream_Impl: IMediaStream_Impl {
    fn GetFormat(&self, pwaveformatcurrent: *mut super::Audio::WAVEFORMATEX) -> windows_core::Result<()>;
    fn SetFormat(&self, lpwaveformat: *const super::Audio::WAVEFORMATEX) -> windows_core::Result<()>;
    fn CreateSample(&self, paudiodata: windows_core::Ref<'_, IAudioData>, dwflags: u32) -> windows_core::Result<IAudioStreamSample>;
}
#[cfg(feature = "Win32_Media_Audio")]
impl IAudioMediaStream_Vtbl {
    pub const fn new<Identity: IAudioMediaStream_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetFormat<Identity: IAudioMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pwaveformatcurrent: *mut super::Audio::WAVEFORMATEX) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAudioMediaStream_Impl::GetFormat(this, core::mem::transmute_copy(&pwaveformatcurrent)).into()
            }
        }
        unsafe extern "system" fn SetFormat<Identity: IAudioMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpwaveformat: *const super::Audio::WAVEFORMATEX) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IAudioMediaStream_Impl::SetFormat(this, core::mem::transmute_copy(&lpwaveformat)).into()
            }
        }
        unsafe extern "system" fn CreateSample<Identity: IAudioMediaStream_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, paudiodata: *mut core::ffi::c_void, dwflags: u32, ppsample: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAudioMediaStream_Impl::CreateSample(this, core::mem::transmute_copy(&paudiodata), core::mem::transmute_copy(&dwflags)) {
                    Ok(ok__) => {
                        ppsample.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: IMediaStream_Vtbl::new::<Identity, OFFSET>(),
            GetFormat: GetFormat::<Identity, OFFSET>,
            SetFormat: SetFormat::<Identity, OFFSET>,
            CreateSample: CreateSample::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAudioMediaStream as windows_core::Interface>::IID || iid == &<IMediaStream as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Media_Audio")]
impl windows_core::RuntimeName for IAudioMediaStream {}
windows_core::imp::define_interface!(IAudioStreamSample, IAudioStreamSample_Vtbl, 0x345fee00_aba5_11d0_8212_00c04fc32c45);
impl core::ops::Deref for IAudioStreamSample {
    type Target = IStreamSample;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IAudioStreamSample, windows_core::IUnknown, IStreamSample);
impl IAudioStreamSample {
    pub unsafe fn GetAudioData(&self) -> windows_core::Result<IAudioData> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetAudioData)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
}
#[repr(C)]
pub struct IAudioStreamSample_Vtbl {
    pub base__: IStreamSample_Vtbl,
    pub GetAudioData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IAudioStreamSample_Impl: IStreamSample_Impl {
    fn GetAudioData(&self) -> windows_core::Result<IAudioData>;
}
impl IAudioStreamSample_Vtbl {
    pub const fn new<Identity: IAudioStreamSample_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetAudioData<Identity: IAudioStreamSample_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppaudio: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IAudioStreamSample_Impl::GetAudioData(this) {
                    Ok(ok__) => {
                        ppaudio.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: IStreamSample_Vtbl::new::<Identity, OFFSET>(), GetAudioData: GetAudioData::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IAudioStreamSample as windows_core::Interface>::IID || iid == &<IStreamSample as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IAudioStreamSample {}
windows_core::imp::define_interface!(IBDA_AUX, IBDA_AUX_Vtbl, 0x7def4c09_6e66_4567_a819_f0e17f4a81ab);
windows_core::imp::interface_hierarchy!(IBDA_AUX, windows_core::IUnknown);
impl IBDA_AUX {
    pub unsafe fn QueryCapabilities(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).QueryCapabilities)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn EnumCapability(&self, dwindex: u32, dwinputid: *mut u32, pconnectortype: *mut windows_core::GUID, conntypenum: *mut u32, numvideostds: *mut u32, analogstds: *mut u64) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EnumCapability)(windows_core::Interface::as_raw(self), dwindex, dwinputid as _, pconnectortype as _, conntypenum as _, numvideostds as _, analogstds as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_AUX_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub QueryCapabilities: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub EnumCapability: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32, *mut windows_core::GUID, *mut u32, *mut u32, *mut u64) -> windows_core::HRESULT,
}
pub trait IBDA_AUX_Impl: windows_core::IUnknownImpl {
    fn QueryCapabilities(&self) -> windows_core::Result<u32>;
    fn EnumCapability(&self, dwindex: u32, dwinputid: *mut u32, pconnectortype: *mut windows_core::GUID, conntypenum: *mut u32, numvideostds: *mut u32, analogstds: *mut u64) -> windows_core::Result<()>;
}
impl IBDA_AUX_Vtbl {
    pub const fn new<Identity: IBDA_AUX_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn QueryCapabilities<Identity: IBDA_AUX_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwnumauxinputsbstr: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_AUX_Impl::QueryCapabilities(this) {
                    Ok(ok__) => {
                        pdwnumauxinputsbstr.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn EnumCapability<Identity: IBDA_AUX_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwindex: u32, dwinputid: *mut u32, pconnectortype: *mut windows_core::GUID, conntypenum: *mut u32, numvideostds: *mut u32, analogstds: *mut u64) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_AUX_Impl::EnumCapability(this, core::mem::transmute_copy(&dwindex), core::mem::transmute_copy(&dwinputid), core::mem::transmute_copy(&pconnectortype), core::mem::transmute_copy(&conntypenum), core::mem::transmute_copy(&numvideostds), core::mem::transmute_copy(&analogstds)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            QueryCapabilities: QueryCapabilities::<Identity, OFFSET>,
            EnumCapability: EnumCapability::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_AUX as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_AUX {}
windows_core::imp::define_interface!(IBDA_AutoDemodulate, IBDA_AutoDemodulate_Vtbl, 0xddf15b12_bd25_11d2_9ca0_00c04f7971e0);
windows_core::imp::interface_hierarchy!(IBDA_AutoDemodulate, windows_core::IUnknown);
impl IBDA_AutoDemodulate {
    pub unsafe fn put_AutoDemodulate(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).put_AutoDemodulate)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
pub struct IBDA_AutoDemodulate_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub put_AutoDemodulate: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IBDA_AutoDemodulate_Impl: windows_core::IUnknownImpl {
    fn put_AutoDemodulate(&self) -> windows_core::Result<()>;
}
impl IBDA_AutoDemodulate_Vtbl {
    pub const fn new<Identity: IBDA_AutoDemodulate_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn put_AutoDemodulate<Identity: IBDA_AutoDemodulate_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_AutoDemodulate_Impl::put_AutoDemodulate(this).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), put_AutoDemodulate: put_AutoDemodulate::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_AutoDemodulate as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_AutoDemodulate {}
windows_core::imp::define_interface!(IBDA_AutoDemodulateEx, IBDA_AutoDemodulateEx_Vtbl, 0x34518d13_1182_48e6_b28f_b24987787326);
impl core::ops::Deref for IBDA_AutoDemodulateEx {
    type Target = IBDA_AutoDemodulate;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBDA_AutoDemodulateEx, windows_core::IUnknown, IBDA_AutoDemodulate);
impl IBDA_AutoDemodulateEx {
    pub unsafe fn get_SupportedDeviceNodeTypes(&self, ulcdevicenodetypesmax: u32, pulcdevicenodetypes: *mut u32, pguiddevicenodetypes: *mut windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_SupportedDeviceNodeTypes)(windows_core::Interface::as_raw(self), ulcdevicenodetypesmax, pulcdevicenodetypes as _, pguiddevicenodetypes as _).ok() }
    }
    pub unsafe fn get_SupportedVideoFormats(&self, pulamtunermodetype: *mut u32, pulanalogvideostandard: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_SupportedVideoFormats)(windows_core::Interface::as_raw(self), pulamtunermodetype as _, pulanalogvideostandard as _).ok() }
    }
    pub unsafe fn get_AuxInputCount(&self, pulcompositecount: *mut u32, pulsvideocount: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_AuxInputCount)(windows_core::Interface::as_raw(self), pulcompositecount as _, pulsvideocount as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_AutoDemodulateEx_Vtbl {
    pub base__: IBDA_AutoDemodulate_Vtbl,
    pub get_SupportedDeviceNodeTypes: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub get_SupportedVideoFormats: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub get_AuxInputCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
}
pub trait IBDA_AutoDemodulateEx_Impl: IBDA_AutoDemodulate_Impl {
    fn get_SupportedDeviceNodeTypes(&self, ulcdevicenodetypesmax: u32, pulcdevicenodetypes: *mut u32, pguiddevicenodetypes: *mut windows_core::GUID) -> windows_core::Result<()>;
    fn get_SupportedVideoFormats(&self, pulamtunermodetype: *mut u32, pulanalogvideostandard: *mut u32) -> windows_core::Result<()>;
    fn get_AuxInputCount(&self, pulcompositecount: *mut u32, pulsvideocount: *mut u32) -> windows_core::Result<()>;
}
impl IBDA_AutoDemodulateEx_Vtbl {
    pub const fn new<Identity: IBDA_AutoDemodulateEx_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn get_SupportedDeviceNodeTypes<Identity: IBDA_AutoDemodulateEx_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulcdevicenodetypesmax: u32, pulcdevicenodetypes: *mut u32, pguiddevicenodetypes: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_AutoDemodulateEx_Impl::get_SupportedDeviceNodeTypes(this, core::mem::transmute_copy(&ulcdevicenodetypesmax), core::mem::transmute_copy(&pulcdevicenodetypes), core::mem::transmute_copy(&pguiddevicenodetypes)).into()
            }
        }
        unsafe extern "system" fn get_SupportedVideoFormats<Identity: IBDA_AutoDemodulateEx_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulamtunermodetype: *mut u32, pulanalogvideostandard: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_AutoDemodulateEx_Impl::get_SupportedVideoFormats(this, core::mem::transmute_copy(&pulamtunermodetype), core::mem::transmute_copy(&pulanalogvideostandard)).into()
            }
        }
        unsafe extern "system" fn get_AuxInputCount<Identity: IBDA_AutoDemodulateEx_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcompositecount: *mut u32, pulsvideocount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_AutoDemodulateEx_Impl::get_AuxInputCount(this, core::mem::transmute_copy(&pulcompositecount), core::mem::transmute_copy(&pulsvideocount)).into()
            }
        }
        Self {
            base__: IBDA_AutoDemodulate_Vtbl::new::<Identity, OFFSET>(),
            get_SupportedDeviceNodeTypes: get_SupportedDeviceNodeTypes::<Identity, OFFSET>,
            get_SupportedVideoFormats: get_SupportedVideoFormats::<Identity, OFFSET>,
            get_AuxInputCount: get_AuxInputCount::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_AutoDemodulateEx as windows_core::Interface>::IID || iid == &<IBDA_AutoDemodulate as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_AutoDemodulateEx {}
windows_core::imp::define_interface!(IBDA_ConditionalAccess, IBDA_ConditionalAccess_Vtbl, 0xcd51f1e0_7be9_4123_8482_a2a796c0a6b0);
windows_core::imp::interface_hierarchy!(IBDA_ConditionalAccess, windows_core::IUnknown);
impl IBDA_ConditionalAccess {
    pub unsafe fn get_SmartCardStatus(&self, pcardstatus: *mut SmartCardStatusType, pcardassociation: *mut SmartCardAssociationType, pbstrcarderror: *mut windows_core::BSTR, pfooblocked: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_SmartCardStatus)(windows_core::Interface::as_raw(self), pcardstatus as _, pcardassociation as _, core::mem::transmute(pbstrcarderror), pfooblocked as _).ok() }
    }
    pub unsafe fn get_SmartCardInfo(&self, pbstrcardname: *mut windows_core::BSTR, pbstrcardmanufacturer: *mut windows_core::BSTR, pfdaylightsavings: *mut super::super::Foundation::VARIANT_BOOL, pbyratingregion: *mut u8, pltimezoneoffsetminutes: *mut i32, pbstrlanguage: *mut windows_core::BSTR, pealocationcode: *mut EALocationCodeType) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_SmartCardInfo)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrcardname), core::mem::transmute(pbstrcardmanufacturer), pfdaylightsavings as _, pbyratingregion as _, pltimezoneoffsetminutes as _, core::mem::transmute(pbstrlanguage), pealocationcode as _).ok() }
    }
    pub unsafe fn get_SmartCardApplications(&self, pulcapplications: *mut u32, rgapplications: &mut [SmartCardApplication]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_SmartCardApplications)(windows_core::Interface::as_raw(self), pulcapplications as _, rgapplications.len().try_into().unwrap(), core::mem::transmute(rgapplications.as_ptr())).ok() }
    }
    pub unsafe fn get_Entitlement(&self, usvirtualchannel: u16) -> windows_core::Result<EntitlementType> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).get_Entitlement)(windows_core::Interface::as_raw(self), usvirtualchannel, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn TuneByChannel(&self, usvirtualchannel: u16) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TuneByChannel)(windows_core::Interface::as_raw(self), usvirtualchannel).ok() }
    }
    pub unsafe fn SetProgram(&self, usprogramnumber: u16) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetProgram)(windows_core::Interface::as_raw(self), usprogramnumber).ok() }
    }
    pub unsafe fn AddProgram(&self, usprogramnumber: u16) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AddProgram)(windows_core::Interface::as_raw(self), usprogramnumber).ok() }
    }
    pub unsafe fn RemoveProgram(&self, usprogramnumber: u16) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveProgram)(windows_core::Interface::as_raw(self), usprogramnumber).ok() }
    }
    pub unsafe fn GetModuleUI(&self, bydialognumber: u8) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetModuleUI)(windows_core::Interface::as_raw(self), bydialognumber, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn InformUIClosed(&self, bydialognumber: u8, closereason: UICloseReasonType) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).InformUIClosed)(windows_core::Interface::as_raw(self), bydialognumber, closereason).ok() }
    }
}
#[repr(C)]
pub struct IBDA_ConditionalAccess_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub get_SmartCardStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut SmartCardStatusType, *mut SmartCardAssociationType, *mut *mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT,
    pub get_SmartCardInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut super::super::Foundation::VARIANT_BOOL, *mut u8, *mut i32, *mut *mut core::ffi::c_void, *mut EALocationCodeType) -> windows_core::HRESULT,
    pub get_SmartCardApplications: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, u32, *mut SmartCardApplication) -> windows_core::HRESULT,
    pub get_Entitlement: unsafe extern "system" fn(*mut core::ffi::c_void, u16, *mut EntitlementType) -> windows_core::HRESULT,
    pub TuneByChannel: unsafe extern "system" fn(*mut core::ffi::c_void, u16) -> windows_core::HRESULT,
    pub SetProgram: unsafe extern "system" fn(*mut core::ffi::c_void, u16) -> windows_core::HRESULT,
    pub AddProgram: unsafe extern "system" fn(*mut core::ffi::c_void, u16) -> windows_core::HRESULT,
    pub RemoveProgram: unsafe extern "system" fn(*mut core::ffi::c_void, u16) -> windows_core::HRESULT,
    pub GetModuleUI: unsafe extern "system" fn(*mut core::ffi::c_void, u8, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub InformUIClosed: unsafe extern "system" fn(*mut core::ffi::c_void, u8, UICloseReasonType) -> windows_core::HRESULT,
}
pub trait IBDA_ConditionalAccess_Impl: windows_core::IUnknownImpl {
    fn get_SmartCardStatus(&self, pcardstatus: *mut SmartCardStatusType, pcardassociation: *mut SmartCardAssociationType, pbstrcarderror: *mut windows_core::BSTR, pfooblocked: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::Result<()>;
    fn get_SmartCardInfo(&self, pbstrcardname: *mut windows_core::BSTR, pbstrcardmanufacturer: *mut windows_core::BSTR, pfdaylightsavings: *mut super::super::Foundation::VARIANT_BOOL, pbyratingregion: *mut u8, pltimezoneoffsetminutes: *mut i32, pbstrlanguage: *mut windows_core::BSTR, pealocationcode: *mut EALocationCodeType) -> windows_core::Result<()>;
    fn get_SmartCardApplications(&self, pulcapplications: *mut u32, ulcapplicationsmax: u32, rgapplications: *mut SmartCardApplication) -> windows_core::Result<()>;
    fn get_Entitlement(&self, usvirtualchannel: u16) -> windows_core::Result<EntitlementType>;
    fn TuneByChannel(&self, usvirtualchannel: u16) -> windows_core::Result<()>;
    fn SetProgram(&self, usprogramnumber: u16) -> windows_core::Result<()>;
    fn AddProgram(&self, usprogramnumber: u16) -> windows_core::Result<()>;
    fn RemoveProgram(&self, usprogramnumber: u16) -> windows_core::Result<()>;
    fn GetModuleUI(&self, bydialognumber: u8) -> windows_core::Result<windows_core::BSTR>;
    fn InformUIClosed(&self, bydialognumber: u8, closereason: UICloseReasonType) -> windows_core::Result<()>;
}
impl IBDA_ConditionalAccess_Vtbl {
    pub const fn new<Identity: IBDA_ConditionalAccess_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn get_SmartCardStatus<Identity: IBDA_ConditionalAccess_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pcardstatus: *mut SmartCardStatusType, pcardassociation: *mut SmartCardAssociationType, pbstrcarderror: *mut *mut core::ffi::c_void, pfooblocked: *mut super::super::Foundation::VARIANT_BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_ConditionalAccess_Impl::get_SmartCardStatus(this, core::mem::transmute_copy(&pcardstatus), core::mem::transmute_copy(&pcardassociation), core::mem::transmute_copy(&pbstrcarderror), core::mem::transmute_copy(&pfooblocked)).into()
            }
        }
        unsafe extern "system" fn get_SmartCardInfo<Identity: IBDA_ConditionalAccess_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrcardname: *mut *mut core::ffi::c_void, pbstrcardmanufacturer: *mut *mut core::ffi::c_void, pfdaylightsavings: *mut super::super::Foundation::VARIANT_BOOL, pbyratingregion: *mut u8, pltimezoneoffsetminutes: *mut i32, pbstrlanguage: *mut *mut core::ffi::c_void, pealocationcode: *mut EALocationCodeType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_ConditionalAccess_Impl::get_SmartCardInfo(this, core::mem::transmute_copy(&pbstrcardname), core::mem::transmute_copy(&pbstrcardmanufacturer), core::mem::transmute_copy(&pfdaylightsavings), core::mem::transmute_copy(&pbyratingregion), core::mem::transmute_copy(&pltimezoneoffsetminutes), core::mem::transmute_copy(&pbstrlanguage), core::mem::transmute_copy(&pealocationcode)).into()
            }
        }
        unsafe extern "system" fn get_SmartCardApplications<Identity: IBDA_ConditionalAccess_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcapplications: *mut u32, ulcapplicationsmax: u32, rgapplications: *mut SmartCardApplication) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_ConditionalAccess_Impl::get_SmartCardApplications(this, core::mem::transmute_copy(&pulcapplications), core::mem::transmute_copy(&ulcapplicationsmax), core::mem::transmute_copy(&rgapplications)).into()
            }
        }
        unsafe extern "system" fn get_Entitlement<Identity: IBDA_ConditionalAccess_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, usvirtualchannel: u16, pentitlement: *mut EntitlementType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_ConditionalAccess_Impl::get_Entitlement(this, core::mem::transmute_copy(&usvirtualchannel)) {
                    Ok(ok__) => {
                        pentitlement.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn TuneByChannel<Identity: IBDA_ConditionalAccess_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, usvirtualchannel: u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_ConditionalAccess_Impl::TuneByChannel(this, core::mem::transmute_copy(&usvirtualchannel)).into()
            }
        }
        unsafe extern "system" fn SetProgram<Identity: IBDA_ConditionalAccess_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, usprogramnumber: u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_ConditionalAccess_Impl::SetProgram(this, core::mem::transmute_copy(&usprogramnumber)).into()
            }
        }
        unsafe extern "system" fn AddProgram<Identity: IBDA_ConditionalAccess_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, usprogramnumber: u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_ConditionalAccess_Impl::AddProgram(this, core::mem::transmute_copy(&usprogramnumber)).into()
            }
        }
        unsafe extern "system" fn RemoveProgram<Identity: IBDA_ConditionalAccess_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, usprogramnumber: u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_ConditionalAccess_Impl::RemoveProgram(this, core::mem::transmute_copy(&usprogramnumber)).into()
            }
        }
        unsafe extern "system" fn GetModuleUI<Identity: IBDA_ConditionalAccess_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bydialognumber: u8, pbstrurl: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_ConditionalAccess_Impl::GetModuleUI(this, core::mem::transmute_copy(&bydialognumber)) {
                    Ok(ok__) => {
                        pbstrurl.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn InformUIClosed<Identity: IBDA_ConditionalAccess_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bydialognumber: u8, closereason: UICloseReasonType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_ConditionalAccess_Impl::InformUIClosed(this, core::mem::transmute_copy(&bydialognumber), core::mem::transmute_copy(&closereason)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            get_SmartCardStatus: get_SmartCardStatus::<Identity, OFFSET>,
            get_SmartCardInfo: get_SmartCardInfo::<Identity, OFFSET>,
            get_SmartCardApplications: get_SmartCardApplications::<Identity, OFFSET>,
            get_Entitlement: get_Entitlement::<Identity, OFFSET>,
            TuneByChannel: TuneByChannel::<Identity, OFFSET>,
            SetProgram: SetProgram::<Identity, OFFSET>,
            AddProgram: AddProgram::<Identity, OFFSET>,
            RemoveProgram: RemoveProgram::<Identity, OFFSET>,
            GetModuleUI: GetModuleUI::<Identity, OFFSET>,
            InformUIClosed: InformUIClosed::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_ConditionalAccess as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_ConditionalAccess {}
windows_core::imp::define_interface!(IBDA_ConditionalAccessEx, IBDA_ConditionalAccessEx_Vtbl, 0x497c3418_23cb_44ba_bb62_769f506fcea7);
windows_core::imp::interface_hierarchy!(IBDA_ConditionalAccessEx, windows_core::IUnknown);
impl IBDA_ConditionalAccessEx {
    pub unsafe fn CheckEntitlementToken(&self, uldialogrequest: u32, bstrlanguage: &windows_core::BSTR, requesttype: BDA_CONDITIONALACCESS_REQUESTTYPE, pbentitlementtoken: &[u8]) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CheckEntitlementToken)(windows_core::Interface::as_raw(self), uldialogrequest, core::mem::transmute_copy(bstrlanguage), requesttype, pbentitlementtoken.len().try_into().unwrap(), core::mem::transmute(pbentitlementtoken.as_ptr()), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetCaptureToken(&self, pbcapturetoken: &[u8]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCaptureToken)(windows_core::Interface::as_raw(self), pbcapturetoken.len().try_into().unwrap(), core::mem::transmute(pbcapturetoken.as_ptr())).ok() }
    }
    pub unsafe fn OpenBroadcastMmi(&self, uldialogrequest: u32, bstrlanguage: &windows_core::BSTR, eventid: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).OpenBroadcastMmi)(windows_core::Interface::as_raw(self), uldialogrequest, core::mem::transmute_copy(bstrlanguage), eventid).ok() }
    }
    pub unsafe fn CloseMmiDialog(&self, uldialogrequest: u32, bstrlanguage: &windows_core::BSTR, uldialognumber: u32, reasoncode: BDA_CONDITIONALACCESS_MMICLOSEREASON) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CloseMmiDialog)(windows_core::Interface::as_raw(self), uldialogrequest, core::mem::transmute_copy(bstrlanguage), uldialognumber, reasoncode, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn CreateDialogRequestNumber(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).CreateDialogRequestNumber)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IBDA_ConditionalAccessEx_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub CheckEntitlementToken: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, BDA_CONDITIONALACCESS_REQUESTTYPE, u32, *const u8, *mut u32) -> windows_core::HRESULT,
    pub SetCaptureToken: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u8) -> windows_core::HRESULT,
    pub OpenBroadcastMmi: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub CloseMmiDialog: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, u32, BDA_CONDITIONALACCESS_MMICLOSEREASON, *mut u32) -> windows_core::HRESULT,
    pub CreateDialogRequestNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IBDA_ConditionalAccessEx_Impl: windows_core::IUnknownImpl {
    fn CheckEntitlementToken(&self, uldialogrequest: u32, bstrlanguage: &windows_core::BSTR, requesttype: BDA_CONDITIONALACCESS_REQUESTTYPE, ulcbentitlementtokenlen: u32, pbentitlementtoken: *const u8) -> windows_core::Result<u32>;
    fn SetCaptureToken(&self, ulcbcapturetokenlen: u32, pbcapturetoken: *const u8) -> windows_core::Result<()>;
    fn OpenBroadcastMmi(&self, uldialogrequest: u32, bstrlanguage: &windows_core::BSTR, eventid: u32) -> windows_core::Result<()>;
    fn CloseMmiDialog(&self, uldialogrequest: u32, bstrlanguage: &windows_core::BSTR, uldialognumber: u32, reasoncode: BDA_CONDITIONALACCESS_MMICLOSEREASON) -> windows_core::Result<u32>;
    fn CreateDialogRequestNumber(&self) -> windows_core::Result<u32>;
}
impl IBDA_ConditionalAccessEx_Vtbl {
    pub const fn new<Identity: IBDA_ConditionalAccessEx_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CheckEntitlementToken<Identity: IBDA_ConditionalAccessEx_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, uldialogrequest: u32, bstrlanguage: *mut core::ffi::c_void, requesttype: BDA_CONDITIONALACCESS_REQUESTTYPE, ulcbentitlementtokenlen: u32, pbentitlementtoken: *const u8, puldescramblestatus: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_ConditionalAccessEx_Impl::CheckEntitlementToken(this, core::mem::transmute_copy(&uldialogrequest), core::mem::transmute(&bstrlanguage), core::mem::transmute_copy(&requesttype), core::mem::transmute_copy(&ulcbentitlementtokenlen), core::mem::transmute_copy(&pbentitlementtoken)) {
                    Ok(ok__) => {
                        puldescramblestatus.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetCaptureToken<Identity: IBDA_ConditionalAccessEx_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulcbcapturetokenlen: u32, pbcapturetoken: *const u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_ConditionalAccessEx_Impl::SetCaptureToken(this, core::mem::transmute_copy(&ulcbcapturetokenlen), core::mem::transmute_copy(&pbcapturetoken)).into()
            }
        }
        unsafe extern "system" fn OpenBroadcastMmi<Identity: IBDA_ConditionalAccessEx_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, uldialogrequest: u32, bstrlanguage: *mut core::ffi::c_void, eventid: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_ConditionalAccessEx_Impl::OpenBroadcastMmi(this, core::mem::transmute_copy(&uldialogrequest), core::mem::transmute(&bstrlanguage), core::mem::transmute_copy(&eventid)).into()
            }
        }
        unsafe extern "system" fn CloseMmiDialog<Identity: IBDA_ConditionalAccessEx_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, uldialogrequest: u32, bstrlanguage: *mut core::ffi::c_void, uldialognumber: u32, reasoncode: BDA_CONDITIONALACCESS_MMICLOSEREASON, pulsessionresult: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_ConditionalAccessEx_Impl::CloseMmiDialog(this, core::mem::transmute_copy(&uldialogrequest), core::mem::transmute(&bstrlanguage), core::mem::transmute_copy(&uldialognumber), core::mem::transmute_copy(&reasoncode)) {
                    Ok(ok__) => {
                        pulsessionresult.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn CreateDialogRequestNumber<Identity: IBDA_ConditionalAccessEx_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, puldialogrequestnumber: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_ConditionalAccessEx_Impl::CreateDialogRequestNumber(this) {
                    Ok(ok__) => {
                        puldialogrequestnumber.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            CheckEntitlementToken: CheckEntitlementToken::<Identity, OFFSET>,
            SetCaptureToken: SetCaptureToken::<Identity, OFFSET>,
            OpenBroadcastMmi: OpenBroadcastMmi::<Identity, OFFSET>,
            CloseMmiDialog: CloseMmiDialog::<Identity, OFFSET>,
            CreateDialogRequestNumber: CreateDialogRequestNumber::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_ConditionalAccessEx as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_ConditionalAccessEx {}
windows_core::imp::define_interface!(IBDA_DRIDRMService, IBDA_DRIDRMService_Vtbl, 0x1f9bc2a5_44a3_4c52_aab1_0bbce5a1381d);
windows_core::imp::interface_hierarchy!(IBDA_DRIDRMService, windows_core::IUnknown);
impl IBDA_DRIDRMService {
    pub unsafe fn SetDRM(&self, bstrnewdrm: &windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDRM)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(bstrnewdrm)).ok() }
    }
    pub unsafe fn GetDRMStatus(&self, pbstrdrmuuidlist: *mut windows_core::BSTR, drmuuid: *mut windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDRMStatus)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrdrmuuidlist), drmuuid as _).ok() }
    }
    pub unsafe fn GetPairingStatus(&self, penumpairingstatus: *mut BDA_DrmPairingError) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetPairingStatus)(windows_core::Interface::as_raw(self), penumpairingstatus as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_DRIDRMService_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetDRM: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetDRMStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub GetPairingStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut BDA_DrmPairingError) -> windows_core::HRESULT,
}
pub trait IBDA_DRIDRMService_Impl: windows_core::IUnknownImpl {
    fn SetDRM(&self, bstrnewdrm: &windows_core::BSTR) -> windows_core::Result<()>;
    fn GetDRMStatus(&self, pbstrdrmuuidlist: *mut windows_core::BSTR, drmuuid: *mut windows_core::GUID) -> windows_core::Result<()>;
    fn GetPairingStatus(&self, penumpairingstatus: *mut BDA_DrmPairingError) -> windows_core::Result<()>;
}
impl IBDA_DRIDRMService_Vtbl {
    pub const fn new<Identity: IBDA_DRIDRMService_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetDRM<Identity: IBDA_DRIDRMService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bstrnewdrm: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DRIDRMService_Impl::SetDRM(this, core::mem::transmute(&bstrnewdrm)).into()
            }
        }
        unsafe extern "system" fn GetDRMStatus<Identity: IBDA_DRIDRMService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrdrmuuidlist: *mut *mut core::ffi::c_void, drmuuid: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DRIDRMService_Impl::GetDRMStatus(this, core::mem::transmute_copy(&pbstrdrmuuidlist), core::mem::transmute_copy(&drmuuid)).into()
            }
        }
        unsafe extern "system" fn GetPairingStatus<Identity: IBDA_DRIDRMService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, penumpairingstatus: *mut BDA_DrmPairingError) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DRIDRMService_Impl::GetPairingStatus(this, core::mem::transmute_copy(&penumpairingstatus)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetDRM: SetDRM::<Identity, OFFSET>,
            GetDRMStatus: GetDRMStatus::<Identity, OFFSET>,
            GetPairingStatus: GetPairingStatus::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_DRIDRMService as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_DRIDRMService {}
windows_core::imp::define_interface!(IBDA_DRIWMDRMSession, IBDA_DRIWMDRMSession_Vtbl, 0x05c690f8_56db_4bb2_b053_79c12098bb26);
windows_core::imp::interface_hierarchy!(IBDA_DRIWMDRMSession, windows_core::IUnknown);
impl IBDA_DRIWMDRMSession {
    pub unsafe fn AcknowledgeLicense(&self, hrlicenseack: windows_core::HRESULT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).AcknowledgeLicense)(windows_core::Interface::as_raw(self), hrlicenseack).ok() }
    }
    pub unsafe fn ProcessLicenseChallenge(&self, pblicensemessage: &[u8], pdwcblicenseresponse: *mut u32, ppblicenseresponse: *mut *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ProcessLicenseChallenge)(windows_core::Interface::as_raw(self), pblicensemessage.len().try_into().unwrap(), core::mem::transmute(pblicensemessage.as_ptr()), pdwcblicenseresponse as _, ppblicenseresponse as _).ok() }
    }
    pub unsafe fn ProcessRegistrationChallenge(&self, pbregistrationmessage: &[u8], pdwcbregistrationresponse: *mut u32, ppbregistrationresponse: *mut *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ProcessRegistrationChallenge)(windows_core::Interface::as_raw(self), pbregistrationmessage.len().try_into().unwrap(), core::mem::transmute(pbregistrationmessage.as_ptr()), pdwcbregistrationresponse as _, ppbregistrationresponse as _).ok() }
    }
    pub unsafe fn SetRevInfo(&self, pbrevinfo: &[u8], pdwresponse: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetRevInfo)(windows_core::Interface::as_raw(self), pbrevinfo.len().try_into().unwrap(), core::mem::transmute(pbrevinfo.as_ptr()), pdwresponse as _).ok() }
    }
    pub unsafe fn SetCrl(&self, pbcrllen: &[u8], pdwresponse: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCrl)(windows_core::Interface::as_raw(self), pbcrllen.len().try_into().unwrap(), core::mem::transmute(pbcrllen.as_ptr()), pdwresponse as _).ok() }
    }
    pub unsafe fn GetHMSAssociationData(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetHMSAssociationData)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetLastCardeaError(&self, pdwerror: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetLastCardeaError)(windows_core::Interface::as_raw(self), pdwerror as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_DRIWMDRMSession_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub AcknowledgeLicense: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::HRESULT) -> windows_core::HRESULT,
    pub ProcessLicenseChallenge: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u8, *mut u32, *mut *mut u8) -> windows_core::HRESULT,
    pub ProcessRegistrationChallenge: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u8, *mut u32, *mut *mut u8) -> windows_core::HRESULT,
    pub SetRevInfo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u8, *mut u32) -> windows_core::HRESULT,
    pub SetCrl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u8, *mut u32) -> windows_core::HRESULT,
    pub GetHMSAssociationData: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetLastCardeaError: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IBDA_DRIWMDRMSession_Impl: windows_core::IUnknownImpl {
    fn AcknowledgeLicense(&self, hrlicenseack: windows_core::HRESULT) -> windows_core::Result<()>;
    fn ProcessLicenseChallenge(&self, dwcblicensemessage: u32, pblicensemessage: *const u8, pdwcblicenseresponse: *mut u32, ppblicenseresponse: *mut *mut u8) -> windows_core::Result<()>;
    fn ProcessRegistrationChallenge(&self, dwcbregistrationmessage: u32, pbregistrationmessage: *const u8, pdwcbregistrationresponse: *mut u32, ppbregistrationresponse: *mut *mut u8) -> windows_core::Result<()>;
    fn SetRevInfo(&self, dwrevinfolen: u32, pbrevinfo: *const u8, pdwresponse: *mut u32) -> windows_core::Result<()>;
    fn SetCrl(&self, dwcrllen: u32, pbcrllen: *const u8, pdwresponse: *mut u32) -> windows_core::Result<()>;
    fn GetHMSAssociationData(&self) -> windows_core::Result<()>;
    fn GetLastCardeaError(&self, pdwerror: *mut u32) -> windows_core::Result<()>;
}
impl IBDA_DRIWMDRMSession_Vtbl {
    pub const fn new<Identity: IBDA_DRIWMDRMSession_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn AcknowledgeLicense<Identity: IBDA_DRIWMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, hrlicenseack: windows_core::HRESULT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DRIWMDRMSession_Impl::AcknowledgeLicense(this, core::mem::transmute_copy(&hrlicenseack)).into()
            }
        }
        unsafe extern "system" fn ProcessLicenseChallenge<Identity: IBDA_DRIWMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwcblicensemessage: u32, pblicensemessage: *const u8, pdwcblicenseresponse: *mut u32, ppblicenseresponse: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DRIWMDRMSession_Impl::ProcessLicenseChallenge(this, core::mem::transmute_copy(&dwcblicensemessage), core::mem::transmute_copy(&pblicensemessage), core::mem::transmute_copy(&pdwcblicenseresponse), core::mem::transmute_copy(&ppblicenseresponse)).into()
            }
        }
        unsafe extern "system" fn ProcessRegistrationChallenge<Identity: IBDA_DRIWMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwcbregistrationmessage: u32, pbregistrationmessage: *const u8, pdwcbregistrationresponse: *mut u32, ppbregistrationresponse: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DRIWMDRMSession_Impl::ProcessRegistrationChallenge(this, core::mem::transmute_copy(&dwcbregistrationmessage), core::mem::transmute_copy(&pbregistrationmessage), core::mem::transmute_copy(&pdwcbregistrationresponse), core::mem::transmute_copy(&ppbregistrationresponse)).into()
            }
        }
        unsafe extern "system" fn SetRevInfo<Identity: IBDA_DRIWMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwrevinfolen: u32, pbrevinfo: *const u8, pdwresponse: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DRIWMDRMSession_Impl::SetRevInfo(this, core::mem::transmute_copy(&dwrevinfolen), core::mem::transmute_copy(&pbrevinfo), core::mem::transmute_copy(&pdwresponse)).into()
            }
        }
        unsafe extern "system" fn SetCrl<Identity: IBDA_DRIWMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwcrllen: u32, pbcrllen: *const u8, pdwresponse: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DRIWMDRMSession_Impl::SetCrl(this, core::mem::transmute_copy(&dwcrllen), core::mem::transmute_copy(&pbcrllen), core::mem::transmute_copy(&pdwresponse)).into()
            }
        }
        unsafe extern "system" fn GetHMSAssociationData<Identity: IBDA_DRIWMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DRIWMDRMSession_Impl::GetHMSAssociationData(this).into()
            }
        }
        unsafe extern "system" fn GetLastCardeaError<Identity: IBDA_DRIWMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwerror: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DRIWMDRMSession_Impl::GetLastCardeaError(this, core::mem::transmute_copy(&pdwerror)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            AcknowledgeLicense: AcknowledgeLicense::<Identity, OFFSET>,
            ProcessLicenseChallenge: ProcessLicenseChallenge::<Identity, OFFSET>,
            ProcessRegistrationChallenge: ProcessRegistrationChallenge::<Identity, OFFSET>,
            SetRevInfo: SetRevInfo::<Identity, OFFSET>,
            SetCrl: SetCrl::<Identity, OFFSET>,
            GetHMSAssociationData: GetHMSAssociationData::<Identity, OFFSET>,
            GetLastCardeaError: GetLastCardeaError::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_DRIWMDRMSession as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_DRIWMDRMSession {}
windows_core::imp::define_interface!(IBDA_DRM, IBDA_DRM_Vtbl, 0xf98d88b0_1992_4cd6_a6d9_b9afab99330d);
windows_core::imp::interface_hierarchy!(IBDA_DRM, windows_core::IUnknown);
impl IBDA_DRM {
    pub unsafe fn GetDRMPairingStatus(&self, pdwstatus: *mut u32, pherror: *mut windows_core::HRESULT) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDRMPairingStatus)(windows_core::Interface::as_raw(self), pdwstatus as _, pherror as _).ok() }
    }
    pub unsafe fn PerformDRMPairing(&self, fsync: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PerformDRMPairing)(windows_core::Interface::as_raw(self), fsync.into()).ok() }
    }
}
#[repr(C)]
pub struct IBDA_DRM_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetDRMPairingStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut windows_core::HRESULT) -> windows_core::HRESULT,
    pub PerformDRMPairing: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::BOOL) -> windows_core::HRESULT,
}
pub trait IBDA_DRM_Impl: windows_core::IUnknownImpl {
    fn GetDRMPairingStatus(&self, pdwstatus: *mut u32, pherror: *mut windows_core::HRESULT) -> windows_core::Result<()>;
    fn PerformDRMPairing(&self, fsync: windows_core::BOOL) -> windows_core::Result<()>;
}
impl IBDA_DRM_Vtbl {
    pub const fn new<Identity: IBDA_DRM_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetDRMPairingStatus<Identity: IBDA_DRM_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwstatus: *mut u32, pherror: *mut windows_core::HRESULT) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DRM_Impl::GetDRMPairingStatus(this, core::mem::transmute_copy(&pdwstatus), core::mem::transmute_copy(&pherror)).into()
            }
        }
        unsafe extern "system" fn PerformDRMPairing<Identity: IBDA_DRM_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fsync: windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DRM_Impl::PerformDRMPairing(this, core::mem::transmute_copy(&fsync)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetDRMPairingStatus: GetDRMPairingStatus::<Identity, OFFSET>,
            PerformDRMPairing: PerformDRMPairing::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_DRM as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_DRM {}
windows_core::imp::define_interface!(IBDA_DRMService, IBDA_DRMService_Vtbl, 0xbff6b5bb_b0ae_484c_9dca_73528fb0b46e);
windows_core::imp::interface_hierarchy!(IBDA_DRMService, windows_core::IUnknown);
impl IBDA_DRMService {
    pub unsafe fn SetDRM(&self, puuidnewdrm: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDRM)(windows_core::Interface::as_raw(self), puuidnewdrm).ok() }
    }
    pub unsafe fn GetDRMStatus(&self, pbstrdrmuuidlist: *mut windows_core::BSTR, drmuuid: *mut windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetDRMStatus)(windows_core::Interface::as_raw(self), core::mem::transmute(pbstrdrmuuidlist), drmuuid as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_DRMService_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetDRM: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub GetDRMStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
}
pub trait IBDA_DRMService_Impl: windows_core::IUnknownImpl {
    fn SetDRM(&self, puuidnewdrm: *const windows_core::GUID) -> windows_core::Result<()>;
    fn GetDRMStatus(&self, pbstrdrmuuidlist: *mut windows_core::BSTR, drmuuid: *mut windows_core::GUID) -> windows_core::Result<()>;
}
impl IBDA_DRMService_Vtbl {
    pub const fn new<Identity: IBDA_DRMService_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetDRM<Identity: IBDA_DRMService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, puuidnewdrm: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DRMService_Impl::SetDRM(this, core::mem::transmute_copy(&puuidnewdrm)).into()
            }
        }
        unsafe extern "system" fn GetDRMStatus<Identity: IBDA_DRMService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrdrmuuidlist: *mut *mut core::ffi::c_void, drmuuid: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DRMService_Impl::GetDRMStatus(this, core::mem::transmute_copy(&pbstrdrmuuidlist), core::mem::transmute_copy(&drmuuid)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetDRM: SetDRM::<Identity, OFFSET>,
            GetDRMStatus: GetDRMStatus::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_DRMService as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_DRMService {}
windows_core::imp::define_interface!(IBDA_DeviceControl, IBDA_DeviceControl_Vtbl, 0xfd0a5af3_b41d_11d2_9c95_00c04f7971e0);
windows_core::imp::interface_hierarchy!(IBDA_DeviceControl, windows_core::IUnknown);
impl IBDA_DeviceControl {
    pub unsafe fn StartChanges(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).StartChanges)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn CheckChanges(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CheckChanges)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn CommitChanges(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CommitChanges)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetChangeState(&self, pstate: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetChangeState)(windows_core::Interface::as_raw(self), pstate as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_DeviceControl_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub StartChanges: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CheckChanges: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub CommitChanges: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetChangeState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IBDA_DeviceControl_Impl: windows_core::IUnknownImpl {
    fn StartChanges(&self) -> windows_core::Result<()>;
    fn CheckChanges(&self) -> windows_core::Result<()>;
    fn CommitChanges(&self) -> windows_core::Result<()>;
    fn GetChangeState(&self, pstate: *mut u32) -> windows_core::Result<()>;
}
impl IBDA_DeviceControl_Vtbl {
    pub const fn new<Identity: IBDA_DeviceControl_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn StartChanges<Identity: IBDA_DeviceControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DeviceControl_Impl::StartChanges(this).into()
            }
        }
        unsafe extern "system" fn CheckChanges<Identity: IBDA_DeviceControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DeviceControl_Impl::CheckChanges(this).into()
            }
        }
        unsafe extern "system" fn CommitChanges<Identity: IBDA_DeviceControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DeviceControl_Impl::CommitChanges(this).into()
            }
        }
        unsafe extern "system" fn GetChangeState<Identity: IBDA_DeviceControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pstate: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DeviceControl_Impl::GetChangeState(this, core::mem::transmute_copy(&pstate)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            StartChanges: StartChanges::<Identity, OFFSET>,
            CheckChanges: CheckChanges::<Identity, OFFSET>,
            CommitChanges: CommitChanges::<Identity, OFFSET>,
            GetChangeState: GetChangeState::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_DeviceControl as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_DeviceControl {}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
windows_core::imp::define_interface!(IBDA_DiagnosticProperties, IBDA_DiagnosticProperties_Vtbl, 0x20e80cb5_c543_4c1b_8eb3_49e719eee7d4);
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
impl core::ops::Deref for IBDA_DiagnosticProperties {
    type Target = super::super::System::Com::StructuredStorage::IPropertyBag;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
windows_core::imp::interface_hierarchy!(IBDA_DiagnosticProperties, windows_core::IUnknown, super::super::System::Com::StructuredStorage::IPropertyBag);
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
#[repr(C)]
pub struct IBDA_DiagnosticProperties_Vtbl {
    pub base__: super::super::System::Com::StructuredStorage::IPropertyBag_Vtbl,
}
#[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
pub trait IBDA_DiagnosticProperties_Impl: super::super::System::Com::StructuredStorage::IPropertyBag_Impl {}
#[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl IBDA_DiagnosticProperties_Vtbl {
    pub const fn new<Identity: IBDA_DiagnosticProperties_Impl, const OFFSET: isize>() -> Self {
        Self { base__: super::super::System::Com::StructuredStorage::IPropertyBag_Vtbl::new::<Identity, OFFSET>() }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_DiagnosticProperties as windows_core::Interface>::IID || iid == &<super::super::System::Com::StructuredStorage::IPropertyBag as windows_core::Interface>::IID
    }
}
#[cfg(all(feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
impl windows_core::RuntimeName for IBDA_DiagnosticProperties {}
windows_core::imp::define_interface!(IBDA_DigitalDemodulator, IBDA_DigitalDemodulator_Vtbl, 0xef30f379_985b_4d10_b640_a79d5e04e1e0);
windows_core::imp::interface_hierarchy!(IBDA_DigitalDemodulator, windows_core::IUnknown);
impl IBDA_DigitalDemodulator {
    pub unsafe fn SetModulationType(&self, pmodulationtype: *const ModulationType) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetModulationType)(windows_core::Interface::as_raw(self), pmodulationtype).ok() }
    }
    pub unsafe fn ModulationType(&self, pmodulationtype: *mut ModulationType) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ModulationType)(windows_core::Interface::as_raw(self), pmodulationtype as _).ok() }
    }
    pub unsafe fn SetInnerFECMethod(&self, pfecmethod: *const FECMethod) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetInnerFECMethod)(windows_core::Interface::as_raw(self), pfecmethod).ok() }
    }
    pub unsafe fn InnerFECMethod(&self, pfecmethod: *mut FECMethod) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).InnerFECMethod)(windows_core::Interface::as_raw(self), pfecmethod as _).ok() }
    }
    pub unsafe fn SetInnerFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetInnerFECRate)(windows_core::Interface::as_raw(self), pfecrate).ok() }
    }
    pub unsafe fn InnerFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).InnerFECRate)(windows_core::Interface::as_raw(self), pfecrate as _).ok() }
    }
    pub unsafe fn SetOuterFECMethod(&self, pfecmethod: *const FECMethod) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOuterFECMethod)(windows_core::Interface::as_raw(self), pfecmethod).ok() }
    }
    pub unsafe fn OuterFECMethod(&self, pfecmethod: *mut FECMethod) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).OuterFECMethod)(windows_core::Interface::as_raw(self), pfecmethod as _).ok() }
    }
    pub unsafe fn SetOuterFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetOuterFECRate)(windows_core::Interface::as_raw(self), pfecrate).ok() }
    }
    pub unsafe fn OuterFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).OuterFECRate)(windows_core::Interface::as_raw(self), pfecrate as _).ok() }
    }
    pub unsafe fn SetSymbolRate(&self, psymbolrate: *const u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSymbolRate)(windows_core::Interface::as_raw(self), psymbolrate).ok() }
    }
    pub unsafe fn SymbolRate(&self, psymbolrate: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SymbolRate)(windows_core::Interface::as_raw(self), psymbolrate as _).ok() }
    }
    pub unsafe fn SetSpectralInversion(&self, pspectralinversion: *const SpectralInversion) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSpectralInversion)(windows_core::Interface::as_raw(self), pspectralinversion).ok() }
    }
    pub unsafe fn SpectralInversion(&self, pspectralinversion: *mut SpectralInversion) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SpectralInversion)(windows_core::Interface::as_raw(self), pspectralinversion as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_DigitalDemodulator_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetModulationType: unsafe extern "system" fn(*mut core::ffi::c_void, *const ModulationType) -> windows_core::HRESULT,
    pub ModulationType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut ModulationType) -> windows_core::HRESULT,
    pub SetInnerFECMethod: unsafe extern "system" fn(*mut core::ffi::c_void, *const FECMethod) -> windows_core::HRESULT,
    pub InnerFECMethod: unsafe extern "system" fn(*mut core::ffi::c_void, *mut FECMethod) -> windows_core::HRESULT,
    pub SetInnerFECRate: unsafe extern "system" fn(*mut core::ffi::c_void, *const BinaryConvolutionCodeRate) -> windows_core::HRESULT,
    pub InnerFECRate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut BinaryConvolutionCodeRate) -> windows_core::HRESULT,
    pub SetOuterFECMethod: unsafe extern "system" fn(*mut core::ffi::c_void, *const FECMethod) -> windows_core::HRESULT,
    pub OuterFECMethod: unsafe extern "system" fn(*mut core::ffi::c_void, *mut FECMethod) -> windows_core::HRESULT,
    pub SetOuterFECRate: unsafe extern "system" fn(*mut core::ffi::c_void, *const BinaryConvolutionCodeRate) -> windows_core::HRESULT,
    pub OuterFECRate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut BinaryConvolutionCodeRate) -> windows_core::HRESULT,
    pub SetSymbolRate: unsafe extern "system" fn(*mut core::ffi::c_void, *const u32) -> windows_core::HRESULT,
    pub SymbolRate: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetSpectralInversion: unsafe extern "system" fn(*mut core::ffi::c_void, *const SpectralInversion) -> windows_core::HRESULT,
    pub SpectralInversion: unsafe extern "system" fn(*mut core::ffi::c_void, *mut SpectralInversion) -> windows_core::HRESULT,
}
pub trait IBDA_DigitalDemodulator_Impl: windows_core::IUnknownImpl {
    fn SetModulationType(&self, pmodulationtype: *const ModulationType) -> windows_core::Result<()>;
    fn ModulationType(&self, pmodulationtype: *mut ModulationType) -> windows_core::Result<()>;
    fn SetInnerFECMethod(&self, pfecmethod: *const FECMethod) -> windows_core::Result<()>;
    fn InnerFECMethod(&self, pfecmethod: *mut FECMethod) -> windows_core::Result<()>;
    fn SetInnerFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> windows_core::Result<()>;
    fn InnerFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> windows_core::Result<()>;
    fn SetOuterFECMethod(&self, pfecmethod: *const FECMethod) -> windows_core::Result<()>;
    fn OuterFECMethod(&self, pfecmethod: *mut FECMethod) -> windows_core::Result<()>;
    fn SetOuterFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> windows_core::Result<()>;
    fn OuterFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> windows_core::Result<()>;
    fn SetSymbolRate(&self, psymbolrate: *const u32) -> windows_core::Result<()>;
    fn SymbolRate(&self, psymbolrate: *mut u32) -> windows_core::Result<()>;
    fn SetSpectralInversion(&self, pspectralinversion: *const SpectralInversion) -> windows_core::Result<()>;
    fn SpectralInversion(&self, pspectralinversion: *mut SpectralInversion) -> windows_core::Result<()>;
}
impl IBDA_DigitalDemodulator_Vtbl {
    pub const fn new<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetModulationType<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmodulationtype: *const ModulationType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator_Impl::SetModulationType(this, core::mem::transmute_copy(&pmodulationtype)).into()
            }
        }
        unsafe extern "system" fn ModulationType<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pmodulationtype: *mut ModulationType) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator_Impl::ModulationType(this, core::mem::transmute_copy(&pmodulationtype)).into()
            }
        }
        unsafe extern "system" fn SetInnerFECMethod<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfecmethod: *const FECMethod) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator_Impl::SetInnerFECMethod(this, core::mem::transmute_copy(&pfecmethod)).into()
            }
        }
        unsafe extern "system" fn InnerFECMethod<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfecmethod: *mut FECMethod) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator_Impl::InnerFECMethod(this, core::mem::transmute_copy(&pfecmethod)).into()
            }
        }
        unsafe extern "system" fn SetInnerFECRate<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfecrate: *const BinaryConvolutionCodeRate) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator_Impl::SetInnerFECRate(this, core::mem::transmute_copy(&pfecrate)).into()
            }
        }
        unsafe extern "system" fn InnerFECRate<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfecrate: *mut BinaryConvolutionCodeRate) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator_Impl::InnerFECRate(this, core::mem::transmute_copy(&pfecrate)).into()
            }
        }
        unsafe extern "system" fn SetOuterFECMethod<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfecmethod: *const FECMethod) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator_Impl::SetOuterFECMethod(this, core::mem::transmute_copy(&pfecmethod)).into()
            }
        }
        unsafe extern "system" fn OuterFECMethod<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfecmethod: *mut FECMethod) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator_Impl::OuterFECMethod(this, core::mem::transmute_copy(&pfecmethod)).into()
            }
        }
        unsafe extern "system" fn SetOuterFECRate<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfecrate: *const BinaryConvolutionCodeRate) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator_Impl::SetOuterFECRate(this, core::mem::transmute_copy(&pfecrate)).into()
            }
        }
        unsafe extern "system" fn OuterFECRate<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfecrate: *mut BinaryConvolutionCodeRate) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator_Impl::OuterFECRate(this, core::mem::transmute_copy(&pfecrate)).into()
            }
        }
        unsafe extern "system" fn SetSymbolRate<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psymbolrate: *const u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator_Impl::SetSymbolRate(this, core::mem::transmute_copy(&psymbolrate)).into()
            }
        }
        unsafe extern "system" fn SymbolRate<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psymbolrate: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator_Impl::SymbolRate(this, core::mem::transmute_copy(&psymbolrate)).into()
            }
        }
        unsafe extern "system" fn SetSpectralInversion<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pspectralinversion: *const SpectralInversion) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator_Impl::SetSpectralInversion(this, core::mem::transmute_copy(&pspectralinversion)).into()
            }
        }
        unsafe extern "system" fn SpectralInversion<Identity: IBDA_DigitalDemodulator_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pspectralinversion: *mut SpectralInversion) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator_Impl::SpectralInversion(this, core::mem::transmute_copy(&pspectralinversion)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetModulationType: SetModulationType::<Identity, OFFSET>,
            ModulationType: ModulationType::<Identity, OFFSET>,
            SetInnerFECMethod: SetInnerFECMethod::<Identity, OFFSET>,
            InnerFECMethod: InnerFECMethod::<Identity, OFFSET>,
            SetInnerFECRate: SetInnerFECRate::<Identity, OFFSET>,
            InnerFECRate: InnerFECRate::<Identity, OFFSET>,
            SetOuterFECMethod: SetOuterFECMethod::<Identity, OFFSET>,
            OuterFECMethod: OuterFECMethod::<Identity, OFFSET>,
            SetOuterFECRate: SetOuterFECRate::<Identity, OFFSET>,
            OuterFECRate: OuterFECRate::<Identity, OFFSET>,
            SetSymbolRate: SetSymbolRate::<Identity, OFFSET>,
            SymbolRate: SymbolRate::<Identity, OFFSET>,
            SetSpectralInversion: SetSpectralInversion::<Identity, OFFSET>,
            SpectralInversion: SpectralInversion::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_DigitalDemodulator as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_DigitalDemodulator {}
windows_core::imp::define_interface!(IBDA_DigitalDemodulator2, IBDA_DigitalDemodulator2_Vtbl, 0x525ed3ee_5cf3_4e1e_9a06_5368a84f9a6e);
impl core::ops::Deref for IBDA_DigitalDemodulator2 {
    type Target = IBDA_DigitalDemodulator;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBDA_DigitalDemodulator2, windows_core::IUnknown, IBDA_DigitalDemodulator);
impl IBDA_DigitalDemodulator2 {
    pub unsafe fn SetGuardInterval(&self, pguardinterval: *const GuardInterval) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetGuardInterval)(windows_core::Interface::as_raw(self), pguardinterval).ok() }
    }
    pub unsafe fn GuardInterval(&self, pguardinterval: *mut GuardInterval) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GuardInterval)(windows_core::Interface::as_raw(self), pguardinterval as _).ok() }
    }
    pub unsafe fn SetTransmissionMode(&self, ptransmissionmode: *const TransmissionMode) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTransmissionMode)(windows_core::Interface::as_raw(self), ptransmissionmode).ok() }
    }
    pub unsafe fn TransmissionMode(&self, ptransmissionmode: *mut TransmissionMode) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TransmissionMode)(windows_core::Interface::as_raw(self), ptransmissionmode as _).ok() }
    }
    pub unsafe fn SetRollOff(&self, prolloff: *const RollOff) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetRollOff)(windows_core::Interface::as_raw(self), prolloff).ok() }
    }
    pub unsafe fn RollOff(&self, prolloff: *mut RollOff) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RollOff)(windows_core::Interface::as_raw(self), prolloff as _).ok() }
    }
    pub unsafe fn SetPilot(&self, ppilot: *const Pilot) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPilot)(windows_core::Interface::as_raw(self), ppilot).ok() }
    }
    pub unsafe fn Pilot(&self, ppilot: *mut Pilot) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Pilot)(windows_core::Interface::as_raw(self), ppilot as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_DigitalDemodulator2_Vtbl {
    pub base__: IBDA_DigitalDemodulator_Vtbl,
    pub SetGuardInterval: unsafe extern "system" fn(*mut core::ffi::c_void, *const GuardInterval) -> windows_core::HRESULT,
    pub GuardInterval: unsafe extern "system" fn(*mut core::ffi::c_void, *mut GuardInterval) -> windows_core::HRESULT,
    pub SetTransmissionMode: unsafe extern "system" fn(*mut core::ffi::c_void, *const TransmissionMode) -> windows_core::HRESULT,
    pub TransmissionMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut TransmissionMode) -> windows_core::HRESULT,
    pub SetRollOff: unsafe extern "system" fn(*mut core::ffi::c_void, *const RollOff) -> windows_core::HRESULT,
    pub RollOff: unsafe extern "system" fn(*mut core::ffi::c_void, *mut RollOff) -> windows_core::HRESULT,
    pub SetPilot: unsafe extern "system" fn(*mut core::ffi::c_void, *const Pilot) -> windows_core::HRESULT,
    pub Pilot: unsafe extern "system" fn(*mut core::ffi::c_void, *mut Pilot) -> windows_core::HRESULT,
}
pub trait IBDA_DigitalDemodulator2_Impl: IBDA_DigitalDemodulator_Impl {
    fn SetGuardInterval(&self, pguardinterval: *const GuardInterval) -> windows_core::Result<()>;
    fn GuardInterval(&self, pguardinterval: *mut GuardInterval) -> windows_core::Result<()>;
    fn SetTransmissionMode(&self, ptransmissionmode: *const TransmissionMode) -> windows_core::Result<()>;
    fn TransmissionMode(&self, ptransmissionmode: *mut TransmissionMode) -> windows_core::Result<()>;
    fn SetRollOff(&self, prolloff: *const RollOff) -> windows_core::Result<()>;
    fn RollOff(&self, prolloff: *mut RollOff) -> windows_core::Result<()>;
    fn SetPilot(&self, ppilot: *const Pilot) -> windows_core::Result<()>;
    fn Pilot(&self, ppilot: *mut Pilot) -> windows_core::Result<()>;
}
impl IBDA_DigitalDemodulator2_Vtbl {
    pub const fn new<Identity: IBDA_DigitalDemodulator2_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetGuardInterval<Identity: IBDA_DigitalDemodulator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguardinterval: *const GuardInterval) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator2_Impl::SetGuardInterval(this, core::mem::transmute_copy(&pguardinterval)).into()
            }
        }
        unsafe extern "system" fn GuardInterval<Identity: IBDA_DigitalDemodulator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguardinterval: *mut GuardInterval) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator2_Impl::GuardInterval(this, core::mem::transmute_copy(&pguardinterval)).into()
            }
        }
        unsafe extern "system" fn SetTransmissionMode<Identity: IBDA_DigitalDemodulator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptransmissionmode: *const TransmissionMode) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator2_Impl::SetTransmissionMode(this, core::mem::transmute_copy(&ptransmissionmode)).into()
            }
        }
        unsafe extern "system" fn TransmissionMode<Identity: IBDA_DigitalDemodulator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ptransmissionmode: *mut TransmissionMode) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator2_Impl::TransmissionMode(this, core::mem::transmute_copy(&ptransmissionmode)).into()
            }
        }
        unsafe extern "system" fn SetRollOff<Identity: IBDA_DigitalDemodulator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prolloff: *const RollOff) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator2_Impl::SetRollOff(this, core::mem::transmute_copy(&prolloff)).into()
            }
        }
        unsafe extern "system" fn RollOff<Identity: IBDA_DigitalDemodulator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, prolloff: *mut RollOff) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator2_Impl::RollOff(this, core::mem::transmute_copy(&prolloff)).into()
            }
        }
        unsafe extern "system" fn SetPilot<Identity: IBDA_DigitalDemodulator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppilot: *const Pilot) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator2_Impl::SetPilot(this, core::mem::transmute_copy(&ppilot)).into()
            }
        }
        unsafe extern "system" fn Pilot<Identity: IBDA_DigitalDemodulator2_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppilot: *mut Pilot) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator2_Impl::Pilot(this, core::mem::transmute_copy(&ppilot)).into()
            }
        }
        Self {
            base__: IBDA_DigitalDemodulator_Vtbl::new::<Identity, OFFSET>(),
            SetGuardInterval: SetGuardInterval::<Identity, OFFSET>,
            GuardInterval: GuardInterval::<Identity, OFFSET>,
            SetTransmissionMode: SetTransmissionMode::<Identity, OFFSET>,
            TransmissionMode: TransmissionMode::<Identity, OFFSET>,
            SetRollOff: SetRollOff::<Identity, OFFSET>,
            RollOff: RollOff::<Identity, OFFSET>,
            SetPilot: SetPilot::<Identity, OFFSET>,
            Pilot: Pilot::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_DigitalDemodulator2 as windows_core::Interface>::IID || iid == &<IBDA_DigitalDemodulator as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_DigitalDemodulator2 {}
windows_core::imp::define_interface!(IBDA_DigitalDemodulator3, IBDA_DigitalDemodulator3_Vtbl, 0x13f19604_7d32_4359_93a2_a05205d90ac9);
impl core::ops::Deref for IBDA_DigitalDemodulator3 {
    type Target = IBDA_DigitalDemodulator2;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBDA_DigitalDemodulator3, windows_core::IUnknown, IBDA_DigitalDemodulator, IBDA_DigitalDemodulator2);
impl IBDA_DigitalDemodulator3 {
    pub unsafe fn SetSignalTimeouts(&self, psignaltimeouts: *const BDA_SIGNAL_TIMEOUTS) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSignalTimeouts)(windows_core::Interface::as_raw(self), psignaltimeouts).ok() }
    }
    pub unsafe fn SignalTimeouts(&self, psignaltimeouts: *mut BDA_SIGNAL_TIMEOUTS) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SignalTimeouts)(windows_core::Interface::as_raw(self), psignaltimeouts as _).ok() }
    }
    pub unsafe fn SetPLPNumber(&self, pplpnumber: *const u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPLPNumber)(windows_core::Interface::as_raw(self), pplpnumber).ok() }
    }
    pub unsafe fn PLPNumber(&self, pplpnumber: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PLPNumber)(windows_core::Interface::as_raw(self), pplpnumber as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_DigitalDemodulator3_Vtbl {
    pub base__: IBDA_DigitalDemodulator2_Vtbl,
    pub SetSignalTimeouts: unsafe extern "system" fn(*mut core::ffi::c_void, *const BDA_SIGNAL_TIMEOUTS) -> windows_core::HRESULT,
    pub SignalTimeouts: unsafe extern "system" fn(*mut core::ffi::c_void, *mut BDA_SIGNAL_TIMEOUTS) -> windows_core::HRESULT,
    pub SetPLPNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *const u32) -> windows_core::HRESULT,
    pub PLPNumber: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IBDA_DigitalDemodulator3_Impl: IBDA_DigitalDemodulator2_Impl {
    fn SetSignalTimeouts(&self, psignaltimeouts: *const BDA_SIGNAL_TIMEOUTS) -> windows_core::Result<()>;
    fn SignalTimeouts(&self, psignaltimeouts: *mut BDA_SIGNAL_TIMEOUTS) -> windows_core::Result<()>;
    fn SetPLPNumber(&self, pplpnumber: *const u32) -> windows_core::Result<()>;
    fn PLPNumber(&self, pplpnumber: *mut u32) -> windows_core::Result<()>;
}
impl IBDA_DigitalDemodulator3_Vtbl {
    pub const fn new<Identity: IBDA_DigitalDemodulator3_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetSignalTimeouts<Identity: IBDA_DigitalDemodulator3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psignaltimeouts: *const BDA_SIGNAL_TIMEOUTS) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator3_Impl::SetSignalTimeouts(this, core::mem::transmute_copy(&psignaltimeouts)).into()
            }
        }
        unsafe extern "system" fn SignalTimeouts<Identity: IBDA_DigitalDemodulator3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, psignaltimeouts: *mut BDA_SIGNAL_TIMEOUTS) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator3_Impl::SignalTimeouts(this, core::mem::transmute_copy(&psignaltimeouts)).into()
            }
        }
        unsafe extern "system" fn SetPLPNumber<Identity: IBDA_DigitalDemodulator3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pplpnumber: *const u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator3_Impl::SetPLPNumber(this, core::mem::transmute_copy(&pplpnumber)).into()
            }
        }
        unsafe extern "system" fn PLPNumber<Identity: IBDA_DigitalDemodulator3_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pplpnumber: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DigitalDemodulator3_Impl::PLPNumber(this, core::mem::transmute_copy(&pplpnumber)).into()
            }
        }
        Self {
            base__: IBDA_DigitalDemodulator2_Vtbl::new::<Identity, OFFSET>(),
            SetSignalTimeouts: SetSignalTimeouts::<Identity, OFFSET>,
            SignalTimeouts: SignalTimeouts::<Identity, OFFSET>,
            SetPLPNumber: SetPLPNumber::<Identity, OFFSET>,
            PLPNumber: PLPNumber::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_DigitalDemodulator3 as windows_core::Interface>::IID || iid == &<IBDA_DigitalDemodulator as windows_core::Interface>::IID || iid == &<IBDA_DigitalDemodulator2 as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_DigitalDemodulator3 {}
windows_core::imp::define_interface!(IBDA_DiseqCommand, IBDA_DiseqCommand_Vtbl, 0xf84e2ab0_3c6b_45e3_a0fc_8669d4b81f11);
windows_core::imp::interface_hierarchy!(IBDA_DiseqCommand, windows_core::IUnknown);
impl IBDA_DiseqCommand {
    pub unsafe fn SetEnableDiseqCommands(&self, benable: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetEnableDiseqCommands)(windows_core::Interface::as_raw(self), benable).ok() }
    }
    pub unsafe fn SetDiseqLNBSource(&self, ullnbsource: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDiseqLNBSource)(windows_core::Interface::as_raw(self), ullnbsource).ok() }
    }
    pub unsafe fn SetDiseqUseToneBurst(&self, busetoneburst: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDiseqUseToneBurst)(windows_core::Interface::as_raw(self), busetoneburst).ok() }
    }
    pub unsafe fn SetDiseqRepeats(&self, ulrepeats: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetDiseqRepeats)(windows_core::Interface::as_raw(self), ulrepeats).ok() }
    }
    pub unsafe fn put_DiseqSendCommand(&self, ulrequestid: u32, pbcommand: &[u8]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).put_DiseqSendCommand)(windows_core::Interface::as_raw(self), ulrequestid, pbcommand.len().try_into().unwrap(), core::mem::transmute(pbcommand.as_ptr())).ok() }
    }
    pub unsafe fn get_DiseqResponse(&self, ulrequestid: u32, pulcbresponselen: *mut u32, pbresponse: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_DiseqResponse)(windows_core::Interface::as_raw(self), ulrequestid, pulcbresponselen as _, pbresponse as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_DiseqCommand_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetEnableDiseqCommands: unsafe extern "system" fn(*mut core::ffi::c_void, bool) -> windows_core::HRESULT,
    pub SetDiseqLNBSource: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub SetDiseqUseToneBurst: unsafe extern "system" fn(*mut core::ffi::c_void, bool) -> windows_core::HRESULT,
    pub SetDiseqRepeats: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub put_DiseqSendCommand: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *const u8) -> windows_core::HRESULT,
    pub get_DiseqResponse: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32, *mut u8) -> windows_core::HRESULT,
}
pub trait IBDA_DiseqCommand_Impl: windows_core::IUnknownImpl {
    fn SetEnableDiseqCommands(&self, benable: bool) -> windows_core::Result<()>;
    fn SetDiseqLNBSource(&self, ullnbsource: u32) -> windows_core::Result<()>;
    fn SetDiseqUseToneBurst(&self, busetoneburst: bool) -> windows_core::Result<()>;
    fn SetDiseqRepeats(&self, ulrepeats: u32) -> windows_core::Result<()>;
    fn put_DiseqSendCommand(&self, ulrequestid: u32, ulcbcommandlen: u32, pbcommand: *const u8) -> windows_core::Result<()>;
    fn get_DiseqResponse(&self, ulrequestid: u32, pulcbresponselen: *mut u32, pbresponse: *mut u8) -> windows_core::Result<()>;
}
impl IBDA_DiseqCommand_Vtbl {
    pub const fn new<Identity: IBDA_DiseqCommand_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetEnableDiseqCommands<Identity: IBDA_DiseqCommand_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, benable: bool) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DiseqCommand_Impl::SetEnableDiseqCommands(this, core::mem::transmute_copy(&benable)).into()
            }
        }
        unsafe extern "system" fn SetDiseqLNBSource<Identity: IBDA_DiseqCommand_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ullnbsource: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DiseqCommand_Impl::SetDiseqLNBSource(this, core::mem::transmute_copy(&ullnbsource)).into()
            }
        }
        unsafe extern "system" fn SetDiseqUseToneBurst<Identity: IBDA_DiseqCommand_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, busetoneburst: bool) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DiseqCommand_Impl::SetDiseqUseToneBurst(this, core::mem::transmute_copy(&busetoneburst)).into()
            }
        }
        unsafe extern "system" fn SetDiseqRepeats<Identity: IBDA_DiseqCommand_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulrepeats: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DiseqCommand_Impl::SetDiseqRepeats(this, core::mem::transmute_copy(&ulrepeats)).into()
            }
        }
        unsafe extern "system" fn put_DiseqSendCommand<Identity: IBDA_DiseqCommand_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulrequestid: u32, ulcbcommandlen: u32, pbcommand: *const u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DiseqCommand_Impl::put_DiseqSendCommand(this, core::mem::transmute_copy(&ulrequestid), core::mem::transmute_copy(&ulcbcommandlen), core::mem::transmute_copy(&pbcommand)).into()
            }
        }
        unsafe extern "system" fn get_DiseqResponse<Identity: IBDA_DiseqCommand_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulrequestid: u32, pulcbresponselen: *mut u32, pbresponse: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_DiseqCommand_Impl::get_DiseqResponse(this, core::mem::transmute_copy(&ulrequestid), core::mem::transmute_copy(&pulcbresponselen), core::mem::transmute_copy(&pbresponse)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetEnableDiseqCommands: SetEnableDiseqCommands::<Identity, OFFSET>,
            SetDiseqLNBSource: SetDiseqLNBSource::<Identity, OFFSET>,
            SetDiseqUseToneBurst: SetDiseqUseToneBurst::<Identity, OFFSET>,
            SetDiseqRepeats: SetDiseqRepeats::<Identity, OFFSET>,
            put_DiseqSendCommand: put_DiseqSendCommand::<Identity, OFFSET>,
            get_DiseqResponse: get_DiseqResponse::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_DiseqCommand as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_DiseqCommand {}
windows_core::imp::define_interface!(IBDA_EasMessage, IBDA_EasMessage_Vtbl, 0xd806973d_3ebe_46de_8fbb_6358fe784208);
windows_core::imp::interface_hierarchy!(IBDA_EasMessage, windows_core::IUnknown);
impl IBDA_EasMessage {
    pub unsafe fn get_EasMessage(&self, uleventid: u32, ppeasobject: *mut Option<windows_core::IUnknown>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_EasMessage)(windows_core::Interface::as_raw(self), uleventid, core::mem::transmute(ppeasobject)).ok() }
    }
}
#[repr(C)]
pub struct IBDA_EasMessage_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub get_EasMessage: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IBDA_EasMessage_Impl: windows_core::IUnknownImpl {
    fn get_EasMessage(&self, uleventid: u32, ppeasobject: windows_core::OutRef<'_, windows_core::IUnknown>) -> windows_core::Result<()>;
}
impl IBDA_EasMessage_Vtbl {
    pub const fn new<Identity: IBDA_EasMessage_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn get_EasMessage<Identity: IBDA_EasMessage_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, uleventid: u32, ppeasobject: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_EasMessage_Impl::get_EasMessage(this, core::mem::transmute_copy(&uleventid), core::mem::transmute_copy(&ppeasobject)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), get_EasMessage: get_EasMessage::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_EasMessage as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_EasMessage {}
windows_core::imp::define_interface!(IBDA_Encoder, IBDA_Encoder_Vtbl, 0x3a8bad59_59fe_4559_a0ba_396cfaa98ae3);
windows_core::imp::interface_hierarchy!(IBDA_Encoder, windows_core::IUnknown);
impl IBDA_Encoder {
    pub unsafe fn QueryCapabilities(&self, numaudiofmts: *mut u32, numvideofmts: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).QueryCapabilities)(windows_core::Interface::as_raw(self), numaudiofmts as _, numvideofmts as _).ok() }
    }
    pub unsafe fn EnumAudioCapability(&self, fmtindex: u32, methodid: *mut u32, algorithmtype: *mut u32, samplingrate: *mut u32, bitdepth: *mut u32, numchannels: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EnumAudioCapability)(windows_core::Interface::as_raw(self), fmtindex, methodid as _, algorithmtype as _, samplingrate as _, bitdepth as _, numchannels as _).ok() }
    }
    pub unsafe fn EnumVideoCapability(&self, fmtindex: u32, methodid: *mut u32, algorithmtype: *mut u32, verticalsize: *mut u32, horizontalsize: *mut u32, aspectratio: *mut u32, frameratecode: *mut u32, progressivesequence: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).EnumVideoCapability)(windows_core::Interface::as_raw(self), fmtindex, methodid as _, algorithmtype as _, verticalsize as _, horizontalsize as _, aspectratio as _, frameratecode as _, progressivesequence as _).ok() }
    }
    pub unsafe fn SetParameters(&self, audiobitratemode: u32, audiobitrate: u32, audiomethodid: u32, audioprogram: u32, videobitratemode: u32, videobitrate: u32, videomethodid: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetParameters)(windows_core::Interface::as_raw(self), audiobitratemode, audiobitrate, audiomethodid, audioprogram, videobitratemode, videobitrate, videomethodid).ok() }
    }
    pub unsafe fn GetState(&self, audiobitratemax: *mut u32, audiobitratemin: *mut u32, audiobitratemode: *mut u32, audiobitratestepping: *mut u32, audiobitrate: *mut u32, audiomethodid: *mut u32, availableaudioprograms: *mut u32, audioprogram: *mut u32, videobitratemax: *mut u32, videobitratemin: *mut u32, videobitratemode: *mut u32, videobitrate: *mut u32, videobitratestepping: *mut u32, videomethodid: *mut u32, signalsourceid: *mut u32, signalformat: *mut u64, signallock: *mut windows_core::BOOL, signallevel: *mut i32, signaltonoiseratio: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetState)(windows_core::Interface::as_raw(self), audiobitratemax as _, audiobitratemin as _, audiobitratemode as _, audiobitratestepping as _, audiobitrate as _, audiomethodid as _, availableaudioprograms as _, audioprogram as _, videobitratemax as _, videobitratemin as _, videobitratemode as _, videobitrate as _, videobitratestepping as _, videomethodid as _, signalsourceid as _, signalformat as _, signallock as _, signallevel as _, signaltonoiseratio as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_Encoder_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub QueryCapabilities: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub EnumAudioCapability: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub EnumVideoCapability: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetParameters: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, u32, u32, u32, u32) -> windows_core::HRESULT,
    pub GetState: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u64, *mut windows_core::BOOL, *mut i32, *mut u32) -> windows_core::HRESULT,
}
pub trait IBDA_Encoder_Impl: windows_core::IUnknownImpl {
    fn QueryCapabilities(&self, numaudiofmts: *mut u32, numvideofmts: *mut u32) -> windows_core::Result<()>;
    fn EnumAudioCapability(&self, fmtindex: u32, methodid: *mut u32, algorithmtype: *mut u32, samplingrate: *mut u32, bitdepth: *mut u32, numchannels: *mut u32) -> windows_core::Result<()>;
    fn EnumVideoCapability(&self, fmtindex: u32, methodid: *mut u32, algorithmtype: *mut u32, verticalsize: *mut u32, horizontalsize: *mut u32, aspectratio: *mut u32, frameratecode: *mut u32, progressivesequence: *mut u32) -> windows_core::Result<()>;
    fn SetParameters(&self, audiobitratemode: u32, audiobitrate: u32, audiomethodid: u32, audioprogram: u32, videobitratemode: u32, videobitrate: u32, videomethodid: u32) -> windows_core::Result<()>;
    fn GetState(&self, audiobitratemax: *mut u32, audiobitratemin: *mut u32, audiobitratemode: *mut u32, audiobitratestepping: *mut u32, audiobitrate: *mut u32, audiomethodid: *mut u32, availableaudioprograms: *mut u32, audioprogram: *mut u32, videobitratemax: *mut u32, videobitratemin: *mut u32, videobitratemode: *mut u32, videobitrate: *mut u32, videobitratestepping: *mut u32, videomethodid: *mut u32, signalsourceid: *mut u32, signalformat: *mut u64, signallock: *mut windows_core::BOOL, signallevel: *mut i32, signaltonoiseratio: *mut u32) -> windows_core::Result<()>;
}
impl IBDA_Encoder_Vtbl {
    pub const fn new<Identity: IBDA_Encoder_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn QueryCapabilities<Identity: IBDA_Encoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, numaudiofmts: *mut u32, numvideofmts: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Encoder_Impl::QueryCapabilities(this, core::mem::transmute_copy(&numaudiofmts), core::mem::transmute_copy(&numvideofmts)).into()
            }
        }
        unsafe extern "system" fn EnumAudioCapability<Identity: IBDA_Encoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fmtindex: u32, methodid: *mut u32, algorithmtype: *mut u32, samplingrate: *mut u32, bitdepth: *mut u32, numchannels: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Encoder_Impl::EnumAudioCapability(this, core::mem::transmute_copy(&fmtindex), core::mem::transmute_copy(&methodid), core::mem::transmute_copy(&algorithmtype), core::mem::transmute_copy(&samplingrate), core::mem::transmute_copy(&bitdepth), core::mem::transmute_copy(&numchannels)).into()
            }
        }
        unsafe extern "system" fn EnumVideoCapability<Identity: IBDA_Encoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fmtindex: u32, methodid: *mut u32, algorithmtype: *mut u32, verticalsize: *mut u32, horizontalsize: *mut u32, aspectratio: *mut u32, frameratecode: *mut u32, progressivesequence: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Encoder_Impl::EnumVideoCapability(this, core::mem::transmute_copy(&fmtindex), core::mem::transmute_copy(&methodid), core::mem::transmute_copy(&algorithmtype), core::mem::transmute_copy(&verticalsize), core::mem::transmute_copy(&horizontalsize), core::mem::transmute_copy(&aspectratio), core::mem::transmute_copy(&frameratecode), core::mem::transmute_copy(&progressivesequence)).into()
            }
        }
        unsafe extern "system" fn SetParameters<Identity: IBDA_Encoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, audiobitratemode: u32, audiobitrate: u32, audiomethodid: u32, audioprogram: u32, videobitratemode: u32, videobitrate: u32, videomethodid: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Encoder_Impl::SetParameters(this, core::mem::transmute_copy(&audiobitratemode), core::mem::transmute_copy(&audiobitrate), core::mem::transmute_copy(&audiomethodid), core::mem::transmute_copy(&audioprogram), core::mem::transmute_copy(&videobitratemode), core::mem::transmute_copy(&videobitrate), core::mem::transmute_copy(&videomethodid)).into()
            }
        }
        unsafe extern "system" fn GetState<Identity: IBDA_Encoder_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, audiobitratemax: *mut u32, audiobitratemin: *mut u32, audiobitratemode: *mut u32, audiobitratestepping: *mut u32, audiobitrate: *mut u32, audiomethodid: *mut u32, availableaudioprograms: *mut u32, audioprogram: *mut u32, videobitratemax: *mut u32, videobitratemin: *mut u32, videobitratemode: *mut u32, videobitrate: *mut u32, videobitratestepping: *mut u32, videomethodid: *mut u32, signalsourceid: *mut u32, signalformat: *mut u64, signallock: *mut windows_core::BOOL, signallevel: *mut i32, signaltonoiseratio: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Encoder_Impl::GetState(
                    this,
                    core::mem::transmute_copy(&audiobitratemax),
                    core::mem::transmute_copy(&audiobitratemin),
                    core::mem::transmute_copy(&audiobitratemode),
                    core::mem::transmute_copy(&audiobitratestepping),
                    core::mem::transmute_copy(&audiobitrate),
                    core::mem::transmute_copy(&audiomethodid),
                    core::mem::transmute_copy(&availableaudioprograms),
                    core::mem::transmute_copy(&audioprogram),
                    core::mem::transmute_copy(&videobitratemax),
                    core::mem::transmute_copy(&videobitratemin),
                    core::mem::transmute_copy(&videobitratemode),
                    core::mem::transmute_copy(&videobitrate),
                    core::mem::transmute_copy(&videobitratestepping),
                    core::mem::transmute_copy(&videomethodid),
                    core::mem::transmute_copy(&signalsourceid),
                    core::mem::transmute_copy(&signalformat),
                    core::mem::transmute_copy(&signallock),
                    core::mem::transmute_copy(&signallevel),
                    core::mem::transmute_copy(&signaltonoiseratio),
                )
                .into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            QueryCapabilities: QueryCapabilities::<Identity, OFFSET>,
            EnumAudioCapability: EnumAudioCapability::<Identity, OFFSET>,
            EnumVideoCapability: EnumVideoCapability::<Identity, OFFSET>,
            SetParameters: SetParameters::<Identity, OFFSET>,
            GetState: GetState::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_Encoder as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_Encoder {}
windows_core::imp::define_interface!(IBDA_EthernetFilter, IBDA_EthernetFilter_Vtbl, 0x71985f43_1ca1_11d3_9cc8_00c04f7971e0);
windows_core::imp::interface_hierarchy!(IBDA_EthernetFilter, windows_core::IUnknown);
impl IBDA_EthernetFilter {
    pub unsafe fn GetMulticastListSize(&self, pulcbaddresses: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetMulticastListSize)(windows_core::Interface::as_raw(self), pulcbaddresses as _).ok() }
    }
    pub unsafe fn PutMulticastList(&self, paddresslist: &[u8]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PutMulticastList)(windows_core::Interface::as_raw(self), paddresslist.len().try_into().unwrap(), core::mem::transmute(paddresslist.as_ptr())).ok() }
    }
    pub unsafe fn GetMulticastList(&self, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetMulticastList)(windows_core::Interface::as_raw(self), pulcbaddresses as _, paddresslist as _).ok() }
    }
    pub unsafe fn PutMulticastMode(&self, ulmodemask: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PutMulticastMode)(windows_core::Interface::as_raw(self), ulmodemask).ok() }
    }
    pub unsafe fn GetMulticastMode(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetMulticastMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IBDA_EthernetFilter_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetMulticastListSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub PutMulticastList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u8) -> windows_core::HRESULT,
    pub GetMulticastList: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u8) -> windows_core::HRESULT,
    pub PutMulticastMode: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetMulticastMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IBDA_EthernetFilter_Impl: windows_core::IUnknownImpl {
    fn GetMulticastListSize(&self, pulcbaddresses: *mut u32) -> windows_core::Result<()>;
    fn PutMulticastList(&self, ulcbaddresses: u32, paddresslist: *const u8) -> windows_core::Result<()>;
    fn GetMulticastList(&self, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> windows_core::Result<()>;
    fn PutMulticastMode(&self, ulmodemask: u32) -> windows_core::Result<()>;
    fn GetMulticastMode(&self) -> windows_core::Result<u32>;
}
impl IBDA_EthernetFilter_Vtbl {
    pub const fn new<Identity: IBDA_EthernetFilter_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetMulticastListSize<Identity: IBDA_EthernetFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcbaddresses: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_EthernetFilter_Impl::GetMulticastListSize(this, core::mem::transmute_copy(&pulcbaddresses)).into()
            }
        }
        unsafe extern "system" fn PutMulticastList<Identity: IBDA_EthernetFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulcbaddresses: u32, paddresslist: *const u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_EthernetFilter_Impl::PutMulticastList(this, core::mem::transmute_copy(&ulcbaddresses), core::mem::transmute_copy(&paddresslist)).into()
            }
        }
        unsafe extern "system" fn GetMulticastList<Identity: IBDA_EthernetFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_EthernetFilter_Impl::GetMulticastList(this, core::mem::transmute_copy(&pulcbaddresses), core::mem::transmute_copy(&paddresslist)).into()
            }
        }
        unsafe extern "system" fn PutMulticastMode<Identity: IBDA_EthernetFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulmodemask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_EthernetFilter_Impl::PutMulticastMode(this, core::mem::transmute_copy(&ulmodemask)).into()
            }
        }
        unsafe extern "system" fn GetMulticastMode<Identity: IBDA_EthernetFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulmodemask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_EthernetFilter_Impl::GetMulticastMode(this) {
                    Ok(ok__) => {
                        pulmodemask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetMulticastListSize: GetMulticastListSize::<Identity, OFFSET>,
            PutMulticastList: PutMulticastList::<Identity, OFFSET>,
            GetMulticastList: GetMulticastList::<Identity, OFFSET>,
            PutMulticastMode: PutMulticastMode::<Identity, OFFSET>,
            GetMulticastMode: GetMulticastMode::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_EthernetFilter as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_EthernetFilter {}
windows_core::imp::define_interface!(IBDA_EventingService, IBDA_EventingService_Vtbl, 0x207c413f_00dc_4c61_bad6_6fee1ff07064);
windows_core::imp::interface_hierarchy!(IBDA_EventingService, windows_core::IUnknown);
impl IBDA_EventingService {
    pub unsafe fn CompleteEvent(&self, uleventid: u32, uleventresult: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CompleteEvent)(windows_core::Interface::as_raw(self), uleventid, uleventresult).ok() }
    }
}
#[repr(C)]
pub struct IBDA_EventingService_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub CompleteEvent: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
}
pub trait IBDA_EventingService_Impl: windows_core::IUnknownImpl {
    fn CompleteEvent(&self, uleventid: u32, uleventresult: u32) -> windows_core::Result<()>;
}
impl IBDA_EventingService_Vtbl {
    pub const fn new<Identity: IBDA_EventingService_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn CompleteEvent<Identity: IBDA_EventingService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, uleventid: u32, uleventresult: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_EventingService_Impl::CompleteEvent(this, core::mem::transmute_copy(&uleventid), core::mem::transmute_copy(&uleventresult)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), CompleteEvent: CompleteEvent::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_EventingService as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_EventingService {}
windows_core::imp::define_interface!(IBDA_FDC, IBDA_FDC_Vtbl, 0x138adc7e_58ae_437f_b0b4_c9fe19d5b4ac);
windows_core::imp::interface_hierarchy!(IBDA_FDC, windows_core::IUnknown);
impl IBDA_FDC {
    pub unsafe fn GetStatus(&self, currentbitrate: *mut u32, carrierlock: *mut windows_core::BOOL, currentfrequency: *mut u32, currentspectruminversion: *mut windows_core::BOOL, currentpidlist: *mut windows_core::BSTR, currenttidlist: *mut windows_core::BSTR, overflow: *mut windows_core::BOOL) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetStatus)(windows_core::Interface::as_raw(self), currentbitrate as _, carrierlock as _, currentfrequency as _, currentspectruminversion as _, core::mem::transmute(currentpidlist), core::mem::transmute(currenttidlist), overflow as _).ok() }
    }
    pub unsafe fn RequestTables(&self, tableids: &windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RequestTables)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(tableids)).ok() }
    }
    pub unsafe fn AddPid(&self, pidstoadd: &windows_core::BSTR) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AddPid)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(pidstoadd), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn RemovePid(&self, pidstoremove: &windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemovePid)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(pidstoremove)).ok() }
    }
    pub unsafe fn AddTid(&self, tidstoadd: &windows_core::BSTR) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AddTid)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(tidstoadd), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn RemoveTid(&self, tidstoremove: &windows_core::BSTR) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RemoveTid)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(tidstoremove)).ok() }
    }
    pub unsafe fn GetTableSection(&self, pid: *mut u32, maxbuffersize: u32, actualsize: *mut u32, secbuffer: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTableSection)(windows_core::Interface::as_raw(self), pid as _, maxbuffersize, actualsize as _, secbuffer as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_FDC_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut windows_core::BOOL, *mut u32, *mut windows_core::BOOL, *mut *mut core::ffi::c_void, *mut *mut core::ffi::c_void, *mut windows_core::BOOL) -> windows_core::HRESULT,
    pub RequestTables: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddPid: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub RemovePid: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AddTid: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub RemoveTid: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTableSection: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, u32, *mut u32, *mut u8) -> windows_core::HRESULT,
}
pub trait IBDA_FDC_Impl: windows_core::IUnknownImpl {
    fn GetStatus(&self, currentbitrate: *mut u32, carrierlock: *mut windows_core::BOOL, currentfrequency: *mut u32, currentspectruminversion: *mut windows_core::BOOL, currentpidlist: *mut windows_core::BSTR, currenttidlist: *mut windows_core::BSTR, overflow: *mut windows_core::BOOL) -> windows_core::Result<()>;
    fn RequestTables(&self, tableids: &windows_core::BSTR) -> windows_core::Result<()>;
    fn AddPid(&self, pidstoadd: &windows_core::BSTR) -> windows_core::Result<u32>;
    fn RemovePid(&self, pidstoremove: &windows_core::BSTR) -> windows_core::Result<()>;
    fn AddTid(&self, tidstoadd: &windows_core::BSTR) -> windows_core::Result<windows_core::BSTR>;
    fn RemoveTid(&self, tidstoremove: &windows_core::BSTR) -> windows_core::Result<()>;
    fn GetTableSection(&self, pid: *mut u32, maxbuffersize: u32, actualsize: *mut u32, secbuffer: *mut u8) -> windows_core::Result<()>;
}
impl IBDA_FDC_Vtbl {
    pub const fn new<Identity: IBDA_FDC_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetStatus<Identity: IBDA_FDC_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, currentbitrate: *mut u32, carrierlock: *mut windows_core::BOOL, currentfrequency: *mut u32, currentspectruminversion: *mut windows_core::BOOL, currentpidlist: *mut *mut core::ffi::c_void, currenttidlist: *mut *mut core::ffi::c_void, overflow: *mut windows_core::BOOL) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FDC_Impl::GetStatus(this, core::mem::transmute_copy(&currentbitrate), core::mem::transmute_copy(&carrierlock), core::mem::transmute_copy(&currentfrequency), core::mem::transmute_copy(&currentspectruminversion), core::mem::transmute_copy(&currentpidlist), core::mem::transmute_copy(&currenttidlist), core::mem::transmute_copy(&overflow)).into()
            }
        }
        unsafe extern "system" fn RequestTables<Identity: IBDA_FDC_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, tableids: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FDC_Impl::RequestTables(this, core::mem::transmute(&tableids)).into()
            }
        }
        unsafe extern "system" fn AddPid<Identity: IBDA_FDC_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pidstoadd: *mut core::ffi::c_void, remainingfilterentries: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_FDC_Impl::AddPid(this, core::mem::transmute(&pidstoadd)) {
                    Ok(ok__) => {
                        remainingfilterentries.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn RemovePid<Identity: IBDA_FDC_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pidstoremove: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FDC_Impl::RemovePid(this, core::mem::transmute(&pidstoremove)).into()
            }
        }
        unsafe extern "system" fn AddTid<Identity: IBDA_FDC_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, tidstoadd: *mut core::ffi::c_void, currenttidlist: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_FDC_Impl::AddTid(this, core::mem::transmute(&tidstoadd)) {
                    Ok(ok__) => {
                        currenttidlist.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn RemoveTid<Identity: IBDA_FDC_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, tidstoremove: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FDC_Impl::RemoveTid(this, core::mem::transmute(&tidstoremove)).into()
            }
        }
        unsafe extern "system" fn GetTableSection<Identity: IBDA_FDC_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pid: *mut u32, maxbuffersize: u32, actualsize: *mut u32, secbuffer: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FDC_Impl::GetTableSection(this, core::mem::transmute_copy(&pid), core::mem::transmute_copy(&maxbuffersize), core::mem::transmute_copy(&actualsize), core::mem::transmute_copy(&secbuffer)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetStatus: GetStatus::<Identity, OFFSET>,
            RequestTables: RequestTables::<Identity, OFFSET>,
            AddPid: AddPid::<Identity, OFFSET>,
            RemovePid: RemovePid::<Identity, OFFSET>,
            AddTid: AddTid::<Identity, OFFSET>,
            RemoveTid: RemoveTid::<Identity, OFFSET>,
            GetTableSection: GetTableSection::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_FDC as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_FDC {}
windows_core::imp::define_interface!(IBDA_FrequencyFilter, IBDA_FrequencyFilter_Vtbl, 0x71985f47_1ca1_11d3_9cc8_00c04f7971e0);
windows_core::imp::interface_hierarchy!(IBDA_FrequencyFilter, windows_core::IUnknown);
impl IBDA_FrequencyFilter {
    pub unsafe fn SetAutotune(&self, ultransponder: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetAutotune)(windows_core::Interface::as_raw(self), ultransponder).ok() }
    }
    pub unsafe fn Autotune(&self, pultransponder: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Autotune)(windows_core::Interface::as_raw(self), pultransponder as _).ok() }
    }
    pub unsafe fn SetFrequency(&self, ulfrequency: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFrequency)(windows_core::Interface::as_raw(self), ulfrequency).ok() }
    }
    pub unsafe fn Frequency(&self, pulfrequency: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Frequency)(windows_core::Interface::as_raw(self), pulfrequency as _).ok() }
    }
    pub unsafe fn SetPolarity(&self, polarity: Polarisation) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPolarity)(windows_core::Interface::as_raw(self), polarity).ok() }
    }
    pub unsafe fn Polarity(&self, ppolarity: *mut Polarisation) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Polarity)(windows_core::Interface::as_raw(self), ppolarity as _).ok() }
    }
    pub unsafe fn SetRange(&self, ulrange: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetRange)(windows_core::Interface::as_raw(self), ulrange).ok() }
    }
    pub unsafe fn Range(&self, pulrange: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Range)(windows_core::Interface::as_raw(self), pulrange as _).ok() }
    }
    pub unsafe fn SetBandwidth(&self, ulbandwidth: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetBandwidth)(windows_core::Interface::as_raw(self), ulbandwidth).ok() }
    }
    pub unsafe fn Bandwidth(&self, pulbandwidth: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Bandwidth)(windows_core::Interface::as_raw(self), pulbandwidth as _).ok() }
    }
    pub unsafe fn SetFrequencyMultiplier(&self, ulmultiplier: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetFrequencyMultiplier)(windows_core::Interface::as_raw(self), ulmultiplier).ok() }
    }
    pub unsafe fn FrequencyMultiplier(&self, pulmultiplier: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).FrequencyMultiplier)(windows_core::Interface::as_raw(self), pulmultiplier as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_FrequencyFilter_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetAutotune: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Autotune: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Frequency: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetPolarity: unsafe extern "system" fn(*mut core::ffi::c_void, Polarisation) -> windows_core::HRESULT,
    pub Polarity: unsafe extern "system" fn(*mut core::ffi::c_void, *mut Polarisation) -> windows_core::HRESULT,
    pub SetRange: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Range: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetBandwidth: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub Bandwidth: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetFrequencyMultiplier: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub FrequencyMultiplier: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IBDA_FrequencyFilter_Impl: windows_core::IUnknownImpl {
    fn SetAutotune(&self, ultransponder: u32) -> windows_core::Result<()>;
    fn Autotune(&self, pultransponder: *mut u32) -> windows_core::Result<()>;
    fn SetFrequency(&self, ulfrequency: u32) -> windows_core::Result<()>;
    fn Frequency(&self, pulfrequency: *mut u32) -> windows_core::Result<()>;
    fn SetPolarity(&self, polarity: Polarisation) -> windows_core::Result<()>;
    fn Polarity(&self, ppolarity: *mut Polarisation) -> windows_core::Result<()>;
    fn SetRange(&self, ulrange: u32) -> windows_core::Result<()>;
    fn Range(&self, pulrange: *mut u32) -> windows_core::Result<()>;
    fn SetBandwidth(&self, ulbandwidth: u32) -> windows_core::Result<()>;
    fn Bandwidth(&self, pulbandwidth: *mut u32) -> windows_core::Result<()>;
    fn SetFrequencyMultiplier(&self, ulmultiplier: u32) -> windows_core::Result<()>;
    fn FrequencyMultiplier(&self, pulmultiplier: *mut u32) -> windows_core::Result<()>;
}
impl IBDA_FrequencyFilter_Vtbl {
    pub const fn new<Identity: IBDA_FrequencyFilter_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetAutotune<Identity: IBDA_FrequencyFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ultransponder: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FrequencyFilter_Impl::SetAutotune(this, core::mem::transmute_copy(&ultransponder)).into()
            }
        }
        unsafe extern "system" fn Autotune<Identity: IBDA_FrequencyFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pultransponder: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FrequencyFilter_Impl::Autotune(this, core::mem::transmute_copy(&pultransponder)).into()
            }
        }
        unsafe extern "system" fn SetFrequency<Identity: IBDA_FrequencyFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulfrequency: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FrequencyFilter_Impl::SetFrequency(this, core::mem::transmute_copy(&ulfrequency)).into()
            }
        }
        unsafe extern "system" fn Frequency<Identity: IBDA_FrequencyFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulfrequency: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FrequencyFilter_Impl::Frequency(this, core::mem::transmute_copy(&pulfrequency)).into()
            }
        }
        unsafe extern "system" fn SetPolarity<Identity: IBDA_FrequencyFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, polarity: Polarisation) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FrequencyFilter_Impl::SetPolarity(this, core::mem::transmute_copy(&polarity)).into()
            }
        }
        unsafe extern "system" fn Polarity<Identity: IBDA_FrequencyFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppolarity: *mut Polarisation) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FrequencyFilter_Impl::Polarity(this, core::mem::transmute_copy(&ppolarity)).into()
            }
        }
        unsafe extern "system" fn SetRange<Identity: IBDA_FrequencyFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulrange: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FrequencyFilter_Impl::SetRange(this, core::mem::transmute_copy(&ulrange)).into()
            }
        }
        unsafe extern "system" fn Range<Identity: IBDA_FrequencyFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulrange: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FrequencyFilter_Impl::Range(this, core::mem::transmute_copy(&pulrange)).into()
            }
        }
        unsafe extern "system" fn SetBandwidth<Identity: IBDA_FrequencyFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulbandwidth: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FrequencyFilter_Impl::SetBandwidth(this, core::mem::transmute_copy(&ulbandwidth)).into()
            }
        }
        unsafe extern "system" fn Bandwidth<Identity: IBDA_FrequencyFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulbandwidth: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FrequencyFilter_Impl::Bandwidth(this, core::mem::transmute_copy(&pulbandwidth)).into()
            }
        }
        unsafe extern "system" fn SetFrequencyMultiplier<Identity: IBDA_FrequencyFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulmultiplier: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FrequencyFilter_Impl::SetFrequencyMultiplier(this, core::mem::transmute_copy(&ulmultiplier)).into()
            }
        }
        unsafe extern "system" fn FrequencyMultiplier<Identity: IBDA_FrequencyFilter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulmultiplier: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_FrequencyFilter_Impl::FrequencyMultiplier(this, core::mem::transmute_copy(&pulmultiplier)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetAutotune: SetAutotune::<Identity, OFFSET>,
            Autotune: Autotune::<Identity, OFFSET>,
            SetFrequency: SetFrequency::<Identity, OFFSET>,
            Frequency: Frequency::<Identity, OFFSET>,
            SetPolarity: SetPolarity::<Identity, OFFSET>,
            Polarity: Polarity::<Identity, OFFSET>,
            SetRange: SetRange::<Identity, OFFSET>,
            Range: Range::<Identity, OFFSET>,
            SetBandwidth: SetBandwidth::<Identity, OFFSET>,
            Bandwidth: Bandwidth::<Identity, OFFSET>,
            SetFrequencyMultiplier: SetFrequencyMultiplier::<Identity, OFFSET>,
            FrequencyMultiplier: FrequencyMultiplier::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_FrequencyFilter as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_FrequencyFilter {}
windows_core::imp::define_interface!(IBDA_GuideDataDeliveryService, IBDA_GuideDataDeliveryService_Vtbl, 0xc0afcb73_23e7_4bc6_bafa_fdc167b4719f);
windows_core::imp::interface_hierarchy!(IBDA_GuideDataDeliveryService, windows_core::IUnknown);
impl IBDA_GuideDataDeliveryService {
    pub unsafe fn GetGuideDataType(&self) -> windows_core::Result<windows_core::GUID> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetGuideDataType)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn GetGuideData(&self, pulcbbufferlen: *mut u32, pbbuffer: *mut u8, pulguidedatapercentageprogress: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetGuideData)(windows_core::Interface::as_raw(self), pulcbbufferlen as _, pbbuffer as _, pulguidedatapercentageprogress as _).ok() }
    }
    pub unsafe fn RequestGuideDataUpdate(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RequestGuideDataUpdate)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn GetTuneXmlFromServiceIdx(&self, ul64serviceidx: u64) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetTuneXmlFromServiceIdx)(windows_core::Interface::as_raw(self), ul64serviceidx, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetServices(&self, pulcbbufferlen: *mut u32, pbbuffer: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetServices)(windows_core::Interface::as_raw(self), pulcbbufferlen as _, pbbuffer as _).ok() }
    }
    pub unsafe fn GetServiceInfoFromTuneXml(&self, bstrtunexml: &windows_core::BSTR) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetServiceInfoFromTuneXml)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(bstrtunexml), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[repr(C)]
pub struct IBDA_GuideDataDeliveryService_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetGuideDataType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub GetGuideData: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u8, *mut u32) -> windows_core::HRESULT,
    pub RequestGuideDataUpdate: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetTuneXmlFromServiceIdx: unsafe extern "system" fn(*mut core::ffi::c_void, u64, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetServices: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u8) -> windows_core::HRESULT,
    pub GetServiceInfoFromTuneXml: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IBDA_GuideDataDeliveryService_Impl: windows_core::IUnknownImpl {
    fn GetGuideDataType(&self) -> windows_core::Result<windows_core::GUID>;
    fn GetGuideData(&self, pulcbbufferlen: *mut u32, pbbuffer: *mut u8, pulguidedatapercentageprogress: *mut u32) -> windows_core::Result<()>;
    fn RequestGuideDataUpdate(&self) -> windows_core::Result<()>;
    fn GetTuneXmlFromServiceIdx(&self, ul64serviceidx: u64) -> windows_core::Result<windows_core::BSTR>;
    fn GetServices(&self, pulcbbufferlen: *mut u32, pbbuffer: *mut u8) -> windows_core::Result<()>;
    fn GetServiceInfoFromTuneXml(&self, bstrtunexml: &windows_core::BSTR) -> windows_core::Result<windows_core::BSTR>;
}
impl IBDA_GuideDataDeliveryService_Vtbl {
    pub const fn new<Identity: IBDA_GuideDataDeliveryService_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetGuideDataType<Identity: IBDA_GuideDataDeliveryService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguiddatatype: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_GuideDataDeliveryService_Impl::GetGuideDataType(this) {
                    Ok(ok__) => {
                        pguiddatatype.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetGuideData<Identity: IBDA_GuideDataDeliveryService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcbbufferlen: *mut u32, pbbuffer: *mut u8, pulguidedatapercentageprogress: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_GuideDataDeliveryService_Impl::GetGuideData(this, core::mem::transmute_copy(&pulcbbufferlen), core::mem::transmute_copy(&pbbuffer), core::mem::transmute_copy(&pulguidedatapercentageprogress)).into()
            }
        }
        unsafe extern "system" fn RequestGuideDataUpdate<Identity: IBDA_GuideDataDeliveryService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_GuideDataDeliveryService_Impl::RequestGuideDataUpdate(this).into()
            }
        }
        unsafe extern "system" fn GetTuneXmlFromServiceIdx<Identity: IBDA_GuideDataDeliveryService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ul64serviceidx: u64, pbstrtunexml: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_GuideDataDeliveryService_Impl::GetTuneXmlFromServiceIdx(this, core::mem::transmute_copy(&ul64serviceidx)) {
                    Ok(ok__) => {
                        pbstrtunexml.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetServices<Identity: IBDA_GuideDataDeliveryService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcbbufferlen: *mut u32, pbbuffer: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_GuideDataDeliveryService_Impl::GetServices(this, core::mem::transmute_copy(&pulcbbufferlen), core::mem::transmute_copy(&pbbuffer)).into()
            }
        }
        unsafe extern "system" fn GetServiceInfoFromTuneXml<Identity: IBDA_GuideDataDeliveryService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bstrtunexml: *mut core::ffi::c_void, pbstrservicedescription: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_GuideDataDeliveryService_Impl::GetServiceInfoFromTuneXml(this, core::mem::transmute(&bstrtunexml)) {
                    Ok(ok__) => {
                        pbstrservicedescription.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetGuideDataType: GetGuideDataType::<Identity, OFFSET>,
            GetGuideData: GetGuideData::<Identity, OFFSET>,
            RequestGuideDataUpdate: RequestGuideDataUpdate::<Identity, OFFSET>,
            GetTuneXmlFromServiceIdx: GetTuneXmlFromServiceIdx::<Identity, OFFSET>,
            GetServices: GetServices::<Identity, OFFSET>,
            GetServiceInfoFromTuneXml: GetServiceInfoFromTuneXml::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_GuideDataDeliveryService as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_GuideDataDeliveryService {}
windows_core::imp::define_interface!(IBDA_IPSinkControl, IBDA_IPSinkControl_Vtbl, 0x3f4dc8e2_4050_11d3_8f4b_00c04f7971e2);
windows_core::imp::interface_hierarchy!(IBDA_IPSinkControl, windows_core::IUnknown);
impl IBDA_IPSinkControl {
    pub unsafe fn GetMulticastList(&self, pulcbsize: *mut u32, pbbuffer: *mut *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetMulticastList)(windows_core::Interface::as_raw(self), pulcbsize as _, pbbuffer as _).ok() }
    }
    pub unsafe fn GetAdapterIPAddress(&self, pulcbsize: *mut u32, pbbuffer: *mut *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetAdapterIPAddress)(windows_core::Interface::as_raw(self), pulcbsize as _, pbbuffer as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_IPSinkControl_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetMulticastList: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut *mut u8) -> windows_core::HRESULT,
    pub GetAdapterIPAddress: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut *mut u8) -> windows_core::HRESULT,
}
pub trait IBDA_IPSinkControl_Impl: windows_core::IUnknownImpl {
    fn GetMulticastList(&self, pulcbsize: *mut u32, pbbuffer: *mut *mut u8) -> windows_core::Result<()>;
    fn GetAdapterIPAddress(&self, pulcbsize: *mut u32, pbbuffer: *mut *mut u8) -> windows_core::Result<()>;
}
impl IBDA_IPSinkControl_Vtbl {
    pub const fn new<Identity: IBDA_IPSinkControl_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetMulticastList<Identity: IBDA_IPSinkControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcbsize: *mut u32, pbbuffer: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_IPSinkControl_Impl::GetMulticastList(this, core::mem::transmute_copy(&pulcbsize), core::mem::transmute_copy(&pbbuffer)).into()
            }
        }
        unsafe extern "system" fn GetAdapterIPAddress<Identity: IBDA_IPSinkControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcbsize: *mut u32, pbbuffer: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_IPSinkControl_Impl::GetAdapterIPAddress(this, core::mem::transmute_copy(&pulcbsize), core::mem::transmute_copy(&pbbuffer)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetMulticastList: GetMulticastList::<Identity, OFFSET>,
            GetAdapterIPAddress: GetAdapterIPAddress::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_IPSinkControl as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_IPSinkControl {}
windows_core::imp::define_interface!(IBDA_IPSinkInfo, IBDA_IPSinkInfo_Vtbl, 0xa750108f_492e_4d51_95f7_649b23ff7ad7);
windows_core::imp::interface_hierarchy!(IBDA_IPSinkInfo, windows_core::IUnknown);
impl IBDA_IPSinkInfo {
    pub unsafe fn get_MulticastList(&self, pulcbaddresses: *mut u32, ppbaddresslist: *mut *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_MulticastList)(windows_core::Interface::as_raw(self), pulcbaddresses as _, ppbaddresslist as _).ok() }
    }
    pub unsafe fn AdapterIPAddress(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AdapterIPAddress)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn AdapterDescription(&self) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).AdapterDescription)(windows_core::Interface::as_raw(self), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
}
#[repr(C)]
pub struct IBDA_IPSinkInfo_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub get_MulticastList: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut *mut u8) -> windows_core::HRESULT,
    pub AdapterIPAddress: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub AdapterDescription: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IBDA_IPSinkInfo_Impl: windows_core::IUnknownImpl {
    fn get_MulticastList(&self, pulcbaddresses: *mut u32, ppbaddresslist: *mut *mut u8) -> windows_core::Result<()>;
    fn AdapterIPAddress(&self) -> windows_core::Result<windows_core::BSTR>;
    fn AdapterDescription(&self) -> windows_core::Result<windows_core::BSTR>;
}
impl IBDA_IPSinkInfo_Vtbl {
    pub const fn new<Identity: IBDA_IPSinkInfo_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn get_MulticastList<Identity: IBDA_IPSinkInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcbaddresses: *mut u32, ppbaddresslist: *mut *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_IPSinkInfo_Impl::get_MulticastList(this, core::mem::transmute_copy(&pulcbaddresses), core::mem::transmute_copy(&ppbaddresslist)).into()
            }
        }
        unsafe extern "system" fn AdapterIPAddress<Identity: IBDA_IPSinkInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrbuffer: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_IPSinkInfo_Impl::AdapterIPAddress(this) {
                    Ok(ok__) => {
                        pbstrbuffer.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn AdapterDescription<Identity: IBDA_IPSinkInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pbstrbuffer: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_IPSinkInfo_Impl::AdapterDescription(this) {
                    Ok(ok__) => {
                        pbstrbuffer.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            get_MulticastList: get_MulticastList::<Identity, OFFSET>,
            AdapterIPAddress: AdapterIPAddress::<Identity, OFFSET>,
            AdapterDescription: AdapterDescription::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_IPSinkInfo as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_IPSinkInfo {}
windows_core::imp::define_interface!(IBDA_IPV4Filter, IBDA_IPV4Filter_Vtbl, 0x71985f44_1ca1_11d3_9cc8_00c04f7971e0);
windows_core::imp::interface_hierarchy!(IBDA_IPV4Filter, windows_core::IUnknown);
impl IBDA_IPV4Filter {
    pub unsafe fn GetMulticastListSize(&self, pulcbaddresses: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetMulticastListSize)(windows_core::Interface::as_raw(self), pulcbaddresses as _).ok() }
    }
    pub unsafe fn PutMulticastList(&self, paddresslist: &[u8]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PutMulticastList)(windows_core::Interface::as_raw(self), paddresslist.len().try_into().unwrap(), core::mem::transmute(paddresslist.as_ptr())).ok() }
    }
    pub unsafe fn GetMulticastList(&self, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetMulticastList)(windows_core::Interface::as_raw(self), pulcbaddresses as _, paddresslist as _).ok() }
    }
    pub unsafe fn PutMulticastMode(&self, ulmodemask: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PutMulticastMode)(windows_core::Interface::as_raw(self), ulmodemask).ok() }
    }
    pub unsafe fn GetMulticastMode(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetMulticastMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IBDA_IPV4Filter_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetMulticastListSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub PutMulticastList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u8) -> windows_core::HRESULT,
    pub GetMulticastList: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u8) -> windows_core::HRESULT,
    pub PutMulticastMode: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetMulticastMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IBDA_IPV4Filter_Impl: windows_core::IUnknownImpl {
    fn GetMulticastListSize(&self, pulcbaddresses: *mut u32) -> windows_core::Result<()>;
    fn PutMulticastList(&self, ulcbaddresses: u32, paddresslist: *const u8) -> windows_core::Result<()>;
    fn GetMulticastList(&self, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> windows_core::Result<()>;
    fn PutMulticastMode(&self, ulmodemask: u32) -> windows_core::Result<()>;
    fn GetMulticastMode(&self) -> windows_core::Result<u32>;
}
impl IBDA_IPV4Filter_Vtbl {
    pub const fn new<Identity: IBDA_IPV4Filter_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetMulticastListSize<Identity: IBDA_IPV4Filter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcbaddresses: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_IPV4Filter_Impl::GetMulticastListSize(this, core::mem::transmute_copy(&pulcbaddresses)).into()
            }
        }
        unsafe extern "system" fn PutMulticastList<Identity: IBDA_IPV4Filter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulcbaddresses: u32, paddresslist: *const u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_IPV4Filter_Impl::PutMulticastList(this, core::mem::transmute_copy(&ulcbaddresses), core::mem::transmute_copy(&paddresslist)).into()
            }
        }
        unsafe extern "system" fn GetMulticastList<Identity: IBDA_IPV4Filter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_IPV4Filter_Impl::GetMulticastList(this, core::mem::transmute_copy(&pulcbaddresses), core::mem::transmute_copy(&paddresslist)).into()
            }
        }
        unsafe extern "system" fn PutMulticastMode<Identity: IBDA_IPV4Filter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulmodemask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_IPV4Filter_Impl::PutMulticastMode(this, core::mem::transmute_copy(&ulmodemask)).into()
            }
        }
        unsafe extern "system" fn GetMulticastMode<Identity: IBDA_IPV4Filter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulmodemask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_IPV4Filter_Impl::GetMulticastMode(this) {
                    Ok(ok__) => {
                        pulmodemask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetMulticastListSize: GetMulticastListSize::<Identity, OFFSET>,
            PutMulticastList: PutMulticastList::<Identity, OFFSET>,
            GetMulticastList: GetMulticastList::<Identity, OFFSET>,
            PutMulticastMode: PutMulticastMode::<Identity, OFFSET>,
            GetMulticastMode: GetMulticastMode::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_IPV4Filter as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_IPV4Filter {}
windows_core::imp::define_interface!(IBDA_IPV6Filter, IBDA_IPV6Filter_Vtbl, 0xe1785a74_2a23_4fb3_9245_a8f88017ef33);
windows_core::imp::interface_hierarchy!(IBDA_IPV6Filter, windows_core::IUnknown);
impl IBDA_IPV6Filter {
    pub unsafe fn GetMulticastListSize(&self, pulcbaddresses: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetMulticastListSize)(windows_core::Interface::as_raw(self), pulcbaddresses as _).ok() }
    }
    pub unsafe fn PutMulticastList(&self, paddresslist: &[u8]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PutMulticastList)(windows_core::Interface::as_raw(self), paddresslist.len().try_into().unwrap(), core::mem::transmute(paddresslist.as_ptr())).ok() }
    }
    pub unsafe fn GetMulticastList(&self, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetMulticastList)(windows_core::Interface::as_raw(self), pulcbaddresses as _, paddresslist as _).ok() }
    }
    pub unsafe fn PutMulticastMode(&self, ulmodemask: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PutMulticastMode)(windows_core::Interface::as_raw(self), ulmodemask).ok() }
    }
    pub unsafe fn GetMulticastMode(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetMulticastMode)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IBDA_IPV6Filter_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetMulticastListSize: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub PutMulticastList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u8) -> windows_core::HRESULT,
    pub GetMulticastList: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u8) -> windows_core::HRESULT,
    pub PutMulticastMode: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetMulticastMode: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IBDA_IPV6Filter_Impl: windows_core::IUnknownImpl {
    fn GetMulticastListSize(&self, pulcbaddresses: *mut u32) -> windows_core::Result<()>;
    fn PutMulticastList(&self, ulcbaddresses: u32, paddresslist: *const u8) -> windows_core::Result<()>;
    fn GetMulticastList(&self, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> windows_core::Result<()>;
    fn PutMulticastMode(&self, ulmodemask: u32) -> windows_core::Result<()>;
    fn GetMulticastMode(&self) -> windows_core::Result<u32>;
}
impl IBDA_IPV6Filter_Vtbl {
    pub const fn new<Identity: IBDA_IPV6Filter_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetMulticastListSize<Identity: IBDA_IPV6Filter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcbaddresses: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_IPV6Filter_Impl::GetMulticastListSize(this, core::mem::transmute_copy(&pulcbaddresses)).into()
            }
        }
        unsafe extern "system" fn PutMulticastList<Identity: IBDA_IPV6Filter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulcbaddresses: u32, paddresslist: *const u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_IPV6Filter_Impl::PutMulticastList(this, core::mem::transmute_copy(&ulcbaddresses), core::mem::transmute_copy(&paddresslist)).into()
            }
        }
        unsafe extern "system" fn GetMulticastList<Identity: IBDA_IPV6Filter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_IPV6Filter_Impl::GetMulticastList(this, core::mem::transmute_copy(&pulcbaddresses), core::mem::transmute_copy(&paddresslist)).into()
            }
        }
        unsafe extern "system" fn PutMulticastMode<Identity: IBDA_IPV6Filter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulmodemask: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_IPV6Filter_Impl::PutMulticastMode(this, core::mem::transmute_copy(&ulmodemask)).into()
            }
        }
        unsafe extern "system" fn GetMulticastMode<Identity: IBDA_IPV6Filter_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulmodemask: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_IPV6Filter_Impl::GetMulticastMode(this) {
                    Ok(ok__) => {
                        pulmodemask.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetMulticastListSize: GetMulticastListSize::<Identity, OFFSET>,
            PutMulticastList: PutMulticastList::<Identity, OFFSET>,
            GetMulticastList: GetMulticastList::<Identity, OFFSET>,
            PutMulticastMode: PutMulticastMode::<Identity, OFFSET>,
            GetMulticastMode: GetMulticastMode::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_IPV6Filter as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_IPV6Filter {}
windows_core::imp::define_interface!(IBDA_ISDBConditionalAccess, IBDA_ISDBConditionalAccess_Vtbl, 0x5e68c627_16c2_4e6c_b1e2_d00170cdaa0f);
windows_core::imp::interface_hierarchy!(IBDA_ISDBConditionalAccess, windows_core::IUnknown);
impl IBDA_ISDBConditionalAccess {
    pub unsafe fn SetIsdbCasRequest(&self, ulrequestid: u32, pbrequestbuffer: &[u8]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetIsdbCasRequest)(windows_core::Interface::as_raw(self), ulrequestid, pbrequestbuffer.len().try_into().unwrap(), core::mem::transmute(pbrequestbuffer.as_ptr())).ok() }
    }
}
#[repr(C)]
pub struct IBDA_ISDBConditionalAccess_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetIsdbCasRequest: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, *const u8) -> windows_core::HRESULT,
}
pub trait IBDA_ISDBConditionalAccess_Impl: windows_core::IUnknownImpl {
    fn SetIsdbCasRequest(&self, ulrequestid: u32, ulcbrequestbufferlen: u32, pbrequestbuffer: *const u8) -> windows_core::Result<()>;
}
impl IBDA_ISDBConditionalAccess_Vtbl {
    pub const fn new<Identity: IBDA_ISDBConditionalAccess_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetIsdbCasRequest<Identity: IBDA_ISDBConditionalAccess_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulrequestid: u32, ulcbrequestbufferlen: u32, pbrequestbuffer: *const u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_ISDBConditionalAccess_Impl::SetIsdbCasRequest(this, core::mem::transmute_copy(&ulrequestid), core::mem::transmute_copy(&ulcbrequestbufferlen), core::mem::transmute_copy(&pbrequestbuffer)).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), SetIsdbCasRequest: SetIsdbCasRequest::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_ISDBConditionalAccess as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_ISDBConditionalAccess {}
windows_core::imp::define_interface!(IBDA_LNBInfo, IBDA_LNBInfo_Vtbl, 0x992cf102_49f9_4719_a664_c4f23e2408f4);
windows_core::imp::interface_hierarchy!(IBDA_LNBInfo, windows_core::IUnknown);
impl IBDA_LNBInfo {
    pub unsafe fn SetLocalOscilatorFrequencyLowBand(&self, ulloflow: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetLocalOscilatorFrequencyLowBand)(windows_core::Interface::as_raw(self), ulloflow).ok() }
    }
    pub unsafe fn LocalOscilatorFrequencyLowBand(&self, pulloflow: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).LocalOscilatorFrequencyLowBand)(windows_core::Interface::as_raw(self), pulloflow as _).ok() }
    }
    pub unsafe fn SetLocalOscilatorFrequencyHighBand(&self, ullofhigh: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetLocalOscilatorFrequencyHighBand)(windows_core::Interface::as_raw(self), ullofhigh).ok() }
    }
    pub unsafe fn LocalOscilatorFrequencyHighBand(&self, pullofhigh: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).LocalOscilatorFrequencyHighBand)(windows_core::Interface::as_raw(self), pullofhigh as _).ok() }
    }
    pub unsafe fn SetHighLowSwitchFrequency(&self, ulswitchfrequency: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetHighLowSwitchFrequency)(windows_core::Interface::as_raw(self), ulswitchfrequency).ok() }
    }
    pub unsafe fn HighLowSwitchFrequency(&self, pulswitchfrequency: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).HighLowSwitchFrequency)(windows_core::Interface::as_raw(self), pulswitchfrequency as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_LNBInfo_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetLocalOscilatorFrequencyLowBand: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub LocalOscilatorFrequencyLowBand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetLocalOscilatorFrequencyHighBand: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub LocalOscilatorFrequencyHighBand: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub SetHighLowSwitchFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub HighLowSwitchFrequency: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IBDA_LNBInfo_Impl: windows_core::IUnknownImpl {
    fn SetLocalOscilatorFrequencyLowBand(&self, ulloflow: u32) -> windows_core::Result<()>;
    fn LocalOscilatorFrequencyLowBand(&self, pulloflow: *mut u32) -> windows_core::Result<()>;
    fn SetLocalOscilatorFrequencyHighBand(&self, ullofhigh: u32) -> windows_core::Result<()>;
    fn LocalOscilatorFrequencyHighBand(&self, pullofhigh: *mut u32) -> windows_core::Result<()>;
    fn SetHighLowSwitchFrequency(&self, ulswitchfrequency: u32) -> windows_core::Result<()>;
    fn HighLowSwitchFrequency(&self, pulswitchfrequency: *mut u32) -> windows_core::Result<()>;
}
impl IBDA_LNBInfo_Vtbl {
    pub const fn new<Identity: IBDA_LNBInfo_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetLocalOscilatorFrequencyLowBand<Identity: IBDA_LNBInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulloflow: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_LNBInfo_Impl::SetLocalOscilatorFrequencyLowBand(this, core::mem::transmute_copy(&ulloflow)).into()
            }
        }
        unsafe extern "system" fn LocalOscilatorFrequencyLowBand<Identity: IBDA_LNBInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulloflow: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_LNBInfo_Impl::LocalOscilatorFrequencyLowBand(this, core::mem::transmute_copy(&pulloflow)).into()
            }
        }
        unsafe extern "system" fn SetLocalOscilatorFrequencyHighBand<Identity: IBDA_LNBInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ullofhigh: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_LNBInfo_Impl::SetLocalOscilatorFrequencyHighBand(this, core::mem::transmute_copy(&ullofhigh)).into()
            }
        }
        unsafe extern "system" fn LocalOscilatorFrequencyHighBand<Identity: IBDA_LNBInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pullofhigh: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_LNBInfo_Impl::LocalOscilatorFrequencyHighBand(this, core::mem::transmute_copy(&pullofhigh)).into()
            }
        }
        unsafe extern "system" fn SetHighLowSwitchFrequency<Identity: IBDA_LNBInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulswitchfrequency: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_LNBInfo_Impl::SetHighLowSwitchFrequency(this, core::mem::transmute_copy(&ulswitchfrequency)).into()
            }
        }
        unsafe extern "system" fn HighLowSwitchFrequency<Identity: IBDA_LNBInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulswitchfrequency: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_LNBInfo_Impl::HighLowSwitchFrequency(this, core::mem::transmute_copy(&pulswitchfrequency)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetLocalOscilatorFrequencyLowBand: SetLocalOscilatorFrequencyLowBand::<Identity, OFFSET>,
            LocalOscilatorFrequencyLowBand: LocalOscilatorFrequencyLowBand::<Identity, OFFSET>,
            SetLocalOscilatorFrequencyHighBand: SetLocalOscilatorFrequencyHighBand::<Identity, OFFSET>,
            LocalOscilatorFrequencyHighBand: LocalOscilatorFrequencyHighBand::<Identity, OFFSET>,
            SetHighLowSwitchFrequency: SetHighLowSwitchFrequency::<Identity, OFFSET>,
            HighLowSwitchFrequency: HighLowSwitchFrequency::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_LNBInfo as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_LNBInfo {}
windows_core::imp::define_interface!(IBDA_MUX, IBDA_MUX_Vtbl, 0x942aafec_4c05_4c74_b8eb_8706c2a4943f);
windows_core::imp::interface_hierarchy!(IBDA_MUX, windows_core::IUnknown);
impl IBDA_MUX {
    pub unsafe fn SetPidList(&self, pbpidlistbuffer: &[BDA_MUX_PIDLISTITEM]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPidList)(windows_core::Interface::as_raw(self), pbpidlistbuffer.len().try_into().unwrap(), core::mem::transmute(pbpidlistbuffer.as_ptr())).ok() }
    }
    pub unsafe fn GetPidList(&self, pulpidlistcount: *mut u32, pbpidlistbuffer: *mut BDA_MUX_PIDLISTITEM) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetPidList)(windows_core::Interface::as_raw(self), pulpidlistcount as _, pbpidlistbuffer as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_MUX_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetPidList: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const BDA_MUX_PIDLISTITEM) -> windows_core::HRESULT,
    pub GetPidList: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut BDA_MUX_PIDLISTITEM) -> windows_core::HRESULT,
}
pub trait IBDA_MUX_Impl: windows_core::IUnknownImpl {
    fn SetPidList(&self, ulpidlistcount: u32, pbpidlistbuffer: *const BDA_MUX_PIDLISTITEM) -> windows_core::Result<()>;
    fn GetPidList(&self, pulpidlistcount: *mut u32, pbpidlistbuffer: *mut BDA_MUX_PIDLISTITEM) -> windows_core::Result<()>;
}
impl IBDA_MUX_Vtbl {
    pub const fn new<Identity: IBDA_MUX_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetPidList<Identity: IBDA_MUX_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulpidlistcount: u32, pbpidlistbuffer: *const BDA_MUX_PIDLISTITEM) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_MUX_Impl::SetPidList(this, core::mem::transmute_copy(&ulpidlistcount), core::mem::transmute_copy(&pbpidlistbuffer)).into()
            }
        }
        unsafe extern "system" fn GetPidList<Identity: IBDA_MUX_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulpidlistcount: *mut u32, pbpidlistbuffer: *mut BDA_MUX_PIDLISTITEM) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_MUX_Impl::GetPidList(this, core::mem::transmute_copy(&pulpidlistcount), core::mem::transmute_copy(&pbpidlistbuffer)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetPidList: SetPidList::<Identity, OFFSET>,
            GetPidList: GetPidList::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_MUX as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_MUX {}
windows_core::imp::define_interface!(IBDA_NameValueService, IBDA_NameValueService_Vtbl, 0x7f0b3150_7b81_4ad4_98e3_7e9097094301);
windows_core::imp::interface_hierarchy!(IBDA_NameValueService, windows_core::IUnknown);
impl IBDA_NameValueService {
    pub unsafe fn GetValueNameByIndex(&self, ulindex: u32) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetValueNameByIndex)(windows_core::Interface::as_raw(self), ulindex, &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn GetValue(&self, bstrname: &windows_core::BSTR, bstrlanguage: &windows_core::BSTR) -> windows_core::Result<windows_core::BSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetValue)(windows_core::Interface::as_raw(self), core::mem::transmute_copy(bstrname), core::mem::transmute_copy(bstrlanguage), &mut result__).map(|| core::mem::transmute(result__))
        }
    }
    pub unsafe fn SetValue(&self, uldialogrequest: u32, bstrlanguage: &windows_core::BSTR, bstrname: &windows_core::BSTR, bstrvalue: &windows_core::BSTR, ulreserved: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetValue)(windows_core::Interface::as_raw(self), uldialogrequest, core::mem::transmute_copy(bstrlanguage), core::mem::transmute_copy(bstrname), core::mem::transmute_copy(bstrvalue), ulreserved).ok() }
    }
}
#[repr(C)]
pub struct IBDA_NameValueService_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetValueNameByIndex: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub GetValue: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub SetValue: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, *mut core::ffi::c_void, *mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
pub trait IBDA_NameValueService_Impl: windows_core::IUnknownImpl {
    fn GetValueNameByIndex(&self, ulindex: u32) -> windows_core::Result<windows_core::BSTR>;
    fn GetValue(&self, bstrname: &windows_core::BSTR, bstrlanguage: &windows_core::BSTR) -> windows_core::Result<windows_core::BSTR>;
    fn SetValue(&self, uldialogrequest: u32, bstrlanguage: &windows_core::BSTR, bstrname: &windows_core::BSTR, bstrvalue: &windows_core::BSTR, ulreserved: u32) -> windows_core::Result<()>;
}
impl IBDA_NameValueService_Vtbl {
    pub const fn new<Identity: IBDA_NameValueService_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetValueNameByIndex<Identity: IBDA_NameValueService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulindex: u32, pbstrname: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_NameValueService_Impl::GetValueNameByIndex(this, core::mem::transmute_copy(&ulindex)) {
                    Ok(ok__) => {
                        pbstrname.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn GetValue<Identity: IBDA_NameValueService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, bstrname: *mut core::ffi::c_void, bstrlanguage: *mut core::ffi::c_void, pbstrvalue: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_NameValueService_Impl::GetValue(this, core::mem::transmute(&bstrname), core::mem::transmute(&bstrlanguage)) {
                    Ok(ok__) => {
                        pbstrvalue.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetValue<Identity: IBDA_NameValueService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, uldialogrequest: u32, bstrlanguage: *mut core::ffi::c_void, bstrname: *mut core::ffi::c_void, bstrvalue: *mut core::ffi::c_void, ulreserved: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_NameValueService_Impl::SetValue(this, core::mem::transmute_copy(&uldialogrequest), core::mem::transmute(&bstrlanguage), core::mem::transmute(&bstrname), core::mem::transmute(&bstrvalue), core::mem::transmute_copy(&ulreserved)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetValueNameByIndex: GetValueNameByIndex::<Identity, OFFSET>,
            GetValue: GetValue::<Identity, OFFSET>,
            SetValue: SetValue::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_NameValueService as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_NameValueService {}
windows_core::imp::define_interface!(IBDA_NetworkProvider, IBDA_NetworkProvider_Vtbl, 0xfd501041_8ebe_11ce_8183_00aa00577da2);
windows_core::imp::interface_hierarchy!(IBDA_NetworkProvider, windows_core::IUnknown);
impl IBDA_NetworkProvider {
    pub unsafe fn PutSignalSource(&self, ulsignalsource: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PutSignalSource)(windows_core::Interface::as_raw(self), ulsignalsource).ok() }
    }
    pub unsafe fn GetSignalSource(&self, pulsignalsource: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetSignalSource)(windows_core::Interface::as_raw(self), pulsignalsource as _).ok() }
    }
    pub unsafe fn GetNetworkType(&self, pguidnetworktype: *mut windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetNetworkType)(windows_core::Interface::as_raw(self), pguidnetworktype as _).ok() }
    }
    pub unsafe fn PutTuningSpace(&self, guidtuningspace: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PutTuningSpace)(windows_core::Interface::as_raw(self), guidtuningspace).ok() }
    }
    pub unsafe fn GetTuningSpace(&self, pguidtuingspace: *mut windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTuningSpace)(windows_core::Interface::as_raw(self), pguidtuingspace as _).ok() }
    }
    pub unsafe fn RegisterDeviceFilter<P0>(&self, punkfiltercontrol: P0, ppvregisitrationcontext: *mut u32) -> windows_core::Result<()>
    where
        P0: windows_core::Param<windows_core::IUnknown>,
    {
        unsafe { (windows_core::Interface::vtable(self).RegisterDeviceFilter)(windows_core::Interface::as_raw(self), punkfiltercontrol.param().abi(), ppvregisitrationcontext as _).ok() }
    }
    pub unsafe fn UnRegisterDeviceFilter(&self, pvregistrationcontext: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).UnRegisterDeviceFilter)(windows_core::Interface::as_raw(self), pvregistrationcontext).ok() }
    }
}
#[repr(C)]
pub struct IBDA_NetworkProvider_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub PutSignalSource: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetSignalSource: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetNetworkType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub PutTuningSpace: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub GetTuningSpace: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub RegisterDeviceFilter: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub UnRegisterDeviceFilter: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
}
pub trait IBDA_NetworkProvider_Impl: windows_core::IUnknownImpl {
    fn PutSignalSource(&self, ulsignalsource: u32) -> windows_core::Result<()>;
    fn GetSignalSource(&self, pulsignalsource: *mut u32) -> windows_core::Result<()>;
    fn GetNetworkType(&self, pguidnetworktype: *mut windows_core::GUID) -> windows_core::Result<()>;
    fn PutTuningSpace(&self, guidtuningspace: *const windows_core::GUID) -> windows_core::Result<()>;
    fn GetTuningSpace(&self, pguidtuingspace: *mut windows_core::GUID) -> windows_core::Result<()>;
    fn RegisterDeviceFilter(&self, punkfiltercontrol: windows_core::Ref<'_, windows_core::IUnknown>, ppvregisitrationcontext: *mut u32) -> windows_core::Result<()>;
    fn UnRegisterDeviceFilter(&self, pvregistrationcontext: u32) -> windows_core::Result<()>;
}
impl IBDA_NetworkProvider_Vtbl {
    pub const fn new<Identity: IBDA_NetworkProvider_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn PutSignalSource<Identity: IBDA_NetworkProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulsignalsource: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_NetworkProvider_Impl::PutSignalSource(this, core::mem::transmute_copy(&ulsignalsource)).into()
            }
        }
        unsafe extern "system" fn GetSignalSource<Identity: IBDA_NetworkProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulsignalsource: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_NetworkProvider_Impl::GetSignalSource(this, core::mem::transmute_copy(&pulsignalsource)).into()
            }
        }
        unsafe extern "system" fn GetNetworkType<Identity: IBDA_NetworkProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguidnetworktype: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_NetworkProvider_Impl::GetNetworkType(this, core::mem::transmute_copy(&pguidnetworktype)).into()
            }
        }
        unsafe extern "system" fn PutTuningSpace<Identity: IBDA_NetworkProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, guidtuningspace: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_NetworkProvider_Impl::PutTuningSpace(this, core::mem::transmute_copy(&guidtuningspace)).into()
            }
        }
        unsafe extern "system" fn GetTuningSpace<Identity: IBDA_NetworkProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguidtuingspace: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_NetworkProvider_Impl::GetTuningSpace(this, core::mem::transmute_copy(&pguidtuingspace)).into()
            }
        }
        unsafe extern "system" fn RegisterDeviceFilter<Identity: IBDA_NetworkProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, punkfiltercontrol: *mut core::ffi::c_void, ppvregisitrationcontext: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_NetworkProvider_Impl::RegisterDeviceFilter(this, core::mem::transmute_copy(&punkfiltercontrol), core::mem::transmute_copy(&ppvregisitrationcontext)).into()
            }
        }
        unsafe extern "system" fn UnRegisterDeviceFilter<Identity: IBDA_NetworkProvider_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pvregistrationcontext: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_NetworkProvider_Impl::UnRegisterDeviceFilter(this, core::mem::transmute_copy(&pvregistrationcontext)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            PutSignalSource: PutSignalSource::<Identity, OFFSET>,
            GetSignalSource: GetSignalSource::<Identity, OFFSET>,
            GetNetworkType: GetNetworkType::<Identity, OFFSET>,
            PutTuningSpace: PutTuningSpace::<Identity, OFFSET>,
            GetTuningSpace: GetTuningSpace::<Identity, OFFSET>,
            RegisterDeviceFilter: RegisterDeviceFilter::<Identity, OFFSET>,
            UnRegisterDeviceFilter: UnRegisterDeviceFilter::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_NetworkProvider as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_NetworkProvider {}
windows_core::imp::define_interface!(IBDA_NullTransform, IBDA_NullTransform_Vtbl, 0xddf15b0d_bd25_11d2_9ca0_00c04f7971e0);
windows_core::imp::interface_hierarchy!(IBDA_NullTransform, windows_core::IUnknown);
impl IBDA_NullTransform {
    pub unsafe fn Start(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Start)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Stop(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Stop)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
pub struct IBDA_NullTransform_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Start: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Stop: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IBDA_NullTransform_Impl: windows_core::IUnknownImpl {
    fn Start(&self) -> windows_core::Result<()>;
    fn Stop(&self) -> windows_core::Result<()>;
}
impl IBDA_NullTransform_Vtbl {
    pub const fn new<Identity: IBDA_NullTransform_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Start<Identity: IBDA_NullTransform_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_NullTransform_Impl::Start(this).into()
            }
        }
        unsafe extern "system" fn Stop<Identity: IBDA_NullTransform_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_NullTransform_Impl::Stop(this).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Start: Start::<Identity, OFFSET>, Stop: Stop::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_NullTransform as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_NullTransform {}
windows_core::imp::define_interface!(IBDA_PinControl, IBDA_PinControl_Vtbl, 0x0ded49d5_a8b7_4d5d_97a1_12b0c195874d);
windows_core::imp::interface_hierarchy!(IBDA_PinControl, windows_core::IUnknown);
impl IBDA_PinControl {
    pub unsafe fn GetPinID(&self, pulpinid: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetPinID)(windows_core::Interface::as_raw(self), pulpinid as _).ok() }
    }
    pub unsafe fn GetPinType(&self, pulpintype: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetPinType)(windows_core::Interface::as_raw(self), pulpintype as _).ok() }
    }
    pub unsafe fn RegistrationContext(&self, pulregistrationctx: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RegistrationContext)(windows_core::Interface::as_raw(self), pulregistrationctx as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_PinControl_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetPinID: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub GetPinType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub RegistrationContext: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IBDA_PinControl_Impl: windows_core::IUnknownImpl {
    fn GetPinID(&self, pulpinid: *mut u32) -> windows_core::Result<()>;
    fn GetPinType(&self, pulpintype: *mut u32) -> windows_core::Result<()>;
    fn RegistrationContext(&self, pulregistrationctx: *mut u32) -> windows_core::Result<()>;
}
impl IBDA_PinControl_Vtbl {
    pub const fn new<Identity: IBDA_PinControl_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetPinID<Identity: IBDA_PinControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulpinid: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_PinControl_Impl::GetPinID(this, core::mem::transmute_copy(&pulpinid)).into()
            }
        }
        unsafe extern "system" fn GetPinType<Identity: IBDA_PinControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulpintype: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_PinControl_Impl::GetPinType(this, core::mem::transmute_copy(&pulpintype)).into()
            }
        }
        unsafe extern "system" fn RegistrationContext<Identity: IBDA_PinControl_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulregistrationctx: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_PinControl_Impl::RegistrationContext(this, core::mem::transmute_copy(&pulregistrationctx)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetPinID: GetPinID::<Identity, OFFSET>,
            GetPinType: GetPinType::<Identity, OFFSET>,
            RegistrationContext: RegistrationContext::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_PinControl as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_PinControl {}
windows_core::imp::define_interface!(IBDA_SignalProperties, IBDA_SignalProperties_Vtbl, 0xd2f1644b_b409_11d2_bc69_00a0c9ee9e16);
windows_core::imp::interface_hierarchy!(IBDA_SignalProperties, windows_core::IUnknown);
impl IBDA_SignalProperties {
    pub unsafe fn PutNetworkType(&self, guidnetworktype: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PutNetworkType)(windows_core::Interface::as_raw(self), guidnetworktype).ok() }
    }
    pub unsafe fn GetNetworkType(&self, pguidnetworktype: *mut windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetNetworkType)(windows_core::Interface::as_raw(self), pguidnetworktype as _).ok() }
    }
    pub unsafe fn PutSignalSource(&self, ulsignalsource: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PutSignalSource)(windows_core::Interface::as_raw(self), ulsignalsource).ok() }
    }
    pub unsafe fn GetSignalSource(&self, pulsignalsource: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetSignalSource)(windows_core::Interface::as_raw(self), pulsignalsource as _).ok() }
    }
    pub unsafe fn PutTuningSpace(&self, guidtuningspace: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PutTuningSpace)(windows_core::Interface::as_raw(self), guidtuningspace).ok() }
    }
    pub unsafe fn GetTuningSpace(&self, pguidtuingspace: *mut windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTuningSpace)(windows_core::Interface::as_raw(self), pguidtuingspace as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_SignalProperties_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub PutNetworkType: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub GetNetworkType: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub PutSignalSource: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetSignalSource: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub PutTuningSpace: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub GetTuningSpace: unsafe extern "system" fn(*mut core::ffi::c_void, *mut windows_core::GUID) -> windows_core::HRESULT,
}
pub trait IBDA_SignalProperties_Impl: windows_core::IUnknownImpl {
    fn PutNetworkType(&self, guidnetworktype: *const windows_core::GUID) -> windows_core::Result<()>;
    fn GetNetworkType(&self, pguidnetworktype: *mut windows_core::GUID) -> windows_core::Result<()>;
    fn PutSignalSource(&self, ulsignalsource: u32) -> windows_core::Result<()>;
    fn GetSignalSource(&self, pulsignalsource: *mut u32) -> windows_core::Result<()>;
    fn PutTuningSpace(&self, guidtuningspace: *const windows_core::GUID) -> windows_core::Result<()>;
    fn GetTuningSpace(&self, pguidtuingspace: *mut windows_core::GUID) -> windows_core::Result<()>;
}
impl IBDA_SignalProperties_Vtbl {
    pub const fn new<Identity: IBDA_SignalProperties_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn PutNetworkType<Identity: IBDA_SignalProperties_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, guidnetworktype: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalProperties_Impl::PutNetworkType(this, core::mem::transmute_copy(&guidnetworktype)).into()
            }
        }
        unsafe extern "system" fn GetNetworkType<Identity: IBDA_SignalProperties_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguidnetworktype: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalProperties_Impl::GetNetworkType(this, core::mem::transmute_copy(&pguidnetworktype)).into()
            }
        }
        unsafe extern "system" fn PutSignalSource<Identity: IBDA_SignalProperties_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulsignalsource: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalProperties_Impl::PutSignalSource(this, core::mem::transmute_copy(&ulsignalsource)).into()
            }
        }
        unsafe extern "system" fn GetSignalSource<Identity: IBDA_SignalProperties_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulsignalsource: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalProperties_Impl::GetSignalSource(this, core::mem::transmute_copy(&pulsignalsource)).into()
            }
        }
        unsafe extern "system" fn PutTuningSpace<Identity: IBDA_SignalProperties_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, guidtuningspace: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalProperties_Impl::PutTuningSpace(this, core::mem::transmute_copy(&guidtuningspace)).into()
            }
        }
        unsafe extern "system" fn GetTuningSpace<Identity: IBDA_SignalProperties_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pguidtuingspace: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalProperties_Impl::GetTuningSpace(this, core::mem::transmute_copy(&pguidtuingspace)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            PutNetworkType: PutNetworkType::<Identity, OFFSET>,
            GetNetworkType: GetNetworkType::<Identity, OFFSET>,
            PutSignalSource: PutSignalSource::<Identity, OFFSET>,
            GetSignalSource: GetSignalSource::<Identity, OFFSET>,
            PutTuningSpace: PutTuningSpace::<Identity, OFFSET>,
            GetTuningSpace: GetTuningSpace::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_SignalProperties as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_SignalProperties {}
windows_core::imp::define_interface!(IBDA_SignalStatistics, IBDA_SignalStatistics_Vtbl, 0x1347d106_cf3a_428a_a5cb_ac0d9a2a4338);
windows_core::imp::interface_hierarchy!(IBDA_SignalStatistics, windows_core::IUnknown);
impl IBDA_SignalStatistics {
    pub unsafe fn SetSignalStrength(&self, ldbstrength: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSignalStrength)(windows_core::Interface::as_raw(self), ldbstrength).ok() }
    }
    pub unsafe fn SignalStrength(&self, pldbstrength: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SignalStrength)(windows_core::Interface::as_raw(self), pldbstrength as _).ok() }
    }
    pub unsafe fn SetSignalQuality(&self, lpercentquality: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSignalQuality)(windows_core::Interface::as_raw(self), lpercentquality).ok() }
    }
    pub unsafe fn SignalQuality(&self, plpercentquality: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SignalQuality)(windows_core::Interface::as_raw(self), plpercentquality as _).ok() }
    }
    pub unsafe fn SetSignalPresent(&self, fpresent: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSignalPresent)(windows_core::Interface::as_raw(self), fpresent).ok() }
    }
    pub unsafe fn SignalPresent(&self, pfpresent: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SignalPresent)(windows_core::Interface::as_raw(self), pfpresent as _).ok() }
    }
    pub unsafe fn SetSignalLocked(&self, flocked: bool) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSignalLocked)(windows_core::Interface::as_raw(self), flocked).ok() }
    }
    pub unsafe fn SignalLocked(&self, pflocked: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SignalLocked)(windows_core::Interface::as_raw(self), pflocked as _).ok() }
    }
    pub unsafe fn SetSampleTime(&self, lmssampletime: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSampleTime)(windows_core::Interface::as_raw(self), lmssampletime).ok() }
    }
    pub unsafe fn SampleTime(&self, plmssampletime: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SampleTime)(windows_core::Interface::as_raw(self), plmssampletime as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_SignalStatistics_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetSignalStrength: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub SignalStrength: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetSignalQuality: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub SignalQuality: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
    pub SetSignalPresent: unsafe extern "system" fn(*mut core::ffi::c_void, bool) -> windows_core::HRESULT,
    pub SignalPresent: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub SetSignalLocked: unsafe extern "system" fn(*mut core::ffi::c_void, bool) -> windows_core::HRESULT,
    pub SignalLocked: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u8) -> windows_core::HRESULT,
    pub SetSampleTime: unsafe extern "system" fn(*mut core::ffi::c_void, i32) -> windows_core::HRESULT,
    pub SampleTime: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32) -> windows_core::HRESULT,
}
pub trait IBDA_SignalStatistics_Impl: windows_core::IUnknownImpl {
    fn SetSignalStrength(&self, ldbstrength: i32) -> windows_core::Result<()>;
    fn SignalStrength(&self, pldbstrength: *mut i32) -> windows_core::Result<()>;
    fn SetSignalQuality(&self, lpercentquality: i32) -> windows_core::Result<()>;
    fn SignalQuality(&self, plpercentquality: *mut i32) -> windows_core::Result<()>;
    fn SetSignalPresent(&self, fpresent: bool) -> windows_core::Result<()>;
    fn SignalPresent(&self, pfpresent: *mut u8) -> windows_core::Result<()>;
    fn SetSignalLocked(&self, flocked: bool) -> windows_core::Result<()>;
    fn SignalLocked(&self, pflocked: *mut u8) -> windows_core::Result<()>;
    fn SetSampleTime(&self, lmssampletime: i32) -> windows_core::Result<()>;
    fn SampleTime(&self, plmssampletime: *mut i32) -> windows_core::Result<()>;
}
impl IBDA_SignalStatistics_Vtbl {
    pub const fn new<Identity: IBDA_SignalStatistics_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetSignalStrength<Identity: IBDA_SignalStatistics_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ldbstrength: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalStatistics_Impl::SetSignalStrength(this, core::mem::transmute_copy(&ldbstrength)).into()
            }
        }
        unsafe extern "system" fn SignalStrength<Identity: IBDA_SignalStatistics_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pldbstrength: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalStatistics_Impl::SignalStrength(this, core::mem::transmute_copy(&pldbstrength)).into()
            }
        }
        unsafe extern "system" fn SetSignalQuality<Identity: IBDA_SignalStatistics_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lpercentquality: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalStatistics_Impl::SetSignalQuality(this, core::mem::transmute_copy(&lpercentquality)).into()
            }
        }
        unsafe extern "system" fn SignalQuality<Identity: IBDA_SignalStatistics_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plpercentquality: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalStatistics_Impl::SignalQuality(this, core::mem::transmute_copy(&plpercentquality)).into()
            }
        }
        unsafe extern "system" fn SetSignalPresent<Identity: IBDA_SignalStatistics_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, fpresent: bool) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalStatistics_Impl::SetSignalPresent(this, core::mem::transmute_copy(&fpresent)).into()
            }
        }
        unsafe extern "system" fn SignalPresent<Identity: IBDA_SignalStatistics_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pfpresent: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalStatistics_Impl::SignalPresent(this, core::mem::transmute_copy(&pfpresent)).into()
            }
        }
        unsafe extern "system" fn SetSignalLocked<Identity: IBDA_SignalStatistics_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, flocked: bool) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalStatistics_Impl::SetSignalLocked(this, core::mem::transmute_copy(&flocked)).into()
            }
        }
        unsafe extern "system" fn SignalLocked<Identity: IBDA_SignalStatistics_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pflocked: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalStatistics_Impl::SignalLocked(this, core::mem::transmute_copy(&pflocked)).into()
            }
        }
        unsafe extern "system" fn SetSampleTime<Identity: IBDA_SignalStatistics_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, lmssampletime: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalStatistics_Impl::SetSampleTime(this, core::mem::transmute_copy(&lmssampletime)).into()
            }
        }
        unsafe extern "system" fn SampleTime<Identity: IBDA_SignalStatistics_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, plmssampletime: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_SignalStatistics_Impl::SampleTime(this, core::mem::transmute_copy(&plmssampletime)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetSignalStrength: SetSignalStrength::<Identity, OFFSET>,
            SignalStrength: SignalStrength::<Identity, OFFSET>,
            SetSignalQuality: SetSignalQuality::<Identity, OFFSET>,
            SignalQuality: SignalQuality::<Identity, OFFSET>,
            SetSignalPresent: SetSignalPresent::<Identity, OFFSET>,
            SignalPresent: SignalPresent::<Identity, OFFSET>,
            SetSignalLocked: SetSignalLocked::<Identity, OFFSET>,
            SignalLocked: SignalLocked::<Identity, OFFSET>,
            SetSampleTime: SetSampleTime::<Identity, OFFSET>,
            SampleTime: SampleTime::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_SignalStatistics as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_SignalStatistics {}
windows_core::imp::define_interface!(IBDA_Topology, IBDA_Topology_Vtbl, 0x79b56888_7fea_4690_b45d_38fd3c7849be);
windows_core::imp::interface_hierarchy!(IBDA_Topology, windows_core::IUnknown);
impl IBDA_Topology {
    pub unsafe fn GetNodeTypes(&self, pulcnodetypes: *mut u32, rgulnodetypes: &mut [u32]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetNodeTypes)(windows_core::Interface::as_raw(self), pulcnodetypes as _, rgulnodetypes.len().try_into().unwrap(), core::mem::transmute(rgulnodetypes.as_ptr())).ok() }
    }
    pub unsafe fn GetNodeDescriptors(&self, ulcnodedescriptors: *mut u32, rgnodedescriptors: &mut [BDANODE_DESCRIPTOR]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetNodeDescriptors)(windows_core::Interface::as_raw(self), ulcnodedescriptors as _, rgnodedescriptors.len().try_into().unwrap(), core::mem::transmute(rgnodedescriptors.as_ptr())).ok() }
    }
    pub unsafe fn GetNodeInterfaces(&self, ulnodetype: u32, pulcinterfaces: *mut u32, rgguidinterfaces: &mut [windows_core::GUID]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetNodeInterfaces)(windows_core::Interface::as_raw(self), ulnodetype, pulcinterfaces as _, rgguidinterfaces.len().try_into().unwrap(), core::mem::transmute(rgguidinterfaces.as_ptr())).ok() }
    }
    pub unsafe fn GetPinTypes(&self, pulcpintypes: *mut u32, rgulpintypes: &mut [u32]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetPinTypes)(windows_core::Interface::as_raw(self), pulcpintypes as _, rgulpintypes.len().try_into().unwrap(), core::mem::transmute(rgulpintypes.as_ptr())).ok() }
    }
    pub unsafe fn GetTemplateConnections(&self, pulcconnections: *mut u32, rgconnections: &mut [BDA_TEMPLATE_CONNECTION]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTemplateConnections)(windows_core::Interface::as_raw(self), pulcconnections as _, rgconnections.len().try_into().unwrap(), core::mem::transmute(rgconnections.as_ptr())).ok() }
    }
    pub unsafe fn CreatePin(&self, ulpintype: u32, pulpinid: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CreatePin)(windows_core::Interface::as_raw(self), ulpintype, pulpinid as _).ok() }
    }
    pub unsafe fn DeletePin(&self, ulpinid: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).DeletePin)(windows_core::Interface::as_raw(self), ulpinid).ok() }
    }
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub unsafe fn SetMediaType(&self, ulpinid: u32, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMediaType)(windows_core::Interface::as_raw(self), ulpinid, core::mem::transmute(pmediatype)).ok() }
    }
    pub unsafe fn SetMedium(&self, ulpinid: u32, pmedium: *const REGPINMEDIUM) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetMedium)(windows_core::Interface::as_raw(self), ulpinid, pmedium).ok() }
    }
    pub unsafe fn CreateTopology(&self, ulinputpinid: u32, uloutputpinid: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CreateTopology)(windows_core::Interface::as_raw(self), ulinputpinid, uloutputpinid).ok() }
    }
    pub unsafe fn GetControlNode(&self, ulinputpinid: u32, uloutputpinid: u32, ulnodetype: u32, ppcontrolnode: *mut Option<windows_core::IUnknown>) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetControlNode)(windows_core::Interface::as_raw(self), ulinputpinid, uloutputpinid, ulnodetype, core::mem::transmute(ppcontrolnode)).ok() }
    }
}
#[repr(C)]
pub struct IBDA_Topology_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetNodeTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetNodeDescriptors: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, u32, *mut BDANODE_DESCRIPTOR) -> windows_core::HRESULT,
    pub GetNodeInterfaces: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32, u32, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub GetPinTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, u32, *mut u32) -> windows_core::HRESULT,
    pub GetTemplateConnections: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, u32, *mut BDA_TEMPLATE_CONNECTION) -> windows_core::HRESULT,
    pub CreatePin: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut u32) -> windows_core::HRESULT,
    pub DeletePin: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_MediaFoundation")]
    pub SetMediaType: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_MediaFoundation"))]
    SetMediaType: usize,
    pub SetMedium: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const REGPINMEDIUM) -> windows_core::HRESULT,
    pub CreateTopology: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32) -> windows_core::HRESULT,
    pub GetControlNode: unsafe extern "system" fn(*mut core::ffi::c_void, u32, u32, u32, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
pub trait IBDA_Topology_Impl: windows_core::IUnknownImpl {
    fn GetNodeTypes(&self, pulcnodetypes: *mut u32, ulcnodetypesmax: u32, rgulnodetypes: *mut u32) -> windows_core::Result<()>;
    fn GetNodeDescriptors(&self, ulcnodedescriptors: *mut u32, ulcnodedescriptorsmax: u32, rgnodedescriptors: *mut BDANODE_DESCRIPTOR) -> windows_core::Result<()>;
    fn GetNodeInterfaces(&self, ulnodetype: u32, pulcinterfaces: *mut u32, ulcinterfacesmax: u32, rgguidinterfaces: *mut windows_core::GUID) -> windows_core::Result<()>;
    fn GetPinTypes(&self, pulcpintypes: *mut u32, ulcpintypesmax: u32, rgulpintypes: *mut u32) -> windows_core::Result<()>;
    fn GetTemplateConnections(&self, pulcconnections: *mut u32, ulcconnectionsmax: u32, rgconnections: *mut BDA_TEMPLATE_CONNECTION) -> windows_core::Result<()>;
    fn CreatePin(&self, ulpintype: u32, pulpinid: *mut u32) -> windows_core::Result<()>;
    fn DeletePin(&self, ulpinid: u32) -> windows_core::Result<()>;
    fn SetMediaType(&self, ulpinid: u32, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::Result<()>;
    fn SetMedium(&self, ulpinid: u32, pmedium: *const REGPINMEDIUM) -> windows_core::Result<()>;
    fn CreateTopology(&self, ulinputpinid: u32, uloutputpinid: u32) -> windows_core::Result<()>;
    fn GetControlNode(&self, ulinputpinid: u32, uloutputpinid: u32, ulnodetype: u32, ppcontrolnode: windows_core::OutRef<'_, windows_core::IUnknown>) -> windows_core::Result<()>;
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl IBDA_Topology_Vtbl {
    pub const fn new<Identity: IBDA_Topology_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetNodeTypes<Identity: IBDA_Topology_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcnodetypes: *mut u32, ulcnodetypesmax: u32, rgulnodetypes: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Topology_Impl::GetNodeTypes(this, core::mem::transmute_copy(&pulcnodetypes), core::mem::transmute_copy(&ulcnodetypesmax), core::mem::transmute_copy(&rgulnodetypes)).into()
            }
        }
        unsafe extern "system" fn GetNodeDescriptors<Identity: IBDA_Topology_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulcnodedescriptors: *mut u32, ulcnodedescriptorsmax: u32, rgnodedescriptors: *mut BDANODE_DESCRIPTOR) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Topology_Impl::GetNodeDescriptors(this, core::mem::transmute_copy(&ulcnodedescriptors), core::mem::transmute_copy(&ulcnodedescriptorsmax), core::mem::transmute_copy(&rgnodedescriptors)).into()
            }
        }
        unsafe extern "system" fn GetNodeInterfaces<Identity: IBDA_Topology_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulnodetype: u32, pulcinterfaces: *mut u32, ulcinterfacesmax: u32, rgguidinterfaces: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Topology_Impl::GetNodeInterfaces(this, core::mem::transmute_copy(&ulnodetype), core::mem::transmute_copy(&pulcinterfaces), core::mem::transmute_copy(&ulcinterfacesmax), core::mem::transmute_copy(&rgguidinterfaces)).into()
            }
        }
        unsafe extern "system" fn GetPinTypes<Identity: IBDA_Topology_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcpintypes: *mut u32, ulcpintypesmax: u32, rgulpintypes: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Topology_Impl::GetPinTypes(this, core::mem::transmute_copy(&pulcpintypes), core::mem::transmute_copy(&ulcpintypesmax), core::mem::transmute_copy(&rgulpintypes)).into()
            }
        }
        unsafe extern "system" fn GetTemplateConnections<Identity: IBDA_Topology_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulcconnections: *mut u32, ulcconnectionsmax: u32, rgconnections: *mut BDA_TEMPLATE_CONNECTION) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Topology_Impl::GetTemplateConnections(this, core::mem::transmute_copy(&pulcconnections), core::mem::transmute_copy(&ulcconnectionsmax), core::mem::transmute_copy(&rgconnections)).into()
            }
        }
        unsafe extern "system" fn CreatePin<Identity: IBDA_Topology_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulpintype: u32, pulpinid: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Topology_Impl::CreatePin(this, core::mem::transmute_copy(&ulpintype), core::mem::transmute_copy(&pulpinid)).into()
            }
        }
        unsafe extern "system" fn DeletePin<Identity: IBDA_Topology_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulpinid: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Topology_Impl::DeletePin(this, core::mem::transmute_copy(&ulpinid)).into()
            }
        }
        unsafe extern "system" fn SetMediaType<Identity: IBDA_Topology_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulpinid: u32, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Topology_Impl::SetMediaType(this, core::mem::transmute_copy(&ulpinid), core::mem::transmute_copy(&pmediatype)).into()
            }
        }
        unsafe extern "system" fn SetMedium<Identity: IBDA_Topology_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulpinid: u32, pmedium: *const REGPINMEDIUM) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Topology_Impl::SetMedium(this, core::mem::transmute_copy(&ulpinid), core::mem::transmute_copy(&pmedium)).into()
            }
        }
        unsafe extern "system" fn CreateTopology<Identity: IBDA_Topology_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulinputpinid: u32, uloutputpinid: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Topology_Impl::CreateTopology(this, core::mem::transmute_copy(&ulinputpinid), core::mem::transmute_copy(&uloutputpinid)).into()
            }
        }
        unsafe extern "system" fn GetControlNode<Identity: IBDA_Topology_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulinputpinid: u32, uloutputpinid: u32, ulnodetype: u32, ppcontrolnode: *mut *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_Topology_Impl::GetControlNode(this, core::mem::transmute_copy(&ulinputpinid), core::mem::transmute_copy(&uloutputpinid), core::mem::transmute_copy(&ulnodetype), core::mem::transmute_copy(&ppcontrolnode)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetNodeTypes: GetNodeTypes::<Identity, OFFSET>,
            GetNodeDescriptors: GetNodeDescriptors::<Identity, OFFSET>,
            GetNodeInterfaces: GetNodeInterfaces::<Identity, OFFSET>,
            GetPinTypes: GetPinTypes::<Identity, OFFSET>,
            GetTemplateConnections: GetTemplateConnections::<Identity, OFFSET>,
            CreatePin: CreatePin::<Identity, OFFSET>,
            DeletePin: DeletePin::<Identity, OFFSET>,
            SetMediaType: SetMediaType::<Identity, OFFSET>,
            SetMedium: SetMedium::<Identity, OFFSET>,
            CreateTopology: CreateTopology::<Identity, OFFSET>,
            GetControlNode: GetControlNode::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_Topology as windows_core::Interface>::IID
    }
}
#[cfg(feature = "Win32_Media_MediaFoundation")]
impl windows_core::RuntimeName for IBDA_Topology {}
windows_core::imp::define_interface!(IBDA_TransportStreamInfo, IBDA_TransportStreamInfo_Vtbl, 0x8e882535_5f86_47ab_86cf_c281a72a0549);
windows_core::imp::interface_hierarchy!(IBDA_TransportStreamInfo, windows_core::IUnknown);
impl IBDA_TransportStreamInfo {
    pub unsafe fn PatTableTickCount(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).PatTableTickCount)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[repr(C)]
pub struct IBDA_TransportStreamInfo_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub PatTableTickCount: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
}
pub trait IBDA_TransportStreamInfo_Impl: windows_core::IUnknownImpl {
    fn PatTableTickCount(&self) -> windows_core::Result<u32>;
}
impl IBDA_TransportStreamInfo_Vtbl {
    pub const fn new<Identity: IBDA_TransportStreamInfo_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn PatTableTickCount<Identity: IBDA_TransportStreamInfo_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ppattickcount: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_TransportStreamInfo_Impl::PatTableTickCount(this) {
                    Ok(ok__) => {
                        ppattickcount.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), PatTableTickCount: PatTableTickCount::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_TransportStreamInfo as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_TransportStreamInfo {}
windows_core::imp::define_interface!(IBDA_TransportStreamSelector, IBDA_TransportStreamSelector_Vtbl, 0x1dcfafe9_b45e_41b3_bb2a_561eb129ae98);
windows_core::imp::interface_hierarchy!(IBDA_TransportStreamSelector, windows_core::IUnknown);
impl IBDA_TransportStreamSelector {
    pub unsafe fn SetTSID(&self, ustsid: u16) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetTSID)(windows_core::Interface::as_raw(self), ustsid).ok() }
    }
    pub unsafe fn GetTSInformation(&self, pultsinformationbufferlen: *mut u32, pbtsinformationbuffer: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetTSInformation)(windows_core::Interface::as_raw(self), pultsinformationbufferlen as _, pbtsinformationbuffer as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_TransportStreamSelector_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetTSID: unsafe extern "system" fn(*mut core::ffi::c_void, u16) -> windows_core::HRESULT,
    pub GetTSInformation: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u8) -> windows_core::HRESULT,
}
pub trait IBDA_TransportStreamSelector_Impl: windows_core::IUnknownImpl {
    fn SetTSID(&self, ustsid: u16) -> windows_core::Result<()>;
    fn GetTSInformation(&self, pultsinformationbufferlen: *mut u32, pbtsinformationbuffer: *mut u8) -> windows_core::Result<()>;
}
impl IBDA_TransportStreamSelector_Vtbl {
    pub const fn new<Identity: IBDA_TransportStreamSelector_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetTSID<Identity: IBDA_TransportStreamSelector_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ustsid: u16) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_TransportStreamSelector_Impl::SetTSID(this, core::mem::transmute_copy(&ustsid)).into()
            }
        }
        unsafe extern "system" fn GetTSInformation<Identity: IBDA_TransportStreamSelector_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pultsinformationbufferlen: *mut u32, pbtsinformationbuffer: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_TransportStreamSelector_Impl::GetTSInformation(this, core::mem::transmute_copy(&pultsinformationbufferlen), core::mem::transmute_copy(&pbtsinformationbuffer)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetTSID: SetTSID::<Identity, OFFSET>,
            GetTSInformation: GetTSInformation::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_TransportStreamSelector as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_TransportStreamSelector {}
windows_core::imp::define_interface!(IBDA_UserActivityService, IBDA_UserActivityService_Vtbl, 0x53b14189_e478_4b7a_a1ff_506db4b99dfe);
windows_core::imp::interface_hierarchy!(IBDA_UserActivityService, windows_core::IUnknown);
impl IBDA_UserActivityService {
    pub unsafe fn SetCurrentTunerUseReason(&self, dwusereason: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCurrentTunerUseReason)(windows_core::Interface::as_raw(self), dwusereason).ok() }
    }
    pub unsafe fn GetUserActivityInterval(&self) -> windows_core::Result<u32> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetUserActivityInterval)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
    pub unsafe fn UserActivityDetected(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).UserActivityDetected)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
pub struct IBDA_UserActivityService_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub SetCurrentTunerUseReason: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetUserActivityInterval: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32) -> windows_core::HRESULT,
    pub UserActivityDetected: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IBDA_UserActivityService_Impl: windows_core::IUnknownImpl {
    fn SetCurrentTunerUseReason(&self, dwusereason: u32) -> windows_core::Result<()>;
    fn GetUserActivityInterval(&self) -> windows_core::Result<u32>;
    fn UserActivityDetected(&self) -> windows_core::Result<()>;
}
impl IBDA_UserActivityService_Vtbl {
    pub const fn new<Identity: IBDA_UserActivityService_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn SetCurrentTunerUseReason<Identity: IBDA_UserActivityService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, dwusereason: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_UserActivityService_Impl::SetCurrentTunerUseReason(this, core::mem::transmute_copy(&dwusereason)).into()
            }
        }
        unsafe extern "system" fn GetUserActivityInterval<Identity: IBDA_UserActivityService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pdwactivityinterval: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_UserActivityService_Impl::GetUserActivityInterval(this) {
                    Ok(ok__) => {
                        pdwactivityinterval.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn UserActivityDetected<Identity: IBDA_UserActivityService_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_UserActivityService_Impl::UserActivityDetected(this).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            SetCurrentTunerUseReason: SetCurrentTunerUseReason::<Identity, OFFSET>,
            GetUserActivityInterval: GetUserActivityInterval::<Identity, OFFSET>,
            UserActivityDetected: UserActivityDetected::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_UserActivityService as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_UserActivityService {}
windows_core::imp::define_interface!(IBDA_VoidTransform, IBDA_VoidTransform_Vtbl, 0x71985f46_1ca1_11d3_9cc8_00c04f7971e0);
windows_core::imp::interface_hierarchy!(IBDA_VoidTransform, windows_core::IUnknown);
impl IBDA_VoidTransform {
    pub unsafe fn Start(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Start)(windows_core::Interface::as_raw(self)).ok() }
    }
    pub unsafe fn Stop(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).Stop)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
pub struct IBDA_VoidTransform_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub Start: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
    pub Stop: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IBDA_VoidTransform_Impl: windows_core::IUnknownImpl {
    fn Start(&self) -> windows_core::Result<()>;
    fn Stop(&self) -> windows_core::Result<()>;
}
impl IBDA_VoidTransform_Vtbl {
    pub const fn new<Identity: IBDA_VoidTransform_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn Start<Identity: IBDA_VoidTransform_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_VoidTransform_Impl::Start(this).into()
            }
        }
        unsafe extern "system" fn Stop<Identity: IBDA_VoidTransform_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_VoidTransform_Impl::Stop(this).into()
            }
        }
        Self { base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(), Start: Start::<Identity, OFFSET>, Stop: Stop::<Identity, OFFSET> }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_VoidTransform as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_VoidTransform {}
windows_core::imp::define_interface!(IBDA_WMDRMSession, IBDA_WMDRMSession_Vtbl, 0x4be6fa3d_07cd_4139_8b80_8c18ba3aec88);
windows_core::imp::interface_hierarchy!(IBDA_WMDRMSession, windows_core::IUnknown);
impl IBDA_WMDRMSession {
    pub unsafe fn GetStatus(&self, maxcapturetoken: *mut u32, maxstreamingpid: *mut u32, maxlicense: *mut u32, minsecuritylevel: *mut u32, revinfosequencenumber: *mut u32, revinfoissuedtime: *mut u64, revinfottl: *mut u32, revlistversion: *mut u32, ulstate: *mut u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetStatus)(windows_core::Interface::as_raw(self), maxcapturetoken as _, maxstreamingpid as _, maxlicense as _, minsecuritylevel as _, revinfosequencenumber as _, revinfoissuedtime as _, revinfottl as _, revlistversion as _, ulstate as _).ok() }
    }
    pub unsafe fn SetRevInfo(&self, pbrevinfo: &[u8]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetRevInfo)(windows_core::Interface::as_raw(self), pbrevinfo.len().try_into().unwrap(), core::mem::transmute(pbrevinfo.as_ptr())).ok() }
    }
    pub unsafe fn SetCrl(&self, pbcrllen: &[u8]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetCrl)(windows_core::Interface::as_raw(self), pbcrllen.len().try_into().unwrap(), core::mem::transmute(pbcrllen.as_ptr())).ok() }
    }
    pub unsafe fn TransactMessage(&self, pbrequest: &[u8], pulcbresponse: *mut u32, pbresponse: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).TransactMessage)(windows_core::Interface::as_raw(self), pbrequest.len().try_into().unwrap(), core::mem::transmute(pbrequest.as_ptr()), pulcbresponse as _, pbresponse as _).ok() }
    }
    pub unsafe fn GetLicense(&self, uuidkey: *const windows_core::GUID, pulpackagelen: *mut u32, pbpackage: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetLicense)(windows_core::Interface::as_raw(self), uuidkey, pulpackagelen as _, pbpackage as _).ok() }
    }
    pub unsafe fn ReissueLicense(&self, uuidkey: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).ReissueLicense)(windows_core::Interface::as_raw(self), uuidkey).ok() }
    }
    pub unsafe fn RenewLicense(&self, pbinxmrlicense: &[u8], pbentitlementtoken: &[u8], puldescramblestatus: *mut u32, puloutxmrlicenselen: *mut u32, pboutxmrlicense: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).RenewLicense)(windows_core::Interface::as_raw(self), pbinxmrlicense.len().try_into().unwrap(), core::mem::transmute(pbinxmrlicense.as_ptr()), pbentitlementtoken.len().try_into().unwrap(), core::mem::transmute(pbentitlementtoken.as_ptr()), puldescramblestatus as _, puloutxmrlicenselen as _, pboutxmrlicense as _).ok() }
    }
    pub unsafe fn GetKeyInfo(&self, pulkeyinfolen: *mut u32, pbkeyinfo: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetKeyInfo)(windows_core::Interface::as_raw(self), pulkeyinfolen as _, pbkeyinfo as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_WMDRMSession_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub GetStatus: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u32, *mut u32, *mut u32, *mut u32, *mut u64, *mut u32, *mut u32, *mut u32) -> windows_core::HRESULT,
    pub SetRevInfo: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u8) -> windows_core::HRESULT,
    pub SetCrl: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u8) -> windows_core::HRESULT,
    pub TransactMessage: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u8, *mut u32, *mut u8) -> windows_core::HRESULT,
    pub GetLicense: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID, *mut u32, *mut u8) -> windows_core::HRESULT,
    pub ReissueLicense: unsafe extern "system" fn(*mut core::ffi::c_void, *const windows_core::GUID) -> windows_core::HRESULT,
    pub RenewLicense: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u8, u32, *const u8, *mut u32, *mut u32, *mut u8) -> windows_core::HRESULT,
    pub GetKeyInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u8) -> windows_core::HRESULT,
}
pub trait IBDA_WMDRMSession_Impl: windows_core::IUnknownImpl {
    fn GetStatus(&self, maxcapturetoken: *mut u32, maxstreamingpid: *mut u32, maxlicense: *mut u32, minsecuritylevel: *mut u32, revinfosequencenumber: *mut u32, revinfoissuedtime: *mut u64, revinfottl: *mut u32, revlistversion: *mut u32, ulstate: *mut u32) -> windows_core::Result<()>;
    fn SetRevInfo(&self, ulrevinfolen: u32, pbrevinfo: *const u8) -> windows_core::Result<()>;
    fn SetCrl(&self, ulcrllen: u32, pbcrllen: *const u8) -> windows_core::Result<()>;
    fn TransactMessage(&self, ulcbrequest: u32, pbrequest: *const u8, pulcbresponse: *mut u32, pbresponse: *mut u8) -> windows_core::Result<()>;
    fn GetLicense(&self, uuidkey: *const windows_core::GUID, pulpackagelen: *mut u32, pbpackage: *mut u8) -> windows_core::Result<()>;
    fn ReissueLicense(&self, uuidkey: *const windows_core::GUID) -> windows_core::Result<()>;
    fn RenewLicense(&self, ulinxmrlicenselen: u32, pbinxmrlicense: *const u8, ulentitlementtokenlen: u32, pbentitlementtoken: *const u8, puldescramblestatus: *mut u32, puloutxmrlicenselen: *mut u32, pboutxmrlicense: *mut u8) -> windows_core::Result<()>;
    fn GetKeyInfo(&self, pulkeyinfolen: *mut u32, pbkeyinfo: *mut u8) -> windows_core::Result<()>;
}
impl IBDA_WMDRMSession_Vtbl {
    pub const fn new<Identity: IBDA_WMDRMSession_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn GetStatus<Identity: IBDA_WMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, maxcapturetoken: *mut u32, maxstreamingpid: *mut u32, maxlicense: *mut u32, minsecuritylevel: *mut u32, revinfosequencenumber: *mut u32, revinfoissuedtime: *mut u64, revinfottl: *mut u32, revlistversion: *mut u32, ulstate: *mut u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_WMDRMSession_Impl::GetStatus(this, core::mem::transmute_copy(&maxcapturetoken), core::mem::transmute_copy(&maxstreamingpid), core::mem::transmute_copy(&maxlicense), core::mem::transmute_copy(&minsecuritylevel), core::mem::transmute_copy(&revinfosequencenumber), core::mem::transmute_copy(&revinfoissuedtime), core::mem::transmute_copy(&revinfottl), core::mem::transmute_copy(&revlistversion), core::mem::transmute_copy(&ulstate)).into()
            }
        }
        unsafe extern "system" fn SetRevInfo<Identity: IBDA_WMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulrevinfolen: u32, pbrevinfo: *const u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_WMDRMSession_Impl::SetRevInfo(this, core::mem::transmute_copy(&ulrevinfolen), core::mem::transmute_copy(&pbrevinfo)).into()
            }
        }
        unsafe extern "system" fn SetCrl<Identity: IBDA_WMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulcrllen: u32, pbcrllen: *const u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_WMDRMSession_Impl::SetCrl(this, core::mem::transmute_copy(&ulcrllen), core::mem::transmute_copy(&pbcrllen)).into()
            }
        }
        unsafe extern "system" fn TransactMessage<Identity: IBDA_WMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulcbrequest: u32, pbrequest: *const u8, pulcbresponse: *mut u32, pbresponse: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_WMDRMSession_Impl::TransactMessage(this, core::mem::transmute_copy(&ulcbrequest), core::mem::transmute_copy(&pbrequest), core::mem::transmute_copy(&pulcbresponse), core::mem::transmute_copy(&pbresponse)).into()
            }
        }
        unsafe extern "system" fn GetLicense<Identity: IBDA_WMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, uuidkey: *const windows_core::GUID, pulpackagelen: *mut u32, pbpackage: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_WMDRMSession_Impl::GetLicense(this, core::mem::transmute_copy(&uuidkey), core::mem::transmute_copy(&pulpackagelen), core::mem::transmute_copy(&pbpackage)).into()
            }
        }
        unsafe extern "system" fn ReissueLicense<Identity: IBDA_WMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, uuidkey: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_WMDRMSession_Impl::ReissueLicense(this, core::mem::transmute_copy(&uuidkey)).into()
            }
        }
        unsafe extern "system" fn RenewLicense<Identity: IBDA_WMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulinxmrlicenselen: u32, pbinxmrlicense: *const u8, ulentitlementtokenlen: u32, pbentitlementtoken: *const u8, puldescramblestatus: *mut u32, puloutxmrlicenselen: *mut u32, pboutxmrlicense: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_WMDRMSession_Impl::RenewLicense(this, core::mem::transmute_copy(&ulinxmrlicenselen), core::mem::transmute_copy(&pbinxmrlicense), core::mem::transmute_copy(&ulentitlementtokenlen), core::mem::transmute_copy(&pbentitlementtoken), core::mem::transmute_copy(&puldescramblestatus), core::mem::transmute_copy(&puloutxmrlicenselen), core::mem::transmute_copy(&pboutxmrlicense)).into()
            }
        }
        unsafe extern "system" fn GetKeyInfo<Identity: IBDA_WMDRMSession_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulkeyinfolen: *mut u32, pbkeyinfo: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_WMDRMSession_Impl::GetKeyInfo(this, core::mem::transmute_copy(&pulkeyinfolen), core::mem::transmute_copy(&pbkeyinfo)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            GetStatus: GetStatus::<Identity, OFFSET>,
            SetRevInfo: SetRevInfo::<Identity, OFFSET>,
            SetCrl: SetCrl::<Identity, OFFSET>,
            TransactMessage: TransactMessage::<Identity, OFFSET>,
            GetLicense: GetLicense::<Identity, OFFSET>,
            ReissueLicense: ReissueLicense::<Identity, OFFSET>,
            RenewLicense: RenewLicense::<Identity, OFFSET>,
            GetKeyInfo: GetKeyInfo::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_WMDRMSession as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_WMDRMSession {}
windows_core::imp::define_interface!(IBDA_WMDRMTuner, IBDA_WMDRMTuner_Vtbl, 0x86d979cf_a8a7_4f94_b5fb_14c0aca68fe6);
windows_core::imp::interface_hierarchy!(IBDA_WMDRMTuner, windows_core::IUnknown);
impl IBDA_WMDRMTuner {
    pub unsafe fn PurchaseEntitlement(&self, uldialogrequest: u32, bstrlanguage: &windows_core::BSTR, pbpurchasetoken: &[u8], puldescramblestatus: *mut u32, pulcapturetokenlen: *mut u32, pbcapturetoken: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).PurchaseEntitlement)(windows_core::Interface::as_raw(self), uldialogrequest, core::mem::transmute_copy(bstrlanguage), pbpurchasetoken.len().try_into().unwrap(), core::mem::transmute(pbpurchasetoken.as_ptr()), puldescramblestatus as _, pulcapturetokenlen as _, pbcapturetoken as _).ok() }
    }
    pub unsafe fn CancelCaptureToken(&self, pbcapturetoken: &[u8]) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).CancelCaptureToken)(windows_core::Interface::as_raw(self), pbcapturetoken.len().try_into().unwrap(), core::mem::transmute(pbcapturetoken.as_ptr())).ok() }
    }
    pub unsafe fn SetPidProtection(&self, ulpid: u32, uuidkey: *const windows_core::GUID) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetPidProtection)(windows_core::Interface::as_raw(self), ulpid, uuidkey).ok() }
    }
    pub unsafe fn GetPidProtection(&self, pulpid: u32) -> windows_core::Result<windows_core::GUID> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).GetPidProtection)(windows_core::Interface::as_raw(self), pulpid, &mut result__).map(|| result__)
        }
    }
    pub unsafe fn SetSyncValue(&self, ulsyncvalue: u32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).SetSyncValue)(windows_core::Interface::as_raw(self), ulsyncvalue).ok() }
    }
    pub unsafe fn GetStartCodeProfile(&self, pulstartcodeprofilelen: *mut u32, pbstartcodeprofile: *mut u8) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).GetStartCodeProfile)(windows_core::Interface::as_raw(self), pulstartcodeprofilelen as _, pbstartcodeprofile as _).ok() }
    }
}
#[repr(C)]
pub struct IBDA_WMDRMTuner_Vtbl {
    pub base__: windows_core::IUnknown_Vtbl,
    pub PurchaseEntitlement: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut core::ffi::c_void, u32, *const u8, *mut u32, *mut u32, *mut u8) -> windows_core::HRESULT,
    pub CancelCaptureToken: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const u8) -> windows_core::HRESULT,
    pub SetPidProtection: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *const windows_core::GUID) -> windows_core::HRESULT,
    pub GetPidProtection: unsafe extern "system" fn(*mut core::ffi::c_void, u32, *mut windows_core::GUID) -> windows_core::HRESULT,
    pub SetSyncValue: unsafe extern "system" fn(*mut core::ffi::c_void, u32) -> windows_core::HRESULT,
    pub GetStartCodeProfile: unsafe extern "system" fn(*mut core::ffi::c_void, *mut u32, *mut u8) -> windows_core::HRESULT,
}
pub trait IBDA_WMDRMTuner_Impl: windows_core::IUnknownImpl {
    fn PurchaseEntitlement(&self, uldialogrequest: u32, bstrlanguage: &windows_core::BSTR, ulpurchasetokenlen: u32, pbpurchasetoken: *const u8, puldescramblestatus: *mut u32, pulcapturetokenlen: *mut u32, pbcapturetoken: *mut u8) -> windows_core::Result<()>;
    fn CancelCaptureToken(&self, ulcapturetokenlen: u32, pbcapturetoken: *const u8) -> windows_core::Result<()>;
    fn SetPidProtection(&self, ulpid: u32, uuidkey: *const windows_core::GUID) -> windows_core::Result<()>;
    fn GetPidProtection(&self, pulpid: u32) -> windows_core::Result<windows_core::GUID>;
    fn SetSyncValue(&self, ulsyncvalue: u32) -> windows_core::Result<()>;
    fn GetStartCodeProfile(&self, pulstartcodeprofilelen: *mut u32, pbstartcodeprofile: *mut u8) -> windows_core::Result<()>;
}
impl IBDA_WMDRMTuner_Vtbl {
    pub const fn new<Identity: IBDA_WMDRMTuner_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn PurchaseEntitlement<Identity: IBDA_WMDRMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, uldialogrequest: u32, bstrlanguage: *mut core::ffi::c_void, ulpurchasetokenlen: u32, pbpurchasetoken: *const u8, puldescramblestatus: *mut u32, pulcapturetokenlen: *mut u32, pbcapturetoken: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_WMDRMTuner_Impl::PurchaseEntitlement(this, core::mem::transmute_copy(&uldialogrequest), core::mem::transmute(&bstrlanguage), core::mem::transmute_copy(&ulpurchasetokenlen), core::mem::transmute_copy(&pbpurchasetoken), core::mem::transmute_copy(&puldescramblestatus), core::mem::transmute_copy(&pulcapturetokenlen), core::mem::transmute_copy(&pbcapturetoken)).into()
            }
        }
        unsafe extern "system" fn CancelCaptureToken<Identity: IBDA_WMDRMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulcapturetokenlen: u32, pbcapturetoken: *const u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_WMDRMTuner_Impl::CancelCaptureToken(this, core::mem::transmute_copy(&ulcapturetokenlen), core::mem::transmute_copy(&pbcapturetoken)).into()
            }
        }
        unsafe extern "system" fn SetPidProtection<Identity: IBDA_WMDRMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulpid: u32, uuidkey: *const windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_WMDRMTuner_Impl::SetPidProtection(this, core::mem::transmute_copy(&ulpid), core::mem::transmute_copy(&uuidkey)).into()
            }
        }
        unsafe extern "system" fn GetPidProtection<Identity: IBDA_WMDRMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulpid: u32, uuidkey: *mut windows_core::GUID) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                match IBDA_WMDRMTuner_Impl::GetPidProtection(this, core::mem::transmute_copy(&pulpid)) {
                    Ok(ok__) => {
                        uuidkey.write(core::mem::transmute(ok__));
                        windows_core::HRESULT(0)
                    }
                    Err(err) => err.into(),
                }
            }
        }
        unsafe extern "system" fn SetSyncValue<Identity: IBDA_WMDRMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ulsyncvalue: u32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_WMDRMTuner_Impl::SetSyncValue(this, core::mem::transmute_copy(&ulsyncvalue)).into()
            }
        }
        unsafe extern "system" fn GetStartCodeProfile<Identity: IBDA_WMDRMTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pulstartcodeprofilelen: *mut u32, pbstartcodeprofile: *mut u8) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBDA_WMDRMTuner_Impl::GetStartCodeProfile(this, core::mem::transmute_copy(&pulstartcodeprofilelen), core::mem::transmute_copy(&pbstartcodeprofile)).into()
            }
        }
        Self {
            base__: windows_core::IUnknown_Vtbl::new::<Identity, OFFSET>(),
            PurchaseEntitlement: PurchaseEntitlement::<Identity, OFFSET>,
            CancelCaptureToken: CancelCaptureToken::<Identity, OFFSET>,
            SetPidProtection: SetPidProtection::<Identity, OFFSET>,
            GetPidProtection: GetPidProtection::<Identity, OFFSET>,
            SetSyncValue: SetSyncValue::<Identity, OFFSET>,
            GetStartCodeProfile: GetStartCodeProfile::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBDA_WMDRMTuner as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBDA_WMDRMTuner {}
windows_core::imp::define_interface!(IBPCSatelliteTuner, IBPCSatelliteTuner_Vtbl, 0x211a8765_03ac_11d1_8d13_00aa00bd8339);
impl core::ops::Deref for IBPCSatelliteTuner {
    type Target = IAMTuner;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
windows_core::imp::interface_hierarchy!(IBPCSatelliteTuner, windows_core::IUnknown, IAMTuner);
impl IBPCSatelliteTuner {
    pub unsafe fn get_DefaultSubChannelTypes(&self, pldefaultvideotype: *mut i32, pldefaultaudiotype: *mut i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).get_DefaultSubChannelTypes)(windows_core::Interface::as_raw(self), pldefaultvideotype as _, pldefaultaudiotype as _).ok() }
    }
    pub unsafe fn put_DefaultSubChannelTypes(&self, ldefaultvideotype: i32, ldefaultaudiotype: i32) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).put_DefaultSubChannelTypes)(windows_core::Interface::as_raw(self), ldefaultvideotype, ldefaultaudiotype).ok() }
    }
    pub unsafe fn IsTapingPermitted(&self) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).IsTapingPermitted)(windows_core::Interface::as_raw(self)).ok() }
    }
}
#[repr(C)]
pub struct IBPCSatelliteTuner_Vtbl {
    pub base__: IAMTuner_Vtbl,
    pub get_DefaultSubChannelTypes: unsafe extern "system" fn(*mut core::ffi::c_void, *mut i32, *mut i32) -> windows_core::HRESULT,
    pub put_DefaultSubChannelTypes: unsafe extern "system" fn(*mut core::ffi::c_void, i32, i32) -> windows_core::HRESULT,
    pub IsTapingPermitted: unsafe extern "system" fn(*mut core::ffi::c_void) -> windows_core::HRESULT,
}
pub trait IBPCSatelliteTuner_Impl: IAMTuner_Impl {
    fn get_DefaultSubChannelTypes(&self, pldefaultvideotype: *mut i32, pldefaultaudiotype: *mut i32) -> windows_core::Result<()>;
    fn put_DefaultSubChannelTypes(&self, ldefaultvideotype: i32, ldefaultaudiotype: i32) -> windows_core::Result<()>;
    fn IsTapingPermitted(&self) -> windows_core::Result<()>;
}
impl IBPCSatelliteTuner_Vtbl {
    pub const fn new<Identity: IBPCSatelliteTuner_Impl, const OFFSET: isize>() -> Self {
        unsafe extern "system" fn get_DefaultSubChannelTypes<Identity: IBPCSatelliteTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, pldefaultvideotype: *mut i32, pldefaultaudiotype: *mut i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBPCSatelliteTuner_Impl::get_DefaultSubChannelTypes(this, core::mem::transmute_copy(&pldefaultvideotype), core::mem::transmute_copy(&pldefaultaudiotype)).into()
            }
        }
        unsafe extern "system" fn put_DefaultSubChannelTypes<Identity: IBPCSatelliteTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void, ldefaultvideotype: i32, ldefaultaudiotype: i32) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBPCSatelliteTuner_Impl::put_DefaultSubChannelTypes(this, core::mem::transmute_copy(&ldefaultvideotype), core::mem::transmute_copy(&ldefaultaudiotype)).into()
            }
        }
        unsafe extern "system" fn IsTapingPermitted<Identity: IBPCSatelliteTuner_Impl, const OFFSET: isize>(this: *mut core::ffi::c_void) -> windows_core::HRESULT {
            unsafe {
                let this: &Identity = &*((this as *const *const ()).offset(OFFSET) as *const Identity);
                IBPCSatelliteTuner_Impl::IsTapingPermitted(this).into()
            }
        }
        Self {
            base__: IAMTuner_Vtbl::new::<Identity, OFFSET>(),
            get_DefaultSubChannelTypes: get_DefaultSubChannelTypes::<Identity, OFFSET>,
            put_DefaultSubChannelTypes: put_DefaultSubChannelTypes::<Identity, OFFSET>,
            IsTapingPermitted: IsTapingPermitted::<Identity, OFFSET>,
        }
    }
    pub fn matches(iid: &windows_core::GUID) -> bool {
        iid == &<IBPCSatelliteTuner as windows_core::Interface>::IID || iid == &<IAMTuner as windows_core::Interface>::IID
    }
}
impl windows_core::RuntimeName for IBPCSatelliteTuner {}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::define_interface!(IBaseFilter, IBaseFilter_Vtbl, 0x56a86895_0ad4_11ce_b03a_0020af0ba770);
#[cfg(feature = "Win32_System_Com")]
impl core::ops::Deref for IBaseFilter {
    type Target = IMediaFilter;
    fn deref(&self) -> &Self::Target {
        unsafe { core::mem::transmute(self) }
    }
}
#[cfg(feature = "Win32_System_Com")]
windows_core::imp::interface_hierarchy!(IBaseFilter, windows_core::IUnknown, super::super::System::Com::IPersist, IMediaFilter);
#[cfg(feature = "Win32_System_Com")]
impl IBaseFilter {
    pub unsafe fn EnumPins(&self) -> windows_core::Result<IEnumPins> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).EnumPins)(windows_core::Interface::as_raw(self), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn FindPin<P0>(&self, id: P0) -> windows_core::Result<IPin>
    where
        P0: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).FindPin)(windows_core::Interface::as_raw(self), id.param().abi(), &mut result__).and_then(|| windows_core::Type::from_abi(result__))
        }
    }
    pub unsafe fn QueryFilterInfo(&self, pinfo: *mut FILTER_INFO) -> windows_core::Result<()> {
        unsafe { (windows_core::Interface::vtable(self).QueryFilterInfo)(windows_core::Interface::as_raw(self), core::mem::transmute(pinfo)).ok() }
    }
    pub unsafe fn JoinFilterGraph<P0, P1>(&self, pgraph: P0, pname: P1) -> windows_core::Result<()>
    where
        P0: windows_core::Param<IFilterGraph>,
        P1: windows_core::Param<windows_core::PCWSTR>,
    {
        unsafe { (windows_core::Interface::vtable(self).JoinFilterGraph)(windows_core::Interface::as_raw(self), pgraph.param().abi(), pname.param().abi()).ok() }
    }
    pub unsafe fn QueryVendorInfo(&self) -> windows_core::Result<windows_core::PWSTR> {
        unsafe {
            let mut result__ = core::mem::zeroed();
            (windows_core::Interface::vtable(self).QueryVendorInfo)(windows_core::Interface::as_raw(self), &mut result__).map(|| result__)
        }
    }
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
pub struct IBaseFilter_Vtbl {
    pub base__: IMediaFilter_Vtbl,
    pub EnumPins: unsafe extern "system" fn(*mut core::ffi::c_void, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub FindPin: unsafe extern "system" fn(*mut core::ffi::c_void, windows_core::PCWSTR, *mut *mut core::ffi::c_void) -> windows_core::HRESULT,
    pub QueryFilterInfo: unsafe extern "system" fn(*mut core::ffi::c_void, *mut FILTER_INFO) -> windows_core::HRESULT,
    pub JoinFilterGraph: unsafe extern "system" fn(*mut core::ffi::c_void, *mut core::ffi::c_void, windows_core::PCWSTR) -> windows_core::HRESULT,
    pub QueryVendorInfo: 