```toml
[advisory]
id = "RUSTSEC-2020-0114"
package = "va-ts"
aliases = ["CVE-2020-36220", "GHSA-3hj2-hh36-hv9v"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2020-12-22"
url = "https://github.com/video-audio/va-ts/issues/4"
categories = ["memory-corruption", "thread-safety"]

[versions]
patched = [">= 0.0.4"]
```

# `Demuxer` can carry non-Send types across thread boundaries

In the affected versions of this crate, `Demuxer<T>` unconditionally implemented `Send` with no trait bounds on `T`.

This allows sending a non-Send type `T` across thread boundaries, which can cause undefined behavior like unlocking a mutex from a thread that didn't lock the mutex, or memory corruption from data race.

The flaw was corrected in commit 0562cbf by adding a `T: Send` bound to the `Send` impl for `Demuxer<T>`.
