```toml
[advisory]
id = "RUSTSEC-2021-0046"
package = "telemetry"
aliases = ["CVE-2021-29937", "GHSA-hpcx-3pw8-g3j2"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-02-17"
url = "https://github.com/Yoric/telemetry.rs/issues/45"
categories = ["memory-corruption"]
keywords = ["memory-safety"]

[versions]
patched = []
```

# misc::vec_with_size() can drop uninitialized memory if clone panics

`misc::vec_with_size` creates a vector of the provided `size` and immediately
calls `vec.set_len(size)` on it, initially filling it with uninitialized memory.
It then inserts elements using `vec[i] = value.clone()`.

If the `value.clone()` call panics, uninitialized items in the vector will be
dropped leading to undefined behavior.
