```toml
[advisory]
id = "RUSTSEC-2020-0131"
package = "rcu_cell"
date = "2020-11-14"
url = "https://github.com/Xudong-Huang/rcu_cell/issues/3"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36451", "GHSA-686h-j8r8-wmfm"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = []
```

# Send/Sync bound needed on T  for Send/Sync impl of RcuCell<T>

Affected versions of this crate unconditionally implement Send/Sync for `RcuCell<T>`.
This allows users to send `T: !Send` to other threads (while `T` enclosed within `RcuCell<T>`), and allows users to concurrently access `T: !Sync` by using the APIs of `RcuCell<T>` that provide access to `&T`.

This can result in memory corruption caused by data races.
