```toml
[advisory]
id = "RUSTSEC-2022-0074"
package = "prettytable-rs"
date = "2022-12-02"
url = "https://github.com/phsym/prettytable-rs/issues/145"
informational = "unsound"
keywords = ["tab", "table", "format", "pretty", "print"]
aliases = ["GHSA-gfgm-chr3-x6px"]

[versions]
patched = [">= 0.10.0"]
```

# Force cast a &Vec<T> to &[T]

In function `Table::as_ref`, a reference of vector is force cast to slice. There are multiple problems here:
1. To guarantee the size is correct, we have to first do `Vec::shrink_to_fit`. The function requires a mutable reference, so we have to force cast from immutable to mutable, which is UB.
2. Even if (1) is sound, `&Vec<T>` and `&[T]` still might not have the same layout. Treating them equally may lead to UB.
