```toml
[advisory]
id = "RUSTSEC-2024-0356"
package = "matrix-sdk-crypto"
date = "2024-07-18"
url = "https://github.com/matrix-org/matrix-rust-sdk/security/advisories/GHSA-4qg4-cvh2-crgg"
categories = ["crypto-failure"]
aliases = ["CVE-2024-40648", "GHSA-4qg4-cvh2-crgg"]

[affected]
functions = { "matrix_sdk_crypto::UserIdentity::is_verified" = ["< 0.7.2"] }

[versions]
patched = [">= 0.7.2"]

```
# `UserIdentity::is_verified` not checking verification status of own user identity while performing the check 

The `UserIdentity::is_verified()` method in the matrix-sdk-crypto crate before
version 0.7.2 doesn't take into account the verification status of the user's
own identity while performing the check and may as a result return a value
contrary to what is implied by its name and documentation.

## Impact

If the method is used to decide whether to perform sensitive operations towards
a user identity, a malicious homeserver could manipulate the outcome in order to
make the identity appear trusted. This is not a typical usage of the method,
which lowers the impact. The method itself is not used inside the
matrix-sdk-crypto crate.
