```toml
[advisory]
id = "RUSTSEC-2020-0102"
package = "late-static"
aliases = ["CVE-2020-36209", "GHSA-wr55-mf5c-hhwm"]
cvss = "CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:H"
date = "2020-11-10"
url = "https://github.com/Richard-W/late-static/issues/1"
categories = ["memory-corruption", "thread-safety"]

[versions]
patched = [">= 0.4.0"]
```

# LateStatic has incorrect Sync bound

Affected versions of this crate implemented `Sync` for `LateStatic` with `T: Send`, so that it is possible to create a data race to a type `T: Send + !Sync` (e.g. `Cell<T>`).

This can result in a memory corruption or other kinds of undefined behavior.

The flaw was corrected in commit 11f396c by replacing the `T: Send` bound to `T: Sync` bound in the `Sync` impl for `LateStatic<T>`.
