```toml
[advisory]
id = "RUSTSEC-2022-0049"
package = "iana-time-zone"
date = "2022-08-15"
url = "https://github.com/strawlab/iana-time-zone/pull/54"
references = ["https://github.com/strawlab/iana-time-zone/pull/50#discussion_r945353515"]
categories = ["memory-exposure"]
informational = "unsound"
aliases = ["GHSA-3fg9-hcq5-vxrc"]

[affected]
os = ["ios", "macos"]
functions = { "iana_time_zone::get_timezone" = ["> 0.1.42, < 0.1.45"] }

[versions]
patched = [">= 0.1.45"]
unaffected = ["< 0.1.43"]
```

# Use after free in MacOS / iOS implementation

In iana-time-zone v0.1.43 a use-after-free bug in the MacOS / iOS implementation was introduced.

The copied system time zone was released before its name was copied.
If the system time zone was changed between the call of `CFRelease` and `str::to_owned()`,
random memory would be copied.
