```toml
[advisory]
id = "RUSTSEC-2023-0034"
package = "h2"
date = "2023-04-14"
url = "https://github.com/hyperium/hyper/issues/2877"
categories = ["denial-of-service"]
keywords = ["http", "http2", "h2"]
aliases = ["CVE-2023-26964", "GHSA-f8vr-r385-rh5r"]
[versions]
patched = [">= 0.3.17"]
```

# Resource exhaustion vulnerability in h2 may lead to Denial of Service (DoS)

If an attacker is able to flood the network with pairs of `HEADERS`/`RST_STREAM` frames, such that the `h2` application is not able to accept them faster than the bytes are received, the pending accept queue can grow in memory usage. Being able to do this consistently can result in excessive memory use, and eventually trigger Out Of Memory.

This flaw is corrected in [hyperium/h2#668](https://github.com/hyperium/h2/pull/668), which restricts remote reset stream count by default.
