```toml
[advisory]
id = "RUSTSEC-2020-0009"
package = "flatbuffers"
aliases = ["CVE-2020-35864", "GHSA-c9h5-hf8r-m97x"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2020-04-11"
url = "https://github.com/google/flatbuffers/issues/5825"

[affected.functions]
"flatbuffers::read_scalar" = [">= 0.4.0"]
"flatbuffers::read_scalar_at" = [">= 0.4.0"]

[versions]
patched = [">= 2.0.0"]
unaffected = ["< 0.4.0"]
```

# `read_scalar` and `read_scalar_at` allow transmuting values without `unsafe` blocks

The `read_scalar` and `read_scalar_at` functions are unsound
because they allow transmuting values without `unsafe` blocks.

The following example shows how to create a dangling reference:

```
fn main() {
    #[derive(Copy, Clone, PartialEq, Debug)]
    struct S(&'static str);
    impl flatbuffers::EndianScalar for S {
        fn to_little_endian(self) -> Self { self }
        fn from_little_endian(self) -> Self { self }
    }
    println!("{:?}", flatbuffers::read_scalar::<S>(&[1; std::mem::size_of::<S>()]));
}
```
