```toml
[advisory]
id = "RUSTSEC-2024-0001"
package = "ferris-says"
date = "2024-01-13"
url = "https://github.com/rust-lang/ferris-says/pull/21"
informational = "unsound"
aliases = ["GHSA-v363-rrf2-5fmj"]

[versions]
patched = [">= 0.3.1"]
unaffected = ["<= 0.1.2"]
```

# Unsound use of str::from_utf8_unchecked on bytes which are not UTF-8

Affected versions receive a `&[u8]` from the caller through a safe API, and pass
it directly to the unsafe `str::from_utf8_unchecked` function.

The behavior of `ferris_says::say` is undefined if the bytes from the caller
don't happen to be valid UTF-8.

The flaw was corrected in [ferris-says#21] by using the safe `str::from_utf8`
instead, and returning an error on invalid input. However this fix has not yet
been published to crates.io as a patch version for 0.2.

Separately, [ferris-says#32] has introduced a different API for version 0.3
which accepts input as `&str` rather than `&[u8]`, so is unaffected by this bug.

[ferris-says#21]: https://github.com/rust-lang/ferris-says/pull/21
[ferris-says#32]: https://github.com/rust-lang/ferris-says/pull/32
