```toml
[advisory]
id = "RUSTSEC-2024-0344"
package = "curve25519-dalek"
date = "2024-06-18"
categories = ["crypto-failure"]
url = "https://github.com/dalek-cryptography/curve25519-dalek/pull/659"

[versions]
patched = [">= 4.1.3"]
```

# Timing variability in `curve25519-dalek`'s `Scalar29::sub`/`Scalar52::sub`

Timing variability of any kind is problematic when working with  potentially secret values such as
elliptic curve scalars, and such issues can potentially leak private keys and other secrets. Such a
problem was recently discovered in `curve25519-dalek`.

The `Scalar29::sub` (32-bit) and `Scalar52::sub` (64-bit) functions contained usage of a mask value
inside a loop where LLVM saw an opportunity to insert a branch instruction (`jns` on x86) to
conditionally bypass this code section when the mask value is set to zero as can be seen in godbolt:

- 32-bit (see L106): <https://godbolt.org/z/zvaWxzvqv>
- 64-bit (see L48): <https://godbolt.org/z/PczYj7Pda>

A similar problem was recently discovered in the Kyber reference implementation:

<https://groups.google.com/a/list.nist.gov/g/pqc-forum/c/hqbtIGFKIpU/m/cnE3pbueBgAJ>

As discussed on that thread, one portable solution, which is also used in this PR, is to introduce a
volatile read as an optimization barrier, which prevents the compiler from optimizing it away.

The fix can be validated in godbolt here:

- 32-bit: <https://godbolt.org/z/jc9j7eb8E>
- 64-bit: <https://godbolt.org/z/x8d46Yfah>

The problem was discovered and the solution independently verified by 
Alexander Wagner <alexander.wagner@aisec.fraunhofer.de> and Lea Themint <lea.thiemt@tum.de> using
their DATA tool:

<https://github.com/Fraunhofer-AISEC/DATA>
