```toml
[advisory]
id = "RUSTSEC-2020-0037"
package = "crayon"
aliases = ["CVE-2020-35889", "GHSA-m833-jv95-mfjh"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2020-08-31"
informational = "unsound"
url = "https://github.com/shawnscode/crayon/issues/87"

[versions]
patched = []
```

# Misbehaving `HandleLike` implementation can lead to memory safety violation

Unsafe code in `ObjectPool` has time-of-check to time-of-use (TOCTOU) bug that
can eventually lead to a memory safety violation. `ObjectPool` and `HandlePool`
implicitly assumes that `HandleLike` trait methods are pure, i.e., they always
return the same value. However, this assumption is unsound since `HandleLike`
is a safe, public trait that allows a custom implementation.
