```toml
[advisory]
id = "RUSTSEC-2023-0076"
package = "cpython"
date = "2023-11-14"
url = "https://github.com/dgrunwald/rust-cpython/commit/e815555"
references = [
    "https://github.com/dgrunwald/rust-cpython/issues/265",
    "https://github.com/dgrunwald/rust-cpython/issues/294",
]
informational = "unmaintained"

[versions]
patched = []
```

# `cpython` is unmaintained

The `cpython` crate and the underlying `python3-sys` and `python27-sys` crates have been marked as [no longer actively maintained] by the developer.

There are also open issues for unsound code that is currently in these crates:

- [cpython#265]: Using some string functions causes segmentation faults on big-endian architectures. Due to incorrect bitfield manipulations, it is possible to create invalid Python objects that crash the Python interpreter.
- [cpython#294]: Python 3.12 is not supported. Due to ABI changes in Python 3.12, calling some string functions will result in invalid Python objects and / or cause out-of-bounds memory accesses.

## Recommended alternatives

- [`pyo3`] (version 0.19.2 and newer)

The `pyo3` crate is actively maintained. Preliminary support for Python 3.12 was added in version 0.19.2, and version 0.20.0 was released with full support for Python 3.12.

Both versions implement string functions correctly on big-endian architectures. The endianness issue affecting the `cpython` crate was fixed in recent versions of `pyo3`.

[no longer actively maintained]: https://github.com/dgrunwald/rust-cpython/commit/e815555
[cpython#265]: https://github.com/dgrunwald/rust-cpython/issues/265
[cpython#294]: https://github.com/dgrunwald/rust-cpython/issues/294
[`pyo3`]: https://crates.io/crates/pyo3

