```toml
[advisory]
id = "RUSTSEC-2020-0092"
package = "concread"
aliases = ["CVE-2020-35928", "GHSA-4xj5-vv9x-63jp"]
cvss = "CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:N/A:H"
date = "2020-11-13"
url = "https://github.com/kanidm/concread/issues/48"
categories = ["thread-safety"]
informational = "unsound"

[versions]
patched = [">= 0.2.6"]
```

# Send/Sync bound needed on V in `impl Send/Sync for ARCache<K, V>`

Affected versions of this crate unconditionally implemented `Send`/`Sync` traits for `ARCache<K, V>` type.

This allows users to send/access types that do not implement `Send`/`Sync`, which can cause a data race.

The flaw was corrected in the 0.2.6 release by adding bounds `K: Send + Sync` & `V: Send + Sync` to affected `Send`/`Sync` trait implementations.
