```toml
[advisory]
id = "RUSTSEC-2021-0063"
package = "comrak"
date = "2021-05-04"
url = "https://github.com/kivikakk/comrak/releases/tag/0.10.1"
categories = ["format-injection"]
keywords = ["xss"]
aliases = ["CVE-2021-38186", "GHSA-6wj2-g87r-pm62"]

[versions]
patched = [">= 0.10.1"]
```

# XSS in `comrak`

[comrak](https://github.com/kivikakk/comrak) operates by default in a "safe"
mode of operation where unsafe content, such as arbitrary raw HTML or URLs with
non-standard schemes, are not permitted in the output.  This is per the
reference GFM implementation, [cmark-gfm](https://github.com/github/cmark).

Ampersands were not being correctly escaped in link targets, making it possible
to fashion unsafe URLs using schemes like `data:` or `javascript:` by entering
them as HTML entities, e.g. `&#x64&#x61&#x74&#x61&#x3a`.  The intended
behaviour, demonstrated upstream, is that these should be escaped and therefore
harmless, but this behaviour was broken in comrak.

