```toml
[advisory]
id = "RUSTSEC-2020-0148"
package = "cgc"
date = "2020-12-10"
url = "https://github.com/playXE/cgc/issues/5"
categories = ["memory-corruption"]
keywords = ["memory-safety", "aliasing", "concurrency"]
aliases = ["CVE-2020-36466", "CVE-2020-36467", "CVE-2020-36468", "GHSA-f3mq-99jr-ww4r", "GHSA-f9xr-3m55-5q2v", "GHSA-pwhf-7427-9vv2"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H"

[versions]
patched = []
```

# Multiple soundness issues in `Ptr`

Affected versions of this crate have the following issues:

1. `Ptr` implements `Send` and `Sync` for all types, this can lead to data
   races by sending non-thread safe types across threads.

2. `Ptr::get` violates mutable alias rules by returning multiple mutable
   references to the same object.

3. `Ptr::write` uses non-atomic writes to the underlying pointer. This means
   that when used across threads it can lead to data races.
