```toml
[advisory]
id = "RUSTSEC-2020-0130"
package = "bunch"
date = "2020-11-12"
url = "https://github.com/krl/bunch/issues/1"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36450", "GHSA-jwph-qp5h-f9wj"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = []
```

# Bunch<T> unconditionally implements Send/Sync

Affected versions of this crate unconditionally implements `Send`/`Sync` for `Bunch<T>`.
This allows users to insert `T: !Sync` to `Bunch<T>`. It is possible to create a data race to a `T: !Sync` by invoking the `Bunch::get()` API (which returns `&T`) from multiple threads. It is also possible to send `T: !Send` to other threads by inserting `T` inside `Bunch<T>` and sending `Bunch<T>` to another thread, allowing to create a data race by inserting types like `T = Rc<_>`.

Such data races can lead to memory corruption.
