```toml
[advisory]
id = "RUSTSEC-2023-0039"
package = "buffered-reader"
date = "2023-05-16"
url = "https://lists.sequoia-pgp.org/hyperkitty/list/announce@lists.sequoia-pgp.org/thread/SN2E3QRT4DMQ5JNEK6VIN6DJ5SH766DI/"
references = ["https://gitlab.com/sequoia-pgp/sequoia/-/tags/buffered-reader%2Fv1.2.0"]
categories = ["denial-of-service"]
# Attacker-controlled input can result in a panic due to an
# out-of-bounds array index.
keywords = ["panic"]
aliases = ["GHSA-29mf-62xx-28jq"]

[versions]
patched = [">= 1.0.2, < 1.1.0", ">= 1.1.5, < 1.2.0", ">= 1.2.0"]
```

# Out-of-bounds array access leads to panic

Affected versions of the crate have a bug where attacker-controlled
input can result in the use of an out-of-bound array index.  Rust
detects the use of the out-of-bound index and causes the application
to panic.  An attacker may be able to use this to cause a
denial-of-service.  However, it is not possible for an attacker to
read from or write to the application's address space.
