```toml
[advisory]
id = "RUSTSEC-2020-0124"
package = "async-coap"
date = "2020-12-08"
url = "https://github.com/google/rust-async-coap/issues/33"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36444", "GHSA-9j8q-m9x5-9g6j"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = []
```

# ArcGuard's Send and Sync should have bounds on RC

Affected versions of this crate implement Send/Sync for `ArcGuard<RC, T>` with no trait bounds on `RC`. This allows users to send `RC: !Send` to other threads and also allows users to concurrently access `Rc: !Sync` from multiple threads.

This can result in memory corruption from data race or other undefined behavior caused by sending `T: !Send` to other threads (e.g. dropping `MutexGuard<T>` in another thread that didn't lock its mutex).
