```toml
[advisory]
id = "RUSTSEC-2018-0011"
package = "arrayfire"
aliases = ["CVE-2018-20998", "GHSA-69fv-gw6g-8ccg"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
categories = ["memory-corruption"]
date = "2018-12-18"
keywords = ["enum", "repr"]
url = "https://github.com/arrayfire/arrayfire-rust/pull/177"

[affected]
arch = ["x86_64"]
os = ["windows"]

[versions]
patched = [">= 3.6.0"]
unaffected = ["<= 3.5.0"]
```

# Enum repr causing potential memory corruption

The attribute repr() added to enums to be compatible with C-FFI caused
memory corruption on MSVC toolchain.

arrayfire crates <= version 3.5.0 do not have this issue when used with
Rust versions 1.27 or earlier. The issue only started to appear since
Rust version 1.28.

The issue seems to be interlinked with which version of Rust is being used.

The issue was fixed in crate 3.6.0.
