```toml
[advisory]
id = "RUSTSEC-2020-0161"
package = "array-macro"
date = "2020-05-07"
url = "https://gitlab.com/KonradBorowski/array-macro/-/commit/01940637dd8f3bfeeee3faf9639fa9ae52f19f4d"
categories = ["memory-corruption"]
informational = "unsound"
aliases = ["GHSA-83gg-pwxf-jr89"]

[versions]
patched = [">= 1.0.5"]
unaffected = ["< 0.1.2"]
```

# `array!` macro is unsound in presence of traits that implement methods it calls internally

Affected versions of this crate called some methods using auto-ref. The affected code looked like this.

```rust
let mut arr = $crate::__core::mem::MaybeUninit::uninit();
let mut vec = $crate::__ArrayVec::<T>::new(arr.as_mut_ptr() as *mut T);
```

In this case, the problem is that `as_mut_ptr` is a method of `&mut MaybeUninit`, not `MaybeUninit`. This made it possible for traits to hijack the method calls in order to cause unsoundness.

```rust
trait AsMutPtr<T> {
    fn as_mut_ptr(&self) -> *mut T;
}
impl<T> AsMutPtr<T> for std::mem::MaybeUninit<T> {
    fn as_mut_ptr(&self) -> *mut T {
        std::ptr::null_mut()
    }
}
array![0; 1];
```

The flaw was corrected by explicitly referencing variables in macro body in order to avoid auto-ref.
