/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.SCRAMBindRequest;
import com.unboundid.util.Base64;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadLocalSecureRandom;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class SCRAMClientFirstMessage
implements Serializable {
    @NotNull
    private static final String GS2_HEADER_NO_CHANNEL_BINDING = "n,,";
    @NotNull
    private static final String GS2_HEADER_NO_CHANNEL_BINDING_BASE64 = Base64.encode("n,,");
    private static final long serialVersionUID = 7117556259158222514L;
    @NotNull
    private final SCRAMBindRequest bindRequest;
    @NotNull
    private final String clientFirstMessage;
    @NotNull
    private final String clientFirstMessageBare;
    @NotNull
    private final String clientNonce;
    @NotNull
    private final String gs2HeaderBase64;
    @NotNull
    private final String gs2HeaderRaw;

    SCRAMClientFirstMessage(@NotNull SCRAMBindRequest bindRequest) {
        this(bindRequest, null);
    }

    SCRAMClientFirstMessage(@NotNull SCRAMBindRequest bindRequest, @Nullable String clientNonce) {
        this.bindRequest = bindRequest;
        if (clientNonce == null) {
            byte[] clientNonceBytes = new byte[16];
            ThreadLocalSecureRandom.get().nextBytes(clientNonceBytes);
            this.clientNonce = Base64.urlEncode(clientNonceBytes, false);
        } else {
            this.clientNonce = clientNonce;
        }
        this.gs2HeaderRaw = GS2_HEADER_NO_CHANNEL_BINDING;
        this.gs2HeaderBase64 = GS2_HEADER_NO_CHANNEL_BINDING_BASE64;
        this.clientFirstMessageBare = "n=" + bindRequest.getUsername() + ",r=" + this.clientNonce;
        this.clientFirstMessage = this.gs2HeaderRaw + this.clientFirstMessageBare;
    }

    @NotNull
    SCRAMBindRequest getBindRequest() {
        return this.bindRequest;
    }

    @NotNull
    String getGS2HeaderRaw() {
        return this.gs2HeaderRaw;
    }

    @NotNull
    String getGS2HeaderBase64() {
        return this.gs2HeaderBase64;
    }

    @NotNull
    String getClientNonce() {
        return this.clientNonce;
    }

    @NotNull
    String getClientFirstMessage() {
        return this.clientFirstMessage;
    }

    @NotNull
    String getClientFirstMessageBare() {
        return this.clientFirstMessageBare;
    }

    @NotNull
    public String toString() {
        return this.clientFirstMessage;
    }
}

