# sap_firewall Ansible Role

Ansible role for updating firewall port entries based on SAP instance numbers

- **Generic** - use the `generic` option to update the ports directly by providing a list of ports
- **SAP NW** - use the `nw` option to update SAP NW ports
- **SAP HANA** - use the `hana` option to update SAP HANA ports

## Overview

![](/docs/diagrams/workflow_role_sap_firewall.svg)

### Variables

| **Variable**                | **Info**                                                               | **Default** | **Required** |
| :---                        | :---                                                                   | :---        | :---         |
| sap_firewall_type           | 'generic' / 'nw' / 'hana'                                              | 'generic'   | yes          |
| sap_firewall_ports          | List of ports to update when using the option 'generic'                | <none>      | no, only if 'generic'          |
| sap_firewall_instance_nr    | SAP instance number when using options 'hana' / 'nw'                   | <none>      | no, only if 'nw' / 'hana'           |
| sap_firewall_disable_end    | Set this parameter to true to disable firewall at the end of execution | <none>      | no           |

### Input and Execution

- Sample execution:

    ```bash
    ansible-playbook --connection=local --limit localhost -i "localhost," sap-firewall-update.yml -e "@input_file.yml"
    ```

- Sample playbook using `generic` option

    ```yaml
    ---
    - hosts: all
      become: true
      vars:
        sap_firewall_ports:
          - "1128"
          - "1129"
        sap_firewall_type: "generic"
      roles:
        - { role: community.sap_operations.sap_firewall }
    ```

- Sample playbook using `sap_facts` module to get all SAP systems in the host

    ```yaml
    ---
    - hosts: all
      become: true

      tasks:

      - name: Run sap_facts module to gather SAP facts
        community.sap_operations.sap_facts:
            param: "all"
        register: sap_facts_register

      - name: Firewall Update
        vars:
          sap_firewall_type: "{{ item.Type }}"
          sap_firewall_instance_nr: "{{ item.InstanceNumber }}"
        ansible.builtin.include_role:
          name: community.sap_operations.sap_firewall
        loop: "{{ sap_facts_register.sap_facts }}"
    ```
