package converters

func NewStringConverter(langID int) IStringConverter {
	switch langID {
	case 0x1: // 1
		return &StringConverter{
			LangID:    1,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32, 173: 45, 166: 124, 180: 39, 8248: 94, 8764: 126, 163: 35, 165: 89, 63741: 102, 8356: 76,
				192: 65, 193: 65, 194: 65, 196: 65, 258: 65, 260: 65, 262: 67, 268: 67, 199: 67, 270: 68, 272: 68, 200: 69, 201: 69, 202: 69, 203: 69, 282: 69,
				280: 69, 204: 73, 205: 73, 206: 73, 313: 76, 317: 76, 321: 76, 323: 78, 327: 78, 210: 79, 211: 79, 212: 79, 214: 79, 336: 79, 340: 82, 344: 82,
				346: 83, 352: 83, 350: 83, 356: 84, 354: 84, 217: 85, 218: 85, 219: 85, 220: 85, 368: 85, 366: 85, 221: 89, 377: 90, 381: 90, 379: 90, 224: 97,
				225: 97, 226: 97, 228: 97, 259: 97, 261: 97, 263: 99, 269: 99, 231: 99, 271: 100, 273: 100, 232: 101, 233: 101, 234: 101, 235: 101, 283: 101, 281: 101,
				236: 105, 237: 105, 238: 105, 314: 108, 318: 108, 322: 108, 324: 110, 328: 110, 242: 111, 243: 111, 244: 111, 246: 111, 337: 111, 341: 114, 345: 114, 347: 115,
				353: 115, 351: 115, 357: 116, 355: 116, 249: 117, 250: 117, 251: 117, 252: 117, 369: 117, 367: 117, 253: 121, 378: 122, 382: 122, 380: 122, 207: 73, 239: 105,
				255: 121,
			},
		}
	case 0x2: // 2
		return &StringConverter{
			LangID:    2,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  191,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 161, 162, 163, 65535, 165, 65535, 167, 164, 169, 170, 171, 65535, 65535, 65535, 65535,
				176, 177, 178, 179, 65535, 181, 182, 183, 65535, 185, 186, 187, 188, 189, 65535, 191,
				192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
				65535, 209, 210, 211, 212, 213, 214, 338, 216, 217, 218, 219, 220, 376, 65535, 223,
				224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
				65535, 241, 242, 243, 244, 245, 246, 339, 248, 249, 250, 251, 252, 255, 65535, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 161: 161, 162: 162, 163: 163, 165: 165, 167: 167, 164: 168, 169: 169, 170: 170, 171: 171, 176: 176, 177: 177, 178: 178, 179: 179, 181: 181, 182: 182,
				183: 183, 185: 185, 186: 186, 187: 187, 188: 188, 189: 189, 191: 191, 192: 192, 193: 193, 194: 194, 195: 195, 196: 196, 197: 197, 198: 198, 199: 199, 200: 200,
				201: 201, 202: 202, 203: 203, 204: 204, 205: 205, 206: 206, 207: 207, 209: 209, 210: 210, 211: 211, 212: 212, 213: 213, 214: 214, 338: 215, 216: 216, 217: 217,
				218: 218, 219: 219, 220: 220, 376: 221, 223: 223, 224: 224, 225: 225, 226: 226, 227: 227, 228: 228, 229: 229, 230: 230, 231: 231, 232: 232, 233: 233, 234: 234,
				235: 235, 236: 236, 237: 237, 238: 238, 239: 239, 241: 241, 242: 242, 243: 243, 244: 244, 245: 245, 246: 246, 339: 247, 248: 248, 249: 249, 250: 250, 251: 251,
				252: 252, 255: 253, 8216: 96, 8213: 45, 175: 45, 160: 32, 173: 45, 166: 124, 180: 39, 8248: 94, 8764: 126, 63741: 102, 8356: 76, 221: 89, 253: 121, 946: 223,
			},
		}
	case 0x3: // 3
		return &StringConverter{
			LangID:    3,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  252,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 8248, 95,
				8216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 8764, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 192, 194, 200, 202, 203, 206, 207, 180, 96, 94, 168, 126, 217, 219, 8356,
				175, 65535, 65535, 176, 199, 231, 209, 241, 161, 191, 164, 163, 165, 167, 402, 162,
				226, 234, 244, 251, 225, 233, 243, 250, 224, 232, 242, 249, 228, 235, 246, 252,
				197, 238, 216, 198, 229, 237, 248, 230, 196, 236, 214, 220, 201, 239, 223, 212,
				193, 195, 227, 272, 273, 205, 204, 211, 210, 213, 245, 352, 353, 218, 376, 255,
				222, 254, 65535, 65535, 65535, 65535, 8213, 188, 189, 170, 186, 171, 8718, 187, 177, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 8248: 94, 95: 95,
				8216: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 8764: 126, 127: 127,
				65535: 255, 192: 161, 194: 162, 200: 163, 202: 164, 203: 165, 206: 166, 207: 167, 180: 168, 96: 169, 94: 170, 168: 171, 126: 172, 217: 173, 219: 174, 8356: 175,
				175: 176, 176: 179, 199: 180, 231: 181, 209: 182, 241: 183, 161: 184, 191: 185, 164: 186, 163: 187, 165: 188, 167: 189, 402: 190, 162: 191, 226: 192, 234: 193,
				244: 194, 251: 195, 225: 196, 233: 197, 243: 198, 250: 199, 224: 200, 232: 201, 242: 202, 249: 203, 228: 204, 235: 205, 246: 206, 252: 207, 197: 208, 238: 209,
				216: 210, 198: 211, 229: 212, 237: 213, 248: 214, 230: 215, 196: 216, 236: 217, 214: 218, 220: 219, 201: 220, 239: 221, 223: 222, 212: 223, 193: 224, 195: 225,
				227: 226, 272: 227, 273: 228, 205: 229, 204: 230, 211: 231, 210: 232, 213: 233, 245: 234, 352: 235, 353: 236, 218: 237, 376: 238, 255: 239, 222: 240, 254: 241,
				8213: 246, 188: 247, 189: 248, 170: 249, 186: 250, 171: 251, 8718: 252, 187: 253, 177: 254, 160: 32, 173: 45, 166: 124, 221: 89, 253: 121, 946: 222, 63741: 190,
			},
		}
	case 0x4: // 4
		return &StringConverter{
			LangID:    4,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 239, 238, 236, 196, 197,
				201, 230, 198, 244, 246, 242, 251, 249, 255, 214, 220, 162, 163, 165, 8359, 402,
				225, 237, 243, 250, 241, 209, 170, 186, 191, 8976, 172, 189, 188, 161, 171, 187,
				9617, 9618, 9619, 9474, 9508, 9569, 9570, 9558, 9557, 9571, 9553, 9559, 9565, 9564, 9563, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 9566, 9567, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 9575,
				9576, 9572, 9573, 9561, 9560, 9554, 9555, 9579, 9578, 9496, 9484, 9608, 9604, 9612, 9616, 9600,
				945, 946, 915, 960, 931, 963, 956, 964, 934, 920, 937, 948, 8734, 966, 949, 8745,
				8801, 177, 8805, 8804, 8992, 8993, 247, 8776, 176, 8729, 183, 8730, 8319, 178, 8718, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 252: 129, 233: 130, 226: 131, 228: 132, 224: 133, 229: 134, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 236: 141, 196: 142, 197: 143,
				201: 144, 230: 145, 198: 146, 244: 147, 246: 148, 242: 149, 251: 150, 249: 151, 255: 152, 214: 153, 220: 154, 162: 155, 163: 156, 165: 157, 8359: 158, 402: 159,
				225: 160, 237: 161, 243: 162, 250: 163, 241: 164, 209: 165, 170: 166, 186: 167, 191: 168, 8976: 169, 172: 170, 189: 171, 188: 172, 161: 173, 171: 174, 187: 175,
				9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 9569: 181, 9570: 182, 9558: 183, 9557: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 9564: 189, 9563: 190, 9488: 191,
				9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 9566: 198, 9567: 199, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 9575: 207,
				9576: 208, 9572: 209, 9573: 210, 9561: 211, 9560: 212, 9554: 213, 9555: 214, 9579: 215, 9578: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 9612: 221, 9616: 222, 9600: 223,
				945: 224, 946: 225, 915: 226, 960: 227, 931: 228, 963: 229, 956: 230, 964: 231, 934: 232, 920: 233, 937: 234, 948: 235, 8734: 236, 966: 237, 949: 238, 8745: 239,
				8801: 240, 177: 241, 8805: 242, 8804: 243, 8992: 244, 8993: 245, 247: 246, 8776: 247, 176: 248, 8729: 249, 183: 250, 8730: 251, 8319: 252, 178: 253, 8718: 254, 160: 255,
				8216: 96, 181: 230, 8213: 45, 173: 45, 166: 124, 180: 39, 8248: 94, 8764: 126, 8356: 76, 192: 65, 193: 65, 194: 65, 195: 65, 200: 69, 202: 69, 203: 69,
				204: 73, 205: 73, 206: 73, 207: 73, 210: 79, 211: 79, 212: 79, 213: 79, 217: 85, 218: 85, 219: 85, 221: 89, 227: 97, 245: 111, 253: 121, 223: 225,
				63741: 159, 63742: 250,
			},
		}
	case 0x5: // 5
		return &StringConverter{
			LangID:    5,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 162, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 33, 36, 42, 41, 59, 172,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 166, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				94, 163, 165, 183, 169, 167, 182, 188, 189, 190, 91, 93, 175, 168, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 172: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 164: 159, 181: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 94: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 91: 186, 93: 187, 175: 188, 168: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255, 8216: 121, 8248: 176,
				8764: 161, 376: 232,
			},
		}
	case 0x6: // 6
		return &StringConverter{
			LangID:    6,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 91, 46, 60, 40, 43, 33,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 93, 36, 42, 41, 59, 94,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 166, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 172, 124, 175, 168, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 91: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 93: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 164: 159, 181: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 168: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255, 8216: 121, 8248: 95,
				8764: 161, 376: 232,
			},
		}
	case 0x7: // 7
		return &StringConverter{
			LangID:    7,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 162, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 33, 36, 42, 41, 59, 172,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 166, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 8364,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				94, 163, 165, 183, 169, 167, 182, 188, 189, 190, 91, 93, 175, 168, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 172: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 8364: 159, 181: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 94: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 91: 186, 93: 187, 175: 188, 168: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255, 8216: 121, 8248: 176,
				8764: 161, 376: 232,
			},
		}
	case 0x8: // 8
		return &StringConverter{
			LangID:    8,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 36, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 33, 163, 42, 41, 59, 172,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 166, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				181, 175, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 91, 165, 183, 169, 167, 182, 188, 189, 190, 94, 93, 126, 168, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 36: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 33: 90, 163: 91, 42: 92, 41: 93, 59: 94, 172: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 164: 159, 181: 160, 175: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 91: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 94: 186, 93: 187, 126: 188, 168: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255,
			},
		}
	case 0x9: // 9
		return &StringConverter{
			LangID:    9,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 36, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 33, 163, 42, 41, 59, 172,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 166, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 8364,
				181, 175, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 91, 165, 183, 169, 167, 182, 188, 189, 190, 94, 93, 126, 168, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 36: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 33: 90, 163: 91, 42: 92, 41: 93, 59: 94, 172: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 8364: 159, 181: 160, 175: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 91: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 94: 186, 93: 187, 126: 188, 168: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255,
			},
		}
	case 0xa: // 10
		return &StringConverter{
			LangID:    10,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 239, 238, 236, 196, 197,
				201, 230, 198, 244, 246, 242, 251, 249, 255, 214, 220, 248, 163, 216, 215, 402,
				225, 237, 243, 250, 241, 209, 170, 186, 191, 174, 172, 189, 188, 161, 171, 187,
				9617, 9618, 9619, 9474, 9508, 193, 194, 192, 169, 9571, 9553, 9559, 9565, 162, 165, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 227, 195, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 164,
				240, 208, 202, 203, 200, 305, 205, 206, 207, 9496, 9484, 9608, 9604, 166, 204, 9600,
				211, 223, 212, 210, 245, 213, 181, 254, 222, 218, 219, 217, 253, 221, 175, 180,
				173, 177, 8215, 190, 182, 167, 247, 184, 176, 168, 183, 185, 179, 178, 9632, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 252: 129, 233: 130, 226: 131, 228: 132, 224: 133, 229: 134, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 236: 141, 196: 142, 197: 143,
				201: 144, 230: 145, 198: 146, 244: 147, 246: 148, 242: 149, 251: 150, 249: 151, 255: 152, 214: 153, 220: 154, 248: 155, 163: 156, 216: 157, 215: 158, 402: 159,
				225: 160, 237: 161, 243: 162, 250: 163, 241: 164, 209: 165, 170: 166, 186: 167, 191: 168, 174: 169, 172: 170, 189: 171, 188: 172, 161: 173, 171: 174, 187: 175,
				9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 193: 181, 194: 182, 192: 183, 169: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 162: 189, 165: 190, 9488: 191,
				9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 227: 198, 195: 199, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 164: 207,
				240: 208, 208: 209, 202: 210, 203: 211, 200: 212, 305: 213, 205: 214, 206: 215, 207: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 166: 221, 204: 222, 9600: 223,
				211: 224, 223: 225, 212: 226, 210: 227, 245: 228, 213: 229, 181: 230, 254: 231, 222: 232, 218: 233, 219: 234, 217: 235, 253: 236, 221: 237, 175: 238, 180: 239,
				173: 240, 177: 241, 8215: 242, 190: 243, 182: 244, 167: 245, 247: 246, 184: 247, 176: 248, 168: 249, 183: 250, 185: 251, 179: 252, 178: 253, 9632: 254, 160: 255,
				8216: 96, 8213: 45, 8248: 94, 8718: 254, 8764: 126, 8356: 76, 63741: 159,
			},
		}
	case 0xb: // 11
		return &StringConverter{
			LangID:    11,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				167, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 220, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 252, 223, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				167, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 220, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 252, 223, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 35: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				167: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 196: 219, 214: 220, 220: 221, 94: 222, 95: 223,
				96: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 228: 251, 246: 252, 252: 253, 223: 254, 127: 255,
				64: 64, 91: 91, 92: 92, 93: 93, 123: 123, 124: 124, 125: 125, 126: 126, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32, 173: 45, 166: 124,
				180: 39, 8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 200: 69, 201: 69, 202: 69, 204: 73, 205: 73, 206: 73,
				210: 79, 211: 79, 212: 79, 217: 85, 218: 85, 219: 85, 224: 97, 225: 97, 226: 97, 231: 99, 232: 101, 233: 101, 234: 101, 236: 105, 237: 105, 238: 105,
				242: 111, 243: 111, 244: 111, 249: 117, 250: 117, 251: 117, 946: 126,
			},
		}
	case 0xc: // 12
		return &StringConverter{
			LangID:    12,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 163, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				224, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 176, 231, 167, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 233, 249, 232, 168, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 163, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				224, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 176, 231, 167, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 233, 249, 232, 168, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 163: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				224: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 176: 219, 231: 220, 167: 221, 94: 222, 95: 223,
				96: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 233: 251, 249: 252, 232: 253, 168: 254, 127: 255,
				35: 35, 64: 64, 91: 91, 92: 92, 93: 93, 123: 123, 124: 124, 125: 125, 126: 126, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32, 173: 45,
				166: 124, 180: 39, 8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 200: 69, 201: 69, 202: 69, 204: 73, 205: 73,
				206: 73, 210: 79, 211: 79, 212: 79, 217: 85, 218: 85, 219: 85, 225: 97, 226: 97, 234: 101, 236: 105, 237: 105, 238: 105, 242: 111, 243: 111, 244: 111,
				250: 117, 251: 117,
			},
		}
	case 0xd: // 13
		return &StringConverter{
			LangID:    13,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				201, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 197, 220, 95,
				233, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 229, 252, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				201, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 197, 220, 95,
				233, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 229, 252, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 35: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				201: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 196: 219, 214: 220, 197: 221, 220: 222, 95: 223,
				233: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 228: 251, 246: 252, 229: 253, 252: 254, 127: 255,
				64: 64, 91: 91, 92: 92, 93: 93, 94: 94, 96: 96, 123: 123, 124: 124, 125: 125, 126: 126, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32,
				173: 45, 166: 124, 180: 39, 8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 202: 69, 204: 73, 205: 73, 206: 73,
				210: 79, 211: 79, 212: 79, 217: 85, 218: 85, 219: 85, 224: 97, 225: 98, 226: 99, 231: 99, 234: 101, 236: 105, 237: 105, 238: 105, 242: 111, 243: 111,
				244: 111, 249: 117, 250: 117, 251: 117,
			},
		}
	case 0xe: // 14
		return &StringConverter{
			LangID:    14,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 163, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				167, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 161, 209, 191, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 176, 241, 231, 126, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 163, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				167, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 161, 209, 191, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 176, 241, 231, 126, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 163: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				167: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 161: 219, 209: 220, 191: 221, 94: 222, 95: 223,
				96: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 176: 251, 241: 252, 231: 253, 126: 254, 127: 255,
				35: 35, 64: 64, 91: 91, 92: 92, 93: 93, 123: 123, 124: 124, 125: 125, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32, 173: 45, 166: 124, 180: 39,
				8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 200: 69, 201: 69, 202: 69, 204: 73, 205: 73, 206: 73, 210: 79,
				211: 79, 212: 79, 217: 85, 218: 85, 219: 85, 224: 97, 225: 97, 226: 97, 232: 101, 233: 101, 234: 101, 236: 105, 237: 105, 238: 105, 242: 111, 243: 111,
				244: 111, 249: 117, 250: 117, 251: 117,
			},
		}
	case 0xf: // 15
		return &StringConverter{
			LangID:    15,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 197, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 229, 126, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 197, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 229, 126, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 35: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				64: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 196: 219, 214: 220, 197: 221, 94: 222, 95: 223,
				96: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 228: 251, 246: 252, 229: 253, 126: 254, 127: 255,
				91: 91, 92: 92, 93: 93, 123: 123, 124: 124, 125: 125, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32, 173: 45, 166: 124, 180: 39, 8248: 94,
				8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 195: 65, 198: 91, 199: 67, 208: 68, 200: 69, 201: 69, 202: 69, 203: 69, 204: 73,
				205: 73, 206: 73, 207: 73, 209: 78, 210: 79, 211: 79, 212: 79, 213: 79, 338: 92, 216: 92, 222: 84, 217: 85, 218: 85, 219: 85, 220: 89, 221: 89,
				376: 89, 224: 97, 225: 97, 226: 97, 227: 97, 230: 123, 231: 99, 240: 100, 232: 101, 233: 101, 234: 101, 235: 101, 236: 105, 237: 105, 238: 105, 239: 105,
				241: 110, 242: 111, 243: 111, 244: 111, 245: 111, 339: 124, 248: 124, 254: 116, 249: 117, 250: 117, 251: 117, 252: 121, 253: 121, 255: 121, 223: 115,
			},
		}
	case 0x10: // 16
		return &StringConverter{
			LangID:    16,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				196, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 198, 216, 197, 220, 95,
				228, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 230, 248, 229, 252, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				196, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 198, 216, 197, 220, 95,
				228, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 230, 248, 229, 252, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 35: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				196: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 198: 219, 216: 220, 197: 221, 220: 222, 95: 223,
				228: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 230: 251, 248: 252, 229: 253, 252: 254, 127: 255,
				64: 64, 91: 91, 92: 92, 93: 93, 94: 94, 96: 96, 123: 123, 124: 124, 125: 125, 126: 126, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32,
				173: 45, 180: 39, 8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 202: 69, 204: 73, 205: 73, 206: 73, 210: 79,
				211: 79, 212: 79, 217: 85, 218: 85, 219: 85, 224: 97, 225: 98, 226: 99, 231: 99, 234: 101, 236: 105, 237: 105, 238: 105, 242: 111, 243: 111, 244: 111,
				249: 117, 250: 117, 251: 117,
			},
		}
	case 0x11: // 17
		return &StringConverter{
			LangID:    17,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 163, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				167, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 176, 231, 233, 94, 95,
				249, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 224, 242, 232, 236, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 163, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				167, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 176, 231, 233, 94, 95,
				249, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 224, 242, 232, 236, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 163: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				167: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 176: 219, 231: 220, 233: 221, 94: 222, 95: 223,
				249: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 224: 251, 242: 252, 232: 253, 236: 254, 127: 255,
				35: 35, 64: 64, 91: 91, 92: 92, 93: 93, 96: 96, 123: 123, 124: 124, 125: 125, 126: 126, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32,
				173: 45, 166: 124, 180: 39, 8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 200: 69, 201: 69, 202: 69, 204: 73,
				205: 73, 206: 73, 210: 79, 211: 79, 212: 79, 217: 85, 218: 85, 219: 85, 225: 97, 226: 97, 234: 101, 237: 105, 238: 105, 243: 111, 244: 111, 250: 117,
				251: 117,
			},
		}
	case 0x12: // 18
		return &StringConverter{
			LangID:    18,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 163, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				190, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 307, 189, 124, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 168, 63741, 188, 180, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 163, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				190, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 307, 189, 124, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 168, 63741, 188, 180, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 163: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				190: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 307: 219, 189: 220, 124: 221, 94: 222, 95: 223,
				96: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 168: 251, 63741: 252, 188: 253, 180: 254, 127: 255,
				35: 35, 64: 64, 91: 91, 92: 92, 93: 93, 123: 123, 125: 125, 126: 126, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32, 173: 45, 166: 93,
				8248: 94, 8764: 126, 165: 89, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 200: 69, 201: 69, 202: 69, 204: 73, 205: 73, 206: 73, 210: 79, 211: 79,
				212: 79, 217: 85, 218: 85, 219: 85, 221: 89, 224: 97, 225: 97, 226: 97, 231: 99, 232: 101, 233: 101, 234: 101, 236: 105, 237: 105, 238: 105, 242: 111,
				243: 111, 244: 111, 249: 117, 250: 117, 251: 117, 253: 121,
			},
		}
	case 0x13: // 19
		return &StringConverter{
			LangID:    19,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 249, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				224, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 233, 231, 234, 238, 232,
				244, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 252, 251, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 249, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				224, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 233, 231, 234, 238, 232,
				244, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 252, 251, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 249: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				224: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 233: 219, 231: 220, 234: 221, 238: 222, 232: 223,
				244: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 228: 251, 246: 252, 252: 253, 251: 254, 127: 255,
				35: 35, 64: 64, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95, 96: 96, 123: 123, 124: 124, 125: 125, 126: 126, 161: 33, 171: 60, 187: 62, 8216: 96,
				8213: 45, 160: 32, 173: 45, 166: 124, 180: 39, 8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 200: 69, 201: 69,
				202: 69, 204: 73, 205: 73, 206: 73, 210: 79, 211: 79, 212: 79, 217: 85, 218: 85, 219: 85, 221: 89, 225: 97, 226: 97, 236: 105, 237: 105, 242: 111,
				243: 111, 250: 117, 253: 121,
			},
		}
	case 0x14: // 20
		return &StringConverter{
			LangID:    20,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				381, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 352, 272, 262, 268, 95,
				382, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 353, 273, 263, 269, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				381, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 352, 272, 262, 268, 95,
				382, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 353, 273, 263, 269, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 35: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				381: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 352: 219, 272: 220, 262: 221, 268: 222, 95: 223,
				382: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 353: 251, 273: 252, 263: 253, 269: 254, 127: 255,
			},
		}
	case 0x15: // 21
		return &StringConverter{
			LangID:    21,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 197, 220, 95,
				233, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 229, 252, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 197, 220, 95,
				233, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 229, 252, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 35: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				64: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 196: 219, 214: 220, 197: 221, 220: 222, 95: 223,
				233: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 228: 251, 246: 252, 229: 253, 252: 254, 127: 255,
				91: 91, 92: 92, 93: 93, 94: 94, 96: 96, 123: 123, 124: 124, 125: 125, 126: 126, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32, 173: 45,
				166: 124, 180: 39, 8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 201: 69, 202: 69, 204: 73, 205: 73, 206: 73,
				210: 79, 211: 79, 212: 79, 217: 85, 218: 85, 219: 85, 224: 97, 225: 98, 226: 99, 231: 99, 234: 101, 236: 105, 237: 105, 238: 105, 242: 111, 243: 111,
				244: 111, 249: 117, 250: 117, 251: 117,
			},
		}
	case 0x16: // 22
		return &StringConverter{
			LangID:    22,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 305, 34, 35, 36, 37, 287, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				304, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 350, 214, 199, 220, 95,
				286, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 351, 246, 231, 252, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 305, 34, 35, 36, 37, 287, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				304, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 350, 214, 199, 220, 95,
				286, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 351, 246, 231, 252, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 305: 161, 34: 162, 35: 163, 36: 164, 37: 165, 287: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				304: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 350: 219, 214: 220, 199: 221, 220: 222, 95: 223,
				286: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 351: 251, 246: 252, 231: 253, 252: 254, 127: 255,
				33: 33, 38: 38, 64: 64, 91: 91, 92: 92, 93: 93, 94: 94, 96: 96, 123: 123, 124: 124, 125: 125, 126: 126, 171: 60, 187: 62, 8216: 96, 8213: 45,
				160: 32, 173: 45, 166: 124, 180: 39, 8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 201: 69, 202: 69, 63738: 73, 204: 73,
				205: 73, 206: 73, 210: 79, 211: 79, 212: 79, 217: 85, 218: 85, 219: 85, 224: 97, 225: 98, 226: 99, 234: 101, 236: 105, 237: 105, 238: 105, 63736: 105,
				242: 111, 243: 111, 244: 111, 249: 117, 250: 117, 251: 117,
			},
		}
	case 0x17: // 23
		return &StringConverter{
			LangID:    23,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502, 1503,
				1504, 1505, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 123, 124, 125, 126, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502, 1503,
				1504, 1505, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 123, 124, 125, 126, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 35: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				64: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 91: 219, 92: 220, 93: 221, 94: 222, 95: 223,
				1488: 224, 1489: 225, 1490: 226, 1491: 227, 1492: 228, 1493: 229, 1494: 230, 1495: 231, 1496: 232, 1497: 233, 1498: 234, 1499: 235, 1500: 236, 1501: 237, 1502: 238, 1503: 239,
				1504: 240, 1505: 241, 1506: 242, 1507: 243, 1508: 244, 1509: 245, 1510: 246, 1511: 247, 1512: 248, 1513: 249, 1514: 250, 123: 251, 124: 252, 125: 253, 126: 254, 127: 255,
				97: 65, 98: 66, 99: 67, 100: 68, 101: 69, 102: 70, 103: 71, 104: 72, 105: 73, 106: 74, 107: 75, 108: 76, 109: 77, 110: 78, 111: 79, 112: 80,
				113: 81, 114: 82, 115: 83, 116: 84, 117: 85, 118: 86, 119: 87, 120: 88, 121: 89, 122: 90, 171: 60, 187: 62, 183: 46, 160: 32, 173: 45, 166: 124,
				819: 95, 180: 39, 168: 34, 184: 44, 172: 45, 215: 42, 247: 47,
			},
		}
	case 0x19: // 25
		return &StringConverter{
			LangID:    25,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 2305, 2306, 2307, 2309, 2310, 2311, 2312, 2313, 2314, 2315, 2318, 2319, 2320, 2317, 2322,
				2323, 2324, 2321, 2325, 2326, 2327, 2328, 2329, 2330, 2331, 2332, 2333, 2334, 2335, 2336, 2337,
				2338, 2339, 2340, 2341, 2342, 2343, 2344, 2345, 2346, 2347, 2348, 2349, 2350, 2351, 2399, 2352,
				2353, 2354, 2355, 2356, 2357, 2358, 2359, 2360, 2361, 160, 2366, 2367, 2368, 2369, 2370, 2371,
				2374, 2375, 2376, 2373, 2378, 2379, 2380, 2377, 2381, 2364, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 2406, 2407, 2408, 2409, 2410, 2411, 2412, 2413, 2414, 2415, 65535, 65535, 65535, 65535, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 2305: 161, 2306: 162, 2307: 163, 2309: 164, 2310: 165, 2311: 166, 2312: 167, 2313: 168, 2314: 169, 2315: 170, 2318: 171, 2319: 172, 2320: 173, 2317: 174, 2322: 175,
				2323: 176, 2324: 177, 2321: 178, 2325: 179, 2326: 180, 2327: 181, 2328: 182, 2329: 183, 2330: 184, 2331: 185, 2332: 186, 2333: 187, 2334: 188, 2335: 189, 2336: 190, 2337: 191,
				2338: 192, 2339: 193, 2340: 194, 2341: 195, 2342: 196, 2343: 197, 2344: 198, 2345: 199, 2346: 200, 2347: 201, 2348: 202, 2349: 203, 2350: 204, 2351: 205, 2399: 206, 2352: 207,
				2353: 208, 2354: 209, 2355: 210, 2356: 211, 2357: 212, 2358: 213, 2359: 214, 2360: 215, 2361: 216, 160: 217, 2366: 218, 2367: 219, 2368: 220, 2369: 221, 2370: 222, 2371: 223,
				2374: 224, 2375: 225, 2376: 226, 2373: 227, 2378: 228, 2379: 229, 2380: 230, 2377: 231, 2381: 232, 2364: 233, 2406: 241, 2407: 242, 2408: 243, 2409: 244, 2410: 245, 2411: 246,
				2412: 247, 2413: 248, 2414: 249, 2415: 250,
			},
		}
	case 0x1b: // 27
		return &StringConverter{
			LangID:    27,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 91, 46, 60, 40, 43, 33,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 93, 36, 42, 41, 59, 94,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 166, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 8364,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 172, 124, 175, 168, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 91: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 93: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 8364: 159, 181: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 168: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255, 8216: 121, 8248: 95,
				8764: 161, 376: 232,
			},
		}
	case 0x1c: // 28
		return &StringConverter{
			LangID:    28,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 239, 238, 236, 196, 197,
				201, 230, 198, 244, 246, 242, 251, 249, 255, 214, 220, 248, 163, 216, 215, 402,
				225, 237, 243, 250, 241, 209, 170, 186, 191, 174, 172, 189, 188, 161, 171, 187,
				9617, 9618, 9619, 9474, 9508, 193, 194, 192, 169, 9571, 9553, 9559, 9565, 162, 165, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 227, 195, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 164,
				240, 208, 202, 203, 200, 8364, 205, 206, 207, 9496, 9484, 9608, 9604, 166, 204, 9600,
				211, 223, 212, 210, 245, 213, 181, 254, 222, 218, 219, 217, 253, 221, 175, 180,
				173, 177, 8215, 190, 182, 167, 247, 184, 176, 168, 183, 185, 179, 178, 9632, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 252: 129, 233: 130, 226: 131, 228: 132, 224: 133, 229: 134, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 236: 141, 196: 142, 197: 143,
				201: 144, 230: 145, 198: 146, 244: 147, 246: 148, 242: 149, 251: 150, 249: 151, 255: 152, 214: 153, 220: 154, 248: 155, 163: 156, 216: 157, 215: 158, 402: 159,
				225: 160, 237: 161, 243: 162, 250: 163, 241: 164, 209: 165, 170: 166, 186: 167, 191: 168, 174: 169, 172: 170, 189: 171, 188: 172, 161: 173, 171: 174, 187: 175,
				9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 193: 181, 194: 182, 192: 183, 169: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 162: 189, 165: 190, 9488: 191,
				9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 227: 198, 195: 199, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 164: 207,
				240: 208, 208: 209, 202: 210, 203: 211, 200: 212, 8364: 213, 205: 214, 206: 215, 207: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 166: 221, 204: 222, 9600: 223,
				211: 224, 223: 225, 212: 226, 210: 227, 245: 228, 213: 229, 181: 230, 254: 231, 222: 232, 218: 233, 219: 234, 217: 235, 253: 236, 221: 237, 175: 238, 180: 239,
				173: 240, 177: 241, 8215: 242, 190: 243, 182: 244, 167: 245, 247: 246, 184: 247, 176: 248, 168: 249, 183: 250, 185: 251, 179: 252, 178: 253, 9632: 254, 160: 255,
				8216: 96, 8213: 45, 8248: 94, 8764: 126, 8356: 76, 63741: 159, 305: 213, 8718: 254,
			},
		}
	case 0x1f: // 31
		return &StringConverter{
			LangID:    31,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  191,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
				176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
				192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
				208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
				224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
				240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				128: 128, 129: 129, 130: 130, 131: 131, 132: 132, 133: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 145: 145, 146: 146, 147: 147, 148: 148, 149: 149, 150: 150, 151: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 161: 161, 162: 162, 163: 163, 164: 164, 165: 165, 166: 166, 167: 167, 168: 168, 169: 169, 170: 170, 171: 171, 172: 172, 173: 173, 174: 174, 175: 175,
				176: 176, 177: 177, 178: 178, 179: 179, 180: 180, 181: 181, 182: 182, 183: 183, 184: 184, 185: 185, 186: 186, 187: 187, 188: 188, 189: 189, 190: 190, 191: 191,
				192: 192, 193: 193, 194: 194, 195: 195, 196: 196, 197: 197, 198: 198, 199: 199, 200: 200, 201: 201, 202: 202, 203: 203, 204: 204, 205: 205, 206: 206, 207: 207,
				208: 208, 209: 209, 210: 210, 211: 211, 212: 212, 213: 213, 214: 214, 215: 215, 216: 216, 217: 217, 218: 218, 219: 219, 220: 220, 221: 221, 222: 222, 223: 223,
				224: 224, 225: 225, 226: 226, 227: 227, 228: 228, 229: 229, 230: 230, 231: 231, 232: 232, 233: 233, 234: 234, 235: 235, 236: 236, 237: 237, 238: 238, 239: 239,
				240: 240, 241: 241, 242: 242, 243: 243, 244: 244, 245: 245, 246: 246, 247: 247, 248: 248, 249: 249, 250: 250, 251: 251, 252: 252, 253: 253, 254: 254, 255: 255,
				8216: 96, 8213: 45, 63742: 183, 8248: 94, 8764: 126, 63741: 102, 8356: 76, 376: 89, 946: 223,
			},
		}
	case 0x20: // 32
		return &StringConverter{
			LangID:    32,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 260, 728, 321, 164, 317, 346, 167, 168, 352, 350, 356, 377, 173, 381, 379,
				176, 261, 731, 322, 180, 318, 347, 711, 184, 353, 351, 357, 378, 733, 382, 380,
				340, 193, 194, 258, 196, 313, 262, 199, 268, 201, 280, 203, 282, 205, 206, 270,
				272, 323, 327, 211, 212, 336, 214, 215, 344, 366, 218, 368, 220, 221, 354, 223,
				341, 225, 226, 259, 228, 314, 263, 231, 269, 233, 281, 235, 283, 237, 238, 271,
				273, 324, 328, 243, 244, 337, 246, 247, 345, 367, 250, 369, 252, 253, 355, 729,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				128: 128, 129: 129, 130: 130, 131: 131, 132: 132, 133: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 145: 145, 146: 146, 147: 147, 148: 148, 149: 149, 150: 150, 151: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 260: 161, 728: 162, 321: 163, 164: 164, 317: 165, 346: 166, 167: 167, 168: 168, 352: 169, 350: 170, 356: 171, 377: 172, 173: 173, 381: 174, 379: 175,
				176: 176, 261: 177, 731: 178, 322: 179, 180: 180, 318: 181, 347: 182, 711: 183, 184: 184, 353: 185, 351: 186, 357: 187, 378: 188, 733: 189, 382: 190, 380: 191,
				340: 192, 193: 193, 194: 194, 258: 195, 196: 196, 313: 197, 262: 198, 199: 199, 268: 200, 201: 201, 280: 202, 203: 203, 282: 204, 205: 205, 206: 206, 270: 207,
				272: 208, 323: 209, 327: 210, 211: 211, 212: 212, 336: 213, 214: 214, 215: 215, 344: 216, 366: 217, 218: 218, 368: 219, 220: 220, 221: 221, 354: 222, 223: 223,
				341: 224, 225: 225, 226: 226, 259: 227, 228: 228, 314: 229, 263: 230, 231: 231, 269: 232, 233: 233, 281: 234, 235: 235, 283: 236, 237: 237, 238: 238, 271: 239,
				273: 240, 324: 241, 328: 242, 243: 243, 244: 244, 337: 245, 246: 246, 247: 247, 345: 248, 367: 249, 250: 250, 369: 251, 252: 252, 253: 253, 355: 254, 729: 255,
				730: 176,
			},
		}
	case 0x21: // 33
		return &StringConverter{
			LangID:    33,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 294, 728, 163, 164, 65535, 292, 167, 168, 304, 350, 286, 308, 173, 65535, 379,
				176, 295, 178, 179, 180, 181, 293, 183, 184, 305, 351, 287, 309, 189, 65535, 380,
				192, 193, 194, 65535, 196, 266, 264, 199, 200, 201, 202, 203, 204, 205, 206, 207,
				65535, 209, 210, 211, 212, 288, 214, 215, 284, 217, 218, 219, 220, 364, 348, 223,
				224, 225, 226, 65535, 228, 267, 265, 231, 232, 233, 234, 235, 236, 237, 238, 239,
				65535, 241, 242, 243, 244, 289, 246, 247, 285, 249, 250, 251, 252, 365, 349, 729,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				128: 128, 129: 129, 130: 130, 131: 131, 132: 132, 133: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 145: 145, 146: 146, 147: 147, 148: 148, 149: 149, 150: 150, 151: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 294: 161, 728: 162, 163: 163, 164: 164, 65535: 240, 292: 166, 167: 167, 168: 168, 304: 169, 350: 170, 286: 171, 308: 172, 173: 173, 379: 175, 176: 176,
				295: 177, 178: 178, 179: 179, 180: 180, 181: 181, 293: 182, 183: 183, 184: 184, 305: 185, 351: 186, 287: 187, 309: 188, 189: 189, 380: 191, 192: 192, 193: 193,
				194: 194, 196: 196, 266: 197, 264: 198, 199: 199, 200: 200, 201: 201, 202: 202, 203: 203, 204: 204, 205: 205, 206: 206, 207: 207, 209: 209, 210: 210, 211: 211,
				212: 212, 288: 213, 214: 214, 215: 215, 284: 216, 217: 217, 218: 218, 219: 219, 220: 220, 364: 221, 348: 222, 223: 223, 224: 224, 225: 225, 226: 226, 228: 228,
				267: 229, 265: 230, 231: 231, 232: 232, 233: 233, 234: 234, 235: 235, 236: 236, 237: 237, 238: 238, 239: 239, 241: 241, 242: 242, 243: 243, 244: 244, 289: 245,
				246: 246, 247: 247, 285: 248, 249: 249, 250: 250, 251: 251, 252: 252, 365: 253, 349: 254, 729: 255,
			},
		}
	case 0x22: // 34
		return &StringConverter{
			LangID:    34,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 260, 312, 342, 164, 296, 315, 167, 168, 352, 274, 290, 358, 173, 381, 713,
				176, 261, 731, 343, 180, 297, 316, 711, 184, 353, 275, 291, 359, 330, 382, 331,
				256, 193, 194, 195, 196, 197, 198, 302, 268, 201, 280, 203, 278, 205, 206, 298,
				272, 325, 332, 310, 212, 213, 214, 215, 216, 370, 218, 219, 220, 360, 362, 223,
				257, 225, 226, 227, 228, 229, 230, 303, 269, 233, 281, 235, 279, 237, 238, 299,
				273, 326, 333, 311, 244, 245, 246, 247, 248, 371, 250, 251, 252, 361, 363, 729,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				128: 128, 129: 129, 130: 130, 131: 131, 132: 132, 133: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 145: 145, 146: 146, 147: 147, 148: 148, 149: 149, 150: 150, 151: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 260: 161, 312: 162, 342: 163, 164: 164, 296: 165, 315: 166, 167: 167, 168: 168, 352: 169, 274: 170, 290: 171, 358: 172, 173: 173, 381: 174, 713: 175,
				176: 176, 261: 177, 731: 178, 343: 179, 180: 180, 297: 181, 316: 182, 711: 183, 184: 184, 353: 185, 275: 186, 291: 187, 359: 188, 330: 189, 382: 190, 331: 191,
				256: 192, 193: 193, 194: 194, 195: 195, 196: 196, 197: 197, 198: 198, 302: 199, 268: 200, 201: 201, 280: 202, 203: 203, 278: 204, 205: 205, 206: 206, 298: 207,
				272: 208, 325: 209, 332: 210, 310: 211, 212: 212, 213: 213, 214: 214, 215: 215, 216: 216, 370: 217, 218: 218, 219: 219, 220: 220, 360: 221, 362: 222, 223: 223,
				257: 224, 225: 225, 226: 226, 227: 227, 228: 228, 229: 229, 230: 230, 303: 231, 269: 232, 233: 233, 281: 234, 235: 235, 279: 236, 237: 237, 238: 238, 299: 239,
				273: 240, 326: 241, 333: 242, 311: 243, 244: 244, 245: 245, 246: 246, 247: 247, 248: 248, 371: 249, 250: 250, 251: 251, 252: 252, 361: 253, 363: 254, 729: 255,
			},
		}
	case 0x23: // 35
		return &StringConverter{
			LangID:    35,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 173, 1038, 1039,
				1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055,
				1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071,
				1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087,
				1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103,
				8470, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 167, 1118, 1119,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				128: 128, 129: 129, 130: 130, 131: 131, 132: 132, 133: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 145: 145, 146: 146, 147: 147, 148: 148, 149: 149, 150: 150, 151: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 1025: 161, 1026: 162, 1027: 163, 1028: 164, 1029: 165, 1030: 166, 1031: 167, 1032: 168, 1033: 169, 1034: 170, 1035: 171, 1036: 172, 173: 173, 1038: 174, 1039: 175,
				1040: 176, 1041: 177, 1042: 178, 1043: 179, 1044: 180, 1045: 181, 1046: 182, 1047: 183, 1048: 184, 1049: 185, 1050: 186, 1051: 187, 1052: 188, 1053: 189, 1054: 190, 1055: 191,
				1056: 192, 1057: 193, 1058: 194, 1059: 195, 1060: 196, 1061: 197, 1062: 198, 1063: 199, 1064: 200, 1065: 201, 1066: 202, 1067: 203, 1068: 204, 1069: 205, 1070: 206, 1071: 207,
				1072: 208, 1073: 209, 1074: 210, 1075: 211, 1076: 212, 1077: 213, 1078: 214, 1079: 215, 1080: 216, 1081: 217, 1082: 218, 1083: 219, 1084: 220, 1085: 221, 1086: 222, 1087: 223,
				1088: 224, 1089: 225, 1090: 226, 1091: 227, 1092: 228, 1093: 229, 1094: 230, 1095: 231, 1096: 232, 1097: 233, 1098: 234, 1099: 235, 1100: 236, 1101: 237, 1102: 238, 1103: 239,
				8470: 240, 1105: 241, 1106: 242, 1107: 243, 1108: 244, 1109: 245, 1110: 246, 1111: 247, 1112: 248, 1113: 249, 1114: 250, 1115: 251, 1116: 252, 167: 253, 1118: 254, 1119: 255,
			},
		}
	case 0x24: // 36
		return &StringConverter{
			LangID:    36,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 65535, 65535, 65535, 164, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 1548, 173, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 1563, 65535, 65535, 65535, 1567,
				65535, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583,
				1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 65535, 65535, 65535, 65535, 65535,
				1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 1611, 1612, 1613, 1614, 1615,
				1616, 1617, 1618, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				128: 128, 129: 129, 130: 130, 131: 131, 132: 132, 133: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 145: 145, 146: 146, 147: 147, 148: 148, 149: 149, 150: 150, 151: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 65535: 255, 164: 164, 1548: 172, 173: 173, 1563: 187, 1567: 191, 1569: 193, 1570: 194, 1571: 195, 1572: 196, 1573: 197, 1574: 198, 1575: 199, 1576: 200, 1577: 201,
				1578: 202, 1579: 203, 1580: 204, 1581: 205, 1582: 206, 1583: 207, 1584: 208, 1585: 209, 1586: 210, 1587: 211, 1588: 212, 1589: 213, 1590: 214, 1591: 215, 1592: 216, 1593: 217,
				1594: 218, 1600: 224, 1601: 225, 1602: 226, 1603: 227, 1604: 228, 1605: 229, 1606: 230, 1607: 231, 1608: 232, 1609: 233, 1610: 234, 1611: 235, 1612: 236, 1613: 237, 1614: 238,
				1615: 239, 1616: 240, 1617: 241, 1618: 242,
			},
		}
	case 0x25: // 37
		return &StringConverter{
			LangID:    37,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 8216, 8217, 163, 8364, 65535, 166, 167, 168, 169, 65535, 171, 172, 173, 65535, 8213,
				176, 177, 178, 179, 900, 901, 902, 183, 904, 905, 906, 187, 908, 189, 910, 911,
				912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927,
				928, 929, 65535, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943,
				944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959,
				960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				128: 128, 129: 129, 130: 130, 131: 131, 132: 132, 133: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 145: 145, 146: 146, 147: 147, 148: 148, 149: 149, 150: 150, 151: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 8216: 161, 8217: 162, 163: 163, 8364: 164, 65535: 255, 166: 166, 167: 167, 168: 168, 169: 169, 171: 171, 172: 172, 173: 173, 8213: 175, 176: 176, 177: 177,
				178: 178, 179: 179, 900: 180, 901: 181, 902: 182, 183: 183, 904: 184, 905: 185, 906: 186, 187: 187, 908: 188, 189: 189, 910: 190, 911: 191, 912: 192, 913: 193,
				914: 194, 915: 195, 916: 196, 917: 197, 918: 198, 919: 199, 920: 200, 921: 201, 922: 202, 923: 203, 924: 204, 925: 205, 926: 206, 927: 207, 928: 208, 929: 209,
				931: 211, 932: 212, 933: 213, 934: 214, 935: 215, 936: 216, 937: 217, 938: 218, 939: 219, 940: 220, 941: 221, 942: 222, 943: 223, 944: 224, 945: 225, 946: 226,
				947: 227, 948: 228, 949: 229, 950: 230, 951: 231, 952: 232, 953: 233, 954: 234, 955: 235, 956: 236, 957: 237, 958: 238, 959: 239, 960: 240, 961: 241, 962: 242,
				963: 243, 964: 244, 965: 245, 966: 246, 967: 247, 968: 248, 969: 249, 970: 250, 971: 251, 972: 252, 973: 253, 974: 254,
			},
		}
	case 0x26: // 38
		return &StringConverter{
			LangID:    38,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 65535, 162, 163, 164, 165, 166, 167, 168, 169, 215, 171, 172, 173, 174, 175,
				176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 247, 187, 188, 189, 190, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 8215,
				1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502, 1503,
				1504, 1505, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 65535, 65535, 8206, 8207, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				128: 128, 129: 129, 130: 130, 131: 131, 132: 132, 133: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 145: 145, 146: 146, 147: 147, 148: 148, 149: 149, 150: 150, 151: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 65535: 255, 162: 162, 163: 163, 164: 164, 165: 165, 166: 166, 167: 167, 168: 168, 169: 169, 215: 170, 171: 171, 172: 172, 173: 173, 174: 174, 175: 175,
				176: 176, 177: 177, 178: 178, 179: 179, 180: 180, 181: 181, 182: 182, 183: 183, 184: 184, 185: 185, 247: 186, 187: 187, 188: 188, 189: 189, 190: 190, 8215: 223,
				1488: 224, 1489: 225, 1490: 226, 1491: 227, 1492: 228, 1493: 229, 1494: 230, 1495: 231, 1496: 232, 1497: 233, 1498: 234, 1499: 235, 1500: 236, 1501: 237, 1502: 238, 1503: 239,
				1504: 240, 1505: 241, 1506: 242, 1507: 243, 1508: 244, 1509: 245, 1510: 246, 1511: 247, 1512: 248, 1513: 249, 1514: 250, 8206: 253, 8207: 254, 819: 223,
			},
		}
	case 0x27: // 39
		return &StringConverter{
			LangID:    39,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
				176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
				192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
				286, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 304, 350, 223,
				224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
				287, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 305, 351, 255,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				128: 128, 129: 129, 130: 130, 131: 131, 132: 132, 133: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 145: 145, 146: 146, 147: 147, 148: 148, 149: 149, 150: 150, 151: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 161: 161, 162: 162, 163: 163, 164: 164, 165: 165, 166: 166, 167: 167, 168: 168, 169: 169, 170: 170, 171: 171, 172: 172, 173: 173, 174: 174, 175: 175,
				176: 176, 177: 177, 178: 178, 179: 179, 180: 180, 181: 181, 182: 182, 183: 183, 184: 184, 185: 185, 186: 186, 187: 187, 188: 188, 189: 189, 190: 190, 191: 191,
				192: 192, 193: 193, 194: 194, 195: 195, 196: 196, 197: 197, 198: 198, 199: 199, 200: 200, 201: 201, 202: 202, 203: 203, 204: 204, 205: 205, 206: 206, 207: 207,
				286: 208, 209: 209, 210: 210, 211: 211, 212: 212, 213: 213, 214: 214, 215: 215, 216: 216, 217: 217, 218: 218, 219: 219, 220: 220, 304: 221, 350: 222, 223: 223,
				224: 224, 225: 225, 226: 226, 227: 227, 228: 228, 229: 229, 230: 230, 231: 231, 232: 232, 233: 233, 234: 234, 235: 235, 236: 236, 237: 237, 238: 238, 239: 239,
				287: 240, 241: 241, 242: 242, 243: 243, 244: 244, 245: 245, 246: 246, 247: 247, 248: 248, 249: 249, 250: 250, 251: 251, 252: 252, 305: 253, 351: 254, 255: 255,
				8216: 96, 8213: 45, 63742: 183, 8248: 94, 8764: 126, 63741: 102, 8356: 76, 63738: 73, 376: 89, 63736: 105, 946: 223,
			},
		}
	case 0x28: // 40
		return &StringConverter{
			LangID:    40,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 260, 274, 290, 298, 296, 310, 167, 315, 272, 352, 358, 381, 173, 362, 330,
				176, 261, 275, 291, 299, 297, 311, 183, 316, 273, 353, 359, 382, 65535, 363, 331,
				256, 193, 194, 195, 196, 197, 198, 302, 268, 201, 280, 203, 278, 205, 206, 207,
				208, 325, 332, 211, 212, 213, 214, 360, 216, 370, 218, 219, 220, 221, 222, 223,
				257, 225, 226, 227, 228, 229, 230, 303, 269, 233, 281, 235, 279, 237, 238, 239,
				240, 326, 333, 243, 244, 245, 246, 361, 248, 371, 250, 251, 252, 253, 254, 312,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				128: 128, 129: 129, 130: 130, 131: 131, 132: 132, 133: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 145: 145, 146: 146, 147: 147, 148: 148, 149: 149, 150: 150, 151: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 260: 161, 274: 162, 290: 163, 298: 164, 296: 165, 310: 166, 167: 167, 315: 168, 272: 169, 352: 170, 358: 171, 381: 172, 173: 173, 362: 174, 330: 175,
				176: 176, 261: 177, 275: 178, 291: 179, 299: 180, 297: 181, 311: 182, 183: 183, 316: 184, 273: 185, 353: 186, 359: 187, 382: 188, 65535: 189, 363: 190, 331: 191,
				256: 192, 193: 193, 194: 194, 195: 195, 196: 196, 197: 197, 198: 198, 302: 199, 268: 200, 201: 201, 280: 202, 203: 203, 278: 204, 205: 205, 206: 206, 207: 207,
				208: 208, 325: 209, 332: 210, 211: 211, 212: 212, 213: 213, 214: 214, 360: 215, 216: 216, 370: 217, 218: 218, 219: 219, 220: 220, 221: 221, 222: 222, 223: 223,
				257: 224, 225: 225, 226: 226, 227: 227, 228: 228, 229: 229, 230: 230, 303: 231, 269: 232, 233: 233, 281: 234, 235: 235, 279: 236, 237: 237, 238: 238, 239: 239,
				240: 240, 326: 241, 333: 242, 243: 243, 244: 244, 245: 245, 246: 246, 361: 247, 248: 248, 371: 249, 250: 250, 251: 251, 252: 252, 253: 253, 254: 254, 312: 255,
			},
		}
	case 0x29: // 41
		return &StringConverter{
			LangID:    41,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				8364, 129, 130, 131, 132, 8230, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 3585, 3586, 3587, 3588, 3589, 3590, 3591, 3592, 3593, 3594, 3595, 3596, 3597, 3598, 3599,
				3600, 3601, 3602, 3603, 3604, 3605, 3606, 3607, 3608, 3609, 3610, 3611, 3612, 3613, 3614, 3615,
				3616, 3617, 3618, 3619, 3620, 3621, 3622, 3623, 3624, 3625, 3626, 3627, 3628, 3629, 3630, 3631,
				3632, 3633, 3634, 3635, 3636, 3637, 3638, 3639, 3640, 3641, 3642, 63681, 63682, 63683, 63684, 3647,
				3648, 3649, 3650, 3651, 3652, 3653, 3654, 3655, 3656, 3657, 3658, 3659, 3660, 3661, 3662, 3663,
				3664, 3665, 3666, 3667, 3668, 3669, 3670, 3671, 3672, 3673, 3674, 3675, 63685, 63686, 63687, 63688,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				8364: 128, 129: 129, 130: 130, 131: 131, 132: 132, 8230: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 8216: 145, 8217: 146, 8220: 147, 8221: 148, 8226: 149, 8211: 150, 8212: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 3585: 161, 3586: 162, 3587: 163, 3588: 164, 3589: 165, 3590: 166, 3591: 167, 3592: 168, 3593: 169, 3594: 170, 3595: 171, 3596: 172, 3597: 173, 3598: 174, 3599: 175,
				3600: 176, 3601: 177, 3602: 178, 3603: 179, 3604: 180, 3605: 181, 3606: 182, 3607: 183, 3608: 184, 3609: 185, 3610: 186, 3611: 187, 3612: 188, 3613: 189, 3614: 190, 3615: 191,
				3616: 192, 3617: 193, 3618: 194, 3619: 195, 3620: 196, 3621: 197, 3622: 198, 3623: 199, 3624: 200, 3625: 201, 3626: 202, 3627: 203, 3628: 204, 3629: 205, 3630: 206, 3631: 207,
				3632: 208, 3633: 209, 3634: 210, 3635: 211, 3636: 212, 3637: 213, 3638: 214, 3639: 215, 3640: 216, 3641: 217, 3642: 218, 63681: 219, 63682: 220, 63683: 221, 63684: 222, 3647: 223,
				3648: 224, 3649: 225, 3650: 226, 3651: 227, 3652: 228, 3653: 229, 3654: 230, 3655: 231, 3656: 232, 3657: 233, 3658: 234, 3659: 235, 3660: 236, 3661: 237, 3662: 238, 3663: 239,
				3664: 240, 3665: 241, 3666: 242, 3667: 243, 3668: 244, 3669: 245, 3670: 246, 3671: 247, 3672: 248, 3673: 249, 3674: 250, 3675: 251, 63685: 252, 63686: 253, 63687: 254, 63688: 255,
				167: 21, 182: 20, 8252: 19, 8592: 27, 8593: 24, 8594: 26, 8595: 25, 8596: 29, 8597: 18, 8616: 23, 8735: 28, 8962: 127, 9472: 196, 9474: 179, 9484: 218, 9488: 191,
				9492: 192, 9496: 217, 9552: 205, 9553: 186, 9556: 201, 9559: 187, 9562: 200, 9565: 188, 9604: 220, 9644: 22, 9650: 30, 9658: 16, 9660: 31, 9668: 17, 9675: 9, 9688: 8,
				9689: 10, 9786: 1, 9787: 2, 9788: 15, 9792: 12, 9794: 11, 9824: 6, 9827: 5, 9829: 3, 9830: 4, 9834: 13, 9835: 14, 65281: 33, 65282: 34, 65283: 35, 65284: 36,
				65285: 37, 65286: 38, 65287: 39, 65288: 40, 65289: 41, 65290: 42, 65291: 43, 65292: 44, 65293: 45, 65294: 46, 65295: 47, 65296: 48, 65297: 49, 65298: 50, 65299: 51, 65300: 52,
				65301: 53, 65302: 54, 65303: 55, 65304: 56, 65305: 57, 65306: 58, 65307: 59, 65308: 60, 65309: 61, 65310: 62, 65312: 64, 65313: 65, 65314: 66, 65315: 67, 65316: 68, 65317: 69,
				65318: 70, 65319: 71, 65320: 72, 65321: 73, 65322: 74, 65323: 75, 65324: 76, 65325: 77, 65326: 78, 65327: 79, 65328: 80, 65329: 81, 65330: 82, 65331: 83, 65332: 84, 65333: 85,
				65334: 86, 65335: 87, 65336: 88, 65337: 89, 65338: 90, 65339: 91, 65340: 92, 65341: 93, 65342: 94, 65343: 95, 65344: 96, 65345: 97, 65346: 98, 65347: 99, 65348: 100, 65349: 101,
				65350: 102, 65351: 103, 65352: 104, 65353: 105, 65354: 106, 65355: 107, 65356: 108, 65357: 109, 65358: 110, 65359: 111, 65360: 112, 65361: 113, 65362: 114, 65363: 115, 65364: 116, 65365: 117,
				65366: 118, 65367: 119, 65368: 120, 65369: 121, 65370: 122, 65371: 123, 65372: 124, 65373: 125, 65374: 126,
			},
		}
	case 0x2a: // 42
		return &StringConverter{
			LangID:    42,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 65535, 3585, 3586, 3587, 3588, 3589, 3590, 3591, 91, 162, 46, 60, 40, 43, 124,
				38, 65535, 3592, 3593, 3594, 3595, 3596, 3597, 3598, 93, 33, 36, 42, 41, 59, 94,
				45, 47, 3599, 3600, 3601, 3602, 3603, 3604, 3605, 65535, 166, 44, 37, 95, 62, 63,
				3647, 3662, 3606, 3607, 3608, 3609, 3610, 3611, 3612, 96, 58, 35, 64, 39, 61, 34,
				3663, 97, 98, 99, 100, 101, 102, 103, 104, 105, 3613, 3614, 3615, 3616, 3617, 3618,
				3674, 106, 107, 108, 109, 110, 111, 112, 113, 114, 3619, 3620, 3621, 3622, 3623, 3624,
				3675, 126, 115, 116, 117, 118, 119, 120, 121, 122, 3625, 3626, 3627, 3628, 3629, 3630,
				3664, 3665, 3666, 3667, 3668, 3669, 3670, 3671, 3672, 3673, 3631, 3632, 3633, 3634, 3635, 3636,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 65535, 3637, 3638, 3639, 3640, 3641,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 3642, 3648, 3649, 3650, 3651, 3652,
				92, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 3653, 3654, 3655, 3656, 3657, 3658,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 3659, 3660, 3661, 65535, 65535, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 65535: 254,
				3585: 66, 3586: 67, 3587: 68, 3588: 69, 3589: 70, 3590: 71, 3591: 72, 91: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 3592: 82,
				3593: 83, 3594: 84, 3595: 85, 3596: 86, 3597: 87, 3598: 88, 93: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97, 3599: 98,
				3600: 99, 3601: 100, 3602: 101, 3603: 102, 3604: 103, 3605: 104, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 3647: 112, 3662: 113, 3606: 114, 3607: 115,
				3608: 116, 3609: 117, 3610: 118, 3611: 119, 3612: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 3663: 128, 97: 129, 98: 130, 99: 131,
				100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 3613: 138, 3614: 139, 3615: 140, 3616: 141, 3617: 142, 3618: 143, 3674: 144, 106: 145, 107: 146, 108: 147,
				109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 3619: 154, 3620: 155, 3621: 156, 3622: 157, 3623: 158, 3624: 159, 3675: 160, 126: 161, 115: 162, 116: 163,
				117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 3625: 170, 3626: 171, 3627: 172, 3628: 173, 3629: 174, 3630: 175, 3664: 176, 3665: 177, 3666: 178, 3667: 179,
				3668: 180, 3669: 181, 3670: 182, 3671: 183, 3672: 184, 3673: 185, 3631: 186, 3632: 187, 3633: 188, 3634: 189, 3635: 190, 3636: 191, 123: 192, 65: 193, 66: 194, 67: 195,
				68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 3637: 203, 3638: 204, 3639: 205, 3640: 206, 3641: 207, 125: 208, 74: 209, 75: 210, 76: 211, 77: 212,
				78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 3642: 218, 3648: 219, 3649: 220, 3650: 221, 3651: 222, 3652: 223, 92: 224, 83: 226, 84: 227, 85: 228, 86: 229,
				87: 230, 88: 231, 89: 232, 90: 233, 3653: 234, 3654: 235, 3655: 236, 3656: 237, 3657: 238, 3658: 239, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245,
				54: 246, 55: 247, 56: 248, 57: 249, 3659: 250, 3660: 251, 3661: 252, 159: 255,
			},
		}
	case 0x2b: // 43
		return &StringConverter{
			LangID:    43,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 2547, 2534, 2535, 2536, 2537, 2538, 2539, 2540, 2541, 2542, 2543,
				2437, 2438, 2439, 2440, 2441, 2442, 2443, 2447, 2448, 2451, 2452, 2434, 2435, 2433, 2453, 2454,
				2455, 2456, 2457, 2458, 2459, 2460, 2461, 2462, 2463, 2464, 2465, 2524, 2466, 2525, 2467, 65535,
				2468, 2469, 2470, 2471, 2472, 2474, 2475, 2476, 2477, 2478, 2479, 2527, 2480, 2482, 2486, 2487,
				2488, 2489, 65535, 2494, 2495, 2496, 2497, 2498, 2499, 2503, 2504, 2507, 2508, 65535, 65535, 65535,
				63671, 63670, 63669, 63668, 63667, 63666, 63665, 63664, 63663, 63662, 63661, 63660, 63659, 65535, 63658, 65535,
				63657, 63656, 63655, 63654, 63653, 63652, 63651, 63650, 63649, 63648, 63647, 63646, 63645, 65535, 63644, 63643,
				63642, 63641, 63640, 63639, 63638, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 2547: 133, 2534: 134, 2535: 135, 2536: 136, 2537: 137, 2538: 138, 2539: 139, 2540: 140, 2541: 141, 2542: 142, 2543: 143, 2437: 144, 2438: 145, 2439: 146, 2440: 147,
				2441: 148, 2442: 149, 2443: 150, 2447: 151, 2448: 152, 2451: 153, 2452: 154, 2434: 155, 2435: 156, 2433: 157, 2453: 158, 2454: 159, 2455: 160, 2456: 161, 2457: 162, 2458: 163,
				2459: 164, 2460: 165, 2461: 166, 2462: 167, 2463: 168, 2464: 169, 2465: 170, 2524: 171, 2466: 172, 2525: 173, 2467: 174, 2468: 176, 2469: 177, 2470: 178, 2471: 179, 2472: 180,
				2474: 181, 2475: 182, 2476: 183, 2477: 184, 2478: 185, 2479: 186, 2527: 187, 2480: 188, 2482: 189, 2486: 190, 2487: 191, 2488: 192, 2489: 193, 2494: 195, 2495: 196, 2496: 197,
				2497: 198, 2498: 199, 2499: 200, 2503: 201, 2504: 202, 2507: 203, 2508: 204, 63671: 208, 63670: 209, 63669: 210, 63668: 211, 63667: 212, 63666: 213, 63665: 214, 63664: 215, 63663: 216,
				63662: 217, 63661: 218, 63660: 219, 63659: 220, 63658: 222, 63657: 224, 63656: 225, 63655: 226, 63654: 227, 63653: 228, 63652: 229, 63651: 230, 63650: 231, 63649: 232, 63648: 233, 63647: 234,
				63646: 235, 63645: 236, 63644: 238, 63643: 239, 63642: 240, 63641: 241, 63640: 242, 63639: 243, 63638: 244,
			},
		}
	case 0x2c: // 44
		return &StringConverter{
			LangID:    44,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 258, 194, 202, 212, 416, 431, 272, 259, 226, 234, 244, 417, 432, 273, 65535,
				65535, 65535, 65535, 65535, 65535, 224, 7843, 227, 225, 7841, 65535, 7857, 7859, 7861, 7855, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 7863, 7847, 7849, 7851, 7845, 7853, 232, 65535, 7867, 7869,
				233, 7865, 7873, 7875, 7877, 7871, 7879, 236, 7881, 65535, 65535, 65535, 297, 237, 7883, 242,
				65535, 7887, 245, 243, 7885, 7891, 7893, 7895, 7889, 7897, 7901, 7903, 7905, 7899, 7907, 249,
				65535, 7911, 361, 250, 7909, 7915, 7917, 7919, 7913, 7921, 7923, 7927, 7929, 253, 7925, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 258: 161, 194: 162, 202: 163, 212: 164, 416: 165, 431: 166, 272: 167, 259: 168, 226: 169, 234: 170, 244: 171, 417: 172, 432: 173, 273: 174, 224: 181,
				7843: 182, 227: 183, 225: 184, 7841: 185, 7857: 187, 7859: 188, 7861: 189, 7855: 190, 7863: 198, 7847: 199, 7849: 200, 7851: 201, 7845: 202, 7853: 203, 232: 204, 7867: 206,
				7869: 207, 233: 208, 7865: 209, 7873: 210, 7875: 211, 7877: 212, 7871: 213, 7879: 214, 236: 215, 7881: 216, 297: 220, 237: 221, 7883: 222, 242: 223, 7887: 225, 245: 226,
				243: 227, 7885: 228, 7891: 229, 7893: 230, 7895: 231, 7889: 232, 7897: 233, 7901: 234, 7903: 235, 7905: 236, 7899: 237, 7907: 238, 249: 239, 7911: 241, 361: 242, 250: 243,
				7909: 244, 7915: 245, 7917: 246, 7919: 247, 7913: 248, 7921: 249, 7923: 250, 7927: 251, 7929: 252, 253: 253, 7925: 254,
			},
		}
	case 0x2d: // 45
		return &StringConverter{
			LangID:    45,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				8364, 129, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 138, 8249, 338, 141, 142, 143,
				144, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 154, 8250, 339, 157, 158, 376,
				160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
				176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
				192, 193, 194, 258, 196, 197, 198, 199, 200, 201, 202, 203, 768, 205, 206, 207,
				272, 209, 777, 211, 212, 416, 214, 215, 216, 217, 218, 219, 220, 431, 771, 223,
				224, 225, 226, 259, 228, 229, 230, 231, 232, 233, 234, 235, 769, 237, 238, 239,
				273, 241, 803, 243, 244, 417, 246, 247, 248, 249, 250, 251, 252, 432, 8363, 255,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				8364: 128, 129: 129, 8218: 130, 402: 131, 8222: 132, 8230: 133, 8224: 134, 8225: 135, 710: 136, 8240: 137, 138: 138, 8249: 139, 338: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 8216: 145, 8217: 146, 8220: 147, 8221: 148, 8226: 149, 8211: 150, 8212: 151, 732: 152, 8482: 153, 154: 154, 8250: 155, 339: 156, 157: 157, 158: 158, 376: 159,
				160: 160, 161: 161, 162: 162, 163: 163, 164: 164, 165: 165, 166: 166, 167: 167, 168: 168, 169: 169, 170: 170, 171: 171, 172: 172, 173: 173, 174: 174, 175: 175,
				176: 176, 177: 177, 178: 178, 179: 179, 180: 180, 181: 181, 182: 182, 183: 183, 184: 184, 185: 185, 186: 186, 187: 187, 188: 188, 189: 189, 190: 190, 191: 191,
				192: 192, 193: 193, 194: 194, 258: 195, 196: 196, 197: 197, 198: 198, 199: 199, 200: 200, 201: 201, 202: 202, 203: 203, 768: 204, 205: 205, 206: 206, 207: 207,
				272: 208, 209: 209, 777: 210, 211: 211, 212: 212, 416: 213, 214: 214, 215: 215, 216: 216, 217: 217, 218: 218, 219: 219, 220: 220, 431: 221, 771: 222, 223: 223,
				224: 224, 225: 225, 226: 226, 259: 227, 228: 228, 229: 229, 230: 230, 231: 231, 232: 232, 233: 233, 234: 234, 235: 235, 769: 236, 237: 237, 238: 238, 239: 239,
				273: 240, 241: 241, 803: 242, 243: 243, 244: 244, 417: 245, 246: 246, 247: 247, 248: 248, 249: 249, 250: 250, 251: 251, 252: 252, 432: 253, 8363: 254, 255: 255,
				65281: 33, 65282: 34, 65283: 35, 65284: 36, 65285: 37, 65286: 38, 65287: 39, 65288: 40, 65289: 41, 65290: 42, 65291: 43, 65292: 44, 65293: 45, 65294: 46, 65295: 47, 65296: 48,
				65297: 49, 65298: 50, 65299: 51, 65300: 52, 65301: 53, 65302: 54, 65303: 55, 65304: 56, 65305: 57, 65306: 58, 65307: 59, 65308: 60, 65309: 61, 65310: 62, 65312: 64, 65313: 65,
				65314: 66, 65315: 67, 65316: 68, 65317: 69, 65318: 70, 65319: 71, 65320: 72, 65321: 73, 65322: 74, 65323: 75, 65324: 76, 65325: 77, 65326: 78, 65327: 79, 65328: 80, 65329: 81,
				65330: 82, 65331: 83, 65332: 84, 65333: 85, 65334: 86, 65335: 87, 65336: 88, 65337: 89, 65338: 90, 65339: 91, 65340: 92, 65341: 93, 65342: 94, 65343: 95, 65344: 96, 65345: 97,
				65346: 98, 65347: 99, 65348: 100, 65349: 101, 65350: 102, 65351: 103, 65352: 104, 65353: 105, 65354: 106, 65355: 107, 65356: 108, 65357: 109, 65358: 110, 65359: 111, 65360: 112, 65361: 113,
				65362: 114, 65363: 115, 65364: 116, 65365: 117, 65366: 118, 65367: 119, 65368: 120, 65369: 121, 65370: 122, 65371: 123, 65372: 124, 65373: 125, 65374: 126,
			},
		}
	case 0x2e: // 46
		return &StringConverter{
			LangID:    46,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  191,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 161, 162, 163, 8364, 165, 352, 167, 353, 169, 170, 171, 172, 173, 174, 175,
				176, 177, 178, 179, 381, 181, 182, 183, 382, 185, 186, 187, 338, 339, 376, 191,
				192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
				208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
				224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
				240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				128: 128, 129: 129, 130: 130, 131: 131, 132: 132, 133: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 145: 145, 146: 146, 147: 147, 148: 148, 149: 149, 150: 150, 151: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 161: 161, 162: 162, 163: 163, 8364: 164, 165: 165, 352: 166, 167: 167, 353: 168, 169: 169, 170: 170, 171: 171, 172: 172, 173: 173, 174: 174, 175: 175,
				176: 176, 177: 177, 178: 178, 179: 179, 381: 180, 181: 181, 182: 182, 183: 183, 382: 184, 185: 185, 186: 186, 187: 187, 338: 188, 339: 189, 376: 190, 191: 191,
				192: 192, 193: 193, 194: 194, 195: 195, 196: 196, 197: 197, 198: 198, 199: 199, 200: 200, 201: 201, 202: 202, 203: 203, 204: 204, 205: 205, 206: 206, 207: 207,
				208: 208, 209: 209, 210: 210, 211: 211, 212: 212, 213: 213, 214: 214, 215: 215, 216: 216, 217: 217, 218: 218, 219: 219, 220: 220, 221: 221, 222: 222, 223: 223,
				224: 224, 225: 225, 226: 226, 227: 227, 228: 228, 229: 229, 230: 230, 231: 231, 232: 232, 233: 233, 234: 234, 235: 235, 236: 236, 237: 237, 238: 238, 239: 239,
				240: 240, 241: 241, 242: 242, 243: 243, 244: 244, 245: 245, 246: 246, 247: 247, 248: 248, 249: 249, 250: 250, 251: 251, 252: 252, 253: 253, 254: 254, 255: 255,
				8216: 96, 8213: 45, 63742: 183, 8248: 94, 8764: 126, 63741: 102, 8356: 76, 946: 223,
			},
		}
	case 0x2f: // 47
		return &StringConverter{
			LangID:    47,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 8221, 162, 163, 164, 8222, 166, 167, 216, 169, 342, 171, 172, 173, 174, 198,
				176, 177, 178, 179, 8220, 181, 182, 183, 248, 185, 343, 187, 188, 189, 190, 230,
				260, 302, 256, 262, 196, 197, 280, 274, 268, 201, 377, 278, 290, 310, 298, 315,
				352, 323, 325, 211, 332, 213, 214, 215, 370, 321, 346, 362, 220, 379, 381, 223,
				261, 303, 257, 263, 228, 229, 281, 275, 269, 233, 378, 279, 291, 311, 299, 316,
				353, 324, 326, 243, 333, 245, 246, 247, 371, 322, 347, 363, 252, 380, 382, 8217,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				128: 128, 129: 129, 130: 130, 131: 131, 132: 132, 133: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 145: 145, 146: 146, 147: 147, 148: 148, 149: 149, 150: 150, 151: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 8221: 161, 162: 162, 163: 163, 164: 164, 8222: 165, 166: 166, 167: 167, 216: 168, 169: 169, 342: 170, 171: 171, 172: 172, 173: 173, 174: 174, 198: 175,
				176: 176, 177: 177, 178: 178, 179: 179, 8220: 180, 181: 181, 182: 182, 183: 183, 248: 184, 185: 185, 343: 186, 187: 187, 188: 188, 189: 189, 190: 190, 230: 191,
				260: 192, 302: 193, 256: 194, 262: 195, 196: 196, 197: 197, 280: 198, 274: 199, 268: 200, 201: 201, 377: 202, 278: 203, 290: 204, 310: 205, 298: 206, 315: 207,
				352: 208, 323: 209, 325: 210, 211: 211, 332: 212, 213: 213, 214: 214, 215: 215, 370: 216, 321: 217, 346: 218, 362: 219, 220: 220, 379: 221, 381: 222, 223: 223,
				261: 224, 303: 225, 257: 226, 263: 227, 228: 228, 229: 229, 281: 230, 275: 231, 269: 232, 233: 233, 378: 234, 279: 235, 291: 236, 311: 237, 299: 238, 316: 239,
				353: 240, 324: 241, 326: 242, 243: 243, 333: 244, 245: 245, 246: 246, 247: 247, 371: 248, 322: 249, 347: 250, 363: 251, 252: 252, 380: 253, 382: 254, 8217: 255,
			},
		}
	case 0x30: // 48
		return &StringConverter{
			LangID:    48,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 7682, 7683, 163, 266, 267, 7690, 167, 7808, 169, 7810, 7691, 7922, 173, 174, 376,
				7710, 7711, 288, 289, 7744, 7745, 182, 7766, 7809, 7767, 7811, 7776, 7923, 7812, 7813, 7777,
				192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
				372, 209, 210, 211, 212, 213, 214, 7786, 216, 217, 218, 219, 220, 221, 374, 223,
				224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
				373, 241, 242, 243, 244, 245, 246, 7787, 248, 249, 250, 251, 252, 253, 375, 255,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				128: 128, 129: 129, 130: 130, 131: 131, 132: 132, 133: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 145: 145, 146: 146, 147: 147, 148: 148, 149: 149, 150: 150, 151: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 7682: 161, 7683: 162, 163: 163, 266: 164, 267: 165, 7690: 166, 167: 167, 7808: 168, 169: 169, 7810: 170, 7691: 171, 7922: 172, 173: 173, 174: 174, 376: 175,
				7710: 176, 7711: 177, 288: 178, 289: 179, 7744: 180, 7745: 181, 182: 182, 7766: 183, 7809: 184, 7767: 185, 7811: 186, 7776: 187, 7923: 188, 7812: 189, 7813: 190, 7777: 191,
				192: 192, 193: 193, 194: 194, 195: 195, 196: 196, 197: 197, 198: 198, 199: 199, 200: 200, 201: 201, 202: 202, 203: 203, 204: 204, 205: 205, 206: 206, 207: 207,
				372: 208, 209: 209, 210: 210, 211: 211, 212: 212, 213: 213, 214: 214, 7786: 215, 216: 216, 217: 217, 218: 218, 219: 219, 220: 220, 221: 221, 374: 222, 223: 223,
				224: 224, 225: 225, 226: 226, 227: 227, 228: 228, 229: 229, 230: 230, 231: 231, 232: 232, 233: 233, 234: 234, 235: 235, 236: 236, 237: 237, 238: 238, 239: 239,
				373: 240, 241: 241, 242: 242, 243: 243, 244: 244, 245: 245, 246: 246, 7787: 247, 248: 248, 249: 249, 250: 250, 251: 251, 252: 252, 253: 253, 375: 254, 255: 255,
			},
		}
	case 0x31: // 49
		return &StringConverter{
			LangID:    49,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
				144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
				160, 1106, 1107, 1105, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 173, 1118, 1119,
				8470, 1026, 1027, 1025, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 164, 1038, 1039,
				1102, 1072, 1073, 1094, 1076, 1077, 1092, 1075, 1093, 1080, 1081, 1082, 1083, 1084, 1085, 1086,
				1087, 1103, 1088, 1089, 1090, 1091, 1078, 1074, 1100, 1099, 1079, 1096, 1101, 1097, 1095, 1098,
				1070, 1040, 1041, 1062, 1044, 1045, 1060, 1043, 1061, 1048, 1049, 1050, 1051, 1052, 1053, 1054,
				1055, 1071, 1056, 1057, 1058, 1059, 1046, 1042, 1068, 1067, 1047, 1064, 1069, 1065, 1063, 1066,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				128: 128, 129: 129, 130: 130, 131: 131, 132: 132, 133: 133, 134: 134, 135: 135, 136: 136, 137: 137, 138: 138, 139: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 145: 145, 146: 146, 147: 147, 148: 148, 149: 149, 150: 150, 151: 151, 152: 152, 153: 153, 154: 154, 155: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 1106: 161, 1107: 162, 1105: 163, 1108: 164, 1109: 165, 1110: 166, 1111: 167, 1112: 168, 1113: 169, 1114: 170, 1115: 171, 1116: 172, 173: 173, 1118: 174, 1119: 175,
				8470: 176, 1026: 177, 1027: 178, 1025: 179, 1028: 180, 1029: 181, 1030: 182, 1031: 183, 1032: 184, 1033: 185, 1034: 186, 1035: 187, 1036: 188, 164: 189, 1038: 190, 1039: 191,
				1102: 192, 1072: 193, 1073: 194, 1094: 195, 1076: 196, 1077: 197, 1092: 198, 1075: 199, 1093: 200, 1080: 201, 1081: 202, 1082: 203, 1083: 204, 1084: 205, 1085: 206, 1086: 207,
				1087: 208, 1103: 209, 1088: 210, 1089: 211, 1090: 212, 1091: 213, 1078: 214, 1074: 215, 1100: 216, 1099: 217, 1079: 218, 1096: 219, 1101: 220, 1097: 221, 1095: 222, 1098: 223,
				1070: 224, 1040: 225, 1041: 226, 1062: 227, 1044: 228, 1045: 229, 1060: 230, 1043: 231, 1061: 232, 1048: 233, 1049: 234, 1050: 235, 1051: 236, 1052: 237, 1053: 238, 1054: 239,
				1055: 240, 1071: 241, 1056: 242, 1057: 243, 1058: 244, 1059: 245, 1046: 246, 1042: 247, 1068: 248, 1067: 249, 1047: 250, 1064: 251, 1069: 252, 1065: 253, 1063: 254, 1066: 255,
			},
		}
	case 0x32: // 50
		return &StringConverter{
			LangID:    50,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  191,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				8199, 192, 193, 194, 195, 196, 197, 199, 200, 201, 202, 203, 204, 205, 206, 207,
				208, 209, 210, 211, 212, 213, 214, 217, 218, 219, 220, 221, 222, 181, 215, 247,
				169, 161, 162, 163, 8260, 165, 402, 167, 164, 8217, 8220, 171, 8249, 8250, 64257, 64258,
				174, 8211, 8224, 8225, 183, 166, 182, 8226, 8218, 8222, 8221, 187, 8230, 8240, 172, 191,
				185, 96, 180, 710, 126, 713, 728, 729, 168, 178, 730, 184, 179, 733, 731, 711,
				8213, 177, 188, 189, 190, 224, 225, 226, 227, 228, 229, 231, 232, 233, 234, 235,
				236, 198, 237, 170, 238, 239, 240, 241, 321, 216, 338, 186, 242, 243, 244, 245,
				246, 230, 249, 250, 251, 305, 252, 253, 322, 248, 339, 223, 254, 255, 65535, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 193, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 196, 127: 127,
				8199: 128, 192: 129, 193: 130, 194: 131, 195: 132, 196: 133, 197: 134, 199: 135, 200: 136, 201: 137, 202: 138, 203: 139, 204: 140, 205: 141, 206: 142, 207: 143,
				208: 144, 209: 145, 210: 146, 211: 147, 212: 148, 213: 149, 214: 150, 217: 151, 218: 152, 219: 153, 220: 154, 221: 155, 222: 156, 181: 157, 215: 158, 247: 159,
				169: 160, 161: 161, 162: 162, 163: 163, 8260: 164, 165: 165, 402: 166, 167: 167, 164: 168, 8217: 169, 8220: 170, 171: 171, 8249: 172, 8250: 173, 64257: 174, 64258: 175,
				174: 176, 8211: 177, 8224: 178, 8225: 179, 183: 180, 166: 181, 182: 182, 8226: 183, 8218: 184, 8222: 185, 8221: 186, 187: 187, 8230: 188, 8240: 189, 172: 190, 191: 191,
				185: 192, 180: 194, 710: 195, 713: 197, 728: 198, 729: 199, 168: 200, 178: 201, 730: 202, 184: 203, 179: 204, 733: 205, 731: 206, 711: 207, 8213: 208, 177: 209,
				188: 210, 189: 211, 190: 212, 224: 213, 225: 214, 226: 215, 227: 216, 228: 217, 229: 218, 231: 219, 232: 220, 233: 221, 234: 222, 235: 223, 236: 224, 198: 225,
				237: 226, 170: 227, 238: 228, 239: 229, 240: 230, 241: 231, 321: 232, 216: 233, 338: 234, 186: 235, 242: 236, 243: 237, 244: 238, 245: 239, 246: 240, 230: 241,
				249: 242, 250: 243, 251: 244, 305: 245, 252: 246, 253: 247, 322: 248, 248: 249, 339: 250, 223: 251, 254: 252, 255: 253, 65535: 255, 176: 202, 175: 197, 160: 128,
				173: 45, 63741: 166,
			},
		}
	case 0x33: // 51
		return &StringConverter{
			LangID:    51,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				9472, 9474, 9484, 9488, 9492, 9496, 9500, 9508, 9516, 9524, 9532, 9600, 9604, 9608, 9612, 9616,
				9617, 9618, 9619, 8992, 9632, 8729, 8730, 8776, 8804, 8805, 160, 8993, 176, 178, 183, 247,
				9552, 9553, 9554, 1105, 1108, 9556, 1110, 1111, 9559, 9560, 9561, 9562, 9563, 1169, 9565, 9566,
				9567, 9568, 9569, 1025, 1028, 9571, 1030, 1031, 9574, 9575, 9576, 9577, 9578, 1168, 9580, 169,
				1102, 1072, 1073, 1094, 1076, 1077, 1092, 1075, 1093, 1080, 1081, 1082, 1083, 1084, 1085, 1086,
				1087, 1103, 1088, 1089, 1090, 1091, 1078, 1074, 1100, 1099, 1079, 1096, 1101, 1097, 1095, 1098,
				1070, 1040, 1041, 1062, 1044, 1045, 1060, 1043, 1061, 1048, 1049, 1050, 1051, 1052, 1053, 1054,
				1055, 1071, 1056, 1057, 1058, 1059, 1046, 1042, 1068, 1067, 1047, 1064, 1069, 1065, 1063, 1066,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				9472: 128, 9474: 129, 9484: 130, 9488: 131, 9492: 132, 9496: 133, 9500: 134, 9508: 135, 9516: 136, 9524: 137, 9532: 138, 9600: 139, 9604: 140, 9608: 141, 9612: 142, 9616: 143,
				9617: 144, 9618: 145, 9619: 146, 8992: 147, 9632: 148, 8729: 149, 8730: 150, 8776: 151, 8804: 152, 8805: 153, 160: 154, 8993: 155, 176: 156, 178: 157, 183: 158, 247: 159,
				9552: 160, 9553: 161, 9554: 162, 1105: 163, 1108: 164, 9556: 165, 1110: 166, 1111: 167, 9559: 168, 9560: 169, 9561: 170, 9562: 171, 9563: 172, 1169: 173, 9565: 174, 9566: 175,
				9567: 176, 9568: 177, 9569: 178, 1025: 179, 1028: 180, 9571: 181, 1030: 182, 1031: 183, 9574: 184, 9575: 185, 9576: 186, 9577: 187, 9578: 188, 1168: 189, 9580: 190, 169: 191,
				1102: 192, 1072: 193, 1073: 194, 1094: 195, 1076: 196, 1077: 197, 1092: 198, 1075: 199, 1093: 200, 1080: 201, 1081: 202, 1082: 203, 1083: 204, 1084: 205, 1085: 206, 1086: 207,
				1087: 208, 1103: 209, 1088: 210, 1089: 211, 1090: 212, 1091: 213, 1078: 214, 1074: 215, 1100: 216, 1099: 217, 1079: 218, 1096: 219, 1101: 220, 1097: 221, 1095: 222, 1098: 223,
				1070: 224, 1040: 225, 1041: 226, 1062: 227, 1044: 228, 1045: 229, 1060: 230, 1043: 231, 1061: 232, 1048: 233, 1049: 234, 1050: 235, 1051: 236, 1052: 237, 1053: 238, 1054: 239,
				1055: 240, 1071: 241, 1056: 242, 1057: 243, 1058: 244, 1059: 245, 1046: 246, 1042: 247, 1068: 248, 1067: 249, 1047: 250, 1064: 251, 1069: 252, 1065: 253, 1063: 254, 1066: 255,
			},
		}
	case 0x34: // 52
		return &StringConverter{
			LangID:    52,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
				176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
				192, 193, 194, 195, 196, 197, 399, 199, 200, 201, 202, 203, 204, 205, 206, 207,
				286, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 304, 350, 223,
				224, 225, 226, 227, 228, 229, 601, 231, 232, 233, 234, 235, 236, 237, 238, 239,
				287, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 305, 351, 255,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 159, 160: 160, 161: 161, 162: 162, 163: 163, 164: 164, 165: 165, 166: 166, 167: 167, 168: 168, 169: 169, 170: 170, 171: 171, 172: 172, 173: 173, 174: 174,
				175: 175, 176: 176, 177: 177, 178: 178, 179: 179, 180: 180, 181: 181, 182: 182, 183: 183, 184: 184, 185: 185, 186: 186, 187: 187, 188: 188, 189: 189, 190: 190,
				191: 191, 192: 192, 193: 193, 194: 194, 195: 195, 196: 196, 197: 197, 399: 198, 199: 199, 200: 200, 201: 201, 202: 202, 203: 203, 204: 204, 205: 205, 206: 206,
				207: 207, 286: 208, 209: 209, 210: 210, 211: 211, 212: 212, 213: 213, 214: 214, 215: 215, 216: 216, 217: 217, 218: 218, 219: 219, 220: 220, 304: 221, 350: 222,
				223: 223, 224: 224, 225: 225, 226: 226, 227: 227, 228: 228, 229: 229, 601: 230, 231: 231, 232: 232, 233: 233, 234: 234, 235: 235, 236: 236, 237: 237, 238: 238,
				239: 239, 287: 240, 241: 241, 242: 242, 243: 243, 244: 244, 245: 245, 246: 246, 247: 247, 248: 248, 249: 249, 250: 250, 251: 251, 252: 252, 305: 253, 351: 254,
				255: 255, 8216: 96, 376: 89, 946: 223, 8213: 45, 8248: 94, 8356: 76, 8764: 126, 63736: 105, 63738: 73, 63741: 102, 63742: 183,
			},
		}
	case 0x3d: // 61
		return &StringConverter{
			LangID:    61,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 233, 226, 65535, 224, 65535, 231, 234, 235, 232, 239, 238, 65535, 65535, 65535,
				65535, 65535, 65535, 244, 65535, 65535, 251, 249, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				160, 65535, 65535, 65535, 164, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 1548, 173, 171, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 1563, 65535, 65535, 65535, 1567,
				65535, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583,
				1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 65535, 65535, 65535, 65535, 65535,
				1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 1611, 1612, 1613, 1614, 1615,
				1616, 1617, 1618, 63731, 64606, 64607, 64608, 64609, 64610, 65535, 65535, 65535, 956, 163, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 233: 130, 226: 131, 224: 133, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 244: 147, 251: 150, 249: 151, 160: 160, 164: 164, 1548: 172,
				173: 173, 171: 174, 187: 175, 1563: 187, 1567: 191, 1569: 193, 1570: 194, 1571: 195, 1572: 196, 1573: 197, 1574: 198, 1575: 199, 1576: 200, 1577: 201, 1578: 202, 1579: 203,
				1580: 204, 1581: 205, 1582: 206, 1583: 207, 1584: 208, 1585: 209, 1586: 210, 1587: 211, 1588: 212, 1589: 213, 1590: 214, 1591: 215, 1592: 216, 1593: 217, 1594: 218, 1600: 224,
				1601: 225, 1602: 226, 1603: 227, 1604: 228, 1605: 229, 1606: 230, 1607: 231, 1608: 232, 1609: 233, 1610: 234, 1611: 235, 1612: 236, 1613: 237, 1614: 238, 1615: 239, 1616: 240,
				1617: 241, 1618: 242, 63731: 243, 64606: 244, 64607: 245, 64608: 246, 64609: 247, 64610: 248, 956: 252, 163: 253, 8718: 254,
			},
		}
	case 0x46: // 70
		return &StringConverter{
			LangID:    70,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  123,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 1617, 65535, 1600, 65535, 1569, 1570, 65535, 1571, 162, 46, 60, 40, 43, 124,
				38, 65535, 1572, 65535, 65535, 1574, 1575, 65535, 65535, 1576, 33, 36, 42, 41, 59, 172,
				45, 47, 1577, 65535, 1578, 65535, 1579, 65535, 1580, 65535, 166, 44, 37, 95, 62, 63,
				1581, 65535, 1582, 1583, 1584, 1585, 1586, 65535, 1587, 1548, 58, 35, 64, 39, 61, 34,
				65535, 97, 98, 99, 100, 101, 102, 103, 104, 105, 1588, 65535, 1589, 65535, 1590, 1591,
				1592, 106, 107, 108, 109, 110, 111, 112, 113, 114, 65535, 65535, 1593, 65535, 65535, 65535,
				1594, 247, 115, 116, 117, 118, 119, 120, 121, 122, 65535, 65535, 1601, 65535, 1602, 65535,
				1603, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 1604, 65535, 1605, 65535, 1606, 65535,
				1563, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 1607, 65535, 65535, 65535, 1608,
				1567, 74, 75, 76, 77, 78, 79, 80, 81, 82, 1609, 65535, 65535, 65535, 1610, 65535,
				215, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 65535, 65535, 65535, 65535, 65535, 65535,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65535, 65535, 65535, 65535, 65535, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				1617: 66, 65535: 254, 1600: 68, 1569: 70, 1570: 71, 1571: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 1572: 82, 1574: 85, 1575: 86,
				1576: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 172: 95, 45: 96, 47: 97, 1577: 98, 1578: 100, 1579: 102, 1580: 104, 166: 106, 44: 107, 37: 108,
				95: 109, 62: 110, 63: 111, 1581: 112, 1582: 114, 1583: 115, 1584: 116, 1585: 117, 1586: 118, 1587: 120, 1548: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126,
				34: 127, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 1588: 138, 1589: 140, 1590: 142, 1591: 143, 1592: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 1593: 156, 1594: 160, 247: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166,
				120: 167, 121: 168, 122: 169, 1601: 172, 1602: 174, 1603: 176, 1604: 186, 1605: 188, 1606: 190, 1563: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198,
				71: 199, 72: 200, 73: 201, 173: 202, 1607: 203, 1608: 207, 1567: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217,
				1609: 218, 1610: 222, 215: 224, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244,
				53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 159: 255,
			},
		}
	case 0x48: // 72
		return &StringConverter{
			LangID:    72,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 65535, 29, 30, 31,
				65535, 65535, 28, 65535, 65535, 65535, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 160, 1617, 1617, 1600, 160, 1569, 1570, 1570, 1571, 91, 46, 60, 40, 43, 33,
				38, 1571, 1572, 65535, 65535, 1574, 1575, 1575, 1576, 1576, 93, 36, 42, 41, 59, 94,
				45, 47, 1577, 1578, 1578, 1579, 1579, 1580, 1580, 1581, 166, 44, 37, 95, 62, 63,
				1581, 1582, 1582, 1583, 1584, 1585, 1586, 1587, 1587, 1548, 58, 35, 64, 39, 61, 34,
				1588, 97, 98, 99, 100, 101, 102, 103, 104, 105, 1588, 1589, 1589, 1590, 1590, 1591,
				1592, 106, 107, 108, 109, 110, 111, 112, 113, 114, 1593, 1593, 1593, 1593, 1594, 1594,
				1594, 126, 115, 116, 117, 118, 119, 120, 121, 122, 1594, 1601, 1601, 1602, 1602, 1603,
				1603, 1604, 65269, 65269, 65271, 65271, 65535, 65535, 65275, 65275, 1604, 1605, 1605, 1606, 1606, 1607,
				1563, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 1607, 65535, 1607, 65535, 1608,
				1567, 74, 75, 76, 77, 78, 79, 80, 81, 82, 1609, 1610, 1610, 1610, 1610, 48,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 49, 50, 65535, 51, 52, 53,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 54, 55, 56, 57, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 255, 9: 5, 127: 7, 10: 21, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18,
				19: 19, 8: 22, 24: 24, 25: 25, 29: 29, 30: 30, 31: 31, 28: 34, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 160: 69, 1617: 67, 1600: 68, 1569: 70, 1570: 72, 1571: 81, 91: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80,
				1572: 82, 1574: 85, 1575: 87, 1576: 89, 93: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97, 1577: 98, 1578: 100, 1579: 102, 1580: 104,
				1581: 112, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 1582: 114, 1583: 115, 1584: 116, 1585: 117, 1586: 118, 1587: 120, 1548: 121, 58: 122, 35: 123,
				64: 124, 39: 125, 61: 126, 34: 127, 1588: 138, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 1589: 140, 1590: 142,
				1591: 143, 1592: 144, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 1593: 157, 1594: 170, 126: 161, 115: 162, 116: 163,
				117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 1601: 172, 1602: 174, 1603: 176, 1604: 186, 65269: 179, 65271: 181, 65275: 185, 1605: 188, 1606: 190, 1607: 205,
				1563: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 1608: 207, 1567: 208, 74: 209, 75: 210, 76: 211,
				77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 1609: 208, 1610: 222, 48: 240, 92: 224, 247: 225, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230,
				88: 231, 89: 232, 90: 233, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 251, 55: 252, 56: 253, 57: 254, 179: 250, 96: 121, 123: 192, 124: 187,
				125: 208, 161: 170, 171: 138, 187: 139, 167: 181, 182: 182, 169: 180, 174: 175, 170: 154, 186: 155, 8216: 121, 181: 160, 183: 179, 176: 144, 175: 188, 185: 218,
				178: 234, 189: 184, 188: 183, 190: 185, 180: 190, 8248: 95, 8764: 161, 168: 189, 184: 157, 164: 159, 162: 176, 163: 177, 165: 178, 177: 143, 172: 186, 215: 191,
				192: 100, 193: 101, 194: 98, 195: 102, 196: 99, 197: 103, 198: 158, 199: 104, 208: 172, 200: 116, 201: 113, 202: 114, 203: 115, 204: 120, 205: 117, 206: 118,
				207: 119, 209: 105, 210: 237, 211: 238, 212: 235, 213: 239, 214: 236, 216: 128, 222: 174, 217: 253, 218: 254, 219: 251, 220: 252, 221: 173, 376: 232, 224: 68,
				225: 69, 226: 66, 227: 70, 228: 67, 229: 71, 230: 156, 231: 72, 240: 140, 232: 84, 233: 81, 234: 82, 235: 83, 236: 88, 237: 85, 238: 86, 239: 87,
				241: 73, 242: 205, 243: 206, 244: 203, 245: 207, 246: 204, 248: 112, 254: 142, 249: 221, 250: 222, 251: 219, 252: 220, 253: 141, 255: 223, 223: 89, 1612: 138,
			},
		}
	case 0x51: // 81
		return &StringConverter{
			LangID:    81,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  191,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 161, 162, 163, 65535, 165, 65535, 167, 164, 169, 170, 171, 65535, 65535, 65535, 65535,
				176, 177, 178, 179, 65535, 181, 182, 183, 65535, 185, 186, 187, 188, 189, 65535, 191,
				970, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927,
				65535, 928, 929, 931, 932, 933, 934, 935, 936, 937, 940, 941, 942, 943, 65535, 972,
				971, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959,
				65535, 960, 961, 963, 964, 965, 966, 967, 968, 969, 962, 973, 974, 900, 65535, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 161: 161, 162: 162, 163: 163, 165: 165, 167: 167, 164: 168, 169: 169, 170: 170, 171: 171, 176: 176, 177: 177, 178: 178, 179: 179, 181: 181, 182: 182,
				183: 183, 185: 185, 186: 186, 187: 187, 188: 188, 189: 189, 191: 191, 970: 192, 913: 193, 914: 194, 915: 195, 916: 196, 917: 197, 918: 198, 919: 199, 920: 200,
				921: 201, 922: 202, 923: 203, 924: 204, 925: 205, 926: 206, 927: 207, 928: 209, 929: 210, 931: 211, 932: 212, 933: 213, 934: 214, 935: 215, 936: 216, 937: 217,
				940: 218, 941: 219, 942: 220, 943: 221, 972: 223, 971: 224, 945: 225, 946: 226, 947: 227, 948: 228, 949: 229, 950: 230, 951: 231, 952: 232, 953: 233, 954: 234,
				955: 235, 956: 236, 957: 237, 958: 238, 959: 239, 960: 241, 961: 242, 963: 243, 964: 244, 965: 245, 966: 246, 967: 247, 968: 248, 969: 249, 962: 250, 973: 251,
				974: 252, 900: 253, 8213: 45, 160: 32, 173: 45, 166: 124, 902: 193, 904: 197, 905: 199, 906: 201, 908: 207, 910: 213, 911: 217, 938: 201, 939: 213, 912: 192,
				944: 224,
			},
		}
	case 0x52: // 82
		return &StringConverter{
			LangID:    82,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  191,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 161, 162, 163, 65535, 165, 65535, 167, 164, 169, 170, 171, 65535, 65535, 304, 65535,
				176, 177, 178, 179, 65535, 181, 182, 183, 65535, 185, 186, 187, 188, 189, 305, 191,
				192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
				286, 209, 210, 211, 212, 213, 214, 338, 216, 217, 218, 219, 220, 376, 350, 223,
				224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
				287, 241, 242, 243, 244, 245, 246, 339, 248, 249, 250, 251, 252, 255, 351, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 161: 161, 162: 162, 163: 163, 165: 165, 167: 167, 164: 168, 169: 169, 170: 170, 171: 171, 304: 174, 176: 176, 177: 177, 178: 178, 179: 179, 181: 181,
				182: 182, 183: 183, 185: 185, 186: 186, 187: 187, 188: 188, 189: 189, 305: 190, 191: 191, 192: 192, 193: 193, 194: 194, 195: 195, 196: 196, 197: 197, 198: 198,
				199: 199, 200: 200, 201: 201, 202: 202, 203: 203, 204: 204, 205: 205, 206: 206, 207: 207, 286: 208, 209: 209, 210: 210, 211: 211, 212: 212, 213: 213, 214: 214,
				338: 215, 216: 216, 217: 217, 218: 218, 219: 219, 220: 220, 376: 221, 350: 222, 223: 223, 224: 224, 225: 225, 226: 226, 227: 227, 228: 228, 229: 229, 230: 230,
				231: 231, 232: 232, 233: 233, 234: 234, 235: 235, 236: 236, 237: 237, 238: 238, 239: 239, 287: 240, 241: 241, 242: 242, 243: 243, 244: 244, 245: 245, 246: 246,
				339: 247, 248: 248, 249: 249, 250: 250, 251: 251, 252: 252, 255: 253, 351: 254, 8216: 96, 8213: 45, 175: 45, 160: 32, 173: 45, 166: 124, 180: 39, 8248: 94,
				8764: 126, 63741: 102, 8356: 76, 63738: 73, 221: 89, 63736: 105, 253: 121, 946: 223,
			},
		}
	case 0x5a: // 90
		return &StringConverter{
			LangID:    90,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 162, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 33, 36, 42, 41, 59, 172,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 166, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 91, 222, 174,
				94, 163, 165, 183, 169, 167, 182, 188, 189, 190, 221, 168, 175, 93, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 172: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 164: 159, 181: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 91: 173, 222: 174, 174: 175, 94: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 221: 186, 168: 187, 175: 188, 93: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255, 8216: 121, 8248: 176,
				8764: 161, 376: 232, 63743: 37,
			},
		}
	case 0x5b: // 91
		return &StringConverter{
			LangID:    91,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 91, 46, 60, 40, 43, 33,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 93, 36, 42, 41, 59, 172,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 124, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 94, 166, 175, 168, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 91: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 93: 90, 36: 91, 42: 92, 41: 93, 59: 94, 172: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 124: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 164: 159, 181: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 94: 186, 166: 187, 175: 188, 168: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255, 8216: 121, 8248: 186,
				8764: 161, 376: 232, 63743: 37,
			},
		}
	case 0x5c: // 92
		return &StringConverter{
			LangID:    92,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 162, 46, 60, 40, 43, 124,
				38, 1497, 1498, 1499, 1500, 1501, 1502, 1503, 1504, 1505, 33, 36, 42, 41, 59, 172,
				45, 47, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 166, 44, 37, 95, 62, 63,
				65535, 1514, 65535, 65535, 160, 65535, 65535, 65535, 819, 96, 58, 35, 64, 39, 61, 34,
				65535, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 65535, 65535, 65535, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 65535, 65535, 65535, 184, 65535, 164,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 65535, 65535, 65535, 65535, 65535, 174,
				94, 163, 165, 183, 169, 167, 182, 188, 189, 190, 91, 93, 175, 168, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 65535, 65535, 65535, 65535, 65535,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 65535, 65535, 65535, 65535, 65535,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 65535, 65535, 65535, 65535, 65535,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 65535, 65535, 65535, 65535, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 1488: 65,
				1489: 66, 1490: 67, 1491: 68, 1492: 69, 1493: 70, 1494: 71, 1495: 72, 1496: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 1497: 81,
				1498: 82, 1499: 83, 1500: 84, 1501: 85, 1502: 86, 1503: 87, 1504: 88, 1505: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 172: 95, 45: 96, 47: 97,
				1506: 98, 1507: 99, 1508: 100, 1509: 101, 1510: 102, 1511: 103, 1512: 104, 1513: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 65535: 254, 1514: 113,
				160: 116, 819: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135,
				104: 136, 105: 137, 171: 138, 187: 139, 177: 143, 176: 144, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 184: 157,
				164: 159, 181: 160, 126: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 174: 175, 94: 176, 163: 177, 165: 178, 183: 179,
				169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 91: 186, 93: 187, 175: 188, 168: 189, 180: 190, 215: 191, 123: 192, 65: 193, 66: 194, 67: 195,
				68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 125: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216,
				82: 217, 185: 218, 92: 224, 247: 225, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 48: 240, 49: 241, 50: 242,
				51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 159: 255,
			},
		}
	case 0x5d: // 93
		return &StringConverter{
			LangID:    93,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 123, 241, 199, 46, 60, 40, 43, 33,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 286, 304, 42, 41, 59, 94,
				45, 47, 194, 196, 192, 193, 195, 197, 91, 209, 351, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 305, 58, 214, 350, 39, 61, 220,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 125, 96, 166, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				181, 246, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 93, 36, 64, 174,
				162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 172, 124, 175, 168, 180, 215,
				231, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 126, 242, 243, 245,
				287, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 92, 249, 250, 255,
				252, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 35, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 34, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 123: 72, 241: 73, 199: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 286: 90, 304: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 91: 104, 209: 105, 351: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 305: 121, 58: 122, 214: 123, 350: 124, 39: 125, 61: 126, 220: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 125: 140, 96: 141, 166: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 164: 159, 181: 160, 246: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 93: 172, 36: 173, 64: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 168: 189, 180: 190, 215: 191, 231: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 126: 204, 242: 205, 243: 206, 245: 207, 287: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 92: 220, 249: 221, 250: 222, 255: 223, 252: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 35: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 34: 252, 217: 253, 218: 254, 159: 255, 63738: 201, 63736: 137,
			},
		}
	case 0x5e: // 94
		return &StringConverter{
			LangID:    94,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 222, 46, 60, 40, 43, 33,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 198, 36, 42, 41, 59, 214,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 166, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 240, 58, 35, 208, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 96, 253, 123, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 125, 184, 93, 164,
				181, 246, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 64, 221, 91, 174,
				162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 172, 124, 175, 168, 92, 215,
				254, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 126, 242, 243, 245,
				230, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				180, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 94, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 222: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 198: 90, 36: 91, 42: 92, 41: 93, 59: 94, 214: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 240: 121, 58: 122, 35: 123, 208: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 96: 140, 253: 141, 123: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 125: 156, 184: 157, 93: 158, 164: 159, 181: 160, 246: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 64: 172, 221: 173, 91: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 168: 189, 92: 190, 215: 191, 254: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 126: 204, 242: 205, 243: 206, 245: 207, 230: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 180: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 94: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255,
			},
		}
	case 0x5f: // 95
		return &StringConverter{
			LangID:    95,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 166, 91, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 93, 36, 42, 41, 59, 172,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 35, 241, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 209, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				181, 168, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 94, 33, 175, 126, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 166: 73, 91: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 93: 90, 36: 91, 42: 92, 41: 93, 59: 94, 172: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 35: 105, 241: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 209: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 164: 159, 181: 160, 168: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 94: 186, 33: 187, 175: 188, 126: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255,
			},
		}
	case 0x60: // 96
		return &StringConverter{
			LangID:    96,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 162, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 33, 36, 42, 41, 59, 94,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 166, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 91, 222, 174,
				172, 163, 165, 183, 169, 167, 182, 188, 189, 190, 221, 168, 175, 93, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 164: 159, 181: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 91: 173, 222: 174, 174: 175, 172: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 221: 186, 168: 187, 175: 188, 93: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255, 8216: 121, 8248: 176,
				8764: 161, 376: 232, 63743: 37,
			},
		}
	case 0x61: // 97
		return &StringConverter{
			LangID:    97,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 162, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 33, 36, 42, 41, 59, 172,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 166, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 8364,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 91, 222, 174,
				94, 163, 165, 183, 169, 167, 182, 188, 189, 190, 221, 168, 175, 93, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 172: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 8364: 159, 181: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 91: 173, 222: 174, 174: 175, 94: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 221: 186, 168: 187, 175: 188, 93: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255, 8216: 121, 8248: 176,
				8764: 161, 376: 232, 63743: 37,
			},
		}
	case 0x62: // 98
		return &StringConverter{
			LangID:    98,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 166, 91, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 93, 36, 42, 41, 59, 172,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 35, 241, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 209, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 8364,
				181, 168, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 94, 33, 175, 126, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 166: 73, 91: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 93: 90, 36: 91, 42: 92, 41: 93, 59: 94, 172: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 35: 105, 241: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 209: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 8364: 159, 181: 160, 168: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 94: 186, 33: 187, 175: 188, 126: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255,
			},
		}
	case 0x63: // 99
		return &StringConverter{
			LangID:    99,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 91, 46, 60, 40, 43, 33,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 93, 36, 42, 41, 59, 172,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 124, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 8364,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 94, 166, 175, 168, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 91: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 93: 90, 36: 91, 42: 92, 41: 93, 59: 94, 172: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 124: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 8364: 159, 181: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 94: 186, 166: 187, 175: 188, 168: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255, 8216: 121, 8248: 186,
				8764: 161, 376: 232, 63743: 25,
			},
		}
	case 0x64: // 100
		return &StringConverter{
			LangID:    100,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 162, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 33, 36, 42, 41, 59, 94,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 166, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 8364,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 91, 222, 174,
				172, 163, 165, 183, 169, 167, 182, 188, 189, 190, 221, 168, 175, 93, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 8364: 159, 181: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 91: 173, 222: 174, 174: 175, 172: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 221: 186, 168: 187, 175: 188, 93: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255, 8216: 121, 8248: 176,
				8764: 161, 376: 232, 63743: 37,
			},
		}
	case 0x65: // 101
		return &StringConverter{
			LangID:    101,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 221, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 33, 36, 42, 41, 59, 94,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 352, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 382, 198, 8364,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 91, 222, 174,
				162, 163, 165, 183, 169, 167, 182, 338, 339, 376, 172, 353, 175, 93, 381, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 221: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 352: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 382: 157, 198: 158, 8364: 159, 181: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 91: 173, 222: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 338: 183, 339: 184, 376: 232, 172: 186, 353: 187, 175: 188, 93: 189, 381: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255, 8216: 121, 8248: 186,
				8764: 161, 63743: 37,
			},
		}
	case 0x6e: // 110
		return &StringConverter{
			LangID:    110,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  32,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 176,
				192, 193, 194, 195, 196, 198, 216, 197, 913, 902, 914, 915, 199, 916, 917, 904,
				200, 201, 202, 203, 918, 919, 905, 920, 921, 906, 204, 205, 206, 207, 922, 923,
				224, 225, 226, 227, 228, 230, 248, 229, 945, 940, 946, 947, 231, 948, 949, 941,
				232, 233, 234, 235, 950, 951, 942, 952, 953, 943, 236, 237, 238, 239, 954, 955,
				924, 925, 209, 926, 927, 908, 210, 211, 212, 213, 214, 928, 929, 931, 932, 933,
				910, 939, 217, 218, 219, 220, 934, 935, 936, 937, 911, 912, 970, 944, 171, 187,
				956, 957, 241, 958, 959, 972, 242, 243, 244, 245, 246, 960, 961, 963, 964, 965,
				973, 971, 249, 250, 251, 252, 966, 967, 968, 969, 974, 962, 223, 161, 191, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 176: 127,
				192: 128, 193: 129, 194: 130, 195: 131, 196: 132, 198: 133, 216: 134, 197: 135, 913: 136, 902: 137, 914: 138, 915: 139, 199: 140, 916: 141, 917: 142, 904: 143,
				200: 144, 201: 145, 202: 146, 203: 147, 918: 148, 919: 149, 905: 150, 920: 151, 921: 152, 906: 153, 204: 154, 205: 155, 206: 156, 207: 157, 922: 158, 923: 159,
				224: 160, 225: 161, 226: 162, 227: 163, 228: 164, 230: 165, 248: 166, 229: 167, 945: 168, 940: 169, 946: 170, 947: 171, 231: 172, 948: 173, 949: 174, 941: 175,
				232: 176, 233: 177, 234: 178, 235: 179, 950: 180, 951: 181, 942: 182, 952: 183, 953: 184, 943: 185, 236: 186, 237: 187, 238: 188, 239: 189, 954: 190, 955: 191,
				924: 192, 925: 193, 209: 194, 926: 195, 927: 196, 908: 197, 210: 198, 211: 199, 212: 200, 213: 201, 214: 202, 928: 203, 929: 204, 931: 205, 932: 206, 933: 207,
				910: 208, 939: 209, 217: 210, 218: 211, 219: 212, 220: 213, 934: 214, 935: 215, 936: 216, 937: 217, 911: 218, 912: 219, 970: 220, 944: 221, 171: 222, 187: 223,
				956: 224, 957: 225, 241: 226, 958: 227, 959: 228, 972: 229, 242: 230, 243: 231, 244: 232, 245: 233, 246: 234, 960: 235, 961: 236, 963: 237, 964: 238, 965: 239,
				973: 240, 971: 241, 249: 242, 250: 243, 251: 244, 252: 245, 966: 246, 967: 247, 968: 248, 969: 249, 974: 250, 962: 251, 223: 252, 161: 253, 191: 254, 65535: 255,
			},
		}
	case 0x71: // 113
		return &StringConverter{
			LangID:    113,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 902, 904, 905, 906, 908, 910, 176, 8, 9, 10, 11, 12, 13, 14, 164,
				16, 17, 18, 19, 182, 167, 163, 911, 8593, 8595, 8594, 8592, 203, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 239, 238, 236, 196, 197,
				201, 230, 198, 244, 246, 242, 251, 249, 913, 214, 220, 248, 945, 216, 940, 914,
				225, 237, 243, 250, 241, 209, 946, 915, 947, 916, 948, 917, 949, 941, 918, 950,
				919, 951, 942, 65535, 170, 193, 194, 192, 920, 952, 65535, 65535, 65535, 921, 938, 65535,
				65535, 186, 161, 191, 65535, 900, 227, 195, 65535, 65535, 953, 943, 970, 65535, 912, 922,
				954, 923, 202, 955, 924, 956, 205, 925, 957, 65535, 65535, 926, 958, 927, 959, 972,
				211, 223, 212, 928, 245, 213, 960, 929, 961, 218, 931, 962, 963, 932, 964, 933,
				939, 965, 973, 971, 944, 934, 966, 935, 967, 936, 183, 968, 937, 969, 974, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 902: 1, 904: 2, 905: 3, 906: 4, 908: 5, 910: 6, 176: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 164: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 182: 20, 167: 21, 163: 22, 911: 23, 8593: 24, 8595: 25, 8594: 26, 8592: 27, 203: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 252: 129, 233: 130, 226: 131, 228: 132, 224: 133, 229: 134, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 236: 141, 196: 142, 197: 143,
				201: 144, 230: 145, 198: 146, 244: 147, 246: 148, 242: 149, 251: 150, 249: 151, 913: 152, 214: 153, 220: 154, 248: 155, 945: 156, 216: 157, 940: 158, 914: 159,
				225: 160, 237: 161, 243: 162, 250: 163, 241: 164, 209: 165, 946: 166, 915: 167, 947: 168, 916: 169, 948: 170, 917: 171, 949: 172, 941: 173, 918: 174, 950: 175,
				919: 176, 951: 177, 942: 178, 65535: 255, 170: 180, 193: 181, 194: 182, 192: 183, 920: 184, 952: 185, 921: 189, 938: 190, 186: 193, 161: 194, 191: 195, 900: 197,
				227: 198, 195: 199, 953: 202, 943: 203, 970: 204, 912: 206, 922: 207, 954: 208, 923: 209, 202: 210, 955: 211, 924: 212, 956: 213, 205: 214, 925: 215, 957: 216,
				926: 219, 958: 220, 927: 221, 959: 222, 972: 223, 211: 224, 223: 225, 212: 226, 928: 227, 245: 228, 213: 229, 960: 230, 929: 231, 961: 232, 218: 233, 931: 234,
				962: 235, 963: 236, 932: 237, 964: 238, 933: 239, 939: 240, 965: 241, 973: 242, 971: 243, 944: 244, 934: 245, 966: 246, 935: 247, 967: 248, 936: 249, 183: 250,
				968: 251, 937: 252, 969: 253, 974: 254,
			},
		}
	case 0x72: // 114
		return &StringConverter{
			LangID:    114,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				258, 259, 260, 261, 262, 263, 266, 267, 272, 273, 276, 277, 278, 279, 280, 281,
				711, 183, 340, 341, 342, 343, 286, 287, 288, 289, 290, 501, 294, 295, 304, 305,
				310, 311, 300, 301, 302, 303, 330, 331, 732, 312, 8220, 63737, 334, 335, 326, 713,
				730, 323, 364, 365, 223, 324, 346, 347, 8216, 325, 8223, 63734, 350, 351, 321, 322,
				192, 193, 313, 315, 196, 338, 198, 199, 200, 201, 368, 203, 204, 205, 358, 207,
				208, 354, 210, 211, 377, 379, 214, 336, 216, 217, 218, 370, 220, 221, 222, 376,
				224, 225, 314, 316, 228, 339, 230, 231, 232, 233, 369, 235, 236, 237, 359, 239,
				240, 355, 242, 243, 378, 380, 246, 337, 248, 249, 250, 371, 252, 253, 254, 255,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				258: 128, 259: 129, 260: 130, 261: 131, 262: 132, 263: 133, 266: 134, 267: 135, 272: 136, 273: 137, 276: 138, 277: 139, 278: 140, 279: 141, 280: 142, 281: 143,
				711: 144, 183: 145, 340: 146, 341: 147, 342: 148, 343: 149, 286: 150, 287: 151, 288: 152, 289: 153, 290: 154, 501: 155, 294: 156, 295: 157, 304: 158, 305: 159,
				310: 160, 311: 161, 300: 162, 301: 163, 302: 164, 303: 165, 330: 166, 331: 167, 732: 168, 312: 169, 8220: 170, 63737: 171, 334: 172, 335: 173, 326: 174, 713: 175,
				730: 176, 323: 177, 364: 178, 365: 179, 223: 180, 324: 181, 346: 182, 347: 183, 8216: 184, 325: 185, 8223: 186, 63734: 187, 350: 188, 351: 189, 321: 190, 322: 191,
				192: 192, 193: 193, 313: 194, 315: 195, 196: 196, 338: 197, 198: 198, 199: 199, 200: 200, 201: 201, 368: 202, 203: 203, 204: 204, 205: 205, 358: 206, 207: 207,
				208: 208, 354: 209, 210: 210, 211: 211, 377: 212, 379: 213, 214: 214, 336: 215, 216: 216, 217: 217, 218: 218, 370: 219, 220: 220, 221: 221, 222: 222, 376: 223,
				224: 224, 225: 225, 314: 226, 316: 227, 228: 228, 339: 229, 230: 230, 231: 231, 232: 232, 233: 233, 369: 234, 235: 235, 236: 236, 237: 237, 359: 238, 239: 239,
				240: 240, 355: 241, 242: 242, 243: 243, 378: 244, 380: 245, 246: 246, 337: 247, 248: 248, 249: 249, 250: 250, 371: 251, 252: 252, 253: 253, 254: 254, 255: 255,
			},
		}
	case 0x8c: // 140
		return &StringConverter{
			LangID:    140,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055,
				1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071,
				1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087,
				1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103,
				9492, 9524, 9516, 9500, 9472, 9532, 9571, 9553, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 9488,
				9617, 9618, 9619, 9474, 9508, 8470, 167, 9559, 9565, 9496, 9484, 9608, 9604, 9612, 9616, 9600,
				945, 946, 915, 960, 931, 963, 956, 964, 934, 920, 937, 948, 8734, 966, 949, 8745,
				8801, 177, 8805, 8804, 8992, 8993, 247, 8776, 176, 183, 183, 8730, 8319, 178, 8718, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1040: 128, 1041: 129, 1042: 130, 1043: 131, 1044: 132, 1045: 133, 1046: 134, 1047: 135, 1048: 136, 1049: 137, 1050: 138, 1051: 139, 1052: 140, 1053: 141, 1054: 142, 1055: 143,
				1056: 144, 1057: 145, 1058: 146, 1059: 147, 1060: 148, 1061: 149, 1062: 150, 1063: 151, 1064: 152, 1065: 153, 1066: 154, 1067: 155, 1068: 156, 1069: 157, 1070: 158, 1071: 159,
				1072: 160, 1073: 161, 1074: 162, 1075: 163, 1076: 164, 1077: 165, 1078: 166, 1079: 167, 1080: 168, 1081: 169, 1082: 170, 1083: 171, 1084: 172, 1085: 173, 1086: 174, 1087: 175,
				1088: 176, 1089: 177, 1090: 178, 1091: 179, 1092: 180, 1093: 181, 1094: 182, 1095: 183, 1096: 184, 1097: 185, 1098: 186, 1099: 187, 1100: 188, 1101: 189, 1102: 190, 1103: 191,
				9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 9571: 198, 9553: 199, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 9488: 207,
				9617: 208, 9618: 209, 9619: 210, 9474: 211, 9508: 212, 8470: 213, 167: 214, 9559: 215, 9565: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 9612: 221, 9616: 222, 9600: 223,
				945: 224, 946: 225, 915: 226, 960: 227, 931: 228, 963: 229, 956: 230, 964: 231, 934: 232, 920: 233, 937: 234, 948: 235, 8734: 236, 966: 237, 949: 238, 8745: 239,
				8801: 240, 177: 241, 8805: 242, 8804: 243, 8992: 244, 8993: 245, 247: 246, 8776: 247, 176: 248, 183: 250, 8730: 251, 8319: 252, 178: 253, 8718: 254, 160: 255, 8226: 249,
				63742: 250,
			},
		}
	case 0x96: // 150
		return &StringConverter{
			LangID:    150,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 252, 233, 226, 228, 367, 263, 231, 322, 235, 336, 337, 238, 377, 196, 262,
				201, 313, 314, 244, 246, 317, 318, 346, 347, 214, 220, 356, 357, 321, 215, 269,
				225, 237, 243, 250, 260, 261, 381, 382, 280, 281, 172, 378, 268, 351, 171, 187,
				9617, 9618, 9619, 9474, 9508, 193, 194, 282, 350, 9571, 9553, 9559, 9565, 379, 380, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 258, 259, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 164,
				273, 272, 270, 203, 271, 327, 205, 206, 283, 9496, 9484, 9608, 9604, 354, 366, 9600,
				211, 223, 212, 323, 324, 328, 352, 353, 340, 218, 341, 368, 253, 221, 355, 180,
				173, 733, 731, 711, 728, 167, 247, 184, 176, 168, 729, 369, 344, 345, 9632, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 252: 129, 233: 130, 226: 131, 228: 132, 367: 133, 263: 134, 231: 135, 322: 136, 235: 137, 336: 138, 337: 139, 238: 140, 377: 141, 196: 142, 262: 143,
				201: 144, 313: 145, 314: 146, 244: 147, 246: 148, 317: 149, 318: 150, 346: 151, 347: 152, 214: 153, 220: 154, 356: 155, 357: 156, 321: 157, 215: 158, 269: 159,
				225: 160, 237: 161, 243: 162, 250: 163, 260: 164, 261: 165, 381: 166, 382: 167, 280: 168, 281: 169, 172: 170, 378: 171, 268: 172, 351: 173, 171: 174, 187: 175,
				9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 193: 181, 194: 182, 282: 183, 350: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 379: 189, 380: 190, 9488: 191,
				9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 258: 198, 259: 199, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 164: 207,
				273: 208, 272: 209, 270: 210, 203: 211, 271: 212, 327: 213, 205: 214, 206: 215, 283: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 354: 221, 366: 222, 9600: 223,
				211: 224, 223: 225, 212: 226, 323: 227, 324: 228, 328: 229, 352: 230, 353: 231, 340: 232, 218: 233, 341: 234, 368: 235, 253: 236, 221: 237, 355: 238, 180: 239,
				173: 240, 733: 241, 731: 242, 711: 243, 728: 244, 167: 245, 247: 246, 184: 247, 176: 248, 168: 249, 729: 250, 369: 251, 344: 252, 345: 253, 9632: 254, 160: 255,
			},
		}
	case 0x98: // 152
		return &StringConverter{
			LangID:    152,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055,
				1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071,
				1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087,
				9617, 9618, 9619, 9474, 9508, 9569, 9570, 9558, 9557, 9571, 9553, 9559, 9565, 9564, 9563, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 9566, 9567, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 9575,
				9576, 9572, 9573, 9561, 9560, 9554, 9555, 9579, 9578, 9496, 9484, 9608, 9604, 9612, 9616, 9600,
				1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103,
				1025, 1105, 1028, 1108, 1031, 1111, 1038, 1118, 176, 8729, 183, 8730, 8470, 164, 9632, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1040: 128, 1041: 129, 1042: 130, 1043: 131, 1044: 132, 1045: 133, 1046: 134, 1047: 135, 1048: 136, 1049: 137, 1050: 138, 1051: 139, 1052: 140, 1053: 141, 1054: 142, 1055: 143,
				1056: 144, 1057: 145, 1058: 146, 1059: 147, 1060: 148, 1061: 149, 1062: 150, 1063: 151, 1064: 152, 1065: 153, 1066: 154, 1067: 155, 1068: 156, 1069: 157, 1070: 158, 1071: 159,
				1072: 160, 1073: 161, 1074: 162, 1075: 163, 1076: 164, 1077: 165, 1078: 166, 1079: 167, 1080: 168, 1081: 169, 1082: 170, 1083: 171, 1084: 172, 1085: 173, 1086: 174, 1087: 175,
				9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 9569: 181, 9570: 182, 9558: 183, 9557: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 9564: 189, 9563: 190, 9488: 191,
				9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 9566: 198, 9567: 199, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 9575: 207,
				9576: 208, 9572: 209, 9573: 210, 9561: 211, 9560: 212, 9554: 213, 9555: 214, 9579: 215, 9578: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 9612: 221, 9616: 222, 9600: 223,
				1088: 224, 1089: 225, 1090: 226, 1091: 227, 1092: 228, 1093: 229, 1094: 230, 1095: 231, 1096: 232, 1097: 233, 1098: 234, 1099: 235, 1100: 236, 1101: 237, 1102: 238, 1103: 239,
				1025: 240, 1105: 241, 1028: 242, 1108: 243, 1031: 244, 1111: 245, 1038: 246, 1118: 247, 176: 248, 8729: 249, 183: 250, 8730: 251, 8470: 252, 164: 253, 9632: 254, 160: 32,
				173: 45,
			},
		}
	case 0x99: // 153
		return &StringConverter{
			LangID:    153,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 1066, 65535, 1098, 65535,
				8470, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 167, 8804, 65535, 8805, 65535,
				1070, 1040, 1041, 1062, 1044, 1045, 1060, 1043, 1061, 1048, 1049, 1050, 1051, 1052, 1053, 1054,
				1055, 1071, 1056, 1057, 1058, 1059, 1046, 1042, 1068, 1067, 1047, 1064, 1069, 1065, 1063, 65535,
				1102, 1072, 1073, 1094, 1076, 1077, 1092, 1075, 1093, 1080, 1081, 1082, 1083, 1084, 1085, 1086,
				1087, 1103, 1088, 1089, 1090, 1091, 1078, 1074, 1100, 1099, 1079, 1096, 1101, 1097, 1095, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 1066: 172, 1098: 174, 8470: 176, 167: 187, 8804: 188, 8805: 190, 1070: 192, 1040: 193, 1041: 194, 1062: 195, 1044: 196, 1045: 197, 1060: 198, 1043: 199, 1061: 200,
				1048: 201, 1049: 202, 1050: 203, 1051: 204, 1052: 205, 1053: 206, 1054: 207, 1055: 208, 1071: 209, 1056: 210, 1057: 211, 1058: 212, 1059: 213, 1046: 214, 1042: 215, 1068: 216,
				1067: 217, 1047: 218, 1064: 219, 1069: 220, 1065: 221, 1063: 222, 1102: 224, 1072: 225, 1073: 226, 1094: 227, 1076: 228, 1077: 229, 1092: 230, 1075: 231, 1093: 232, 1080: 233,
				1081: 234, 1082: 235, 1083: 236, 1084: 237, 1085: 238, 1086: 239, 1087: 240, 1103: 241, 1088: 242, 1089: 243, 1090: 244, 1091: 245, 1078: 246, 1074: 247, 1100: 248, 1099: 249,
				1079: 250, 1096: 251, 1101: 252, 1097: 253, 1095: 254, 8216: 96, 160: 32, 173: 45, 180: 39, 8248: 94, 8764: 126,
			},
		}
	case 0x9a: // 154
		return &StringConverter{
			LangID:    154,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502, 1503,
				1504, 1505, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 162, 163, 165, 8359, 402,
				225, 237, 243, 250, 241, 209, 170, 186, 191, 8976, 172, 189, 188, 161, 171, 187,
				9617, 9618, 9619, 9474, 9508, 9569, 9570, 9558, 9557, 9571, 9553, 9559, 9565, 9564, 9563, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 9566, 9567, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 9575,
				9576, 9572, 9573, 9561, 9560, 9554, 9555, 9579, 9578, 9496, 9484, 9608, 9604, 9612, 9616, 9600,
				945, 223, 915, 960, 931, 963, 956, 964, 934, 920, 937, 948, 8734, 966, 949, 8745,
				8801, 177, 8805, 8804, 8992, 8993, 247, 8776, 176, 8729, 183, 8730, 8319, 178, 8718, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1488: 128, 1489: 129, 1490: 130, 1491: 131, 1492: 132, 1493: 133, 1494: 134, 1495: 135, 1496: 136, 1497: 137, 1498: 138, 1499: 139, 1500: 140, 1501: 141, 1502: 142, 1503: 143,
				1504: 144, 1505: 145, 1506: 146, 1507: 147, 1508: 148, 1509: 149, 1510: 150, 1511: 151, 1512: 152, 1513: 153, 1514: 154, 162: 155, 163: 156, 165: 157, 8359: 158, 402: 159,
				225: 160, 237: 161, 243: 162, 250: 163, 241: 164, 209: 165, 170: 166, 186: 167, 191: 168, 8976: 169, 172: 170, 189: 171, 188: 172, 161: 173, 171: 174, 187: 175,
				9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 9569: 181, 9570: 182, 9558: 183, 9557: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 9564: 189, 9563: 190, 9488: 191,
				9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 9566: 198, 9567: 199, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 9575: 207,
				9576: 208, 9572: 209, 9573: 210, 9561: 211, 9560: 212, 9554: 213, 9555: 214, 9579: 215, 9578: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 9612: 221, 9616: 222, 9600: 223,
				945: 224, 223: 225, 915: 226, 960: 227, 931: 228, 963: 229, 956: 230, 964: 231, 934: 232, 920: 233, 937: 234, 948: 235, 8734: 236, 966: 237, 949: 238, 8745: 239,
				8801: 240, 177: 241, 8805: 242, 8804: 243, 8992: 244, 8993: 245, 247: 246, 8776: 247, 176: 248, 8729: 249, 183: 250, 8730: 251, 8319: 252, 178: 253, 8718: 254, 160: 255,
				181: 230, 63741: 159,
			},
		}
	case 0x9b: // 155
		return &StringConverter{
			LangID:    155,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1106, 1026, 1107, 1027, 1105, 1025, 1108, 1028, 1109, 1029, 1110, 1030, 1111, 1031, 1112, 1032,
				1113, 1033, 1114, 1034, 1115, 1035, 1116, 1036, 1118, 1038, 1119, 1039, 1102, 1070, 1098, 1066,
				1072, 1040, 1073, 1041, 1094, 1062, 1076, 1044, 1077, 1045, 1092, 1060, 1075, 1043, 171, 187,
				65535, 65535, 65535, 65535, 65535, 1093, 1061, 1080, 1048, 65535, 65535, 65535, 65535, 1081, 1049, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 1082, 1050, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 164,
				1083, 1051, 1084, 1052, 1085, 1053, 1086, 1054, 1087, 65535, 65535, 65535, 65535, 1055, 1103, 65535,
				1071, 1088, 1056, 1089, 1057, 1090, 1058, 1091, 1059, 1078, 1046, 1074, 1042, 1100, 1068, 8470,
				173, 1099, 1067, 1079, 1047, 1096, 1064, 1101, 1069, 1097, 1065, 1095, 1063, 65535, 8718, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1106: 128, 1026: 129, 1107: 130, 1027: 131, 1105: 132, 1025: 133, 1108: 134, 1028: 135, 1109: 136, 1029: 137, 1110: 138, 1030: 139, 1111: 140, 1031: 141, 1112: 142, 1032: 143,
				1113: 144, 1033: 145, 1114: 146, 1034: 147, 1115: 148, 1035: 149, 1116: 150, 1036: 151, 1118: 152, 1038: 153, 1119: 154, 1039: 155, 1102: 156, 1070: 157, 1098: 158, 1066: 159,
				1072: 160, 1040: 161, 1073: 162, 1041: 163, 1094: 164, 1062: 165, 1076: 166, 1044: 167, 1077: 168, 1045: 169, 1092: 170, 1060: 171, 1075: 172, 1043: 173, 171: 174, 187: 175,
				65535: 253, 1093: 181, 1061: 182, 1080: 183, 1048: 184, 1081: 189, 1049: 190, 1082: 198, 1050: 199, 164: 207, 1083: 208, 1051: 209, 1084: 210, 1052: 211, 1085: 212, 1053: 213,
				1086: 214, 1054: 215, 1087: 216, 1055: 221, 1103: 222, 1071: 224, 1088: 225, 1056: 226, 1089: 227, 1057: 228, 1090: 229, 1058: 230, 1091: 231, 1059: 232, 1078: 233, 1046: 234,
				1074: 235, 1042: 236, 1100: 237, 1068: 238, 8470: 239, 173: 240, 1099: 241, 1067: 242, 1079: 243, 1047: 244, 1096: 245, 1064: 246, 1101: 247, 1069: 248, 1097: 249, 1065: 250,
				1095: 251, 1063: 252, 8718: 254, 160: 255,
			},
		}
	case 0x9c: // 156
		return &StringConverter{
			LangID:    156,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 239, 238, 305, 196, 197,
				201, 230, 198, 244, 246, 242, 251, 249, 304, 214, 220, 248, 163, 216, 350, 351,
				225, 237, 243, 250, 241, 209, 286, 287, 191, 174, 172, 189, 188, 161, 171, 187,
				9617, 9618, 9619, 9474, 9508, 193, 194, 192, 169, 9571, 9553, 9559, 9565, 162, 165, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 227, 195, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 164,
				186, 170, 202, 203, 200, 65535, 205, 206, 207, 9496, 9484, 9608, 9604, 166, 204, 9600,
				211, 223, 212, 210, 245, 213, 181, 65535, 215, 218, 219, 217, 236, 255, 175, 180,
				173, 177, 65535, 190, 182, 167, 247, 184, 176, 168, 183, 185, 179, 178, 9632, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 252: 129, 233: 130, 226: 131, 228: 132, 224: 133, 229: 134, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 305: 141, 196: 142, 197: 143,
				201: 144, 230: 145, 198: 146, 244: 147, 246: 148, 242: 149, 251: 150, 249: 151, 304: 152, 214: 153, 220: 154, 248: 155, 163: 156, 216: 157, 350: 158, 351: 159,
				225: 160, 237: 161, 243: 162, 250: 163, 241: 164, 209: 165, 286: 166, 287: 167, 191: 168, 174: 169, 172: 170, 189: 171, 188: 172, 161: 173, 171: 174, 187: 175,
				9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 193: 181, 194: 182, 192: 183, 169: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 162: 189, 165: 190, 9488: 191,
				9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 227: 198, 195: 199, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 164: 207,
				186: 208, 170: 209, 202: 210, 203: 211, 200: 212, 65535: 242, 205: 214, 206: 215, 207: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 166: 221, 204: 222, 9600: 223,
				211: 224, 223: 225, 212: 226, 210: 227, 245: 228, 213: 229, 181: 230, 215: 232, 218: 233, 219: 234, 217: 235, 236: 236, 255: 237, 175: 238, 180: 239, 173: 240,
				177: 241, 190: 243, 182: 244, 167: 245, 247: 246, 184: 247, 176: 248, 168: 249, 183: 250, 185: 251, 179: 252, 178: 253, 9632: 254, 160: 255, 8216: 96, 8213: 45,
				8248: 94, 8764: 126, 8356: 76, 63738: 73, 63736: 105,
			},
		}
	case 0x9e: // 158
		return &StringConverter{
			LangID:    158,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 12, 10, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055,
				1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071,
				65535, 176, 162, 163, 167, 183, 182, 1030, 174, 169, 8482, 1026, 1106, 1110, 1027, 1107,
				65535, 177, 8804, 8805, 165, 181, 65535, 1032, 1028, 1108, 1031, 1111, 1033, 1113, 1034, 1114,
				1112, 1029, 172, 65535, 402, 65535, 65535, 171, 187, 65535, 160, 1035, 1115, 1036, 1116, 1109,
				173, 8213, 65535, 65535, 65535, 65535, 247, 65535, 1038, 1118, 1039, 1119, 8470, 1025, 1105, 1103,
				1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087,
				1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 164,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 13: 10, 11: 11, 12: 12, 10: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1040: 128, 1041: 129, 1042: 130, 1043: 131, 1044: 132, 1045: 133, 1046: 134, 1047: 135, 1048: 136, 1049: 137, 1050: 138, 1051: 139, 1052: 140, 1053: 141, 1054: 142, 1055: 143,
				1056: 144, 1057: 145, 1058: 146, 1059: 147, 1060: 148, 1061: 149, 1062: 150, 1063: 151, 1064: 152, 1065: 153, 1066: 154, 1067: 155, 1068: 156, 1069: 157, 1070: 158, 1071: 159,
				65535: 215, 176: 161, 162: 162, 163: 163, 167: 164, 183: 165, 182: 166, 1030: 167, 174: 168, 169: 169, 8482: 170, 1026: 171, 1106: 172, 1110: 173, 1027: 174, 1107: 175,
				177: 177, 8804: 178, 8805: 179, 165: 180, 181: 181, 1032: 183, 1028: 184, 1108: 185, 1031: 186, 1111: 187, 1033: 188, 1113: 189, 1034: 190, 1114: 191, 1112: 192, 1029: 193,
				172: 194, 402: 196, 171: 199, 187: 200, 160: 202, 1035: 203, 1115: 204, 1036: 205, 1116: 206, 1109: 207, 173: 208, 8213: 209, 247: 214, 1038: 216, 1118: 217, 1039: 218,
				1119: 219, 8470: 220, 1025: 221, 1105: 222, 1103: 223, 1072: 224, 1073: 225, 1074: 226, 1075: 227, 1076: 228, 1077: 229, 1078: 230, 1079: 231, 1080: 232, 1081: 233, 1082: 234,
				1083: 235, 1084: 236, 1085: 237, 1086: 238, 1087: 239, 1088: 240, 1089: 241, 1090: 242, 1091: 243, 1092: 244, 1093: 245, 1094: 246, 1095: 247, 1096: 248, 1097: 249, 1098: 250,
				1099: 251, 1100: 252, 1101: 253, 1102: 254, 164: 255, 63741: 196,
			},
		}
	case 0x9f: // 159
		return &StringConverter{
			LangID:    159,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055,
				1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071,
				65535, 176, 162, 163, 167, 183, 182, 1030, 174, 169, 8482, 1026, 1106, 1110, 1027, 1107,
				65535, 177, 8804, 8805, 165, 181, 65535, 1032, 1028, 1108, 1031, 1111, 1033, 1113, 1034, 1114,
				1112, 1029, 172, 65535, 402, 65535, 65535, 171, 187, 65535, 160, 1035, 1115, 1036, 1116, 1109,
				173, 8213, 65535, 65535, 65535, 65535, 247, 65535, 1038, 1118, 1039, 1119, 8470, 1025, 1105, 1103,
				1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087,
				1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 164,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1040: 128, 1041: 129, 1042: 130, 1043: 131, 1044: 132, 1045: 133, 1046: 134, 1047: 135, 1048: 136, 1049: 137, 1050: 138, 1051: 139, 1052: 140, 1053: 141, 1054: 142, 1055: 143,
				1056: 144, 1057: 145, 1058: 146, 1059: 147, 1060: 148, 1061: 149, 1062: 150, 1063: 151, 1064: 152, 1065: 153, 1066: 154, 1067: 155, 1068: 156, 1069: 157, 1070: 158, 1071: 159,
				65535: 215, 176: 161, 162: 162, 163: 163, 167: 164, 183: 165, 182: 166, 1030: 167, 174: 168, 169: 169, 8482: 170, 1026: 171, 1106: 172, 1110: 173, 1027: 174, 1107: 175,
				177: 177, 8804: 178, 8805: 179, 165: 180, 181: 181, 1032: 183, 1028: 184, 1108: 185, 1031: 186, 1111: 187, 1033: 188, 1113: 189, 1034: 190, 1114: 191, 1112: 192, 1029: 193,
				172: 194, 402: 196, 171: 199, 187: 200, 160: 202, 1035: 203, 1115: 204, 1036: 205, 1116: 206, 1109: 207, 173: 208, 8213: 209, 247: 214, 1038: 216, 1118: 217, 1039: 218,
				1119: 219, 8470: 220, 1025: 221, 1105: 222, 1103: 223, 1072: 224, 1073: 225, 1074: 226, 1075: 227, 1076: 228, 1077: 229, 1078: 230, 1079: 231, 1080: 232, 1081: 233, 1082: 234,
				1083: 235, 1084: 236, 1085: 237, 1086: 238, 1087: 239, 1088: 240, 1089: 241, 1090: 242, 1091: 243, 1092: 244, 1093: 245, 1094: 246, 1095: 247, 1096: 248, 1097: 249, 1098: 250,
				1099: 251, 1100: 252, 1101: 253, 1102: 254, 164: 255, 63741: 196,
			},
		}
	case 0xa0: // 160
		return &StringConverter{
			LangID:    160,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 252, 233, 226, 227, 224, 193, 231, 234, 202, 232, 205, 212, 236, 195, 194,
				201, 192, 200, 244, 245, 242, 218, 249, 204, 213, 220, 162, 163, 217, 8359, 211,
				225, 237, 243, 250, 241, 209, 170, 186, 191, 210, 172, 189, 188, 161, 171, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				945, 223, 915, 960, 931, 963, 181, 964, 934, 920, 937, 948, 65535, 966, 949, 65535,
				65535, 177, 8805, 8804, 65535, 65535, 247, 65535, 176, 729, 183, 65535, 65535, 178, 8718, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 252: 129, 233: 130, 226: 131, 227: 132, 224: 133, 193: 134, 231: 135, 234: 136, 202: 137, 232: 138, 205: 139, 212: 140, 236: 141, 195: 142, 194: 143,
				201: 144, 192: 145, 200: 146, 244: 147, 245: 148, 242: 149, 218: 150, 249: 151, 204: 152, 213: 153, 220: 154, 162: 155, 163: 156, 217: 157, 8359: 158, 211: 159,
				225: 160, 237: 161, 243: 162, 250: 163, 241: 164, 209: 165, 170: 166, 186: 167, 191: 168, 210: 169, 172: 170, 189: 171, 188: 172, 161: 173, 171: 174, 187: 175,
				65535: 252, 945: 224, 223: 225, 915: 226, 960: 227, 931: 228, 963: 229, 181: 230, 964: 231, 934: 232, 920: 233, 937: 234, 948: 235, 966: 237, 949: 238, 177: 241,
				8805: 242, 8804: 243, 247: 246, 176: 248, 729: 249, 183: 250, 178: 253, 8718: 254, 160: 255, 169: 99, 174: 82, 8216: 96, 8213: 45, 173: 45, 180: 39, 8248: 94,
				8764: 126, 8356: 76, 215: 42, 196: 65, 197: 65, 203: 69, 206: 73, 207: 73, 214: 79, 216: 79, 219: 85, 221: 89, 228: 97, 229: 97, 235: 101, 238: 105,
				239: 105, 246: 111, 248: 111, 251: 117, 253: 121, 255: 121,
			},
		}
	case 0xa1: // 161
		return &StringConverter{
			LangID:    161,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 208, 240, 222, 196, 197,
				201, 230, 198, 244, 246, 254, 251, 221, 253, 214, 220, 248, 163, 216, 8359, 402,
				225, 237, 243, 250, 193, 205, 211, 218, 191, 65535, 172, 189, 188, 161, 171, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				945, 223, 915, 960, 931, 963, 956, 964, 934, 920, 937, 948, 65535, 966, 949, 65535,
				65535, 177, 8805, 8804, 65535, 65535, 247, 65535, 176, 729, 183, 65535, 65535, 178, 8718, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 252: 129, 233: 130, 226: 131, 228: 132, 224: 133, 229: 134, 231: 135, 234: 136, 235: 137, 232: 138, 208: 139, 240: 140, 222: 141, 196: 142, 197: 143,
				201: 144, 230: 145, 198: 146, 244: 147, 246: 148, 254: 149, 251: 150, 221: 151, 253: 152, 214: 153, 220: 154, 248: 155, 163: 156, 216: 157, 8359: 158, 402: 159,
				225: 160, 237: 161, 243: 162, 250: 163, 193: 164, 205: 165, 211: 166, 218: 167, 191: 168, 65535: 252, 172: 170, 189: 171, 188: 172, 161: 173, 171: 174, 187: 175,
				945: 224, 223: 225, 915: 226, 960: 227, 931: 228, 963: 229, 956: 230, 964: 231, 934: 232, 920: 233, 937: 234, 948: 235, 966: 237, 949: 238, 177: 241, 8805: 242,
				8804: 243, 247: 246, 176: 248, 729: 249, 183: 250, 178: 253, 8718: 254, 160: 255, 63741: 159,
			},
		}
	case 0xa2: // 162
		return &StringConverter{
			LangID:    162,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 256, 257, 201, 260, 214, 220, 225, 261, 268, 228, 269, 262, 263, 233, 377,
				378, 270, 237, 271, 274, 275, 278, 243, 279, 244, 246, 245, 250, 282, 283, 252,
				65535, 176, 280, 163, 167, 183, 182, 223, 174, 169, 8482, 281, 168, 8800, 65535, 302,
				303, 298, 8804, 8805, 299, 310, 948, 931, 322, 315, 316, 317, 318, 313, 314, 325,
				326, 323, 172, 65535, 324, 327, 916, 171, 187, 65535, 160, 328, 336, 213, 337, 332,
				65535, 8213, 8220, 8221, 8216, 8217, 247, 65535, 333, 340, 341, 344, 65535, 65535, 345, 342,
				343, 352, 65535, 65535, 353, 346, 347, 193, 356, 357, 205, 381, 382, 362, 211, 212,
				363, 366, 218, 367, 368, 369, 370, 371, 221, 253, 311, 379, 321, 380, 65535, 711,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 256: 129, 257: 130, 201: 131, 260: 132, 214: 133, 220: 134, 225: 135, 261: 136, 268: 137, 228: 138, 269: 139, 262: 140, 263: 141, 233: 142, 377: 143,
				378: 144, 270: 145, 237: 146, 271: 147, 274: 148, 275: 149, 278: 150, 243: 151, 279: 152, 244: 153, 246: 154, 245: 155, 250: 156, 282: 157, 283: 158, 252: 159,
				65535: 254, 176: 161, 280: 162, 163: 163, 167: 164, 183: 165, 182: 166, 223: 167, 174: 168, 169: 169, 8482: 170, 281: 171, 168: 172, 8800: 173, 302: 175, 303: 176,
				298: 177, 8804: 178, 8805: 179, 299: 180, 310: 181, 948: 182, 931: 183, 322: 184, 315: 185, 316: 186, 317: 187, 318: 188, 313: 189, 314: 190, 325: 191, 326: 192,
				323: 193, 172: 194, 324: 196, 327: 197, 916: 198, 171: 199, 187: 200, 160: 202, 328: 203, 336: 204, 213: 205, 337: 206, 332: 207, 8213: 209, 8220: 210, 8221: 211,
				8216: 212, 8217: 213, 247: 214, 333: 216, 340: 217, 341: 218, 344: 219, 345: 222, 342: 223, 343: 224, 352: 225, 353: 228, 346: 229, 347: 230, 193: 231, 356: 232,
				357: 233, 205: 234, 381: 235, 382: 236, 362: 237, 211: 238, 212: 239, 363: 240, 366: 241, 218: 242, 367: 243, 368: 244, 369: 245, 370: 246, 371: 247, 221: 248,
				253: 249, 311: 250, 379: 251, 321: 252, 380: 253, 711: 255,
			},
		}
	case 0xa3: // 163
		return &StringConverter{
			LangID:    163,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232,
				234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252,
				65535, 176, 162, 163, 167, 183, 182, 223, 174, 350, 8482, 180, 168, 8800, 381, 216,
				65535, 177, 8804, 8805, 165, 181, 948, 931, 928, 351, 65535, 170, 186, 8486, 382, 248,
				191, 161, 172, 65535, 402, 8764, 262, 171, 268, 65535, 160, 192, 195, 213, 338, 339,
				272, 8213, 8220, 8221, 8216, 8217, 247, 65535, 65535, 169, 65535, 65535, 65535, 65535, 198, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 263, 65535, 269, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				273, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 960, 65535, 65535, 65535, 65535, 230, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 197: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 227: 139, 229: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 237: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 242: 152, 244: 153, 246: 154, 245: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				65535: 255, 176: 161, 162: 162, 163: 163, 167: 164, 183: 165, 182: 166, 223: 167, 174: 168, 350: 169, 8482: 170, 180: 171, 168: 172, 8800: 173, 381: 174, 216: 175,
				177: 177, 8804: 178, 8805: 179, 165: 180, 181: 181, 948: 182, 931: 183, 928: 184, 351: 185, 170: 187, 186: 188, 8486: 189, 382: 190, 248: 191, 191: 192, 161: 193,
				172: 194, 402: 196, 8764: 197, 262: 198, 171: 199, 268: 200, 160: 202, 192: 203, 195: 204, 213: 205, 338: 206, 339: 207, 272: 208, 8213: 209, 8220: 210, 8221: 211,
				8216: 212, 8217: 213, 247: 214, 169: 217, 198: 222, 187: 223, 263: 230, 269: 232, 273: 240, 960: 249, 230: 254, 63741: 196,
			},
		}
	case 0xa4: // 164
		return &StringConverter{
			LangID:    164,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232,
				234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252,
				8224, 176, 162, 163, 167, 8226, 182, 223, 174, 169, 8482, 180, 168, 8800, 198, 216,
				8734, 177, 8804, 8805, 165, 181, 948, 931, 928, 960, 8747, 170, 186, 8486, 230, 248,
				191, 161, 172, 8730, 402, 8776, 8710, 171, 187, 8230, 160, 192, 195, 213, 338, 339,
				8211, 8213, 8220, 8221, 8216, 8217, 247, 9674, 255, 376, 286, 287, 304, 305, 350, 351,
				8225, 183, 8218, 8222, 8240, 194, 202, 193, 203, 200, 205, 206, 207, 204, 211, 212,
				65535, 210, 218, 219, 217, 65535, 710, 732, 713, 728, 729, 730, 184, 733, 731, 711,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 197: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 227: 139, 229: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 237: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 242: 152, 244: 153, 246: 154, 245: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				8224: 160, 176: 161, 162: 162, 163: 163, 167: 164, 8226: 165, 182: 166, 223: 167, 174: 168, 169: 169, 8482: 170, 180: 171, 168: 172, 8800: 173, 198: 174, 216: 175,
				8734: 176, 177: 177, 8804: 178, 8805: 179, 165: 180, 181: 181, 948: 182, 931: 183, 928: 184, 960: 185, 8747: 186, 170: 187, 186: 188, 8486: 189, 230: 190, 248: 191,
				191: 192, 161: 193, 172: 194, 8730: 195, 402: 196, 8776: 197, 8710: 198, 171: 199, 187: 200, 8230: 201, 160: 202, 192: 203, 195: 204, 213: 205, 338: 206, 339: 207,
				8211: 208, 8213: 209, 8220: 210, 8221: 211, 8216: 212, 8217: 213, 247: 214, 9674: 215, 255: 216, 376: 217, 286: 218, 287: 219, 304: 220, 305: 221, 350: 222, 351: 223,
				8225: 224, 183: 225, 8218: 226, 8222: 227, 8240: 228, 194: 229, 202: 230, 193: 231, 203: 232, 200: 233, 205: 234, 206: 235, 207: 236, 204: 237, 211: 238, 212: 239,
				65535: 245, 210: 241, 218: 242, 219: 243, 217: 244, 710: 246, 732: 247, 713: 248, 728: 249, 729: 250, 730: 251, 184: 252, 733: 253, 731: 254, 711: 255, 175: 248,
				173: 225, 166: 124, 8764: 197, 215: 42, 63738: 73, 63736: 105, 916: 198, 63740: 240, 63741: 196,
			},
		}
	case 0xa5: // 165
		return &StringConverter{
			LangID:    165,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  192,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 8764, 127,
				196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232,
				234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252,
				221, 176, 162, 163, 167, 65535, 182, 223, 174, 169, 8482, 180, 168, 8800, 198, 216,
				65535, 177, 8804, 8805, 165, 181, 948, 931, 928, 960, 65535, 170, 186, 8486, 230, 248,
				191, 161, 172, 65535, 402, 65535, 916, 171, 187, 65535, 160, 192, 195, 213, 338, 339,
				65535, 8213, 8220, 8221, 8216, 8217, 247, 65535, 255, 376, 65535, 164, 208, 240, 222, 254,
				253, 183, 65535, 65535, 65535, 194, 202, 193, 203, 200, 205, 206, 207, 204, 211, 212,
				65535, 210, 218, 219, 217, 305, 8248, 126, 713, 728, 729, 730, 184, 733, 731, 711,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 8764: 126, 127: 127,
				196: 128, 197: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 227: 139, 229: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 237: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 242: 152, 244: 153, 246: 154, 245: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				221: 160, 176: 161, 162: 162, 163: 163, 167: 164, 65535: 240, 182: 166, 223: 167, 174: 168, 169: 169, 8482: 170, 180: 171, 168: 172, 8800: 173, 198: 174, 216: 175,
				177: 177, 8804: 178, 8805: 179, 165: 180, 181: 181, 948: 182, 931: 183, 928: 184, 960: 185, 170: 187, 186: 188, 8486: 189, 230: 190, 248: 191, 191: 192, 161: 193,
				172: 194, 402: 196, 916: 198, 171: 199, 187: 200, 160: 202, 192: 203, 195: 204, 213: 205, 338: 206, 339: 207, 8213: 209, 8220: 210, 8221: 211, 8216: 212, 8217: 213,
				247: 214, 255: 216, 376: 217, 164: 219, 208: 220, 240: 221, 222: 222, 254: 223, 253: 224, 183: 225, 194: 229, 202: 230, 193: 231, 203: 232, 200: 233, 205: 234,
				206: 235, 207: 236, 204: 237, 211: 238, 212: 239, 210: 241, 218: 242, 219: 243, 217: 244, 305: 245, 8248: 246, 126: 247, 713: 248, 728: 249, 729: 250, 730: 251,
				184: 252, 733: 253, 731: 254, 711: 255, 173: 225, 166: 124, 215: 42, 63741: 196,
			},
		}
	case 0xa6: // 166
		return &StringConverter{
			LangID:    166,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232,
				234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252,
				65535, 8216, 8217, 163, 174, 247, 166, 167, 168, 169, 8482, 171, 172, 65535, 65535, 8213,
				176, 177, 178, 179, 900, 901, 902, 183, 904, 905, 906, 187, 908, 189, 910, 911,
				970, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927,
				928, 929, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943, 971,
				912, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959,
				960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 65535, 65535, 972, 973, 974, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 197: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 227: 139, 229: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 237: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 242: 152, 244: 153, 246: 154, 245: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				65535: 255, 8216: 161, 8217: 162, 163: 163, 174: 164, 247: 165, 166: 166, 167: 167, 168: 168, 169: 169, 8482: 170, 171: 171, 172: 172, 8213: 175, 176: 176, 177: 177,
				178: 178, 179: 179, 900: 180, 901: 181, 902: 182, 183: 183, 904: 184, 905: 185, 906: 186, 187: 187, 908: 188, 189: 189, 910: 190, 911: 191, 970: 192, 913: 193,
				914: 194, 915: 195, 916: 196, 917: 197, 918: 198, 919: 199, 920: 200, 921: 201, 922: 202, 923: 203, 924: 204, 925: 205, 926: 206, 927: 207, 928: 208, 929: 209,
				931: 210, 932: 211, 933: 212, 934: 213, 935: 214, 936: 215, 937: 216, 938: 217, 939: 218, 940: 219, 941: 220, 942: 221, 943: 222, 971: 223, 912: 224, 945: 225,
				946: 226, 947: 227, 948: 228, 949: 229, 950: 230, 951: 231, 952: 232, 953: 233, 954: 234, 955: 235, 956: 236, 957: 237, 958: 238, 959: 239, 960: 240, 961: 241,
				962: 242, 963: 243, 964: 244, 965: 245, 966: 246, 967: 247, 968: 248, 969: 249, 972: 252, 973: 253, 974: 254,
			},
		}
	case 0xa7: // 167
		return &StringConverter{
			LangID:    167,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 64287, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232,
				234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252,
				63713, 63712, 63711, 63710, 63709, 63708, 8362, 63707, 63706, 63705, 63704, 63703, 63702, 63701, 63700, 63699,
				63698, 63697, 63696, 63695, 63694, 63693, 63692, 63691, 63690, 63689, 63688, 63687, 63684, 63685, 63686, 63674,
				64316, 8222, 65535, 65535, 65535, 65535, 1468, 64331, 64309, 8230, 160, 1464, 1463, 1461, 1462, 1460,
				8211, 8213, 8220, 8221, 8216, 8217, 64298, 64299, 63682, 63730, 1458, 1457, 1467, 1465, 1464, 1459,
				1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502, 1503,
				1504, 1505, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 63678, 63683, 63676, 63676, 63677,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 64287: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 227: 139, 229: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 237: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 242: 152, 244: 153, 246: 154, 245: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				63713: 160, 63712: 161, 63711: 162, 63710: 163, 63709: 164, 63708: 165, 8362: 166, 63707: 167, 63706: 168, 63705: 169, 63704: 170, 63703: 171, 63702: 172, 63701: 173, 63700: 174, 63699: 175,
				63698: 176, 63697: 177, 63696: 178, 63695: 179, 63694: 180, 63693: 181, 63692: 182, 63691: 183, 63690: 184, 63689: 185, 63688: 186, 63687: 187, 63684: 188, 63685: 189, 63686: 190, 63674: 191,
				64316: 192, 8222: 193, 65535: 197, 1468: 198, 64331: 199, 64309: 200, 8230: 201, 160: 202, 1464: 222, 1463: 204, 1461: 205, 1462: 206, 1460: 207, 8211: 208, 8213: 209, 8220: 210,
				8221: 211, 8216: 212, 8217: 213, 64298: 214, 64299: 215, 63682: 216, 63730: 217, 1458: 218, 1457: 219, 1467: 220, 1465: 221, 1459: 223, 1488: 224, 1489: 225, 1490: 226, 1491: 227,
				1492: 228, 1493: 229, 1494: 230, 1495: 231, 1496: 232, 1497: 233, 1498: 234, 1499: 235, 1500: 236, 1501: 237, 1502: 238, 1503: 239, 1504: 240, 1505: 241, 1506: 242, 1507: 243,
				1508: 244, 1509: 245, 1510: 246, 1511: 247, 1512: 248, 1513: 249, 1514: 250, 63678: 251, 63683: 252, 63676: 254, 63677: 255,
			},
		}
	case 0xaa: // 170
		return &StringConverter{
			LangID:    170,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				8364, 129, 8218, 131, 8222, 8230, 8224, 8225, 136, 8240, 352, 8249, 346, 356, 381, 377,
				144, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 152, 8482, 353, 8250, 347, 357, 382, 378,
				160, 711, 728, 321, 164, 260, 166, 167, 168, 169, 350, 171, 172, 173, 174, 379,
				176, 177, 731, 322, 180, 181, 182, 183, 184, 261, 351, 187, 317, 733, 318, 380,
				340, 193, 194, 258, 196, 313, 262, 199, 268, 201, 280, 203, 282, 205, 206, 270,
				272, 323, 327, 211, 212, 336, 214, 215, 344, 366, 218, 368, 220, 221, 354, 223,
				341, 225, 226, 259, 228, 314, 263, 231, 269, 233, 281, 235, 283, 237, 238, 271,
				273, 324, 328, 243, 244, 337, 246, 247, 345, 367, 250, 369, 252, 253, 355, 729,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				8364: 128, 129: 129, 8218: 130, 131: 131, 8222: 132, 8230: 133, 8224: 134, 8225: 135, 136: 136, 8240: 137, 352: 138, 8249: 139, 346: 140, 356: 141, 381: 142, 377: 143,
				144: 144, 8216: 145, 8217: 146, 8220: 147, 8221: 148, 8226: 149, 8211: 150, 8212: 151, 152: 152, 8482: 153, 353: 154, 8250: 155, 347: 156, 357: 157, 382: 158, 378: 159,
				160: 160, 711: 161, 728: 162, 321: 163, 164: 164, 260: 165, 166: 166, 167: 167, 168: 168, 169: 169, 350: 170, 171: 171, 172: 172, 173: 173, 174: 174, 379: 175,
				176: 176, 177: 177, 731: 178, 322: 179, 180: 180, 181: 181, 182: 182, 183: 183, 184: 184, 261: 185, 351: 186, 187: 187, 317: 188, 733: 189, 318: 190, 380: 191,
				340: 192, 193: 193, 194: 194, 258: 195, 196: 196, 313: 197, 262: 198, 199: 199, 268: 200, 201: 201, 280: 202, 203: 203, 282: 204, 205: 205, 206: 206, 270: 207,
				272: 208, 323: 209, 327: 210, 211: 211, 212: 212, 336: 213, 214: 214, 215: 215, 344: 216, 366: 217, 218: 218, 368: 219, 220: 220, 221: 221, 354: 222, 223: 223,
				341: 224, 225: 225, 226: 226, 259: 227, 228: 228, 314: 229, 263: 230, 231: 231, 269: 232, 233: 233, 281: 234, 235: 235, 283: 236, 237: 237, 238: 238, 271: 239,
				273: 240, 324: 241, 328: 242, 243: 243, 244: 244, 337: 245, 246: 246, 247: 247, 345: 248, 367: 249, 250: 250, 369: 251, 252: 252, 253: 253, 355: 254, 729: 255,
				161: 33, 162: 99, 163: 76, 165: 89, 170: 97, 175: 151, 178: 50, 179: 51, 185: 49, 186: 111, 188: 49, 189: 49, 190: 51, 192: 65, 195: 65, 197: 65,
				198: 65, 200: 69, 202: 69, 204: 73, 207: 73, 209: 78, 210: 79, 213: 79, 216: 79, 217: 85, 219: 85, 224: 97, 227: 97, 229: 97, 230: 97, 232: 101,
				234: 101, 236: 105, 239: 105, 241: 110, 242: 111, 245: 111, 248: 111, 249: 117, 251: 117, 255: 121, 256: 65, 257: 97, 264: 67, 265: 99, 266: 67, 267: 99,
				274: 69, 275: 101, 276: 69, 277: 101, 278: 69, 279: 101, 284: 71, 285: 103, 286: 71, 287: 103, 288: 71, 289: 103, 290: 71, 291: 103, 292: 72, 293: 104,
				294: 72, 295: 104, 296: 73, 297: 105, 298: 73, 299: 105, 300: 73, 301: 105, 302: 73, 303: 105, 304: 73, 305: 105, 308: 74, 309: 106, 310: 75, 311: 107,
				315: 76, 316: 108, 325: 78, 326: 110, 332: 79, 333: 111, 334: 79, 335: 111, 338: 79, 339: 111, 342: 82, 343: 114, 348: 83, 349: 115, 358: 84, 359: 116,
				360: 85, 361: 117, 362: 85, 363: 117, 364: 85, 365: 117, 370: 85, 371: 117, 372: 87, 373: 119, 374: 89, 375: 121, 376: 89, 384: 98, 393: 208, 401: 70,
				402: 102, 407: 73, 410: 108, 415: 79, 416: 79, 417: 111, 427: 116, 430: 84, 431: 85, 432: 117, 438: 122, 448: 124, 451: 33, 461: 65, 462: 97, 463: 73,
				464: 105, 465: 79, 466: 111, 467: 85, 468: 117, 469: 85, 470: 117, 471: 85, 472: 117, 473: 85, 474: 117, 475: 85, 476: 117, 478: 65, 479: 97, 484: 71,
				485: 103, 486: 71, 487: 103, 488: 75, 489: 107, 490: 79, 491: 111, 492: 79, 493: 111, 496: 106, 609: 103, 697: 39, 698: 34, 699: 145, 700: 39, 708: 94,
				710: 94, 712: 39, 713: 175, 714: 180, 715: 96, 717: 95, 730: 176, 732: 126, 768: 96, 769: 180, 770: 94, 771: 126, 772: 175, 773: 175, 774: 162, 775: 255,
				776: 168, 778: 176, 780: 161, 782: 34, 807: 184, 817: 95, 818: 95, 894: 59, 946: 223, 956: 181, 1211: 104, 1417: 58, 1642: 37, 8192: 32, 8193: 32, 8194: 32,
				8195: 32, 8196: 32, 8197: 32, 8198: 32, 8208: 45, 8209: 45, 8228: 149, 8242: 39, 8243: 148, 8245: 96, 8252: 33, 8260: 47, 8304: 176, 8308: 52, 8309: 53, 8310: 54,
				8311: 55, 8312: 56, 8320: 48, 8321: 49, 8322: 50, 8323: 51, 8324: 52, 8325: 53, 8326: 54, 8327: 55, 8328: 56, 8329: 57, 8356: 163, 8450: 67, 8455: 69, 8458: 103,
				8459: 72, 8460: 72, 8461: 72, 8462: 104, 8464: 73, 8465: 73, 8466: 76, 8467: 108, 8469: 78, 8472: 80, 8473: 80, 8474: 81, 8475: 82, 8476: 82, 8477: 82, 8484: 90,
				8488: 90, 8490: 75, 8491: 197, 8492: 66, 8493: 67, 8494: 101, 8495: 101, 8496: 69, 8497: 70, 8499: 77, 8500: 111, 8592: 139, 8593: 94, 8594: 155, 8595: 161, 8596: 45,
				8597: 124, 8616: 124, 8709: 216, 8722: 45, 8723: 177, 8725: 47, 8726: 92, 8727: 42, 8728: 176, 8729: 149, 8735: 76, 8739: 124, 8758: 58, 8764: 126, 8810: 171, 8811: 187,
				8901: 183, 8962: 166, 8963: 94, 9001: 60, 9002: 62, 9472: 166, 9474: 45, 9484: 45, 9488: 172, 9492: 76, 9496: 45, 9500: 43, 9508: 43, 9516: 84, 9524: 43, 9532: 43,
				9552: 61, 9553: 166, 9556: 45, 9559: 172, 9562: 76, 9565: 45, 9568: 166, 9571: 166, 9574: 84, 9577: 166, 9580: 43, 9600: 45, 9604: 45, 9608: 45, 9617: 45, 9618: 45,
				9619: 45, 9632: 166, 9644: 45, 9650: 94, 9658: 62, 9660: 161, 9668: 60, 9675: 48, 9688: 149, 9689: 48, 9786: 162, 9787: 162, 9788: 48, 9792: 43, 9794: 62, 9824: 166,
				9827: 166, 9829: 166, 9830: 166, 9834: 100, 9835: 100, 10072: 124, 10075: 145, 10076: 146, 10077: 147, 10078: 148, 12288: 32, 12296: 60, 12297: 62, 12298: 171, 12299: 187, 12314: 91,
				12315: 93, 12317: 147, 12318: 148, 12319: 132, 12539: 183, 12540: 151, 65281: 33, 65282: 34, 65283: 35, 65284: 36, 65285: 37, 65286: 38, 65287: 39, 65288: 40, 65289: 41, 65290: 42,
				65291: 43, 65292: 44, 65293: 45, 65294: 46, 65295: 47, 65296: 48, 65297: 49, 65298: 50, 65299: 51, 65300: 52, 65301: 53, 65302: 54, 65303: 55, 65304: 56, 65305: 57, 65306: 58,
				65307: 59, 65308: 60, 65309: 61, 65310: 62, 65312: 64, 65313: 65, 65314: 66, 65315: 67, 65316: 68, 65317: 69, 65318: 70, 65319: 71, 65320: 72, 65321: 73, 65322: 74, 65323: 75,
				65324: 76, 65325: 77, 65326: 78, 65327: 79, 65328: 80, 65329: 81, 65330: 82, 65331: 83, 65332: 84, 65333: 85, 65334: 86, 65335: 87, 65336: 88, 65337: 89, 65338: 90, 65339: 91,
				65340: 92, 65341: 93, 65342: 94, 65343: 95, 65344: 96, 65345: 97, 65346: 98, 65347: 99, 65348: 100, 65349: 101, 65350: 102, 65351: 103, 65352: 104, 65353: 105, 65354: 106, 65355: 107,
				65356: 108, 65357: 109, 65358: 110, 65359: 111, 65360: 112, 65361: 113, 65362: 114, 65363: 115, 65364: 116, 65365: 117, 65366: 118, 65367: 119, 65368: 120, 65369: 121, 65370: 122, 65371: 123,
				65372: 124, 65373: 125, 65374: 126,
			},
		}
	case 0xab: // 171
		return &StringConverter{
			LangID:    171,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1026, 1027, 8218, 1107, 8222, 8230, 8224, 8225, 8364, 8240, 1033, 8249, 1034, 1036, 1035, 1039,
				1106, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 152, 8482, 1113, 8250, 1114, 1116, 1115, 1119,
				160, 1038, 1118, 1032, 164, 1168, 166, 167, 1025, 169, 1028, 171, 172, 173, 174, 1031,
				176, 177, 1030, 1110, 1169, 181, 182, 183, 1105, 8470, 1108, 187, 1112, 1029, 1109, 1111,
				1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055,
				1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071,
				1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087,
				1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1026: 128, 1027: 129, 8218: 130, 1107: 131, 8222: 132, 8230: 133, 8224: 134, 8225: 135, 8364: 136, 8240: 137, 1033: 138, 8249: 139, 1034: 140, 1036: 141, 1035: 142, 1039: 143,
				1106: 144, 8216: 145, 8217: 146, 8220: 147, 8221: 148, 8226: 149, 8211: 150, 8212: 151, 152: 152, 8482: 153, 1113: 154, 8250: 155, 1114: 156, 1116: 157, 1115: 158, 1119: 159,
				160: 160, 1038: 161, 1118: 162, 1032: 163, 164: 164, 1168: 165, 166: 166, 167: 167, 1025: 168, 169: 169, 1028: 170, 171: 171, 172: 172, 173: 173, 174: 174, 1031: 175,
				176: 176, 177: 177, 1030: 178, 1110: 179, 1169: 180, 181: 181, 182: 182, 183: 183, 1105: 184, 8470: 185, 1108: 186, 187: 187, 1112: 188, 1029: 189, 1109: 190, 1111: 191,
				1040: 192, 1041: 193, 1042: 194, 1043: 195, 1044: 196, 1045: 197, 1046: 198, 1047: 199, 1048: 200, 1049: 201, 1050: 202, 1051: 203, 1052: 204, 1053: 205, 1054: 206, 1055: 207,
				1056: 208, 1057: 209, 1058: 210, 1059: 211, 1060: 212, 1061: 213, 1062: 214, 1063: 215, 1064: 216, 1065: 217, 1066: 218, 1067: 219, 1068: 220, 1069: 221, 1070: 222, 1071: 223,
				1072: 224, 1073: 225, 1074: 226, 1075: 227, 1076: 228, 1077: 229, 1078: 230, 1079: 231, 1080: 232, 1081: 233, 1082: 234, 1083: 235, 1084: 236, 1085: 237, 1086: 238, 1087: 239,
				1088: 240, 1089: 241, 1090: 242, 1091: 243, 1092: 244, 1093: 245, 1094: 246, 1095: 247, 1096: 248, 1097: 249, 1098: 250, 1099: 251, 1100: 252, 1101: 253, 1102: 254, 1103: 255,
				192: 65, 193: 65, 194: 65, 195: 65, 196: 65, 197: 65, 199: 67, 200: 69, 201: 69, 202: 69, 203: 69, 204: 73, 205: 73, 206: 73, 207: 73, 209: 78,
				210: 79, 211: 79, 212: 79, 213: 79, 214: 79, 216: 79, 217: 85, 218: 85, 219: 85, 220: 85, 221: 89, 224: 97, 225: 97, 226: 97, 227: 97, 228: 97,
				229: 97, 231: 99, 232: 101, 233: 101, 234: 101, 235: 101, 236: 105, 237: 105, 238: 105, 239: 105, 241: 110, 242: 111, 243: 111, 244: 111, 245: 111, 246: 111,
				248: 111, 249: 117, 250: 117, 251: 117, 252: 117, 253: 121, 255: 121, 256: 65, 257: 97, 258: 65, 259: 97, 260: 65, 261: 97, 262: 67, 263: 99, 264: 67,
				265: 99, 266: 67, 267: 99, 268: 67, 269: 99, 270: 68, 271: 100, 272: 68, 273: 100, 274: 69, 275: 101, 276: 69, 277: 101, 278: 69, 279: 101, 280: 69,
				281: 101, 282: 69, 283: 101, 284: 71, 285: 103, 286: 71, 287: 103, 288: 71, 289: 103, 290: 71, 291: 103, 292: 72, 293: 104, 294: 72, 295: 104, 296: 73,
				297: 105, 298: 73, 299: 105, 300: 73, 301: 105, 302: 73, 303: 105, 304: 73, 308: 74, 309: 106, 310: 75, 311: 107, 313: 76, 314: 108, 315: 76, 316: 108,
				317: 76, 318: 108, 321: 76, 322: 108, 323: 78, 324: 110, 325: 78, 326: 110, 327: 78, 328: 110, 332: 79, 333: 111, 334: 79, 335: 111, 336: 79, 337: 111,
				340: 82, 341: 114, 342: 82, 343: 114, 344: 82, 345: 114, 346: 83, 347: 115, 348: 83, 349: 115, 350: 83, 351: 115, 352: 83, 353: 115, 354: 84, 355: 116,
				356: 84, 357: 116, 358: 84, 359: 116, 360: 85, 361: 117, 362: 85, 363: 117, 364: 85, 365: 117, 366: 85, 367: 117, 368: 85, 369: 117, 370: 85, 371: 117,
				372: 87, 373: 119, 374: 89, 375: 121, 376: 89, 377: 90, 378: 122, 379: 90, 380: 122, 381: 90, 382: 122, 384: 98, 407: 73, 410: 108, 415: 79, 416: 79,
				417: 111, 427: 116, 430: 84, 431: 85, 432: 117, 461: 65, 462: 97, 463: 73, 464: 105, 465: 79, 466: 111, 467: 85, 468: 117, 469: 85, 470: 117, 471: 85,
				472: 117, 473: 85, 474: 117, 475: 85, 476: 117, 478: 65, 479: 97, 484: 71, 485: 103, 486: 71, 487: 103, 488: 75, 489: 107, 490: 79, 491: 111, 492: 79,
				493: 111, 496: 106, 8252: 33, 8592: 60, 8593: 94, 8594: 62, 8595: 118, 8596: 45, 8597: 166, 8616: 166, 8729: 149, 8730: 118, 8735: 76, 8962: 166, 9472: 45, 9474: 166,
				9484: 45, 9488: 172, 9492: 76, 9496: 45, 9500: 43, 9508: 43, 9516: 84, 9524: 43, 9532: 43, 9552: 61, 9553: 166, 9554: 45, 9555: 227, 9556: 227, 9557: 172, 9558: 172,
				9559: 172, 9560: 76, 9561: 76, 9562: 76, 9563: 45, 9564: 45, 9565: 45, 9566: 166, 9567: 166, 9568: 166, 9569: 166, 9570: 166, 9571: 166, 9572: 84, 9573: 84, 9574: 84,
				9575: 166, 9576: 166, 9577: 166, 9578: 43, 9579: 43, 9580: 43, 9600: 45, 9604: 45, 9608: 45, 9612: 166, 9616: 166, 9617: 45, 9618: 45, 9619: 45, 9632: 166, 9644: 45,
				9650: 94, 9658: 62, 9660: 161, 9668: 60, 9675: 48, 9688: 149, 9689: 48, 9786: 79, 9787: 79, 9788: 48, 9792: 43, 9794: 62, 9824: 166, 9827: 166, 9829: 166, 9830: 166,
				9834: 100, 9835: 100, 65281: 33, 65282: 34, 65283: 35, 65284: 36, 65285: 37, 65286: 38, 65287: 39, 65288: 40, 65289: 41, 65290: 42, 65291: 43, 65292: 44, 65293: 45, 65294: 46,
				65295: 47, 65296: 48, 65297: 49, 65298: 50, 65299: 51, 65300: 52, 65301: 53, 65302: 54, 65303: 55, 65304: 56, 65305: 57, 65306: 58, 65307: 59, 65308: 60, 65309: 61, 65310: 62,
				65312: 64, 65313: 65, 65314: 66, 65315: 67, 65316: 68, 65317: 69, 65318: 70, 65319: 71, 65320: 72, 65321: 73, 65322: 74, 65323: 75, 65324: 76, 65325: 77, 65326: 78, 65327: 79,
				65328: 80, 65329: 81, 65330: 82, 65331: 83, 65332: 84, 65333: 85, 65334: 86, 65335: 87, 65336: 88, 65337: 89, 65338: 90, 65339: 91, 65340: 92, 65341: 93, 65342: 94, 65343: 95,
				65344: 96, 65345: 97, 65346: 98, 65347: 99, 65348: 100, 65349: 101, 65350: 102, 65351: 103, 65352: 104, 65353: 105, 65354: 106, 65355: 107, 65356: 108, 65357: 109, 65358: 110, 65359: 111,
				65360: 112, 65361: 113, 65362: 114, 65363: 115, 65364: 116, 65365: 117, 65366: 118, 65367: 119, 65368: 120, 65369: 121, 65370: 122, 65371: 123, 65372: 124, 65373: 125, 65374: 126,
			},
		}
	case 0xac: // 172
		return &StringConverter{
			LangID:    172,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  191,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 65535, 381, 65535, 65535,
				65535, 8216, 8217, 8220, 8221, 8226, 8211, 8213, 732, 8482, 353, 8250, 65535, 382, 65535, 376,
				65535, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
				176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
				192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
				208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
				224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
				240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 160, 8218: 130, 402: 131, 8222: 132, 8230: 133, 8224: 134, 8225: 135, 710: 136, 8240: 137, 352: 138, 8249: 139, 381: 141, 8216: 145, 8217: 146, 8220: 147, 8221: 148,
				8226: 149, 8211: 150, 8213: 151, 732: 152, 8482: 153, 353: 154, 8250: 155, 382: 157, 376: 159, 161: 161, 162: 162, 163: 163, 164: 164, 165: 165, 166: 166, 167: 167,
				168: 168, 169: 169, 170: 170, 171: 171, 172: 172, 173: 173, 174: 174, 175: 175, 176: 176, 177: 177, 178: 178, 179: 179, 180: 180, 181: 181, 182: 182, 183: 183,
				184: 184, 185: 185, 186: 186, 187: 187, 188: 188, 189: 189, 190: 190, 191: 191, 192: 192, 193: 193, 194: 194, 195: 195, 196: 196, 197: 197, 198: 198, 199: 199,
				200: 200, 201: 201, 202: 202, 203: 203, 204: 204, 205: 205, 206: 206, 207: 207, 208: 208, 209: 209, 210: 210, 211: 211, 212: 212, 213: 213, 214: 214, 215: 215,
				216: 216, 217: 217, 218: 218, 219: 219, 220: 220, 221: 221, 222: 222, 223: 223, 224: 224, 225: 225, 226: 226, 227: 227, 228: 228, 229: 229, 230: 230, 231: 231,
				232: 232, 233: 233, 234: 234, 235: 235, 236: 236, 237: 237, 238: 238, 239: 239, 240: 240, 241: 241, 242: 242, 243: 243, 244: 244, 245: 245, 246: 246, 247: 247,
				248: 248, 249: 249, 250: 250, 251: 251, 252: 252, 253: 253, 254: 254, 255: 255, 63741: 131,
			},
		}
	case 0xad: // 173
		return &StringConverter{
			LangID:    173,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 8216, 8217, 8220, 8221, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				160, 65535, 162, 163, 164, 165, 8213, 167, 1025, 169, 1028, 8592, 172, 173, 174, 1031,
				176, 177, 8804, 8805, 180, 65535, 182, 733, 1105, 8470, 65535, 8594, 65535, 65535, 65535, 711,
				1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055,
				1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071,
				1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087,
				1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 190, 8216: 145, 8217: 146, 8220: 147, 8221: 148, 160: 160, 162: 162, 163: 163, 164: 164, 165: 165, 8213: 166, 167: 167, 1025: 168, 169: 169, 1028: 170, 8592: 171,
				172: 172, 173: 173, 174: 174, 1031: 175, 176: 176, 177: 177, 8804: 178, 8805: 179, 180: 180, 182: 182, 733: 183, 1105: 184, 8470: 185, 8594: 187, 711: 191, 1040: 192,
				1041: 193, 1042: 194, 1043: 195, 1044: 196, 1045: 197, 1046: 198, 1047: 199, 1048: 200, 1049: 201, 1050: 202, 1051: 203, 1052: 204, 1053: 205, 1054: 206, 1055: 207, 1056: 208,
				1057: 209, 1058: 210, 1059: 211, 1060: 212, 1061: 213, 1062: 214, 1063: 215, 1064: 216, 1065: 217, 1066: 218, 1067: 219, 1068: 220, 1069: 221, 1070: 222, 1071: 223, 1072: 224,
				1073: 225, 1074: 226, 1075: 227, 1076: 228, 1077: 229, 1078: 230, 1079: 231, 1080: 232, 1081: 233, 1082: 234, 1083: 235, 1084: 236, 1085: 237, 1086: 238, 1087: 239, 1088: 240,
				1089: 241, 1090: 242, 1091: 243, 1092: 244, 1093: 245, 1094: 246, 1095: 247, 1096: 248, 1097: 249, 1098: 250, 1099: 251, 1100: 252, 1101: 253, 1102: 254, 1103: 255,
			},
		}
	case 0xae: // 174
		return &StringConverter{
			LangID:    174,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				8364, 129, 8218, 402, 8222, 8230, 8224, 8225, 136, 8240, 138, 8249, 140, 141, 142, 143,
				144, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 152, 8482, 154, 8250, 156, 157, 158, 159,
				160, 901, 902, 163, 164, 165, 166, 167, 168, 169, 63737, 171, 172, 173, 174, 8213,
				176, 177, 178, 179, 900, 181, 182, 183, 904, 905, 906, 187, 908, 189, 910, 911,
				912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927,
				928, 929, 63738, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943,
				944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959,
				960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 63739,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				8364: 128, 129: 129, 8218: 130, 402: 131, 8222: 132, 8230: 133, 8224: 134, 8225: 135, 136: 136, 8240: 137, 138: 138, 8249: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 8216: 145, 8217: 146, 8220: 147, 8221: 148, 8226: 149, 8211: 150, 8212: 151, 152: 152, 8482: 153, 154: 154, 8250: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 901: 161, 902: 162, 163: 163, 164: 164, 165: 165, 166: 166, 167: 167, 168: 168, 169: 169, 63737: 170, 171: 171, 172: 172, 173: 173, 174: 174, 8213: 175,
				176: 176, 177: 177, 178: 178, 179: 179, 900: 180, 181: 181, 182: 182, 183: 183, 904: 184, 905: 185, 906: 186, 187: 187, 908: 188, 189: 189, 910: 190, 911: 191,
				912: 192, 913: 193, 914: 194, 915: 195, 916: 196, 917: 197, 918: 198, 919: 199, 920: 200, 921: 201, 922: 202, 923: 203, 924: 204, 925: 205, 926: 206, 927: 207,
				928: 208, 929: 209, 63738: 210, 931: 211, 932: 212, 933: 213, 934: 214, 935: 215, 936: 216, 937: 217, 938: 218, 939: 219, 940: 220, 941: 221, 942: 222, 943: 223,
				944: 224, 945: 225, 946: 226, 947: 227, 948: 228, 949: 229, 950: 230, 951: 231, 952: 232, 953: 233, 954: 234, 955: 235, 956: 236, 957: 237, 958: 238, 959: 239,
				960: 240, 961: 241, 962: 242, 963: 243, 964: 244, 965: 245, 966: 246, 967: 247, 968: 248, 969: 249, 970: 250, 971: 251, 972: 252, 973: 253, 974: 254, 63739: 255,
				180: 47, 192: 65, 193: 65, 194: 65, 195: 65, 196: 65, 197: 65, 199: 67, 200: 69, 201: 69, 202: 69, 203: 69, 204: 73, 205: 73, 206: 73, 207: 73,
				209: 78, 210: 79, 211: 79, 212: 79, 213: 79, 214: 79, 216: 79, 217: 85, 218: 85, 219: 85, 220: 85, 221: 89, 224: 97, 225: 97, 226: 97, 227: 97,
				228: 97, 229: 97, 231: 99, 232: 101, 233: 101, 234: 101, 235: 101, 236: 105, 237: 105, 238: 105, 239: 105, 241: 110, 242: 111, 243: 111, 244: 111, 245: 111,
				246: 111, 248: 111, 249: 117, 250: 117, 251: 117, 252: 117, 253: 121, 255: 121, 256: 65, 257: 97, 258: 65, 259: 97, 260: 65, 261: 97, 262: 67, 263: 99,
				264: 67, 265: 99, 266: 67, 267: 99, 268: 67, 269: 99, 270: 68, 271: 100, 272: 68, 273: 100, 274: 69, 275: 101, 276: 69, 277: 101, 278: 69, 279: 101,
				280: 69, 281: 101, 282: 69, 283: 101, 284: 71, 285: 103, 286: 71, 287: 103, 288: 71, 289: 103, 290: 71, 291: 103, 292: 72, 293: 104, 294: 72, 295: 104,
				296: 73, 297: 105, 298: 73, 299: 105, 300: 73, 301: 105, 302: 73, 303: 105, 304: 73, 308: 74, 309: 106, 310: 75, 311: 107, 313: 76, 314: 108, 315: 76,
				316: 108, 317: 76, 318: 108, 321: 76, 322: 108, 323: 78, 324: 110, 325: 78, 326: 110, 327: 78, 328: 110, 332: 79, 333: 111, 334: 79, 335: 111, 336: 79,
				337: 111, 340: 82, 341: 114, 342: 82, 343: 114, 344: 82, 345: 114, 346: 83, 347: 115, 348: 83, 349: 115, 350: 83, 351: 115, 352: 83, 353: 115, 354: 84,
				355: 116, 356: 84, 357: 116, 358: 84, 359: 116, 360: 85, 361: 117, 362: 85, 363: 117, 364: 85, 365: 117, 366: 85, 367: 117, 368: 85, 369: 117, 370: 85,
				371: 117, 372: 87, 373: 119, 374: 89, 375: 121, 376: 89, 377: 90, 378: 122, 379: 90, 380: 122, 381: 90, 382: 122, 384: 98, 401: 131, 407: 73, 410: 108,
				415: 79, 416: 79, 417: 111, 427: 116, 430: 84, 431: 85, 432: 117, 461: 65, 462: 97, 463: 73, 464: 105, 465: 79, 466: 111, 467: 85, 468: 117, 469: 85,
				470: 117, 471: 85, 472: 117, 473: 85, 474: 117, 475: 85, 476: 117, 478: 65, 479: 97, 484: 71, 485: 103, 486: 71, 487: 103, 488: 75, 489: 107, 490: 79,
				491: 111, 492: 79, 493: 111, 496: 106, 781: 180, 894: 59, 8252: 33, 8592: 60, 8593: 94, 8594: 62, 8595: 118, 8596: 45, 8597: 166, 8616: 166, 8735: 76, 8962: 166,
				9472: 45, 9474: 166, 9484: 45, 9488: 172, 9492: 76, 9496: 45, 9500: 43, 9508: 43, 9516: 84, 9524: 43, 9532: 43, 9552: 61, 9553: 166, 9556: 45, 9559: 172, 9562: 76,
				9565: 45, 9568: 166, 9571: 166, 9574: 84, 9577: 166, 9580: 43, 9600: 45, 9604: 45, 9608: 45, 9617: 45, 9618: 45, 9619: 45, 9632: 166, 9644: 45, 9650: 94, 9658: 62,
				9660: 161, 9668: 60, 9675: 48, 9688: 149, 9689: 48, 9786: 79, 9787: 79, 9788: 48, 9792: 43, 9794: 62, 9824: 166, 9827: 166, 9829: 166, 9830: 166, 9834: 100, 9835: 100,
				65281: 33, 65282: 34, 65283: 35, 65284: 36, 65285: 37, 65286: 38, 65287: 39, 65288: 40, 65289: 41, 65290: 42, 65291: 43, 65292: 44, 65293: 45, 65294: 46, 65295: 47, 65296: 48,
				65297: 49, 65298: 50, 65299: 51, 65300: 52, 65301: 53, 65302: 54, 65303: 55, 65304: 56, 65305: 57, 65306: 58, 65307: 59, 65308: 60, 65309: 61, 65310: 62, 65312: 64, 65313: 65,
				65314: 66, 65315: 67, 65316: 68, 65317: 69, 65318: 70, 65319: 71, 65320: 72, 65321: 73, 65322: 74, 65323: 75, 65324: 76, 65325: 77, 65326: 78, 65327: 79, 65328: 80, 65329: 81,
				65330: 82, 65331: 83, 65332: 84, 65333: 85, 65334: 86, 65335: 87, 65336: 88, 65337: 89, 65338: 90, 65339: 91, 65340: 92, 65341: 93, 65342: 94, 65343: 95, 65344: 96, 65345: 97,
				65346: 98, 65347: 99, 65348: 100, 65349: 101, 65350: 102, 65351: 103, 65352: 104, 65353: 105, 65354: 106, 65355: 107, 65356: 108, 65357: 109, 65358: 110, 65359: 111, 65360: 112, 65361: 113,
				65362: 114, 65363: 115, 65364: 116, 65365: 117, 65366: 118, 65367: 119, 65368: 120, 65369: 121, 65370: 122, 65371: 123, 65372: 124, 65373: 125, 65374: 126,
			},
		}
	case 0xaf: // 175
		return &StringConverter{
			LangID:    175,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				8364, 129, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 138, 8249, 140, 141, 142, 143,
				144, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 154, 8250, 156, 157, 158, 159,
				160, 161, 162, 163, 8362, 165, 166, 167, 168, 169, 215, 171, 172, 173, 174, 175,
				176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 247, 187, 188, 189, 190, 191,
				1456, 1457, 1458, 1459, 1460, 1461, 1462, 1463, 1464, 1465, 1466, 1467, 1468, 1469, 1470, 1471,
				1472, 1473, 1474, 1475, 1520, 1521, 1522, 1523, 1524, 63629, 63630, 63631, 63632, 63633, 63634, 63635,
				1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502, 1503,
				1504, 1505, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 63636, 63637, 8206, 8207, 63638,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				8364: 128, 129: 129, 8218: 130, 402: 131, 8222: 132, 8230: 133, 8224: 134, 8225: 135, 710: 136, 8240: 137, 138: 138, 8249: 139, 140: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 8216: 145, 8217: 146, 8220: 147, 8221: 148, 8226: 149, 8211: 150, 8212: 151, 732: 152, 8482: 153, 154: 154, 8250: 155, 156: 156, 157: 157, 158: 158, 159: 159,
				160: 160, 161: 161, 162: 162, 163: 163, 8362: 164, 165: 165, 166: 166, 167: 167, 168: 168, 169: 169, 215: 170, 171: 171, 172: 172, 173: 173, 174: 174, 175: 175,
				176: 176, 177: 177, 178: 178, 179: 179, 180: 180, 181: 181, 182: 182, 183: 183, 184: 184, 185: 185, 247: 186, 187: 187, 188: 188, 189: 189, 190: 190, 191: 191,
				1456: 192, 1457: 193, 1458: 194, 1459: 195, 1460: 196, 1461: 197, 1462: 198, 1463: 199, 1464: 200, 1465: 201, 1466: 202, 1467: 203, 1468: 204, 1469: 205, 1470: 206, 1471: 207,
				1472: 208, 1473: 209, 1474: 210, 1475: 211, 1520: 212, 1521: 213, 1522: 214, 1523: 215, 1524: 216, 63629: 217, 63630: 218, 63631: 219, 63632: 220, 63633: 221, 63634: 222, 63635: 223,
				1488: 224, 1489: 225, 1490: 226, 1491: 227, 1492: 228, 1493: 229, 1494: 230, 1495: 231, 1496: 232, 1497: 233, 1498: 234, 1499: 235, 1500: 236, 1501: 237, 1502: 238, 1503: 239,
				1504: 240, 1505: 241, 1506: 242, 1507: 243, 1508: 244, 1509: 245, 1510: 246, 1511: 247, 1512: 248, 1513: 249, 1514: 250, 63636: 251, 63637: 252, 8206: 253, 8207: 254, 63638: 255,
				164: 164, 401: 70, 65281: 33, 65282: 34, 65283: 35, 65284: 36, 65285: 37, 65286: 38, 65287: 39, 65288: 40, 65289: 41, 65290: 42, 65291: 43, 65292: 44, 65293: 45, 65294: 46,
				65295: 47, 65296: 48, 65297: 49, 65298: 50, 65299: 51, 65300: 52, 65301: 53, 65302: 54, 65303: 55, 65304: 56, 65305: 57, 65306: 58, 65307: 59, 65308: 60, 65309: 61, 65310: 62,
				65312: 64, 65313: 65, 65314: 66, 65315: 67, 65316: 68, 65317: 69, 65318: 70, 65319: 71, 65320: 72, 65321: 73, 65322: 74, 65323: 75, 65324: 76, 65325: 77, 65326: 78, 65327: 79,
				65328: 80, 65329: 81, 65330: 82, 65331: 83, 65332: 84, 65333: 85, 65334: 86, 65335: 87, 65336: 88, 65337: 89, 65338: 90, 65339: 91, 65340: 92, 65341: 93, 65342: 94, 65343: 95,
				65344: 96, 65345: 97, 65346: 98, 65347: 99, 65348: 100, 65349: 101, 65350: 102, 65351: 103, 65352: 104, 65353: 105, 65354: 106, 65355: 107, 65356: 108, 65357: 109, 65358: 110, 65359: 111,
				65360: 112, 65361: 113, 65362: 114, 65363: 115, 65364: 116, 65365: 117, 65366: 118, 65367: 119, 65368: 120, 65369: 121, 65370: 122, 65371: 123, 65372: 124, 65373: 125, 65374: 126,
			},
		}
	case 0xb0: // 176
		return &StringConverter{
			LangID:    176,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				160, 8221, 162, 163, 164, 8222, 166, 167, 216, 169, 342, 171, 172, 173, 174, 198,
				176, 177, 178, 179, 8220, 181, 182, 183, 248, 185, 343, 187, 188, 189, 190, 230,
				260, 302, 256, 262, 196, 197, 280, 274, 268, 201, 377, 278, 290, 310, 298, 315,
				352, 323, 325, 211, 332, 213, 214, 215, 370, 321, 346, 362, 220, 379, 381, 223,
				261, 303, 257, 263, 228, 229, 281, 275, 269, 233, 378, 279, 291, 311, 299, 316,
				353, 324, 326, 243, 333, 245, 246, 247, 371, 322, 347, 363, 252, 380, 382, 8217,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 159, 160: 160, 8221: 161, 162: 162, 163: 163, 164: 164, 8222: 165, 166: 166, 167: 167, 216: 168, 169: 169, 342: 170, 171: 171, 172: 172, 173: 173, 174: 174,
				198: 175, 176: 176, 177: 177, 178: 178, 179: 179, 8220: 180, 181: 181, 182: 182, 183: 183, 248: 184, 185: 185, 343: 186, 187: 187, 188: 188, 189: 189, 190: 190,
				230: 191, 260: 192, 302: 193, 256: 194, 262: 195, 196: 196, 197: 197, 280: 198, 274: 199, 268: 200, 201: 201, 377: 202, 278: 203, 290: 204, 310: 205, 298: 206,
				315: 207, 352: 208, 323: 209, 325: 210, 211: 211, 332: 212, 213: 213, 214: 214, 215: 215, 370: 216, 321: 217, 346: 218, 362: 219, 220: 220, 379: 221, 381: 222,
				223: 223, 261: 224, 303: 225, 257: 226, 263: 227, 228: 228, 229: 229, 281: 230, 275: 231, 269: 232, 233: 233, 378: 234, 279: 235, 291: 236, 311: 237, 299: 238,
				316: 239, 353: 240, 324: 241, 326: 242, 243: 243, 333: 244, 245: 245, 246: 246, 247: 247, 371: 248, 322: 249, 347: 250, 363: 251, 252: 252, 380: 253, 382: 254,
				8217: 255,
			},
		}
	case 0xb1: // 177
		return &StringConverter{
			LangID:    177,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				8364, 129, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 141, 142, 143,
				144, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 157, 158, 376,
				160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
				176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
				192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
				286, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 304, 350, 223,
				224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
				287, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 305, 351, 255,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				8364: 128, 129: 129, 8218: 130, 402: 131, 8222: 132, 8230: 133, 8224: 134, 8225: 135, 710: 136, 8240: 137, 352: 138, 8249: 139, 338: 140, 141: 141, 142: 142, 143: 143,
				144: 144, 8216: 145, 8217: 146, 8220: 147, 8221: 148, 8226: 149, 8211: 150, 8212: 151, 732: 152, 8482: 153, 353: 154, 8250: 155, 339: 156, 157: 157, 158: 158, 376: 159,
				160: 160, 161: 161, 162: 162, 163: 163, 164: 164, 165: 165, 166: 166, 167: 167, 168: 168, 169: 169, 170: 170, 171: 171, 172: 172, 173: 173, 174: 174, 175: 175,
				176: 176, 177: 177, 178: 178, 179: 179, 180: 180, 181: 181, 182: 182, 183: 183, 184: 184, 185: 185, 186: 186, 187: 187, 188: 188, 189: 189, 190: 190, 191: 191,
				192: 192, 193: 193, 194: 194, 195: 195, 196: 196, 197: 197, 198: 198, 199: 199, 200: 200, 201: 201, 202: 202, 203: 203, 204: 204, 205: 205, 206: 206, 207: 207,
				286: 208, 209: 209, 210: 210, 211: 211, 212: 212, 213: 213, 214: 214, 215: 215, 216: 216, 217: 217, 218: 218, 219: 219, 220: 220, 304: 221, 350: 222, 223: 223,
				224: 224, 225: 225, 226: 226, 227: 227, 228: 228, 229: 229, 230: 230, 231: 231, 232: 232, 233: 233, 234: 234, 235: 235, 236: 236, 237: 237, 238: 238, 239: 239,
				287: 240, 241: 241, 242: 242, 243: 243, 244: 244, 245: 245, 246: 246, 247: 247, 248: 248, 249: 249, 250: 250, 251: 251, 252: 252, 305: 253, 351: 254, 255: 255,
				221: 89, 253: 121, 256: 65, 257: 97, 258: 65, 259: 97, 260: 65, 261: 97, 262: 67, 263: 99, 264: 67, 265: 99, 266: 67, 267: 99, 268: 67, 269: 99,
				270: 68, 271: 100, 272: 68, 273: 100, 274: 69, 275: 101, 276: 69, 277: 101, 278: 69, 279: 101, 280: 69, 281: 101, 282: 69, 283: 101, 284: 71, 285: 103,
				288: 71, 289: 103, 290: 71, 291: 103, 292: 72, 293: 104, 294: 72, 295: 104, 296: 73, 297: 105, 298: 73, 299: 105, 300: 73, 301: 105, 302: 73, 303: 105,
				308: 74, 309: 106, 310: 75, 311: 107, 313: 76, 314: 108, 315: 76, 316: 108, 317: 76, 318: 108, 321: 76, 322: 108, 323: 78, 324: 110, 325: 78, 326: 110,
				327: 78, 328: 110, 332: 79, 333: 111, 334: 79, 335: 111, 336: 79, 337: 111, 340: 82, 341: 114, 342: 82, 343: 114, 344: 82, 345: 114, 346: 83, 347: 115,
				348: 83, 349: 115, 354: 84, 355: 116, 356: 84, 357: 116, 358: 84, 359: 116, 360: 85, 361: 117, 362: 85, 363: 117, 364: 85, 365: 117, 366: 85, 367: 117,
				368: 85, 369: 117, 370: 85, 371: 117, 372: 87, 373: 119, 374: 89, 375: 121, 377: 90, 378: 122, 379: 90, 380: 122, 381: 90, 382: 122, 384: 98, 393: 68,
				401: 131, 407: 73, 410: 108, 415: 79, 416: 79, 417: 111, 427: 116, 430: 84, 431: 85, 432: 117, 438: 122, 448: 124, 451: 33, 461: 65, 462: 97, 463: 73,
				464: 105, 465: 79, 466: 111, 467: 85, 468: 117, 469: 85, 470: 117, 471: 85, 472: 117, 473: 85, 474: 117, 475: 85, 476: 117, 478: 65, 479: 97, 484: 71,
				485: 103, 486: 71, 487: 103, 488: 75, 489: 107, 490: 79, 491: 111, 492: 79, 493: 111, 496: 106, 609: 103, 697: 39, 698: 34, 699: 145, 700: 39, 708: 94,
				711: 94, 712: 39, 713: 175, 714: 180, 715: 96, 717: 95, 728: 94, 729: 39, 730: 176, 731: 184, 733: 168, 768: 96, 769: 180, 770: 94, 771: 152, 772: 175,
				773: 175, 774: 136, 775: 183, 776: 168, 778: 167, 780: 136, 782: 168, 807: 184, 817: 95, 818: 95, 946: 223, 956: 181, 1211: 104, 1417: 58, 1642: 37, 8192: 32,
				8193: 32, 8194: 32, 8195: 32, 8196: 32, 8197: 32, 8198: 32, 8208: 45, 8209: 45, 8228: 149, 8242: 39, 8243: 168, 8245: 96, 8252: 33, 8260: 47, 8304: 176, 8308: 52,
				8309: 53, 8310: 54, 8311: 55, 8312: 56, 8320: 176, 8321: 48, 8322: 178, 8323: 179, 8324: 52, 8325: 53, 8326: 54, 8327: 55, 8328: 56, 8329: 57, 8356: 163, 8450: 67,
				8455: 69, 8458: 103, 8459: 72, 8460: 72, 8461: 72, 8462: 104, 8464: 73, 8465: 73, 8466: 76, 8467: 108, 8469: 78, 8472: 80, 8473: 80, 8474: 81, 8475: 82, 8476: 82,
				8477: 82, 8484: 90, 8488: 90, 8490: 75, 8491: 197, 8492: 66, 8493: 67, 8494: 101, 8495: 101, 8496: 69, 8497: 70, 8499: 77, 8500: 111, 8592: 139, 8593: 94, 8594: 155,
				8595: 118, 8596: 45, 8597: 124, 8616: 124, 8709: 216, 8722: 45, 8723: 177, 8725: 47, 8726: 92, 8727: 42, 8728: 176, 8729: 149, 8735: 76, 8739: 124, 8758: 58, 8764: 126,
				8810: 171, 8811: 187, 8901: 183, 8962: 166, 8963: 94, 9001: 60, 9002: 62, 9472: 166, 9474: 45, 9484: 45, 9488: 172, 9492: 76, 9496: 45, 9500: 43, 9508: 43, 9516: 84,
				9524: 43, 9532: 43, 9552: 61, 9553: 166, 9556: 45, 9559: 172, 9562: 76, 9565: 45, 9568: 166, 9571: 166, 9574: 84, 9577: 166, 9580: 43, 9600: 45, 9604: 45, 9608: 45,
				9617: 45, 9618: 45, 9619: 45, 9632: 166, 9644: 45, 9650: 94, 9658: 62, 9660: 161, 9668: 60, 9675: 48, 9688: 149, 9689: 48, 9786: 79, 9787: 79, 9788: 48, 9792: 43,
				9794: 62, 9824: 166, 9827: 166, 9829: 166, 9830: 166, 9834: 100, 9835: 100, 10072: 124, 10075: 145, 10076: 146, 10077: 147, 10078: 148, 12288: 32, 12296: 60, 12297: 62, 12298: 171,
				12299: 187, 12314: 91, 12315: 61, 12317: 34, 12318: 34, 12319: 132, 12539: 183, 12540: 151, 65281: 33, 65282: 34, 65283: 35, 65284: 36, 65285: 37, 65286: 38, 65287: 39, 65288: 40,
				65289: 41, 65290: 42, 65291: 43, 65292: 44, 65293: 45, 65294: 46, 65295: 47, 65296: 48, 65297: 49, 65298: 50, 65299: 51, 65300: 52, 65301: 53, 65302: 54, 65303: 55, 65304: 56,
				65305: 57, 65306: 58, 65307: 59, 65308: 60, 65309: 61, 65310: 62, 65312: 64, 65313: 65, 65314: 66, 65315: 67, 65316: 68, 65317: 69, 65318: 70, 65319: 71, 65320: 72, 65321: 73,
				65322: 74, 65323: 75, 65324: 76, 65325: 77, 65326: 78, 65327: 79, 65328: 80, 65329: 81, 65330: 82, 65331: 83, 65332: 84, 65333: 85, 65334: 86, 65335: 87, 65336: 88, 65337: 89,
				65338: 90, 65339: 91, 65340: 92, 65341: 93, 65342: 94, 65343: 95, 65344: 96, 65345: 97, 65346: 98, 65347: 99, 65348: 100, 65349: 101, 65350: 102, 65351: 103, 65352: 104, 65353: 105,
				65354: 106, 65355: 107, 65356: 108, 65357: 109, 65358: 110, 65359: 111, 65360: 112, 65361: 113, 65362: 114, 65363: 115, 65364: 116, 65365: 117, 65366: 118, 65367: 119, 65368: 120, 65369: 121,
				65370: 122, 65371: 123, 65372: 124, 65373: 125, 65374: 126,
			},
		}
	case 0xb2: // 178
		return &StringConverter{
			LangID:    178,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  191,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				8364, 129, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 141, 381, 143,
				144, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 157, 382, 376,
				160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
				176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
				192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
				208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
				224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
				240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				8364: 128, 129: 129, 8218: 130, 402: 131, 8222: 132, 8230: 133, 8224: 134, 8225: 135, 710: 136, 8240: 137, 352: 138, 8249: 139, 338: 140, 141: 141, 381: 142, 143: 143,
				144: 144, 8216: 145, 8217: 146, 8220: 147, 8221: 148, 8226: 149, 8211: 150, 8212: 151, 732: 152, 8482: 153, 353: 154, 8250: 155, 339: 156, 157: 157, 382: 158, 376: 159,
				160: 160, 161: 161, 162: 162, 163: 163, 164: 164, 165: 165, 166: 166, 167: 167, 168: 168, 169: 169, 170: 170, 171: 171, 172: 172, 173: 173, 174: 174, 175: 175,
				176: 176, 177: 177, 178: 178, 179: 179, 180: 180, 181: 181, 182: 182, 183: 183, 184: 184, 185: 185, 186: 186, 187: 187, 188: 188, 189: 189, 190: 190, 191: 191,
				192: 192, 193: 193, 194: 194, 195: 195, 196: 196, 197: 197, 198: 198, 199: 199, 200: 200, 201: 201, 202: 202, 203: 203, 204: 204, 205: 205, 206: 206, 207: 207,
				208: 208, 209: 209, 210: 210, 211: 211, 212: 212, 213: 213, 214: 214, 215: 215, 216: 216, 217: 217, 218: 218, 219: 219, 220: 220, 221: 221, 222: 222, 223: 223,
				224: 224, 225: 225, 226: 226, 227: 227, 228: 228, 229: 229, 230: 230, 231: 231, 232: 232, 233: 233, 234: 234, 235: 235, 236: 236, 237: 237, 238: 238, 239: 239,
				240: 240, 241: 241, 242: 242, 243: 243, 244: 244, 245: 245, 246: 246, 247: 247, 248: 248, 249: 249, 250: 250, 251: 251, 252: 252, 253: 253, 254: 254, 255: 255,
				256: 65, 257: 97, 258: 65, 259: 97, 260: 65, 261: 97, 262: 67, 263: 99, 264: 67, 265: 99, 266: 67, 267: 99, 268: 67, 269: 99, 270: 68, 271: 100,
				272: 208, 273: 100, 274: 69, 275: 101, 276: 69, 277: 101, 278: 69, 279: 101, 280: 69, 281: 101, 282: 69, 283: 101, 284: 71, 285: 103, 286: 71, 287: 103,
				288: 71, 289: 103, 290: 71, 291: 103, 292: 72, 293: 104, 294: 72, 295: 104, 296: 73, 297: 105, 298: 73, 299: 105, 300: 73, 301: 105, 302: 73, 303: 105,
				304: 73, 305: 105, 308: 74, 309: 106, 310: 75, 311: 107, 313: 76, 314: 108, 315: 76, 316: 108, 317: 76, 318: 108, 321: 76, 322: 108, 323: 78, 324: 110,
				325: 78, 326: 110, 327: 78, 328: 110, 332: 79, 333: 111, 334: 79, 335: 111, 336: 79, 337: 111, 340: 82, 341: 114, 342: 82, 343: 114, 344: 82, 345: 114,
				346: 83, 347: 115, 348: 83, 349: 115, 350: 83, 351: 115, 354: 84, 355: 116, 356: 84, 357: 116, 358: 84, 359: 116, 360: 85, 361: 117, 362: 85, 363: 117,
				364: 85, 365: 117, 366: 85, 367: 117, 368: 85, 369: 117, 370: 85, 371: 117, 372: 87, 373: 119, 374: 89, 375: 121, 377: 90, 378: 122, 379: 90, 380: 122,
				384: 98, 393: 208, 401: 131, 407: 73, 410: 108, 415: 79, 416: 79, 417: 111, 427: 116, 430: 84, 431: 85, 432: 117, 438: 122, 448: 124, 451: 33, 461: 65,
				462: 97, 463: 73, 464: 105, 465: 79, 466: 111, 467: 85, 468: 117, 469: 85, 470: 117, 471: 85, 472: 117, 473: 85, 474: 117, 475: 85, 476: 117, 478: 65,
				479: 97, 484: 71, 485: 103, 486: 71, 487: 103, 488: 75, 489: 107, 490: 79, 491: 111, 492: 79, 493: 111, 496: 106, 609: 103, 697: 39, 698: 34, 700: 39,
				708: 94, 712: 39, 713: 175, 714: 180, 715: 96, 717: 95, 730: 176, 768: 96, 769: 180, 770: 94, 771: 126, 772: 175, 773: 175, 776: 168, 778: 176, 782: 34,
				807: 184, 817: 95, 818: 95, 894: 59, 915: 71, 920: 84, 931: 83, 934: 70, 937: 79, 945: 97, 946: 223, 948: 100, 949: 101, 956: 181, 960: 112, 963: 115,
				964: 116, 966: 102, 1211: 104, 1417: 58, 1642: 37, 8192: 32, 8193: 32, 8194: 32, 8195: 32, 8196: 32, 8197: 32, 8198: 32, 8208: 45, 8209: 45, 8215: 61, 8228: 183,
				8242: 39, 8245: 96, 8260: 47, 8304: 176, 8308: 52, 8309: 53, 8310: 54, 8311: 55, 8312: 56, 8319: 110, 8320: 48, 8321: 49, 8322: 50, 8323: 51, 8324: 52, 8325: 53,
				8326: 54, 8327: 55, 8328: 56, 8329: 57, 8353: 162, 8356: 163, 8359: 80, 8450: 67, 8455: 69, 8458: 103, 8459: 72, 8460: 72, 8461: 72, 8462: 104, 8464: 73, 8465: 73,
				8466: 76, 8467: 108, 8469: 78, 8472: 80, 8473: 80, 8474: 81, 8475: 82, 8476: 82, 8477: 82, 8484: 90, 8488: 90, 8490: 75, 8491: 197, 8492: 66, 8493: 67, 8494: 101,
				8495: 101, 8496: 69, 8497: 70, 8499: 77, 8500: 111, 8709: 216, 8722: 45, 8723: 177, 8725: 47, 8726: 92, 8727: 42, 8728: 176, 8729: 183, 8730: 118, 8734: 56, 8739: 124,
				8745: 110, 8758: 58, 8764: 126, 8776: 152, 8801: 61, 8804: 61, 8805: 61, 8810: 171, 8811: 187, 8901: 183, 8962: 166, 8963: 94, 8976: 172, 8992: 40, 8993: 41, 9001: 60,
				9002: 62, 9472: 45, 9474: 166, 9484: 43, 9488: 43, 9492: 43, 9496: 43, 9500: 43, 9508: 166, 9516: 45, 9524: 45, 9532: 43, 9552: 45, 9553: 166, 9554: 43, 9555: 43,
				9556: 43, 9557: 43, 9558: 43, 9559: 43, 9560: 43, 9561: 43, 9562: 43, 9563: 43, 9564: 43, 9565: 43, 9566: 166, 9567: 166, 9568: 166, 9569: 166, 9570: 166, 9571: 166,
				9572: 45, 9573: 45, 9574: 45, 9575: 45, 9576: 45, 9577: 45, 9578: 43, 9579: 43, 9580: 43, 9600: 175, 9604: 95, 9608: 166, 9612: 166, 9616: 166, 9617: 166, 9618: 166,
				9619: 166, 9632: 166, 9788: 164, 10072: 124, 12288: 32, 12296: 60, 12297: 62, 12298: 171, 12299: 187, 12314: 91, 12315: 93, 12539: 183, 65281: 33, 65282: 34, 65283: 35, 65284: 36,
				65285: 37, 65286: 38, 65287: 39, 65288: 40, 65289: 41, 65290: 42, 65291: 43, 65292: 44, 65293: 45, 65294: 46, 65295: 47, 65296: 48, 65297: 49, 65298: 50, 65299: 51, 65300: 52,
				65301: 53, 65302: 54, 65303: 55, 65304: 56, 65305: 57, 65306: 58, 65307: 59, 65308: 60, 65309: 61, 65310: 62, 65312: 64, 65313: 65, 65314: 66, 65315: 67, 65316: 68, 65317: 69,
				65318: 70, 65319: 71, 65320: 72, 65321: 73, 65322: 74, 65323: 75, 65324: 76, 65325: 77, 65326: 78, 65327: 79, 65328: 80, 65329: 81, 65330: 82, 65331: 83, 65332: 84, 65333: 85,
				65334: 86, 65335: 87, 65336: 88, 65337: 89, 65338: 90, 65339: 91, 65340: 92, 65341: 93, 65342: 94, 65343: 95, 65344: 96, 65345: 97, 65346: 98, 65347: 99, 65348: 100, 65349: 101,
				65350: 102, 65351: 103, 65352: 104, 65353: 105, 65354: 106, 65355: 107, 65356: 108, 65357: 109, 65358: 110, 65359: 111, 65360: 112, 65361: 113, 65362: 114, 65363: 115, 65364: 116, 65365: 117,
				65366: 118, 65367: 119, 65368: 120, 65369: 121, 65370: 122, 65371: 123, 65372: 124, 65373: 125, 65374: 126,
			},
		}
	case 0xb3: // 179
		return &StringConverter{
			LangID:    179,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				8364, 129, 8218, 131, 8222, 8230, 8224, 8225, 136, 8240, 138, 8249, 140, 168, 711, 184,
				144, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 152, 8482, 154, 8250, 156, 175, 731, 159,
				160, 63740, 162, 163, 164, 63741, 166, 167, 216, 169, 342, 171, 172, 173, 174, 198,
				176, 177, 178, 179, 180, 181, 182, 183, 248, 185, 343, 187, 188, 189, 190, 230,
				260, 302, 256, 262, 196, 197, 280, 274, 268, 201, 377, 278, 290, 310, 298, 315,
				352, 323, 325, 211, 332, 213, 214, 215, 370, 321, 346, 362, 220, 379, 381, 223,
				261, 303, 257, 263, 228, 229, 281, 275, 269, 233, 378, 279, 291, 311, 299, 316,
				353, 324, 326, 243, 333, 245, 246, 247, 371, 322, 347, 363, 252, 380, 382, 729,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				8364: 128, 129: 129, 8218: 130, 131: 131, 8222: 132, 8230: 133, 8224: 134, 8225: 135, 136: 136, 8240: 137, 138: 138, 8249: 139, 140: 140, 168: 141, 711: 142, 184: 143,
				144: 144, 8216: 145, 8217: 146, 8220: 147, 8221: 148, 8226: 149, 8211: 150, 8212: 151, 152: 152, 8482: 153, 154: 154, 8250: 155, 156: 156, 175: 157, 731: 158, 159: 159,
				160: 160, 63740: 161, 162: 162, 163: 163, 164: 164, 63741: 165, 166: 166, 167: 167, 216: 168, 169: 169, 342: 170, 171: 171, 172: 172, 173: 173, 174: 174, 198: 175,
				176: 176, 177: 177, 178: 178, 179: 179, 180: 180, 181: 181, 182: 182, 183: 183, 248: 184, 185: 185, 343: 186, 187: 187, 188: 188, 189: 189, 190: 190, 230: 191,
				260: 192, 302: 193, 256: 194, 262: 195, 196: 196, 197: 197, 280: 198, 274: 199, 268: 200, 201: 201, 377: 202, 278: 203, 290: 204, 310: 205, 298: 206, 315: 207,
				352: 208, 323: 209, 325: 210, 211: 211, 332: 212, 213: 213, 214: 214, 215: 215, 370: 216, 321: 217, 346: 218, 362: 219, 220: 220, 379: 221, 381: 222, 223: 223,
				261: 224, 303: 225, 257: 226, 263: 227, 228: 228, 229: 229, 281: 230, 275: 231, 269: 232, 233: 233, 378: 234, 279: 235, 291: 236, 311: 237, 299: 238, 316: 239,
				353: 240, 324: 241, 326: 242, 243: 243, 333: 244, 245: 245, 246: 246, 247: 247, 371: 248, 322: 249, 347: 250, 363: 251, 252: 252, 380: 253, 382: 254, 729: 255,
				65281: 33, 65282: 34, 65283: 35, 65284: 36, 65285: 37, 65286: 38, 65287: 39, 65288: 40, 65289: 41, 65290: 42, 65291: 43, 65292: 44, 65293: 45, 65294: 46, 65295: 47, 65296: 48,
				65297: 49, 65298: 50, 65299: 51, 65300: 52, 65301: 53, 65302: 54, 65303: 55, 65304: 56, 65305: 57, 65306: 58, 65307: 59, 65308: 60, 65309: 61, 65310: 62, 65312: 64, 65313: 65,
				65314: 66, 65315: 67, 65316: 68, 65317: 69, 65318: 70, 65319: 71, 65320: 72, 65321: 73, 65322: 74, 65323: 75, 65324: 76, 65325: 77, 65326: 78, 65327: 79, 65328: 80, 65329: 81,
				65330: 82, 65331: 83, 65332: 84, 65333: 85, 65334: 86, 65335: 87, 65336: 88, 65337: 89, 65338: 90, 65339: 91, 65340: 92, 65341: 93, 65342: 94, 65343: 95, 65344: 96, 65345: 97,
				65346: 98, 65347: 99, 65348: 100, 65349: 101, 65350: 102, 65351: 103, 65352: 104, 65353: 105, 65354: 106, 65355: 107, 65356: 108, 65357: 109, 65358: 110, 65359: 111, 65360: 112, 65361: 113,
				65362: 114, 65363: 115, 65364: 116, 65365: 117, 65366: 118, 65367: 119, 65368: 120, 65369: 121, 65370: 122, 65371: 123, 65372: 124, 65373: 125, 65374: 126,
			},
		}
	case 0xb4: // 180
		return &StringConverter{
			LangID:    180,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 123, 224, 225, 227, 229, 231, 241, 196, 46, 60, 40, 43, 33,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 126, 220, 36, 42, 41, 59, 94,
				45, 47, 194, 91, 192, 193, 195, 197, 199, 209, 246, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 167, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				181, 223, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 64, 182, 188, 189, 190, 172, 124, 175, 168, 180, 215,
				228, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 166, 242, 243, 245,
				252, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 125, 249, 250, 255,
				214, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 92, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 93, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 123: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 196: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 126: 89, 220: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 91: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 246: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 167: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 164: 159, 181: 160, 223: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 64: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 168: 189, 180: 190, 215: 191, 228: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 166: 204, 242: 205, 243: 206, 245: 207, 252: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 125: 220, 249: 221, 250: 222, 255: 223, 214: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 92: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 93: 252, 217: 253, 218: 254, 159: 255, 8216: 121, 8248: 95,
				8764: 89, 376: 232,
			},
		}
	case 0xb5: // 181
		return &StringConverter{
			LangID:    181,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 123, 225, 227, 229, 92, 241, 176, 46, 60, 40, 43, 33,
				38, 93, 234, 235, 125, 237, 238, 239, 126, 223, 233, 36, 42, 41, 59, 94,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 242, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 249, 58, 163, 167, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				91, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				181, 236, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 35, 165, 183, 169, 64, 182, 188, 189, 190, 172, 124, 175, 168, 180, 215,
				224, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 166, 243, 245,
				232, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 96, 250, 255,
				231, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 123: 68, 225: 69, 227: 70, 229: 71, 92: 72, 241: 73, 176: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 93: 81,
				234: 82, 235: 83, 125: 84, 237: 85, 238: 86, 239: 87, 126: 88, 223: 89, 233: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 242: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 249: 121, 58: 122, 163: 123, 167: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 91: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 164: 159, 181: 160, 236: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 35: 177,
				165: 178, 183: 179, 169: 180, 64: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 168: 189, 180: 190, 215: 191, 224: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 166: 205, 243: 206, 245: 207, 232: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 96: 221, 250: 222, 255: 223, 231: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255, 8216: 221, 8248: 95,
				8764: 88, 376: 232,
			},
		}
	case 0xb6: // 182
		return &StringConverter{
			LangID:    182,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 125, 231, 241, 35, 46, 60, 40, 43, 33,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 164, 197, 42, 41, 59, 94,
				45, 47, 194, 196, 192, 193, 195, 36, 199, 209, 248, 44, 37, 95, 62, 63,
				166, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 198, 216, 39, 61, 34,
				64, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 123, 184, 91, 93,
				181, 252, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 172, 124, 175, 168, 180, 215,
				230, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				229, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 126, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 125: 71, 231: 72, 241: 73, 35: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 164: 90, 197: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 36: 103, 199: 104, 209: 105, 248: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 166: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 198: 123, 216: 124, 39: 125, 61: 126, 34: 127, 64: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 123: 156, 184: 157, 91: 158, 93: 159, 181: 160, 252: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 168: 189, 180: 190, 215: 191, 230: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 229: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 126: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255,
			},
		}
	case 0xb7: // 183
		return &StringConverter{
			LangID:    183,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 123, 224, 225, 227, 125, 231, 241, 167, 46, 60, 40, 43, 33,
				38, 96, 234, 235, 232, 237, 238, 239, 236, 223, 164, 197, 42, 41, 59, 94,
				45, 47, 194, 35, 192, 193, 195, 36, 199, 209, 246, 44, 37, 95, 62, 63,
				248, 92, 202, 203, 200, 205, 206, 207, 204, 233, 58, 196, 214, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 93,
				181, 252, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 91, 182, 188, 189, 190, 172, 124, 175, 168, 180, 215,
				228, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 166, 242, 243, 245,
				229, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 126, 249, 250, 255,
				201, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 64, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 123: 67, 224: 68, 225: 69, 227: 70, 125: 71, 231: 72, 241: 73, 167: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 96: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 164: 90, 197: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 35: 99, 192: 100, 193: 101, 195: 102, 36: 103, 199: 104, 209: 105, 246: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 92: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 233: 121, 58: 122, 196: 123, 214: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 93: 159, 181: 160, 252: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 91: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 168: 189, 180: 190, 215: 191, 228: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 166: 204, 242: 205, 243: 206, 245: 207, 229: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 126: 220, 249: 221, 250: 222, 255: 223, 201: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 64: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255,
			},
		}
	case 0xb8: // 184
		return &StringConverter{
			LangID:    184,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 355, 225, 259, 269, 231, 263, 91, 46, 60, 40, 43, 33,
				38, 233, 281, 235, 367, 237, 238, 318, 314, 223, 93, 36, 42, 41, 59, 94,
				45, 47, 194, 196, 733, 193, 258, 268, 199, 262, 124, 44, 37, 95, 62, 63,
				711, 201, 280, 203, 366, 205, 206, 317, 313, 96, 58, 35, 64, 39, 61, 34,
				728, 97, 98, 99, 100, 101, 102, 103, 104, 105, 347, 328, 273, 253, 345, 351,
				730, 106, 107, 108, 109, 110, 111, 112, 113, 114, 322, 324, 353, 184, 731, 164,
				261, 126, 115, 116, 117, 118, 119, 120, 121, 122, 346, 327, 272, 221, 344, 350,
				729, 260, 380, 354, 379, 167, 382, 378, 381, 377, 321, 323, 352, 168, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 341, 243, 337,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 282, 369, 252, 357, 250, 283,
				92, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 271, 212, 214, 340, 211, 336,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 270, 368, 220, 356, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 355: 68, 225: 69, 259: 70, 269: 71, 231: 72, 263: 73, 91: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 233: 81,
				281: 82, 235: 83, 367: 84, 237: 85, 238: 86, 318: 87, 314: 88, 223: 89, 93: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 733: 100, 193: 101, 258: 102, 268: 103, 199: 104, 262: 105, 124: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 711: 112, 201: 113,
				280: 114, 203: 115, 366: 116, 205: 117, 206: 118, 317: 119, 313: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 728: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 347: 138, 328: 139, 273: 140, 253: 141, 345: 142, 351: 143, 730: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 322: 154, 324: 155, 353: 156, 184: 157, 731: 158, 164: 159, 261: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 346: 170, 327: 171, 272: 172, 221: 173, 344: 174, 350: 175, 729: 176, 260: 177,
				380: 178, 354: 179, 379: 180, 167: 181, 382: 182, 378: 183, 381: 184, 377: 185, 321: 186, 323: 187, 352: 188, 168: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 341: 205, 243: 206, 337: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 282: 218, 369: 219, 252: 220, 357: 221, 250: 222, 283: 223, 92: 224, 65535: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 271: 234, 212: 235, 214: 236, 340: 237, 211: 238, 336: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 270: 250, 368: 251, 220: 252, 356: 253, 218: 254, 159: 255, 176: 144,
			},
		}
	case 0xb9: // 185
		return &StringConverter{
			LangID:    185,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 1106, 1107, 1105, 1108, 1109, 1110, 1111, 1112, 91, 46, 60, 40, 43, 33,
				38, 1113, 1114, 1115, 1116, 1118, 1119, 1066, 8470, 1026, 93, 36, 42, 41, 59, 94,
				45, 47, 1027, 1025, 1028, 1029, 1030, 1031, 1032, 1033, 124, 44, 37, 95, 62, 63,
				1034, 1035, 1036, 173, 1038, 1039, 1102, 1072, 1073, 96, 58, 35, 64, 39, 61, 34,
				1094, 97, 98, 99, 100, 101, 102, 103, 104, 105, 1076, 1077, 1092, 1075, 1093, 1080,
				1081, 106, 107, 108, 109, 110, 111, 112, 113, 114, 1082, 1083, 1084, 1085, 1086, 1087,
				1103, 126, 115, 116, 117, 118, 119, 120, 121, 122, 1088, 1089, 1090, 1091, 1078, 1074,
				1100, 1099, 1079, 1096, 1101, 1097, 1095, 1098, 1070, 1040, 1041, 1062, 1044, 1045, 1060, 1043,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 1061, 1048, 1049, 1050, 1051, 1052,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 1053, 1054, 1055, 1071, 1056, 1057,
				92, 167, 83, 84, 85, 86, 87, 88, 89, 90, 1058, 1059, 1046, 1042, 1068, 1067,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 1047, 1064, 1069, 1065, 1063, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				1106: 66, 1107: 67, 1105: 68, 1108: 69, 1109: 70, 1110: 71, 1111: 72, 1112: 73, 91: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 1113: 81,
				1114: 82, 1115: 83, 1116: 84, 1118: 85, 1119: 86, 1066: 87, 8470: 88, 1026: 89, 93: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				1027: 98, 1025: 99, 1028: 100, 1029: 101, 1030: 102, 1031: 103, 1032: 104, 1033: 105, 124: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 1034: 112, 1035: 113,
				1036: 114, 173: 115, 1038: 116, 1039: 117, 1102: 118, 1072: 119, 1073: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 1094: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 1076: 138, 1077: 139, 1092: 140, 1075: 141, 1093: 142, 1080: 143, 1081: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 1082: 154, 1083: 155, 1084: 156, 1085: 157, 1086: 158, 1087: 159, 1103: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 1088: 170, 1089: 171, 1090: 172, 1091: 173, 1078: 174, 1074: 175, 1100: 176, 1099: 177,
				1079: 178, 1096: 179, 1101: 180, 1097: 181, 1095: 182, 1098: 183, 1070: 184, 1040: 185, 1041: 186, 1062: 187, 1044: 188, 1045: 189, 1060: 190, 1043: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 1061: 202, 1048: 203, 1049: 204, 1050: 205, 1051: 206, 1052: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 1053: 218, 1054: 219, 1055: 220, 1071: 221, 1056: 222, 1057: 223, 92: 224, 167: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 1058: 234, 1059: 235, 1046: 236, 1042: 237, 1068: 238, 1067: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 1047: 250, 1064: 251, 1069: 252, 1065: 253, 1063: 254, 159: 255,
			},
		}
	case 0xba: // 186
		return &StringConverter{
			LangID:    186,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 64, 225, 227, 229, 92, 241, 176, 46, 60, 40, 43, 33,
				38, 123, 234, 235, 125, 237, 238, 239, 236, 223, 167, 36, 42, 41, 59, 94,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 249, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 181, 58, 163, 224, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				91, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				96, 168, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 35, 165, 183, 169, 93, 182, 188, 189, 190, 172, 124, 175, 126, 180, 215,
				233, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				232, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 166, 250, 255,
				231, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 64: 68, 225: 69, 227: 70, 229: 71, 92: 72, 241: 73, 176: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 123: 81,
				234: 82, 235: 83, 125: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 167: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 249: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 181: 121, 58: 122, 163: 123, 224: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 91: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 164: 159, 96: 160, 168: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 35: 177,
				165: 178, 183: 179, 169: 180, 93: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 126: 189, 180: 190, 215: 191, 233: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 232: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 166: 221, 250: 222, 255: 223, 231: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255,
			},
		}
	case 0xbb: // 187
		return &StringConverter{
			LangID:    187,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 162, 46, 60, 40, 43, 124,
				38, 1497, 1498, 1499, 1500, 1501, 1502, 1503, 1504, 1505, 33, 36, 42, 41, 59, 172,
				45, 47, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 166, 44, 37, 95, 62, 63,
				65535, 1514, 65535, 65535, 160, 65535, 65535, 65535, 819, 96, 58, 35, 64, 39, 61, 34,
				65535, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 65535, 65535, 65535, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 65535, 65535, 65535, 184, 65535, 164,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 65535, 65535, 65535, 65535, 65535, 174,
				94, 163, 165, 183, 169, 167, 182, 188, 189, 190, 91, 93, 175, 168, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 65535, 65535, 65535, 65535, 65535,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 65535, 65535, 65535, 65535, 65535,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 65535, 65535, 65535, 65535, 65535,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 65535, 65535, 65535, 65535, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 1488: 65,
				1489: 66, 1490: 67, 1491: 68, 1492: 69, 1493: 70, 1494: 71, 1495: 72, 1496: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 1497: 81,
				1498: 82, 1499: 83, 1500: 84, 1501: 85, 1502: 86, 1503: 87, 1504: 88, 1505: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 172: 95, 45: 96, 47: 97,
				1506: 98, 1507: 99, 1508: 100, 1509: 101, 1510: 102, 1511: 103, 1512: 104, 1513: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 65535: 254, 1514: 113,
				160: 116, 819: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135,
				104: 136, 105: 137, 171: 138, 187: 139, 177: 143, 176: 144, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 184: 157,
				164: 159, 181: 160, 126: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 174: 175, 94: 176, 163: 177, 165: 178, 183: 179,
				169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 91: 186, 93: 187, 175: 188, 168: 189, 180: 190, 215: 191, 123: 192, 65: 193, 66: 194, 67: 195,
				68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 125: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216,
				82: 217, 185: 218, 92: 224, 247: 225, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 48: 240, 49: 241, 50: 242,
				51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 159: 255,
			},
		}
	case 0xbc: // 188
		return &StringConverter{
			LangID:    188,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 1106, 1107, 1105, 1108, 1109, 1110, 1111, 1112, 91, 46, 60, 40, 43, 33,
				38, 1113, 1114, 1115, 1116, 1118, 1119, 1066, 8470, 1026, 93, 36, 42, 41, 59, 94,
				45, 47, 1027, 1025, 1028, 1029, 1030, 1031, 1032, 1033, 166, 44, 37, 95, 62, 63,
				1034, 1035, 1036, 173, 1038, 1039, 1102, 1072, 1073, 96, 58, 35, 64, 39, 61, 34,
				1094, 97, 98, 99, 100, 101, 102, 103, 104, 105, 1076, 1077, 1092, 1075, 1093, 1080,
				1081, 106, 107, 108, 109, 110, 111, 112, 113, 114, 1082, 1083, 1084, 1085, 1086, 1087,
				1103, 126, 115, 116, 117, 118, 119, 120, 121, 122, 1088, 1089, 1090, 1091, 1078, 1074,
				1100, 1099, 1079, 1096, 1101, 1097, 1095, 1098, 1070, 1040, 1041, 1062, 1044, 1045, 1060, 1043,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 1061, 1048, 1049, 1050, 1051, 1052,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 1053, 1054, 1055, 1071, 1056, 1057,
				92, 164, 83, 84, 85, 86, 87, 88, 89, 90, 1058, 1059, 1046, 1042, 1068, 1067,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 1047, 1064, 1069, 1065, 1063, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				1106: 66, 1107: 67, 1105: 68, 1108: 69, 1109: 70, 1110: 71, 1111: 72, 1112: 73, 91: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 1113: 81,
				1114: 82, 1115: 83, 1116: 84, 1118: 85, 1119: 86, 1066: 87, 8470: 88, 1026: 89, 93: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				1027: 98, 1025: 99, 1028: 100, 1029: 101, 1030: 102, 1031: 103, 1032: 104, 1033: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 1034: 112, 1035: 113,
				1036: 114, 173: 115, 1038: 116, 1039: 117, 1102: 118, 1072: 119, 1073: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 1094: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 1076: 138, 1077: 139, 1092: 140, 1075: 141, 1093: 142, 1080: 143, 1081: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 1082: 154, 1083: 155, 1084: 156, 1085: 157, 1086: 158, 1087: 159, 1103: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 1088: 170, 1089: 171, 1090: 172, 1091: 173, 1078: 174, 1074: 175, 1100: 176, 1099: 177,
				1079: 178, 1096: 179, 1101: 180, 1097: 181, 1095: 182, 1098: 183, 1070: 184, 1040: 185, 1041: 186, 1062: 187, 1044: 188, 1045: 189, 1060: 190, 1043: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 1061: 202, 1048: 203, 1049: 204, 1050: 205, 1051: 206, 1052: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 1053: 218, 1054: 219, 1055: 220, 1071: 221, 1056: 222, 1057: 223, 92: 224, 164: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 1058: 234, 1059: 235, 1046: 236, 1042: 237, 1068: 238, 1067: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 1047: 250, 1064: 251, 1069: 252, 1065: 253, 1063: 254, 159: 255,
			},
		}
	case 0xbd: // 189
		return &StringConverter{
			LangID:    189,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 123, 224, 225, 227, 229, 231, 241, 196, 46, 60, 40, 43, 33,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 126, 220, 36, 42, 41, 59, 94,
				45, 47, 194, 91, 192, 193, 195, 197, 199, 209, 246, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 167, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 8364,
				181, 223, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 64, 182, 188, 189, 190, 172, 124, 175, 168, 180, 215,
				228, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 166, 242, 243, 245,
				252, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 125, 249, 250, 255,
				214, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 92, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 93, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 123: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 196: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 126: 89, 220: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 91: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 246: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 167: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 8364: 159, 181: 160, 223: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 64: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 168: 189, 180: 190, 215: 191, 228: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 166: 204, 242: 205, 243: 206, 245: 207, 252: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 125: 220, 249: 221, 250: 222, 255: 223, 214: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 92: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 93: 252, 217: 253, 218: 254, 159: 255, 8216: 121, 8248: 95,
				8764: 89, 376: 232,
			},
		}
	case 0xbe: // 190
		return &StringConverter{
			LangID:    190,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 239, 238, 236, 196, 197,
				201, 230, 198, 244, 246, 242, 251, 249, 255, 214, 220, 248, 163, 216, 8359, 402,
				225, 237, 243, 250, 241, 209, 170, 186, 191, 65535, 172, 189, 188, 161, 171, 164,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				945, 946, 915, 960, 931, 963, 956, 964, 934, 920, 937, 948, 65535, 966, 949, 65535,
				65535, 177, 8805, 8804, 65535, 65535, 247, 65535, 176, 183, 65535, 65535, 65535, 178, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 252: 129, 233: 130, 226: 131, 228: 132, 224: 133, 229: 134, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 236: 141, 196: 142, 197: 143,
				201: 144, 230: 145, 198: 146, 244: 147, 246: 148, 242: 149, 251: 150, 249: 151, 255: 152, 214: 153, 220: 154, 248: 155, 163: 156, 216: 157, 8359: 158, 402: 159,
				225: 160, 237: 161, 243: 162, 250: 163, 241: 164, 209: 165, 170: 166, 186: 167, 191: 168, 65535: 255, 172: 170, 189: 171, 188: 172, 161: 173, 171: 174, 164: 175,
				945: 224, 946: 225, 915: 226, 960: 227, 931: 228, 963: 229, 956: 230, 964: 231, 934: 232, 920: 233, 937: 234, 948: 235, 966: 237, 949: 238, 177: 241, 8805: 242,
				8804: 243, 247: 246, 176: 248, 183: 249, 178: 253, 8718: 254, 187: 175, 8216: 96, 8213: 45, 160: 32, 173: 45, 166: 124, 180: 39, 8248: 94, 8764: 126, 162: 155,
				165: 157, 8356: 76, 192: 65, 193: 65, 194: 65, 200: 69, 202: 69, 204: 73, 205: 73, 206: 73, 210: 79, 211: 79, 212: 79, 217: 85, 218: 85, 219: 85,
				221: 89, 253: 121, 223: 225, 63741: 159,
			},
		}
	case 0xbf: // 191
		return &StringConverter{
			LangID:    191,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				160, 8221, 162, 163, 164, 8222, 166, 167, 216, 169, 342, 171, 172, 173, 174, 198,
				176, 177, 178, 179, 8220, 181, 182, 183, 248, 185, 343, 187, 188, 189, 190, 230,
				260, 302, 256, 262, 196, 197, 280, 274, 268, 201, 377, 278, 290, 310, 298, 315,
				352, 323, 325, 211, 332, 213, 214, 215, 370, 321, 346, 362, 220, 379, 381, 223,
				261, 303, 257, 263, 228, 229, 281, 275, 269, 233, 378, 279, 291, 311, 299, 316,
				353, 324, 326, 243, 333, 245, 246, 247, 371, 322, 347, 363, 252, 380, 382, 8217,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 159, 160: 160, 8221: 161, 162: 162, 163: 163, 164: 164, 8222: 165, 166: 166, 167: 167, 216: 168, 169: 169, 342: 170, 171: 171, 172: 172, 173: 173, 174: 174,
				198: 175, 176: 176, 177: 177, 178: 178, 179: 179, 8220: 180, 181: 181, 182: 182, 183: 183, 248: 184, 185: 185, 343: 186, 187: 187, 188: 188, 189: 189, 190: 190,
				230: 191, 260: 192, 302: 193, 256: 194, 262: 195, 196: 196, 197: 197, 280: 198, 274: 199, 268: 200, 201: 201, 377: 202, 278: 203, 290: 204, 310: 205, 298: 206,
				315: 207, 352: 208, 323: 209, 325: 210, 211: 211, 332: 212, 213: 213, 214: 214, 215: 215, 370: 216, 321: 217, 346: 218, 362: 219, 220: 220, 379: 221, 381: 222,
				223: 223, 261: 224, 303: 225, 257: 226, 263: 227, 228: 228, 229: 229, 281: 230, 275: 231, 269: 232, 233: 233, 378: 234, 279: 235, 291: 236, 311: 237, 299: 238,
				316: 239, 353: 240, 324: 241, 326: 242, 243: 243, 333: 244, 245: 245, 246: 246, 247: 247, 371: 248, 322: 249, 347: 250, 363: 251, 252: 252, 380: 253, 382: 254,
				8217: 255,
			},
		}
	case 0xc0: // 192
		return &StringConverter{
			LangID:    192,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				262, 252, 233, 257, 228, 291, 229, 263, 322, 275, 279, 303, 299, 377, 196, 197,
				201, 379, 380, 333, 246, 290, 363, 346, 347, 214, 220, 324, 315, 321, 215, 269,
				256, 298, 243, 371, 260, 261, 381, 382, 280, 281, 278, 378, 268, 302, 171, 187,
				9617, 9618, 9619, 9474, 9508, 9569, 9570, 9558, 9557, 9571, 9553, 9559, 9565, 9564, 9563, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 9566, 9567, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 9575,
				9576, 9572, 9573, 9561, 9560, 9554, 9555, 9579, 9578, 9496, 9484, 9608, 9604, 9612, 9616, 9600,
				211, 223, 332, 323, 245, 213, 352, 353, 310, 311, 362, 370, 316, 274, 325, 326,
				173, 177, 230, 198, 182, 164, 247, 248, 176, 216, 183, 343, 342, 8222, 8220, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				262: 128, 252: 129, 233: 130, 257: 131, 228: 132, 291: 133, 229: 134, 263: 135, 322: 136, 275: 137, 279: 138, 303: 139, 299: 140, 377: 141, 196: 142, 197: 143,
				201: 144, 379: 145, 380: 146, 333: 147, 246: 148, 290: 149, 363: 150, 346: 151, 347: 152, 214: 153, 220: 154, 324: 155, 315: 156, 321: 157, 215: 158, 269: 159,
				256: 160, 298: 161, 243: 162, 371: 163, 260: 164, 261: 165, 381: 166, 382: 167, 280: 168, 281: 169, 278: 170, 378: 171, 268: 172, 302: 173, 171: 174, 187: 175,
				9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 9569: 181, 9570: 182, 9558: 183, 9557: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 9564: 189, 9563: 190, 9488: 191,
				9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 9566: 198, 9567: 199, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 9575: 207,
				9576: 208, 9572: 209, 9573: 210, 9561: 211, 9560: 212, 9554: 213, 9555: 214, 9579: 215, 9578: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 9612: 221, 9616: 222, 9600: 223,
				211: 224, 223: 225, 332: 226, 323: 227, 245: 228, 213: 229, 352: 230, 353: 231, 310: 232, 311: 233, 362: 234, 370: 235, 316: 236, 274: 237, 325: 238, 326: 239,
				173: 240, 177: 241, 230: 242, 198: 243, 182: 244, 164: 245, 247: 246, 248: 247, 176: 248, 216: 249, 183: 250, 343: 251, 342: 252, 8222: 253, 8220: 254, 160: 255,
			},
		}
	case 0xc1: // 193
		return &StringConverter{
			LangID:    193,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055,
				1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071,
				1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087,
				9617, 9618, 9619, 9474, 9508, 256, 65535, 326, 9557, 9571, 9553, 9559, 9565, 332, 9563, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 257, 65535, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 65535,
				352, 65535, 269, 268, 9560, 9554, 501, 298, 299, 9496, 9484, 9608, 9604, 363, 362, 9600,
				1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103,
				274, 275, 290, 311, 310, 316, 315, 382, 381, 333, 183, 8730, 325, 353, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1040: 128, 1041: 129, 1042: 130, 1043: 131, 1044: 132, 1045: 133, 1046: 134, 1047: 135, 1048: 136, 1049: 137, 1050: 138, 1051: 139, 1052: 140, 1053: 141, 1054: 142, 1055: 143,
				1056: 144, 1057: 145, 1058: 146, 1059: 147, 1060: 148, 1061: 149, 1062: 150, 1063: 151, 1064: 152, 1065: 153, 1066: 154, 1067: 155, 1068: 156, 1069: 157, 1070: 158, 1071: 159,
				1072: 160, 1073: 161, 1074: 162, 1075: 163, 1076: 164, 1077: 165, 1078: 166, 1079: 167, 1080: 168, 1081: 169, 1082: 170, 1083: 171, 1084: 172, 1085: 173, 1086: 174, 1087: 175,
				9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 256: 181, 65535: 255, 326: 183, 9557: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 332: 189, 9563: 190, 9488: 191,
				9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 257: 198, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 352: 208, 269: 210,
				268: 211, 9560: 212, 9554: 213, 501: 214, 298: 215, 299: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 363: 221, 362: 222, 9600: 223, 1088: 224, 1089: 225, 1090: 226,
				1091: 227, 1092: 228, 1093: 229, 1094: 230, 1095: 231, 1096: 232, 1097: 233, 1098: 234, 1099: 235, 1100: 236, 1101: 237, 1102: 238, 1103: 239, 274: 240, 275: 241, 290: 242,
				311: 243, 310: 244, 316: 245, 315: 246, 382: 247, 381: 248, 333: 249, 183: 250, 8730: 251, 325: 252, 353: 253, 8718: 254,
			},
		}
	case 0xc2: // 194
		return &StringConverter{
			LangID:    194,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 353, 228, 261, 303, 363, 229, 275, 382, 162, 46, 60, 40, 43, 124,
				38, 233, 281, 279, 269, 371, 8222, 8220, 501, 223, 33, 36, 42, 41, 59, 172,
				45, 47, 352, 196, 260, 302, 362, 197, 274, 381, 166, 44, 37, 95, 62, 63,
				248, 201, 280, 278, 268, 370, 298, 315, 290, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 257, 380, 324, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 342, 343, 230, 311, 198, 164,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 8221, 378, 256, 379, 323, 174,
				94, 163, 299, 183, 169, 167, 182, 188, 189, 190, 91, 93, 377, 310, 316, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 333, 246, 326, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 263, 252, 322, 347, 8217,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 332, 214, 325, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 262, 220, 321, 346, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				353: 66, 228: 67, 261: 68, 303: 69, 363: 70, 229: 71, 275: 72, 382: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				281: 82, 279: 83, 269: 84, 371: 85, 8222: 86, 8220: 87, 501: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 172: 95, 45: 96, 47: 97,
				352: 98, 196: 99, 260: 100, 302: 101, 362: 102, 197: 103, 274: 104, 381: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				280: 114, 278: 115, 268: 116, 370: 117, 298: 118, 315: 119, 290: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 257: 140, 380: 141, 324: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 342: 154, 343: 155, 230: 156, 311: 157, 198: 158, 164: 159, 181: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 8221: 170, 378: 171, 256: 172, 379: 173, 323: 174, 174: 175, 94: 176, 163: 177,
				299: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 91: 186, 93: 187, 377: 188, 310: 189, 316: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 333: 203, 246: 204, 326: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 263: 219, 252: 220, 322: 221, 347: 222, 8217: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 332: 235, 214: 236, 325: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 262: 251, 220: 252, 321: 253, 346: 254, 159: 255,
			},
		}
	case 0xc3: // 195
		return &StringConverter{
			LangID:    195,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055,
				1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071,
				1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087,
				9617, 9618, 9619, 9474, 9508, 256, 9570, 326, 9557, 9571, 9553, 9559, 9565, 332, 9563, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 257, 9567, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 9575,
				352, 9572, 269, 268, 9560, 9554, 291, 298, 299, 9496, 9484, 9608, 9604, 363, 362, 9600,
				1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103,
				274, 275, 290, 311, 310, 316, 315, 382, 381, 333, 183, 8730, 325, 353, 8718, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1040: 128, 1041: 129, 1042: 130, 1043: 131, 1044: 132, 1045: 133, 1046: 134, 1047: 135, 1048: 136, 1049: 137, 1050: 138, 1051: 139, 1052: 140, 1053: 141, 1054: 142, 1055: 143,
				1056: 144, 1057: 145, 1058: 146, 1059: 147, 1060: 148, 1061: 149, 1062: 150, 1063: 151, 1064: 152, 1065: 153, 1066: 154, 1067: 155, 1068: 156, 1069: 157, 1070: 158, 1071: 159,
				1072: 160, 1073: 161, 1074: 162, 1075: 163, 1076: 164, 1077: 165, 1078: 166, 1079: 167, 1080: 168, 1081: 169, 1082: 170, 1083: 171, 1084: 172, 1085: 173, 1086: 174, 1087: 175,
				9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 256: 181, 9570: 182, 326: 183, 9557: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 332: 189, 9563: 190, 9488: 191,
				9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 257: 198, 9567: 199, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 9575: 207,
				352: 208, 9572: 209, 269: 210, 268: 211, 9560: 212, 9554: 213, 291: 214, 298: 215, 299: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 363: 221, 362: 222, 9600: 223,
				1088: 224, 1089: 225, 1090: 226, 1091: 227, 1092: 228, 1093: 229, 1094: 230, 1095: 231, 1096: 232, 1097: 233, 1098: 234, 1099: 235, 1100: 236, 1101: 237, 1102: 238, 1103: 239,
				274: 240, 275: 241, 290: 242, 311: 243, 310: 244, 316: 245, 315: 246, 382: 247, 381: 248, 333: 249, 183: 250, 8730: 251, 325: 252, 353: 253, 8718: 254, 160: 255,
			},
		}
	case 0xc4: // 196
		return &StringConverter{
			LangID:    196,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  148,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				9472, 9474, 9484, 9488, 9492, 9496, 9500, 9508, 9516, 9524, 9532, 9600, 9604, 9608, 9612, 9616,
				9617, 9618, 9619, 8992, 8718, 8226, 8730, 8776, 8804, 8805, 160, 8993, 176, 178, 183, 247,
				9552, 9553, 9554, 1105, 9555, 9556, 9557, 9558, 9559, 9560, 9561, 9562, 9563, 9564, 9565, 9566,
				9567, 9568, 9569, 1025, 9570, 9571, 9572, 9573, 9574, 9575, 9576, 9577, 9578, 9579, 9580, 169,
				1102, 1072, 1073, 1094, 1076, 1077, 1092, 1075, 1093, 1080, 1081, 1082, 1083, 1084, 1085, 1086,
				1087, 1103, 1088, 1089, 1090, 1091, 1078, 1074, 1100, 1099, 1079, 1096, 1101, 1097, 1095, 1098,
				1070, 1040, 1041, 1062, 1044, 1045, 1060, 1043, 1061, 1048, 1049, 1050, 1051, 1052, 1053, 1054,
				1055, 1071, 1056, 1057, 1058, 1059, 1046, 1042, 1068, 1067, 1047, 1064, 1069, 1065, 1063, 1066,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				9472: 128, 9474: 129, 9484: 130, 9488: 131, 9492: 132, 9496: 133, 9500: 134, 9508: 135, 9516: 136, 9524: 137, 9532: 138, 9600: 139, 9604: 140, 9608: 141, 9612: 142, 9616: 143,
				9617: 144, 9618: 145, 9619: 146, 8992: 147, 8718: 148, 8226: 149, 8730: 150, 8776: 151, 8804: 152, 8805: 153, 160: 154, 8993: 155, 176: 156, 178: 157, 183: 158, 247: 159,
				9552: 160, 9553: 161, 9554: 162, 1105: 163, 9555: 164, 9556: 165, 9557: 166, 9558: 167, 9559: 168, 9560: 169, 9561: 170, 9562: 171, 9563: 172, 9564: 173, 9565: 174, 9566: 175,
				9567: 176, 9568: 177, 9569: 178, 1025: 179, 9570: 180, 9571: 181, 9572: 182, 9573: 183, 9574: 184, 9575: 185, 9576: 186, 9577: 187, 9578: 188, 9579: 189, 9580: 190, 169: 191,
				1102: 192, 1072: 193, 1073: 194, 1094: 195, 1076: 196, 1077: 197, 1092: 198, 1075: 199, 1093: 200, 1080: 201, 1081: 202, 1082: 203, 1083: 204, 1084: 205, 1085: 206, 1086: 207,
				1087: 208, 1103: 209, 1088: 210, 1089: 211, 1090: 212, 1091: 213, 1078: 214, 1074: 215, 1100: 216, 1099: 217, 1079: 218, 1096: 219, 1101: 220, 1097: 221, 1095: 222, 1098: 223,
				1070: 224, 1040: 225, 1041: 226, 1062: 227, 1044: 228, 1045: 229, 1060: 230, 1043: 231, 1061: 232, 1048: 233, 1049: 234, 1050: 235, 1051: 236, 1052: 237, 1053: 238, 1054: 239,
				1055: 240, 1071: 241, 1056: 242, 1057: 243, 1058: 244, 1059: 245, 1046: 246, 1042: 247, 1068: 248, 1067: 249, 1047: 250, 1064: 251, 1069: 252, 1065: 253, 1063: 254, 1066: 255,
			},
		}
	case 0xc5: // 197
		return &StringConverter{
			LangID:    197,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				262, 252, 233, 257, 228, 291, 229, 263, 322, 275, 342, 343, 299, 377, 196, 197,
				201, 230, 198, 333, 246, 290, 162, 346, 347, 214, 220, 248, 163, 216, 215, 164,
				256, 298, 243, 379, 380, 378, 8221, 166, 169, 174, 172, 189, 188, 321, 171, 187,
				9617, 9618, 9619, 9474, 9508, 260, 268, 280, 278, 9571, 9553, 9559, 9565, 302, 352, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 370, 362, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 381,
				261, 269, 281, 279, 303, 353, 371, 363, 382, 9496, 9484, 9608, 9604, 9612, 9616, 9600,
				211, 223, 332, 323, 245, 213, 181, 324, 310, 311, 315, 316, 326, 274, 325, 8217,
				173, 177, 8220, 190, 182, 167, 247, 8222, 176, 8226, 183, 185, 179, 178, 8718, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				262: 128, 252: 129, 233: 130, 257: 131, 228: 132, 291: 133, 229: 134, 263: 135, 322: 136, 275: 137, 342: 138, 343: 139, 299: 140, 377: 141, 196: 142, 197: 143,
				201: 144, 230: 145, 198: 146, 333: 147, 246: 148, 290: 149, 162: 150, 346: 151, 347: 152, 214: 153, 220: 154, 248: 155, 163: 156, 216: 157, 215: 158, 164: 159,
				256: 160, 298: 161, 243: 162, 379: 163, 380: 164, 378: 165, 8221: 166, 166: 167, 169: 168, 174: 169, 172: 170, 189: 171, 188: 172, 321: 173, 171: 174, 187: 175,
				9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 260: 181, 268: 182, 280: 183, 278: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 302: 189, 352: 190, 9488: 191,
				9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 370: 198, 362: 199, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 381: 207,
				261: 208, 269: 209, 281: 210, 279: 211, 303: 212, 353: 213, 371: 214, 363: 215, 382: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 9612: 221, 9616: 222, 9600: 223,
				211: 224, 223: 225, 332: 226, 323: 227, 245: 228, 213: 229, 181: 230, 324: 231, 310: 232, 311: 233, 315: 234, 316: 235, 326: 236, 274: 237, 325: 238, 8217: 239,
				173: 240, 177: 241, 8220: 242, 190: 243, 182: 244, 167: 245, 247: 246, 8222: 247, 176: 248, 8226: 249, 183: 250, 185: 251, 179: 252, 178: 253, 8718: 254, 160: 255,
			},
		}
	case 0xc6: // 198
		return &StringConverter{
			LangID:    198,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 125, 231, 241, 35, 46, 60, 40, 43, 33,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 8364, 197, 42, 41, 59, 94,
				45, 47, 194, 196, 192, 193, 195, 36, 199, 209, 248, 44, 37, 95, 62, 63,
				166, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 198, 216, 39, 61, 34,
				64, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 123, 184, 91, 93,
				181, 252, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 172, 124, 175, 168, 180, 215,
				230, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				229, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 126, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 125: 71, 231: 72, 241: 73, 35: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 8364: 90, 197: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 36: 103, 199: 104, 209: 105, 248: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 166: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 198: 123, 216: 124, 39: 125, 61: 126, 34: 127, 64: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 123: 156, 184: 157, 91: 158, 93: 159, 181: 160, 252: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 168: 189, 180: 190, 215: 191, 230: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 229: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 126: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255,
			},
		}
	case 0xc7: // 199
		return &StringConverter{
			LangID:    199,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 123, 224, 225, 227, 125, 231, 241, 167, 46, 60, 40, 43, 33,
				38, 96, 234, 235, 232, 237, 238, 239, 236, 223, 8364, 197, 42, 41, 59, 94,
				45, 47, 194, 35, 192, 193, 195, 36, 199, 209, 246, 44, 37, 95, 62, 63,
				248, 92, 202, 203, 200, 205, 206, 207, 204, 233, 58, 196, 214, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 93,
				181, 252, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 91, 182, 188, 189, 190, 172, 124, 175, 168, 180, 215,
				228, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 166, 242, 243, 245,
				229, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 126, 249, 250, 255,
				201, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 64, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 123: 67, 224: 68, 225: 69, 227: 70, 125: 71, 231: 72, 241: 73, 167: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 96: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 8364: 90, 197: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 35: 99, 192: 100, 193: 101, 195: 102, 36: 103, 199: 104, 209: 105, 246: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 92: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 233: 121, 58: 122, 196: 123, 214: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 93: 159, 181: 160, 252: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 91: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 168: 189, 180: 190, 215: 191, 228: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 166: 204, 242: 205, 243: 206, 245: 207, 229: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 126: 220, 249: 221, 250: 222, 255: 223, 201: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 64: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255,
			},
		}
	case 0xc8: // 200
		return &StringConverter{
			LangID:    200,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 123, 225, 227, 229, 92, 241, 176, 46, 60, 40, 43, 33,
				38, 93, 234, 235, 125, 237, 238, 239, 126, 223, 233, 36, 42, 41, 59, 94,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 242, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 249, 58, 163, 167, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				91, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 8364,
				181, 236, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 35, 165, 183, 169, 64, 182, 188, 189, 190, 172, 124, 175, 168, 180, 215,
				224, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 166, 243, 245,
				232, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 96, 250, 255,
				231, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 123: 68, 225: 69, 227: 70, 229: 71, 92: 72, 241: 73, 176: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 93: 81,
				234: 82, 235: 83, 125: 84, 237: 85, 238: 86, 239: 87, 126: 88, 223: 89, 233: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 242: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 249: 121, 58: 122, 163: 123, 167: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 91: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 8364: 159, 181: 160, 236: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 35: 177,
				165: 178, 183: 179, 169: 180, 64: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 168: 189, 180: 190, 215: 191, 224: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 166: 205, 243: 206, 245: 207, 232: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 96: 221, 250: 222, 255: 223, 231: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255, 8216: 221, 8248: 95,
				8764: 88, 376: 232,
			},
		}
	case 0xc9: // 201
		return &StringConverter{
			LangID:    201,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				224, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 176, 231, 167, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 233, 249, 232, 168, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				224, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 176, 231, 167, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 233, 249, 232, 168, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 35: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				224: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 176: 219, 231: 220, 167: 221, 94: 222, 95: 223,
				96: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 233: 251, 249: 252, 232: 253, 168: 254, 127: 255,
				64: 64, 91: 91, 92: 92, 93: 93, 123: 123, 124: 124, 125: 125, 126: 126, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32, 173: 45, 166: 124,
				180: 39, 8248: 94, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 200: 69, 201: 69, 202: 69, 204: 73, 205: 73, 206: 73, 210: 79,
				211: 79, 212: 79, 217: 85, 218: 85, 219: 85, 225: 97, 226: 97, 234: 101, 236: 105, 237: 105, 238: 105, 242: 111, 243: 111, 244: 111, 250: 117, 251: 117,
			},
		}
	case 0xca: // 202
		return &StringConverter{
			LangID:    202,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 161, 209, 191, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 180, 241, 231, 168, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 161, 209, 191, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 180, 241, 231, 168, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 35: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				64: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 161: 219, 209: 220, 191: 221, 94: 222, 95: 223,
				96: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 180: 251, 241: 252, 231: 253, 168: 254, 127: 255,
				91: 91, 92: 92, 93: 93, 123: 123, 124: 124, 125: 125, 126: 126, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32, 173: 45, 166: 124, 8248: 94, 165: 89,
				63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 200: 69, 201: 69, 202: 69, 204: 73, 205: 73, 206: 73, 210: 79, 211: 79, 212: 79, 217: 85,
				218: 85, 219: 85, 224: 97, 225: 97, 226: 97, 232: 101, 233: 101, 234: 101, 236: 105, 237: 105, 238: 105, 242: 111, 243: 111, 244: 111, 249: 117, 250: 117,
				251: 117,
			},
		}
	case 0xcb: // 203
		return &StringConverter{
			LangID:    203,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 164, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				201, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 197, 220, 95,
				233, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 229, 252, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 164, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				201, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 197, 220, 95,
				233, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 229, 252, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 35: 163, 164: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				201: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 196: 219, 214: 220, 197: 221, 220: 222, 95: 223,
				233: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 228: 251, 246: 252, 229: 253, 252: 254, 127: 255,
				36: 36, 64: 64, 91: 91, 92: 92, 93: 93, 94: 94, 96: 96, 123: 123, 124: 124, 125: 125, 126: 126, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45,
				160: 32, 173: 45, 166: 124, 180: 39, 8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 202: 69, 204: 73, 205: 73,
				206: 73, 210: 79, 211: 79, 212: 79, 217: 85, 218: 85, 219: 85, 224: 97, 225: 98, 226: 99, 231: 99, 234: 101, 236: 105, 237: 105, 238: 105, 242: 111,
				243: 111, 244: 111, 249: 117, 250: 117, 251: 117,
			},
		}
	case 0xcc: // 204
		return &StringConverter{
			LangID:    204,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 198, 216, 197, 220, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 230, 248, 229, 252, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 198, 216, 197, 220, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 230, 248, 229, 252, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 35: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				64: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 198: 219, 216: 220, 197: 221, 220: 222, 95: 223,
				96: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 230: 251, 248: 252, 229: 253, 252: 254, 127: 255,
				91: 91, 92: 92, 93: 93, 94: 94, 123: 123, 124: 124, 125: 125, 126: 126, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32, 173: 45, 180: 39,
				8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 202: 69, 204: 73, 205: 73, 206: 73, 210: 79, 211: 79, 212: 79,
				217: 85, 218: 85, 219: 85, 224: 97, 225: 98, 226: 99, 231: 99, 234: 101, 236: 105, 237: 105, 238: 105, 242: 111, 243: 111, 244: 111, 249: 117, 250: 117,
				251: 117,
			},
		}
	case 0xcd: // 205
		return &StringConverter{
			LangID:    205,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 198, 216, 197, 220, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 230, 248, 229, 252, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 198, 216, 197, 220, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 230, 248, 229, 252, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 35: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				64: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 198: 219, 216: 220, 197: 221, 220: 222, 95: 223,
				96: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 230: 251, 248: 252, 229: 253, 252: 254, 127: 255,
				91: 91, 92: 92, 93: 93, 94: 94, 123: 123, 124: 124, 125: 125, 126: 126, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32, 173: 45, 180: 39,
				8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 202: 69, 204: 73, 205: 73, 206: 73, 210: 79, 211: 79, 212: 79,
				217: 85, 218: 85, 219: 85, 224: 97, 225: 98, 226: 99, 231: 99, 234: 101, 236: 105, 237: 105, 238: 105, 242: 111, 243: 111, 244: 111, 249: 117, 250: 117,
				251: 117,
			},
		}
	case 0xce: // 206
		return &StringConverter{
			LangID:    206,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 163, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				167, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 176, 231, 233, 94, 95,
				249, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 224, 242, 232, 236, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 163, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				167, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 176, 231, 233, 94, 95,
				249, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 224, 242, 232, 236, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 163: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				167: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 176: 219, 231: 220, 233: 221, 94: 222, 95: 223,
				249: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 224: 251, 242: 252, 232: 253, 236: 254, 127: 255,
				35: 35, 64: 64, 91: 91, 92: 92, 93: 93, 96: 96, 123: 123, 124: 124, 125: 125, 126: 126, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32,
				173: 45, 166: 124, 180: 39, 8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 200: 69, 201: 69, 202: 69, 204: 73,
				205: 73, 206: 73, 210: 79, 211: 79, 212: 79, 217: 85, 218: 85, 219: 85, 225: 97, 226: 97, 234: 101, 237: 105, 238: 105, 243: 111, 244: 111, 250: 117,
				251: 117,
			},
		}
	case 0xcf: // 207
		return &StringConverter{
			LangID:    207,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				167, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 220, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 252, 223, 127,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				167, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 220, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 252, 223, 127,
			},
			eBuffer: map[int]int{
				0: 128, 1: 129, 2: 130, 3: 131, 4: 132, 5: 133, 6: 134, 7: 135, 8: 136, 9: 137, 10: 138, 11: 139, 12: 140, 13: 141, 14: 142, 15: 143,
				16: 144, 17: 145, 18: 146, 19: 147, 20: 148, 21: 149, 22: 150, 23: 151, 24: 152, 25: 153, 26: 154, 27: 155, 28: 156, 29: 157, 30: 158, 31: 159,
				32: 160, 33: 161, 34: 162, 35: 163, 36: 164, 37: 165, 38: 166, 39: 167, 40: 168, 41: 169, 42: 170, 43: 171, 44: 172, 45: 173, 46: 174, 47: 175,
				48: 176, 49: 177, 50: 178, 51: 179, 52: 180, 53: 181, 54: 182, 55: 183, 56: 184, 57: 185, 58: 186, 59: 187, 60: 188, 61: 189, 62: 190, 63: 191,
				167: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 202, 75: 203, 76: 204, 77: 205, 78: 206, 79: 207,
				80: 208, 81: 209, 82: 210, 83: 211, 84: 212, 85: 213, 86: 214, 87: 215, 88: 216, 89: 217, 90: 218, 196: 219, 214: 220, 220: 221, 94: 222, 95: 223,
				96: 224, 97: 225, 98: 226, 99: 227, 100: 228, 101: 229, 102: 230, 103: 231, 104: 232, 105: 233, 106: 234, 107: 235, 108: 236, 109: 237, 110: 238, 111: 239,
				112: 240, 113: 241, 114: 242, 115: 243, 116: 244, 117: 245, 118: 246, 119: 247, 120: 248, 121: 249, 122: 250, 228: 251, 246: 252, 252: 253, 223: 254, 127: 255,
				64: 64, 91: 91, 92: 92, 93: 93, 123: 123, 124: 124, 125: 125, 126: 126, 161: 33, 171: 60, 187: 62, 8216: 96, 8213: 45, 160: 32, 173: 45, 166: 124,
				180: 39, 8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 192: 65, 193: 65, 194: 65, 199: 67, 200: 69, 201: 69, 202: 69, 204: 73, 205: 73, 206: 73,
				210: 79, 211: 79, 212: 79, 217: 85, 218: 85, 219: 85, 224: 97, 225: 97, 226: 97, 231: 99, 232: 101, 233: 101, 234: 101, 236: 105, 237: 105, 238: 105,
				242: 111, 243: 111, 244: 111, 249: 117, 250: 117, 251: 117, 946: 126,
			},
		}
	case 0xd0: // 208
		return &StringConverter{
			LangID:    208,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 64, 225, 227, 229, 92, 241, 176, 46, 60, 40, 43, 33,
				38, 123, 234, 235, 125, 237, 238, 239, 236, 223, 167, 36, 42, 41, 59, 94,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 249, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 181, 58, 163, 224, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				91, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 8364,
				96, 168, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 35, 165, 183, 169, 93, 182, 188, 189, 190, 172, 124, 175, 126, 180, 215,
				233, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				232, 74, 75, 76, 77, 78, 79, 80, 81, 82, 65535, 251, 252, 166, 250, 255,
				231, 247, 83, 84, 85, 86, 87, 88, 89, 90, 65535, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65535, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 64: 68, 225: 69, 227: 70, 229: 71, 92: 72, 241: 73, 176: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 123: 81,
				234: 82, 235: 83, 125: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 167: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 249: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 181: 121, 58: 122, 163: 123, 224: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143, 91: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 8364: 159, 96: 160, 168: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175, 162: 176, 35: 177,
				165: 178, 183: 179, 169: 180, 93: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 126: 189, 180: 190, 215: 191, 233: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206, 245: 207, 232: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 65535: 250, 251: 219, 252: 220, 166: 221, 250: 222, 255: 223, 231: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241, 50: 242,
				51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255,
			},
		}
	case 0xd2: // 210
		return &StringConverter{
			LangID:    210,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 28, 29, 30, 31,
				65535, 65535, 65535, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 91, 46, 60, 40, 43, 33,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 93, 36, 42, 41, 59, 94,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 124, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 172, 166, 175, 168, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 255, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 28: 28, 29: 29, 30: 30, 31: 31, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 160: 65, 226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 91: 74, 46: 75, 60: 76, 40: 77,
				43: 78, 33: 79, 38: 80, 233: 81, 234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 93: 90, 36: 91, 42: 92, 41: 93,
				59: 94, 94: 95, 45: 96, 47: 97, 194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 124: 106, 44: 107, 37: 108, 95: 109,
				62: 110, 63: 111, 248: 112, 201: 113, 202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125,
				61: 126, 34: 127, 216: 128, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141,
				254: 142, 177: 143, 176: 144, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157,
				198: 158, 164: 159, 181: 160, 126: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173,
				222: 174, 174: 175, 162: 176, 163: 177, 165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 166: 187, 175: 188, 168: 189,
				180: 190, 215: 191, 123: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205,
				243: 206, 245: 207, 125: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221,
				250: 222, 255: 223, 92: 224, 247: 225, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237,
				211: 238, 213: 239, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253,
				218: 254, 8216: 121, 8248: 95, 8764: 161, 376: 232,
			},
		}
	case 0xd3: // 211
		return &StringConverter{
			LangID:    211,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 28, 29, 30, 31,
				65535, 65535, 65535, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 160, 902, 904, 905, 906, 908, 910, 911, 912, 91, 46, 60, 40, 43, 33,
				38, 913, 914, 915, 916, 917, 918, 919, 920, 921, 93, 36, 42, 41, 59, 94,
				45, 47, 922, 923, 924, 925, 926, 927, 928, 929, 124, 44, 37, 95, 62, 63,
				8216, 8217, 931, 932, 933, 934, 935, 936, 937, 96, 58, 35, 64, 39, 61, 34,
				900, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 938, 939, 940, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 941, 942, 943, 944, 945, 946,
				901, 126, 115, 116, 117, 118, 119, 120, 121, 122, 947, 948, 949, 950, 951, 952,
				65535, 163, 65535, 183, 169, 167, 65535, 65535, 189, 65535, 172, 166, 8213, 168, 953, 954,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 955, 956, 957, 958, 959,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 960, 961, 962, 963, 964, 965,
				92, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 178, 966, 967, 968, 969, 970,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 971, 972, 973, 974, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 255, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 28: 28, 29: 29, 30: 30, 31: 31, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 160: 65, 902: 66, 904: 67, 905: 68, 906: 69, 908: 70, 910: 71, 911: 72, 912: 73, 91: 74, 46: 75, 60: 76, 40: 77,
				43: 78, 33: 79, 38: 80, 913: 81, 914: 82, 915: 83, 916: 84, 917: 85, 918: 86, 919: 87, 920: 88, 921: 89, 93: 90, 36: 91, 42: 92, 41: 93,
				59: 94, 94: 95, 45: 96, 47: 97, 922: 98, 923: 99, 924: 100, 925: 101, 926: 102, 927: 103, 928: 104, 929: 105, 124: 106, 44: 107, 37: 108, 95: 109,
				62: 110, 63: 111, 8216: 112, 8217: 113, 931: 114, 932: 115, 933: 116, 934: 117, 935: 118, 936: 119, 937: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125,
				61: 126, 34: 127, 900: 128, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 938: 140, 939: 141,
				940: 142, 177: 143, 176: 144, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 941: 154, 942: 155, 943: 156, 944: 157,
				945: 158, 946: 159, 901: 160, 126: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 947: 170, 948: 171, 949: 172, 950: 173,
				951: 174, 952: 175, 163: 177, 183: 179, 169: 180, 167: 181, 189: 184, 172: 186, 166: 187, 8213: 188, 168: 189, 953: 190, 954: 191, 123: 192, 65: 193, 66: 194,
				67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 955: 203, 956: 204, 957: 205, 958: 206, 959: 207, 125: 208, 74: 209, 75: 210,
				76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 960: 218, 961: 219, 962: 220, 963: 221, 964: 222, 965: 223, 92: 224, 83: 226, 84: 227,
				85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 966: 235, 967: 236, 968: 237, 969: 238, 970: 239, 48: 240, 49: 241, 50: 242, 51: 243,
				52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 971: 251, 972: 252, 973: 253, 974: 254,
			},
		}
	case 0xdd: // 221
		return &StringConverter{
			LangID:    221,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 28, 29, 30, 31,
				65535, 65535, 65535, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 96, 46, 60, 40, 43, 124,
				38, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 33, 36, 42, 41, 59, 65535,
				45, 47, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 94, 44, 37, 95, 62, 63,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 58, 35, 64, 39, 61, 34,
				65535, 97, 98, 99, 100, 101, 102, 103, 104, 105, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 106, 107, 108, 109, 110, 111, 112, 113, 114, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 115, 116, 117, 118, 119, 120, 121, 122, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 91, 92, 93, 65535, 65535,
				65535, 65, 66, 67, 68, 69, 70, 71, 72, 73, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 74, 75, 76, 77, 78, 79, 80, 81, 82, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 65535, 65535, 65535, 65535, 65535, 65535,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65535, 123, 65535, 125, 65535, 172,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 254, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 28: 28, 29: 29, 30: 30, 31: 31, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 96: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 45: 96,
				47: 97, 94: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 97: 129, 98: 130, 99: 131,
				100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 115: 162,
				116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 91: 187, 92: 188, 93: 189, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198,
				71: 199, 72: 200, 73: 201, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 83: 226, 84: 227, 85: 228, 86: 229,
				87: 230, 88: 231, 89: 232, 90: 233, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 123: 251, 125: 253,
				172: 255, 161: 90, 171: 76, 187: 110, 8216: 74, 8213: 96, 180: 125, 8248: 106, 165: 232, 63741: 134, 8356: 211, 192: 193, 193: 193, 194: 193, 199: 195, 200: 197,
				201: 197, 202: 197, 204: 201, 205: 201, 206: 201, 210: 214, 211: 214, 212: 214, 217: 228, 218: 228, 219: 228, 224: 129, 225: 129, 226: 129, 231: 131, 232: 133,
				233: 133, 234: 133, 236: 137, 237: 137, 238: 137, 242: 150, 243: 150, 244: 150, 249: 164, 250: 164, 251: 164,
			},
		}
	case 0xde: // 222
		return &StringConverter{
			LangID:    222,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 28, 29, 30, 31,
				65535, 65535, 65535, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 96, 46, 60, 40, 43, 246,
				38, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 33, 36, 42, 41, 59, 65535,
				45, 47, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 94, 44, 37, 95, 62, 63,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 58, 35, 167, 39, 61, 34,
				65535, 97, 98, 99, 100, 101, 102, 103, 104, 105, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 106, 107, 108, 109, 110, 111, 112, 113, 114, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 115, 116, 117, 118, 119, 120, 121, 122, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 196, 214, 220, 65535, 65535,
				65535, 65, 66, 67, 68, 69, 70, 71, 72, 73, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 74, 75, 76, 77, 78, 79, 80, 81, 82, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 65535, 65535, 65535, 65535, 65535, 65535,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65535, 228, 65535, 252, 65535, 223,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 254, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 28: 28, 29: 29, 30: 30, 31: 31, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 96: 74, 46: 75, 60: 76, 40: 77, 43: 78, 246: 79, 38: 80, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 45: 96,
				47: 97, 94: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 58: 122, 35: 123, 167: 124, 39: 125, 61: 126, 34: 127, 97: 129, 98: 130, 99: 131,
				100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 115: 162,
				116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 196: 187, 214: 188, 220: 189, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198,
				71: 199, 72: 200, 73: 201, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 83: 226, 84: 227, 85: 228, 86: 229,
				87: 230, 88: 231, 89: 232, 90: 233, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 228: 251, 252: 253,
				223: 255, 64: 124, 91: 187, 92: 188, 93: 189, 123: 251, 124: 79, 125: 253, 161: 90, 171: 76, 187: 110, 8216: 74, 8213: 96, 180: 125, 8248: 106, 164: 91,
				165: 232, 63741: 134, 8356: 211, 172: 255, 192: 193, 193: 193, 194: 193, 199: 195, 200: 197, 201: 197, 202: 197, 204: 201, 205: 201, 206: 201, 210: 214, 211: 214,
				212: 214, 217: 228, 218: 228, 219: 228, 224: 129, 225: 129, 226: 129, 231: 131, 232: 133, 233: 133, 234: 133, 236: 137, 237: 137, 238: 137, 242: 150, 243: 150,
				244: 150, 249: 164, 250: 164, 251: 164,
			},
		}
	case 0xdf: // 223
		return &StringConverter{
			LangID:    223,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 28, 29, 30, 31,
				65535, 65535, 65535, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 96, 46, 60, 40, 43, 249,
				38, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 33, 36, 42, 41, 59, 65535,
				45, 47, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 94, 44, 37, 95, 62, 63,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 58, 35, 224, 39, 61, 34,
				65535, 97, 98, 99, 100, 101, 102, 103, 104, 105, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 106, 107, 108, 109, 110, 111, 112, 113, 114, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 115, 116, 117, 118, 119, 120, 121, 122, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 176, 231, 167, 65535, 65535,
				65535, 65, 66, 67, 68, 69, 70, 71, 72, 73, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 74, 75, 76, 77, 78, 79, 80, 81, 82, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 65535, 65535, 65535, 65535, 65535, 65535,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65535, 233, 65535, 232, 65535, 168,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 254, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 28: 28, 29: 29, 30: 30, 31: 31, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 96: 74, 46: 75, 60: 76, 40: 77, 43: 78, 249: 79, 38: 80, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 45: 96,
				47: 97, 94: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 58: 122, 35: 123, 224: 124, 39: 125, 61: 126, 34: 127, 97: 129, 98: 130, 99: 131,
				100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 115: 162,
				116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 176: 187, 231: 188, 167: 189, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198,
				71: 199, 72: 200, 73: 201, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 83: 226, 84: 227, 85: 228, 86: 229,
				87: 230, 88: 231, 89: 232, 90: 233, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 233: 251, 232: 253,
				168: 255, 64: 124, 91: 187, 92: 188, 93: 189, 123: 251, 124: 79, 125: 253, 161: 90, 171: 76, 187: 110, 8216: 74, 8213: 96, 180: 125, 8248: 106, 164: 91,
				165: 232, 63741: 134, 8356: 211, 172: 255, 192: 193, 193: 193, 194: 193, 199: 195, 200: 197, 201: 197, 202: 197, 204: 201, 205: 201, 206: 201, 210: 214, 211: 214,
				212: 214, 217: 228, 218: 228, 219: 228, 225: 129, 226: 129, 234: 133, 236: 137, 237: 137, 238: 137, 242: 150, 243: 150, 244: 150, 250: 164, 251: 164,
			},
		}
	case 0xe0: // 224
		return &StringConverter{
			LangID:    224,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 28, 29, 30, 31,
				65535, 65535, 65535, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 65535, 225, 233, 237, 243, 250, 252, 65535, 65535, 96, 46, 60, 40, 43, 241,
				38, 65535, 193, 201, 205, 211, 218, 220, 65535, 65535, 33, 36, 42, 41, 59, 65535,
				45, 47, 224, 232, 236, 242, 249, 65535, 65535, 65535, 94, 44, 37, 95, 62, 63,
				65535, 65535, 192, 200, 204, 210, 217, 65535, 65535, 65535, 58, 35, 64, 39, 61, 34,
				65535, 97, 98, 99, 100, 101, 102, 103, 104, 105, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 106, 107, 108, 109, 110, 111, 112, 113, 114, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 115, 116, 117, 118, 119, 120, 121, 122, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 161, 209, 191, 65535, 65535,
				65535, 65, 66, 67, 68, 69, 70, 71, 72, 73, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 74, 75, 76, 77, 78, 79, 80, 81, 82, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 65535, 65535, 65535, 65535, 65535, 65535,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65535, 180, 65535, 231, 65535, 168,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 254, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 28: 28, 29: 29, 30: 30, 31: 31, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 225: 66, 233: 67, 237: 68, 243: 69, 250: 70, 252: 71, 96: 74, 46: 75, 60: 76, 40: 77, 43: 78, 241: 79, 38: 80,
				193: 82, 201: 83, 205: 84, 211: 85, 218: 86, 220: 87, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 45: 96, 47: 97, 224: 98, 232: 99, 236: 100,
				242: 101, 249: 102, 94: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 192: 114, 200: 115, 204: 116, 210: 117, 217: 118, 58: 122, 35: 123, 64: 124,
				39: 125, 61: 126, 34: 127, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 106: 145, 107: 146, 108: 147, 109: 148,
				110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 187, 209: 188, 191: 189,
				65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215,
				81: 216, 82: 217, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245,
				54: 246, 55: 247, 56: 248, 57: 249, 180: 251, 231: 253, 168: 255, 91: 187, 92: 188, 93: 189, 123: 251, 124: 79, 125: 253, 171: 76, 187: 110, 8216: 74,
				8213: 96, 8248: 106, 164: 91, 165: 232, 63741: 134, 8356: 211, 172: 255, 194: 193, 199: 195, 202: 197, 206: 201, 212: 214, 219: 228, 226: 129, 234: 133, 238: 137,
				244: 150, 251: 164,
			},
		}
	case 0xe1: // 225
		return &StringConverter{
			LangID:    225,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 28, 29, 30, 31,
				65535, 65535, 65535, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 96, 46, 60, 40, 43, 248,
				38, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 33, 36, 42, 41, 59, 65535,
				45, 47, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 220, 44, 37, 95, 62, 63,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 58, 35, 167, 39, 61, 34,
				65535, 97, 98, 99, 100, 101, 102, 103, 104, 105, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 106, 107, 108, 109, 110, 111, 112, 113, 114, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 115, 116, 117, 118, 119, 120, 121, 122, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 198, 216, 197, 65535, 65535,
				65535, 65, 66, 67, 68, 69, 70, 71, 72, 73, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 74, 75, 76, 77, 78, 79, 80, 81, 82, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 65535, 65535, 65535, 65535, 65535, 65535,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65535, 230, 65535, 229, 65535, 252,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 254, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 28: 28, 29: 29, 30: 30, 31: 31, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 96: 74, 46: 75, 60: 76, 40: 77, 43: 78, 248: 79, 38: 80, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 45: 96,
				47: 97, 220: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 58: 122, 35: 123, 167: 124, 39: 125, 61: 126, 34: 127, 97: 129, 98: 130, 99: 131,
				100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 115: 162,
				116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 198: 187, 216: 188, 197: 189, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198,
				71: 199, 72: 200, 73: 201, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 83: 226, 84: 227, 85: 228, 86: 229,
				87: 230, 88: 231, 89: 232, 90: 233, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 230: 251, 229: 253,
				252: 255, 64: 124, 91: 187, 92: 188, 93: 189, 123: 251, 124: 79, 125: 253, 161: 90, 171: 76, 187: 110, 8216: 74, 8213: 96, 180: 125, 8248: 106, 164: 91,
				165: 232, 63741: 134, 8356: 211, 172: 255, 192: 193, 193: 193, 194: 193, 199: 195, 200: 197, 201: 197, 202: 197, 204: 201, 205: 201, 206: 201, 210: 214, 211: 214,
				212: 214, 217: 228, 218: 228, 219: 228, 224: 129, 225: 129, 226: 129, 231: 131, 232: 133, 233: 133, 234: 133, 236: 137, 237: 137, 238: 137, 242: 150, 243: 150,
				244: 150, 249: 164, 250: 164, 251: 164,
			},
		}
	case 0xe2: // 226
		return &StringConverter{
			LangID:    226,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 65535, 29, 30, 31,
				65535, 65535, 28, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 160, 226, 123, 224, 225, 227, 125, 231, 241, 35, 46, 60, 40, 43, 33,
				38, 96, 234, 235, 232, 237, 238, 239, 236, 223, 36, 197, 42, 41, 59, 220,
				45, 47, 194, 65535, 192, 193, 195, 65535, 199, 209, 246, 44, 37, 95, 62, 63,
				248, 92, 202, 203, 200, 205, 206, 207, 204, 233, 58, 196, 214, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 93,
				181, 252, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 91, 182, 188, 189, 190, 172, 124, 175, 168, 180, 215,
				228, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 166, 242, 243, 245,
				229, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 126, 249, 250, 255,
				201, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 64, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 65535, 217, 218, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 255, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 29: 29, 30: 30, 31: 31, 28: 34, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 160: 65, 226: 66, 123: 67, 224: 68, 225: 69, 227: 70, 125: 71, 231: 72, 241: 73, 35: 74, 46: 75, 60: 76, 40: 77,
				43: 78, 33: 79, 38: 80, 96: 81, 234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 36: 90, 197: 91, 42: 92, 41: 93,
				59: 94, 220: 95, 45: 96, 47: 97, 194: 98, 192: 100, 193: 101, 195: 102, 199: 104, 209: 105, 246: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111,
				248: 112, 92: 113, 202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 233: 121, 58: 122, 196: 123, 214: 124, 39: 125, 61: 126, 34: 127,
				216: 128, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142, 177: 143,
				176: 144, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 93: 159,
				181: 160, 252: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174, 174: 175,
				162: 176, 163: 177, 165: 178, 183: 179, 169: 180, 91: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 124: 187, 175: 188, 168: 189, 180: 190, 215: 191,
				228: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 166: 204, 242: 205, 243: 206, 245: 207,
				229: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 126: 220, 249: 221, 250: 222, 255: 223,
				201: 224, 247: 225, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 64: 236, 210: 237, 211: 238, 213: 239,
				48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 217: 253, 218: 254,
			},
		}
	case 0xe6: // 230
		return &StringConverter{
			LangID:    230,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 28, 29, 30, 31,
				65535, 65535, 65535, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 96, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 33, 36, 42, 41, 59, 65535,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 94, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 353, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 382, 198, 8364,
				181, 175, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 167, 182, 338, 339, 376, 172, 91, 92, 93, 381, 215,
				352, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				166, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 219, 250, 255,
				217, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 123, 220, 125, 218, 126,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 95, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 28: 28, 29: 29, 30: 30, 31: 31, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 160: 65, 226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 96: 74, 46: 75, 60: 76, 40: 77,
				43: 78, 124: 79, 38: 80, 233: 81, 234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93,
				59: 94, 45: 96, 47: 97, 194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 94: 106, 44: 107, 37: 108, 95: 109, 62: 110,
				63: 111, 248: 112, 201: 113, 202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 353: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126,
				34: 127, 216: 128, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142,
				177: 143, 176: 144, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 382: 157, 198: 158,
				8364: 159, 181: 160, 175: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174,
				174: 175, 162: 176, 163: 177, 165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 338: 183, 339: 184, 376: 185, 172: 186, 91: 187, 92: 188, 93: 189, 381: 190,
				215: 191, 352: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206,
				245: 207, 166: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 219: 221, 250: 222,
				255: 223, 217: 224, 247: 225, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238,
				213: 239, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 123: 251, 220: 252, 125: 253, 218: 254,
				126: 255, 8248: 106, 8764: 255,
			},
		}
	case 0xe7: // 231
		return &StringConverter{
			LangID:    231,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 28, 29, 30, 31,
				65535, 65535, 65535, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 96, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 33, 36, 42, 41, 59, 65535,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 94, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 168, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 240, 253, 254, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				181, 175, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 208, 221, 222, 174,
				162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 172, 91, 92, 93, 180, 215,
				249, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				166, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 219, 250, 255,
				217, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 123, 220, 125, 218, 126,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 95, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 28: 28, 29: 29, 30: 30, 31: 31, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 160: 65, 226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 96: 74, 46: 75, 60: 76, 40: 77,
				43: 78, 124: 79, 38: 80, 233: 81, 234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93,
				59: 94, 45: 96, 47: 97, 194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 94: 106, 44: 107, 37: 108, 95: 109, 62: 110,
				63: 111, 248: 112, 201: 113, 202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 168: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126,
				34: 127, 216: 128, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 240: 140, 253: 141, 254: 142,
				177: 143, 176: 144, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158,
				164: 159, 181: 160, 175: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 208: 172, 221: 173, 222: 174,
				174: 175, 162: 176, 163: 177, 165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 91: 187, 92: 188, 93: 189, 180: 190,
				215: 191, 249: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206,
				245: 207, 166: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 219: 221, 250: 222,
				255: 223, 217: 224, 247: 225, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238,
				213: 239, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 123: 251, 220: 252, 125: 253, 218: 254,
				126: 255, 8248: 106, 8764: 255,
			},
		}
	case 0xe8: // 232
		return &StringConverter{
			LangID:    232,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 28, 29, 30, 31,
				65535, 65535, 65535, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 160, 226, 228, 259, 261, 263, 269, 231, 215, 96, 46, 60, 40, 43, 124,
				38, 281, 280, 235, 203, 283, 238, 282, 206, 167, 33, 36, 42, 41, 59, 65535,
				45, 47, 194, 196, 258, 260, 262, 268, 199, 168, 94, 44, 37, 95, 62, 63,
				345, 225, 233, 237, 243, 246, 337, 250, 252, 369, 58, 35, 64, 39, 61, 34,
				344, 97, 98, 99, 100, 101, 102, 103, 104, 105, 323, 271, 273, 253, 355, 357,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 318, 317, 341, 184, 340, 164,
				711, 223, 115, 116, 117, 118, 119, 120, 121, 122, 321, 270, 208, 221, 354, 356,
				728, 193, 201, 205, 211, 214, 336, 218, 220, 368, 731, 91, 92, 93, 180, 382,
				367, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 324, 328, 347, 353,
				733, 74, 75, 76, 77, 78, 79, 80, 81, 82, 314, 351, 378, 350, 380, 381,
				366, 247, 83, 84, 85, 86, 87, 88, 89, 90, 729, 212, 323, 327, 346, 352,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 313, 123, 377, 125, 379, 126,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 95, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 28: 28, 29: 29, 30: 30, 31: 31, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 160: 65, 226: 66, 228: 67, 259: 68, 261: 69, 263: 70, 269: 71, 231: 72, 215: 73, 96: 74, 46: 75, 60: 76, 40: 77,
				43: 78, 124: 79, 38: 80, 281: 81, 280: 82, 235: 83, 203: 84, 283: 85, 238: 86, 282: 87, 206: 88, 167: 89, 33: 90, 36: 91, 42: 92, 41: 93,
				59: 94, 45: 96, 47: 97, 194: 98, 196: 99, 258: 100, 260: 101, 262: 102, 268: 103, 199: 104, 168: 105, 94: 106, 44: 107, 37: 108, 95: 109, 62: 110,
				63: 111, 345: 112, 225: 113, 233: 114, 237: 115, 243: 116, 246: 117, 337: 118, 250: 119, 252: 120, 369: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126,
				34: 127, 344: 128, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 323: 236, 271: 139, 273: 140, 253: 141, 355: 142,
				357: 143, 176: 144, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 318: 154, 317: 155, 341: 156, 184: 157, 340: 158,
				164: 159, 711: 160, 223: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 321: 170, 270: 171, 208: 172, 221: 173, 354: 174,
				356: 175, 728: 176, 193: 177, 201: 178, 205: 179, 211: 180, 214: 181, 336: 182, 218: 183, 220: 184, 368: 185, 731: 186, 91: 187, 92: 188, 93: 189, 180: 190,
				382: 191, 367: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 324: 204, 328: 205, 347: 206,
				353: 207, 733: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 314: 218, 351: 219, 378: 220, 350: 221, 380: 222,
				381: 223, 366: 224, 247: 225, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 729: 234, 212: 235, 327: 237, 346: 238, 352: 239,
				48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 313: 250, 123: 251, 377: 252, 125: 253, 379: 254, 126: 255,
				8248: 106, 8764: 255,
			},
		}
	case 0xe9: // 233
		return &StringConverter{
			LangID:    233,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 28, 29, 30, 31,
				65535, 65535, 65535, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 160, 226, 228, 341, 225, 259, 314, 231, 324, 96, 46, 60, 40, 43, 124,
				38, 233, 281, 235, 269, 237, 238, 271, 283, 223, 33, 36, 42, 41, 59, 65535,
				45, 47, 194, 196, 340, 193, 258, 313, 199, 323, 94, 44, 37, 95, 62, 63,
				345, 201, 280, 203, 268, 205, 206, 270, 282, 168, 58, 35, 64, 39, 61, 34,
				344, 97, 98, 99, 100, 101, 102, 103, 104, 105, 356, 357, 273, 253, 355, 261,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 350, 351, 263, 184, 262, 164,
				318, 379, 115, 116, 117, 118, 119, 120, 121, 122, 260, 380, 272, 221, 354, 381,
				728, 321, 317, 711, 352, 167, 347, 378, 733, 382, 377, 91, 92, 93, 180, 215,
				367, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 328, 243, 337,
				346, 74, 75, 76, 77, 78, 79, 80, 81, 82, 353, 369, 252, 368, 250, 729,
				366, 247, 83, 84, 85, 86, 87, 88, 89, 90, 731, 212, 214, 327, 211, 336,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 322, 123, 220, 125, 218, 126,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 95, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 28: 28, 29: 29, 30: 30, 31: 31, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 160: 65, 226: 66, 228: 67, 341: 68, 225: 69, 259: 70, 314: 71, 231: 72, 324: 73, 96: 74, 46: 75, 60: 76, 40: 77,
				43: 78, 124: 79, 38: 80, 233: 81, 281: 82, 235: 83, 269: 84, 237: 85, 238: 86, 271: 87, 283: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93,
				59: 94, 45: 96, 47: 97, 194: 98, 196: 99, 340: 100, 193: 101, 258: 102, 313: 103, 199: 104, 323: 105, 94: 106, 44: 107, 37: 108, 95: 109, 62: 110,
				63: 111, 345: 112, 201: 113, 280: 114, 203: 115, 268: 116, 205: 117, 206: 118, 270: 119, 282: 120, 168: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126,
				34: 127, 344: 128, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 356: 138, 357: 139, 273: 140, 253: 141, 355: 142,
				261: 143, 176: 144, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 350: 154, 351: 155, 263: 156, 184: 157, 262: 158,
				164: 159, 318: 160, 379: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 260: 170, 380: 171, 272: 172, 221: 173, 354: 174,
				381: 175, 728: 176, 321: 177, 317: 178, 711: 179, 352: 180, 167: 181, 347: 182, 378: 183, 733: 184, 382: 185, 377: 186, 91: 187, 92: 188, 93: 189, 180: 190,
				215: 191, 367: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 328: 205, 243: 206,
				337: 207, 346: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 353: 218, 369: 219, 252: 220, 368: 221, 250: 222,
				729: 223, 366: 224, 247: 225, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 731: 234, 212: 235, 214: 236, 327: 237, 211: 238,
				336: 239, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 322: 250, 123: 251, 220: 252, 125: 253, 218: 254,
				126: 255, 8248: 106, 8764: 255,
			},
		}
	case 0xeb: // 235
		return &StringConverter{
			LangID:    235,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 28, 29, 30, 31,
				65535, 65535, 65535, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 160, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 96, 46, 60, 40, 43, 124,
				38, 8470, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 33, 36, 42, 41, 59, 65535,
				45, 47, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 94, 44, 37, 95, 62, 63,
				1106, 1105, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 58, 35, 64, 39, 61, 34,
				1107, 97, 98, 99, 100, 101, 102, 103, 104, 105, 1040, 1041, 1042, 1043, 1044, 1045,
				1108, 106, 107, 108, 109, 110, 111, 112, 113, 114, 1046, 1047, 1048, 1049, 1050, 1051,
				1109, 126, 115, 116, 117, 118, 119, 120, 121, 122, 1052, 1053, 1054, 1055, 1056, 1057,
				1026, 1025, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071,
				1027, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 1110, 1111, 1112, 1113, 1114,
				1028, 74, 75, 76, 77, 78, 79, 80, 81, 82, 1115, 1116, 1118, 1119, 1030, 1031,
				1029, 167, 83, 84, 85, 86, 87, 88, 89, 90, 1032, 1033, 1034, 1035, 1036, 1038,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 1039, 91, 123, 93, 125, 92,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 95, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 28: 28, 29: 29, 30: 30, 31: 31, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 160: 65, 1072: 66, 1073: 67, 1074: 68, 1075: 69, 1076: 70, 1077: 71, 1078: 72, 1079: 73, 96: 74, 46: 75, 60: 76, 40: 77,
				43: 78, 124: 79, 38: 80, 8470: 81, 1080: 82, 1081: 83, 1082: 84, 1083: 85, 1084: 86, 1085: 87, 1086: 88, 1087: 89, 33: 90, 36: 91, 42: 92, 41: 93,
				59: 94, 45: 96, 47: 97, 1088: 98, 1089: 99, 1090: 100, 1091: 101, 1092: 102, 1093: 103, 1094: 104, 1095: 105, 94: 106, 44: 107, 37: 108, 95: 109, 62: 110,
				63: 111, 1106: 112, 1105: 113, 1096: 114, 1097: 115, 1098: 116, 1099: 117, 1100: 118, 1101: 119, 1102: 120, 1103: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126,
				34: 127, 1107: 128, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 1040: 138, 1041: 139, 1042: 140, 1043: 141, 1044: 142,
				1045: 143, 1108: 144, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 1046: 154, 1047: 155, 1048: 156, 1049: 157, 1050: 158,
				1051: 159, 1109: 160, 126: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 1052: 170, 1053: 171, 1054: 172, 1055: 173, 1056: 174,
				1057: 175, 1026: 176, 1025: 177, 1058: 178, 1059: 179, 1060: 180, 1061: 181, 1062: 182, 1063: 183, 1064: 184, 1065: 185, 1066: 186, 1067: 187, 1068: 188, 1069: 189, 1070: 190,
				1071: 191, 1027: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 1110: 203, 1111: 204, 1112: 205, 1113: 206,
				1114: 207, 1028: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 1115: 218, 1116: 219, 1118: 220, 1119: 221, 1030: 222,
				1031: 223, 1029: 224, 167: 225, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 1032: 234, 1033: 235, 1034: 236, 1035: 237, 1036: 238,
				1038: 239, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 1039: 250, 91: 251, 123: 252, 93: 253, 125: 254,
				92: 255,
			},
		}
	case 0xef: // 239
		return &StringConverter{
			LangID:    239,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 28, 29, 30, 31,
				65535, 65535, 65535, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 231, 241, 96, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 33, 36, 42, 41, 59, 65535,
				45, 47, 194, 196, 192, 193, 195, 197, 199, 209, 94, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 168, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 287, 305, 351, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				181, 175, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 286, 304, 350, 174,
				162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 172, 91, 92, 93, 180, 215,
				249, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 242, 243, 245,
				166, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 219, 250, 255,
				217, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 123, 220, 125, 218, 126,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 95, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 28: 28, 29: 29, 30: 30, 31: 31, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 160: 65, 226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 231: 72, 241: 73, 96: 74, 46: 75, 60: 76, 40: 77,
				43: 78, 124: 79, 38: 80, 233: 81, 234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93,
				59: 94, 45: 96, 47: 97, 194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 199: 104, 209: 105, 94: 106, 44: 107, 37: 108, 95: 109, 62: 110,
				63: 111, 248: 112, 201: 113, 202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 168: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126,
				34: 127, 216: 128, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 287: 140, 305: 141, 351: 142,
				177: 143, 176: 144, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158,
				164: 159, 181: 160, 175: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 286: 172, 304: 173, 350: 174,
				174: 175, 162: 176, 163: 177, 165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 91: 187, 92: 188, 93: 189, 180: 190,
				215: 191, 249: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 242: 205, 243: 206,
				245: 207, 166: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 219: 221, 250: 222,
				255: 223, 217: 224, 247: 225, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238,
				213: 239, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 123: 251, 220: 252, 125: 253, 218: 254,
				126: 255, 8248: 106, 8764: 255, 63738: 201, 63736: 137,
			},
		}
	case 0xf1: // 241
		return &StringConverter{
			LangID:    241,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 167, 65535, 65535, 65535, 8593,
				193, 192, 194, 196, 195, 197, 198, 199, 201, 200, 202, 203, 205, 204, 206, 207,
				209, 211, 210, 212, 214, 213, 216, 338, 218, 217, 219, 220, 65535, 65535, 65535, 65535,
				225, 224, 226, 228, 227, 229, 230, 231, 233, 232, 234, 235, 237, 236, 238, 239,
				241, 243, 242, 244, 246, 245, 248, 339, 250, 249, 251, 252, 223, 65535, 65535, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 167: 187, 8593: 191, 193: 192, 192: 193, 194: 194, 196: 195, 195: 196, 197: 197, 198: 198, 199: 199, 201: 200, 200: 201, 202: 202, 203: 203, 205: 204,
				204: 205, 206: 206, 207: 207, 209: 208, 211: 209, 210: 210, 212: 211, 214: 212, 213: 213, 216: 214, 338: 215, 218: 216, 217: 217, 219: 218, 220: 219, 225: 224,
				224: 225, 226: 226, 228: 227, 227: 228, 229: 229, 230: 230, 231: 231, 233: 232, 232: 233, 234: 234, 235: 235, 237: 236, 236: 237, 238: 238, 239: 239, 241: 240,
				243: 241, 242: 242, 244: 243, 246: 244, 245: 245, 248: 246, 339: 247, 250: 248, 249: 249, 251: 250, 252: 251, 223: 252, 161: 33, 171: 60, 187: 62, 8216: 96,
				8213: 45, 160: 32, 173: 45, 166: 124, 180: 39, 8248: 94, 8764: 126, 165: 89, 63741: 102, 8356: 76, 221: 89, 253: 121,
			},
		}
	case 0xfb: // 251
		return &StringConverter{
			LangID:    251,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  191,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 161, 162, 163, 65535, 165, 65535, 167, 164, 169, 170, 171, 65535, 65535, 65535, 65535,
				176, 177, 178, 179, 65535, 181, 182, 183, 65535, 185, 186, 187, 188, 189, 65535, 191,
				192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
				65535, 209, 210, 211, 212, 213, 214, 338, 216, 217, 218, 219, 220, 376, 65535, 223,
				224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
				65535, 241, 242, 243, 244, 245, 246, 339, 248, 249, 250, 251, 252, 255, 65535, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 161: 161, 162: 162, 163: 163, 165: 165, 167: 167, 164: 168, 169: 169, 170: 170, 171: 171, 176: 176, 177: 177, 178: 178, 179: 179, 181: 181, 182: 182,
				183: 183, 185: 185, 186: 186, 187: 187, 188: 188, 189: 189, 191: 191, 192: 192, 193: 193, 194: 194, 195: 195, 196: 196, 197: 197, 198: 198, 199: 199, 200: 200,
				201: 201, 202: 202, 203: 203, 204: 204, 205: 205, 206: 206, 207: 207, 209: 209, 210: 210, 211: 211, 212: 212, 213: 213, 214: 214, 338: 215, 216: 216, 217: 217,
				218: 218, 219: 219, 220: 220, 376: 221, 223: 223, 224: 224, 225: 225, 226: 226, 227: 227, 228: 228, 229: 229, 230: 230, 231: 231, 232: 232, 233: 233, 234: 234,
				235: 235, 236: 236, 237: 237, 238: 238, 239: 239, 241: 241, 242: 242, 243: 243, 244: 244, 245: 245, 246: 246, 339: 247, 248: 248, 249: 249, 250: 250, 251: 251,
				252: 252, 255: 253, 8216: 96, 8213: 45, 175: 45, 160: 32, 173: 45, 166: 124, 180: 39, 8248: 94, 8764: 126, 63741: 102, 8356: 76, 221: 89, 253: 121, 946: 223,
			},
		}
	case 0x105: // 261
		return &StringConverter{
			LangID:    261,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  252,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 192, 194, 200, 202, 203, 206, 207, 180, 8216, 8248, 168, 8764, 217, 219, 8356,
				175, 221, 253, 176, 199, 231, 209, 241, 161, 191, 164, 163, 165, 167, 402, 162,
				226, 234, 244, 251, 225, 233, 243, 250, 224, 232, 242, 249, 228, 235, 246, 252,
				197, 238, 216, 198, 229, 237, 248, 230, 196, 236, 214, 220, 201, 239, 223, 212,
				193, 195, 227, 208, 240, 205, 204, 211, 210, 213, 245, 352, 353, 218, 376, 255,
				222, 254, 183, 181, 182, 65535, 8213, 188, 189, 170, 186, 171, 8718, 187, 177, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 192: 161, 194: 162, 200: 163, 202: 164, 203: 165, 206: 166, 207: 167, 180: 168, 8216: 169, 8248: 170, 168: 171, 8764: 172, 217: 173, 219: 174, 8356: 175,
				175: 176, 221: 177, 253: 178, 176: 179, 199: 180, 231: 181, 209: 182, 241: 183, 161: 184, 191: 185, 164: 186, 163: 187, 165: 188, 167: 189, 402: 190, 162: 191,
				226: 192, 234: 193, 244: 194, 251: 195, 225: 196, 233: 197, 243: 198, 250: 199, 224: 200, 232: 201, 242: 202, 249: 203, 228: 204, 235: 205, 246: 206, 252: 207,
				197: 208, 238: 209, 216: 210, 198: 211, 229: 212, 237: 213, 248: 214, 230: 215, 196: 216, 236: 217, 214: 218, 220: 219, 201: 220, 239: 221, 223: 222, 212: 223,
				193: 224, 195: 225, 227: 226, 208: 227, 240: 228, 205: 229, 204: 230, 211: 231, 210: 232, 213: 233, 245: 234, 352: 235, 353: 236, 218: 237, 376: 238, 255: 239,
				222: 240, 254: 241, 183: 242, 181: 243, 182: 244, 8213: 246, 188: 247, 189: 248, 170: 249, 186: 250, 171: 251, 8718: 252, 187: 253, 177: 254, 160: 32, 173: 45,
				166: 124, 272: 227, 273: 228, 63741: 190,
			},
		}
	case 0x106: // 262
		return &StringConverter{
			LangID:    262,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 12, 10, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 256, 257, 201, 260, 214, 220, 225, 261, 268, 228, 269, 262, 263, 233, 377,
				378, 270, 237, 271, 274, 275, 278, 243, 279, 244, 246, 245, 250, 282, 283, 252,
				65535, 176, 280, 163, 167, 183, 182, 223, 174, 169, 8482, 281, 168, 8800, 65535, 302,
				303, 298, 8804, 8805, 299, 310, 948, 931, 322, 315, 316, 317, 318, 313, 314, 325,
				326, 323, 172, 65535, 324, 327, 916, 171, 187, 65535, 160, 328, 336, 213, 337, 332,
				65535, 8213, 8220, 8221, 8216, 8217, 247, 65535, 333, 340, 341, 344, 65535, 65535, 345, 342,
				343, 352, 65535, 65535, 353, 346, 347, 193, 356, 357, 205, 381, 382, 362, 211, 212,
				363, 366, 218, 367, 368, 369, 370, 371, 221, 253, 311, 379, 321, 380, 65535, 711,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 13: 10, 11: 11, 12: 12, 10: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 256: 129, 257: 130, 201: 131, 260: 132, 214: 133, 220: 134, 225: 135, 261: 136, 268: 137, 228: 138, 269: 139, 262: 140, 263: 141, 233: 142, 377: 143,
				378: 144, 270: 145, 237: 146, 271: 147, 274: 148, 275: 149, 278: 150, 243: 151, 279: 152, 244: 153, 246: 154, 245: 155, 250: 156, 282: 157, 283: 158, 252: 159,
				65535: 254, 176: 161, 280: 162, 163: 163, 167: 164, 183: 165, 182: 166, 223: 167, 174: 168, 169: 169, 8482: 170, 281: 171, 168: 172, 8800: 173, 302: 175, 303: 176,
				298: 177, 8804: 178, 8805: 179, 299: 180, 310: 181, 948: 182, 931: 183, 322: 184, 315: 185, 316: 186, 317: 187, 318: 188, 313: 189, 314: 190, 325: 191, 326: 192,
				323: 193, 172: 194, 324: 196, 327: 197, 916: 198, 171: 199, 187: 200, 160: 202, 328: 203, 336: 204, 213: 205, 337: 206, 332: 207, 8213: 209, 8220: 210, 8221: 211,
				8216: 212, 8217: 213, 247: 214, 333: 216, 340: 217, 341: 218, 344: 219, 345: 222, 342: 223, 343: 224, 352: 225, 353: 228, 346: 229, 347: 230, 193: 231, 356: 232,
				357: 233, 205: 234, 381: 235, 382: 236, 362: 237, 211: 238, 212: 239, 363: 240, 366: 241, 218: 242, 367: 243, 368: 244, 369: 245, 370: 246, 371: 247, 221: 248,
				253: 249, 311: 250, 379: 251, 321: 252, 380: 253, 711: 255,
			},
		}
	case 0x107: // 263
		return &StringConverter{
			LangID:    263,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 12, 10, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232,
				234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252,
				65535, 176, 162, 163, 167, 183, 182, 223, 174, 350, 8482, 180, 168, 8800, 381, 216,
				65535, 177, 8804, 8805, 165, 181, 948, 931, 928, 351, 65535, 170, 186, 8486, 382, 248,
				191, 161, 172, 65535, 402, 8764, 262, 171, 268, 65535, 160, 192, 195, 213, 338, 339,
				272, 8213, 8220, 8221, 8216, 8217, 247, 65535, 65535, 169, 65535, 65535, 65535, 65535, 198, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 263, 65535, 269, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				273, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 960, 65535, 65535, 65535, 65535, 230, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 13: 10, 11: 11, 12: 12, 10: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 197: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 227: 139, 229: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 237: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 242: 152, 244: 153, 246: 154, 245: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				65535: 255, 176: 161, 162: 162, 163: 163, 167: 164, 183: 165, 182: 166, 223: 167, 174: 168, 350: 169, 8482: 170, 180: 171, 168: 172, 8800: 173, 381: 174, 216: 175,
				177: 177, 8804: 178, 8805: 179, 165: 180, 181: 181, 948: 182, 931: 183, 928: 184, 351: 185, 170: 187, 186: 188, 8486: 189, 382: 190, 248: 191, 191: 192, 161: 193,
				172: 194, 402: 196, 8764: 197, 262: 198, 171: 199, 268: 200, 160: 202, 192: 203, 195: 204, 213: 205, 338: 206, 339: 207, 272: 208, 8213: 209, 8220: 210, 8221: 211,
				8216: 212, 8217: 213, 247: 214, 169: 217, 198: 222, 187: 223, 263: 230, 269: 232, 273: 240, 960: 249, 230: 254, 63741: 196,
			},
		}
	case 0x108: // 264
		return &StringConverter{
			LangID:    264,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 12, 10, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232,
				234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252,
				8224, 176, 162, 163, 167, 8226, 182, 223, 174, 169, 8482, 180, 168, 8800, 198, 216,
				8734, 177, 8804, 8805, 165, 181, 948, 931, 928, 960, 8747, 170, 186, 8486, 230, 248,
				191, 161, 172, 8730, 402, 8776, 8710, 171, 187, 8230, 160, 192, 195, 213, 338, 339,
				8211, 8213, 8220, 8221, 8216, 8217, 247, 9674, 255, 376, 286, 287, 304, 305, 350, 351,
				8225, 183, 8218, 8222, 8240, 194, 202, 193, 203, 200, 205, 206, 207, 204, 211, 212,
				65535, 210, 218, 219, 217, 65535, 710, 732, 713, 728, 729, 730, 184, 733, 731, 711,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 13: 10, 11: 11, 12: 12, 10: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 197: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 227: 139, 229: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 237: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 242: 152, 244: 153, 246: 154, 245: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				8224: 160, 176: 161, 162: 162, 163: 163, 167: 164, 8226: 165, 182: 166, 223: 167, 174: 168, 169: 169, 8482: 170, 180: 171, 168: 172, 8800: 173, 198: 174, 216: 175,
				8734: 176, 177: 177, 8804: 178, 8805: 179, 165: 180, 181: 181, 948: 182, 931: 183, 928: 184, 960: 185, 8747: 186, 170: 187, 186: 188, 8486: 189, 230: 190, 248: 191,
				191: 192, 161: 193, 172: 194, 8730: 195, 402: 196, 8776: 197, 8710: 198, 171: 199, 187: 200, 8230: 201, 160: 202, 192: 203, 195: 204, 213: 205, 338: 206, 339: 207,
				8211: 208, 8213: 209, 8220: 210, 8221: 211, 8216: 212, 8217: 213, 247: 214, 9674: 215, 255: 216, 376: 217, 286: 218, 287: 219, 304: 220, 305: 221, 350: 222, 351: 223,
				8225: 224, 183: 225, 8218: 226, 8222: 227, 8240: 228, 194: 229, 202: 230, 193: 231, 203: 232, 200: 233, 205: 234, 206: 235, 207: 236, 204: 237, 211: 238, 212: 239,
				65535: 245, 210: 241, 218: 242, 219: 243, 217: 244, 710: 246, 732: 247, 713: 248, 728: 249, 729: 250, 730: 251, 184: 252, 733: 253, 731: 254, 711: 255, 175: 248,
				173: 225, 166: 124, 8764: 197, 215: 42, 63738: 73, 63736: 105, 916: 198, 63740: 240, 63741: 196,
			},
		}
	case 0x109: // 265
		return &StringConverter{
			LangID:    265,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  192,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 12, 10, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 8764, 127,
				196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232,
				234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252,
				221, 176, 162, 163, 167, 65535, 182, 223, 174, 169, 8482, 180, 168, 8800, 198, 216,
				65535, 177, 8804, 8805, 165, 181, 948, 931, 928, 960, 65535, 170, 186, 8486, 230, 248,
				191, 161, 172, 65535, 402, 65535, 916, 171, 187, 65535, 160, 192, 195, 213, 338, 339,
				65535, 8213, 8220, 8221, 8216, 8217, 247, 65535, 255, 376, 65535, 164, 208, 240, 222, 254,
				253, 183, 65535, 65535, 65535, 194, 202, 193, 203, 200, 205, 206, 207, 204, 211, 212,
				65535, 210, 218, 219, 217, 305, 8248, 126, 713, 728, 729, 730, 184, 733, 731, 711,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 13: 10, 11: 11, 12: 12, 10: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 8764: 126, 127: 127,
				196: 128, 197: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 227: 139, 229: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 237: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 242: 152, 244: 153, 246: 154, 245: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				221: 160, 176: 161, 162: 162, 163: 163, 167: 164, 65535: 240, 182: 166, 223: 167, 174: 168, 169: 169, 8482: 170, 180: 171, 168: 172, 8800: 173, 198: 174, 216: 175,
				177: 177, 8804: 178, 8805: 179, 165: 180, 181: 181, 948: 182, 931: 183, 928: 184, 960: 185, 170: 187, 186: 188, 8486: 189, 230: 190, 248: 191, 191: 192, 161: 193,
				172: 194, 402: 196, 916: 198, 171: 199, 187: 200, 160: 202, 192: 203, 195: 204, 213: 205, 338: 206, 339: 207, 8213: 209, 8220: 210, 8221: 211, 8216: 212, 8217: 213,
				247: 214, 255: 216, 376: 217, 164: 219, 208: 220, 240: 221, 222: 222, 254: 223, 253: 224, 183: 225, 194: 229, 202: 230, 193: 231, 203: 232, 200: 233, 205: 234,
				206: 235, 207: 236, 204: 237, 211: 238, 212: 239, 210: 241, 218: 242, 219: 243, 217: 244, 305: 245, 8248: 246, 126: 247, 713: 248, 728: 249, 729: 250, 730: 251,
				184: 252, 733: 253, 731: 254, 711: 255, 63741: 196,
			},
		}
	case 0x10a: // 266
		return &StringConverter{
			LangID:    266,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 12, 10, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232,
				234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252,
				65535, 8216, 8217, 163, 174, 247, 166, 167, 168, 169, 8482, 171, 172, 65535, 65535, 8213,
				176, 177, 178, 179, 900, 901, 902, 183, 904, 905, 906, 187, 908, 189, 910, 911,
				970, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927,
				928, 929, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943, 971,
				912, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959,
				960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 65535, 65535, 972, 973, 974, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 13: 10, 11: 11, 12: 12, 10: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 197: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 227: 139, 229: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 237: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 242: 152, 244: 153, 246: 154, 245: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				65535: 255, 8216: 161, 8217: 162, 163: 163, 174: 164, 247: 165, 166: 166, 167: 167, 168: 168, 169: 169, 8482: 170, 171: 171, 172: 172, 8213: 175, 176: 176, 177: 177,
				178: 178, 179: 179, 900: 180, 901: 181, 902: 182, 183: 183, 904: 184, 905: 185, 906: 186, 187: 187, 908: 188, 189: 189, 910: 190, 911: 191, 970: 192, 913: 193,
				914: 194, 915: 195, 916: 196, 917: 197, 918: 198, 919: 199, 920: 200, 921: 201, 922: 202, 923: 203, 924: 204, 925: 205, 926: 206, 927: 207, 928: 208, 929: 209,
				931: 210, 932: 211, 933: 212, 934: 213, 935: 214, 936: 215, 937: 216, 938: 217, 939: 218, 940: 219, 941: 220, 942: 221, 943: 222, 971: 223, 912: 224, 945: 225,
				946: 226, 947: 227, 948: 228, 949: 229, 950: 230, 951: 231, 952: 232, 953: 233, 954: 234, 955: 235, 956: 236, 957: 237, 958: 238, 959: 239, 960: 240, 961: 241,
				962: 242, 963: 243, 964: 244, 965: 245, 966: 246, 967: 247, 968: 248, 969: 249, 972: 252, 973: 253, 974: 254,
			},
		}
	case 0x10b: // 267
		return &StringConverter{
			LangID:    267,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 12, 10, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 64287, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232,
				234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252,
				63713, 63712, 63711, 63710, 63709, 63708, 8362, 63707, 63706, 63705, 63704, 63703, 63702, 63701, 63700, 63699,
				63698, 63697, 63696, 63695, 63694, 63693, 63692, 63691, 63690, 63689, 63688, 63687, 63684, 63685, 63686, 63674,
				64316, 8222, 65535, 65535, 65535, 65535, 1468, 64331, 64309, 8230, 160, 1464, 1463, 1461, 1462, 1460,
				8211, 8213, 8220, 8221, 8216, 8217, 64298, 64299, 63682, 63730, 1458, 1457, 1467, 1465, 1464, 1459,
				1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502, 1503,
				1504, 1505, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 63678, 63683, 63676, 63676, 63677,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 13: 10, 11: 11, 12: 12, 10: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 64287: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 227: 139, 229: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 237: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 242: 152, 244: 153, 246: 154, 245: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				63713: 160, 63712: 161, 63711: 162, 63710: 163, 63709: 164, 63708: 165, 8362: 166, 63707: 167, 63706: 168, 63705: 169, 63704: 170, 63703: 171, 63702: 172, 63701: 173, 63700: 174, 63699: 175,
				63698: 176, 63697: 177, 63696: 178, 63695: 179, 63694: 180, 63693: 181, 63692: 182, 63691: 183, 63690: 184, 63689: 185, 63688: 186, 63687: 187, 63684: 188, 63685: 189, 63686: 190, 63674: 191,
				64316: 192, 8222: 193, 65535: 197, 1468: 198, 64331: 199, 64309: 200, 8230: 201, 160: 202, 1464: 222, 1463: 204, 1461: 205, 1462: 206, 1460: 207, 8211: 208, 8213: 209, 8220: 210,
				8221: 211, 8216: 212, 8217: 213, 64298: 214, 64299: 215, 63682: 216, 63730: 217, 1458: 218, 1457: 219, 1467: 220, 1465: 221, 1459: 223, 1488: 224, 1489: 225, 1490: 226, 1491: 227,
				1492: 228, 1493: 229, 1494: 230, 1495: 231, 1496: 232, 1497: 233, 1498: 234, 1499: 235, 1500: 236, 1501: 237, 1502: 238, 1503: 239, 1504: 240, 1505: 241, 1506: 242, 1507: 243,
				1508: 244, 1509: 245, 1510: 246, 1511: 247, 1512: 248, 1513: 249, 1514: 250, 63678: 251, 63683: 252, 63676: 254, 63677: 255,
			},
		}
	case 0x115: // 277
		return &StringConverter{
			LangID:    277,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 65535, 29, 30, 31,
				65535, 65535, 28, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 91, 46, 60, 40, 43, 33,
				38, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 93, 36, 42, 41, 59, 94,
				45, 47, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 124, 44, 37, 95, 62, 63,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 96, 58, 163, 64, 39, 61, 34,
				65535, 97, 98, 99, 100, 101, 102, 103, 104, 105, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 106, 107, 108, 109, 110, 111, 112, 113, 114, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 126, 115, 116, 117, 118, 119, 120, 121, 122, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 65535, 65535, 65535, 65535, 65535, 65535,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 65535, 65535, 65535, 65535, 65535, 65535,
				92, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 65535, 65535, 65535, 65535, 65535, 65535,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65535, 65535, 65535, 65535, 65535, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 255, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 29: 29, 30: 30, 31: 31, 28: 34, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 91: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 93: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95,
				45: 96, 47: 97, 124: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 96: 121, 58: 122, 163: 123, 64: 124, 39: 125, 61: 126, 34: 127, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152,
				114: 153, 126: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 123: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197,
				70: 198, 71: 199, 72: 200, 73: 201, 125: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 92: 224, 83: 226,
				84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248,
				57: 249,
			},
		}
	case 0x116: // 278
		return &StringConverter{
			LangID:    278,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  117,
			dBuffer: []int{
				0, 1, 2, 3, 65535, 9, 65535, 127, 65535, 65535, 65535, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 65535, 10, 8, 65535, 24, 25, 65535, 65535, 65535, 29, 30, 31,
				65535, 65535, 28, 65535, 65535, 10, 23, 27, 65535, 65535, 65535, 65535, 65535, 5, 6, 7,
				65535, 65535, 22, 65535, 65535, 65535, 65535, 4, 65535, 65535, 65535, 65535, 20, 21, 65535, 26,
				32, 160, 161, 162, 35, 164, 165, 166, 167, 168, 91, 46, 60, 40, 43, 33,
				38, 169, 170, 171, 172, 173, 174, 126, 176, 177, 93, 36, 42, 41, 59, 94,
				45, 47, 178, 179, 180, 181, 182, 183, 184, 185, 124, 44, 37, 95, 62, 63,
				186, 187, 188, 189, 190, 191, 192, 193, 194, 96, 58, 163, 64, 39, 61, 34,
				195, 97, 98, 99, 100, 101, 102, 103, 104, 105, 196, 197, 198, 199, 200, 201,
				202, 106, 107, 108, 109, 110, 111, 112, 113, 114, 203, 204, 205, 206, 207, 208,
				209, 175, 115, 116, 117, 118, 119, 120, 121, 122, 210, 211, 212, 213, 214, 215,
				216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 232, 233, 234, 235, 236, 237,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 238, 239, 240, 241, 242, 243,
				92, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 244, 245, 246, 247, 248, 249,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 250, 251, 252, 253, 254, 255,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 65535: 225, 9: 5, 127: 7, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15, 16: 16, 17: 17, 18: 18, 19: 19,
				10: 37, 8: 22, 24: 24, 25: 25, 29: 29, 30: 30, 31: 31, 28: 34, 23: 38, 27: 39, 5: 45, 6: 46, 7: 47, 22: 50, 4: 55, 20: 60,
				21: 61, 26: 63, 32: 64, 160: 65, 161: 66, 162: 67, 35: 68, 164: 69, 165: 70, 166: 71, 167: 72, 168: 73, 91: 74, 46: 75, 60: 76, 40: 77,
				43: 78, 33: 79, 38: 80, 169: 81, 170: 82, 171: 83, 172: 84, 173: 85, 174: 86, 126: 87, 176: 88, 177: 89, 93: 90, 36: 91, 42: 92, 41: 93,
				59: 94, 94: 95, 45: 96, 47: 97, 178: 98, 179: 99, 180: 100, 181: 101, 182: 102, 183: 103, 184: 104, 185: 105, 124: 106, 44: 107, 37: 108, 95: 109,
				62: 110, 63: 111, 186: 112, 187: 113, 188: 114, 189: 115, 190: 116, 191: 117, 192: 118, 193: 119, 194: 120, 96: 121, 58: 122, 163: 123, 64: 124, 39: 125,
				61: 126, 34: 127, 195: 128, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 196: 138, 197: 139, 198: 140, 199: 141,
				200: 142, 201: 143, 202: 144, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 203: 154, 204: 155, 205: 156, 206: 157,
				207: 158, 208: 159, 209: 160, 175: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 210: 170, 211: 171, 212: 172, 213: 173,
				214: 174, 215: 175, 216: 176, 217: 177, 218: 178, 219: 179, 220: 180, 221: 181, 222: 182, 223: 183, 224: 184, 225: 185, 226: 186, 227: 187, 228: 188, 229: 189,
				230: 190, 231: 191, 123: 192, 65: 193, 66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 232: 202, 233: 203, 234: 204, 235: 205,
				236: 206, 237: 207, 125: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 238: 218, 239: 219, 240: 220, 241: 221,
				242: 222, 243: 223, 92: 224, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 244: 234, 245: 235, 246: 236, 247: 237, 248: 238,
				249: 239, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 250: 250, 251: 251, 252: 252, 253: 253, 254: 254,
				255: 255,
			},
		}
	case 0x117: // 279
		return &StringConverter{
			LangID:    279,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  191,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 92, 163, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 36, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				160, 161, 162, 65535, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
				176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
				192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
				208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
				224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
				240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 92: 35, 163: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 36: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 163, 160: 160, 161: 161, 162: 162, 164: 164, 165: 165, 166: 166, 167: 167, 168: 168, 169: 169, 170: 170, 171: 171, 172: 172, 173: 173, 174: 174, 175: 175,
				176: 176, 177: 177, 178: 178, 179: 179, 180: 180, 181: 181, 182: 182, 183: 183, 184: 184, 185: 185, 186: 186, 187: 187, 188: 188, 189: 189, 190: 190, 191: 191,
				192: 192, 193: 193, 194: 194, 195: 195, 196: 196, 197: 197, 198: 198, 199: 199, 200: 200, 201: 201, 202: 202, 203: 203, 204: 204, 205: 205, 206: 206, 207: 207,
				208: 208, 209: 209, 210: 210, 211: 211, 212: 212, 213: 213, 214: 214, 215: 215, 216: 216, 217: 217, 218: 218, 219: 219, 220: 220, 221: 221, 222: 222, 223: 223,
				224: 224, 225: 225, 226: 226, 227: 227, 228: 228, 229: 229, 230: 230, 231: 231, 232: 232, 233: 233, 234: 234, 235: 235, 236: 236, 237: 237, 238: 238, 239: 239,
				240: 240, 241: 241, 242: 242, 243: 243, 244: 244, 245: 245, 246: 246, 247: 247, 248: 248, 249: 249, 250: 250, 251: 251, 252: 252, 253: 253, 254: 254, 255: 255,
				35: 36,
			},
		}
	case 0x12d: // 301
		return &StringConverter{
			LangID:    301,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 355, 225, 259, 269, 231, 263, 321, 46, 60, 40, 43, 124,
				38, 233, 281, 235, 367, 237, 238, 318, 314, 223, 33, 36, 42, 41, 59, 729,
				45, 47, 194, 196, 733, 193, 258, 268, 199, 262, 323, 44, 37, 95, 62, 63,
				711, 201, 280, 203, 366, 205, 206, 317, 313, 96, 58, 35, 64, 39, 61, 34,
				728, 97, 98, 99, 100, 101, 102, 103, 104, 105, 347, 328, 273, 253, 345, 351,
				730, 106, 107, 108, 109, 110, 111, 112, 113, 114, 322, 324, 353, 184, 731, 164,
				261, 126, 115, 116, 117, 118, 119, 120, 121, 122, 346, 327, 272, 221, 344, 350,
				94, 260, 380, 354, 379, 167, 382, 378, 381, 377, 91, 93, 352, 168, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 341, 243, 337,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 282, 369, 252, 357, 250, 283,
				92, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 271, 212, 214, 340, 211, 336,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 270, 368, 220, 356, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 355: 68, 225: 69, 259: 70, 269: 71, 231: 72, 263: 73, 321: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				281: 82, 235: 83, 367: 84, 237: 85, 238: 86, 318: 87, 314: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 729: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 733: 100, 193: 101, 258: 102, 268: 103, 199: 104, 262: 105, 323: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 711: 112, 201: 113,
				280: 114, 203: 115, 366: 116, 205: 117, 206: 118, 317: 119, 313: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 728: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 347: 138, 328: 139, 273: 140, 253: 141, 345: 142, 351: 143, 730: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 322: 154, 324: 155, 353: 156, 184: 157, 731: 158, 164: 159, 261: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 346: 170, 327: 171, 272: 172, 221: 173, 344: 174, 350: 175, 94: 176, 260: 177,
				380: 178, 354: 179, 379: 180, 167: 181, 382: 182, 378: 183, 381: 184, 377: 185, 91: 186, 93: 187, 352: 188, 168: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 341: 205, 243: 206, 337: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 282: 218, 369: 219, 252: 220, 357: 221, 250: 222, 283: 223, 92: 224, 65535: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 271: 234, 212: 235, 214: 236, 340: 237, 211: 238, 336: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 270: 250, 368: 251, 220: 252, 356: 253, 218: 254, 159: 255, 176: 144,
			},
		}
	case 0x137: // 311
		return &StringConverter{
			LangID:    311,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 913, 914, 915, 916, 917, 918, 919, 920, 921, 65535, 46, 60, 40, 43, 124,
				38, 922, 923, 924, 925, 926, 927, 928, 929, 931, 33, 36, 42, 41, 59, 94,
				45, 47, 932, 933, 934, 935, 936, 937, 938, 939, 166, 44, 37, 95, 62, 63,
				168, 902, 904, 905, 65535, 906, 908, 910, 911, 96, 58, 35, 64, 39, 61, 34,
				901, 97, 98, 99, 100, 101, 102, 103, 104, 105, 945, 946, 947, 948, 949, 950,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 951, 952, 953, 954, 955, 956,
				900, 126, 115, 116, 117, 118, 119, 120, 121, 122, 957, 958, 959, 91, 961, 963,
				163, 940, 941, 942, 970, 943, 972, 973, 971, 974, 962, 964, 965, 93, 967, 968,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 969, 912, 944, 8216, 8213,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 177, 189, 960, 183, 8217, 65535,
				92, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 178, 167, 966, 65535, 171, 172,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 169, 65535, 65535, 187, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 913: 65,
				914: 66, 915: 67, 916: 68, 917: 69, 918: 70, 919: 71, 920: 72, 921: 73, 65535: 253, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 922: 81,
				923: 82, 924: 83, 925: 84, 926: 85, 927: 86, 928: 87, 929: 88, 931: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				932: 98, 933: 99, 934: 100, 935: 101, 936: 102, 937: 103, 938: 104, 939: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 168: 112, 902: 113,
				904: 114, 905: 115, 906: 117, 908: 118, 910: 119, 911: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 901: 128, 97: 129, 98: 130,
				99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 945: 138, 946: 139, 947: 140, 948: 141, 949: 142, 950: 143, 176: 144, 106: 145, 107: 146,
				108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 951: 154, 952: 155, 953: 156, 954: 157, 955: 158, 956: 159, 900: 160, 126: 161, 115: 162,
				116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 957: 170, 958: 171, 959: 172, 91: 173, 961: 174, 963: 175, 163: 176, 940: 177, 941: 178,
				942: 179, 970: 180, 943: 181, 972: 182, 973: 183, 971: 184, 974: 185, 962: 186, 964: 187, 965: 188, 93: 189, 967: 190, 968: 191, 123: 192, 65: 193, 66: 194,
				67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 969: 203, 912: 204, 944: 205, 8216: 206, 8213: 207, 125: 208, 74: 209, 75: 210,
				76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 177: 218, 189: 219, 960: 220, 183: 221, 8217: 222, 92: 224, 83: 226, 84: 227, 85: 228,
				86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 167: 235, 966: 236, 171: 238, 172: 239, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245,
				54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 169: 251, 187: 254, 159: 255, 8248: 95, 8764: 161, 376: 232,
			},
		}
	case 0x138: // 312
		return &StringConverter{
			LangID:    312,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 224, 225, 227, 229, 123, 241, 199, 46, 60, 40, 43, 124,
				38, 233, 234, 235, 232, 237, 238, 239, 236, 223, 33, 36, 42, 41, 59, 94,
				45, 47, 194, 196, 192, 193, 195, 197, 304, 209, 351, 44, 37, 95, 62, 63,
				248, 201, 202, 203, 200, 205, 206, 207, 204, 305, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 125, 96, 166, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 170, 186, 230, 184, 198, 164,
				181, 246, 115, 116, 117, 118, 119, 120, 121, 122, 161, 191, 168, 91, 350, 174,
				162, 163, 165, 183, 169, 167, 182, 188, 189, 190, 172, 286, 175, 93, 180, 215,
				231, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 126, 242, 243, 245,
				287, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 251, 252, 249, 250, 255,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 212, 214, 210, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 219, 220, 217, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 224: 68, 225: 69, 227: 70, 229: 71, 123: 72, 241: 73, 199: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				234: 82, 235: 83, 232: 84, 237: 85, 238: 86, 239: 87, 236: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 192: 100, 193: 101, 195: 102, 197: 103, 304: 104, 209: 105, 351: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				202: 114, 203: 115, 200: 116, 205: 117, 206: 118, 207: 119, 204: 120, 305: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 125: 140, 96: 141, 166: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 170: 154, 186: 155, 230: 156, 184: 157, 198: 158, 164: 159, 181: 160, 246: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 161: 170, 191: 171, 168: 172, 91: 173, 350: 174, 174: 175, 162: 176, 163: 177,
				165: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 172: 186, 286: 187, 175: 188, 93: 189, 180: 190, 215: 191, 231: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 126: 204, 242: 205, 243: 206, 245: 207, 287: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 251: 219, 252: 220, 249: 221, 250: 222, 255: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 212: 235, 214: 236, 210: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 219: 251, 220: 252, 217: 253, 218: 254, 159: 255, 63738: 201, 63736: 137,
			},
		}
	case 0x13a: // 314
		return &StringConverter{
			LangID:    314,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 353, 228, 261, 303, 363, 229, 275, 382, 162, 46, 60, 40, 43, 124,
				38, 233, 281, 279, 269, 371, 8222, 8220, 291, 223, 33, 36, 42, 41, 59, 94,
				45, 47, 352, 196, 260, 302, 362, 197, 274, 381, 166, 44, 37, 95, 62, 63,
				248, 201, 280, 278, 268, 370, 298, 315, 290, 96, 58, 35, 64, 39, 61, 34,
				216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 257, 380, 324, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 342, 343, 230, 311, 198, 164,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 8221, 378, 256, 91, 323, 174,
				172, 163, 299, 183, 169, 167, 182, 188, 189, 190, 379, 310, 377, 93, 316, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 333, 246, 326, 243, 245,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 263, 252, 322, 347, 8217,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 332, 214, 325, 211, 213,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 262, 220, 321, 346, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				353: 66, 228: 67, 261: 68, 303: 69, 363: 70, 229: 71, 275: 72, 382: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				281: 82, 279: 83, 269: 84, 371: 85, 8222: 86, 8220: 87, 291: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				352: 98, 196: 99, 260: 100, 302: 101, 362: 102, 197: 103, 274: 104, 381: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 248: 112, 201: 113,
				280: 114, 278: 115, 268: 116, 370: 117, 298: 118, 315: 119, 290: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 216: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 171: 138, 187: 139, 257: 140, 380: 141, 324: 142, 177: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 342: 154, 343: 155, 230: 156, 311: 157, 198: 158, 164: 159, 181: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 8221: 170, 378: 171, 256: 172, 91: 173, 323: 174, 174: 175, 172: 176, 163: 177,
				299: 178, 183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 379: 186, 310: 187, 377: 188, 93: 189, 316: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 333: 203, 246: 204, 326: 205, 243: 206, 245: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 185: 218, 263: 219, 252: 220, 322: 221, 347: 222, 8217: 223, 92: 224, 247: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 332: 235, 214: 236, 325: 237, 211: 238, 213: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 262: 251, 220: 252, 321: 253, 346: 254, 159: 255,
			},
		}
	case 0x13b: // 315
		return &StringConverter{
			LangID:    315,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  171,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 162, 46, 60, 40, 43, 124,
				38, 1497, 1498, 1499, 1500, 1501, 1502, 1503, 1504, 1505, 33, 36, 42, 41, 59, 94,
				45, 47, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 166, 44, 37, 95, 62, 63,
				65535, 1514, 65535, 65535, 160, 65535, 65535, 65535, 819, 96, 58, 35, 64, 39, 61, 34,
				65535, 97, 98, 99, 100, 101, 102, 103, 104, 105, 171, 187, 65535, 65535, 65535, 177,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 65535, 65535, 65535, 184, 65535, 164,
				181, 126, 115, 116, 117, 118, 119, 120, 121, 122, 65535, 65535, 65535, 91, 65535, 174,
				172, 163, 165, 183, 169, 167, 182, 188, 189, 190, 65535, 168, 175, 93, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 65535, 65535, 65535, 65535, 65535,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 185, 65535, 65535, 65535, 65535, 65535,
				92, 247, 83, 84, 85, 86, 87, 88, 89, 90, 178, 65535, 65535, 65535, 65535, 65535,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 65535, 65535, 65535, 65535, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 1488: 65,
				1489: 66, 1490: 67, 1491: 68, 1492: 69, 1493: 70, 1494: 71, 1495: 72, 1496: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 1497: 81,
				1498: 82, 1499: 83, 1500: 84, 1501: 85, 1502: 86, 1503: 87, 1504: 88, 1505: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				1506: 98, 1507: 99, 1508: 100, 1509: 101, 1510: 102, 1511: 103, 1512: 104, 1513: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 65535: 254, 1514: 113,
				160: 116, 819: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135,
				104: 136, 105: 137, 171: 138, 187: 139, 177: 143, 176: 144, 106: 145, 107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 184: 157,
				164: 159, 181: 160, 126: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 91: 173, 174: 175, 172: 176, 163: 177, 165: 178,
				183: 179, 169: 180, 167: 181, 182: 182, 188: 183, 189: 184, 190: 185, 168: 187, 175: 188, 93: 189, 180: 190, 215: 191, 123: 192, 65: 193, 66: 194, 67: 195,
				68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 125: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216,
				82: 217, 185: 218, 92: 224, 247: 225, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 48: 240, 49: 241, 50: 242,
				51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 159: 255,
			},
		}
	case 0x13c: // 316
		return &StringConverter{
			LangID:    316,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 226, 228, 355, 225, 259, 269, 231, 263, 221, 46, 60, 40, 43, 124,
				38, 233, 281, 235, 367, 237, 238, 318, 314, 223, 33, 36, 42, 41, 59, 94,
				45, 47, 194, 196, 733, 193, 258, 268, 199, 262, 168, 44, 37, 95, 62, 63,
				711, 201, 280, 203, 366, 205, 206, 317, 313, 96, 58, 35, 64, 39, 61, 34,
				728, 97, 98, 99, 100, 101, 102, 103, 104, 105, 347, 328, 273, 253, 345, 351,
				730, 106, 107, 108, 109, 110, 111, 112, 113, 114, 322, 324, 353, 184, 731, 164,
				261, 126, 115, 116, 117, 118, 119, 120, 121, 122, 346, 327, 272, 91, 344, 350,
				729, 260, 380, 354, 379, 167, 382, 378, 381, 377, 321, 323, 352, 93, 180, 215,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 244, 246, 341, 243, 337,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 282, 369, 252, 357, 250, 283,
				92, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 271, 212, 214, 340, 211, 336,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 270, 368, 220, 356, 218, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				226: 66, 228: 67, 355: 68, 225: 69, 259: 70, 269: 71, 231: 72, 263: 73, 221: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 233: 81,
				281: 82, 235: 83, 367: 84, 237: 85, 238: 86, 318: 87, 314: 88, 223: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				194: 98, 196: 99, 733: 100, 193: 101, 258: 102, 268: 103, 199: 104, 262: 105, 168: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 711: 112, 201: 113,
				280: 114, 203: 115, 366: 116, 205: 117, 206: 118, 317: 119, 313: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 728: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 347: 138, 328: 139, 273: 140, 253: 141, 345: 142, 351: 143, 730: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 322: 154, 324: 155, 353: 156, 184: 157, 731: 158, 164: 159, 261: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 346: 170, 327: 171, 272: 172, 91: 173, 344: 174, 350: 175, 729: 176, 260: 177,
				380: 178, 354: 179, 379: 180, 167: 181, 382: 182, 378: 183, 381: 184, 377: 185, 321: 186, 323: 187, 352: 188, 93: 189, 180: 190, 215: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 244: 203, 246: 204, 341: 205, 243: 206, 337: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 282: 218, 369: 219, 252: 220, 357: 221, 250: 222, 283: 223, 92: 224, 65535: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 271: 234, 212: 235, 214: 236, 340: 237, 211: 238, 336: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 270: 250, 368: 251, 220: 252, 356: 253, 218: 254, 159: 255, 176: 144,
			},
		}
	case 0x13d: // 317
		return &StringConverter{
			LangID:    317,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 1106, 1107, 1105, 1108, 1109, 1110, 1111, 1112, 1091, 46, 60, 40, 43, 124,
				38, 1113, 1114, 1115, 1116, 1118, 1119, 1066, 8470, 1026, 33, 36, 42, 41, 59, 94,
				45, 47, 1027, 1025, 1028, 1029, 1030, 1031, 1032, 1033, 1045, 44, 37, 95, 62, 63,
				1034, 1035, 1036, 173, 1038, 1039, 1102, 1072, 1073, 96, 58, 35, 64, 39, 61, 34,
				1094, 97, 98, 99, 100, 101, 102, 103, 104, 105, 1076, 1077, 1092, 1075, 1093, 1080,
				1081, 106, 107, 108, 109, 110, 111, 112, 113, 114, 1082, 1083, 1084, 1085, 1086, 1087,
				1103, 126, 115, 116, 117, 118, 119, 120, 121, 122, 1088, 1089, 1090, 91, 1078, 1074,
				1100, 1099, 1079, 1096, 1101, 1097, 1095, 1098, 1070, 1040, 1041, 1062, 1044, 93, 1060, 1043,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 1061, 1048, 1049, 1050, 1051, 1052,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 1053, 1054, 1055, 1071, 1056, 1057,
				92, 167, 83, 84, 85, 86, 87, 88, 89, 90, 1058, 1059, 1046, 1042, 1068, 1067,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 1047, 1064, 1069, 1065, 1063, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				1106: 66, 1107: 67, 1105: 68, 1108: 69, 1109: 70, 1110: 71, 1111: 72, 1112: 73, 1091: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 1113: 81,
				1114: 82, 1115: 83, 1116: 84, 1118: 85, 1119: 86, 1066: 87, 8470: 88, 1026: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				1027: 98, 1025: 99, 1028: 100, 1029: 101, 1030: 102, 1031: 103, 1032: 104, 1033: 105, 1045: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 1034: 112, 1035: 113,
				1036: 114, 173: 115, 1038: 116, 1039: 117, 1102: 118, 1072: 119, 1073: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 1094: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 1076: 138, 1077: 139, 1092: 140, 1075: 141, 1093: 142, 1080: 143, 1081: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 1082: 154, 1083: 155, 1084: 156, 1085: 157, 1086: 158, 1087: 159, 1103: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 1088: 170, 1089: 171, 1090: 172, 91: 173, 1078: 174, 1074: 175, 1100: 176, 1099: 177,
				1079: 178, 1096: 179, 1101: 180, 1097: 181, 1095: 182, 1098: 183, 1070: 184, 1040: 185, 1041: 186, 1062: 187, 1044: 188, 93: 189, 1060: 190, 1043: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 1061: 202, 1048: 203, 1049: 204, 1050: 205, 1051: 206, 1052: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 1053: 218, 1054: 219, 1055: 220, 1071: 221, 1056: 222, 1057: 223, 92: 224, 167: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 1058: 234, 1059: 235, 1046: 236, 1042: 237, 1068: 238, 1067: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 1047: 250, 1064: 251, 1069: 252, 1065: 253, 1063: 254, 159: 255,
			},
		}
	case 0x13f: // 319
		return &StringConverter{
			LangID:    319,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 65535, 3585, 3586, 3587, 3588, 3589, 3590, 3591, 3628, 162, 46, 60, 40, 43, 124,
				38, 65535, 3592, 3593, 3594, 3595, 3596, 3597, 3598, 3634, 33, 36, 42, 41, 59, 94,
				45, 47, 3599, 3600, 3601, 3602, 3603, 3604, 3605, 3664, 166, 44, 37, 95, 62, 63,
				3647, 3662, 3606, 3607, 3608, 3609, 3610, 3611, 3612, 96, 58, 35, 64, 39, 61, 34,
				3663, 97, 98, 99, 100, 101, 102, 103, 104, 105, 3613, 3614, 3615, 3616, 3617, 3618,
				3674, 106, 107, 108, 109, 110, 111, 112, 113, 114, 3619, 3620, 3621, 3622, 3623, 3624,
				3675, 126, 115, 116, 117, 118, 119, 120, 121, 122, 3625, 3626, 3627, 91, 3629, 3630,
				172, 3665, 3666, 3667, 3668, 3669, 3670, 3671, 3672, 3673, 3631, 3632, 3633, 93, 3635, 3636,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 65535, 3637, 3638, 3639, 3640, 3641,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 3642, 3648, 3649, 3650, 3651, 3652,
				92, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 3653, 3654, 3655, 3656, 3657, 3658,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 3659, 3660, 3661, 65535, 65535, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 65535: 254,
				3585: 66, 3586: 67, 3587: 68, 3588: 69, 3589: 70, 3590: 71, 3591: 72, 3628: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 3592: 82,
				3593: 83, 3594: 84, 3595: 85, 3596: 86, 3597: 87, 3598: 88, 3634: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97, 3599: 98,
				3600: 99, 3601: 100, 3602: 101, 3603: 102, 3604: 103, 3605: 104, 3664: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 3647: 112, 3662: 113, 3606: 114,
				3607: 115, 3608: 116, 3609: 117, 3610: 118, 3611: 119, 3612: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 3663: 128, 97: 129, 98: 130,
				99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 3613: 138, 3614: 139, 3615: 140, 3616: 141, 3617: 142, 3618: 143, 3674: 144, 106: 145, 107: 146,
				108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 3619: 154, 3620: 155, 3621: 156, 3622: 157, 3623: 158, 3624: 159, 3675: 160, 126: 161, 115: 162,
				116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 3625: 170, 3626: 171, 3627: 172, 91: 173, 3629: 174, 3630: 175, 172: 176, 3665: 177, 3666: 178,
				3667: 179, 3668: 180, 3669: 181, 3670: 182, 3671: 183, 3672: 184, 3673: 185, 3631: 186, 3632: 187, 3633: 188, 93: 189, 3635: 190, 3636: 191, 123: 192, 65: 193, 66: 194,
				67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 3637: 203, 3638: 204, 3639: 205, 3640: 206, 3641: 207, 125: 208, 74: 209, 75: 210, 76: 211,
				77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 3642: 218, 3648: 219, 3649: 220, 3650: 221, 3651: 222, 3652: 223, 92: 224, 83: 226, 84: 227, 85: 228,
				86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 3653: 234, 3654: 235, 3655: 236, 3656: 237, 3657: 238, 3658: 239, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244,
				53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 3659: 250, 3660: 251, 3661: 252, 159: 255,
			},
		}
	case 0x140: // 320
		return &StringConverter{
			LangID:    320,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  123,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 1617, 65535, 1600, 65535, 1569, 1570, 65535, 1571, 162, 46, 60, 40, 43, 124,
				38, 65535, 1572, 65535, 65535, 1574, 1575, 65535, 65535, 1576, 33, 36, 42, 41, 59, 94,
				45, 47, 1577, 65535, 1578, 65535, 1579, 65535, 1580, 65535, 166, 44, 37, 95, 62, 63,
				1581, 65535, 1582, 1583, 1584, 1585, 1586, 65535, 1587, 1548, 58, 35, 64, 39, 61, 34,
				65535, 97, 98, 99, 100, 101, 102, 103, 104, 105, 1588, 65535, 1589, 65535, 1590, 1591,
				1592, 106, 107, 108, 109, 110, 111, 112, 113, 114, 65535, 65535, 1593, 65535, 65535, 65535,
				1594, 247, 115, 116, 117, 118, 119, 120, 121, 122, 65535, 65535, 1601, 91, 1602, 65535,
				172, 65535, 65535, 65535, 65535, 65535, 1603, 215, 65535, 65535, 1604, 65535, 1605, 93, 1606, 65535,
				1563, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 1607, 65535, 65535, 65535, 1608,
				1567, 74, 75, 76, 77, 78, 79, 80, 81, 82, 1609, 65535, 65535, 65535, 1610, 65535,
				92, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 65535, 65535, 65535, 65535, 65535, 65535,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65535, 65535, 65535, 65535, 65535, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				1617: 66, 65535: 254, 1600: 68, 1569: 70, 1570: 71, 1571: 73, 162: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 1572: 82, 1574: 85, 1575: 86,
				1576: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97, 1577: 98, 1578: 100, 1579: 102, 1580: 104, 166: 106, 44: 107, 37: 108,
				95: 109, 62: 110, 63: 111, 1581: 112, 1582: 114, 1583: 115, 1584: 116, 1585: 117, 1586: 118, 1587: 120, 1548: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126,
				34: 127, 97: 129, 98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 1588: 138, 1589: 140, 1590: 142, 1591: 143, 1592: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 1593: 156, 1594: 160, 247: 161, 115: 162, 116: 163, 117: 164, 118: 165, 119: 166,
				120: 167, 121: 168, 122: 169, 1601: 172, 91: 173, 1602: 174, 172: 176, 1603: 182, 215: 183, 1604: 186, 1605: 188, 93: 189, 1606: 190, 1563: 192, 65: 193, 66: 194,
				67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 1607: 203, 1608: 207, 1567: 208, 74: 209, 75: 210, 76: 211, 77: 212, 78: 213,
				79: 214, 80: 215, 81: 216, 82: 217, 1609: 218, 1610: 222, 92: 224, 83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 48: 240,
				49: 241, 50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 159: 255,
			},
		}
	case 0x142: // 322
		return &StringConverter{
			LangID:    322,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 1106, 1107, 1105, 1108, 1109, 1110, 1111, 1112, 1041, 46, 60, 40, 43, 124,
				38, 1113, 1114, 1115, 1116, 1118, 1119, 1066, 8470, 1026, 33, 36, 42, 41, 59, 1100,
				45, 47, 1027, 1025, 1028, 1029, 1030, 1031, 1032, 1033, 1062, 44, 37, 95, 62, 63,
				1034, 1035, 1036, 173, 1038, 1039, 1102, 1072, 1073, 96, 58, 35, 64, 39, 61, 34,
				1094, 97, 98, 99, 100, 101, 102, 103, 104, 105, 1076, 1077, 1092, 1075, 1093, 1080,
				1081, 106, 107, 108, 109, 110, 111, 112, 113, 114, 1082, 1083, 1084, 1085, 1086, 1087,
				1103, 126, 115, 116, 117, 118, 119, 120, 121, 122, 1088, 1089, 1090, 1091, 1078, 1074,
				94, 1099, 1079, 1096, 1101, 1097, 1095, 1098, 1070, 1040, 91, 93, 1044, 1045, 1060, 1043,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 1061, 1048, 1049, 1050, 1051, 1052,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 1053, 1054, 1055, 1071, 1056, 1057,
				92, 167, 83, 84, 85, 86, 87, 88, 89, 90, 1058, 1059, 1046, 1042, 1068, 1067,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 1047, 1064, 1069, 1065, 1063, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				1106: 66, 1107: 67, 1105: 68, 1108: 69, 1109: 70, 1110: 71, 1111: 72, 1112: 73, 1041: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 1113: 81,
				1114: 82, 1115: 83, 1116: 84, 1118: 85, 1119: 86, 1066: 87, 8470: 88, 1026: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 1100: 95, 45: 96, 47: 97,
				1027: 98, 1025: 99, 1028: 100, 1029: 101, 1030: 102, 1031: 103, 1032: 104, 1033: 105, 1062: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 1034: 112, 1035: 113,
				1036: 114, 173: 115, 1038: 116, 1039: 117, 1102: 118, 1072: 119, 1073: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 1094: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 1076: 138, 1077: 139, 1092: 140, 1075: 141, 1093: 142, 1080: 143, 1081: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 1082: 154, 1083: 155, 1084: 156, 1085: 157, 1086: 158, 1087: 159, 1103: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 1088: 170, 1089: 171, 1090: 172, 1091: 173, 1078: 174, 1074: 175, 94: 176, 1099: 177,
				1079: 178, 1096: 179, 1101: 180, 1097: 181, 1095: 182, 1098: 183, 1070: 184, 1040: 185, 91: 186, 93: 187, 1044: 188, 1045: 189, 1060: 190, 1043: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 1061: 202, 1048: 203, 1049: 204, 1050: 205, 1051: 206, 1052: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 1053: 218, 1054: 219, 1055: 220, 1071: 221, 1056: 222, 1057: 223, 92: 224, 167: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 1058: 234, 1059: 235, 1046: 236, 1042: 237, 1068: 238, 1067: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 1047: 250, 1064: 251, 1069: 252, 1065: 253, 1063: 254, 159: 255,
			},
		}
	case 0x143: // 323
		return &StringConverter{
			LangID:    323,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 1072, 1073, 1074, 1075, 1076, 1077, 1105, 1078, 1079, 46, 60, 40, 43, 124,
				38, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 8470, 1087, 33, 36, 42, 41, 59, 94,
				45, 47, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 166, 44, 37, 95, 62, 63,
				1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1106, 96, 58, 35, 64, 39, 61, 34,
				1107, 97, 98, 99, 100, 101, 102, 103, 104, 105, 1108, 1109, 1110, 1111, 1112, 1113,
				1114, 106, 107, 108, 109, 110, 111, 112, 113, 114, 1115, 1116, 1118, 1119, 1040, 164,
				1041, 126, 115, 116, 117, 118, 119, 120, 121, 122, 1042, 1043, 1044, 91, 1045, 1025,
				1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 93, 1059, 1060,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 1061, 1062, 1063, 1064, 1065, 1066,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 1067, 1068, 1069, 1070, 1071, 1026,
				92, 1027, 83, 84, 85, 86, 87, 88, 89, 90, 1028, 1029, 1030, 1031, 1032, 1033,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 1034, 1035, 1036, 1038, 1039, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				1072: 66, 1073: 67, 1074: 68, 1075: 69, 1076: 70, 1077: 71, 1105: 72, 1078: 73, 1079: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 1080: 81,
				1081: 82, 1082: 83, 1083: 84, 1084: 85, 1085: 86, 1086: 87, 8470: 88, 1087: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				1088: 98, 1089: 99, 1090: 100, 1091: 101, 1092: 102, 1093: 103, 1094: 104, 1095: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 1096: 112, 1097: 113,
				1098: 114, 1099: 115, 1100: 116, 1101: 117, 1102: 118, 1103: 119, 1106: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 1107: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 1108: 138, 1109: 139, 1110: 140, 1111: 141, 1112: 142, 1113: 143, 1114: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 1115: 154, 1116: 155, 1118: 156, 1119: 157, 1040: 158, 164: 159, 1041: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 1042: 170, 1043: 171, 1044: 172, 91: 173, 1045: 174, 1025: 175, 1046: 176, 1047: 177,
				1048: 178, 1049: 179, 1050: 180, 1051: 181, 1052: 182, 1053: 183, 1054: 184, 1055: 185, 1056: 186, 1057: 187, 1058: 188, 93: 189, 1059: 190, 1060: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 1061: 202, 1062: 203, 1063: 204, 1064: 205, 1065: 206, 1066: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 1067: 218, 1068: 219, 1069: 220, 1070: 221, 1071: 222, 1026: 223, 92: 224, 1027: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 1028: 234, 1029: 235, 1030: 236, 1031: 237, 1032: 238, 1033: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 1034: 250, 1035: 251, 1036: 252, 1038: 253, 1039: 254, 159: 255,
			},
		}
	case 0x144: // 324
		return &StringConverter{
			LangID:    324,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 913, 914, 915, 916, 917, 918, 919, 920, 921, 46, 60, 40, 43, 124,
				38, 922, 923, 924, 925, 926, 927, 928, 929, 931, 33, 36, 42, 41, 59, 94,
				45, 47, 932, 933, 934, 935, 936, 937, 938, 939, 166, 44, 37, 95, 62, 63,
				168, 902, 904, 905, 906, 908, 910, 911, 901, 96, 58, 35, 64, 39, 61, 34,
				945, 97, 98, 99, 100, 101, 102, 103, 104, 105, 946, 947, 948, 949, 950, 951,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 952, 953, 954, 955, 956, 900,
				957, 126, 115, 116, 117, 118, 119, 120, 121, 122, 958, 959, 960, 91, 961, 963,
				163, 940, 941, 942, 970, 943, 972, 973, 971, 974, 962, 964, 965, 93, 966, 967,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 968, 969, 912, 8216, 8213,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 177, 189, 944, 183, 8217, 8364,
				92, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 178, 167, 65535, 65535, 171, 172,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 169, 65535, 65535, 187, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				913: 66, 914: 67, 915: 68, 916: 69, 917: 70, 918: 71, 919: 72, 920: 73, 921: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 922: 81,
				923: 82, 924: 83, 925: 84, 926: 85, 927: 86, 928: 87, 929: 88, 931: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				932: 98, 933: 99, 934: 100, 935: 101, 936: 102, 937: 103, 938: 104, 939: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 168: 112, 902: 113,
				904: 114, 905: 115, 906: 116, 908: 117, 910: 118, 911: 119, 901: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 945: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 946: 138, 947: 139, 948: 140, 949: 141, 950: 142, 951: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 952: 154, 953: 155, 954: 156, 955: 157, 956: 158, 900: 159, 957: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 958: 170, 959: 171, 960: 172, 91: 173, 961: 174, 963: 175, 163: 176, 940: 177,
				941: 178, 942: 179, 970: 180, 943: 181, 972: 182, 973: 183, 971: 184, 974: 185, 962: 186, 964: 187, 965: 188, 93: 189, 966: 190, 967: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 968: 203, 969: 204, 912: 205, 8216: 206, 8213: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 177: 218, 189: 219, 944: 220, 183: 221, 8217: 222, 8364: 223, 92: 224, 65535: 253,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 167: 235, 171: 238, 172: 239, 48: 240, 49: 241, 50: 242, 51: 243,
				52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 169: 251, 187: 254, 159: 255, 8248: 95, 8764: 161, 376: 232,
			},
		}
	case 0x145: // 325
		return &StringConverter{
			LangID:    325,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 1106, 1169, 1105, 1108, 1109, 1110, 1111, 1112, 91, 46, 60, 40, 43, 33,
				38, 1113, 1114, 1115, 1116, 1118, 1119, 1066, 8470, 1026, 93, 36, 42, 41, 59, 94,
				45, 47, 1168, 1025, 1028, 1029, 1030, 1031, 1032, 1033, 124, 44, 37, 95, 62, 63,
				1034, 1035, 1036, 173, 1038, 1039, 1102, 1072, 1073, 96, 58, 35, 64, 39, 61, 34,
				1094, 97, 98, 99, 100, 101, 102, 103, 104, 105, 1076, 1077, 1092, 1075, 1093, 1080,
				1081, 106, 107, 108, 109, 110, 111, 112, 113, 114, 1082, 1083, 1084, 1085, 1086, 1087,
				1103, 126, 115, 116, 117, 118, 119, 120, 121, 122, 1088, 1089, 1090, 1091, 1078, 1074,
				1100, 1099, 1079, 1096, 1101, 1097, 1095, 1098, 1070, 1040, 1041, 1062, 1044, 1045, 1060, 1043,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 1061, 1048, 1049, 1050, 1051, 1052,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 1053, 1054, 1055, 1071, 1056, 1057,
				92, 8364, 83, 84, 85, 86, 87, 88, 89, 90, 1058, 1059, 1046, 1042, 1068, 1067,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 1047, 1064, 1069, 1065, 1063, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				1106: 66, 1169: 67, 1105: 68, 1108: 69, 1109: 70, 1110: 71, 1111: 72, 1112: 73, 91: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 1113: 81,
				1114: 82, 1115: 83, 1116: 84, 1118: 85, 1119: 86, 1066: 87, 8470: 88, 1026: 89, 93: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				1168: 98, 1025: 99, 1028: 100, 1029: 101, 1030: 102, 1031: 103, 1032: 104, 1033: 105, 124: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 1034: 112, 1035: 113,
				1036: 114, 173: 115, 1038: 116, 1039: 117, 1102: 118, 1072: 119, 1073: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 1094: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 1076: 138, 1077: 139, 1092: 140, 1075: 141, 1093: 142, 1080: 143, 1081: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 1082: 154, 1083: 155, 1084: 156, 1085: 157, 1086: 158, 1087: 159, 1103: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 1088: 170, 1089: 171, 1090: 172, 1091: 173, 1078: 174, 1074: 175, 1100: 176, 1099: 177,
				1079: 178, 1096: 179, 1101: 180, 1097: 181, 1095: 182, 1098: 183, 1070: 184, 1040: 185, 1041: 186, 1062: 187, 1044: 188, 1045: 189, 1060: 190, 1043: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 1061: 202, 1048: 203, 1049: 204, 1050: 205, 1051: 206, 1052: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 1053: 218, 1054: 219, 1055: 220, 1071: 221, 1056: 222, 1057: 223, 92: 224, 8364: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 1058: 234, 1059: 235, 1046: 236, 1042: 237, 1068: 238, 1067: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 1047: 250, 1064: 251, 1069: 252, 1065: 253, 1063: 254, 159: 255,
			},
		}
	case 0x146: // 326
		return &StringConverter{
			LangID:    326,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 160, 1072, 1073, 1074, 1075, 1076, 1077, 1105, 1078, 1079, 46, 60, 40, 43, 124,
				38, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 8470, 1087, 33, 36, 42, 41, 59, 94,
				45, 47, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 166, 44, 37, 95, 62, 63,
				1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1106, 96, 58, 35, 64, 39, 61, 34,
				1169, 97, 98, 99, 100, 101, 102, 103, 104, 105, 1108, 1109, 1110, 1111, 1112, 1113,
				1114, 106, 107, 108, 109, 110, 111, 112, 113, 114, 1115, 1116, 1118, 1119, 1040, 8364,
				1041, 126, 115, 116, 117, 118, 119, 120, 121, 122, 1042, 1043, 1044, 91, 1045, 1025,
				1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 93, 1059, 1060,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 1061, 1062, 1063, 1064, 1065, 1066,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 1067, 1068, 1069, 1070, 1071, 1026,
				92, 1168, 83, 84, 85, 86, 87, 88, 89, 90, 1028, 1029, 1030, 1031, 1032, 1033,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 1034, 1035, 1036, 1038, 1039, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 160: 65,
				1072: 66, 1073: 67, 1074: 68, 1075: 69, 1076: 70, 1077: 71, 1105: 72, 1078: 73, 1079: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 1080: 81,
				1081: 82, 1082: 83, 1083: 84, 1084: 85, 1085: 86, 1086: 87, 8470: 88, 1087: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				1088: 98, 1089: 99, 1090: 100, 1091: 101, 1092: 102, 1093: 103, 1094: 104, 1095: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 1096: 112, 1097: 113,
				1098: 114, 1099: 115, 1100: 116, 1101: 117, 1102: 118, 1103: 119, 1106: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 1169: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 1108: 138, 1109: 139, 1110: 140, 1111: 141, 1112: 142, 1113: 143, 1114: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 1115: 154, 1116: 155, 1118: 156, 1119: 157, 1040: 158, 8364: 159, 1041: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 1042: 170, 1043: 171, 1044: 172, 91: 173, 1045: 174, 1025: 175, 1046: 176, 1047: 177,
				1048: 178, 1049: 179, 1050: 180, 1051: 181, 1052: 182, 1053: 183, 1054: 184, 1055: 185, 1056: 186, 1057: 187, 1058: 188, 93: 189, 1059: 190, 1060: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 1061: 202, 1062: 203, 1063: 204, 1064: 205, 1065: 206, 1066: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 1067: 218, 1068: 219, 1069: 220, 1070: 221, 1071: 222, 1026: 223, 92: 224, 1168: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 1028: 234, 1029: 235, 1030: 236, 1031: 237, 1032: 238, 1033: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 1034: 250, 1035: 251, 1036: 252, 1038: 253, 1039: 254, 159: 255,
			},
		}
	case 0x147: // 327
		return &StringConverter{
			LangID:    327,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 167, 913, 914, 915, 916, 917, 918, 919, 920, 921, 46, 60, 40, 43, 124,
				38, 922, 923, 924, 925, 926, 927, 928, 929, 931, 33, 36, 42, 41, 59, 94,
				45, 47, 932, 933, 934, 935, 936, 937, 196, 214, 166, 44, 37, 95, 62, 63,
				220, 902, 904, 905, 906, 908, 910, 911, 168, 96, 58, 35, 64, 39, 61, 34,
				184, 97, 98, 99, 100, 101, 102, 103, 104, 105, 945, 946, 947, 948, 949, 950,
				951, 106, 107, 108, 109, 110, 111, 112, 113, 114, 952, 953, 954, 955, 956, 900,
				957, 126, 115, 116, 117, 118, 119, 120, 121, 122, 958, 959, 960, 91, 961, 963,
				163, 940, 941, 942, 970, 943, 972, 973, 971, 974, 962, 964, 965, 93, 966, 967,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 968, 969, 226, 224, 228,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 234, 233, 232, 235, 238, 239,
				92, 176, 83, 84, 85, 86, 87, 88, 89, 90, 189, 246, 244, 251, 249, 252,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 255, 231, 199, 8364, 177, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 167: 65,
				913: 66, 914: 67, 915: 68, 916: 69, 917: 70, 918: 71, 919: 72, 920: 73, 921: 74, 46: 75, 60: 76, 40: 77, 43: 78, 124: 79, 38: 80, 922: 81,
				923: 82, 924: 83, 925: 84, 926: 85, 927: 86, 928: 87, 929: 88, 931: 89, 33: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				932: 98, 933: 99, 934: 100, 935: 101, 936: 102, 937: 103, 196: 104, 214: 105, 166: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 220: 112, 902: 113,
				904: 114, 905: 115, 906: 116, 908: 117, 910: 118, 911: 119, 168: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 184: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 945: 138, 946: 139, 947: 140, 948: 141, 949: 142, 950: 143, 951: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 952: 154, 953: 155, 954: 156, 955: 157, 956: 158, 900: 159, 957: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 958: 170, 959: 171, 960: 172, 91: 173, 961: 174, 963: 175, 163: 176, 940: 177,
				941: 178, 942: 179, 970: 180, 943: 181, 972: 182, 973: 183, 971: 184, 974: 185, 962: 186, 964: 187, 965: 188, 93: 189, 966: 190, 967: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 968: 203, 969: 204, 226: 205, 224: 206, 228: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 234: 218, 233: 219, 232: 220, 235: 221, 238: 222, 239: 223, 92: 224, 176: 225,
				83: 226, 84: 227, 85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 189: 234, 246: 235, 244: 236, 251: 237, 249: 238, 252: 239, 48: 240, 49: 241,
				50: 242, 51: 243, 52: 244, 53: 245, 54: 246, 55: 247, 56: 248, 57: 249, 255: 250, 231: 251, 199: 252, 8364: 253, 177: 254, 159: 255, 8248: 95, 8764: 161,
				376: 232,
			},
		}
	case 0x15f: // 351
		return &StringConverter{
			LangID:    351,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  192,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 12, 10, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232,
				234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252,
				8224, 176, 162, 163, 167, 8226, 182, 223, 174, 169, 8482, 180, 168, 8800, 198, 216,
				8734, 177, 8804, 8805, 165, 181, 8706, 8721, 8719, 960, 8747, 170, 186, 937, 230, 248,
				191, 161, 172, 8730, 402, 8776, 8710, 171, 187, 8230, 160, 192, 195, 213, 338, 339,
				8211, 8212, 8220, 8221, 8216, 8217, 247, 9674, 255, 376, 8260, 8364, 8249, 8250, 64257, 64258,
				8225, 183, 8218, 8222, 8240, 194, 202, 193, 203, 200, 205, 206, 207, 204, 211, 212,
				63743, 210, 218, 219, 217, 305, 710, 732, 175, 728, 729, 730, 184, 733, 731, 711,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 13: 10, 11: 11, 12: 12, 10: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 197: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 227: 139, 229: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 237: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 242: 152, 244: 153, 246: 154, 245: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				8224: 160, 176: 161, 162: 162, 163: 163, 167: 164, 8226: 165, 182: 166, 223: 167, 174: 168, 169: 169, 8482: 170, 180: 171, 168: 172, 8800: 173, 198: 174, 216: 175,
				8734: 176, 177: 177, 8804: 178, 8805: 179, 165: 180, 181: 181, 8706: 182, 8721: 183, 8719: 184, 960: 185, 8747: 186, 170: 187, 186: 188, 937: 189, 230: 190, 248: 191,
				191: 192, 161: 193, 172: 194, 8730: 195, 402: 196, 8776: 197, 8710: 198, 171: 199, 187: 200, 8230: 201, 160: 202, 192: 203, 195: 204, 213: 205, 338: 206, 339: 207,
				8211: 208, 8212: 209, 8220: 210, 8221: 211, 8216: 212, 8217: 213, 247: 214, 9674: 215, 255: 216, 376: 217, 8260: 218, 8364: 219, 8249: 220, 8250: 221, 64257: 222, 64258: 223,
				8225: 224, 183: 225, 8218: 226, 8222: 227, 8240: 228, 194: 229, 202: 230, 193: 231, 203: 232, 200: 233, 205: 234, 206: 235, 207: 236, 204: 237, 211: 238, 212: 239,
				63743: 240, 210: 241, 218: 242, 219: 243, 217: 244, 305: 245, 710: 246, 732: 247, 175: 248, 728: 249, 729: 250, 730: 251, 184: 252, 733: 253, 731: 254, 711: 255,
				8486: 189, 173: 208, 8213: 209, 164: 219, 8248: 246, 8764: 247, 713: 248, 63740: 240, 63741: 196,
			},
		}
	case 0x160: // 352
		return &StringConverter{
			LangID:    352,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  192,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232,
				234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252,
				8224, 176, 162, 163, 167, 8226, 182, 223, 174, 169, 8482, 180, 168, 8800, 198, 216,
				8734, 177, 8804, 8805, 165, 181, 8706, 8721, 8719, 960, 8747, 170, 186, 937, 230, 248,
				191, 161, 172, 8730, 402, 8776, 8710, 171, 187, 8230, 160, 192, 195, 213, 338, 339,
				8211, 8212, 8220, 8221, 8216, 8217, 247, 9674, 255, 376, 8260, 8364, 8249, 8250, 64257, 64258,
				8225, 183, 8218, 8222, 8240, 194, 202, 193, 203, 200, 205, 206, 207, 204, 211, 212,
				63743, 210, 218, 219, 217, 305, 710, 732, 175, 728, 729, 730, 184, 733, 731, 711,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 197: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 227: 139, 229: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 237: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 242: 152, 244: 153, 246: 154, 245: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				8224: 160, 176: 161, 162: 162, 163: 163, 167: 164, 8226: 165, 182: 166, 223: 167, 174: 168, 169: 169, 8482: 170, 180: 171, 168: 172, 8800: 173, 198: 174, 216: 175,
				8734: 176, 177: 177, 8804: 178, 8805: 179, 165: 180, 181: 181, 8706: 182, 8721: 183, 8719: 184, 960: 185, 8747: 186, 170: 187, 186: 188, 937: 189, 230: 190, 248: 191,
				191: 192, 161: 193, 172: 194, 8730: 195, 402: 196, 8776: 197, 8710: 198, 171: 199, 187: 200, 8230: 201, 160: 202, 192: 203, 195: 204, 213: 205, 338: 206, 339: 207,
				8211: 208, 8212: 209, 8220: 210, 8221: 211, 8216: 212, 8217: 213, 247: 214, 9674: 215, 255: 216, 376: 217, 8260: 218, 8364: 219, 8249: 220, 8250: 221, 64257: 222, 64258: 223,
				8225: 224, 183: 225, 8218: 226, 8222: 227, 8240: 228, 194: 229, 202: 230, 193: 231, 203: 232, 200: 233, 205: 234, 206: 235, 207: 236, 204: 237, 211: 238, 212: 239,
				63743: 240, 210: 241, 218: 242, 219: 243, 217: 244, 305: 245, 710: 246, 732: 247, 175: 248, 728: 249, 729: 250, 730: 251, 184: 252, 733: 253, 731: 254, 711: 255,
				8486: 189, 173: 208, 8213: 209, 164: 219, 8248: 246, 8764: 247, 713: 248, 63740: 240, 63741: 196,
			},
		}
	case 0x161: // 353
		return &StringConverter{
			LangID:    353,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 12, 10, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				171, 187, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 8220, 8221, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 8216, 8217, 65535,
				160, 3585, 3586, 3587, 3588, 3589, 3590, 3591, 3592, 3593, 3594, 3595, 3596, 3597, 3598, 3599,
				3600, 3601, 3602, 3603, 3604, 3605, 3606, 3607, 3608, 3609, 3610, 3611, 3612, 3613, 3614, 3615,
				3616, 3617, 3618, 3619, 3620, 3621, 3622, 3623, 3624, 3625, 3626, 3627, 3628, 3629, 3630, 3631,
				3632, 3633, 3634, 3635, 3636, 3637, 3638, 3639, 3640, 3641, 65535, 65535, 65535, 173, 8213, 3647,
				3648, 3649, 3650, 3651, 3652, 3653, 3654, 3655, 3656, 3657, 3658, 3659, 3660, 3661, 8482, 3663,
				3664, 3665, 3666, 3667, 3668, 3669, 3670, 3671, 3672, 3673, 174, 169, 65535, 65535, 65535, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 13: 10, 11: 11, 12: 12, 10: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				171: 128, 187: 129, 65535: 255, 8220: 141, 8221: 142, 8216: 157, 8217: 158, 160: 160, 3585: 161, 3586: 162, 3587: 163, 3588: 164, 3589: 165, 3590: 166, 3591: 167, 3592: 168,
				3593: 169, 3594: 170, 3595: 171, 3596: 172, 3597: 173, 3598: 174, 3599: 175, 3600: 176, 3601: 177, 3602: 178, 3603: 179, 3604: 180, 3605: 181, 3606: 182, 3607: 183, 3608: 184,
				3609: 185, 3610: 186, 3611: 187, 3612: 188, 3613: 189, 3614: 190, 3615: 191, 3616: 192, 3617: 193, 3618: 194, 3619: 195, 3620: 196, 3621: 197, 3622: 198, 3623: 199, 3624: 200,
				3625: 201, 3626: 202, 3627: 203, 3628: 204, 3629: 205, 3630: 206, 3631: 207, 3632: 208, 3633: 209, 3634: 210, 3635: 211, 3636: 212, 3637: 213, 3638: 214, 3639: 215, 3640: 216,
				3641: 217, 173: 221, 8213: 222, 3647: 223, 3648: 224, 3649: 225, 3650: 226, 3651: 227, 3652: 228, 3653: 229, 3654: 230, 3655: 231, 3656: 232, 3657: 233, 3658: 234, 3659: 235,
				3660: 236, 3661: 237, 8482: 238, 3663: 239, 3664: 240, 3665: 241, 3666: 242, 3667: 243, 3668: 244, 3669: 245, 3670: 246, 3671: 247, 3672: 248, 3673: 249, 174: 250, 169: 251,
			},
		}
	case 0x162: // 354
		return &StringConverter{
			LangID:    354,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				171, 187, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 8220, 8221, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 8216, 8217, 65535,
				160, 3585, 3586, 3587, 3588, 3589, 3590, 3591, 3592, 3593, 3594, 3595, 3596, 3597, 3598, 3599,
				3600, 3601, 3602, 3603, 3604, 3605, 3606, 3607, 3608, 3609, 3610, 3611, 3612, 3613, 3614, 3615,
				3616, 3617, 3618, 3619, 3620, 3621, 3622, 3623, 3624, 3625, 3626, 3627, 3628, 3629, 3630, 3631,
				3632, 3633, 3634, 3635, 3636, 3637, 3638, 3639, 3640, 3641, 65535, 65535, 65535, 173, 8213, 3647,
				3648, 3649, 3650, 3651, 3652, 3653, 3654, 3655, 3656, 3657, 3658, 3659, 3660, 3661, 8482, 3663,
				3664, 3665, 3666, 3667, 3668, 3669, 3670, 3671, 3672, 3673, 174, 169, 65535, 65535, 65535, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				171: 128, 187: 129, 65535: 255, 8220: 141, 8221: 142, 8216: 157, 8217: 158, 160: 160, 3585: 161, 3586: 162, 3587: 163, 3588: 164, 3589: 165, 3590: 166, 3591: 167, 3592: 168,
				3593: 169, 3594: 170, 3595: 171, 3596: 172, 3597: 173, 3598: 174, 3599: 175, 3600: 176, 3601: 177, 3602: 178, 3603: 179, 3604: 180, 3605: 181, 3606: 182, 3607: 183, 3608: 184,
				3609: 185, 3610: 186, 3611: 187, 3612: 188, 3613: 189, 3614: 190, 3615: 191, 3616: 192, 3617: 193, 3618: 194, 3619: 195, 3620: 196, 3621: 197, 3622: 198, 3623: 199, 3624: 200,
				3625: 201, 3626: 202, 3627: 203, 3628: 204, 3629: 205, 3630: 206, 3631: 207, 3632: 208, 3633: 209, 3634: 210, 3635: 211, 3636: 212, 3637: 213, 3638: 214, 3639: 215, 3640: 216,
				3641: 217, 173: 221, 8213: 222, 3647: 223, 3648: 224, 3649: 225, 3650: 226, 3651: 227, 3652: 228, 3653: 229, 3654: 230, 3655: 231, 3656: 232, 3657: 233, 3658: 234, 3659: 235,
				3660: 236, 3661: 237, 8482: 238, 3663: 239, 3664: 240, 3665: 241, 3666: 242, 3667: 243, 3668: 244, 3669: 245, 3670: 246, 3671: 247, 3672: 248, 3673: 249, 174: 250, 169: 251,
			},
		}
	case 0x170: // 368
		return &StringConverter{
			LangID:    368,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 239, 238, 205, 196, 193,
				201, 230, 198, 337, 246, 211, 369, 218, 368, 214, 220, 162, 163, 165, 8359, 402,
				225, 237, 243, 250, 241, 209, 170, 336, 191, 65535, 172, 189, 188, 161, 171, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				945, 946, 915, 960, 931, 963, 956, 964, 934, 920, 937, 948, 65535, 966, 949, 65535,
				65535, 177, 8805, 8804, 65535, 65535, 247, 65535, 176, 183, 65535, 65535, 65535, 178, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 252: 129, 233: 130, 226: 131, 228: 132, 224: 133, 229: 134, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 205: 141, 196: 142, 193: 143,
				201: 144, 230: 145, 198: 146, 337: 147, 246: 148, 211: 149, 369: 150, 218: 151, 368: 152, 214: 153, 220: 154, 162: 155, 163: 156, 165: 157, 8359: 158, 402: 159,
				225: 160, 237: 161, 243: 162, 250: 163, 241: 164, 209: 165, 170: 166, 336: 167, 191: 168, 65535: 255, 172: 170, 189: 171, 188: 172, 161: 173, 171: 174, 187: 175,
				945: 224, 946: 225, 915: 226, 960: 227, 931: 228, 963: 229, 956: 230, 964: 231, 934: 232, 920: 233, 937: 234, 948: 235, 966: 237, 949: 238, 177: 241, 8805: 242,
				8804: 243, 247: 246, 176: 248, 183: 249, 178: 253, 8718: 254, 8216: 96, 8213: 45, 160: 32, 173: 45, 180: 39, 8248: 94, 8764: 126, 8356: 76, 194: 65, 206: 73,
				212: 79, 221: 89, 253: 121, 223: 225, 63741: 159,
			},
		}
	case 0x17c: // 380
		return &StringConverter{
			LangID:    380,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928,
				929, 931, 932, 933, 934, 935, 936, 937, 945, 946, 947, 948, 949, 950, 951, 952,
				953, 954, 955, 956, 957, 958, 959, 960, 961, 963, 962, 964, 965, 966, 967, 968,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				969, 940, 941, 942, 970, 943, 972, 973, 971, 974, 902, 904, 905, 906, 908, 910,
				911, 177, 8805, 8804, 65535, 65535, 247, 65535, 176, 65535, 183, 65535, 65535, 178, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				913: 128, 914: 129, 915: 130, 916: 131, 917: 132, 918: 133, 919: 134, 920: 135, 921: 136, 922: 137, 923: 138, 924: 139, 925: 140, 926: 141, 927: 142, 928: 143,
				929: 144, 931: 145, 932: 146, 933: 147, 934: 148, 935: 149, 936: 150, 937: 151, 945: 152, 946: 153, 947: 154, 948: 155, 949: 156, 950: 157, 951: 158, 952: 159,
				953: 160, 954: 161, 955: 162, 956: 163, 957: 164, 958: 165, 959: 166, 960: 167, 961: 168, 963: 169, 962: 170, 964: 171, 965: 172, 966: 173, 967: 174, 968: 175,
				65535: 255, 969: 224, 940: 225, 941: 226, 942: 227, 970: 228, 943: 229, 972: 230, 973: 231, 971: 232, 974: 233, 902: 234, 904: 235, 905: 236, 906: 237, 908: 238,
				910: 239, 911: 240, 177: 241, 8805: 242, 8804: 243, 247: 246, 176: 248, 183: 250, 178: 253, 8718: 254, 8216: 96, 8217: 39, 8213: 45, 160: 32, 173: 45, 180: 39,
				8248: 94, 8764: 126, 168: 34, 8356: 76, 192: 65, 193: 65, 194: 65, 200: 69, 202: 69, 204: 73, 205: 73, 206: 73, 210: 79, 211: 79, 212: 79, 217: 85,
				218: 85, 219: 85, 221: 89, 253: 121, 938: 136, 939: 147, 912: 228, 944: 232, 900: 96,
			},
		}
	case 0x17d: // 381
		return &StringConverter{
			LangID:    381,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  111,
			dBuffer: []int{
				0, 1, 2, 3, 156, 9, 134, 127, 151, 141, 142, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 157, 10, 8, 135, 24, 25, 146, 143, 28, 29, 30, 31,
				128, 129, 28, 131, 132, 10, 23, 27, 136, 137, 138, 139, 140, 5, 6, 7,
				144, 145, 22, 147, 148, 149, 150, 4, 152, 153, 154, 155, 20, 21, 158, 26,
				32, 913, 914, 915, 916, 917, 918, 919, 920, 921, 91, 46, 60, 40, 43, 33,
				38, 922, 923, 924, 925, 926, 927, 928, 929, 931, 93, 36, 42, 41, 59, 94,
				45, 47, 932, 933, 934, 935, 936, 937, 938, 939, 124, 44, 37, 95, 62, 63,
				168, 902, 904, 905, 65535, 906, 908, 910, 911, 96, 58, 35, 64, 39, 61, 34,
				901, 97, 98, 99, 100, 101, 102, 103, 104, 105, 945, 946, 947, 948, 949, 950,
				176, 106, 107, 108, 109, 110, 111, 112, 113, 114, 951, 952, 953, 954, 955, 956,
				900, 126, 115, 116, 117, 118, 119, 120, 121, 122, 957, 958, 959, 960, 961, 963,
				163, 940, 941, 942, 970, 943, 972, 973, 971, 974, 962, 964, 965, 966, 967, 968,
				123, 65, 66, 67, 68, 69, 70, 71, 72, 73, 173, 969, 912, 944, 8216, 8213,
				125, 74, 75, 76, 77, 78, 79, 80, 81, 82, 177, 189, 65535, 183, 8217, 166,
				92, 65535, 83, 84, 85, 86, 87, 88, 89, 90, 178, 167, 65535, 65535, 171, 172,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 179, 169, 65535, 65535, 187, 159,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 156: 4, 9: 5, 134: 6, 127: 7, 151: 8, 141: 9, 142: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 157: 20, 10: 37, 8: 22, 135: 23, 24: 24, 25: 25, 146: 26, 143: 27, 28: 34, 29: 29, 30: 30, 31: 31,
				128: 32, 129: 33, 131: 35, 132: 36, 23: 38, 27: 39, 136: 40, 137: 41, 138: 42, 139: 43, 140: 44, 5: 45, 6: 46, 7: 47, 144: 48, 145: 49,
				22: 50, 147: 51, 148: 52, 149: 53, 150: 54, 4: 55, 152: 56, 153: 57, 154: 58, 155: 59, 20: 60, 21: 61, 158: 62, 26: 63, 32: 64, 913: 65,
				914: 66, 915: 67, 916: 68, 917: 69, 918: 70, 919: 71, 920: 72, 921: 73, 91: 74, 46: 75, 60: 76, 40: 77, 43: 78, 33: 79, 38: 80, 922: 81,
				923: 82, 924: 83, 925: 84, 926: 85, 927: 86, 928: 87, 929: 88, 931: 89, 93: 90, 36: 91, 42: 92, 41: 93, 59: 94, 94: 95, 45: 96, 47: 97,
				932: 98, 933: 99, 934: 100, 935: 101, 936: 102, 937: 103, 938: 104, 939: 105, 124: 106, 44: 107, 37: 108, 95: 109, 62: 110, 63: 111, 168: 112, 902: 113,
				904: 114, 905: 115, 65535: 253, 906: 117, 908: 118, 910: 119, 911: 120, 96: 121, 58: 122, 35: 123, 64: 124, 39: 125, 61: 126, 34: 127, 901: 128, 97: 129,
				98: 130, 99: 131, 100: 132, 101: 133, 102: 134, 103: 135, 104: 136, 105: 137, 945: 138, 946: 139, 947: 140, 948: 141, 949: 142, 950: 143, 176: 144, 106: 145,
				107: 146, 108: 147, 109: 148, 110: 149, 111: 150, 112: 151, 113: 152, 114: 153, 951: 154, 952: 155, 953: 156, 954: 157, 955: 158, 956: 159, 900: 160, 126: 161,
				115: 162, 116: 163, 117: 164, 118: 165, 119: 166, 120: 167, 121: 168, 122: 169, 957: 170, 958: 171, 959: 172, 960: 173, 961: 174, 963: 175, 163: 176, 940: 177,
				941: 178, 942: 179, 970: 180, 943: 181, 972: 182, 973: 183, 971: 184, 974: 185, 962: 186, 964: 187, 965: 188, 966: 189, 967: 190, 968: 191, 123: 192, 65: 193,
				66: 194, 67: 195, 68: 196, 69: 197, 70: 198, 71: 199, 72: 200, 73: 201, 173: 202, 969: 203, 912: 204, 944: 205, 8216: 206, 8213: 207, 125: 208, 74: 209,
				75: 210, 76: 211, 77: 212, 78: 213, 79: 214, 80: 215, 81: 216, 82: 217, 177: 218, 189: 219, 183: 221, 8217: 222, 166: 223, 92: 224, 83: 226, 84: 227,
				85: 228, 86: 229, 87: 230, 88: 231, 89: 232, 90: 233, 178: 234, 167: 235, 171: 238, 172: 239, 48: 240, 49: 241, 50: 242, 51: 243, 52: 244, 53: 245,
				54: 246, 55: 247, 56: 248, 57: 249, 179: 250, 169: 251, 187: 254, 159: 255, 8248: 95, 8764: 161, 376: 232,
			},
		}
	case 0x17e: // 382
		return &StringConverter{
			LangID:    382,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928,
				929, 931, 932, 933, 934, 935, 936, 937, 945, 946, 947, 948, 949, 950, 951, 952,
				953, 954, 955, 956, 957, 958, 959, 960, 961, 963, 962, 964, 965, 966, 967, 968,
				9617, 9618, 9619, 9474, 9508, 9569, 9570, 9558, 9557, 9571, 9553, 9559, 9565, 9564, 9563, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 9566, 9567, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 9575,
				9576, 9572, 9573, 9561, 9560, 9554, 9555, 9579, 9578, 9496, 9484, 9608, 9604, 9612, 9616, 9600,
				969, 940, 941, 942, 970, 943, 972, 973, 971, 974, 902, 904, 905, 906, 908, 910,
				911, 177, 8805, 8804, 938, 939, 247, 8776, 176, 8226, 183, 8730, 8319, 178, 8718, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				913: 128, 914: 129, 915: 130, 916: 131, 917: 132, 918: 133, 919: 134, 920: 135, 921: 136, 922: 137, 923: 138, 924: 139, 925: 140, 926: 141, 927: 142, 928: 143,
				929: 144, 931: 145, 932: 146, 933: 147, 934: 148, 935: 149, 936: 150, 937: 151, 945: 152, 946: 153, 947: 154, 948: 155, 949: 156, 950: 157, 951: 158, 952: 159,
				953: 160, 954: 161, 955: 162, 956: 163, 957: 164, 958: 165, 959: 166, 960: 167, 961: 168, 963: 169, 962: 170, 964: 171, 965: 172, 966: 173, 967: 174, 968: 175,
				9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 9569: 181, 9570: 182, 9558: 183, 9557: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 9564: 189, 9563: 190, 9488: 191,
				9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 9566: 198, 9567: 199, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 9575: 207,
				9576: 208, 9572: 209, 9573: 210, 9561: 211, 9560: 212, 9554: 213, 9555: 214, 9579: 215, 9578: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 9612: 221, 9616: 222, 9600: 223,
				969: 224, 940: 225, 941: 226, 942: 227, 970: 228, 943: 229, 972: 230, 973: 231, 971: 232, 974: 233, 902: 234, 904: 235, 905: 236, 906: 237, 908: 238, 910: 239,
				911: 240, 177: 241, 8805: 242, 8804: 243, 938: 244, 939: 245, 247: 246, 8776: 247, 176: 248, 8226: 249, 183: 250, 8730: 251, 8319: 252, 178: 253, 8718: 254, 160: 255,
			},
		}
	case 0x17f: // 383
		return &StringConverter{
			LangID:    383,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055,
				1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071,
				1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087,
				65535, 65535, 65535, 65535, 65535, 260, 268, 280, 278, 65535, 65535, 65535, 65535, 302, 352, 172,
				65535, 65535, 65535, 65535, 65535, 65535, 370, 362, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 381,
				261, 269, 281, 279, 303, 353, 371, 363, 382, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103,
				1025, 1105, 8805, 8804, 8220, 8221, 247, 65535, 176, 729, 183, 65535, 8470, 178, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1040: 128, 1041: 129, 1042: 130, 1043: 131, 1044: 132, 1045: 133, 1046: 134, 1047: 135, 1048: 136, 1049: 137, 1050: 138, 1051: 139, 1052: 140, 1053: 141, 1054: 142, 1055: 143,
				1056: 144, 1057: 145, 1058: 146, 1059: 147, 1060: 148, 1061: 149, 1062: 150, 1063: 151, 1064: 152, 1065: 153, 1066: 154, 1067: 155, 1068: 156, 1069: 157, 1070: 158, 1071: 159,
				1072: 160, 1073: 161, 1074: 162, 1075: 163, 1076: 164, 1077: 165, 1078: 166, 1079: 167, 1080: 168, 1081: 169, 1082: 170, 1083: 171, 1084: 172, 1085: 173, 1086: 174, 1087: 175,
				65535: 255, 260: 181, 268: 182, 280: 183, 278: 184, 302: 189, 352: 190, 172: 191, 370: 198, 362: 199, 381: 207, 261: 208, 269: 209, 281: 210, 279: 211, 303: 212,
				353: 213, 371: 214, 363: 215, 382: 216, 1088: 224, 1089: 225, 1090: 226, 1091: 227, 1092: 228, 1093: 229, 1094: 230, 1095: 231, 1096: 232, 1097: 233, 1098: 234, 1099: 235,
				1100: 236, 1101: 237, 1102: 238, 1103: 239, 1025: 240, 1105: 241, 8805: 242, 8804: 243, 8220: 244, 8221: 245, 247: 246, 176: 248, 729: 249, 183: 250, 8470: 252, 178: 253,
				8718: 254, 160: 32, 173: 45,
			},
		}
	case 0x180: // 384
		return &StringConverter{
			LangID:    384,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 239, 238, 236, 196, 197,
				201, 230, 198, 244, 246, 242, 251, 249, 255, 214, 220, 162, 163, 165, 8359, 402,
				225, 237, 243, 250, 241, 209, 170, 186, 191, 65535, 172, 189, 188, 161, 171, 187,
				65535, 65535, 65535, 65535, 65535, 260, 268, 280, 278, 65535, 65535, 65535, 65535, 302, 352, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 370, 362, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 381,
				261, 269, 281, 279, 303, 353, 371, 363, 382, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				945, 946, 915, 960, 931, 963, 956, 964, 934, 920, 937, 948, 65535, 216, 65535, 65535,
				65535, 177, 8805, 8804, 65535, 65535, 247, 65535, 176, 729, 183, 65535, 65535, 178, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 252: 129, 233: 130, 226: 131, 228: 132, 224: 133, 229: 134, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 236: 141, 196: 142, 197: 143,
				201: 144, 230: 145, 198: 146, 244: 147, 246: 148, 242: 149, 251: 150, 249: 151, 255: 152, 214: 153, 220: 154, 162: 155, 163: 156, 165: 157, 8359: 158, 402: 159,
				225: 160, 237: 161, 243: 162, 250: 163, 241: 164, 209: 165, 170: 166, 186: 167, 191: 168, 65535: 255, 172: 170, 189: 171, 188: 172, 161: 173, 171: 174, 187: 175,
				260: 181, 268: 182, 280: 183, 278: 184, 302: 189, 352: 190, 370: 198, 362: 199, 381: 207, 261: 208, 269: 209, 281: 210, 279: 211, 303: 212, 353: 213, 371: 214,
				363: 215, 382: 216, 945: 224, 946: 225, 915: 226, 960: 227, 931: 228, 963: 229, 956: 230, 964: 231, 934: 232, 920: 233, 937: 234, 948: 235, 216: 237, 177: 241,
				8805: 242, 8804: 243, 247: 246, 176: 248, 729: 249, 183: 250, 178: 253, 8718: 254, 8216: 96, 8213: 45, 160: 32, 173: 45, 166: 124, 180: 39, 8248: 94, 8764: 126,
				8356: 76, 192: 65, 193: 65, 194: 65, 195: 65, 256: 65, 272: 68, 200: 69, 202: 69, 203: 69, 274: 69, 204: 73, 205: 73, 206: 73, 296: 73, 298: 73,
				310: 75, 315: 76, 325: 78, 210: 79, 211: 79, 212: 79, 213: 79, 332: 79, 342: 82, 358: 84, 217: 85, 218: 85, 219: 85, 360: 85, 221: 89, 290: 71,
				227: 97, 257: 97, 273: 100, 275: 101, 297: 105, 299: 105, 311: 107, 316: 108, 326: 110, 245: 111, 333: 111, 343: 114, 359: 116, 361: 117, 253: 121, 501: 103,
				223: 225, 63741: 159,
			},
		}
	case 0x181: // 385
		return &StringConverter{
			LangID:    385,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 902, 65535, 183, 172, 166, 8216, 8217, 904, 8213, 905,
				906, 938, 908, 65535, 65535, 910, 939, 169, 911, 178, 179, 940, 163, 941, 942, 943,
				970, 912, 972, 973, 913, 914, 915, 916, 917, 918, 919, 189, 920, 921, 171, 187,
				9617, 9618, 9619, 9474, 9508, 922, 923, 924, 925, 9571, 9553, 9559, 9565, 926, 927, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 928, 929, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 931,
				932, 933, 934, 935, 936, 937, 945, 946, 947, 9496, 9484, 9608, 9604, 948, 949, 9600,
				950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 963, 962, 964, 180,
				173, 177, 965, 966, 967, 167, 968, 901, 176, 168, 969, 971, 944, 974, 8718, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 148, 902: 134, 183: 136, 172: 137, 166: 138, 8216: 139, 8217: 140, 904: 141, 8213: 142, 905: 143, 906: 144, 938: 145, 908: 146, 910: 149, 939: 150, 169: 151,
				911: 152, 178: 153, 179: 154, 940: 155, 163: 156, 941: 157, 942: 158, 943: 159, 970: 160, 912: 161, 972: 162, 973: 163, 913: 164, 914: 165, 915: 166, 916: 167,
				917: 168, 918: 169, 919: 170, 189: 171, 920: 172, 921: 173, 171: 174, 187: 175, 9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 922: 181, 923: 182, 924: 183,
				925: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 926: 189, 927: 190, 9488: 191, 9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 928: 198, 929: 199,
				9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 931: 207, 932: 208, 933: 209, 934: 210, 935: 211, 936: 212, 937: 213, 945: 214, 946: 215,
				947: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 948: 221, 949: 222, 9600: 223, 950: 224, 951: 225, 952: 226, 953: 227, 954: 228, 955: 229, 956: 230, 957: 231,
				958: 232, 959: 233, 960: 234, 961: 235, 963: 236, 962: 237, 964: 238, 180: 239, 173: 240, 177: 241, 965: 242, 966: 243, 967: 244, 167: 245, 968: 246, 901: 247,
				176: 248, 168: 249, 969: 250, 971: 251, 944: 252, 974: 253, 8718: 254, 160: 255, 63742: 136,
			},
		}
	case 0x182: // 386
		return &StringConverter{
			LangID:    386,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 252, 233, 226, 228, 224, 902, 231, 234, 235, 232, 239, 238, 904, 196, 905,
				906, 65535, 908, 244, 246, 910, 251, 249, 911, 214, 220, 940, 163, 941, 942, 943,
				970, 912, 972, 973, 913, 914, 915, 916, 917, 918, 919, 189, 920, 921, 171, 187,
				9617, 9618, 9619, 9474, 9508, 922, 923, 924, 925, 9571, 9553, 9559, 9565, 926, 927, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 928, 929, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 931,
				932, 933, 934, 935, 936, 937, 945, 946, 947, 9496, 9484, 9608, 9604, 948, 949, 9600,
				950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 963, 962, 964, 180,
				173, 177, 965, 966, 967, 167, 968, 184, 176, 168, 969, 971, 944, 974, 8718, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 252: 129, 233: 130, 226: 131, 228: 132, 224: 133, 902: 134, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 904: 141, 196: 142, 905: 143,
				906: 144, 65535: 145, 908: 146, 244: 147, 246: 148, 910: 149, 251: 150, 249: 151, 911: 152, 214: 153, 220: 154, 940: 155, 163: 156, 941: 157, 942: 158, 943: 159,
				970: 160, 912: 161, 972: 162, 973: 163, 913: 164, 914: 165, 915: 166, 916: 167, 917: 168, 918: 169, 919: 170, 189: 171, 920: 172, 921: 173, 171: 174, 187: 175,
				9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 922: 181, 923: 182, 924: 183, 925: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 926: 189, 927: 190, 9488: 191,
				9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 928: 198, 929: 199, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 931: 207,
				932: 208, 933: 209, 934: 210, 935: 211, 936: 212, 937: 213, 945: 214, 946: 215, 947: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 948: 221, 949: 222, 9600: 223,
				950: 224, 951: 225, 952: 226, 953: 227, 954: 228, 955: 229, 956: 230, 957: 231, 958: 232, 959: 233, 960: 234, 961: 235, 963: 236, 962: 237, 964: 238, 180: 239,
				173: 240, 177: 241, 965: 242, 966: 243, 967: 244, 167: 245, 968: 246, 184: 247, 176: 248, 168: 249, 969: 250, 971: 251, 944: 252, 974: 253, 8718: 254, 160: 255,
			},
		}
	case 0x186: // 390
		return &StringConverter{
			LangID:    390,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 252, 233, 226, 194, 224, 182, 231, 234, 235, 232, 239, 238, 819, 192, 167,
				201, 200, 202, 244, 203, 207, 251, 249, 164, 212, 220, 162, 163, 217, 219, 402,
				166, 180, 243, 250, 168, 184, 179, 713, 206, 65535, 172, 189, 188, 190, 171, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				945, 946, 915, 960, 931, 963, 956, 964, 934, 920, 937, 948, 65535, 966, 949, 65535,
				65535, 177, 8805, 8804, 65535, 65535, 247, 65535, 176, 183, 65535, 65535, 65535, 178, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 252: 129, 233: 130, 226: 131, 194: 132, 224: 133, 182: 134, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 819: 141, 192: 142, 167: 143,
				201: 144, 200: 145, 202: 146, 244: 147, 203: 148, 207: 149, 251: 150, 249: 151, 164: 152, 212: 153, 220: 154, 162: 155, 163: 156, 217: 157, 219: 158, 402: 159,
				166: 160, 180: 161, 243: 162, 250: 163, 168: 164, 184: 165, 179: 166, 713: 167, 206: 168, 65535: 255, 172: 170, 189: 171, 188: 172, 190: 173, 171: 174, 187: 175,
				945: 224, 946: 225, 915: 226, 960: 227, 931: 228, 963: 229, 956: 230, 964: 231, 934: 232, 920: 233, 937: 234, 948: 235, 966: 237, 949: 238, 177: 241, 8805: 242,
				8804: 243, 247: 246, 176: 248, 183: 249, 178: 253, 8718: 254, 8216: 96, 181: 230, 8213: 45, 175: 167, 160: 32, 173: 45, 8248: 94, 8764: 126, 8356: 76, 193: 65,
				195: 65, 197: 65, 204: 73, 205: 73, 210: 79, 211: 79, 213: 79, 352: 83, 218: 85, 221: 89, 376: 89, 225: 97, 227: 97, 229: 97, 236: 105, 237: 105,
				242: 111, 245: 111, 353: 115, 253: 121, 255: 121, 223: 225, 63741: 159,
			},
		}
	case 0x191: // 401
		return &StringConverter{
			LangID:    401,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  254,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 188, 170, 226, 228, 193, 201, 205, 211, 214, 336, 218, 220, 368, 196, 197,
				229, 230, 198, 172, 174, 242, 161, 249, 255, 235, 238, 248, 163, 216, 215, 402,
				209, 186, 191, 189, 241, 225, 233, 237, 243, 246, 337, 250, 252, 369, 171, 187,
				65535, 65535, 65535, 65535, 65535, 224, 194, 192, 169, 65535, 65535, 65535, 65535, 162, 165, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 227, 195, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 164,
				240, 208, 202, 203, 200, 305, 231, 206, 207, 65535, 65535, 65535, 65535, 166, 204, 65535,
				234, 223, 232, 210, 245, 213, 181, 254, 222, 239, 236, 217, 253, 221, 175, 180,
				173, 177, 65535, 190, 182, 167, 247, 184, 176, 168, 183, 185, 179, 178, 8718, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 188: 129, 170: 130, 226: 131, 228: 132, 193: 133, 201: 134, 205: 135, 211: 136, 214: 137, 336: 138, 218: 139, 220: 140, 368: 141, 196: 142, 197: 143,
				229: 144, 230: 145, 198: 146, 172: 147, 174: 148, 242: 149, 161: 150, 249: 151, 255: 152, 235: 153, 238: 154, 248: 155, 163: 156, 216: 157, 215: 158, 402: 159,
				209: 160, 186: 161, 191: 162, 189: 163, 241: 164, 225: 165, 233: 166, 237: 167, 243: 168, 246: 169, 337: 170, 250: 171, 252: 172, 369: 173, 171: 174, 187: 175,
				65535: 242, 224: 181, 194: 182, 192: 183, 169: 184, 162: 189, 165: 190, 227: 198, 195: 199, 164: 207, 240: 208, 208: 209, 202: 210, 203: 211, 200: 212, 305: 213,
				231: 214, 206: 215, 207: 216, 166: 221, 204: 222, 234: 224, 223: 225, 232: 226, 210: 227, 245: 228, 213: 229, 181: 230, 254: 231, 222: 232, 239: 233, 236: 234,
				217: 235, 253: 236, 221: 237, 175: 238, 180: 239, 173: 240, 177: 241, 190: 243, 182: 244, 167: 245, 247: 246, 184: 247, 176: 248, 168: 249, 183: 250, 185: 251,
				179: 252, 178: 253, 8718: 254, 160: 255, 63741: 159,
			},
		}
	case 0x1f4: // 500
		return &StringConverter{
			LangID:    500,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				199, 252, 233, 226, 228, 224, 229, 231, 234, 235, 232, 239, 238, 236, 65535, 65535,
				65535, 65535, 65535, 244, 246, 242, 251, 249, 174, 8482, 65535, 65535, 65535, 65535, 65535, 65535,
				160, 161, 162, 402, 164, 165, 166, 167, 168, 169, 8248, 65535, 1548, 173, 171, 187,
				176, 177, 178, 179, 65535, 65535, 182, 945, 966, 185, 8764, 1563, 188, 189, 190, 1567,
				65535, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583,
				1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 65535, 65535, 65535, 65535, 191,
				1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 1611, 1612, 1613, 1614, 1615,
				1616, 1617, 1618, 65535, 65535, 65535, 65535, 65535, 65535, 215, 247, 946, 956, 163, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				199: 128, 252: 129, 233: 130, 226: 131, 228: 132, 224: 133, 229: 134, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 236: 141, 65535: 255, 244: 147,
				246: 148, 242: 149, 251: 150, 249: 151, 174: 152, 8482: 153, 160: 160, 161: 161, 162: 162, 402: 163, 164: 164, 165: 165, 166: 166, 167: 167, 168: 168, 169: 169,
				8248: 170, 1548: 172, 173: 173, 171: 174, 187: 175, 176: 176, 177: 177, 178: 178, 179: 179, 182: 182, 945: 183, 966: 184, 185: 185, 8764: 186, 1563: 187, 188: 188,
				189: 189, 190: 190, 1567: 191, 1569: 193, 1570: 194, 1571: 195, 1572: 196, 1573: 197, 1574: 198, 1575: 199, 1576: 200, 1577: 201, 1578: 202, 1579: 203, 1580: 204, 1581: 205,
				1582: 206, 1583: 207, 1584: 208, 1585: 209, 1586: 210, 1587: 211, 1588: 212, 1589: 213, 1590: 214, 1591: 215, 1592: 216, 1593: 217, 1594: 218, 191: 223, 1600: 224, 1601: 225,
				1602: 226, 1603: 227, 1604: 228, 1605: 229, 1606: 230, 1607: 231, 1608: 232, 1609: 233, 1610: 234, 1611: 235, 1612: 236, 1613: 237, 1614: 238, 1615: 239, 1616: 240, 1617: 241,
				1618: 242, 215: 249, 247: 250, 946: 251, 956: 252, 163: 253, 8718: 254, 63741: 163,
			},
		}
	case 0x1f8: // 504
		return &StringConverter{
			LangID:    504,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 160, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 1618, 1617, 1614, 64608, 1611, 63731, 1615, 64609, 1612,
				64606, 1616, 64610, 1613, 64607, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 171, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593,
				1594, 1600, 1601, 1602, 1603, 1604, 1605, 65535, 1606, 1607, 65535, 1608, 1609, 1610, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 160: 131, 1618: 151, 1617: 152, 1614: 153, 64608: 154, 1611: 155, 63731: 156, 1615: 157, 64609: 158, 1612: 159, 64606: 160, 1616: 161, 64610: 162, 1613: 163, 64607: 164,
				1569: 165, 1570: 166, 1571: 167, 1572: 168, 1573: 169, 1574: 170, 1575: 171, 1576: 172, 1577: 173, 171: 174, 187: 175, 1578: 224, 1579: 225, 1580: 226, 1581: 227, 1582: 228,
				1583: 229, 1584: 230, 1585: 231, 1586: 232, 1587: 233, 1588: 234, 1589: 235, 1590: 236, 1591: 237, 1592: 238, 1593: 239, 1594: 240, 1600: 241, 1601: 242, 1602: 243, 1603: 244,
				1604: 245, 1605: 246, 1606: 248, 1607: 249, 1608: 251, 1609: 252, 1610: 253, 8718: 254,
			},
		}
	case 0x1f9: // 505
		return &StringConverter{
			LangID:    505,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 233, 226, 65535, 224, 65535, 231, 234, 235, 232, 239, 238, 65535, 65535, 65535,
				65535, 65535, 65535, 244, 65535, 65535, 251, 249, 65535, 65535, 65535, 65535, 65535, 1611, 1612, 1613,
				1614, 1615, 1616, 1617, 1618, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 65535, 160,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593,
				1594, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 176, 1608, 1609, 1610, 1600, 65535, 65535, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 233: 130, 226: 131, 224: 133, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 244: 147, 251: 150, 249: 151, 1611: 157, 1612: 158, 1613: 159,
				1614: 160, 1615: 161, 1616: 162, 1617: 163, 1618: 164, 1569: 165, 1570: 166, 1571: 167, 1572: 168, 1573: 169, 1574: 170, 1575: 171, 1576: 172, 1577: 173, 160: 175, 1578: 224,
				1579: 225, 1580: 226, 1581: 227, 1582: 228, 1583: 229, 1584: 230, 1585: 231, 1586: 232, 1587: 233, 1588: 234, 1589: 235, 1590: 236, 1591: 237, 1592: 238, 1593: 239, 1594: 240,
				1601: 241, 1602: 242, 1603: 243, 1604: 244, 1605: 245, 1606: 246, 1607: 247, 176: 248, 1608: 249, 1609: 250, 1610: 251, 1600: 252,
			},
		}
	case 0x1fa: // 506
		return &StringConverter{
			LangID:    506,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 65535, 1579, 1580, 65535, 1581, 1582,
				1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1601, 1602, 1603, 1604,
				1605, 1606, 1607, 1608, 1609, 1610, 1600, 1548, 1563, 1567, 65535, 65535, 65535, 65535, 171, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 160, 65535, 65535, 65535, 65535, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1569: 128, 1570: 129, 1571: 130, 1572: 131, 1573: 132, 1574: 133, 1575: 134, 1576: 135, 1577: 136, 1578: 137, 65535: 255, 1579: 139, 1580: 140, 1581: 142, 1582: 143, 1583: 144,
				1584: 145, 1585: 146, 1586: 147, 1587: 148, 1588: 149, 1589: 150, 1590: 151, 1591: 152, 1592: 153, 1593: 154, 1594: 155, 1601: 156, 1602: 157, 1603: 158, 1604: 159, 1605: 160,
				1606: 161, 1607: 162, 1608: 163, 1609: 164, 1610: 165, 1600: 166, 1548: 167, 1563: 168, 1567: 169, 171: 174, 187: 175, 160: 249, 8718: 254,
			},
		}
	case 0x1fb: // 507
		return &StringConverter{
			LangID:    507,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1611, 1612, 233, 226, 1613, 224, 1614, 231, 234, 235, 232, 239, 238, 1615, 1616, 1617,
				1618, 63731, 64606, 244, 64607, 64608, 251, 249, 64609, 64610, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 171, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593,
				1594, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 1600, 65535, 65535, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1611: 128, 1612: 129, 233: 130, 226: 131, 1613: 132, 224: 133, 1614: 134, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 1615: 141, 1616: 142, 1617: 143,
				1618: 144, 63731: 145, 64606: 146, 244: 147, 64607: 148, 64608: 149, 251: 150, 249: 151, 64609: 152, 64610: 153, 65535: 255, 1569: 165, 1570: 166, 1571: 167, 1572: 168, 1573: 169,
				1574: 170, 1575: 171, 1576: 172, 1577: 173, 171: 174, 187: 175, 1578: 224, 1579: 225, 1580: 226, 1581: 227, 1582: 228, 1583: 229, 1584: 230, 1585: 231, 1586: 232, 1587: 233,
				1588: 234, 1589: 235, 1590: 236, 1591: 237, 1592: 238, 1593: 239, 1594: 240, 1601: 241, 1602: 242, 1603: 243, 1604: 244, 1605: 245, 1606: 246, 1607: 247, 1608: 248, 1609: 249,
				1610: 250, 1600: 251, 8718: 254,
			},
		}
	case 0x1fc: // 508
		return &StringConverter{
			LangID:    508,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 233, 226, 160, 224, 231, 234, 235, 232, 239, 238, 65535, 65535, 65535, 65535,
				65535, 1617, 1618, 244, 164, 1600, 251, 249, 1569, 1570, 1571, 1572, 163, 1573, 1574, 1575,
				1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 171, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				1590, 1591, 1592, 1593, 1594, 1601, 956, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610,
				65535, 1611, 1612, 1613, 1614, 1615, 1616, 65535, 176, 65535, 65535, 65535, 65535, 178, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 233: 130, 226: 131, 160: 132, 224: 133, 231: 134, 234: 135, 235: 136, 232: 137, 239: 138, 238: 139, 1617: 145, 1618: 146, 244: 147, 164: 148, 1600: 149,
				251: 150, 249: 151, 1569: 152, 1570: 153, 1571: 154, 1572: 155, 163: 156, 1573: 157, 1574: 158, 1575: 159, 1576: 160, 1577: 161, 1578: 162, 1579: 163, 1580: 164, 1581: 165,
				1582: 166, 1583: 167, 1584: 168, 1585: 169, 1586: 170, 1587: 171, 1588: 172, 1589: 173, 171: 174, 187: 175, 1590: 224, 1591: 225, 1592: 226, 1593: 227, 1594: 228, 1601: 229,
				956: 230, 1602: 231, 1603: 232, 1604: 233, 1605: 234, 1606: 235, 1607: 236, 1608: 237, 1609: 238, 1610: 239, 1611: 241, 1612: 242, 1613: 243, 1614: 244, 1615: 245, 1616: 246,
				176: 248, 178: 253, 8718: 254,
			},
		}
	case 0x1fd: // 509
		return &StringConverter{
			LangID:    509,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 1600, 1617, 1618, 1614, 64608, 1611, 63731, 1615, 64609, 1612, 64606, 1616, 64610, 1613, 64607,
				65535, 1569, 1570, 1571, 1572, 1573, 1574, 65535, 1575, 1576, 65535, 1577, 1578, 65535, 1579, 1580,
				65535, 1581, 1582, 65535, 1583, 65535, 1584, 1585, 65535, 1586, 65535, 1587, 1588, 1589, 1590, 1591,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				1592, 1593, 1594, 65535, 1601, 65535, 1602, 1603, 65535, 65535, 1604, 65269, 65271, 65273, 65275, 1605,
				1606, 65535, 65535, 1607, 1608, 65535, 1609, 65535, 1610, 247, 215, 65535, 171, 187, 65535, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 254, 1600: 129, 1617: 130, 1618: 131, 1614: 132, 64608: 133, 1611: 134, 63731: 135, 1615: 136, 64609: 137, 1612: 138, 64606: 139, 1616: 140, 64610: 141, 1613: 142, 64607: 143,
				1569: 145, 1570: 146, 1571: 147, 1572: 148, 1573: 149, 1574: 150, 1575: 152, 1576: 153, 1577: 155, 1578: 156, 1579: 158, 1580: 159, 1581: 161, 1582: 162, 1583: 164, 1584: 166,
				1585: 167, 1586: 169, 1587: 171, 1588: 172, 1589: 173, 1590: 174, 1591: 175, 1592: 224, 1593: 225, 1594: 226, 1601: 228, 1602: 230, 1603: 231, 1604: 234, 65269: 235, 65271: 236,
				65273: 237, 65275: 238, 1605: 239, 1606: 240, 1607: 243, 1608: 244, 1609: 246, 1610: 248, 247: 249, 215: 250, 171: 252, 187: 253, 160: 255,
			},
		}
	case 0x1ff: // 511
		return &StringConverter{
			LangID:    511,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 233, 226, 65535, 224, 65535, 231, 234, 235, 232, 239, 238, 65535, 65535, 160,
				65535, 65535, 65535, 244, 164, 1618, 251, 249, 1617, 1614, 64608, 1611, 63731, 1615, 64609, 1612,
				64606, 1616, 64610, 1613, 64607, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 171, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593,
				1594, 1600, 1601, 1602, 1603, 1604, 1605, 65535, 1606, 1607, 65535, 1608, 1609, 1610, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 233: 130, 226: 131, 224: 133, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 160: 143, 244: 147, 164: 148, 1618: 149, 251: 150, 249: 151,
				1617: 152, 1614: 153, 64608: 154, 1611: 155, 63731: 156, 1615: 157, 64609: 158, 1612: 159, 64606: 160, 1616: 161, 64610: 162, 1613: 163, 64607: 164, 1569: 165, 1570: 166, 1571: 167,
				1572: 168, 1573: 169, 1574: 170, 1575: 171, 1576: 172, 1577: 173, 171: 174, 187: 175, 1578: 224, 1579: 225, 1580: 226, 1581: 227, 1582: 228, 1583: 229, 1584: 230, 1585: 231,
				1586: 232, 1587: 233, 1588: 234, 1589: 235, 1590: 236, 1591: 237, 1592: 238, 1593: 239, 1594: 240, 1600: 241, 1601: 242, 1602: 243, 1603: 244, 1604: 245, 1605: 246, 1606: 248,
				1607: 249, 1608: 251, 1609: 252, 1610: 253, 8718: 254,
			},
		}
	case 0x202: // 514
		return &StringConverter{
			LangID:    514,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				63713, 63712, 63711, 63710, 63709, 1642, 63675, 63707, 63705, 63706, 63704, 63703, 1548, 63701, 63700, 63699,
				1632, 1633, 1634, 1635, 1636, 1637, 1638, 1639, 1640, 1641, 63688, 1563, 63686, 63685, 63684, 1567,
				63673, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583,
				1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 63683, 63682, 63681, 63680, 63679,
				1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 1611, 1612, 1613, 1614, 1615,
				1616, 1617, 1618, 65535, 65535, 65535, 64608, 64609, 64610, 65535, 65535, 63678, 63677, 63676, 63672, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 63713: 160, 63712: 161, 63711: 162, 63710: 163, 63709: 164, 1642: 165, 63675: 166, 63707: 167, 63705: 168, 63706: 169, 63704: 170, 63703: 171, 1548: 172, 63701: 173, 63700: 174,
				63699: 175, 1632: 176, 1633: 177, 1634: 178, 1635: 179, 1636: 180, 1637: 181, 1638: 182, 1639: 183, 1640: 184, 1641: 185, 63688: 186, 1563: 187, 63686: 188, 63685: 189, 63684: 190,
				1567: 191, 63673: 192, 1569: 193, 1570: 194, 1571: 195, 1572: 196, 1573: 197, 1574: 198, 1575: 199, 1576: 200, 1577: 201, 1578: 202, 1579: 203, 1580: 204, 1581: 205, 1582: 206,
				1583: 207, 1584: 208, 1585: 209, 1586: 210, 1587: 211, 1588: 212, 1589: 213, 1590: 214, 1591: 215, 1592: 216, 1593: 217, 1594: 218, 63683: 219, 63682: 220, 63681: 221, 63680: 222,
				63679: 223, 1600: 224, 1601: 225, 1602: 226, 1603: 227, 1604: 228, 1605: 229, 1606: 230, 1607: 231, 1608: 232, 1609: 233, 1610: 234, 1611: 235, 1612: 236, 1613: 237, 1614: 238,
				1615: 239, 1616: 240, 1617: 241, 1618: 242, 64608: 246, 64609: 247, 64610: 248, 63678: 251, 63677: 252, 63676: 253, 63672: 254,
			},
		}
	case 0x22a: // 554
		return &StringConverter{
			LangID:    554,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 160, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 1618, 1617, 1614, 65535, 1611, 65535, 1615, 65535, 1612,
				65535, 1616, 65535, 1613, 65535, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 171, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593,
				1594, 1600, 1601, 1602, 1603, 1604, 1605, 65535, 1606, 1607, 65535, 1608, 1609, 1610, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 160: 131, 1618: 151, 1617: 152, 1614: 153, 1611: 155, 1615: 157, 1612: 159, 1616: 161, 1613: 163, 1569: 165, 1570: 166, 1571: 167, 1572: 168, 1573: 169, 1574: 170,
				1575: 171, 1576: 172, 1577: 173, 171: 174, 187: 175, 1578: 224, 1579: 225, 1580: 226, 1581: 227, 1582: 228, 1583: 229, 1584: 230, 1585: 231, 1586: 232, 1587: 233, 1588: 234,
				1589: 235, 1590: 236, 1591: 237, 1592: 238, 1593: 239, 1594: 240, 1600: 241, 1601: 242, 1602: 243, 1603: 244, 1604: 245, 1605: 246, 1606: 248, 1607: 249, 1608: 251, 1609: 252,
				1610: 253, 8718: 254,
			},
		}
	case 0x22b: // 555
		return &StringConverter{
			LangID:    555,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 233, 226, 65535, 224, 65535, 231, 234, 235, 232, 239, 238, 65535, 65535, 65535,
				65535, 65535, 65535, 244, 65535, 65535, 251, 249, 65535, 65535, 65535, 65535, 65535, 1611, 1612, 1613,
				1614, 1615, 1616, 1617, 1618, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 65535, 160,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593,
				1594, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 176, 1608, 1609, 1610, 1600, 65535, 65535, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 233: 130, 226: 131, 224: 133, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 244: 147, 251: 150, 249: 151, 1611: 157, 1612: 158, 1613: 159,
				1614: 160, 1615: 161, 1616: 162, 1617: 163, 1618: 164, 1569: 165, 1570: 166, 1571: 167, 1572: 168, 1573: 169, 1574: 170, 1575: 171, 1576: 172, 1577: 173, 160: 175, 1578: 224,
				1579: 225, 1580: 226, 1581: 227, 1582: 228, 1583: 229, 1584: 230, 1585: 231, 1586: 232, 1587: 233, 1588: 234, 1589: 235, 1590: 236, 1591: 237, 1592: 238, 1593: 239, 1594: 240,
				1601: 241, 1602: 242, 1603: 243, 1604: 244, 1605: 245, 1606: 246, 1607: 247, 176: 248, 1608: 249, 1609: 250, 1610: 251, 1600: 252,
			},
		}
	case 0x22c: // 556
		return &StringConverter{
			LangID:    556,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 65535, 1579, 1580, 65535, 1581, 1582,
				1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1601, 1602, 1603, 1604,
				1605, 1606, 1607, 1608, 1609, 1610, 1600, 1548, 1563, 1567, 65535, 65535, 65535, 65535, 171, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 160, 65535, 65535, 65535, 65535, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1569: 128, 1570: 129, 1571: 130, 1572: 131, 1573: 132, 1574: 133, 1575: 134, 1576: 135, 1577: 136, 1578: 137, 65535: 255, 1579: 139, 1580: 140, 1581: 142, 1582: 143, 1583: 144,
				1584: 145, 1585: 146, 1586: 147, 1587: 148, 1588: 149, 1589: 150, 1590: 151, 1591: 152, 1592: 153, 1593: 154, 1594: 155, 1601: 156, 1602: 157, 1603: 158, 1604: 159, 1605: 160,
				1606: 161, 1607: 162, 1608: 163, 1609: 164, 1610: 165, 1600: 166, 1548: 167, 1563: 168, 1567: 169, 171: 174, 187: 175, 160: 249, 8718: 254,
			},
		}
	case 0x22d: // 557
		return &StringConverter{
			LangID:    557,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1611, 1612, 233, 226, 1613, 224, 1614, 231, 234, 235, 232, 239, 238, 1615, 1616, 1617,
				1618, 65535, 65535, 244, 65535, 65535, 251, 249, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 171, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593,
				1594, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 1600, 65535, 65535, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1611: 128, 1612: 129, 233: 130, 226: 131, 1613: 132, 224: 133, 1614: 134, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 1615: 141, 1616: 142, 1617: 143,
				1618: 144, 65535: 255, 244: 147, 251: 150, 249: 151, 1569: 165, 1570: 166, 1571: 167, 1572: 168, 1573: 169, 1574: 170, 1575: 171, 1576: 172, 1577: 173, 171: 174, 187: 175,
				1578: 224, 1579: 225, 1580: 226, 1581: 227, 1582: 228, 1583: 229, 1584: 230, 1585: 231, 1586: 232, 1587: 233, 1588: 234, 1589: 235, 1590: 236, 1591: 237, 1592: 238, 1593: 239,
				1594: 240, 1601: 241, 1602: 242, 1603: 243, 1604: 244, 1605: 245, 1606: 246, 1607: 247, 1608: 248, 1609: 249, 1610: 250, 1600: 251, 8718: 254,
			},
		}
	case 0x22e: // 558
		return &StringConverter{
			LangID:    558,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 233, 226, 65535, 224, 65535, 231, 234, 235, 232, 239, 238, 65535, 65535, 65535,
				65535, 1617, 1618, 244, 164, 1600, 251, 249, 1569, 1570, 1571, 1572, 163, 1573, 1574, 1575,
				1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 171, 187,
				9617, 9618, 9619, 9474, 9508, 9569, 9570, 9558, 9557, 9571, 9553, 9559, 9565, 9564, 9563, 9488,
				9492, 9524, 9516, 9500, 9472, 9532, 9566, 9567, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 9575,
				9576, 9572, 9573, 9561, 9560, 9554, 9555, 9579, 9578, 9496, 9484, 9608, 9604, 9612, 9616, 9600,
				1590, 1591, 1592, 1593, 1594, 1601, 181, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610,
				8801, 1611, 1612, 1613, 1614, 1615, 1616, 8776, 176, 8729, 183, 8730, 8319, 178, 9632, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 144, 233: 130, 226: 131, 224: 133, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 1617: 145, 1618: 146, 244: 147, 164: 148, 1600: 149, 251: 150,
				249: 151, 1569: 152, 1570: 153, 1571: 154, 1572: 155, 163: 156, 1573: 157, 1574: 158, 1575: 159, 1576: 160, 1577: 161, 1578: 162, 1579: 163, 1580: 164, 1581: 165, 1582: 166,
				1583: 167, 1584: 168, 1585: 169, 1586: 170, 1587: 171, 1588: 172, 1589: 173, 171: 174, 187: 175, 9617: 176, 9618: 177, 9619: 178, 9474: 179, 9508: 180, 9569: 181, 9570: 182,
				9558: 183, 9557: 184, 9571: 185, 9553: 186, 9559: 187, 9565: 188, 9564: 189, 9563: 190, 9488: 191, 9492: 192, 9524: 193, 9516: 194, 9500: 195, 9472: 196, 9532: 197, 9566: 198,
				9567: 199, 9562: 200, 9556: 201, 9577: 202, 9574: 203, 9568: 204, 9552: 205, 9580: 206, 9575: 207, 9576: 208, 9572: 209, 9573: 210, 9561: 211, 9560: 212, 9554: 213, 9555: 214,
				9579: 215, 9578: 216, 9496: 217, 9484: 218, 9608: 219, 9604: 220, 9612: 221, 9616: 222, 9600: 223, 1590: 224, 1591: 225, 1592: 226, 1593: 227, 1594: 228, 1601: 229, 181: 230,
				1602: 231, 1603: 232, 1604: 233, 1605: 234, 1606: 235, 1607: 236, 1608: 237, 1609: 238, 1610: 239, 8801: 240, 1611: 241, 1612: 242, 1613: 243, 1614: 244, 1615: 245, 1616: 246,
				8776: 247, 176: 248, 8729: 249, 183: 250, 8730: 251, 8319: 252, 178: 253, 9632: 254, 160: 255,
			},
		}
	case 0x22f: // 559
		return &StringConverter{
			LangID:    559,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 1600, 1617, 1618, 1614, 65535, 1611, 65535, 1615, 65535, 1612, 65535, 1616, 65535, 1613, 65535,
				65535, 1569, 1570, 1571, 1572, 1573, 1574, 65535, 1575, 1576, 65535, 1577, 1578, 65535, 1579, 1580,
				65535, 1581, 1582, 65535, 1583, 65535, 1584, 1585, 65535, 1586, 65535, 1587, 1588, 1589, 1590, 1591,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				1592, 1593, 1594, 65535, 1601, 65535, 1602, 1603, 65535, 65535, 1604, 65535, 65535, 65535, 65535, 1605,
				1606, 65535, 65535, 1607, 1608, 65535, 1609, 65535, 1610, 247, 215, 65535, 171, 187, 65535, 160,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 254, 1600: 129, 1617: 130, 1618: 131, 1614: 132, 1611: 134, 1615: 136, 1612: 138, 1616: 140, 1613: 142, 1569: 145, 1570: 146, 1571: 147, 1572: 148, 1573: 149, 1574: 150,
				1575: 152, 1576: 153, 1577: 155, 1578: 156, 1579: 158, 1580: 159, 1581: 161, 1582: 162, 1583: 164, 1584: 166, 1585: 167, 1586: 169, 1587: 171, 1588: 172, 1589: 173, 1590: 174,
				1591: 175, 1592: 224, 1593: 225, 1594: 226, 1601: 228, 1602: 230, 1603: 231, 1604: 234, 1605: 239, 1606: 240, 1607: 243, 1608: 244, 1609: 246, 1610: 248, 247: 249, 215: 250,
				171: 252, 187: 253, 160: 255,
			},
		}
	case 0x230: // 560
		return &StringConverter{
			LangID:    560,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				8364, 1662, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 1657, 8249, 338, 1670, 1688, 1672,
				1711, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 1705, 8482, 1681, 8250, 339, 8204, 8205, 1722,
				160, 1548, 162, 163, 164, 165, 166, 167, 168, 169, 1726, 171, 172, 173, 174, 175,
				176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 1563, 187, 188, 189, 190, 1567,
				1729, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583,
				1584, 1585, 1586, 1587, 1588, 1589, 1590, 215, 1591, 1592, 1593, 1594, 1600, 1601, 1602, 1603,
				224, 1604, 226, 1605, 1606, 1607, 1608, 231, 232, 233, 234, 235, 1609, 1610, 238, 239,
				1611, 1612, 1613, 1614, 244, 1615, 1616, 247, 1617, 249, 1618, 251, 252, 8206, 8207, 1746,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				8364: 128, 1662: 129, 8218: 130, 402: 131, 8222: 132, 8230: 133, 8224: 134, 8225: 135, 710: 136, 8240: 137, 1657: 138, 8249: 139, 338: 140, 1670: 141, 1688: 142, 1672: 143,
				1711: 144, 8216: 145, 8217: 146, 8220: 147, 8221: 148, 8226: 149, 8211: 150, 8212: 151, 1705: 152, 8482: 153, 1681: 154, 8250: 155, 339: 156, 8204: 157, 8205: 158, 1722: 159,
				160: 160, 1548: 161, 162: 162, 163: 163, 164: 164, 165: 165, 166: 166, 167: 167, 168: 168, 169: 169, 1726: 170, 171: 171, 172: 172, 173: 173, 174: 174, 175: 175,
				176: 176, 177: 177, 178: 178, 179: 179, 180: 180, 181: 181, 182: 182, 183: 183, 184: 184, 185: 185, 1563: 186, 187: 187, 188: 188, 189: 189, 190: 190, 1567: 191,
				1729: 192, 1569: 193, 1570: 194, 1571: 195, 1572: 196, 1573: 197, 1574: 198, 1575: 199, 1576: 200, 1577: 201, 1578: 202, 1579: 203, 1580: 204, 1581: 205, 1582: 206, 1583: 207,
				1584: 208, 1585: 209, 1586: 210, 1587: 211, 1588: 212, 1589: 213, 1590: 214, 215: 215, 1591: 216, 1592: 217, 1593: 218, 1594: 219, 1600: 220, 1601: 221, 1602: 222, 1603: 223,
				224: 224, 1604: 225, 226: 226, 1605: 227, 1606: 228, 1607: 229, 1608: 230, 231: 231, 232: 232, 233: 233, 234: 234, 235: 235, 1609: 236, 1610: 237, 238: 238, 239: 239,
				1611: 240, 1612: 241, 1613: 242, 1614: 243, 244: 244, 1615: 245, 1616: 246, 247: 247, 1617: 248, 249: 249, 1618: 250, 251: 251, 252: 252, 8206: 253, 8207: 254, 1746: 255,
				192: 65, 194: 65, 199: 67, 200: 69, 201: 69, 202: 69, 203: 69, 206: 73, 207: 73, 212: 79, 217: 85, 219: 85, 220: 85, 401: 70, 1740: 237, 64342: 129,
				64343: 129, 64344: 129, 64345: 129, 64358: 138, 64359: 138, 64360: 138, 64361: 138, 64378: 141, 64379: 141, 64380: 141, 64381: 141, 64392: 143, 64393: 143, 64394: 142, 64395: 142, 64396: 154,
				64397: 154, 64398: 152, 64399: 152, 64400: 152, 64401: 152, 64402: 144, 64403: 144, 64404: 144, 64405: 144, 64414: 159, 64415: 159, 64422: 192, 64423: 192, 64424: 192, 64425: 192, 64426: 170,
				64427: 170, 64428: 170, 64429: 170, 64430: 255, 64431: 255, 65136: 240, 65137: 240, 65138: 241, 65140: 242, 65142: 243, 65143: 243, 65144: 245, 65145: 245, 65146: 246, 65147: 246, 65148: 248,
				65149: 248, 65150: 250, 65151: 250, 65152: 193, 65153: 194, 65154: 194, 65155: 195, 65156: 195, 65157: 196, 65158: 196, 65159: 197, 65160: 197, 65161: 198, 65162: 198, 65163: 198, 65164: 198,
				65165: 199, 65166: 199, 65167: 200, 65168: 200, 65169: 200, 65170: 200, 65171: 201, 65172: 201, 65173: 202, 65174: 202, 65175: 202, 65176: 202, 65177: 203, 65178: 203, 65179: 203, 65180: 203,
				65181: 204, 65182: 204, 65183: 204, 65184: 204, 65185: 205, 65186: 205, 65187: 205, 65188: 205, 65189: 206, 65190: 206, 65191: 206, 65192: 206, 65193: 207, 65194: 207, 65195: 208, 65196: 208,
				65197: 209, 65198: 209, 65199: 210, 65200: 210, 65201: 211, 65202: 211, 65203: 211, 65204: 211, 65205: 212, 65206: 212, 65207: 212, 65208: 212, 65209: 213, 65210: 213, 65211: 213, 65212: 213,
				65213: 214, 65214: 214, 65215: 214, 65216: 214, 65217: 216, 65218: 216, 65219: 216, 65220: 216, 65221: 217, 65222: 217, 65223: 217, 65224: 217, 65225: 218, 65226: 218, 65227: 218, 65228: 218,
				65229: 219, 65230: 219, 65231: 219, 65232: 219, 65233: 221, 65234: 221, 65235: 221, 65236: 221, 65237: 222, 65238: 222, 65239: 222, 65240: 222, 65241: 223, 65242: 223, 65243: 223, 65244: 223,
				65245: 225, 65246: 225, 65247: 225, 65248: 225, 65249: 227, 65250: 227, 65251: 227, 65252: 227, 65253: 228, 65254: 228, 65255: 228, 65256: 228, 65257: 229, 65258: 229, 65259: 229, 65260: 229,
				65261: 230, 65262: 230, 65263: 236, 65264: 236, 65265: 237, 65266: 237, 65267: 237, 65268: 237, 65281: 33, 65282: 34, 65283: 35, 65284: 36, 65285: 37, 65286: 38, 65287: 39, 65288: 40,
				65289: 41, 65290: 42, 65291: 43, 65292: 44, 65293: 45, 65294: 46, 65295: 47, 65296: 48, 65297: 49, 65298: 50, 65299: 51, 65300: 52, 65301: 53, 65302: 54, 65303: 55, 65304: 56,
				65305: 57, 65306: 58, 65307: 59, 65308: 60, 65309: 61, 65310: 62, 65312: 64, 65313: 65, 65314: 66, 65315: 67, 65316: 68, 65317: 69, 65318: 70, 65319: 71, 65320: 72, 65321: 73,
				65322: 74, 65323: 75, 65324: 76, 65325: 77, 65326: 78, 65327: 79, 65328: 80, 65329: 81, 65330: 82, 65331: 83, 65332: 84, 65333: 85, 65334: 86, 65335: 87, 65336: 88, 65337: 89,
				65338: 90, 65339: 91, 65340: 92, 65341: 93, 65342: 94, 65343: 95, 65344: 96, 65345: 97, 65346: 98, 65347: 99, 65348: 100, 65349: 101, 65350: 102, 65351: 103, 65352: 104, 65353: 105,
				65354: 106, 65355: 107, 65356: 108, 65357: 109, 65358: 110, 65359: 111, 65360: 112, 65361: 113, 65362: 114, 65363: 115, 65364: 116, 65365: 117, 65366: 118, 65367: 119, 65368: 120, 65369: 121,
				65370: 122, 65371: 123, 65372: 124, 65373: 125, 65374: 126,
			},
		}
	case 0x231: // 561
		return &StringConverter{
			LangID:    561,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 233, 226, 65535, 224, 65535, 231, 234, 235, 232, 239, 238, 65535, 65535, 160,
				65535, 65535, 65535, 244, 164, 1618, 251, 249, 1617, 1614, 65535, 1611, 65535, 1615, 65535, 1612,
				65535, 1616, 65535, 1613, 65535, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 171, 187,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593,
				1594, 1600, 1601, 1602, 1603, 1604, 1605, 65535, 1606, 1607, 65535, 1608, 1609, 1610, 8718, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				65535: 255, 233: 130, 226: 131, 224: 133, 231: 135, 234: 136, 235: 137, 232: 138, 239: 139, 238: 140, 160: 143, 244: 147, 164: 148, 1618: 149, 251: 150, 249: 151,
				1617: 152, 1614: 153, 1611: 155, 1615: 157, 1612: 159, 1616: 161, 1613: 163, 1569: 165, 1570: 166, 1571: 167, 1572: 168, 1573: 169, 1574: 170, 1575: 171, 1576: 172, 1577: 173,
				171: 174, 187: 175, 1578: 224, 1579: 225, 1580: 226, 1581: 227, 1582: 228, 1583: 229, 1584: 230, 1585: 231, 1586: 232, 1587: 233, 1588: 234, 1589: 235, 1590: 236, 1591: 237,
				1592: 238, 1593: 239, 1594: 240, 1600: 241, 1601: 242, 1602: 243, 1603: 244, 1604: 245, 1605: 246, 1606: 248, 1607: 249, 1608: 251, 1609: 252, 1610: 253, 8718: 254,
			},
		}
	case 0x233: // 563
		return &StringConverter{
			LangID:    563,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				1611, 1612, 1613, 1614, 1615, 1616, 1617, 1618, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576,
				1577, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592,
				160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 65535, 171, 172, 173, 174, 175,
				176, 177, 178, 179, 180, 956, 182, 8718, 184, 185, 65535, 187, 65535, 65535, 65535, 191,
				1593, 1594, 1601, 1602, 1603, 197, 198, 199, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 1600,
				272, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 946,
				224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
				273, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				1611: 128, 1612: 129, 1613: 130, 1614: 131, 1615: 132, 1616: 133, 1617: 134, 1618: 135, 1569: 136, 1570: 137, 1571: 138, 1572: 139, 1573: 140, 1574: 141, 1575: 142, 1576: 143,
				1577: 144, 1578: 145, 1579: 146, 1580: 147, 1581: 148, 1582: 149, 1583: 150, 1584: 151, 1585: 152, 1586: 153, 1587: 154, 1588: 155, 1589: 156, 1590: 157, 1591: 158, 1592: 159,
				160: 160, 161: 161, 162: 162, 163: 163, 164: 164, 165: 165, 166: 166, 167: 167, 168: 168, 169: 169, 65535: 190, 171: 171, 172: 172, 173: 173, 174: 174, 175: 175,
				176: 176, 177: 177, 178: 178, 179: 179, 180: 180, 956: 181, 182: 182, 8718: 183, 184: 184, 185: 185, 187: 187, 191: 191, 1593: 192, 1594: 193, 1601: 194, 1602: 195,
				1603: 196, 197: 197, 198: 198, 199: 199, 1604: 200, 1605: 201, 1606: 202, 1607: 203, 1608: 204, 1609: 205, 1610: 206, 1600: 207, 272: 208, 209: 209, 210: 210, 211: 211,
				212: 212, 213: 213, 214: 214, 215: 215, 216: 216, 217: 217, 218: 218, 219: 219, 220: 220, 221: 221, 222: 222, 946: 223, 224: 224, 225: 225, 226: 226, 227: 227,
				228: 228, 229: 229, 230: 230, 231: 231, 232: 232, 233: 233, 234: 234, 235: 235, 236: 236, 237: 237, 238: 238, 239: 239, 273: 240, 241: 241, 242: 242, 243: 243,
				244: 244, 245: 245, 246: 246, 247: 247, 248: 248, 249: 249, 250: 250, 251: 251, 252: 252, 253: 253, 254: 254, 255: 255,
			},
		}
	case 0x235: // 565
		return &StringConverter{
			LangID:    565,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 12, 10, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 160, 199, 201, 209, 214, 220, 225, 224, 226, 228, 1722, 171, 231, 233, 232,
				234, 235, 8230, 236, 238, 239, 241, 243, 187, 244, 246, 247, 250, 249, 251, 252,
				63713, 63712, 63711, 63710, 63709, 1642, 63675, 63707, 63705, 63706, 215, 63703, 1548, 63701, 63700, 63699,
				1632, 1633, 1634, 1635, 1636, 1637, 1638, 1639, 1640, 1641, 63688, 1563, 63686, 63685, 63684, 1567,
				1645, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583,
				1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 63683, 63682, 63681, 63680, 63679,
				1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 1611, 1612, 1613, 1614, 1615,
				1616, 1617, 1618, 1662, 1657, 1670, 1749, 1700, 1711, 1672, 1681, 63678, 63677, 63676, 1688, 1746,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 13: 10, 11: 11, 12: 12, 10: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 160: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 1722: 139, 171: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 8230: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 187: 152, 244: 153, 246: 154, 247: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				63713: 160, 63712: 161, 63711: 162, 63710: 163, 63709: 164, 1642: 165, 63675: 166, 63707: 167, 63705: 168, 63706: 169, 215: 170, 63703: 171, 1548: 172, 63701: 173, 63700: 174, 63699: 175,
				1632: 176, 1633: 177, 1634: 178, 1635: 179, 1636: 180, 1637: 181, 1638: 182, 1639: 183, 1640: 184, 1641: 185, 63688: 186, 1563: 187, 63686: 188, 63685: 189, 63684: 190, 1567: 191,
				1645: 192, 1569: 193, 1570: 194, 1571: 195, 1572: 196, 1573: 197, 1574: 198, 1575: 199, 1576: 200, 1577: 201, 1578: 202, 1579: 203, 1580: 204, 1581: 205, 1582: 206, 1583: 207,
				1584: 208, 1585: 209, 1586: 210, 1587: 211, 1588: 212, 1589: 213, 1590: 214, 1591: 215, 1592: 216, 1593: 217, 1594: 218, 63683: 219, 63682: 220, 63681: 221, 63680: 222, 63679: 223,
				1600: 224, 1601: 225, 1602: 226, 1603: 227, 1604: 228, 1605: 229, 1606: 230, 1607: 231, 1608: 232, 1609: 233, 1610: 234, 1611: 235, 1612: 236, 1613: 237, 1614: 238, 1615: 239,
				1616: 240, 1617: 241, 1618: 242, 1662: 243, 1657: 244, 1670: 245, 1749: 246, 1700: 247, 1711: 248, 1672: 249, 1681: 250, 63678: 251, 63677: 252, 63676: 253, 1688: 254, 1746: 255,
			},
		}
	case 0x236: // 566
		return &StringConverter{
			LangID:    566,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 160, 199, 201, 209, 214, 220, 225, 224, 226, 228, 1722, 171, 231, 233, 232,
				234, 235, 8230, 236, 238, 239, 241, 243, 187, 244, 246, 247, 250, 249, 251, 252,
				63713, 63712, 63711, 63710, 63709, 1642, 63675, 63707, 63705, 63706, 215, 63703, 1548, 63701, 63700, 63699,
				1632, 1633, 1634, 1635, 1636, 1637, 1638, 1639, 1640, 1641, 63688, 1563, 63686, 63685, 63684, 1567,
				1645, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583,
				1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 63683, 63682, 63681, 63680, 63679,
				1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 1611, 1612, 1613, 1614, 1615,
				1616, 1617, 1618, 1662, 1657, 1670, 1749, 1700, 1711, 1672, 1681, 63678, 63677, 63676, 1688, 1746,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 160: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 1722: 139, 171: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 8230: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 187: 152, 244: 153, 246: 154, 247: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				63713: 160, 63712: 161, 63711: 162, 63710: 163, 63709: 164, 1642: 165, 63675: 166, 63707: 167, 63705: 168, 63706: 169, 215: 170, 63703: 171, 1548: 172, 63701: 173, 63700: 174, 63699: 175,
				1632: 176, 1633: 177, 1634: 178, 1635: 179, 1636: 180, 1637: 181, 1638: 182, 1639: 183, 1640: 184, 1641: 185, 63688: 186, 1563: 187, 63686: 188, 63685: 189, 63684: 190, 1567: 191,
				1645: 192, 1569: 193, 1570: 194, 1571: 195, 1572: 196, 1573: 197, 1574: 198, 1575: 199, 1576: 200, 1577: 201, 1578: 202, 1579: 203, 1580: 204, 1581: 205, 1582: 206, 1583: 207,
				1584: 208, 1585: 209, 1586: 210, 1587: 211, 1588: 212, 1589: 213, 1590: 214, 1591: 215, 1592: 216, 1593: 217, 1594: 218, 63683: 219, 63682: 220, 63681: 221, 63680: 222, 63679: 223,
				1600: 224, 1601: 225, 1602: 226, 1603: 227, 1604: 228, 1605: 229, 1606: 230, 1607: 231, 1608: 232, 1609: 233, 1610: 234, 1611: 235, 1612: 236, 1613: 237, 1614: 238, 1615: 239,
				1616: 240, 1617: 241, 1618: 242, 1662: 243, 1657: 244, 1670: 245, 1749: 246, 1700: 247, 1711: 248, 1672: 249, 1681: 250, 63678: 251, 63677: 252, 63676: 253, 1688: 254, 1746: 255,
			},
		}
	case 0x237: // 567
		return &StringConverter{
			LangID:    567,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 12, 10, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				196, 160, 199, 201, 209, 214, 220, 225, 224, 226, 228, 1722, 171, 231, 233, 232,
				234, 235, 8230, 236, 238, 239, 241, 243, 187, 244, 246, 247, 250, 249, 251, 252,
				63713, 63712, 63711, 63710, 63709, 1642, 63675, 63707, 63705, 63706, 215, 63703, 1548, 63701, 63700, 63699,
				1632, 1633, 1634, 1635, 1636, 1637, 1638, 1639, 1640, 1641, 63688, 1563, 63686, 63685, 63684, 1567,
				1645, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583,
				1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 63683, 63682, 63681, 63680, 63679,
				1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 1611, 1612, 1613, 1614, 1615,
				1616, 1617, 1618, 1662, 1657, 1670, 1749, 1700, 1711, 1672, 1681, 63678, 63677, 63676, 1688, 1746,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 13: 10, 11: 11, 12: 12, 10: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				196: 128, 160: 129, 199: 130, 201: 131, 209: 132, 214: 133, 220: 134, 225: 135, 224: 136, 226: 137, 228: 138, 1722: 139, 171: 140, 231: 141, 233: 142, 232: 143,
				234: 144, 235: 145, 8230: 146, 236: 147, 238: 148, 239: 149, 241: 150, 243: 151, 187: 152, 244: 153, 246: 154, 247: 155, 250: 156, 249: 157, 251: 158, 252: 159,
				63713: 160, 63712: 161, 63711: 162, 63710: 163, 63709: 164, 1642: 165, 63675: 166, 63707: 167, 63705: 168, 63706: 169, 215: 170, 63703: 171, 1548: 172, 63701: 173, 63700: 174, 63699: 175,
				1632: 176, 1633: 177, 1634: 178, 1635: 179, 1636: 180, 1637: 181, 1638: 182, 1639: 183, 1640: 184, 1641: 185, 63688: 186, 1563: 187, 63686: 188, 63685: 189, 63684: 190, 1567: 191,
				1645: 192, 1569: 193, 1570: 194, 1571: 195, 1572: 196, 1573: 197, 1574: 198, 1575: 199, 1576: 200, 1577: 201, 1578: 202, 1579: 203, 1580: 204, 1581: 205, 1582: 206, 1583: 207,
				1584: 208, 1585: 209, 1586: 210, 1587: 211, 1588: 212, 1589: 213, 1590: 214, 1591: 215, 1592: 216, 1593: 217, 1594: 218, 63683: 219, 63682: 220, 63681: 221, 63680: 222, 63679: 223,
				1600: 224, 1601: 225, 1602: 226, 1603: 227, 1604: 228, 1605: 229, 1606: 230, 1607: 231, 1608: 232, 1609: 233, 1610: 234, 1611: 235, 1612: 236, 1613: 237, 1614: 238, 1615: 239,
				1616: 240, 1617: 241, 1618: 242, 1662: 243, 1657: 244, 1670: 245, 1749: 246, 1700: 247, 1711: 248, 1672: 249, 1681: 250, 63678: 251, 63677: 252, 63676: 253, 1688: 254, 1746: 255,
			},
		}
	case 0x24E: // 590
		return &StringConverter{
			LangID:    590,
			CharWidth: 1,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				160, 161, 162, 163, 65535, 165, 65535, 167, 164, 8216, 8220, 171, 8592, 8593, 8594, 8595,
				176, 177, 178, 179, 215, 181, 182, 183, 247, 8217, 8221, 187, 188, 189, 190, 191,
				65535, 768, 180, 710, 126, 713, 728, 729, 168, 65535, 730, 184, 65535, 733, 731, 711,
				8213, 185, 174, 169, 8482, 9834, 166, 65535, 65535, 65535, 65535, 65535, 8539, 8540, 8541, 8542,
				8486, 198, 272, 170, 294, 65535, 306, 319, 321, 216, 338, 186, 222, 358, 330, 329,
				312, 230, 273, 240, 295, 305, 307, 320, 322, 248, 339, 223, 254, 359, 331, 173,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 196, 127: 127,
				65535: 229, 160: 160, 161: 161, 162: 162, 163: 163, 165: 165, 167: 167, 164: 168, 8216: 169, 8220: 170, 171: 171, 8592: 172, 8593: 173, 8594: 174, 8595: 175, 176: 176,
				177: 177, 178: 178, 179: 179, 215: 180, 181: 181, 182: 182, 183: 183, 247: 184, 8217: 185, 8221: 186, 187: 187, 188: 188, 189: 189, 190: 190, 191: 191, 768: 193,
				180: 194, 710: 195, 713: 197, 728: 198, 729: 199, 168: 200, 730: 202, 184: 203, 733: 205, 731: 206, 711: 207, 8213: 208, 185: 209, 174: 210, 169: 211, 8482: 212,
				9834: 213, 166: 214, 8539: 220, 8540: 221, 8541: 222, 8542: 223, 8486: 224, 198: 225, 272: 226, 170: 227, 294: 228, 306: 230, 319: 231, 321: 232, 216: 233, 338: 234,
				186: 235, 222: 236, 358: 237, 330: 238, 329: 239, 312: 240, 230: 241, 273: 242, 240: 243, 295: 244, 305: 245, 307: 246, 320: 247, 322: 248, 248: 249, 339: 250,
				223: 251, 254: 252, 359: 253, 331: 254, 173: 255,
			},
		}
	case 0x33D: // 829
		return &StringConverter{
			LangID:    829,
			CharWidth: 2,
			eReplace:  65533,
			dReplace:  63,
			dBuffer: []int{
				256, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 384, 639, 894, 1145, 1389, 1636, 1853, 2095, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				2288, 2543, 2798, 3053, 3308, 3563, 3818, 4073, 4328, 4583, 4838, 5093, 5348, 5603, 5858, 6113,
				6368, 6623, 6878, 7133, 7388, 7643, 7898, 8153, 8408, 8663, 8918, 9173, 9428, 9683, 9938, 10193,
				10405, 10660, 10915, 11170, 11425, 11680, 11935, 12190, 12445, 12700, 12955, 13210, 13465, 13720, 13975, 14230,
				14485, 14740, 14995, 15250, 15505, 15760, 16015, 16270, 16525, 16780, 17035, 17290, 17545, 17800, 18055, 18310,
				18565, 18820, 19075, 19330, 19585, 19840, 20095, 20350, 20605, 20860, 21115, 21370, 21625, 21880, 22135, 65535,
			},
			dBuffer2: []int{
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
				16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
				32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
				48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
				64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
				80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
				96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
				112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 12288, 12289, 12290, 65292, 65294, 12539, 65306, 65307, 65311, 65281, 12443, 12444, 180, 65344, 168,
				65342, 8254, 65343, 12541, 12542, 12445, 12446, 12291, 20189, 12293, 12294, 12295, 12540, 8213, 173, 65295,
				65340, 65374, 8741, 65372, 8230, 8229, 8216, 8217, 8220, 8221, 65288, 65289, 12308, 12309, 65339, 65341,
				65371, 65373, 12296, 12297, 12298, 12299, 12300, 12301, 12302, 12303, 12304, 12305, 65291, 65293, 177, 215,
				247, 65309, 8800, 65308, 65310, 8804, 8805, 8734, 8756, 9794, 9792, 176, 8242, 8243, 8451, 165,
				65284, 162, 163, 65285, 65283, 65286, 65290, 65312, 167, 9734, 9733, 9675, 9679, 9678, 9671, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				9670, 9633, 9632, 9651, 9650, 9661, 9660, 8251, 12306, 8594, 8592, 8593, 8595, 12307, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 8712, 8715, 8838, 8839, 8834, 8835, 8746,
				8745, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 8743, 8744, 172, 8658, 8660, 8704, 8707,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 8736, 8869, 8256, 8706, 8711,
				8801, 8786, 8810, 8811, 8730, 8780, 8733, 8757, 8747, 8748, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 8491, 8240, 9839, 9837, 9834, 8224, 8225, 182, 65535, 65535, 65535, 65535, 8413, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65296, 65297,
				65298, 65299, 65300, 65301, 65302, 65303, 65304, 65305, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65313,
				65314, 65315, 65316, 65317, 65318, 65319, 65320, 65321, 65322, 65323, 65324, 65325, 65326, 65327, 65328, 65329,
				65330, 65331, 65332, 65333, 65334, 65335, 65336, 65337, 65338, 65535, 65535, 65535, 65535, 65535, 65535, 65345,
				65346, 65347, 65348, 65349, 65350, 65351, 65352, 65353, 65354, 65355, 65356, 65357, 65358, 65359, 65360, 65361,
				65362, 65363, 65364, 65365, 65366, 65367, 65368, 65369, 65370, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 12353, 12354, 12355, 12356, 12357, 12358,
				12359, 12360, 12361, 12362, 12363, 12364, 12365, 12366, 12367, 12368, 12369, 12370, 12371, 12372, 12373, 12374,
				12375, 12376, 12377, 12378, 12379, 12380, 12381, 12382, 12383, 12384, 12385, 12386, 12387, 12388, 12389, 12390,
				12391, 12392, 12393, 12394, 12395, 12396, 12397, 12398, 12399, 12400, 12401, 12402, 12403, 12404, 12405, 12406,
				12407, 12408, 12409, 12410, 12411, 12412, 12413, 12414, 12415, 12416, 12417, 12418, 12419, 12420, 12421, 12422,
				12423, 12424, 12425, 12426, 12427, 12428, 12429, 12430, 12431, 12432, 12433, 12434, 12435, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 12449, 12450,
				12451, 12452, 12453, 12454, 12455, 12456, 12457, 12458, 12459, 12460, 12461, 12462, 12463, 12464, 12465, 12466,
				12467, 12468, 12469, 12470, 12471, 12472, 12473, 12474, 12475, 12476, 12477, 12478, 12479, 12480, 12481, 12482,
				12483, 12484, 12485, 12486, 12487, 12488, 12489, 12490, 12491, 12492, 12493, 12494, 12495, 12496, 12497, 12498,
				12499, 12500, 12501, 12502, 12503, 12504, 12505, 12506, 12507, 12508, 12509, 12510, 12511, 12512, 12513, 12514,
				12515, 12516, 12517, 12518, 12519, 12520, 12521, 12522, 12523, 12524, 12525, 12526, 12527, 12528, 12529, 12530,
				12531, 12532, 12533, 12534, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923,
				924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955,
				956, 957, 958, 959, 960, 961, 963, 964, 965, 966, 967, 968, 969, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 1040, 1041,
				1042, 1043, 1044, 1045, 1025, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056,
				1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 1072, 1073,
				1074, 1075, 1076, 1077, 1105, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088,
				1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				9472, 9474, 9484, 9488, 9496, 9492, 9500, 9516, 9508, 9524, 9532, 9473, 9475, 9487, 9491, 9499,
				9495, 9507, 9523, 9515, 9531, 9547, 9504, 9519, 9512, 9527, 9535, 9501, 9520, 9509, 9528, 9538,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 20124, 21782, 23043, 38463, 21696, 24859, 25384, 23030, 36898, 33909, 33564, 31312, 24746, 25569, 28197,
				26093, 33894, 33446, 39925, 26771, 22311, 26017, 25201, 23451, 22992, 34427, 39156, 32098, 32190, 39822, 25110,
				31903, 34999, 23433, 24245, 25353, 26263, 26696, 38343, 38797, 26447, 20197, 20234, 20301, 20381, 20553, 22258,
				22839, 22996, 23041, 23561, 24799, 24847, 24944, 26131, 26885, 28858, 30031, 30064, 31227, 32173, 32239, 32963,
				33806, 34915, 35586, 36949, 36986, 21307, 20117, 20133, 22495, 32946, 37057, 30959, 19968, 22769, 28322, 36920,
				31282, 33576, 33419, 39983, 20801, 21360, 21693, 21729, 22240, 23035, 24341, 39154, 28139, 32996, 34093, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				38498, 38512, 38560, 38907, 21515, 21491, 23431, 28879, 32701, 36802, 38632, 21359, 40284, 31418, 19985, 30867,
				33276, 28198, 22040, 21764, 27421, 34074, 39995, 23013, 21417, 28006, 29916, 38287, 22082, 20113, 36939, 38642,
				33615, 39180, 21473, 21942, 23344, 24433, 26144, 26355, 26628, 27704, 27891, 27945, 29787, 30408, 31310, 38964,
				33521, 34907, 35424, 37613, 28082, 30123, 30410, 39365, 24742, 35585, 36234, 38322, 27022, 21421, 20870, 22290,
				22576, 22852, 23476, 24310, 24616, 25513, 25588, 27839, 28436, 28814, 28948, 29017, 29141, 29503, 32257, 33398,
				33489, 34199, 36960, 37467, 40219, 22633, 26044, 27738, 29989, 20985, 22830, 22885, 24448, 24540, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 25276,
				26106, 27178, 27431, 27572, 29579, 32705, 35158, 40236, 40206, 40644, 23713, 27798, 33659, 20740, 23627, 25014,
				33222, 26742, 29281, 20057, 20474, 21368, 24681, 28201, 31311, 38899, 19979, 21270, 20206, 20309, 20285, 20385,
				20339, 21152, 21487, 22025, 22799, 23233, 23478, 23521, 31185, 26247, 26524, 26550, 27468, 27827, 28779, 29634,
				31117, 31166, 31292, 31623, 33457, 33499, 33540, 33655, 33775, 33747, 34662, 35506, 22057, 36008, 36838, 36942,
				38686, 34442, 20420, 23784, 25105, 29273, 30011, 33253, 33469, 34558, 36032, 38597, 39187, 39381, 20171, 20250,
				35299, 22238, 22602, 22730, 24315, 24555, 24618, 24724, 24674, 25040, 25106, 25296, 25913, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 39745, 26214,
				26800, 28023, 28784, 30028, 30342, 32117, 33445, 34809, 38283, 38542, 35997, 20977, 21182, 22806, 21683, 23475,
				23830, 24936, 27010, 28079, 30861, 33995, 34903, 35442, 37799, 39608, 28012, 39336, 34521, 22435, 26623, 34510,
				37390, 21123, 22151, 21508, 24275, 25313, 25785, 26684, 26680, 27579, 29554, 30906, 31339, 35226, 35282, 36203,
				36611, 37101, 38307, 38548, 38761, 23398, 23731, 27005, 38989, 38990, 25499, 31520, 27179, 27263, 26806, 39949,
				28511, 21106, 21917, 24688, 25324, 27963, 28167, 28369, 33883, 35088, 36676, 19988, 39993, 21494, 26907, 27194,
				38788, 26666, 20828, 31427, 33970, 37340, 37772, 22107, 40232, 26658, 33541, 33841, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 31909, 21000, 33477,
				29926, 20094, 20355, 20896, 23506, 21002, 21208, 21223, 24059, 21914, 22570, 23014, 23436, 23448, 23515, 24178,
				24185, 24739, 24863, 24931, 25022, 25563, 25954, 26577, 26707, 26874, 27454, 27475, 27735, 28450, 28567, 28485,
				29872, 29976, 30435, 30475, 31487, 31649, 31777, 32233, 32566, 32752, 32925, 33382, 33694, 35251, 35532, 36011,
				36996, 37969, 38291, 38289, 38306, 38501, 38867, 39208, 33304, 20024, 21547, 23736, 24012, 29609, 30284, 30524,
				23721, 32747, 36107, 38593, 38929, 38996, 39000, 20225, 20238, 21361, 21916, 22120, 22522, 22855, 23305, 23492,
				23696, 24076, 24190, 24524, 25582, 26426, 26071, 26082, 26399, 26827, 26820, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 27231, 24112, 27589, 27671,
				27773, 30079, 31048, 23395, 31232, 32000, 24509, 35215, 35352, 36020, 36215, 36556, 36637, 39138, 39438, 39740,
				20096, 20605, 20736, 22931, 23452, 25135, 25216, 25836, 27450, 29344, 30097, 31047, 32681, 34811, 35516, 35696,
				25516, 33738, 38816, 21513, 21507, 21931, 26708, 27224, 35440, 30759, 26485, 40653, 21364, 23458, 33050, 34384,
				36870, 19992, 20037, 20167, 20241, 21450, 21560, 23470, 24339, 24613, 25937, 26429, 27714, 27762, 27875, 28792,
				29699, 31350, 31406, 31496, 32026, 31998, 32102, 26087, 29275, 21435, 23621, 24040, 25298, 25312, 25369, 28192,
				34394, 35377, 36317, 37624, 28417, 31142, 39770, 20136, 20139, 20140, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 20379, 20384, 20689, 20807, 31478,
				20849, 20982, 21332, 21281, 21375, 21483, 21932, 22659, 23777, 24375, 24394, 24623, 24656, 24685, 25375, 25945,
				27211, 27841, 29378, 29421, 30703, 33016, 33029, 33288, 34126, 37111, 37857, 38911, 39255, 39514, 20208, 20957,
				23597, 26241, 26989, 23616, 26354, 26997, 29577, 26704, 31873, 20677, 21220, 22343, 24062, 37670, 26020, 27427,
				27453, 29748, 31105, 31165, 31563, 32202, 33465, 33740, 34943, 35167, 35641, 36817, 37329, 21535, 37504, 20061,
				20534, 21477, 21306, 29399, 29590, 30697, 33510, 36527, 39366, 39368, 39378, 20855, 24858, 34398, 21936, 31354,
				20598, 23507, 36935, 38533, 20018, 27355, 37351, 23633, 23624, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 25496, 31391, 27795, 38772, 36705, 31402,
				29066, 38536, 31874, 26647, 32368, 26705, 37740, 21234, 21531, 34219, 35347, 32676, 36557, 37089, 21350, 34952,
				31041, 20418, 20670, 21009, 20804, 21843, 22317, 29674, 22411, 22865, 24418, 24452, 24693, 24950, 24935, 25001,
				25522, 25658, 25964, 26223, 26690, 28179, 30054, 31293, 31995, 32076, 32153, 32331, 32619, 33550, 33610, 34509,
				35336, 35427, 35686, 36605, 38938, 40335, 33464, 36814, 39912, 21127, 25119, 25731, 28608, 38553, 26689, 20625,
				27424, 27770, 28500, 31348, 32080, 34880, 35363, 26376, 20214, 20537, 20518, 20581, 20860, 21048, 21091, 21927,
				22287, 22533, 23244, 24314, 25010, 25080, 25331, 25458, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 26908, 27177, 29309, 29356, 29486, 30740, 30831,
				32121, 30476, 32937, 35211, 35609, 36066, 36562, 36963, 37749, 38522, 38997, 39443, 40568, 20803, 21407, 21427,
				24187, 24358, 28187, 28304, 29572, 29694, 32067, 33335, 35328, 35578, 38480, 20046, 20491, 21476, 21628, 22266,
				22993, 23396, 24049, 24235, 24359, 25144, 25925, 26543, 28246, 29392, 31946, 34996, 32929, 32993, 33776, 34382,
				35463, 36328, 37431, 38599, 39015, 40723, 20116, 20114, 20237, 21320, 21577, 21566, 23087, 24460, 24481, 24735,
				26791, 27278, 29786, 30849, 35486, 35492, 35703, 37264, 20062, 39881, 20132, 20348, 20399, 20505, 20502, 20809,
				20844, 21151, 21177, 21246, 21402, 21475, 21521, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 21518, 21897, 22353, 22434, 22909, 23380, 23389, 23439,
				24037, 24039, 24055, 24184, 24195, 24218, 24247, 24344, 24658, 24908, 25239, 25304, 25511, 25915, 26114, 26179,
				26356, 26477, 26657, 26775, 27083, 27743, 27946, 28009, 28207, 28317, 30002, 30343, 30828, 31295, 31968, 32005,
				32024, 32094, 32177, 32789, 32771, 32943, 32945, 33108, 33167, 33322, 33618, 34892, 34913, 35611, 36002, 36092,
				37066, 37237, 37489, 30783, 37628, 38308, 38477, 38917, 39321, 39640, 40251, 21083, 21163, 21495, 21512, 22741,
				25335, 28640, 35946, 36703, 40633, 20811, 21051, 21578, 22269, 31296, 37239, 40288, 40658, 29508, 28425, 33136,
				29969, 24573, 24794, 39592, 29403, 36796, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 27492, 38915, 20170, 22256, 22372, 22718, 23130, 24680, 25031,
				26127, 26118, 26681, 26801, 28151, 30165, 32058, 33390, 39746, 20123, 20304, 21449, 21766, 23919, 24038, 24046,
				26619, 27801, 29811, 30722, 35408, 37782, 35039, 22352, 24231, 25387, 20661, 20652, 20877, 26368, 21705, 22622,
				22971, 23472, 24425, 25165, 25505, 26685, 27507, 28168, 28797, 37319, 29312, 30741, 30758, 31085, 25998, 32048,
				33756, 35009, 36617, 38555, 21092, 22312, 26448, 32618, 36001, 20916, 22338, 38442, 22586, 27018, 32948, 21682,
				23822, 22524, 30869, 40442, 20316, 21066, 21643, 25662, 26152, 26388, 26613, 31364, 31574, 32034, 37679, 26716,
				39853, 31545, 21273, 20874, 21047, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 23519, 25334, 25774, 25830, 26413, 27578, 34217, 38609, 30352, 39894,
				25420, 37638, 39851, 30399, 26194, 19977, 20632, 21442, 23665, 24808, 25746, 25955, 26719, 29158, 29642, 29987,
				31639, 32386, 34453, 35715, 36059, 37240, 39184, 26028, 26283, 27531, 20181, 20180, 20282, 20351, 21050, 21496,
				21490, 21987, 22235, 22763, 22987, 22985, 23039, 23376, 23629, 24066, 24107, 24535, 24605, 25351, 25903, 23388,
				26031, 26045, 26088, 26525, 27490, 27515, 27663, 29509, 31049, 31169, 31992, 32025, 32043, 32930, 33026, 33267,
				35222, 35422, 35433, 35430, 35468, 35566, 36039, 36060, 38604, 39164, 27503, 20107, 20284, 20365, 20816, 23383,
				23546, 24904, 25345, 26178, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 27425, 28363, 27835, 29246, 29885, 30164, 30913, 31034, 32780, 32819, 33258,
				33940, 36766, 27728, 40575, 24335, 35672, 40235, 31482, 36600, 23437, 38635, 19971, 21489, 22519, 22833, 23241,
				23460, 24713, 28287, 28422, 30142, 36074, 23455, 34048, 31712, 20594, 26612, 33437, 23649, 34122, 32286, 33294,
				20889, 23556, 25448, 36198, 26012, 29038, 31038, 32023, 32773, 35613, 36554, 36974, 34503, 37034, 20511, 21242,
				23610, 26451, 28796, 29237, 37196, 37320, 37675, 33509, 23490, 24369, 24825, 20027, 21462, 23432, 25163, 26417,
				27530, 29417, 29664, 31278, 33131, 36259, 37202, 39318, 20754, 21463, 21610, 23551, 25480, 27193, 32172, 38656,
				22234, 21454, 21608, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 23447, 23601, 24030, 20462, 24833, 25342, 27954, 31168, 31179, 32066, 32333, 32722,
				33261, 33311, 33936, 34886, 35186, 35728, 36468, 36655, 36913, 37195, 37228, 38598, 37276, 20160, 20303, 20805,
				21313, 24467, 25102, 26580, 27713, 28171, 29539, 32294, 37325, 37507, 21460, 22809, 23487, 28113, 31069, 32302,
				31899, 22654, 29087, 20986, 34899, 36848, 20426, 23803, 26149, 30636, 31459, 33308, 39423, 20934, 24490, 26092,
				26991, 27529, 28147, 28310, 28516, 30462, 32020, 24033, 36981, 37255, 38918, 20966, 21021, 25152, 26257, 26329,
				28186, 24246, 32210, 32626, 26360, 34223, 34295, 35576, 21161, 21465, 22899, 24207, 24464, 24661, 37604, 38500,
				20663, 20767, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 21213, 21280, 21319, 21484, 21736, 21830, 21809, 22039, 22888, 22974, 23100, 23477, 23558,
				23567, 23569, 23578, 24196, 24202, 24288, 24432, 25215, 25220, 25307, 25484, 25463, 26119, 26124, 26157, 26230,
				26494, 26786, 27167, 27189, 27836, 28040, 28169, 28248, 28988, 28966, 29031, 30151, 30465, 30813, 30977, 31077,
				31216, 31456, 31505, 31911, 32057, 32918, 33750, 33931, 34121, 34909, 35059, 35359, 35388, 35412, 35443, 35937,
				36062, 37284, 37478, 37758, 37912, 38556, 38808, 19978, 19976, 19998, 20055, 20887, 21104, 22478, 22580, 22732,
				23330, 24120, 24773, 25854, 26465, 26454, 27972, 29366, 30067, 31331, 33976, 35698, 37304, 37664, 22065, 22516,
				39166, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 25325, 26893, 27542, 29165, 32340, 32887, 33394, 35302, 39135, 34645, 36785, 23611, 20280, 20449,
				20405, 21767, 23072, 23517, 23529, 24515, 24910, 25391, 26032, 26187, 26862, 27035, 28024, 28145, 30003, 30137,
				30495, 31070, 31206, 32051, 33251, 33455, 34218, 35242, 35386, 36523, 36763, 36914, 37341, 38663, 20154, 20161,
				20995, 22645, 22764, 23563, 29978, 23613, 33102, 35338, 36805, 38499, 38765, 31525, 35535, 38920, 37218, 22259,
				21416, 36887, 21561, 22402, 24101, 25512, 27700, 28810, 30561, 31883, 32736, 34928, 36930, 37204, 37648, 37656,
				38543, 29790, 39620, 23815, 23913, 25968, 26530, 36264, 38619, 25454, 26441, 26905, 33733, 38935, 38592, 35070,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 28548, 25722, 23544, 19990, 28716, 30045, 26159, 20932, 21046, 21218, 22995, 24449, 24615, 25104, 25919,
				25972, 26143, 26228, 26866, 26646, 27491, 28165, 29298, 29983, 30427, 31934, 32854, 22768, 35069, 35199, 35488,
				35475, 35531, 36893, 37266, 38738, 38745, 25993, 31246, 33030, 38587, 24109, 24796, 25114, 26021, 26132, 26512,
				30707, 31309, 31821, 32318, 33034, 36012, 36196, 36321, 36447, 30889, 20999, 25305, 25509, 25666, 25240, 35373,
				31363, 31680, 35500, 38634, 32118, 33292, 34633, 20185, 20808, 21315, 21344, 23459, 23554, 23574, 24029, 25126,
				25159, 25776, 26643, 26676, 27849, 27973, 27927, 26579, 28508, 29006, 29053, 26059, 31359, 31661, 32218, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				32330, 32680, 33146, 33307, 33337, 34214, 35438, 36046, 36341, 36984, 36983, 37549, 37521, 38275, 39854, 21069,
				21892, 28472, 28982, 20840, 31109, 32341, 33203, 31950, 22092, 22609, 23720, 25514, 26366, 26365, 26970, 29401,
				30095, 30094, 30990, 31062, 31199, 31895, 32032, 32068, 34311, 35380, 38459, 36961, 40736, 20711, 21109, 21452,
				21474, 20489, 21930, 22766, 22863, 29245, 23435, 23652, 21277, 24803, 24819, 25436, 25475, 25407, 25531, 25805,
				26089, 26361, 24035, 27085, 27133, 28437, 29157, 20105, 30185, 30456, 31379, 31967, 32207, 32156, 32865, 33609,
				33624, 33900, 33980, 34299, 35013, 36208, 36865, 36973, 37783, 38684, 39442, 20687, 22679, 24974, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 33235,
				34101, 36104, 36896, 20419, 20596, 21063, 21363, 24687, 25417, 26463, 28204, 36275, 36895, 20439, 23646, 36042,
				26063, 32154, 21330, 34966, 20854, 25539, 23384, 23403, 23562, 25613, 26449, 36956, 20182, 22810, 22826, 27760,
				35409, 21822, 22549, 22949, 24816, 25171, 26561, 33333, 26965, 38464, 39364, 39464, 20307, 22534, 23550, 32784,
				23729, 24111, 24453, 24608, 24907, 25140, 26367, 27888, 28382, 32974, 33151, 33492, 34955, 36024, 36864, 36910,
				38538, 40667, 39899, 20195, 21488, 22823, 31532, 37261, 38988, 40441, 28381, 28711, 21331, 21828, 23429, 25176,
				25246, 25299, 27810, 28655, 29730, 35351, 37944, 28609, 35582, 33592, 20967, 34552, 21482, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 21481, 20294,
				36948, 36784, 22890, 33073, 24061, 31466, 36799, 26842, 35895, 29432, 40008, 27197, 35504, 20025, 21336, 22022,
				22374, 25285, 25506, 26086, 27470, 28129, 28251, 28845, 30701, 31471, 31658, 32187, 32829, 32966, 34507, 35477,
				37723, 22243, 22727, 24382, 26029, 26262, 27264, 27573, 30007, 35527, 20516, 30693, 22320, 24347, 24677, 26234,
				27744, 30196, 31258, 32622, 33268, 34584, 36933, 39347, 31689, 30044, 31481, 31569, 33988, 36880, 31209, 31378,
				33590, 23265, 30528, 20013, 20210, 23449, 24544, 25277, 26172, 26609, 27880, 34411, 34935, 35387, 37198, 37619,
				39376, 27159, 28710, 29482, 33511, 33879, 36015, 19969, 20806, 20939, 21899, 23541, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 24086, 24115, 24193,
				24340, 24373, 24427, 24500, 25074, 25361, 26274, 26397, 28526, 29266, 30010, 30522, 32884, 33081, 33144, 34678,
				35519, 35548, 36229, 36339, 37530, 38263, 38914, 40165, 21189, 25431, 30452, 26389, 27784, 29645, 36035, 37806,
				38515, 27941, 22684, 26894, 27084, 36861, 37786, 30171, 36890, 22618, 26626, 25524, 27131, 20291, 28460, 26584,
				36795, 34086, 32180, 37716, 26943, 28528, 22378, 22775, 23340, 32044, 29226, 21514, 37347, 40372, 20141, 20302,
				20572, 20597, 21059, 35998, 21576, 22564, 23450, 24093, 24213, 24237, 24311, 24351, 24716, 25269, 25402, 25552,
				26799, 27712, 30855, 31118, 31243, 32224, 33351, 35330, 35558, 36420, 36883, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 37048, 37165, 37336, 40718,
				27877, 25688, 25826, 25973, 28404, 30340, 31515, 36969, 37841, 28346, 21746, 24505, 25764, 36685, 36845, 37444,
				20856, 22635, 22825, 23637, 24215, 28155, 32399, 29980, 36028, 36578, 39003, 28857, 20253, 27583, 28593, 30000,
				38651, 20814, 21520, 22581, 22615, 22956, 23648, 24466, 26007, 26460, 28193, 30331, 33759, 36077, 36884, 37117,
				37709, 30757, 30778, 21162, 24230, 22303, 22900, 24594, 20498, 20826, 20908, 20941, 20992, 21776, 22612, 22616,
				22871, 23445, 23798, 23947, 24764, 25237, 25645, 26481, 26691, 26812, 26847, 30423, 28120, 28271, 28059, 28783,
				29128, 24403, 30168, 31095, 31561, 31572, 31570, 31958, 32113, 21040, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 33891, 34153, 34276, 35342, 35588,
				35910, 36367, 36867, 36879, 37913, 38518, 38957, 39472, 38360, 20685, 21205, 21516, 22530, 23566, 24999, 25758,
				27934, 30643, 31461, 33012, 33796, 36947, 37509, 23776, 40199, 21311, 24471, 24499, 28060, 29305, 30563, 31167,
				31716, 27602, 29420, 35501, 26627, 27233, 20984, 31361, 26932, 23626, 40182, 33515, 23493, 37193, 28702, 22136,
				23663, 24775, 25958, 27788, 35930, 36929, 38931, 21585, 26311, 37389, 22856, 37027, 20869, 20045, 20970, 34201,
				35598, 28760, 25466, 37707, 26978, 39348, 32260, 30071, 21335, 26976, 36575, 38627, 27741, 20108, 23612, 24336,
				36841, 21250, 36049, 32905, 34425, 24319, 26085, 20083, 20837, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 22914, 23615, 38894, 20219, 22922, 24525,
				35469, 28641, 31152, 31074, 23527, 33905, 29483, 29105, 24180, 24565, 25467, 25754, 29123, 31896, 20035, 24316,
				20043, 22492, 22178, 24745, 28611, 32013, 33021, 33075, 33215, 36786, 35223, 34468, 24052, 25226, 25773, 35207,
				26487, 27874, 27966, 29750, 30772, 23110, 32629, 33453, 39340, 20467, 24259, 25309, 25490, 25943, 26479, 30403,
				29260, 32972, 32954, 36649, 37197, 20493, 22521, 23186, 26757, 26995, 29028, 29437, 36023, 22770, 36064, 38506,
				36889, 34687, 31204, 30695, 33833, 20271, 21093, 21338, 25293, 26575, 27850, 30333, 31636, 31893, 33334, 34180,
				36843, 26333, 28448, 29190, 32283, 33707, 39361, 40614, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 20989, 31665, 30834, 31672, 32903, 31560, 27368,
				24161, 32908, 30033, 30048, 20843, 37474, 28300, 30330, 37271, 39658, 20240, 32624, 25244, 31567, 38309, 40169,
				22138, 22617, 34532, 38588, 20276, 21028, 21322, 21453, 21467, 24070, 25644, 26001, 26495, 27710, 27726, 29256,
				29359, 29677, 30036, 32321, 33324, 34281, 36009, 31684, 37318, 29033, 38930, 39151, 25405, 26217, 30058, 30436,
				30928, 34115, 34542, 21290, 21329, 21542, 22915, 24199, 24444, 24754, 25161, 25209, 25259, 26000, 27604, 27852,
				30130, 30382, 30865, 31192, 32203, 32631, 32933, 34987, 35513, 36027, 36991, 38750, 39131, 27147, 31800, 20633,
				23614, 24494, 26503, 27608, 29749, 30473, 32654, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 40763, 26570, 31255, 21305, 30091, 39661, 24422, 33181,
				33777, 32920, 24380, 24517, 30050, 31558, 36924, 26727, 23019, 23195, 32016, 30334, 35628, 20469, 24426, 27161,
				27703, 28418, 29922, 31080, 34920, 35413, 35961, 24287, 25551, 30149, 31186, 33495, 37672, 37618, 33948, 34541,
				39981, 21697, 24428, 25996, 27996, 28693, 36007, 36051, 38971, 25935, 29942, 19981, 20184, 22496, 22827, 23142,
				23500, 20904, 24067, 24220, 24598, 25206, 25975, 26023, 26222, 28014, 29238, 31526, 33104, 33178, 33433, 35676,
				36000, 36070, 36212, 38428, 38468, 20398, 25771, 27494, 33310, 33889, 34154, 37096, 23553, 26963, 39080, 33914,
				34135, 20239, 21103, 24489, 24133, 26381, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 31119, 33145, 35079, 35206, 28149, 24343, 25173, 27832, 20175,
				29289, 39826, 20998, 21563, 22132, 22707, 24996, 25198, 28954, 22894, 31881, 31966, 32027, 38640, 25991, 32862,
				19993, 20341, 20853, 22592, 24163, 24179, 24330, 26564, 20006, 34109, 38281, 38491, 31859, 38913, 20731, 22721,
				30294, 30887, 21029, 30629, 34065, 31622, 20559, 22793, 29255, 31687, 32232, 36794, 36820, 36941, 20415, 21193,
				23081, 24321, 38829, 20445, 33303, 37610, 22275, 25429, 27497, 29995, 35036, 36628, 31298, 21215, 22675, 24917,
				25098, 26286, 27597, 31807, 33769, 20515, 20472, 21253, 21574, 22577, 22857, 23453, 23792, 23791, 23849, 24214,
				25265, 25447, 25918, 26041, 26379, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 27861, 27873, 28921, 30770, 32299, 32990, 33459, 33804, 34028, 34562,
				35090, 35370, 35914, 37030, 37586, 39165, 40179, 40300, 20047, 20129, 20621, 21078, 22346, 22952, 24125, 24536,
				24537, 25151, 26292, 26395, 26576, 26834, 20882, 32033, 32938, 33192, 35584, 35980, 36031, 37502, 38450, 21536,
				38956, 21271, 20693, 21340, 22696, 25778, 26420, 29287, 30566, 31302, 37350, 21187, 27809, 27526, 22528, 24140,
				22868, 26412, 32763, 20961, 30406, 25705, 30952, 39764, 40635, 22475, 22969, 26151, 26522, 27598, 21737, 27097,
				24149, 33180, 26517, 39850, 26622, 40018, 26717, 20134, 20451, 21448, 25273, 26411, 27819, 36804, 20397, 32365,
				40639, 19975, 24930, 28288, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 28459, 34067, 21619, 26410, 39749, 24051, 31637, 23724, 23494, 34588, 28234,
				34001, 31252, 33032, 22937, 31885, 27665, 30496, 21209, 22818, 28961, 29279, 30683, 38695, 40289, 26891, 23167,
				23064, 20901, 21517, 21629, 26126, 30431, 36855, 37528, 40180, 23018, 29277, 28357, 20813, 26825, 32191, 32236,
				38754, 40634, 25720, 27169, 33538, 22916, 23391, 27611, 29467, 30450, 32178, 32791, 33945, 20786, 26408, 40665,
				30446, 26466, 21247, 39173, 23588, 25147, 31870, 36016, 21839, 24758, 32011, 38272, 21249, 20063, 20918, 22812,
				29242, 32822, 37326, 24357, 30690, 21380, 24441, 32004, 34220, 35379, 36493, 38742, 26611, 34222, 37971, 24841,
				24840, 27833, 30290, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 35565, 36664, 21807, 20305, 20778, 21191, 21451, 23461, 24189, 24736, 24962, 25558,
				26377, 26586, 28263, 28044, 29494, 29495, 30001, 31056, 35029, 35480, 36938, 37009, 37109, 38596, 34701, 22805,
				20104, 20313, 19982, 35465, 36671, 38928, 20653, 24188, 22934, 23481, 24248, 25562, 25594, 25793, 26332, 26954,
				27096, 27915, 28342, 29076, 29992, 31407, 32650, 32768, 33865, 33993, 35201, 35617, 36362, 36965, 38525, 39178,
				24958, 25233, 27442, 27779, 28020, 32716, 32764, 28096, 32645, 34746, 35064, 26469, 33713, 38972, 38647, 27931,
				32097, 33853, 37226, 20081, 21365, 23888, 27396, 28651, 34253, 34349, 35239, 21033, 21519, 23653, 26446, 26792,
				29702, 29827, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 30178, 35023, 35041, 37324, 38626, 38520, 24459, 29575, 31435, 33870, 25504, 30053, 21129,
				27969, 28316, 29705, 30041, 30827, 31890, 38534, 31452, 40845, 20406, 24942, 26053, 34396, 20102, 20142, 20698,
				20001, 20940, 23534, 26009, 26753, 28092, 29471, 30274, 30637, 31260, 31975, 33391, 35538, 36988, 37327, 38517,
				38936, 21147, 32209, 20523, 21400, 26519, 28107, 29136, 29747, 33256, 36650, 38563, 40023, 40607, 29792, 22593,
				28057, 32047, 39006, 20196, 20278, 20363, 20919, 21169, 23994, 24604, 29618, 31036, 33491, 37428, 38583, 38646,
				38666, 40599, 40802, 26278, 27508, 21015, 21155, 28872, 35010, 24265, 24651, 24976, 28451, 29001, 31806, 32244,
				32879, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 34030, 36899, 37676, 21570, 39791, 27347, 28809, 36034, 36335, 38706, 21172, 23105, 24266, 24324,
				26391, 27004, 27028, 28010, 28431, 29282, 29436, 31725, 32769, 32894, 34635, 37070, 20845, 40595, 31108, 32907,
				37682, 35542, 20525, 21644, 35441, 27498, 36036, 33031, 24785, 26528, 40434, 20121, 20120, 39952, 35435, 34241,
				34152, 26880, 28286, 30871, 33109, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 24332, 19984, 19989, 20010, 20017, 20022, 20028, 20031, 20034, 20054,
				20056, 20098, 20101, 35947, 20106, 33298, 24333, 20110, 20126, 20127, 20128, 20130, 20144, 20147, 20150, 20174,
				20173, 20164, 20166, 20162, 20183, 20190, 20205, 20191, 20215, 20233, 20314, 20272, 20315, 20317, 20311, 20295,
				20342, 20360, 20367, 20376, 20347, 20329, 20336, 20369, 20335, 20358, 20374, 20760, 20436, 20447, 20430, 20440,
				20443, 20433, 20442, 20432, 20452, 20453, 20506, 20520, 20500, 20522, 20517, 20485, 20252, 20470, 20513, 20521,
				20524, 20478, 20463, 20497, 20486, 20547, 20551, 26371, 20565, 20560, 20552, 20570, 20566, 20588, 20600, 20608,
				20634, 20613, 20660, 20658, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 20681, 20682, 20659, 20674, 20694, 20702, 20709, 20717, 20707, 20718, 20729,
				20725, 20745, 20737, 20738, 20758, 20757, 20756, 20762, 20769, 20794, 20791, 20796, 20795, 20799, 20800, 20818,
				20812, 20820, 20834, 31480, 20841, 20842, 20846, 20864, 20866, 22232, 20876, 20873, 20879, 20881, 20883, 20885,
				20886, 20900, 20902, 20898, 20905, 20906, 20907, 20915, 20913, 20914, 20912, 20917, 20925, 20933, 20937, 20955,
				20960, 34389, 20969, 20973, 20976, 20981, 20990, 20996, 21003, 21012, 21006, 21031, 21034, 21038, 21043, 21049,
				21071, 21060, 21067, 21068, 21086, 21076, 21098, 21108, 21097, 21107, 21119, 21117, 21133, 21140, 21138, 21105,
				21128, 21137, 36776, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 36775, 21164, 21165, 21180, 21173, 21185, 21197, 21207, 21214, 21219, 21222, 39149,
				21216, 21235, 21237, 21240, 21241, 21254, 21256, 30008, 21261, 21264, 21263, 21269, 21274, 21283, 21295, 21297,
				21299, 21304, 21312, 21318, 21317, 19991, 21321, 21325, 20950, 21342, 21353, 21358, 22808, 21371, 21367, 21378,
				21398, 21408, 21414, 21413, 21422, 21424, 21430, 21443, 31762, 38617, 21471, 26364, 29166, 21486, 21480, 21485,
				21498, 21505, 21565, 21568, 21548, 21549, 21564, 21550, 21558, 21545, 21533, 21582, 21647, 21621, 21646, 21599,
				21617, 21623, 21616, 21650, 21627, 21632, 21622, 21636, 21648, 21638, 21703, 21666, 21688, 21669, 21676, 21700,
				21704, 21672, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 21675, 21698, 21668, 21694, 21692, 21720, 21733, 21734, 21775, 21780, 21757, 21742, 21741,
				21754, 21730, 21817, 21824, 21859, 21836, 21806, 21852, 21829, 21846, 21847, 21816, 21811, 21853, 21913, 21888,
				21679, 21898, 21919, 21883, 21886, 21912, 21918, 21934, 21884, 21891, 21929, 21895, 21928, 21978, 21957, 21983,
				21956, 21980, 21988, 21972, 22036, 22007, 22038, 22014, 22013, 22043, 22009, 22094, 22096, 29151, 22068, 22070,
				22066, 22072, 22123, 22116, 22063, 22124, 22122, 22150, 22144, 22154, 22176, 22164, 22159, 22181, 22190, 22198,
				22196, 22210, 22204, 22209, 22211, 22208, 22216, 22222, 22225, 22227, 22231, 22254, 22265, 22272, 22271, 22276,
				22281, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 22280, 22283, 22285, 22291, 22296, 22294, 21959, 22300, 22310, 22327, 22328, 22350, 22331, 22336,
				22351, 22377, 22464, 22408, 22369, 22399, 22409, 22419, 22432, 22451, 22436, 22442, 22448, 22467, 22470, 22484,
				22482, 22483, 22538, 22486, 22499, 22539, 22553, 22557, 22642, 22561, 22626, 22603, 22640, 27584, 22610, 22589,
				22649, 22661, 22713, 22687, 22699, 22714, 22750, 22715, 22712, 22702, 22725, 22739, 22737, 22743, 22745, 22744,
				22757, 22748, 22756, 22751, 22767, 22778, 22777, 22779, 22780, 22781, 22786, 22794, 22800, 22811, 26790, 22821,
				22828, 22829, 22834, 22840, 22846, 31442, 22869, 22864, 22862, 22874, 22872, 22882, 22880, 22887, 22892, 22889,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 22904, 22913, 22941, 20318, 20395, 22947, 22962, 22982, 23016, 23004, 22925, 23001, 23002, 23077, 23071,
				23057, 23068, 23049, 23066, 23104, 23148, 23113, 23093, 23094, 23138, 23146, 23194, 23228, 23230, 23243, 23234,
				23229, 23267, 23255, 23270, 23273, 23254, 23290, 23291, 23308, 23307, 23318, 23346, 23248, 23338, 23350, 23358,
				23363, 23365, 23360, 23377, 23381, 23386, 23387, 23397, 23401, 23408, 23411, 23413, 23416, 25992, 23418, 23424,
				23427, 23462, 23480, 23491, 23495, 23497, 23508, 23504, 23524, 23526, 23522, 23518, 23525, 23531, 23536, 23542,
				23539, 23557, 23559, 23560, 23565, 23571, 23584, 23586, 23592, 23608, 23609, 23617, 23622, 23630, 23635, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				23632, 23631, 23409, 23660, 23662, 20066, 23670, 23673, 23692, 23697, 23700, 22939, 23723, 23739, 23734, 23740,
				23735, 23749, 23742, 23751, 23769, 23785, 23805, 23802, 23789, 23948, 23786, 23819, 23829, 23831, 23900, 23839,
				23835, 23825, 23828, 23842, 23834, 23833, 23832, 23884, 23890, 23886, 23883, 23916, 23923, 23926, 23943, 23940,
				23938, 23970, 23965, 23980, 23982, 23997, 23952, 23991, 23996, 24009, 24013, 24019, 24018, 24022, 24027, 24043,
				24050, 24053, 24075, 24090, 24089, 24081, 24091, 24118, 24119, 24132, 24131, 24128, 24142, 24151, 24148, 24159,
				24162, 24164, 24135, 24181, 24182, 24186, 40636, 24191, 24224, 24257, 24258, 24264, 24272, 24271, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 24278,
				24291, 24285, 24282, 24283, 24290, 24289, 24296, 24297, 24300, 24305, 24307, 24304, 24308, 24312, 24318, 24323,
				24329, 24413, 24412, 24331, 24337, 24342, 24361, 24365, 24376, 24385, 24392, 24396, 24398, 24367, 24401, 24406,
				24407, 24409, 24417, 24429, 24435, 24439, 24451, 24450, 24447, 24458, 24456, 24465, 24455, 24478, 24473, 24472,
				24480, 24488, 24493, 24508, 24534, 24571, 24548, 24568, 24561, 24541, 24755, 24575, 24609, 24672, 24601, 24592,
				24617, 24590, 24625, 24603, 24597, 24619, 24614, 24591, 24634, 24666, 24641, 24682, 24695, 24671, 24650, 24646,
				24653, 24675, 24643, 24676, 24642, 24684, 24683, 24665, 24705, 24717, 24807, 24707, 24730, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 24708, 24731,
				24726, 24727, 24722, 24743, 24715, 24801, 24760, 24800, 24787, 24756, 24560, 24765, 24774, 24757, 24792, 24909,
				24853, 24838, 24822, 24823, 24832, 24820, 24826, 24835, 24865, 24827, 24817, 24845, 24846, 24903, 24894, 24872,
				24871, 24906, 24895, 24892, 24876, 24884, 24893, 24898, 24900, 24947, 24951, 24920, 24921, 24922, 24939, 24948,
				24943, 24933, 24945, 24927, 24925, 24915, 24949, 24985, 24982, 24967, 25004, 24980, 24986, 24970, 24977, 25003,
				25006, 25036, 25034, 25033, 25079, 25032, 25027, 25030, 25018, 25035, 32633, 25037, 25062, 25059, 25078, 25082,
				25076, 25087, 25085, 25084, 25086, 25088, 25096, 25097, 25101, 25100, 25108, 25115, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 25118, 25121, 25130,
				25134, 25136, 25138, 25139, 25153, 25166, 25182, 25187, 25179, 25184, 25192, 25212, 25218, 25225, 25214, 25234,
				25235, 25238, 25300, 25219, 25236, 25303, 25297, 25275, 25295, 25343, 25286, 25812, 25288, 25308, 25292, 25290,
				25282, 25287, 25243, 25289, 25356, 25326, 25329, 25383, 25346, 25352, 25327, 25333, 25424, 25406, 25421, 25628,
				25423, 25494, 25486, 25472, 25515, 25462, 25507, 25487, 25481, 25503, 25525, 25451, 25449, 25534, 25577, 25536,
				25542, 25571, 25545, 25554, 25590, 25540, 25622, 25652, 25606, 25619, 25638, 25654, 25885, 25623, 25640, 25615,
				25703, 25711, 25718, 25678, 25898, 25749, 25747, 25765, 25769, 25736, 25788, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 25818, 25810, 25797, 25799,
				25787, 25816, 25794, 25841, 25831, 33289, 25824, 25825, 25260, 25827, 25839, 25900, 25846, 25844, 25842, 25850,
				25856, 25853, 25880, 25884, 25861, 25892, 25891, 25899, 25908, 25909, 25911, 25910, 25912, 30027, 25928, 25942,
				25941, 25933, 25944, 25950, 25949, 25970, 25976, 25986, 25987, 35722, 26011, 26015, 26027, 26039, 26051, 26054,
				26049, 26052, 26060, 26066, 26075, 26073, 26080, 26081, 26097, 26482, 26122, 26115, 26107, 26483, 26165, 26166,
				26164, 26140, 26191, 26180, 26185, 26177, 26206, 26205, 26212, 26215, 26216, 26207, 26210, 26224, 26243, 26248,
				26254, 26249, 26244, 26264, 26269, 26305, 26297, 26313, 26302, 26300, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 26308, 26296, 26326, 26330, 26336,
				26175, 26342, 26345, 26352, 26357, 26359, 26383, 26390, 26398, 26406, 26407, 38712, 26414, 26431, 26422, 26433,
				26424, 26423, 26438, 26462, 26464, 26457, 26467, 26468, 26505, 26480, 26537, 26492, 26474, 26508, 26507, 26534,
				26529, 26501, 26551, 26607, 26548, 26604, 26547, 26601, 26552, 26596, 26590, 26589, 26594, 26606, 26553, 26574,
				26566, 26599, 27292, 26654, 26694, 26665, 26688, 26701, 26674, 26702, 26803, 26667, 26713, 26723, 26743, 26751,
				26783, 26767, 26797, 26772, 26781, 26779, 26755, 27310, 26809, 26740, 26805, 26784, 26810, 26895, 26765, 26750,
				26881, 26826, 26888, 26840, 26914, 26918, 26849, 26892, 26829, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 26836, 26855, 26837, 26934, 26898, 26884,
				26839, 26851, 26917, 26873, 26848, 26863, 26920, 26922, 26906, 26915, 26913, 26822, 27001, 26999, 26972, 27000,
				26987, 26964, 27006, 26990, 26937, 26996, 26941, 26969, 26928, 26977, 26974, 26973, 27009, 26986, 27058, 27054,
				27088, 27071, 27073, 27091, 27070, 27086, 23528, 27082, 27101, 27067, 27075, 27047, 27182, 27025, 27040, 27036,
				27029, 27060, 27102, 27112, 27138, 27163, 27135, 27402, 27129, 27122, 27111, 27141, 27057, 27166, 27117, 27156,
				27115, 27146, 27154, 27329, 27171, 27155, 27204, 27148, 27250, 27190, 27256, 27207, 27234, 27225, 27238, 27208,
				27192, 27170, 27280, 27277, 27296, 27268, 27298, 27299, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 27287, 34327, 27323, 27331, 27330, 27320, 27315,
				27308, 27358, 27345, 27359, 27306, 27354, 27370, 27387, 27397, 34326, 27386, 27410, 27414, 39729, 27423, 27448,
				27447, 30428, 27449, 39150, 27463, 27459, 27465, 27472, 27481, 27476, 27483, 27487, 27489, 27512, 27513, 27519,
				27520, 27524, 27523, 27533, 27544, 27541, 27550, 27556, 27562, 27563, 27567, 27570, 27569, 27571, 27575, 27580,
				27590, 27595, 27603, 27615, 27628, 27627, 27635, 27631, 40638, 27656, 27667, 27668, 27675, 27684, 27683, 27742,
				27733, 27746, 27754, 27778, 27789, 27802, 27777, 27803, 27774, 27752, 27763, 27794, 27792, 27844, 27889, 27859,
				27837, 27863, 27845, 27869, 27822, 27825, 27838, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 27834, 27867, 27887, 27865, 27882, 27935, 34893, 27958,
				27947, 27965, 27960, 27929, 27957, 27955, 27922, 27916, 28003, 28051, 28004, 27994, 28025, 27993, 28046, 28053,
				28644, 28037, 28153, 28181, 28170, 28085, 28103, 28134, 28088, 28102, 28140, 28126, 28108, 28136, 28114, 28101,
				28154, 28121, 28132, 28117, 28138, 28142, 28205, 28270, 28206, 28185, 28274, 28255, 28222, 28195, 28267, 28203,
				28278, 28237, 28191, 28227, 28218, 28238, 28196, 28415, 28189, 28216, 28290, 28330, 28312, 28361, 28343, 28371,
				28349, 28335, 28356, 28338, 28372, 28373, 28303, 28325, 28354, 28319, 28481, 28433, 28748, 28396, 28408, 28414,
				28479, 28402, 28465, 28399, 28466, 28364, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 28478, 28435, 28407, 28550, 28538, 28536, 28545, 28544, 28527,
				28507, 28659, 28525, 28546, 28540, 28504, 28558, 28561, 28610, 28518, 28595, 28579, 28577, 28580, 28601, 28614,
				28586, 28639, 28629, 28652, 28628, 28632, 28657, 28654, 28635, 28681, 28683, 28666, 28689, 28673, 28687, 28670,
				28699, 28698, 28532, 28701, 28696, 28703, 28720, 28734, 28722, 28753, 28771, 28825, 28818, 28847, 28913, 28844,
				28856, 28851, 28846, 28895, 28875, 28893, 28889, 28937, 28925, 28956, 28953, 29029, 29013, 29064, 29030, 29026,
				29004, 29014, 29036, 29071, 29179, 29060, 29077, 29096, 29100, 29143, 29113, 29118, 29138, 29129, 29140, 29134,
				29152, 29164, 29159, 29173, 29180, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 29177, 29183, 29197, 29200, 29211, 29224, 29229, 29228, 29232, 29234,
				29243, 29244, 29247, 29248, 29254, 29259, 29272, 29300, 29310, 29314, 29313, 29319, 29330, 29334, 29346, 29351,
				29369, 29362, 29379, 29382, 29380, 29390, 29394, 29410, 29408, 29409, 29433, 29431, 20495, 29463, 29450, 29468,
				29462, 29469, 29492, 29487, 29481, 29477, 29502, 29518, 29519, 40664, 29527, 29546, 29544, 29552, 29560, 29557,
				29563, 29562, 29640, 29619, 29646, 29627, 29632, 29669, 29678, 29662, 29858, 29701, 29807, 29733, 29688, 29746,
				29754, 29781, 29759, 29791, 29785, 29761, 29788, 29801, 29808, 29795, 29802, 29814, 29822, 29835, 29854, 29863,
				29898, 29903, 29908, 29681, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 29920, 29923, 29927, 29929, 29934, 29938, 29936, 29937, 29944, 29943, 29956,
				29955, 29957, 29964, 29966, 29965, 29973, 29971, 29982, 29990, 29996, 30012, 30020, 30029, 30026, 30025, 30043,
				30022, 30042, 30057, 30052, 30055, 30059, 30061, 30072, 30070, 30086, 30087, 30068, 30090, 30089, 30082, 30100,
				30106, 30109, 30117, 30115, 30146, 30131, 30147, 30133, 30141, 30136, 30140, 30129, 30157, 30154, 30162, 30169,
				30179, 30174, 30206, 30207, 30204, 30209, 30192, 30202, 30194, 30195, 30219, 30221, 30217, 30239, 30247, 30240,
				30241, 30242, 30244, 30260, 30256, 30267, 30279, 30280, 30278, 30300, 30296, 30305, 30306, 30312, 30313, 30314,
				30311, 30316, 30320, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 30322, 30326, 30328, 30332, 30336, 30339, 30344, 30347, 30350, 30358, 30355, 30361,
				30362, 30384, 30388, 30392, 30393, 30394, 30402, 30413, 30422, 30418, 30430, 30433, 30437, 30439, 30442, 34351,
				30459, 30472, 30471, 30468, 30505, 30500, 30494, 30501, 30502, 30491, 30519, 30520, 30535, 30554, 30568, 30571,
				30555, 30565, 30591, 30590, 30585, 30606, 30603, 30609, 30624, 30622, 30640, 30646, 30649, 30655, 30652, 30653,
				30651, 30663, 30669, 30679, 30682, 30684, 30691, 30702, 30716, 30732, 30738, 31014, 30752, 31018, 30789, 30862,
				30836, 30854, 30844, 30874, 30860, 30883, 30901, 30890, 30895, 30929, 30918, 30923, 30932, 30910, 30908, 30917,
				30922, 30956, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 30951, 30938, 30973, 30964, 30983, 30994, 30993, 31001, 31020, 31019, 31040, 31072, 31063,
				31071, 31066, 31061, 31059, 31098, 31103, 31114, 31133, 31143, 40779, 31146, 31150, 31155, 31161, 31162, 31177,
				31189, 31207, 31212, 31201, 31203, 31240, 31245, 31256, 31257, 31264, 31263, 31104, 31281, 31291, 31294, 31287,
				31299, 31319, 31305, 31329, 31330, 31337, 40861, 31344, 31353, 31357, 31368, 31383, 31381, 31384, 31382, 31401,
				31432, 31408, 31414, 31429, 31428, 31423, 36995, 31431, 31434, 31437, 31439, 31445, 31443, 31449, 31450, 31453,
				31457, 31458, 31462, 31469, 31472, 31490, 31503, 31498, 31494, 31539, 31512, 31513, 31518, 31541, 31528, 31542,
				31568, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 31610, 31492, 31565, 31499, 31564, 31557, 31605, 31589, 31604, 31591, 31600, 31601, 31596, 31598,
				31645, 31640, 31647, 31629, 31644, 31642, 31627, 31634, 31631, 31581, 31641, 31691, 31681, 31692, 31695, 31668,
				31686, 31709, 31721, 31761, 31764, 31718, 31717, 31840, 31744, 31751, 31763, 31731, 31735, 31767, 31757, 31734,
				31779, 31783, 31786, 31775, 31799, 31787, 31805, 31820, 31811, 31828, 31823, 31808, 31824, 31832, 31839, 31844,
				31830, 31845, 31852, 31861, 31875, 31888, 31908, 31917, 31906, 31915, 31905, 31912, 31923, 31922, 31921, 31918,
				31929, 31933, 31936, 31941, 31938, 31960, 31954, 31964, 31970, 39739, 31983, 31986, 31988, 31990, 31994, 32006,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 32002, 32028, 32021, 32010, 32069, 32075, 32046, 32050, 32063, 32053, 32070, 32115, 32086, 32078, 32114,
				32104, 32110, 32079, 32099, 32147, 32137, 32091, 32143, 32125, 32155, 32186, 32174, 32163, 32181, 32199, 32189,
				32171, 32317, 32162, 32175, 32220, 32184, 32159, 32176, 32216, 32221, 32228, 32222, 32251, 32242, 32225, 32261,
				32266, 32291, 32289, 32274, 32305, 32287, 32265, 32267, 32290, 32326, 32358, 32315, 32309, 32313, 32323, 32311,
				32306, 32314, 32359, 32349, 32342, 32350, 32345, 32346, 32377, 32362, 32361, 32380, 32379, 32387, 32213, 32381,
				36782, 32383, 32392, 32393, 32396, 32402, 32400, 32403, 32404, 32406, 32398, 32411, 32412, 32568, 32570, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				32581, 32588, 32589, 32590, 32592, 32593, 32597, 32596, 32600, 32607, 32608, 32616, 32617, 32615, 32632, 32642,
				32646, 32643, 32648, 32647, 32652, 32660, 32670, 32669, 32666, 32675, 32687, 32690, 32697, 32686, 32694, 32696,
				35697, 32709, 32710, 32714, 32725, 32724, 32737, 32742, 32745, 32755, 32761, 39132, 32774, 32772, 32779, 32786,
				32792, 32793, 32796, 32801, 32808, 32831, 32827, 32842, 32838, 32850, 32856, 32858, 32863, 32866, 32872, 32883,
				32882, 32880, 32886, 32889, 32893, 32895, 32900, 32902, 32901, 32923, 32915, 32922, 32941, 20880, 32940, 32987,
				32997, 32985, 32989, 32964, 32986, 32982, 33033, 33007, 33009, 33051, 33065, 33059, 33071, 33099, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 38539,
				33094, 33086, 33107, 33105, 33020, 33137, 33134, 33125, 33126, 33140, 33155, 33160, 33162, 33152, 33154, 33184,
				33173, 33188, 33187, 33119, 33171, 33193, 33200, 33205, 33214, 33208, 33213, 33216, 33218, 33210, 33225, 33229,
				33233, 33241, 33240, 33224, 33242, 33247, 33248, 33255, 33274, 33275, 33278, 33281, 33282, 33285, 33287, 33290,
				33293, 33296, 33302, 33321, 33323, 33336, 33331, 33344, 33369, 33368, 33373, 33370, 33375, 33380, 33378, 33384,
				33386, 33387, 33326, 33393, 33399, 33400, 33406, 33421, 33426, 33451, 33439, 33467, 33452, 33505, 33507, 33503,
				33490, 33524, 33523, 33530, 33683, 33539, 33531, 33529, 33502, 33542, 33500, 33545, 33497, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 33589, 33588,
				33558, 33586, 33585, 33600, 33593, 33616, 33605, 33583, 33579, 33559, 33560, 33669, 33690, 33706, 33695, 33698,
				33686, 33571, 33678, 33671, 33674, 33660, 33717, 33651, 33653, 33696, 33673, 33704, 33780, 33811, 33771, 33742,
				33789, 33795, 33752, 33803, 33729, 33783, 33799, 33760, 33778, 33805, 33826, 33824, 33725, 33848, 34054, 33787,
				33901, 33834, 33852, 34138, 33924, 33911, 33899, 33965, 33902, 33922, 33897, 33862, 33836, 33903, 33913, 33845,
				33994, 33890, 33977, 33983, 33951, 34009, 33997, 33979, 34010, 34000, 33985, 33990, 34006, 33953, 34081, 34047,
				34036, 34071, 34072, 34092, 34079, 34069, 34068, 34044, 34112, 34147, 34136, 34120, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 34113, 34306, 34123,
				34133, 34176, 34212, 34184, 34193, 34186, 34216, 34157, 34196, 34203, 34282, 34183, 34204, 34167, 34174, 34192,
				34249, 34234, 34255, 34233, 34256, 34261, 34269, 34277, 34268, 34297, 34314, 34323, 34315, 34302, 34298, 34310,
				34338, 34330, 34352, 34367, 34381, 20053, 34388, 34399, 34407, 34417, 34451, 34467, 34473, 34474, 34443, 34444,
				34486, 34479, 34500, 34502, 34480, 34505, 34851, 34475, 34516, 34526, 34537, 34540, 34527, 34523, 34543, 34578,
				34566, 34568, 34560, 34563, 34555, 34577, 34569, 34573, 34553, 34570, 34612, 34623, 34615, 34619, 34597, 34601,
				34586, 34656, 34655, 34680, 34636, 34638, 34676, 34647, 34664, 34670, 34649, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 34643, 34659, 34666, 34821,
				34722, 34719, 34690, 34735, 34763, 34749, 34752, 34768, 38614, 34731, 34756, 34739, 34759, 34758, 34747, 34799,
				34802, 34784, 34831, 34829, 34814, 34806, 34807, 34830, 34770, 34833, 34838, 34837, 34850, 34849, 34865, 34870,
				34873, 34855, 34875, 34884, 34882, 34898, 34905, 34910, 34914, 34923, 34945, 34942, 34974, 34933, 34941, 34997,
				34930, 34946, 34967, 34962, 34990, 34969, 34978, 34957, 34980, 34992, 35007, 34993, 35011, 35012, 35028, 35032,
				35033, 35037, 35065, 35074, 35068, 35060, 35048, 35058, 35076, 35084, 35082, 35091, 35139, 35102, 35109, 35114,
				35115, 35137, 35140, 35131, 35126, 35128, 35148, 35101, 35168, 35166, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 35174, 35172, 35181, 35178, 35183,
				35188, 35191, 35198, 35203, 35208, 35210, 35219, 35224, 35233, 35241, 35238, 35244, 35247, 35250, 35258, 35261,
				35263, 35264, 35290, 35292, 35293, 35303, 35316, 35320, 35331, 35350, 35344, 35340, 35355, 35357, 35365, 35382,
				35393, 35419, 35410, 35398, 35400, 35452, 35437, 35436, 35426, 35461, 35458, 35460, 35496, 35489, 35473, 35493,
				35494, 35482, 35491, 35524, 35533, 35522, 35546, 35563, 35571, 35559, 35556, 35569, 35604, 35552, 35554, 35575,
				35550, 35547, 35596, 35591, 35610, 35553, 35606, 35600, 35607, 35616, 35635, 38827, 35622, 35627, 35646, 35624,
				35649, 35660, 35663, 35662, 35657, 35670, 35675, 35674, 35691, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 35679, 35692, 35695, 35700, 35709, 35712,
				35724, 35726, 35730, 35731, 35734, 35737, 35738, 35898, 35905, 35903, 35912, 35916, 35918, 35920, 35925, 35938,
				35948, 35960, 35962, 35970, 35977, 35973, 35978, 35981, 35982, 35988, 35964, 35992, 25117, 36013, 36010, 36029,
				36018, 36019, 36014, 36022, 36040, 36033, 36068, 36067, 36058, 36093, 36090, 36091, 36100, 36101, 36106, 36103,
				36111, 36109, 36112, 40782, 36115, 36045, 36116, 36118, 36199, 36205, 36209, 36211, 36225, 36249, 36290, 36286,
				36282, 36303, 36314, 36310, 36300, 36315, 36299, 36330, 36331, 36319, 36323, 36348, 36360, 36361, 36351, 36381,
				36382, 36368, 36383, 36418, 36405, 36400, 36404, 36426, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 36423, 36425, 36428, 36432, 36424, 36441, 36452,
				36448, 36394, 36451, 36437, 36470, 36466, 36476, 36481, 36487, 36485, 36484, 36491, 36490, 36499, 36497, 36500,
				36505, 36522, 36513, 36524, 36528, 36550, 36529, 36542, 36549, 36552, 36555, 36571, 36579, 36604, 36603, 36587,
				36606, 36618, 36613, 36629, 36626, 36633, 36627, 36636, 36639, 36635, 36620, 36646, 36659, 36667, 36665, 36677,
				36674, 36670, 36684, 36681, 36678, 36686, 36695, 36700, 36706, 36707, 36708, 36764, 36767, 36771, 36781, 36783,
				36791, 36826, 36837, 36834, 36842, 36847, 36999, 36852, 36869, 36857, 36858, 36881, 36885, 36897, 36877, 36894,
				36886, 36875, 36903, 36918, 36917, 36921, 36856, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 36943, 36944, 36945, 36946, 36878, 36937, 36926, 36950,
				36952, 36958, 36968, 36975, 36982, 38568, 36978, 36994, 36989, 36993, 36992, 37002, 37001, 37007, 37032, 37039,
				37041, 37045, 37090, 37092, 25160, 37083, 37122, 37138, 37145, 37170, 37168, 37194, 37206, 37208, 37219, 37221,
				37225, 37235, 37234, 37259, 37257, 37250, 37282, 37291, 37295, 37290, 37301, 37300, 37306, 37312, 37313, 37321,
				37323, 37328, 37334, 37343, 37345, 37339, 37372, 37365, 37366, 37406, 37375, 37396, 37420, 37397, 37393, 37470,
				37463, 37445, 37449, 37476, 37448, 37525, 37439, 37451, 37456, 37532, 37526, 37523, 37531, 37466, 37583, 37561,
				37559, 37609, 37647, 37626, 37700, 37678, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 37657, 37666, 37658, 37667, 37690, 37685, 37691, 37724, 37728,
				37756, 37742, 37718, 37808, 37804, 37805, 37780, 37817, 37846, 37847, 37864, 37861, 37848, 37827, 37853, 37840,
				37832, 37860, 37914, 37908, 37907, 37891, 37895, 37904, 37942, 37931, 37941, 37921, 37946, 37953, 37970, 37956,
				37979, 37984, 37986, 37982, 37994, 37417, 38000, 38005, 38007, 38013, 37978, 38012, 38014, 38017, 38015, 38274,
				38279, 38282, 38292, 38294, 38296, 38297, 38304, 38312, 38311, 38317, 38332, 38331, 38329, 38334, 38346, 28662,
				38339, 38349, 38348, 38357, 38356, 38358, 38364, 38369, 38373, 38370, 38433, 38440, 38446, 38447, 38466, 38476,
				38479, 38475, 38519, 38492, 38494, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 38493, 38495, 38502, 38514, 38508, 38541, 38552, 38549, 38551, 38570,
				38567, 38577, 38578, 38576, 38580, 38582, 38584, 38585, 38606, 38603, 38601, 38605, 35149, 38620, 38669, 38613,
				38649, 38660, 38662, 38664, 38675, 38670, 38673, 38671, 38678, 38681, 38692, 38698, 38704, 38713, 38717, 38718,
				38724, 38726, 38728, 38722, 38729, 38748, 38752, 38756, 38758, 38760, 21202, 38763, 38769, 38777, 38789, 38780,
				38785, 38778, 38790, 38795, 38799, 38800, 38812, 38824, 38822, 38819, 38835, 38836, 38851, 38854, 38856, 38859,
				38876, 38893, 40783, 38898, 31455, 38902, 38901, 38927, 38924, 38968, 38948, 38945, 38967, 38973, 38982, 38991,
				38987, 39019, 39023, 39024, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 39025, 39028, 39027, 39082, 39087, 39089, 39094, 39108, 39107, 39110, 39145,
				39147, 39171, 39177, 39186, 39188, 39192, 39201, 39197, 39198, 39204, 39200, 39212, 39214, 39229, 39230, 39234,
				39241, 39237, 39248, 39243, 39249, 39250, 39244, 39253, 39319, 39320, 39333, 39341, 39342, 39356, 39391, 39387,
				39389, 39384, 39377, 39405, 39406, 39409, 39410, 39419, 39416, 39425, 39439, 39429, 39394, 39449, 39467, 39479,
				39493, 39490, 39488, 39491, 39486, 39509, 39501, 39515, 39511, 39519, 39522, 39525, 39524, 39529, 39531, 39530,
				39597, 39600, 39612, 39616, 39631, 39633, 39635, 39636, 39646, 39647, 39650, 39651, 39654, 39663, 39659, 39662,
				39668, 39665, 39671, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 39675, 39686, 39704, 39706, 39711, 39714, 39715, 39717, 39719, 39720, 39721, 39722,
				39726, 39727, 39730, 39748, 39747, 39759, 39757, 39758, 39761, 39768, 39796, 39827, 39811, 39825, 39830, 39831,
				39839, 39840, 39848, 39860, 39872, 39882, 39865, 39878, 39887, 39889, 39890, 39907, 39906, 39908, 39892, 39905,
				39994, 39922, 39921, 39920, 39957, 39956, 39945, 39955, 39948, 39942, 39944, 39954, 39946, 39940, 39982, 39963,
				39973, 39972, 39969, 39984, 40007, 39986, 40006, 39998, 40026, 40032, 40039, 40054, 40056, 40167, 40172, 40176,
				40201, 40200, 40171, 40195, 40198, 40234, 40230, 40367, 40227, 40223, 40260, 40213, 40210, 40257, 40255, 40254,
				40262, 40264, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 40285, 40286, 40292, 40273, 40272, 40281, 40306, 40329, 40327, 40363, 40303, 40314, 40346,
				40356, 40361, 40370, 40388, 40385, 40379, 40376, 40378, 40390, 40399, 40386, 40409, 40403, 40440, 40422, 40429,
				40431, 40445, 40474, 40475, 40478, 40565, 40569, 40573, 40577, 40584, 40587, 40588, 40594, 40597, 40593, 40605,
				40613, 40617, 40632, 40618, 40621, 38753, 40652, 40654, 40655, 40656, 40660, 40668, 40670, 40669, 40672, 40677,
				40680, 40687, 40692, 40694, 40695, 40697, 40699, 40700, 40701, 40711, 40712, 30391, 40725, 40737, 40748, 40766,
				40778, 40786, 40788, 40803, 40799, 40800, 40801, 40806, 40807, 40812, 40810, 40823, 40818, 40822, 40853, 40860,
				40864, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 22575, 27079, 36953, 29796, 20956, 29081, 234, 21322, 18771, 8276, 20256, 21844, 17970, 65535,
				65535, 65535, 65535, 65535, 32905, 65535, 65535, 23130, 65535, 272, 65535, 65535, 65535, 32899, 32783, 27768,
				26485, 29490, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 32768, 32768, 32768, 32768,
				32783, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535,
				65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
				234, 234, 234, 234, 234, 234, 65535,
			},
			eBuffer: map[int]int{
				0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14, 15: 15,
				16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26, 27: 27, 28: 28, 29: 29, 30: 30, 31: 31,
				32: 32, 33: 33, 34: 34, 35: 35, 36: 36, 37: 37, 38: 38, 39: 39, 40: 40, 41: 41, 42: 42, 43: 43, 44: 44, 45: 45, 46: 46, 47: 47,
				48: 48, 49: 49, 50: 50, 51: 51, 52: 52, 53: 53, 54: 54, 55: 55, 56: 56, 57: 57, 58: 58, 59: 59, 60: 60, 61: 61, 62: 62, 63: 63,
				64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71, 72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79,
				80: 80, 81: 81, 82: 82, 83: 83, 84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89, 90: 90, 91: 91, 92: 92, 93: 93, 94: 94, 95: 95,
				96: 96, 97: 97, 98: 98, 99: 99, 100: 100, 101: 101, 102: 102, 103: 103, 104: 104, 105: 105, 106: 106, 107: 107, 108: 108, 109: 109, 110: 110, 111: 111,
				112: 112, 113: 113, 114: 114, 115: 115, 116: 116, 117: 117, 118: 118, 119: 119, 120: 120, 121: 121, 122: 122, 123: 123, 124: 124, 125: 125, 126: 126, 127: 127,
				12288: 41377, 12289: 41378, 12290: 41379, 65292: 41380, 65294: 41381, 12539: 41382, 65306: 41383, 65307: 41384, 65311: 41385, 65281: 41386, 12443: 41387, 12444: 41388, 180: 41389, 65344: 41390, 168: 41391, 65342: 41392,
				8254: 41393, 65343: 41394, 12541: 41395, 12542: 41396, 12445: 41397, 12446: 41398, 12291: 41399, 20189: 41400, 12293: 41401, 12294: 41402, 12295: 41403, 12540: 41404, 8213: 41405, 173: 41406, 65295: 41407, 65340: 41408,
				65374: 41409, 8741: 41410, 65372: 41411, 8230: 41412, 8229: 41413, 8216: 41414, 8217: 41415, 8220: 41416, 8221: 41417, 65288: 41418, 65289: 41419, 12308: 41420, 12309: 41421, 65339: 41422, 65341: 41423, 65371: 41424,
				65373: 41425, 12296: 41426, 12297: 41427, 12298: 41428, 12299: 41429, 12300: 41430, 12301: 41431, 12302: 41432, 12303: 41433, 12304: 41434, 12305: 41435, 65291: 41436, 65293: 41437, 177: 41438, 215: 41439, 247: 41440,
				65309: 41441, 8800: 41442, 65308: 41443, 65310: 41444, 8804: 41445, 8805: 41446, 8734: 41447, 8756: 41448, 9794: 41449, 9792: 41450, 176: 41451, 8242: 41452, 8243: 41453, 8451: 41454, 165: 41455, 65284: 41456,
				162: 41457, 163: 41458, 65285: 41459, 65283: 41460, 65286: 41461, 65290: 41462, 65312: 41463, 167: 41464, 9734: 41465, 9733: 41466, 9675: 41467, 9679: 41468, 9678: 41469, 9671: 41470, 9670: 41633, 9633: 41634,
				9632: 41635, 9651: 41636, 9650: 41637, 9661: 41638, 9660: 41639, 8251: 41640, 12306: 41641, 8594: 41642, 8592: 41643, 8593: 41644, 8595: 41645, 12307: 41646, 8712: 41658, 8715: 41659, 8838: 41660, 8839: 41661,
				8834: 41662, 8835: 41663, 8746: 41664, 8745: 41665, 8743: 41674, 8744: 41675, 172: 41676, 8658: 41677, 8660: 41678, 8704: 41679, 8707: 41680, 8736: 41692, 8869: 41693, 8256: 41694, 8706: 41695, 8711: 41696,
				8801: 41697, 8786: 41698, 8810: 41699, 8811: 41700, 8730: 41701, 8780: 41702, 8733: 41703, 8757: 41704, 8747: 41705, 8748: 41706, 8491: 41714, 8240: 41715, 9839: 41716, 9837: 41717, 9834: 41718, 8224: 41719,
				8225: 41720, 182: 41721, 8413: 41726, 65296: 41904, 65297: 41905, 65298: 41906, 65299: 41907, 65300: 41908, 65301: 41909, 65302: 41910, 65303: 41911, 65304: 41912, 65305: 41913, 65313: 41921, 65314: 41922, 65315: 41923,
				65316: 41924, 65317: 41925, 65318: 41926, 65319: 41927, 65320: 41928, 65321: 41929, 65322: 41930, 65323: 41931, 65324: 41932, 65325: 41933, 65326: 41934, 65327: 41935, 65328: 41936, 65329: 41937, 65330: 41938, 65331: 41939,
				65332: 41940, 65333: 41941, 65334: 41942, 65335: 41943, 65336: 41944, 65337: 41945, 65338: 41946, 65345: 41953, 65346: 41954, 65347: 41955, 65348: 41956, 65349: 41957, 65350: 41958, 65351: 41959, 65352: 41960, 65353: 41961,
				65354: 41962, 65355: 41963, 65356: 41964, 65357: 41965, 65358: 41966, 65359: 41967, 65360: 41968, 65361: 41969, 65362: 41970, 65363: 41971, 65364: 41972, 65365: 41973, 65366: 41974, 65367: 41975, 65368: 41976, 65369: 41977,
				65370: 41978, 12353: 42145, 12354: 42146, 12355: 42147, 12356: 42148, 12357: 42149, 12358: 42150, 12359: 42151, 12360: 42152, 12361: 42153, 12362: 42154, 12363: 42155, 12364: 42156, 12365: 42157, 12366: 42158, 12367: 42159,
				12368: 42160, 12369: 42161, 12370: 42162, 12371: 42163, 12372: 42164, 12373: 42165, 12374: 42166, 12375: 42167, 12376: 42168, 12377: 42169, 12378: 42170, 12379: 42171, 12380: 42172, 12381: 42173, 12382: 42174, 12383: 42175,
				12384: 42176, 12385: 42177, 12386: 42178, 12387: 42179, 12388: 42180, 12389: 42181, 12390: 42182, 12391: 42183, 12392: 42184, 12393: 42185, 12394: 42186, 12395: 42187, 12396: 42188, 12397: 42189, 12398: 42190, 12399: 42191,
				12400: 42192, 12401: 42193, 12402: 42194, 12403: 42195, 12404: 42196, 12405: 42197, 12406: 42198, 12407: 42199, 12408: 42200, 12409: 42201, 12410: 42202, 12411: 42203, 12412: 42204, 12413: 42205, 12414: 42206, 12415: 42207,
				12416: 42208, 12417: 42209, 12418: 42210, 12419: 42211, 12420: 42212, 12421: 42213, 12422: 42214, 12423: 42215, 12424: 42216, 12425: 42217, 12426: 42218, 12427: 42219, 12428: 42220, 12429: 42221, 12430: 42222, 12431: 42223,
				12432: 42224, 12433: 42225, 12434: 42226, 12435: 42227, 12449: 42401, 12450: 42402, 12451: 42403, 12452: 42404, 12453: 42405, 12454: 42406, 12455: 42407, 12456: 42408, 12457: 42409, 12458: 42410, 12459: 42411, 12460: 42412,
				12461: 42413, 12462: 42414, 12463: 42415, 12464: 42416, 12465: 42417, 12466: 42418, 12467: 42419, 12468: 42420, 12469: 42421, 12470: 42422, 12471: 42423, 12472: 42424, 12473: 42425, 12474: 42426, 12475: 42427, 12476: 42428,
				12477: 42429, 12478: 42430, 12479: 42431, 12480: 42432, 12481: 42433, 12482: 42434, 12483: 42435, 12484: 42436, 12485: 42437, 12486: 42438, 12487: 42439, 12488: 42440, 12489: 42441, 12490: 42442, 12491: 42443, 12492: 42444,
				12493: 42445, 12494: 42446, 12495: 42447, 12496: 42448, 12497: 42449, 12498: 42450, 12499: 42451, 12500: 42452, 12501: 42453, 12502: 42454, 12503: 42455, 12504: 42456, 12505: 42457, 12506: 42458, 12507: 42459, 12508: 42460,
				12509: 42461, 12510: 42462, 12511: 42463, 12512: 42464, 12513: 42465, 12514: 42466, 12515: 42467, 12516: 42468, 12517: 42469, 12518: 42470, 12519: 42471, 12520: 42472, 12521: 42473, 12522: 42474, 12523: 42475, 12524: 42476,
				12525: 42477, 12526: 42478, 12527: 42479, 12528: 42480, 12529: 42481, 12530: 42482, 12531: 42483, 12532: 42484, 12533: 42485, 12534: 42486, 913: 42657, 914: 42658, 915: 42659, 916: 42660, 917: 42661, 918: 42662,
				919: 42663, 920: 42664, 921: 42665, 922: 42666, 923: 42667, 924: 42668, 925: 42669, 926: 42670, 927: 42671, 928: 42672, 929: 42673, 931: 42674, 932: 42675, 933: 42676, 934: 42677, 935: 42678,
				936: 42679, 937: 42680, 945: 42689, 946: 42690, 947: 42691, 948: 42692, 949: 42693, 950: 42694, 951: 42695, 952: 42696, 953: 42697, 954: 42698, 955: 42699, 956: 42700, 957: 42701, 958: 42702,
				959: 42703, 960: 42704, 961: 42705, 963: 42706, 964: 42707, 965: 42708, 966: 42709, 967: 42710, 968: 42711, 969: 42712, 1040: 42913, 1041: 42914, 1042: 42915, 1043: 42916, 1044: 42917, 1045: 42918,
				1025: 42919, 1046: 42920, 1047: 42921, 1048: 42922, 1049: 42923, 1050: 42924, 1051: 42925, 1052: 42926, 1053: 42927, 1054: 42928, 1055: 42929, 1056: 42930, 1057: 42931, 1058: 42932, 1059: 42933, 1060: 42934,
				1061: 42935, 1062: 42936, 1063: 42937, 1064: 42938, 1065: 42939, 1066: 42940, 1067: 42941, 1068: 42942, 1069: 42943, 1070: 42944, 1071: 42945, 1072: 42961, 1073: 42962, 1074: 42963, 1075: 42964, 1076: 42965,
				1077: 42966, 1105: 42967, 1078: 42968, 1079: 42969, 1080: 42970, 1081: 42971, 1082: 42972, 1083: 42973, 1084: 42974, 1085: 42975, 1086: 42976, 1087: 42977, 1088: 42978, 1089: 42979, 1090: 42980, 1091: 42981,
				1092: 42982, 1093: 42983, 1094: 42984, 1095: 42985, 1096: 42986, 1097: 42987, 1098: 42988, 1099: 42989, 1100: 42990, 1101: 42991, 1102: 42992, 1103: 42993, 9472: 43169, 9474: 43170, 9484: 43171, 9488: 43172,
				9496: 43173, 9492: 43174, 9500: 43175, 9516: 43176, 9508: 43177, 9524: 43178, 9532: 43179, 9473: 43180, 9475: 43181, 9487: 43182, 9491: 43183, 9499: 43184, 9495: 43185, 9507: 43186, 9523: 43187, 9515: 43188,
				9531: 43189, 9547: 43190, 9504: 43191, 9519: 43192, 9512: 43193, 9527: 43194, 9535: 43195, 9501: 43196, 9520: 43197, 9509: 43198, 9528: 43199, 9538: 43200, 20124: 45217, 21782: 45218, 23043: 45219, 38463: 45220,
				21696: 45221, 24859: 45222, 25384: 45223, 23030: 45224, 36898: 45225, 33909: 45226, 33564: 45227, 31312: 45228, 24746: 45229, 25569: 45230, 28197: 45231, 26093: 45232, 33894: 45233, 33446: 45234, 39925: 45235, 26771: 45236,
				22311: 45237, 26017: 45238, 25201: 45239, 23451: 45240, 22992: 45241, 34427: 45242, 39156: 45243, 32098: 45244, 32190: 45245, 39822: 45246, 25110: 45247, 31903: 45248, 34999: 45249, 23433: 45250, 24245: 45251, 25353: 45252,
				26263: 45253, 26696: 45254, 38343: 45255, 38797: 45256, 26447: 45257, 20197: 45258, 20234: 45259, 20301: 45260, 20381: 45261, 20553: 45262, 22258: 45263, 22839: 45264, 22996: 45265, 23041: 45266, 23561: 45267, 24799: 45268,
				24847: 45269, 24944: 45270, 26131: 45271, 26885: 45272, 28858: 45273, 30031: 45274, 30064: 45275, 31227: 45276, 32173: 45277, 32239: 45278, 32963: 45279, 33806: 45280, 34915: 45281, 35586: 45282, 36949: 45283, 36986: 45284,
				21307: 45285, 20117: 45286, 20133: 45287, 22495: 45288, 32946: 45289, 37057: 45290, 30959: 45291, 19968: 45292, 22769: 45293, 28322: 45294, 36920: 45295, 31282: 45296, 33576: 45297, 33419: 45298, 39983: 45299, 20801: 45300,
				21360: 45301, 21693: 45302, 21729: 45303, 22240: 45304, 23035: 45305, 24341: 45306, 39154: 45307, 28139: 45308, 32996: 45309, 34093: 45310, 38498: 45473, 38512: 45474, 38560: 45475, 38907: 45476, 21515: 45477, 21491: 45478,
				23431: 45479, 28879: 45480, 32701: 45481, 36802: 45482, 38632: 45483, 21359: 45484, 40284: 45485, 31418: 45486, 19985: 45487, 30867: 45488, 33276: 45489, 28198: 45490, 22040: 45491, 21764: 45492, 27421: 45493, 34074: 45494,
				39995: 45495, 23013: 45496, 21417: 45497, 28006: 45498, 29916: 45499, 38287: 45500, 22082: 45501, 20113: 45502, 36939: 45503, 38642: 45504, 33615: 45505, 39180: 45506, 21473: 45507, 21942: 45508, 23344: 45509, 24433: 45510,
				26144: 45511, 26355: 45512, 26628: 45513, 27704: 45514, 27891: 45515, 27945: 45516, 29787: 45517, 30408: 45518, 31310: 45519, 38964: 45520, 33521: 45521, 34907: 45522, 35424: 45523, 37613: 45524, 28082: 45525, 30123: 45526,
				30410: 45527, 39365: 45528, 24742: 45529, 35585: 45530, 36234: 45531, 38322: 45532, 27022: 45533, 21421: 45534, 20870: 45535, 22290: 45536, 22576: 45537, 22852: 45538, 23476: 45539, 24310: 45540, 24616: 45541, 25513: 45542,
				25588: 45543, 27839: 45544, 28436: 45545, 28814: 45546, 28948: 45547, 29017: 45548, 29141: 45549, 29503: 45550, 32257: 45551, 33398: 45552, 33489: 45553, 34199: 45554, 36960: 45555, 37467: 45556, 40219: 45557, 22633: 45558,
				26044: 45559, 27738: 45560, 29989: 45561, 20985: 45562, 22830: 45563, 22885: 45564, 24448: 45565, 24540: 45566, 25276: 45729, 26106: 45730, 27178: 45731, 27431: 45732, 27572: 45733, 29579: 45734, 32705: 45735, 35158: 45736,
				40236: 45737, 40206: 45738, 40644: 45739, 23713: 45740, 27798: 45741, 33659: 45742, 20740: 45743, 23627: 45744, 25014: 45745, 33222: 45746, 26742: 45747, 29281: 45748, 20057: 45749, 20474: 45750, 21368: 45751, 24681: 45752,
				28201: 45753, 31311: 45754, 38899: 45755, 19979: 45756, 21270: 45757, 20206: 45758, 20309: 45759, 20285: 45760, 20385: 45761, 20339: 45762, 21152: 45763, 21487: 45764, 22025: 45765, 22799: 45766, 23233: 45767, 23478: 45768,
				23521: 45769, 31185: 45770, 26247: 45771, 26524: 45772, 26550: 45773, 27468: 45774, 27827: 45775, 28779: 45776, 29634: 45777, 31117: 45778, 31166: 45779, 31292: 45780, 31623: 45781, 33457: 45782, 33499: 45783, 33540: 45784,
				33655: 45785, 33775: 45786, 33747: 45787, 34662: 45788, 35506: 45789, 22057: 45790, 36008: 45791, 36838: 45792, 36942: 45793, 38686: 45794, 34442: 45795, 20420: 45796, 23784: 45797, 25105: 45798, 29273: 45799, 30011: 45800,
				33253: 45801, 33469: 45802, 34558: 45803, 36032: 45804, 38597: 45805, 39187: 45806, 39381: 45807, 20171: 45808, 20250: 45809, 35299: 45810, 22238: 45811, 22602: 45812, 22730: 45813, 24315: 45814, 24555: 45815, 24618: 45816,
				24724: 45817, 24674: 45818, 25040: 45819, 25106: 45820, 25296: 45821, 25913: 45822, 39745: 45985, 26214: 45986, 26800: 45987, 28023: 45988, 28784: 45989, 30028: 45990, 30342: 45991, 32117: 45992, 33445: 45993, 34809: 45994,
				38283: 45995, 38542: 45996, 35997: 45997, 20977: 45998, 21182: 45999, 22806: 46000, 21683: 46001, 23475: 46002, 23830: 46003, 24936: 46004, 27010: 46005, 28079: 46006, 30861: 46007, 33995: 46008, 34903: 46009, 35442: 46010,
				37799: 46011, 39608: 46012, 28012: 46013, 39336: 46014, 34521: 46015, 22435: 46016, 26623: 46017, 34510: 46018, 37390: 46019, 21123: 46020, 22151: 46021, 21508: 46022, 24275: 46023, 25313: 46024, 25785: 46025, 26684: 46026,
				26680: 46027, 27579: 46028, 29554: 46029, 30906: 46030, 31339: 46031, 35226: 46032, 35282: 46033, 36203: 46034, 36611: 46035, 37101: 46036, 38307: 46037, 38548: 46038, 38761: 46039, 23398: 46040, 23731: 46041, 27005: 46042,
				38989: 46043, 38990: 46044, 25499: 46045, 31520: 46046, 27179: 46047, 27263: 46048, 26806: 46049, 39949: 46050, 28511: 46051, 21106: 46052, 21917: 46053, 24688: 46054, 25324: 46055, 27963: 46056, 28167: 46057, 28369: 46058,
				33883: 46059, 35088: 46060, 36676: 46061, 19988: 46062, 39993: 46063, 21494: 46064, 26907: 46065, 27194: 46066, 38788: 46067, 26666: 46068, 20828: 46069, 31427: 46070, 33970: 46071, 37340: 46072, 37772: 46073, 22107: 46074,
				40232: 46075, 26658: 46076, 33541: 46077, 33841: 46078, 31909: 46241, 21000: 46242, 33477: 46243, 29926: 46244, 20094: 46245, 20355: 46246, 20896: 46247, 23506: 46248, 21002: 46249, 21208: 46250, 21223: 46251, 24059: 46252,
				21914: 46253, 22570: 46254, 23014: 46255, 23436: 46256, 23448: 46257, 23515: 46258, 24178: 46259, 24185: 46260, 24739: 46261, 24863: 46262, 24931: 46263, 25022: 46264, 25563: 46265, 25954: 46266, 26577: 46267, 26707: 46268,
				26874: 46269, 27454: 46270, 27475: 46271, 27735: 46272, 28450: 46273, 28567: 46274, 28485: 46275, 29872: 46276, 29976: 46277, 30435: 46278, 30475: 46279, 31487: 46280, 31649: 46281, 31777: 46282, 32233: 46283, 32566: 46284,
				32752: 46285, 32925: 46286, 33382: 46287, 33694: 46288, 35251: 46289, 35532: 46290, 36011: 46291, 36996: 46292, 37969: 46293, 38291: 46294, 38289: 46295, 38306: 46296, 38501: 46297, 38867: 46298, 39208: 46299, 33304: 46300,
				20024: 46301, 21547: 46302, 23736: 46303, 24012: 46304, 29609: 46305, 30284: 46306, 30524: 46307, 23721: 46308, 32747: 46309, 36107: 46310, 38593: 46311, 38929: 46312, 38996: 46313, 39000: 46314, 20225: 46315, 20238: 46316,
				21361: 46317, 21916: 46318, 22120: 46319, 22522: 46320, 22855: 46321, 23305: 46322, 23492: 46323, 23696: 46324, 24076: 46325, 24190: 46326, 24524: 46327, 25582: 46328, 26426: 46329, 26071: 46330, 26082: 46331, 26399: 46332,
				26827: 46333, 26820: 46334, 27231: 46497, 24112: 46498, 27589: 46499, 27671: 46500, 27773: 46501, 30079: 46502, 31048: 46503, 23395: 46504, 31232: 46505, 32000: 46506, 24509: 46507, 35215: 46508, 35352: 46509, 36020: 46510,
				36215: 46511, 36556: 46512, 36637: 46513, 39138: 46514, 39438: 46515, 39740: 46516, 20096: 46517, 20605: 46518, 20736: 46519, 22931: 46520, 23452: 46521, 25135: 46522, 25216: 46523, 25836: 46524, 27450: 46525, 29344: 46526,
				30097: 46527, 31047: 46528, 32681: 46529, 34811: 46530, 35516: 46531, 35696: 46532, 25516: 46533, 33738: 46534, 38816: 46535, 21513: 46536, 21507: 46537, 21931: 46538, 26708: 46539, 27224: 46540, 35440: 46541, 30759: 46542,
				26485: 46543, 40653: 46544, 21364: 46545, 23458: 46546, 33050: 46547, 34384: 46548, 36870: 46549, 19992: 46550, 20037: 46551, 20167: 46552, 20241: 46553, 21450: 46554, 21560: 46555, 23470: 46556, 24339: 46557, 24613: 46558,
				25937: 46559, 26429: 46560, 27714: 46561, 27762: 46562, 27875: 46563, 28792: 46564, 29699: 46565, 31350: 46566, 31406: 46567, 31496: 46568, 32026: 46569, 31998: 46570, 32102: 46571, 26087: 46572, 29275: 46573, 21435: 46574,
				23621: 46575, 24040: 46576, 25298: 46577, 25312: 46578, 25369: 46579, 28192: 46580, 34394: 46581, 35377: 46582, 36317: 46583, 37624: 46584, 28417: 46585, 31142: 46586, 39770: 46587, 20136: 46588, 20139: 46589, 20140: 46590,
				20379: 46753, 20384: 46754, 20689: 46755, 20807: 46756, 31478: 46757, 20849: 46758, 20982: 46759, 21332: 46760, 21281: 46761, 21375: 46762, 21483: 46763, 21932: 46764, 22659: 46765, 23777: 46766, 24375: 46767, 24394: 46768,
				24623: 46769, 24656: 46770, 24685: 46771, 25375: 46772, 25945: 46773, 27211: 46774, 27841: 46775, 29378: 46776, 29421: 46777, 30703: 46778, 33016: 46779, 33029: 46780, 33288: 46781, 34126: 46782, 37111: 46783, 37857: 46784,
				38911: 46785, 39255: 46786, 39514: 46787, 20208: 46788, 20957: 46789, 23597: 46790, 26241: 46791, 26989: 46792, 23616: 46793, 26354: 46794, 26997: 46795, 29577: 46796, 26704: 46797, 31873: 46798, 20677: 46799, 21220: 46800,
				22343: 46801, 24062: 46802, 37670: 46803, 26020: 46804, 27427: 46805, 27453: 46806, 29748: 46807, 31105: 46808, 31165: 46809, 31563: 46810, 32202: 46811, 33465: 46812, 33740: 46813, 34943: 46814, 35167: 46815, 35641: 46816,
				36817: 46817, 37329: 46818, 21535: 46819, 37504: 46820, 20061: 46821, 20534: 46822, 21477: 46823, 21306: 46824, 29399: 46825, 29590: 46826, 30697: 46827, 33510: 46828, 36527: 46829, 39366: 46830, 39368: 46831, 39378: 46832,
				20855: 46833, 24858: 46834, 34398: 46835, 21936: 46836, 31354: 46837, 20598: 46838, 23507: 46839, 36935: 46840, 38533: 46841, 20018: 46842, 27355: 46843, 37351: 46844, 23633: 46845, 23624: 46846, 25496: 47009, 31391: 47010,
				27795: 47011, 38772: 47012, 36705: 47013, 31402: 47014, 29066: 47015, 38536: 47016, 31874: 47017, 26647: 47018, 32368: 47019, 26705: 47020, 37740: 47021, 21234: 47022, 21531: 47023, 34219: 47024, 35347: 47025, 32676: 47026,
				36557: 47027, 37089: 47028, 21350: 47029, 34952: 47030, 31041: 47031, 20418: 47032, 20670: 47033, 21009: 47034, 20804: 47035, 21843: 47036, 22317: 47037, 29674: 47038, 22411: 47039, 22865: 47040, 24418: 47041, 24452: 47042,
				24693: 47043, 24950: 47044, 24935: 47045, 25001: 47046, 25522: 47047, 25658: 47048, 25964: 47049, 26223: 47050, 26690: 47051, 28179: 47052, 30054: 47053, 31293: 47054, 31995: 47055, 32076: 47056, 32153: 47057, 32331: 47058,
				32619: 47059, 33550: 47060, 33610: 47061, 34509: 47062, 35336: 47063, 35427: 47064, 35686: 47065, 36605: 47066, 38938: 47067, 40335: 47068, 33464: 47069, 36814: 47070, 39912: 47071, 21127: 47072, 25119: 47073, 25731: 47074,
				28608: 47075, 38553: 47076, 26689: 47077, 20625: 47078, 27424: 47079, 27770: 47080, 28500: 47081, 31348: 47082, 32080: 47083, 34880: 47084, 35363: 47085, 26376: 47086, 20214: 47087, 20537: 47088, 20518: 47089, 20581: 47090,
				20860: 47091, 21048: 47092, 21091: 47093, 21927: 47094, 22287: 47095, 22533: 47096, 23244: 47097, 24314: 47098, 25010: 47099, 25080: 47100, 25331: 47101, 25458: 47102, 26908: 47265, 27177: 47266, 29309: 47267, 29356: 47268,
				29486: 47269, 30740: 47270, 30831: 47271, 32121: 47272, 30476: 47273, 32937: 47274, 35211: 47275, 35609: 47276, 36066: 47277, 36562: 47278, 36963: 47279, 37749: 47280, 38522: 47281, 38997: 47282, 39443: 47283, 40568: 47284,
				20803: 47285, 21407: 47286, 21427: 47287, 24187: 47288, 24358: 47289, 28187: 47290, 28304: 47291, 29572: 47292, 29694: 47293, 32067: 47294, 33335: 47295, 35328: 47296, 35578: 47297, 38480: 47298, 20046: 47299, 20491: 47300,
				21476: 47301, 21628: 47302, 22266: 47303, 22993: 47304, 23396: 47305, 24049: 47306, 24235: 47307, 24359: 47308, 25144: 47309, 25925: 47310, 26543: 47311, 28246: 47312, 29392: 47313, 31946: 47314, 34996: 47315, 32929: 47316,
				32993: 47317, 33776: 47318, 34382: 47319, 35463: 47320, 36328: 47321, 37431: 47322, 38599: 47323, 39015: 47324, 40723: 47325, 20116: 47326, 20114: 47327, 20237: 47328, 21320: 47329, 21577: 47330, 21566: 47331, 23087: 47332,
				24460: 47333, 24481: 47334, 24735: 47335, 26791: 47336, 27278: 47337, 29786: 47338, 30849: 47339, 35486: 47340, 35492: 47341, 35703: 47342, 37264: 47343, 20062: 47344, 39881: 47345, 20132: 47346, 20348: 47347, 20399: 47348,
				20505: 47349, 20502: 47350, 20809: 47351, 20844: 47352, 21151: 47353, 21177: 47354, 21246: 47355, 21402: 47356, 21475: 47357, 21521: 47358, 21518: 47521, 21897: 47522, 22353: 47523, 22434: 47524, 22909: 47525, 23380: 47526,
				23389: 47527, 23439: 47528, 24037: 47529, 24039: 47530, 24055: 47531, 24184: 47532, 24195: 47533, 24218: 47534, 24247: 47535, 24344: 47536, 24658: 47537, 24908: 47538, 25239: 47539, 25304: 47540, 25511: 47541, 25915: 47542,
				26114: 47543, 26179: 47544, 26356: 47545, 26477: 47546, 26657: 47547, 26775: 47548, 27083: 47549, 27743: 47550, 27946: 47551, 28009: 47552, 28207: 47553, 28317: 47554, 30002: 47555, 30343: 47556, 30828: 47557, 31295: 47558,
				31968: 47559, 32005: 47560, 32024: 47561, 32094: 47562, 32177: 47563, 32789: 47564, 32771: 47565, 32943: 47566, 32945: 47567, 33108: 47568, 33167: 47569, 33322: 47570, 33618: 47571, 34892: 47572, 34913: 47573, 35611: 47574,
				36002: 47575, 36092: 47576, 37066: 47577, 37237: 47578, 37489: 47579, 30783: 47580, 37628: 47581, 38308: 47582, 38477: 47583, 38917: 47584, 39321: 47585, 39640: 47586, 40251: 47587, 21083: 47588, 21163: 47589, 21495: 47590,
				21512: 47591, 22741: 47592, 25335: 47593, 28640: 47594, 35946: 47595, 36703: 47596, 40633: 47597, 20811: 47598, 21051: 47599, 21578: 47600, 22269: 47601, 31296: 47602, 37239: 47603, 40288: 47604, 40658: 47605, 29508: 47606,
				28425: 47607, 33136: 47608, 29969: 47609, 24573: 47610, 24794: 47611, 39592: 47612, 29403: 47613, 36796: 47614, 27492: 47777, 38915: 47778, 20170: 47779, 22256: 47780, 22372: 47781, 22718: 47782, 23130: 47783, 24680: 47784,
				25031: 47785, 26127: 47786, 26118: 47787, 26681: 47788, 26801: 47789, 28151: 47790, 30165: 47791, 32058: 47792, 33390: 47793, 39746: 47794, 20123: 47795, 20304: 47796, 21449: 47797, 21766: 47798, 23919: 47799, 24038: 47800,
				24046: 47801, 26619: 47802, 27801: 47803, 29811: 47804, 30722: 47805, 35408: 47806, 37782: 47807, 35039: 47808, 22352: 47809, 24231: 47810, 25387: 47811, 20661: 47812, 20652: 47813, 20877: 47814, 26368: 47815, 21705: 47816,
				22622: 47817, 22971: 47818, 23472: 47819, 24425: 47820, 25165: 47821, 25505: 47822, 26685: 47823, 27507: 47824, 28168: 47825, 28797: 47826, 37319: 47827, 29312: 47828, 30741: 47829, 30758: 47830, 31085: 47831, 25998: 47832,
				32048: 47833, 33756: 47834, 35009: 47835, 36617: 47836, 38555: 47837, 21092: 47838, 22312: 47839, 26448: 47840, 32618: 47841, 36001: 47842, 20916: 47843, 22338: 47844, 38442: 47845, 22586: 47846, 27018: 47847, 32948: 47848,
				21682: 47849, 23822: 47850, 22524: 47851, 30869: 47852, 40442: 47853, 20316: 47854, 21066: 47855, 21643: 47856, 25662: 47857, 26152: 47858, 26388: 47859, 26613: 47860, 31364: 47861, 31574: 47862, 32034: 47863, 37679: 47864,
				26716: 47865, 39853: 47866, 31545: 47867, 21273: 47868, 20874: 47869, 21047: 47870, 23519: 48033, 25334: 48034, 25774: 48035, 25830: 48036, 26413: 48037, 27578: 48038, 34217: 48039, 38609: 48040, 30352: 48041, 39894: 48042,
				25420: 48043, 37638: 48044, 39851: 48045, 30399: 48046, 26194: 48047, 19977: 48048, 20632: 48049, 21442: 48050, 23665: 48051, 24808: 48052, 25746: 48053, 25955: 48054, 26719: 48055, 29158: 48056, 29642: 48057, 29987: 48058,
				31639: 48059, 32386: 48060, 34453: 48061, 35715: 48062, 36059: 48063, 37240: 48064, 39184: 48065, 26028: 48066, 26283: 48067, 27531: 48068, 20181: 48069, 20180: 48070, 20282: 48071, 20351: 48072, 21050: 48073, 21496: 48074,
				21490: 48075, 21987: 48076, 22235: 48077, 22763: 48078, 22987: 48079, 22985: 48080, 23039: 48081, 23376: 48082, 23629: 48083, 24066: 48084, 24107: 48085, 24535: 48086, 24605: 48087, 25351: 48088, 25903: 48089, 23388: 48090,
				26031: 48091, 26045: 48092, 26088: 48093, 26525: 48094, 27490: 48095, 27515: 48096, 27663: 48097, 29509: 48098, 31049: 48099, 31169: 48100, 31992: 48101, 32025: 48102, 32043: 48103, 32930: 48104, 33026: 48105, 33267: 48106,
				35222: 48107, 35422: 48108, 35433: 48109, 35430: 48110, 35468: 48111, 35566: 48112, 36039: 48113, 36060: 48114, 38604: 48115, 39164: 48116, 27503: 48117, 20107: 48118, 20284: 48119, 20365: 48120, 20816: 48121, 23383: 48122,
				23546: 48123, 24904: 48124, 25345: 48125, 26178: 48126, 27425: 48289, 28363: 48290, 27835: 48291, 29246: 48292, 29885: 48293, 30164: 48294, 30913: 48295, 31034: 48296, 32780: 48297, 32819: 48298, 33258: 48299, 33940: 48300,
				36766: 48301, 27728: 48302, 40575: 48303, 24335: 48304, 35672: 48305, 40235: 48306, 31482: 48307, 36600: 48308, 23437: 48309, 38635: 48310, 19971: 48311, 21489: 48312, 22519: 48313, 22833: 48314, 23241: 48315, 23460: 48316,
				24713: 48317, 28287: 48318, 28422: 48319, 30142: 48320, 36074: 48321, 23455: 48322, 34048: 48323, 31712: 48324, 20594: 48325, 26612: 48326, 33437: 48327, 23649: 48328, 34122: 48329, 32286: 48330, 33294: 48331, 20889: 48332,
				23556: 48333, 25448: 48334, 36198: 48335, 26012: 48336, 29038: 48337, 31038: 48338, 32023: 48339, 32773: 48340, 35613: 48341, 36554: 48342, 36974: 48343, 34503: 48344, 37034: 48345, 20511: 48346, 21242: 48347, 23610: 48348,
				26451: 48349, 28796: 48350, 29237: 48351, 37196: 48352, 37320: 48353, 37675: 48354, 33509: 48355, 23490: 48356, 24369: 48357, 24825: 48358, 20027: 48359, 21462: 48360, 23432: 48361, 25163: 48362, 26417: 48363, 27530: 48364,
				29417: 48365, 29664: 48366, 31278: 48367, 33131: 48368, 36259: 48369, 37202: 48370, 39318: 48371, 20754: 48372, 21463: 48373, 21610: 48374, 23551: 48375, 25480: 48376, 27193: 48377, 32172: 48378, 38656: 48379, 22234: 48380,
				21454: 48381, 21608: 48382, 23447: 48545, 23601: 48546, 24030: 48547, 20462: 48548, 24833: 48549, 25342: 48550, 27954: 48551, 31168: 48552, 31179: 48553, 32066: 48554, 32333: 48555, 32722: 48556, 33261: 48557, 33311: 48558,
				33936: 48559, 34886: 48560, 35186: 48561, 35728: 48562, 36468: 48563, 36655: 48564, 36913: 48565, 37195: 48566, 37228: 48567, 38598: 48568, 37276: 48569, 20160: 48570, 20303: 48571, 20805: 48572, 21313: 48573, 24467: 48574,
				25102: 48575, 26580: 48576, 27713: 48577, 28171: 48578, 29539: 48579, 32294: 48580, 37325: 48581, 37507: 48582, 21460: 48583, 22809: 48584, 23487: 48585, 28113: 48586, 31069: 48587, 32302: 48588, 31899: 48589, 22654: 48590,
				29087: 48591, 20986: 48592, 34899: 48593, 36848: 48594, 20426: 48595, 23803: 48596, 26149: 48597, 30636: 48598, 31459: 48599, 33308: 48600, 39423: 48601, 20934: 48602, 24490: 48603, 26092: 48604, 26991: 48605, 27529: 48606,
				28147: 48607, 28310: 48608, 28516: 48609, 30462: 48610, 32020: 48611, 24033: 48612, 36981: 48613, 37255: 48614, 38918: 48615, 20966: 48616, 21021: 48617, 25152: 48618, 26257: 48619, 26329: 48620, 28186: 48621, 24246: 48622,
				32210: 48623, 32626: 48624, 26360: 48625, 34223: 48626, 34295: 48627, 35576: 48628, 21161: 48629, 21465: 48630, 22899: 48631, 24207: 48632, 24464: 48633, 24661: 48634, 37604: 48635, 38500: 48636, 20663: 48637, 20767: 48638,
				21213: 48801, 21280: 48802, 21319: 48803, 21484: 48804, 21736: 48805, 21830: 48806, 21809: 48807, 22039: 48808, 22888: 48809, 22974: 48810, 23100: 48811, 23477: 48812, 23558: 48813, 23567: 48814, 23569: 48815, 23578: 48816,
				24196: 48817, 24202: 48818, 24288: 48819, 24432: 48820, 25215: 48821, 25220: 48822, 25307: 48823, 25484: 48824, 25463: 48825, 26119: 48826, 26124: 48827, 26157: 48828, 26230: 48829, 26494: 48830, 26786: 48831, 27167: 48832,
				27189: 48833, 27836: 48834, 28040: 48835, 28169: 48836, 28248: 48837, 28988: 48838, 28966: 48839, 29031: 48840, 30151: 48841, 30465: 48842, 30813: 48843, 30977: 48844, 31077: 48845, 31216: 48846, 31456: 48847, 31505: 48848,
				31911: 48849, 32057: 48850, 32918: 48851, 33750: 48852, 33931: 48853, 34121: 48854, 34909: 48855, 35059: 48856, 35359: 48857, 35388: 48858, 35412: 48859, 35443: 48860, 35937: 48861, 36062: 48862, 37284: 48863, 37478: 48864,
				37758: 48865, 37912: 48866, 38556: 48867, 38808: 48868, 19978: 48869, 19976: 48870, 19998: 48871, 20055: 48872, 20887: 48873, 21104: 48874, 22478: 48875, 22580: 48876, 22732: 48877, 23330: 48878, 24120: 48879, 24773: 48880,
				25854: 48881, 26465: 48882, 26454: 48883, 27972: 48884, 29366: 48885, 30067: 48886, 31331: 48887, 33976: 48888, 35698: 48889, 37304: 48890, 37664: 48891, 22065: 48892, 22516: 48893, 39166: 48894, 25325: 49057, 26893: 49058,
				27542: 49059, 29165: 49060, 32340: 49061, 32887: 49062, 33394: 49063, 35302: 49064, 39135: 49065, 34645: 49066, 36785: 49067, 23611: 49068, 20280: 49069, 20449: 49070, 20405: 49071, 21767: 49072, 23072: 49073, 23517: 49074,
				23529: 49075, 24515: 49076, 24910: 49077, 25391: 49078, 26032: 49079, 26187: 49080, 26862: 49081, 27035: 49082, 28024: 49083, 28145: 49084, 30003: 49085, 30137: 49086, 30495: 49087, 31070: 49088, 31206: 49089, 32051: 49090,
				33251: 49091, 33455: 49092, 34218: 49093, 35242: 49094, 35386: 49095, 36523: 49096, 36763: 49097, 36914: 49098, 37341: 49099, 38663: 49100, 20154: 49101, 20161: 49102, 20995: 49103, 22645: 49104, 22764: 49105, 23563: 49106,
				29978: 49107, 23613: 49108, 33102: 49109, 35338: 49110, 36805: 49111, 38499: 49112, 38765: 49113, 31525: 49114, 35535: 49115, 38920: 49116, 37218: 49117, 22259: 49118, 21416: 49119, 36887: 49120, 21561: 49121, 22402: 49122,
				24101: 49123, 25512: 49124, 27700: 49125, 28810: 49126, 30561: 49127, 31883: 49128, 32736: 49129, 34928: 49130, 36930: 49131, 37204: 49132, 37648: 49133, 37656: 49134, 38543: 49135, 29790: 49136, 39620: 49137, 23815: 49138,
				23913: 49139, 25968: 49140, 26530: 49141, 36264: 49142, 38619: 49143, 25454: 49144, 26441: 49145, 26905: 49146, 33733: 49147, 38935: 49148, 38592: 49149, 35070: 49150, 28548: 49313, 25722: 49314, 23544: 49315, 19990: 49316,
				28716: 49317, 30045: 49318, 26159: 49319, 20932: 49320, 21046: 49321, 21218: 49322, 22995: 49323, 24449: 49324, 24615: 49325, 25104: 49326, 25919: 49327, 25972: 49328, 26143: 49329, 26228: 49330, 26866: 49331, 26646: 49332,
				27491: 49333, 28165: 49334, 29298: 49335, 29983: 49336, 30427: 49337, 31934: 49338, 32854: 49339, 22768: 49340, 35069: 49341, 35199: 49342, 35488: 49343, 35475: 49344, 35531: 49345, 36893: 49346, 37266: 49347, 38738: 49348,
				38745: 49349, 25993: 49350, 31246: 49351, 33030: 49352, 38587: 49353, 24109: 49354, 24796: 49355, 25114: 49356, 26021: 49357, 26132: 49358, 26512: 49359, 30707: 49360, 31309: 49361, 31821: 49362, 32318: 49363, 33034: 49364,
				36012: 49365, 36196: 49366, 36321: 49367, 36447: 49368, 30889: 49369, 20999: 49370, 25305: 49371, 25509: 49372, 25666: 49373, 25240: 49374, 35373: 49375, 31363: 49376, 31680: 49377, 35500: 49378, 38634: 49379, 32118: 49380,
				33292: 49381, 34633: 49382, 20185: 49383, 20808: 49384, 21315: 49385, 21344: 49386, 23459: 49387, 23554: 49388, 23574: 49389, 24029: 49390, 25126: 49391, 25159: 49392, 25776: 49393, 26643: 49394, 26676: 49395, 27849: 49396,
				27973: 49397, 27927: 49398, 26579: 49399, 28508: 49400, 29006: 49401, 29053: 49402, 26059: 49403, 31359: 49404, 31661: 49405, 32218: 49406, 32330: 49569, 32680: 49570, 33146: 49571, 33307: 49572, 33337: 49573, 34214: 49574,
				35438: 49575, 36046: 49576, 36341: 49577, 36984: 49578, 36983: 49579, 37549: 49580, 37521: 49581, 38275: 49582, 39854: 49583, 21069: 49584, 21892: 49585, 28472: 49586, 28982: 49587, 20840: 49588, 31109: 49589, 32341: 49590,
				33203: 49591, 31950: 49592, 22092: 49593, 22609: 49594, 23720: 49595, 25514: 49596, 26366: 49597, 26365: 49598, 26970: 49599, 29401: 49600, 30095: 49601, 30094: 49602, 30990: 49603, 31062: 49604, 31199: 49605, 31895: 49606,
				32032: 49607, 32068: 49608, 34311: 49609, 35380: 49610, 38459: 49611, 36961: 49612, 40736: 49613, 20711: 49614, 21109: 49615, 21452: 49616, 21474: 49617, 20489: 49618, 21930: 49619, 22766: 49620, 22863: 49621, 29245: 49622,
				23435: 49623, 23652: 49624, 21277: 49625, 24803: 49626, 24819: 49627, 25436: 49628, 25475: 49629, 25407: 49630, 25531: 49631, 25805: 49632, 26089: 49633, 26361: 49634, 24035: 49635, 27085: 49636, 27133: 49637, 28437: 49638,
				29157: 49639, 20105: 49640, 30185: 49641, 30456: 49642, 31379: 49643, 31967: 49644, 32207: 49645, 32156: 49646, 32865: 49647, 33609: 49648, 33624: 49649, 33900: 49650, 33980: 49651, 34299: 49652, 35013: 49653, 36208: 49654,
				36865: 49655, 36973: 49656, 37783: 49657, 38684: 49658, 39442: 49659, 20687: 49660, 22679: 49661, 24974: 49662, 33235: 49825, 34101: 49826, 36104: 49827, 36896: 49828, 20419: 49829, 20596: 49830, 21063: 49831, 21363: 49832,
				24687: 49833, 25417: 49834, 26463: 49835, 28204: 49836, 36275: 49837, 36895: 49838, 20439: 49839, 23646: 49840, 36042: 49841, 26063: 49842, 32154: 49843, 21330: 49844, 34966: 49845, 20854: 49846, 25539: 49847, 23384: 49848,
				23403: 49849, 23562: 49850, 25613: 49851, 26449: 49852, 36956: 49853, 20182: 49854, 22810: 49855, 22826: 49856, 27760: 49857, 35409: 49858, 21822: 49859, 22549: 49860, 22949: 49861, 24816: 49862, 25171: 49863, 26561: 49864,
				33333: 49865, 26965: 49866, 38464: 49867, 39364: 49868, 39464: 49869, 20307: 49870, 22534: 49871, 23550: 49872, 32784: 49873, 23729: 49874, 24111: 49875, 24453: 49876, 24608: 49877, 24907: 49878, 25140: 49879, 26367: 49880,
				27888: 49881, 28382: 49882, 32974: 49883, 33151: 49884, 33492: 49885, 34955: 49886, 36024: 49887, 36864: 49888, 36910: 49889, 38538: 49890, 40667: 49891, 39899: 49892, 20195: 49893, 21488: 49894, 22823: 49895, 31532: 49896,
				37261: 49897, 38988: 49898, 40441: 49899, 28381: 49900, 28711: 49901, 21331: 49902, 21828: 49903, 23429: 49904, 25176: 49905, 25246: 49906, 25299: 49907, 27810: 49908, 28655: 49909, 29730: 49910, 35351: 49911, 37944: 49912,
				28609: 49913, 35582: 49914, 33592: 49915, 20967: 49916, 34552: 49917, 21482: 49918, 21481: 50081, 20294: 50082, 36948: 50083, 36784: 50084, 22890: 50085, 33073: 50086, 24061: 50087, 31466: 50088, 36799: 50089, 26842: 50090,
				35895: 50091, 29432: 50092, 40008: 50093, 27197: 50094, 35504: 50095, 20025: 50096, 21336: 50097, 22022: 50098, 22374: 50099, 25285: 50100, 25506: 50101, 26086: 50102, 27470: 50103, 28129: 50104, 28251: 50105, 28845: 50106,
				30701: 50107, 31471: 50108, 31658: 50109, 32187: 50110, 32829: 50111, 32966: 50112, 34507: 50113, 35477: 50114, 37723: 50115, 22243: 50116, 22727: 50117, 24382: 50118, 26029: 50119, 26262: 50120, 27264: 50121, 27573: 50122,
				30007: 50123, 35527: 50124, 20516: 50125, 30693: 50126, 22320: 50127, 24347: 50128, 24677: 50129, 26234: 50130, 27744: 50131, 30196: 50132, 31258: 50133, 32622: 50134, 33268: 50135, 34584: 50136, 36933: 50137, 39347: 50138,
				31689: 50139, 30044: 50140, 31481: 50141, 31569: 50142, 33988: 50143, 36880: 50144, 31209: 50145, 31378: 50146, 33590: 50147, 23265: 50148, 30528: 50149, 20013: 50150, 20210: 50151, 23449: 50152, 24544: 50153, 25277: 50154,
				26172: 50155, 26609: 50156, 27880: 50157, 34411: 50158, 34935: 50159, 35387: 50160, 37198: 50161, 37619: 50162, 39376: 50163, 27159: 50164, 28710: 50165, 29482: 50166, 33511: 50167, 33879: 50168, 36015: 50169, 19969: 50170,
				20806: 50171, 20939: 50172, 21899: 50173, 23541: 50174, 24086: 50337, 24115: 50338, 24193: 50339, 24340: 50340, 24373: 50341, 24427: 50342, 24500: 50343, 25074: 50344, 25361: 50345, 26274: 50346, 26397: 50347, 28526: 50348,
				29266: 50349, 30010: 50350, 30522: 50351, 32884: 50352, 33081: 50353, 33144: 50354, 34678: 50355, 35519: 50356, 35548: 50357, 36229: 50358, 36339: 50359, 37530: 50360, 38263: 50361, 38914: 50362, 40165: 50363, 21189: 50364,
				25431: 50365, 30452: 50366, 26389: 50367, 27784: 50368, 29645: 50369, 36035: 50370, 37806: 50371, 38515: 50372, 27941: 50373, 22684: 50374, 26894: 50375, 27084: 50376, 36861: 50377, 37786: 50378, 30171: 50379, 36890: 50380,
				22618: 50381, 26626: 50382, 25524: 50383, 27131: 50384, 20291: 50385, 28460: 50386, 26584: 50387, 36795: 50388, 34086: 50389, 32180: 50390, 37716: 50391, 26943: 50392, 28528: 50393, 22378: 50394, 22775: 50395, 23340: 50396,
				32044: 50397, 29226: 50398, 21514: 50399, 37347: 50400, 40372: 50401, 20141: 50402, 20302: 50403, 20572: 50404, 20597: 50405, 21059: 50406, 35998: 50407, 21576: 50408, 22564: 50409, 23450: 50410, 24093: 50411, 24213: 50412,
				24237: 50413, 24311: 50414, 24351: 50415, 24716: 50416, 25269: 50417, 25402: 50418, 25552: 50419, 26799: 50420, 27712: 50421, 30855: 50422, 31118: 50423, 31243: 50424, 32224: 50425, 33351: 50426, 35330: 50427, 35558: 50428,
				36420: 50429, 36883: 50430, 37048: 50593, 37165: 50594, 37336: 50595, 40718: 50596, 27877: 50597, 25688: 50598, 25826: 50599, 25973: 50600, 28404: 50601, 30340: 50602, 31515: 50603, 36969: 50604, 37841: 50605, 28346: 50606,
				21746: 50607, 24505: 50608, 25764: 50609, 36685: 50610, 36845: 50611, 37444: 50612, 20856: 50613, 22635: 50614, 22825: 50615, 23637: 50616, 24215: 50617, 28155: 50618, 32399: 50619, 29980: 50620, 36028: 50621, 36578: 50622,
				39003: 50623, 28857: 50624, 20253: 50625, 27583: 50626, 28593: 50627, 30000: 50628, 38651: 50629, 20814: 50630, 21520: 50631, 22581: 50632, 22615: 50633, 22956: 50634, 23648: 50635, 24466: 50636, 26007: 50637, 26460: 50638,
				28193: 50639, 30331: 50640, 33759: 50641, 36077: 50642, 36884: 50643, 37117: 50644, 37709: 50645, 30757: 50646, 30778: 50647, 21162: 50648, 24230: 50649, 22303: 50650, 22900: 50651, 24594: 50652, 20498: 50653, 20826: 50654,
				20908: 50655, 20941: 50656, 20992: 50657, 21776: 50658, 22612: 50659, 22616: 50660, 22871: 50661, 23445: 50662, 23798: 50663, 23947: 50664, 24764: 50665, 25237: 50666, 25645: 50667, 26481: 50668, 26691: 50669, 26812: 50670,
				26847: 50671, 30423: 50672, 28120: 50673, 28271: 50674, 28059: 50675, 28783: 50676, 29128: 50677, 24403: 50678, 30168: 50679, 31095: 50680, 31561: 50681, 31572: 50682, 31570: 50683, 31958: 50684, 32113: 50685, 21040: 50686,
				33891: 50849, 34153: 50850, 34276: 50851, 35342: 50852, 35588: 50853, 35910: 50854, 36367: 50855, 36867: 50856, 36879: 50857, 37913: 50858, 38518: 50859, 38957: 50860, 39472: 50861, 38360: 50862, 20685: 50863, 21205: 50864,
				21516: 50865, 22530: 50866, 23566: 50867, 24999: 50868, 25758: 50869, 27934: 50870, 30643: 50871, 31461: 50872, 33012: 50873, 33796: 50874, 36947: 50875, 37509: 50876, 23776: 50877, 40199: 50878, 21311: 50879, 24471: 50880,
				24499: 50881, 28060: 50882, 29305: 50883, 30563: 50884, 31167: 50885, 31716: 50886, 27602: 50887, 29420: 50888, 35501: 50889, 26627: 50890, 27233: 50891, 20984: 50892, 31361: 50893, 26932: 50894, 23626: 50895, 40182: 50896,
				33515: 50897, 23493: 50898, 37193: 50899, 28702: 50900, 22136: 50901, 23663: 50902, 24775: 50903, 25958: 50904, 27788: 50905, 35930: 50906, 36929: 50907, 38931: 50908, 21585: 50909, 26311: 50910, 37389: 50911, 22856: 50912,
				37027: 50913, 20869: 50914, 20045: 50915, 20970: 50916, 34201: 50917, 35598: 50918, 28760: 50919, 25466: 50920, 37707: 50921, 26978: 50922, 39348: 50923, 32260: 50924, 30071: 50925, 21335: 50926, 26976: 50927, 36575: 50928,
				38627: 50929, 27741: 50930, 20108: 50931, 23612: 50932, 24336: 50933, 36841: 50934, 21250: 50935, 36049: 50936, 32905: 50937, 34425: 50938, 24319: 50939, 26085: 50940, 20083: 50941, 20837: 50942, 22914: 51105, 23615: 51106,
				38894: 51107, 20219: 51108, 22922: 51109, 24525: 51110, 35469: 51111, 28641: 51112, 31152: 51113, 31074: 51114, 23527: 51115, 33905: 51116, 29483: 51117, 29105: 51118, 24180: 51119, 24565: 51120, 25467: 51121, 25754: 51122,
				29123: 51123, 31896: 51124, 20035: 51125, 24316: 51126, 20043: 51127, 22492: 51128, 22178: 51129, 24745: 51130, 28611: 51131, 32013: 51132, 33021: 51133, 33075: 51134, 33215: 51135, 36786: 51136, 35223: 51137, 34468: 51138,
				24052: 51139, 25226: 51140, 25773: 51141, 35207: 51142, 26487: 51143, 27874: 51144, 27966: 51145, 29750: 51146, 30772: 51147, 23110: 51148, 32629: 51149, 33453: 51150, 39340: 51151, 20467: 51152, 24259: 51153, 25309: 51154,
				25490: 51155, 25943: 51156, 26479: 51157, 30403: 51158, 29260: 51159, 32972: 51160, 32954: 51161, 36649: 51162, 37197: 51163, 20493: 51164, 22521: 51165, 23186: 51166, 26757: 51167, 26995: 51168, 29028: 51169, 29437: 51170,
				36023: 51171, 22770: 51172, 36064: 51173, 38506: 51174, 36889: 51175, 34687: 51176, 31204: 51177, 30695: 51178, 33833: 51179, 20271: 51180, 21093: 51181, 21338: 51182, 25293: 51183, 26575: 51184, 27850: 51185, 30333: 51186,
				31636: 51187, 31893: 51188, 33334: 51189, 34180: 51190, 36843: 51191, 26333: 51192, 28448: 51193, 29190: 51194, 32283: 51195, 33707: 51196, 39361: 51197, 40614: 51198, 20989: 51361, 31665: 51362, 30834: 51363, 31672: 51364,
				32903: 51365, 31560: 51366, 27368: 51367, 24161: 51368, 32908: 51369, 30033: 51370, 30048: 51371, 20843: 51372, 37474: 51373, 28300: 51374, 30330: 51375, 37271: 51376, 39658: 51377, 20240: 51378, 32624: 51379, 25244: 51380,
				31567: 51381, 38309: 51382, 40169: 51383, 22138: 51384, 22617: 51385, 34532: 51386, 38588: 51387, 20276: 51388, 21028: 51389, 21322: 51390, 21453: 51391, 21467: 51392, 24070: 51393, 25644: 51394, 26001: 51395, 26495: 51396,
				27710: 51397, 27726: 51398, 29256: 51399, 29359: 51400, 29677: 51401, 30036: 51402, 32321: 51403, 33324: 51404, 34281: 51405, 36009: 51406, 31684: 51407, 37318: 51408, 29033: 51409, 38930: 51410, 39151: 51411, 25405: 51412,
				26217: 51413, 30058: 51414, 30436: 51415, 30928: 51416, 34115: 51417, 34542: 51418, 21290: 51419, 21329: 51420, 21542: 51421, 22915: 51422, 24199: 51423, 24444: 51424, 24754: 51425, 25161: 51426, 25209: 51427, 25259: 51428,
				26000: 51429, 27604: 51430, 27852: 51431, 30130: 51432, 30382: 51433, 30865: 51434, 31192: 51435, 32203: 51436, 32631: 51437, 32933: 51438, 34987: 51439, 35513: 51440, 36027: 51441, 36991: 51442, 38750: 51443, 39131: 51444,
				27147: 51445, 31800: 51446, 20633: 51447, 23614: 51448, 24494: 51449, 26503: 51450, 27608: 51451, 29749: 51452, 30473: 51453, 32654: 51454, 40763: 51617, 26570: 51618, 31255: 51619, 21305: 51620, 30091: 51621, 39661: 51622,
				24422: 51623, 33181: 51624, 33777: 51625, 32920: 51626, 24380: 51627, 24517: 51628, 30050: 51629, 31558: 51630, 36924: 51631, 26727: 51632, 23019: 51633, 23195: 51634, 32016: 51635, 30334: 51636, 35628: 51637, 20469: 51638,
				24426: 51639, 27161: 51640, 27703: 51641, 28418: 51642, 29922: 51643, 31080: 51644, 34920: 51645, 35413: 51646, 35961: 51647, 24287: 51648, 25551: 51649, 30149: 51650, 31186: 51651, 33495: 51652, 37672: 51653, 37618: 51654,
				33948: 51655, 34541: 51656, 39981: 51657, 21697: 51658, 24428: 51659, 25996: 51660, 27996: 51661, 28693: 51662, 36007: 51663, 36051: 51664, 38971: 51665, 25935: 51666, 29942: 51667, 19981: 51668, 20184: 51669, 22496: 51670,
				22827: 51671, 23142: 51672, 23500: 51673, 20904: 51674, 24067: 51675, 24220: 51676, 24598: 51677, 25206: 51678, 25975: 51679, 26023: 51680, 26222: 51681, 28014: 51682, 29238: 51683, 31526: 51684, 33104: 51685, 33178: 51686,
				33433: 51687, 35676: 51688, 36000: 51689, 36070: 51690, 36212: 51691, 38428: 51692, 38468: 51693, 20398: 51694, 25771: 51695, 27494: 51696, 33310: 51697, 33889: 51698, 34154: 51699, 37096: 51700, 23553: 51701, 26963: 51702,
				39080: 51703, 33914: 51704, 34135: 51705, 20239: 51706, 21103: 51707, 24489: 51708, 24133: 51709, 26381: 51710, 31119: 51873, 33145: 51874, 35079: 51875, 35206: 51876, 28149: 51877, 24343: 51878, 25173: 51879, 27832: 51880,
				20175: 51881, 29289: 51882, 39826: 51883, 20998: 51884, 21563: 51885, 22132: 51886, 22707: 51887, 24996: 51888, 25198: 51889, 28954: 51890, 22894: 51891, 31881: 51892, 31966: 51893, 32027: 51894, 38640: 51895, 25991: 51896,
				32862: 51897, 19993: 51898, 20341: 51899, 20853: 51900, 22592: 51901, 24163: 51902, 24179: 51903, 24330: 51904, 26564: 51905, 20006: 51906, 34109: 51907, 38281: 51908, 38491: 51909, 31859: 51910, 38913: 51911, 20731: 51912,
				22721: 51913, 30294: 51914, 30887: 51915, 21029: 51916, 30629: 51917, 34065: 51918, 31622: 51919, 20559: 51920, 22793: 51921, 29255: 51922, 31687: 51923, 32232: 51924, 36794: 51925, 36820: 51926, 36941: 51927, 20415: 51928,
				21193: 51929, 23081: 51930, 24321: 51931, 38829: 51932, 20445: 51933, 33303: 51934, 37610: 51935, 22275: 51936, 25429: 51937, 27497: 51938, 29995: 51939, 35036: 51940, 36628: 51941, 31298: 51942, 21215: 51943, 22675: 51944,
				24917: 51945, 25098: 51946, 26286: 51947, 27597: 51948, 31807: 51949, 33769: 51950, 20515: 51951, 20472: 51952, 21253: 51953, 21574: 51954, 22577: 51955, 22857: 51956, 23453: 51957, 23792: 51958, 23791: 51959, 23849: 51960,
				24214: 51961, 25265: 51962, 25447: 51963, 25918: 51964, 26041: 51965, 26379: 51966, 27861: 52129, 27873: 52130, 28921: 52131, 30770: 52132, 32299: 52133, 32990: 52134, 33459: 52135, 33804: 52136, 34028: 52137, 34562: 52138,
				35090: 52139, 35370: 52140, 35914: 52141, 37030: 52142, 37586: 52143, 39165: 52144, 40179: 52145, 40300: 52146, 20047: 52147, 20129: 52148, 20621: 52149, 21078: 52150, 22346: 52151, 22952: 52152, 24125: 52153, 24536: 52154,
				24537: 52155, 25151: 52156, 26292: 52157, 26395: 52158, 26576: 52159, 26834: 52160, 20882: 52161, 32033: 52162, 32938: 52163, 33192: 52164, 35584: 52165, 35980: 52166, 36031: 52167, 37502: 52168, 38450: 52169, 21536: 52170,
				38956: 52171, 21271: 52172, 20693: 52173, 21340: 52174, 22696: 52175, 25778: 52176, 26420: 52177, 29287: 52178, 30566: 52179, 31302: 52180, 37350: 52181, 21187: 52182, 27809: 52183, 27526: 52184, 22528: 52185, 24140: 52186,
				22868: 52187, 26412: 52188, 32763: 52189, 20961: 52190, 30406: 52191, 25705: 52192, 30952: 52193, 39764: 52194, 40635: 52195, 22475: 52196, 22969: 52197, 26151: 52198, 26522: 52199, 27598: 52200, 21737: 52201, 27097: 52202,
				24149: 52203, 33180: 52204, 26517: 52205, 39850: 52206, 26622: 52207, 40018: 52208, 26717: 52209, 20134: 52210, 20451: 52211, 21448: 52212, 25273: 52213, 26411: 52214, 27819: 52215, 36804: 52216, 20397: 52217, 32365: 52218,
				40639: 52219, 19975: 52220, 24930: 52221, 28288: 52222, 28459: 52385, 34067: 52386, 21619: 52387, 26410: 52388, 39749: 52389, 24051: 52390, 31637: 52391, 23724: 52392, 23494: 52393, 34588: 52394, 28234: 52395, 34001: 52396,
				31252: 52397, 33032: 52398, 22937: 52399, 31885: 52400, 27665: 52401, 30496: 52402, 21209: 52403, 22818: 52404, 28961: 52405, 29279: 52406, 30683: 52407, 38695: 52408, 40289: 52409, 26891: 52410, 23167: 52411, 23064: 52412,
				20901: 52413, 21517: 52414, 21629: 52415, 26126: 52416, 30431: 52417, 36855: 52418, 37528: 52419, 40180: 52420, 23018: 52421, 29277: 52422, 28357: 52423, 20813: 52424, 26825: 52425, 32191: 52426, 32236: 52427, 38754: 52428,
				40634: 52429, 25720: 52430, 27169: 52431, 33538: 52432, 22916: 52433, 23391: 52434, 27611: 52435, 29467: 52436, 30450: 52437, 32178: 52438, 32791: 52439, 33945: 52440, 20786: 52441, 26408: 52442, 40665: 52443, 30446: 52444,
				26466: 52445, 21247: 52446, 39173: 52447, 23588: 52448, 25147: 52449, 31870: 52450, 36016: 52451, 21839: 52452, 24758: 52453, 32011: 52454, 38272: 52455, 21249: 52456, 20063: 52457, 20918: 52458, 22812: 52459, 29242: 52460,
				32822: 52461, 37326: 52462, 24357: 52463, 30690: 52464, 21380: 52465, 24441: 52466, 32004: 52467, 34220: 52468, 35379: 52469, 36493: 52470, 38742: 52471, 26611: 52472, 34222: 52473, 37971: 52474, 24841: 52475, 24840: 52476,
				27833: 52477, 30290: 52478, 35565: 52641, 36664: 52642, 21807: 52643, 20305: 52644, 20778: 52645, 21191: 52646, 21451: 52647, 23461: 52648, 24189: 52649, 24736: 52650, 24962: 52651, 25558: 52652, 26377: 52653, 26586: 52654,
				28263: 52655, 28044: 52656, 29494: 52657, 29495: 52658, 30001: 52659, 31056: 52660, 35029: 52661, 35480: 52662, 36938: 52663, 37009: 52664, 37109: 52665, 38596: 52666, 34701: 52667, 22805: 52668, 20104: 52669, 20313: 52670,
				19982: 52671, 35465: 52672, 36671: 52673, 38928: 52674, 20653: 52675, 24188: 52676, 22934: 52677, 23481: 52678, 24248: 52679, 25562: 52680, 25594: 52681, 25793: 52682, 26332: 52683, 26954: 52684, 27096: 52685, 27915: 52686,
				28342: 52687, 29076: 52688, 29992: 52689, 31407: 52690, 32650: 52691, 32768: 52692, 33865: 52693, 33993: 52694, 35201: 52695, 35617: 52696, 36362: 52697, 36965: 52698, 38525: 52699, 39178: 52700, 24958: 52701, 25233: 52702,
				27442: 52703, 27779: 52704, 28020: 52705, 32716: 52706, 32764: 52707, 28096: 52708, 32645: 52709, 34746: 52710, 35064: 52711, 26469: 52712, 33713: 52713, 38972: 52714, 38647: 52715, 27931: 52716, 32097: 52717, 33853: 52718,
				37226: 52719, 20081: 52720, 21365: 52721, 23888: 52722, 27396: 52723, 28651: 52724, 34253: 52725, 34349: 52726, 35239: 52727, 21033: 52728, 21519: 52729, 23653: 52730, 26446: 52731, 26792: 52732, 29702: 52733, 29827: 52734,
				30178: 52897, 35023: 52898, 35041: 52899, 37324: 52900, 38626: 52901, 38520: 52902, 24459: 52903, 29575: 52904, 31435: 52905, 33870: 52906, 25504: 52907, 30053: 52908, 21129: 52909, 27969: 52910, 28316: 52911, 29705: 52912,
				30041: 52913, 30827: 52914, 31890: 52915, 38534: 52916, 31452: 52917, 40845: 52918, 20406: 52919, 24942: 52920, 26053: 52921, 34396: 52922, 20102: 52923, 20142: 52924, 20698: 52925, 20001: 52926, 20940: 52927, 23534: 52928,
				26009: 52929, 26753: 52930, 28092: 52931, 29471: 52932, 30274: 52933, 30637: 52934, 31260: 52935, 31975: 52936, 33391: 52937, 35538: 52938, 36988: 52939, 37327: 52940, 38517: 52941, 38936: 52942, 21147: 52943, 32209: 52944,
				20523: 52945, 21400: 52946, 26519: 52947, 28107: 52948, 29136: 52949, 29747: 52950, 33256: 52951, 36650: 52952, 38563: 52953, 40023: 52954, 40607: 52955, 29792: 52956, 22593: 52957, 28057: 52958, 32047: 52959, 39006: 52960,
				20196: 52961, 20278: 52962, 20363: 52963, 20919: 52964, 21169: 52965, 23994: 52966, 24604: 52967, 29618: 52968, 31036: 52969, 33491: 52970, 37428: 52971, 38583: 52972, 38646: 52973, 38666: 52974, 40599: 52975, 40802: 52976,
				26278: 52977, 27508: 52978, 21015: 52979, 21155: 52980, 28872: 52981, 35010: 52982, 24265: 52983, 24651: 52984, 24976: 52985, 28451: 52986, 29001: 52987, 31806: 52988, 32244: 52989, 32879: 52990, 34030: 53153, 36899: 53154,
				37676: 53155, 21570: 53156, 39791: 53157, 27347: 53158, 28809: 53159, 36034: 53160, 36335: 53161, 38706: 53162, 21172: 53163, 23105: 53164, 24266: 53165, 24324: 53166, 26391: 53167, 27004: 53168, 27028: 53169, 28010: 53170,
				28431: 53171, 29282: 53172, 29436: 53173, 31725: 53174, 32769: 53175, 32894: 53176, 34635: 53177, 37070: 53178, 20845: 53179, 40595: 53180, 31108: 53181, 32907: 53182, 37682: 53183, 35542: 53184, 20525: 53185, 21644: 53186,
				35441: 53187, 27498: 53188, 36036: 53189, 33031: 53190, 24785: 53191, 26528: 53192, 40434: 53193, 20121: 53194, 20120: 53195, 39952: 53196, 35435: 53197, 34241: 53198, 34152: 53199, 26880: 53200, 28286: 53201, 30871: 53202,
				33109: 53203, 24332: 53409, 19984: 53410, 19989: 53411, 20010: 53412, 20017: 53413, 20022: 53414, 20028: 53415, 20031: 53416, 20034: 53417, 20054: 53418, 20056: 53419, 20098: 53420, 20101: 53421, 35947: 53422, 20106: 53423,
				33298: 53424, 24333: 53425, 20110: 53426, 20126: 53427, 20127: 53428, 20128: 53429, 20130: 53430, 20144: 53431, 20147: 53432, 20150: 53433, 20174: 53434, 20173: 53435, 20164: 53436, 20166: 53437, 20162: 53438, 20183: 53439,
				20190: 53440, 20205: 53441, 20191: 53442, 20215: 53443, 20233: 53444, 20314: 53445, 20272: 53446, 20315: 53447, 20317: 53448, 20311: 53449, 20295: 53450, 20342: 53451, 20360: 53452, 20367: 53453, 20376: 53454, 20347: 53455,
				20329: 53456, 20336: 53457, 20369: 53458, 20335: 53459, 20358: 53460, 20374: 53461, 20760: 53462, 20436: 53463, 20447: 53464, 20430: 53465, 20440: 53466, 20443: 53467, 20433: 53468, 20442: 53469, 20432: 53470, 20452: 53471,
				20453: 53472, 20506: 53473, 20520: 53474, 20500: 53475, 20522: 53476, 20517: 53477, 20485: 53478, 20252: 53479, 20470: 53480, 20513: 53481, 20521: 53482, 20524: 53483, 20478: 53484, 20463: 53485, 20497: 53486, 20486: 53487,
				20547: 53488, 20551: 53489, 26371: 53490, 20565: 53491, 20560: 53492, 20552: 53493, 20570: 53494, 20566: 53495, 20588: 53496, 20600: 53497, 20608: 53498, 20634: 53499, 20613: 53500, 20660: 53501, 20658: 53502, 20681: 53665,
				20682: 53666, 20659: 53667, 20674: 53668, 20694: 53669, 20702: 53670, 20709: 53671, 20717: 53672, 20707: 53673, 20718: 53674, 20729: 53675, 20725: 53676, 20745: 53677, 20737: 53678, 20738: 53679, 20758: 53680, 20757: 53681,
				20756: 53682, 20762: 53683, 20769: 53684, 20794: 53685, 20791: 53686, 20796: 53687, 20795: 53688, 20799: 53689, 20800: 53690, 20818: 53691, 20812: 53692, 20820: 53693, 20834: 53694, 31480: 53695, 20841: 53696, 20842: 53697,
				20846: 53698, 20864: 53699, 20866: 53700, 22232: 53701, 20876: 53702, 20873: 53703, 20879: 53704, 20881: 53705, 20883: 53706, 20885: 53707, 20886: 53708, 20900: 53709, 20902: 53710, 20898: 53711, 20905: 53712, 20906: 53713,
				20907: 53714, 20915: 53715, 20913: 53716, 20914: 53717, 20912: 53718, 20917: 53719, 20925: 53720, 20933: 53721, 20937: 53722, 20955: 53723, 20960: 53724, 34389: 53725, 20969: 53726, 20973: 53727, 20976: 53728, 20981: 53729,
				20990: 53730, 20996: 53731, 21003: 53732, 21012: 53733, 21006: 53734, 21031: 53735, 21034: 53736, 21038: 53737, 21043: 53738, 21049: 53739, 21071: 53740, 21060: 53741, 21067: 53742, 21068: 53743, 21086: 53744, 21076: 53745,
				21098: 53746, 21108: 53747, 21097: 53748, 21107: 53749, 21119: 53750, 21117: 53751, 21133: 53752, 21140: 53753, 21138: 53754, 21105: 53755, 21128: 53756, 21137: 53757, 36776: 53758, 36775: 53921, 21164: 53922, 21165: 53923,
				21180: 53924, 21173: 53925, 21185: 53926, 21197: 53927, 21207: 53928, 21214: 53929, 21219: 53930, 21222: 53931, 39149: 53932, 21216: 53933, 21235: 53934, 21237: 53935, 21240: 53936, 21241: 53937, 21254: 53938, 21256: 53939,
				30008: 53940, 21261: 53941, 21264: 53942, 21263: 53943, 21269: 53944, 21274: 53945, 21283: 53946, 21295: 53947, 21297: 53948, 21299: 53949, 21304: 53950, 21312: 53951, 21318: 53952, 21317: 53953, 19991: 53954, 21321: 53955,
				21325: 53956, 20950: 53957, 21342: 53958, 21353: 53959, 21358: 53960, 22808: 53961, 21371: 53962, 21367: 53963, 21378: 53964, 21398: 53965, 21408: 53966, 21414: 53967, 21413: 53968, 21422: 53969, 21424: 53970, 21430: 53971,
				21443: 53972, 31762: 53973, 38617: 53974, 21471: 53975, 26364: 53976, 29166: 53977, 21486: 53978, 21480: 53979, 21485: 53980, 21498: 53981, 21505: 53982, 21565: 53983, 21568: 53984, 21548: 53985, 21549: 53986, 21564: 53987,
				21550: 53988, 21558: 53989, 21545: 53990, 21533: 53991, 21582: 53992, 21647: 53993, 21621: 53994, 21646: 53995, 21599: 53996, 21617: 53997, 21623: 53998, 21616: 53999, 21650: 54000, 21627: 54001, 21632: 54002, 21622: 54003,
				21636: 54004, 21648: 54005, 21638: 54006, 21703: 54007, 21666: 54008, 21688: 54009, 21669: 54010, 21676: 54011, 21700: 54012, 21704: 54013, 21672: 54014, 21675: 54177, 21698: 54178, 21668: 54179, 21694: 54180, 21692: 54181,
				21720: 54182, 21733: 54183, 21734: 54184, 21775: 54185, 21780: 54186, 21757: 54187, 21742: 54188, 21741: 54189, 21754: 54190, 21730: 54191, 21817: 54192, 21824: 54193, 21859: 54194, 21836: 54195, 21806: 54196, 21852: 54197,
				21829: 54198, 21846: 54199, 21847: 54200, 21816: 54201, 21811: 54202, 21853: 54203, 21913: 54204, 21888: 54205, 21679: 54206, 21898: 54207, 21919: 54208, 21883: 54209, 21886: 54210, 21912: 54211, 21918: 54212, 21934: 54213,
				21884: 54214, 21891: 54215, 21929: 54216, 21895: 54217, 21928: 54218, 21978: 54219, 21957: 54220, 21983: 54221, 21956: 54222, 21980: 54223, 21988: 54224, 21972: 54225, 22036: 54226, 22007: 54227, 22038: 54228, 22014: 54229,
				22013: 54230, 22043: 54231, 22009: 54232, 22094: 54233, 22096: 54234, 29151: 54235, 22068: 54236, 22070: 54237, 22066: 54238, 22072: 54239, 22123: 54240, 22116: 54241, 22063: 54242, 22124: 54243, 22122: 54244, 22150: 54245,
				22144: 54246, 22154: 54247, 22176: 54248, 22164: 54249, 22159: 54250, 22181: 54251, 22190: 54252, 22198: 54253, 22196: 54254, 22210: 54255, 22204: 54256, 22209: 54257, 22211: 54258, 22208: 54259, 22216: 54260, 22222: 54261,
				22225: 54262, 22227: 54263, 22231: 54264, 22254: 54265, 22265: 54266, 22272: 54267, 22271: 54268, 22276: 54269, 22281: 54270, 22280: 54433, 22283: 54434, 22285: 54435, 22291: 54436, 22296: 54437, 22294: 54438, 21959: 54439,
				22300: 54440, 22310: 54441, 22327: 54442, 22328: 54443, 22350: 54444, 22331: 54445, 22336: 54446, 22351: 54447, 22377: 54448, 22464: 54449, 22408: 54450, 22369: 54451, 22399: 54452, 22409: 54453, 22419: 54454, 22432: 54455,
				22451: 54456, 22436: 54457, 22442: 54458, 22448: 54459, 22467: 54460, 22470: 54461, 22484: 54462, 22482: 54463, 22483: 54464, 22538: 54465, 22486: 54466, 22499: 54467, 22539: 54468, 22553: 54469, 22557: 54470, 22642: 54471,
				22561: 54472, 22626: 54473, 22603: 54474, 22640: 54475, 27584: 54476, 22610: 54477, 22589: 54478, 22649: 54479, 22661: 54480, 22713: 54481, 22687: 54482, 22699: 54483, 22714: 54484, 22750: 54485, 22715: 54486, 22712: 54487,
				22702: 54488, 22725: 54489, 22739: 54490, 22737: 54491, 22743: 54492, 22745: 54493, 22744: 54494, 22757: 54495, 22748: 54496, 22756: 54497, 22751: 54498, 22767: 54499, 22778: 54500, 22777: 54501, 22779: 54502, 22780: 54503,
				22781: 54504, 22786: 54505, 22794: 54506, 22800: 54507, 22811: 54508, 26790: 54509, 22821: 54510, 22828: 54511, 22829: 54512, 22834: 54513, 22840: 54514, 22846: 54515, 31442: 54516, 22869: 54517, 22864: 54518, 22862: 54519,
				22874: 54520, 22872: 54521, 22882: 54522, 22880: 54523, 22887: 54524, 22892: 54525, 22889: 54526, 22904: 54689, 22913: 54690, 22941: 54691, 20318: 54692, 20395: 54693, 22947: 54694, 22962: 54695, 22982: 54696, 23016: 54697,
				23004: 54698, 22925: 54699, 23001: 54700, 23002: 54701, 23077: 54702, 23071: 54703, 23057: 54704, 23068: 54705, 23049: 54706, 23066: 54707, 23104: 54708, 23148: 54709, 23113: 54710, 23093: 54711, 23094: 54712, 23138: 54713,
				23146: 54714, 23194: 54715, 23228: 54716, 23230: 54717, 23243: 54718, 23234: 54719, 23229: 54720, 23267: 54721, 23255: 54722, 23270: 54723, 23273: 54724, 23254: 54725, 23290: 54726, 23291: 54727, 23308: 54728, 23307: 54729,
				23318: 54730, 23346: 54731, 23248: 54732, 23338: 54733, 23350: 54734, 23358: 54735, 23363: 54736, 23365: 54737, 23360: 54738, 23377: 54739, 23381: 54740, 23386: 54741, 23387: 54742, 23397: 54743, 23401: 54744, 23408: 54745,
				23411: 54746, 23413: 54747, 23416: 54748, 25992: 54749, 23418: 54750, 23424: 54751, 23427: 54752, 23462: 54753, 23480: 54754, 23491: 54755, 23495: 54756, 23497: 54757, 23508: 54758, 23504: 54759, 23524: 54760, 23526: 54761,
				23522: 54762, 23518: 54763, 23525: 54764, 23531: 54765, 23536: 54766, 23542: 54767, 23539: 54768, 23557: 54769, 23559: 54770, 23560: 54771, 23565: 54772, 23571: 54773, 23584: 54774, 23586: 54775, 23592: 54776, 23608: 54777,
				23609: 54778, 23617: 54779, 23622: 54780, 23630: 54781, 23635: 54782, 23632: 54945, 23631: 54946, 23409: 54947, 23660: 54948, 23662: 54949, 20066: 54950, 23670: 54951, 23673: 54952, 23692: 54953, 23697: 54954, 23700: 54955,
				22939: 54956, 23723: 54957, 23739: 54958, 23734: 54959, 23740: 54960, 23735: 54961, 23749: 54962, 23742: 54963, 23751: 54964, 23769: 54965, 23785: 54966, 23805: 54967, 23802: 54968, 23789: 54969, 23948: 54970, 23786: 54971,
				23819: 54972, 23829: 54973, 23831: 54974, 23900: 54975, 23839: 54976, 23835: 54977, 23825: 54978, 23828: 54979, 23842: 54980, 23834: 54981, 23833: 54982, 23832: 54983, 23884: 54984, 23890: 54985, 23886: 54986, 23883: 54987,
				23916: 54988, 23923: 54989, 23926: 54990, 23943: 54991, 23940: 54992, 23938: 54993, 23970: 54994, 23965: 54995, 23980: 54996, 23982: 54997, 23997: 54998, 23952: 54999, 23991: 55000, 23996: 55001, 24009: 55002, 24013: 55003,
				24019: 55004, 24018: 55005, 24022: 55006, 24027: 55007, 24043: 55008, 24050: 55009, 24053: 55010, 24075: 55011, 24090: 55012, 24089: 55013, 24081: 55014, 24091: 55015, 24118: 55016, 24119: 55017, 24132: 55018, 24131: 55019,
				24128: 55020, 24142: 55021, 24151: 55022, 24148: 55023, 24159: 55024, 24162: 55025, 24164: 55026, 24135: 55027, 24181: 55028, 24182: 55029, 24186: 55030, 40636: 55031, 24191: 55032, 24224: 55033, 24257: 55034, 24258: 55035,
				24264: 55036, 24272: 55037, 24271: 55038, 24278: 55201, 24291: 55202, 24285: 55203, 24282: 55204, 24283: 55205, 24290: 55206, 24289: 55207, 24296: 55208, 24297: 55209, 24300: 55210, 24305: 55211, 24307: 55212, 24304: 55213,
				24308: 55214, 24312: 55215, 24318: 55216, 24323: 55217, 24329: 55218, 24413: 55219, 24412: 55220, 24331: 55221, 24337: 55222, 24342: 55223, 24361: 55224, 24365: 55225, 24376: 55226, 24385: 55227, 24392: 55228, 24396: 55229,
				24398: 55230, 24367: 55231, 24401: 55232, 24406: 55233, 24407: 55234, 24409: 55235, 24417: 55236, 24429: 55237, 24435: 55238, 24439: 55239, 24451: 55240, 24450: 55241, 24447: 55242, 24458: 55243, 24456: 55244, 24465: 55245,
				24455: 55246, 24478: 55247, 24473: 55248, 24472: 55249, 24480: 55250, 24488: 55251, 24493: 55252, 24508: 55253, 24534: 55254, 24571: 55255, 24548: 55256, 24568: 55257, 24561: 55258, 24541: 55259, 24755: 55260, 24575: 55261,
				24609: 55262, 24672: 55263, 24601: 55264, 24592: 55265, 24617: 55266, 24590: 55267, 24625: 55268, 24603: 55269, 24597: 55270, 24619: 55271, 24614: 55272, 24591: 55273, 24634: 55274, 24666: 55275, 24641: 55276, 24682: 55277,
				24695: 55278, 24671: 55279, 24650: 55280, 24646: 55281, 24653: 55282, 24675: 55283, 24643: 55284, 24676: 55285, 24642: 55286, 24684: 55287, 24683: 55288, 24665: 55289, 24705: 55290, 24717: 55291, 24807: 55292, 24707: 55293,
				24730: 55294, 24708: 55457, 24731: 55458, 24726: 55459, 24727: 55460, 24722: 55461, 24743: 55462, 24715: 55463, 24801: 55464, 24760: 55465, 24800: 55466, 24787: 55467, 24756: 55468, 24560: 55469, 24765: 55470, 24774: 55471,
				24757: 55472, 24792: 55473, 24909: 55474, 24853: 55475, 24838: 55476, 24822: 55477, 24823: 55478, 24832: 55479, 24820: 55480, 24826: 55481, 24835: 55482, 24865: 55483, 24827: 55484, 24817: 55485, 24845: 55486, 24846: 55487,
				24903: 55488, 24894: 55489, 24872: 55490, 24871: 55491, 24906: 55492, 24895: 55493, 24892: 55494, 24876: 55495, 24884: 55496, 24893: 55497, 24898: 55498, 24900: 55499, 24947: 55500, 24951: 55501, 24920: 55502, 24921: 55503,
				24922: 55504, 24939: 55505, 24948: 55506, 24943: 55507, 24933: 55508, 24945: 55509, 24927: 55510, 24925: 55511, 24915: 55512, 24949: 55513, 24985: 55514, 24982: 55515, 24967: 55516, 25004: 55517, 24980: 55518, 24986: 55519,
				24970: 55520, 24977: 55521, 25003: 55522, 25006: 55523, 25036: 55524, 25034: 55525, 25033: 55526, 25079: 55527, 25032: 55528, 25027: 55529, 25030: 55530, 25018: 55531, 25035: 55532, 32633: 55533, 25037: 55534, 25062: 55535,
				25059: 55536, 25078: 55537, 25082: 55538, 25076: 55539, 25087: 55540, 25085: 55541, 25084: 55542, 25086: 55543, 25088: 55544, 25096: 55545, 25097: 55546, 25101: 55547, 25100: 55548, 25108: 55549, 25115: 55550, 25118: 55713,
				25121: 55714, 25130: 55715, 25134: 55716, 25136: 55717, 25138: 55718, 25139: 55719, 25153: 55720, 25166: 55721, 25182: 55722, 25187: 55723, 25179: 55724, 25184: 55725, 25192: 55726, 25212: 55727, 25218: 55728, 25225: 55729,
				25214: 55730, 25234: 55731, 25235: 55732, 25238: 55733, 25300: 55734, 25219: 55735, 25236: 55736, 25303: 55737, 25297: 55738, 25275: 55739, 25295: 55740, 25343: 55741, 25286: 55742, 25812: 55743, 25288: 55744, 25308: 55745,
				25292: 55746, 25290: 55747, 25282: 55748, 25287: 55749, 25243: 55750, 25289: 55751, 25356: 55752, 25326: 55753, 25329: 55754, 25383: 55755, 25346: 55756, 25352: 55757, 25327: 55758, 25333: 55759, 25424: 55760, 25406: 55761,
				25421: 55762, 25628: 55763, 25423: 55764, 25494: 55765, 25486: 55766, 25472: 55767, 25515: 55768, 25462: 55769, 25507: 55770, 25487: 55771, 25481: 55772, 25503: 55773, 25525: 55774, 25451: 55775, 25449: 55776, 25534: 55777,
				25577: 55778, 25536: 55779, 25542: 55780, 25571: 55781, 25545: 55782, 25554: 55783, 25590: 55784, 25540: 55785, 25622: 55786, 25652: 55787, 25606: 55788, 25619: 55789, 25638: 55790, 25654: 55791, 25885: 55792, 25623: 55793,
				25640: 55794, 25615: 55795, 25703: 55796, 25711: 55797, 25718: 55798, 25678: 55799, 25898: 55800, 25749: 55801, 25747: 55802, 25765: 55803, 25769: 55804, 25736: 55805, 25788: 55806, 25818: 55969, 25810: 55970, 25797: 55971,
				25799: 55972, 25787: 55973, 25816: 55974, 25794: 55975, 25841: 55976, 25831: 55977, 33289: 55978, 25824: 55979, 25825: 55980, 25260: 55981, 25827: 55982, 25839: 55983, 25900: 55984, 25846: 55985, 25844: 55986, 25842: 55987,
				25850: 55988, 25856: 55989, 25853: 55990, 25880: 55991, 25884: 55992, 25861: 55993, 25892: 55994, 25891: 55995, 25899: 55996, 25908: 55997, 25909: 55998, 25911: 55999, 25910: 56000, 25912: 56001, 30027: 56002, 25928: 56003,
				25942: 56004, 25941: 56005, 25933: 56006, 25944: 56007, 25950: 56008, 25949: 56009, 25970: 56010, 25976: 56011, 25986: 56012, 25987: 56013, 35722: 56014, 26011: 56015, 26015: 56016, 26027: 56017, 26039: 56018, 26051: 56019,
				26054: 56020, 26049: 56021, 26052: 56022, 26060: 56023, 26066: 56024, 26075: 56025, 26073: 56026, 26080: 56027, 26081: 56028, 26097: 56029, 26482: 56030, 26122: 56031, 26115: 56032, 26107: 56033, 26483: 56034, 26165: 56035,
				26166: 56036, 26164: 56037, 26140: 56038, 26191: 56039, 26180: 56040, 26185: 56041, 26177: 56042, 26206: 56043, 26205: 56044, 26212: 56045, 26215: 56046, 26216: 56047, 26207: 56048, 26210: 56049, 26224: 56050, 26243: 56051,
				26248: 56052, 26254: 56053, 26249: 56054, 26244: 56055, 26264: 56056, 26269: 56057, 26305: 56058, 26297: 56059, 26313: 56060, 26302: 56061, 26300: 56062, 26308: 56225, 26296: 56226, 26326: 56227, 26330: 56228, 26336: 56229,
				26175: 56230, 26342: 56231, 26345: 56232, 26352: 56233, 26357: 56234, 26359: 56235, 26383: 56236, 26390: 56237, 26398: 56238, 26406: 56239, 26407: 56240, 38712: 56241, 26414: 56242, 26431: 56243, 26422: 56244, 26433: 56245,
				26424: 56246, 26423: 56247, 26438: 56248, 26462: 56249, 26464: 56250, 26457: 56251, 26467: 56252, 26468: 56253, 26505: 56254, 26480: 56255, 26537: 56256, 26492: 56257, 26474: 56258, 26508: 56259, 26507: 56260, 26534: 56261,
				26529: 56262, 26501: 56263, 26551: 56264, 26607: 56265, 26548: 56266, 26604: 56267, 26547: 56268, 26601: 56269, 26552: 56270, 26596: 56271, 26590: 56272, 26589: 56273, 26594: 56274, 26606: 56275, 26553: 56276, 26574: 56277,
				26566: 56278, 26599: 56279, 27292: 56280, 26654: 56281, 26694: 56282, 26665: 56283, 26688: 56284, 26701: 56285, 26674: 56286, 26702: 56287, 26803: 56288, 26667: 56289, 26713: 56290, 26723: 56291, 26743: 56292, 26751: 56293,
				26783: 56294, 26767: 56295, 26797: 56296, 26772: 56297, 26781: 56298, 26779: 56299, 26755: 56300, 27310: 56301, 26809: 56302, 26740: 56303, 26805: 56304, 26784: 56305, 26810: 56306, 26895: 56307, 26765: 56308, 26750: 56309,
				26881: 56310, 26826: 56311, 26888: 56312, 26840: 56313, 26914: 56314, 26918: 56315, 26849: 56316, 26892: 56317, 26829: 56318, 26836: 56481, 26855: 56482, 26837: 56483, 26934: 56484, 26898: 56485, 26884: 56486, 26839: 56487,
				26851: 56488, 26917: 56489, 26873: 56490, 26848: 56491, 26863: 56492, 26920: 56493, 26922: 56494, 26906: 56495, 26915: 56496, 26913: 56497, 26822: 56498, 27001: 56499, 26999: 56500, 26972: 56501, 27000: 56502, 26987: 56503,
				26964: 56504, 27006: 56505, 26990: 56506, 26937: 56507, 26996: 56508, 26941: 56509, 26969: 56510, 26928: 56511, 26977: 56512, 26974: 56513, 26973: 56514, 27009: 56515, 26986: 56516, 27058: 56517, 27054: 56518, 27088: 56519,
				27071: 56520, 27073: 56521, 27091: 56522, 27070: 56523, 27086: 56524, 23528: 56525, 27082: 56526, 27101: 56527, 27067: 56528, 27075: 56529, 27047: 56530, 27182: 56531, 27025: 56532, 27040: 56533, 27036: 56534, 27029: 56535,
				27060: 56536, 27102: 56537, 27112: 56538, 27138: 56539, 27163: 56540, 27135: 56541, 27402: 56542, 27129: 56543, 27122: 56544, 27111: 56545, 27141: 56546, 27057: 56547, 27166: 56548, 27117: 56549, 27156: 56550, 27115: 56551,
				27146: 56552, 27154: 56553, 27329: 56554, 27171: 56555, 27155: 56556, 27204: 56557, 27148: 56558, 27250: 56559, 27190: 56560, 27256: 56561, 27207: 56562, 27234: 56563, 27225: 56564, 27238: 56565, 27208: 56566, 27192: 56567,
				27170: 56568, 27280: 56569, 27277: 56570, 27296: 56571, 27268: 56572, 27298: 56573, 27299: 56574, 27287: 56737, 34327: 56738, 27323: 56739, 27331: 56740, 27330: 56741, 27320: 56742, 27315: 56743, 27308: 56744, 27358: 56745,
				27345: 56746, 27359: 56747, 27306: 56748, 27354: 56749, 27370: 56750, 27387: 56751, 27397: 56752, 34326: 56753, 27386: 56754, 27410: 56755, 27414: 56756, 39729: 56757, 27423: 56758, 27448: 56759, 27447: 56760, 30428: 56761,
				27449: 56762, 39150: 56763, 27463: 56764, 27459: 56765, 27465: 56766, 27472: 56767, 27481: 56768, 27476: 56769, 27483: 56770, 27487: 56771, 27489: 56772, 27512: 56773, 27513: 56774, 27519: