// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: pkg/querier/queryrange/queryrangebase/queryrange.proto

package queryrangebase

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	github_com_grafana_loki_v3_pkg_logproto "github.com/grafana/loki/v3/pkg/logproto"
	logproto "github.com/grafana/loki/v3/pkg/logproto"
	definitions "github.com/grafana/loki/v3/pkg/querier/queryrange/queryrangebase/definitions"
	resultscache "github.com/grafana/loki/v3/pkg/storage/chunk/cache/resultscache"
	_ "google.golang.org/protobuf/types/known/durationpb"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type PrometheusRequest struct {
	Path           string                                 `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Start          time.Time                              `protobuf:"bytes,2,opt,name=start,proto3,stdtime" json:"start"`
	End            time.Time                              `protobuf:"bytes,3,opt,name=end,proto3,stdtime" json:"end"`
	Step           int64                                  `protobuf:"varint,4,opt,name=step,proto3" json:"step,omitempty"`
	Timeout        time.Duration                          `protobuf:"bytes,5,opt,name=timeout,proto3,stdduration" json:"timeout"`
	Query          string                                 `protobuf:"bytes,6,opt,name=query,proto3" json:"query,omitempty"`
	CachingOptions resultscache.CachingOptions            `protobuf:"bytes,7,opt,name=cachingOptions,proto3" json:"cachingOptions"`
	Headers        []*definitions.PrometheusRequestHeader `protobuf:"bytes,8,rep,name=Headers,proto3" json:"-"`
}

func (m *PrometheusRequest) Reset()      { *m = PrometheusRequest{} }
func (*PrometheusRequest) ProtoMessage() {}
func (*PrometheusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4cc6a0c1d6b614c4, []int{0}
}
func (m *PrometheusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrometheusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrometheusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrometheusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrometheusRequest.Merge(m, src)
}
func (m *PrometheusRequest) XXX_Size() int {
	return m.Size()
}
func (m *PrometheusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PrometheusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PrometheusRequest proto.InternalMessageInfo

func (m *PrometheusRequest) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *PrometheusRequest) GetStart() time.Time {
	if m != nil {
		return m.Start
	}
	return time.Time{}
}

func (m *PrometheusRequest) GetEnd() time.Time {
	if m != nil {
		return m.End
	}
	return time.Time{}
}

func (m *PrometheusRequest) GetStep() int64 {
	if m != nil {
		return m.Step
	}
	return 0
}

func (m *PrometheusRequest) GetTimeout() time.Duration {
	if m != nil {
		return m.Timeout
	}
	return 0
}

func (m *PrometheusRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *PrometheusRequest) GetCachingOptions() resultscache.CachingOptions {
	if m != nil {
		return m.CachingOptions
	}
	return resultscache.CachingOptions{}
}

func (m *PrometheusRequest) GetHeaders() []*definitions.PrometheusRequestHeader {
	if m != nil {
		return m.Headers
	}
	return nil
}

type PrometheusResponse struct {
	Status    string                                  `protobuf:"bytes,1,opt,name=Status,proto3" json:"status"`
	Data      PrometheusData                          `protobuf:"bytes,2,opt,name=Data,proto3" json:"data,omitempty"`
	ErrorType string                                  `protobuf:"bytes,3,opt,name=ErrorType,proto3" json:"errorType,omitempty"`
	Error     string                                  `protobuf:"bytes,4,opt,name=Error,proto3" json:"error,omitempty"`
	Headers   []*definitions.PrometheusResponseHeader `protobuf:"bytes,5,rep,name=Headers,proto3" json:"-"`
	Warnings  []string                                `protobuf:"bytes,6,rep,name=Warnings,proto3" json:"warnings,omitempty"`
}

func (m *PrometheusResponse) Reset()      { *m = PrometheusResponse{} }
func (*PrometheusResponse) ProtoMessage() {}
func (*PrometheusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4cc6a0c1d6b614c4, []int{1}
}
func (m *PrometheusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrometheusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrometheusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrometheusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrometheusResponse.Merge(m, src)
}
func (m *PrometheusResponse) XXX_Size() int {
	return m.Size()
}
func (m *PrometheusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PrometheusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PrometheusResponse proto.InternalMessageInfo

func (m *PrometheusResponse) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *PrometheusResponse) GetData() PrometheusData {
	if m != nil {
		return m.Data
	}
	return PrometheusData{}
}

func (m *PrometheusResponse) GetErrorType() string {
	if m != nil {
		return m.ErrorType
	}
	return ""
}

func (m *PrometheusResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *PrometheusResponse) GetHeaders() []*definitions.PrometheusResponseHeader {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *PrometheusResponse) GetWarnings() []string {
	if m != nil {
		return m.Warnings
	}
	return nil
}

type PrometheusData struct {
	ResultType string         `protobuf:"bytes,1,opt,name=ResultType,proto3" json:"resultType"`
	Result     []SampleStream `protobuf:"bytes,2,rep,name=Result,proto3" json:"result"`
}

func (m *PrometheusData) Reset()      { *m = PrometheusData{} }
func (*PrometheusData) ProtoMessage() {}
func (*PrometheusData) Descriptor() ([]byte, []int) {
	return fileDescriptor_4cc6a0c1d6b614c4, []int{2}
}
func (m *PrometheusData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrometheusData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrometheusData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrometheusData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrometheusData.Merge(m, src)
}
func (m *PrometheusData) XXX_Size() int {
	return m.Size()
}
func (m *PrometheusData) XXX_DiscardUnknown() {
	xxx_messageInfo_PrometheusData.DiscardUnknown(m)
}

var xxx_messageInfo_PrometheusData proto.InternalMessageInfo

func (m *PrometheusData) GetResultType() string {
	if m != nil {
		return m.ResultType
	}
	return ""
}

func (m *PrometheusData) GetResult() []SampleStream {
	if m != nil {
		return m.Result
	}
	return nil
}

type SampleStream struct {
	Labels  []github_com_grafana_loki_v3_pkg_logproto.LabelAdapter `protobuf:"bytes,1,rep,name=labels,proto3,customtype=github.com/grafana/loki/v3/pkg/logproto.LabelAdapter" json:"metric"`
	Samples []logproto.LegacySample                                `protobuf:"bytes,2,rep,name=samples,proto3" json:"values"`
}

func (m *SampleStream) Reset()      { *m = SampleStream{} }
func (*SampleStream) ProtoMessage() {}
func (*SampleStream) Descriptor() ([]byte, []int) {
	return fileDescriptor_4cc6a0c1d6b614c4, []int{3}
}
func (m *SampleStream) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SampleStream) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SampleStream.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SampleStream) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SampleStream.Merge(m, src)
}
func (m *SampleStream) XXX_Size() int {
	return m.Size()
}
func (m *SampleStream) XXX_DiscardUnknown() {
	xxx_messageInfo_SampleStream.DiscardUnknown(m)
}

var xxx_messageInfo_SampleStream proto.InternalMessageInfo

func (m *SampleStream) GetSamples() []logproto.LegacySample {
	if m != nil {
		return m.Samples
	}
	return nil
}

func init() {
	proto.RegisterType((*PrometheusRequest)(nil), "queryrangebase.PrometheusRequest")
	proto.RegisterType((*PrometheusResponse)(nil), "queryrangebase.PrometheusResponse")
	proto.RegisterType((*PrometheusData)(nil), "queryrangebase.PrometheusData")
	proto.RegisterType((*SampleStream)(nil), "queryrangebase.SampleStream")
}

func init() {
	proto.RegisterFile("pkg/querier/queryrange/queryrangebase/queryrange.proto", fileDescriptor_4cc6a0c1d6b614c4)
}

var fileDescriptor_4cc6a0c1d6b614c4 = []byte{
	// 768 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0x4f, 0x6f, 0xd3, 0x4e,
	0x10, 0x8d, 0x9b, 0xc4, 0x69, 0xb6, 0x3f, 0xe5, 0x27, 0xb6, 0x55, 0x31, 0xa5, 0xb2, 0xa3, 0x08,
	0xa4, 0x20, 0x81, 0x8d, 0x5a, 0xe8, 0x01, 0x09, 0xa9, 0xb8, 0x7f, 0x84, 0xaa, 0x4a, 0x54, 0x6e,
	0x25, 0x24, 0x6e, 0x9b, 0x64, 0xeb, 0x58, 0xb5, 0xbd, 0xee, 0xee, 0xba, 0x28, 0x37, 0x4e, 0x9c,
	0x7b, 0x83, 0x8f, 0xc0, 0x47, 0xa9, 0xc4, 0xa5, 0xc7, 0x8a, 0x83, 0xa1, 0xee, 0x05, 0xe5, 0xd4,
	0x8f, 0x80, 0x76, 0xed, 0xb4, 0x4e, 0x0a, 0x2a, 0x9c, 0x3c, 0xb3, 0xf3, 0xde, 0xdb, 0x99, 0x37,
	0xd6, 0x82, 0x95, 0xe8, 0xc0, 0xb5, 0x0e, 0x63, 0x4c, 0x3d, 0x4c, 0xe5, 0x77, 0x40, 0x51, 0xe8,
	0xe2, 0x42, 0xd8, 0x41, 0xac, 0x98, 0x9a, 0x11, 0x25, 0x9c, 0xc0, 0xc6, 0x38, 0x60, 0x61, 0xce,
	0x25, 0x2e, 0x91, 0x25, 0x4b, 0x44, 0x19, 0x6a, 0x41, 0x77, 0x09, 0x71, 0x7d, 0x6c, 0xc9, 0xac,
	0x13, 0xef, 0x5b, 0xbd, 0x98, 0x22, 0xee, 0x91, 0x30, 0xaf, 0x1b, 0x93, 0x75, 0xee, 0x05, 0x98,
	0x71, 0x14, 0x44, 0x39, 0xe0, 0xbe, 0x68, 0xcf, 0x27, 0x6e, 0xa6, 0x3c, 0x0a, 0xf2, 0xe2, 0xda,
	0xdf, 0xf5, 0xde, 0xc3, 0xfb, 0x5e, 0xe8, 0x89, 0x5b, 0x59, 0x31, 0xce, 0x45, 0x9e, 0x0a, 0x11,
	0xc6, 0x09, 0x45, 0x2e, 0xb6, 0xba, 0xfd, 0x38, 0x3c, 0xb0, 0xba, 0xa8, 0xdb, 0xc7, 0x16, 0xc5,
	0x2c, 0xf6, 0x39, 0xcb, 0x12, 0x3e, 0x88, 0x70, 0xce, 0x68, 0x7d, 0x2a, 0x83, 0x3b, 0x3b, 0x94,
	0x04, 0x98, 0xf7, 0x71, 0xcc, 0x1c, 0x7c, 0x18, 0x63, 0xc6, 0x21, 0x04, 0x95, 0x08, 0xf1, 0xbe,
	0xa6, 0x34, 0x95, 0x76, 0xdd, 0x91, 0x31, 0x7c, 0x01, 0xaa, 0x8c, 0x23, 0xca, 0xb5, 0xa9, 0xa6,
	0xd2, 0x9e, 0x59, 0x5a, 0x30, 0xb3, 0x71, 0xcd, 0xd1, 0xb8, 0xe6, 0xde, 0x68, 0x5c, 0x7b, 0xfa,
	0x24, 0x31, 0x4a, 0xc7, 0xdf, 0x0d, 0xc5, 0xc9, 0x28, 0x70, 0x05, 0x94, 0x71, 0xd8, 0xd3, 0xca,
	0xff, 0xc0, 0x14, 0x04, 0xd1, 0x07, 0xe3, 0x38, 0xd2, 0x2a, 0x4d, 0xa5, 0x5d, 0x76, 0x64, 0x0c,
	0x5f, 0x82, 0x9a, 0x30, 0x96, 0xc4, 0x5c, 0xab, 0x4a, 0xbd, 0x7b, 0x37, 0xf4, 0xd6, 0xf3, 0xc5,
	0x64, 0x72, 0x9f, 0x85, 0xdc, 0x88, 0x03, 0xe7, 0x40, 0x55, 0x5a, 0xaa, 0xa9, 0x72, 0xb6, 0x2c,
	0x81, 0x5b, 0xa0, 0x21, 0xbc, 0xf1, 0x42, 0xf7, 0x4d, 0x24, 0x0d, 0xd5, 0x6a, 0x52, 0x7b, 0xd1,
	0x2c, 0x3a, 0x67, 0xae, 0x8d, 0x61, 0xec, 0x8a, 0x90, 0x77, 0x26, 0x98, 0x70, 0x03, 0xd4, 0x5e,
	0x63, 0xd4, 0xc3, 0x94, 0x69, 0xd3, 0xcd, 0x72, 0x7b, 0x66, 0xe9, 0x81, 0x59, 0xdc, 0xd4, 0x0d,
	0xb7, 0x33, 0xb0, 0x5d, 0x1d, 0x26, 0x86, 0xf2, 0xc4, 0x19, 0x71, 0x5b, 0xe9, 0x14, 0x80, 0x45,
	0x2c, 0x8b, 0x48, 0xc8, 0x30, 0x6c, 0x01, 0x75, 0x97, 0x23, 0x1e, 0xb3, 0x6c, 0x39, 0x36, 0x18,
	0x26, 0x86, 0xca, 0xe4, 0x89, 0x93, 0x57, 0xe0, 0x16, 0xa8, 0xac, 0x23, 0x8e, 0xf2, 0x4d, 0xe9,
	0xe6, 0xf8, 0x3f, 0x54, 0xe8, 0x40, 0xa0, 0xec, 0x79, 0x31, 0xc5, 0x30, 0x31, 0x1a, 0x3d, 0xc4,
	0xd1, 0x63, 0x12, 0x78, 0x1c, 0x07, 0x11, 0x1f, 0x38, 0x52, 0x03, 0x3e, 0x07, 0xf5, 0x0d, 0x4a,
	0x09, 0xdd, 0x1b, 0x44, 0x58, 0x2e, 0xb0, 0x6e, 0xdf, 0x1d, 0x26, 0xc6, 0x2c, 0x1e, 0x1d, 0x16,
	0x18, 0xd7, 0x48, 0xf8, 0x08, 0x54, 0x65, 0x22, 0x57, 0x57, 0xb7, 0x67, 0x87, 0x89, 0xf1, 0xbf,
	0xa4, 0x14, 0xe0, 0x19, 0x02, 0x6e, 0x5e, 0xfb, 0x55, 0x95, 0x7e, 0x3d, 0xfc, 0xa3, 0x5f, 0x99,
	0x07, 0xbf, 0x37, 0x0c, 0x2e, 0x81, 0xe9, 0xb7, 0x88, 0x86, 0x5e, 0xe8, 0x32, 0x4d, 0x6d, 0x96,
	0xdb, 0x75, 0x7b, 0x7e, 0x98, 0x18, 0xf0, 0x7d, 0x7e, 0x56, 0xb8, 0xf8, 0x0a, 0xd7, 0xfa, 0xa8,
	0x80, 0xc6, 0xb8, 0x1d, 0xd0, 0x04, 0xc0, 0x91, 0x3b, 0x97, 0x13, 0x67, 0x26, 0x37, 0x86, 0x89,
	0x01, 0xe8, 0xd5, 0xa9, 0x53, 0x40, 0xc0, 0x75, 0xa0, 0x66, 0x99, 0x36, 0x25, 0xbb, 0x5f, 0x9c,
	0xb4, 0x7b, 0x17, 0x05, 0x91, 0x8f, 0x77, 0x39, 0xc5, 0x28, 0xb0, 0x1b, 0xb9, 0xd9, 0x6a, 0xa6,
	0xe6, 0xe4, 0xdc, 0xd6, 0x57, 0x05, 0xfc, 0x57, 0x04, 0xc2, 0x01, 0x50, 0x7d, 0xd4, 0xc1, 0xbe,
	0xd8, 0x73, 0x59, 0xfe, 0xe5, 0x57, 0x0f, 0xc6, 0x36, 0x76, 0x51, 0x77, 0xb0, 0x2d, 0xaa, 0x3b,
	0xc8, 0xa3, 0xf6, 0xa6, 0xd0, 0xfc, 0x96, 0x18, 0xcf, 0x5c, 0x8f, 0xf7, 0xe3, 0x8e, 0xd9, 0x25,
	0x81, 0xe5, 0x52, 0xb4, 0x8f, 0x42, 0x64, 0xf9, 0xe4, 0xc0, 0xb3, 0x8e, 0x96, 0xad, 0xe2, 0xd3,
	0x63, 0x4a, 0xea, 0xab, 0x1e, 0x8a, 0x38, 0xa6, 0xa2, 0x97, 0x00, 0x73, 0xea, 0x75, 0x9d, 0xfc,
	0x42, 0xb8, 0x0a, 0x6a, 0x4c, 0xb6, 0xc2, 0xf2, 0x91, 0xe6, 0x27, 0xef, 0xce, 0x3a, 0xbd, 0x1e,
	0xe6, 0x08, 0xf9, 0x31, 0x66, 0xce, 0x88, 0x66, 0x1f, 0x9d, 0x9e, 0xeb, 0xa5, 0xb3, 0x73, 0xbd,
	0x74, 0x79, 0xae, 0x2b, 0x1f, 0x52, 0x5d, 0xf9, 0x92, 0xea, 0xca, 0x49, 0xaa, 0x2b, 0xa7, 0xa9,
	0xae, 0xfc, 0x48, 0x75, 0xe5, 0x67, 0xaa, 0x97, 0x2e, 0x53, 0x5d, 0x39, 0xbe, 0xd0, 0x4b, 0xa7,
	0x17, 0x7a, 0xe9, 0xec, 0x42, 0x2f, 0xbd, 0x5b, 0xbd, 0xa5, 0xff, 0x5b, 0x5f, 0xc7, 0x8e, 0x2a,
	0x9b, 0x5c, 0xfe, 0x15, 0x00, 0x00, 0xff, 0xff, 0x8f, 0x2e, 0x5a, 0xee, 0x09, 0x06, 0x00, 0x00,
}

func (this *PrometheusRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PrometheusRequest)
	if !ok {
		that2, ok := that.(PrometheusRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if !this.Start.Equal(that1.Start) {
		return false
	}
	if !this.End.Equal(that1.End) {
		return false
	}
	if this.Step != that1.Step {
		return false
	}
	if this.Timeout != that1.Timeout {
		return false
	}
	if this.Query != that1.Query {
		return false
	}
	if !this.CachingOptions.Equal(&that1.CachingOptions) {
		return false
	}
	if len(this.Headers) != len(that1.Headers) {
		return false
	}
	for i := range this.Headers {
		if !this.Headers[i].Equal(that1.Headers[i]) {
			return false
		}
	}
	return true
}
func (this *PrometheusResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PrometheusResponse)
	if !ok {
		that2, ok := that.(PrometheusResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if !this.Data.Equal(&that1.Data) {
		return false
	}
	if this.ErrorType != that1.ErrorType {
		return false
	}
	if this.Error != that1.Error {
		return false
	}
	if len(this.Headers) != len(that1.Headers) {
		return false
	}
	for i := range this.Headers {
		if !this.Headers[i].Equal(that1.Headers[i]) {
			return false
		}
	}
	if len(this.Warnings) != len(that1.Warnings) {
		return false
	}
	for i := range this.Warnings {
		if this.Warnings[i] != that1.Warnings[i] {
			return false
		}
	}
	return true
}
func (this *PrometheusData) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PrometheusData)
	if !ok {
		that2, ok := that.(PrometheusData)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ResultType != that1.ResultType {
		return false
	}
	if len(this.Result) != len(that1.Result) {
		return false
	}
	for i := range this.Result {
		if !this.Result[i].Equal(&that1.Result[i]) {
			return false
		}
	}
	return true
}
func (this *SampleStream) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SampleStream)
	if !ok {
		that2, ok := that.(SampleStream)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Labels) != len(that1.Labels) {
		return false
	}
	for i := range this.Labels {
		if !this.Labels[i].Equal(that1.Labels[i]) {
			return false
		}
	}
	if len(this.Samples) != len(that1.Samples) {
		return false
	}
	for i := range this.Samples {
		if !this.Samples[i].Equal(&that1.Samples[i]) {
			return false
		}
	}
	return true
}
func (this *PrometheusRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&queryrangebase.PrometheusRequest{")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "Start: "+fmt.Sprintf("%#v", this.Start)+",\n")
	s = append(s, "End: "+fmt.Sprintf("%#v", this.End)+",\n")
	s = append(s, "Step: "+fmt.Sprintf("%#v", this.Step)+",\n")
	s = append(s, "Timeout: "+fmt.Sprintf("%#v", this.Timeout)+",\n")
	s = append(s, "Query: "+fmt.Sprintf("%#v", this.Query)+",\n")
	s = append(s, "CachingOptions: "+strings.Replace(this.CachingOptions.GoString(), `&`, ``, 1)+",\n")
	if this.Headers != nil {
		s = append(s, "Headers: "+fmt.Sprintf("%#v", this.Headers)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PrometheusResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&queryrangebase.PrometheusResponse{")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	s = append(s, "Data: "+strings.Replace(this.Data.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "ErrorType: "+fmt.Sprintf("%#v", this.ErrorType)+",\n")
	s = append(s, "Error: "+fmt.Sprintf("%#v", this.Error)+",\n")
	if this.Headers != nil {
		s = append(s, "Headers: "+fmt.Sprintf("%#v", this.Headers)+",\n")
	}
	s = append(s, "Warnings: "+fmt.Sprintf("%#v", this.Warnings)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PrometheusData) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&queryrangebase.PrometheusData{")
	s = append(s, "ResultType: "+fmt.Sprintf("%#v", this.ResultType)+",\n")
	if this.Result != nil {
		vs := make([]*SampleStream, len(this.Result))
		for i := range vs {
			vs[i] = &this.Result[i]
		}
		s = append(s, "Result: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SampleStream) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&queryrangebase.SampleStream{")
	s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	if this.Samples != nil {
		vs := make([]*logproto.LegacySample, len(this.Samples))
		for i := range vs {
			vs[i] = &this.Samples[i]
		}
		s = append(s, "Samples: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringQueryrange(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *PrometheusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrometheusRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrometheusRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Headers) > 0 {
		for iNdEx := len(m.Headers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Headers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintQueryrange(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	{
		size, err := m.CachingOptions.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintQueryrange(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x3a
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintQueryrange(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0x32
	}
	n2, err2 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.Timeout, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.Timeout):])
	if err2 != nil {
		return 0, err2
	}
	i -= n2
	i = encodeVarintQueryrange(dAtA, i, uint64(n2))
	i--
	dAtA[i] = 0x2a
	if m.Step != 0 {
		i = encodeVarintQueryrange(dAtA, i, uint64(m.Step))
		i--
		dAtA[i] = 0x20
	}
	n3, err3 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.End, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.End):])
	if err3 != nil {
		return 0, err3
	}
	i -= n3
	i = encodeVarintQueryrange(dAtA, i, uint64(n3))
	i--
	dAtA[i] = 0x1a
	n4, err4 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Start, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.Start):])
	if err4 != nil {
		return 0, err4
	}
	i -= n4
	i = encodeVarintQueryrange(dAtA, i, uint64(n4))
	i--
	dAtA[i] = 0x12
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintQueryrange(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PrometheusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrometheusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrometheusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Warnings) > 0 {
		for iNdEx := len(m.Warnings) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Warnings[iNdEx])
			copy(dAtA[i:], m.Warnings[iNdEx])
			i = encodeVarintQueryrange(dAtA, i, uint64(len(m.Warnings[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Headers) > 0 {
		for iNdEx := len(m.Headers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Headers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintQueryrange(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintQueryrange(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ErrorType) > 0 {
		i -= len(m.ErrorType)
		copy(dAtA[i:], m.ErrorType)
		i = encodeVarintQueryrange(dAtA, i, uint64(len(m.ErrorType)))
		i--
		dAtA[i] = 0x1a
	}
	{
		size, err := m.Data.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintQueryrange(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintQueryrange(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PrometheusData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrometheusData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrometheusData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Result) > 0 {
		for iNdEx := len(m.Result) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Result[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintQueryrange(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ResultType) > 0 {
		i -= len(m.ResultType)
		copy(dAtA[i:], m.ResultType)
		i = encodeVarintQueryrange(dAtA, i, uint64(len(m.ResultType)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SampleStream) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SampleStream) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SampleStream) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Samples) > 0 {
		for iNdEx := len(m.Samples) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Samples[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintQueryrange(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size := m.Labels[iNdEx].Size()
				i -= size
				if _, err := m.Labels[iNdEx].MarshalTo(dAtA[i:]); err != nil {
					return 0, err
				}
				i = encodeVarintQueryrange(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintQueryrange(dAtA []byte, offset int, v uint64) int {
	offset -= sovQueryrange(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *PrometheusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovQueryrange(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Start)
	n += 1 + l + sovQueryrange(uint64(l))
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.End)
	n += 1 + l + sovQueryrange(uint64(l))
	if m.Step != 0 {
		n += 1 + sovQueryrange(uint64(m.Step))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.Timeout)
	n += 1 + l + sovQueryrange(uint64(l))
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovQueryrange(uint64(l))
	}
	l = m.CachingOptions.Size()
	n += 1 + l + sovQueryrange(uint64(l))
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovQueryrange(uint64(l))
		}
	}
	return n
}

func (m *PrometheusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Status)
	if l > 0 {
		n += 1 + l + sovQueryrange(uint64(l))
	}
	l = m.Data.Size()
	n += 1 + l + sovQueryrange(uint64(l))
	l = len(m.ErrorType)
	if l > 0 {
		n += 1 + l + sovQueryrange(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovQueryrange(uint64(l))
	}
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovQueryrange(uint64(l))
		}
	}
	if len(m.Warnings) > 0 {
		for _, s := range m.Warnings {
			l = len(s)
			n += 1 + l + sovQueryrange(uint64(l))
		}
	}
	return n
}

func (m *PrometheusData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ResultType)
	if l > 0 {
		n += 1 + l + sovQueryrange(uint64(l))
	}
	if len(m.Result) > 0 {
		for _, e := range m.Result {
			l = e.Size()
			n += 1 + l + sovQueryrange(uint64(l))
		}
	}
	return n
}

func (m *SampleStream) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovQueryrange(uint64(l))
		}
	}
	if len(m.Samples) > 0 {
		for _, e := range m.Samples {
			l = e.Size()
			n += 1 + l + sovQueryrange(uint64(l))
		}
	}
	return n
}

func sovQueryrange(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozQueryrange(x uint64) (n int) {
	return sovQueryrange(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *PrometheusRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForHeaders := "[]*PrometheusRequestHeader{"
	for _, f := range this.Headers {
		repeatedStringForHeaders += strings.Replace(fmt.Sprintf("%v", f), "PrometheusRequestHeader", "definitions.PrometheusRequestHeader", 1) + ","
	}
	repeatedStringForHeaders += "}"
	s := strings.Join([]string{`&PrometheusRequest{`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`Start:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Start), "Timestamp", "types.Timestamp", 1), `&`, ``, 1) + `,`,
		`End:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.End), "Timestamp", "types.Timestamp", 1), `&`, ``, 1) + `,`,
		`Step:` + fmt.Sprintf("%v", this.Step) + `,`,
		`Timeout:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Timeout), "Duration", "durationpb.Duration", 1), `&`, ``, 1) + `,`,
		`Query:` + fmt.Sprintf("%v", this.Query) + `,`,
		`CachingOptions:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.CachingOptions), "CachingOptions", "resultscache.CachingOptions", 1), `&`, ``, 1) + `,`,
		`Headers:` + repeatedStringForHeaders + `,`,
		`}`,
	}, "")
	return s
}
func (this *PrometheusResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForHeaders := "[]*PrometheusResponseHeader{"
	for _, f := range this.Headers {
		repeatedStringForHeaders += strings.Replace(fmt.Sprintf("%v", f), "PrometheusResponseHeader", "definitions.PrometheusResponseHeader", 1) + ","
	}
	repeatedStringForHeaders += "}"
	s := strings.Join([]string{`&PrometheusResponse{`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`Data:` + strings.Replace(strings.Replace(this.Data.String(), "PrometheusData", "PrometheusData", 1), `&`, ``, 1) + `,`,
		`ErrorType:` + fmt.Sprintf("%v", this.ErrorType) + `,`,
		`Error:` + fmt.Sprintf("%v", this.Error) + `,`,
		`Headers:` + repeatedStringForHeaders + `,`,
		`Warnings:` + fmt.Sprintf("%v", this.Warnings) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PrometheusData) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForResult := "[]SampleStream{"
	for _, f := range this.Result {
		repeatedStringForResult += strings.Replace(strings.Replace(f.String(), "SampleStream", "SampleStream", 1), `&`, ``, 1) + ","
	}
	repeatedStringForResult += "}"
	s := strings.Join([]string{`&PrometheusData{`,
		`ResultType:` + fmt.Sprintf("%v", this.ResultType) + `,`,
		`Result:` + repeatedStringForResult + `,`,
		`}`,
	}, "")
	return s
}
func (this *SampleStream) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForSamples := "[]LegacySample{"
	for _, f := range this.Samples {
		repeatedStringForSamples += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForSamples += "}"
	s := strings.Join([]string{`&SampleStream{`,
		`Labels:` + fmt.Sprintf("%v", this.Labels) + `,`,
		`Samples:` + repeatedStringForSamples + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringQueryrange(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *PrometheusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQueryrange
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrometheusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrometheusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Start, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.End, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Step", wireType)
			}
			m.Step = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Step |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.Timeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CachingOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.CachingOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &definitions.PrometheusRequestHeader{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQueryrange(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQueryrange
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQueryrange
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrometheusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQueryrange
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrometheusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrometheusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &definitions.PrometheusResponseHeader{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQueryrange(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQueryrange
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQueryrange
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrometheusData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQueryrange
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrometheusData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrometheusData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResultType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResultType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Result = append(m.Result, SampleStream{})
			if err := m.Result[len(m.Result)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQueryrange(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQueryrange
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQueryrange
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SampleStream) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQueryrange
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SampleStream: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SampleStream: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, github_com_grafana_loki_v3_pkg_logproto.LabelAdapter{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Samples", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQueryrange
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthQueryrange
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Samples = append(m.Samples, logproto.LegacySample{})
			if err := m.Samples[len(m.Samples)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQueryrange(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQueryrange
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthQueryrange
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipQueryrange(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowQueryrange
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQueryrange
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthQueryrange
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthQueryrange
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowQueryrange
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipQueryrange(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthQueryrange
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthQueryrange = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowQueryrange   = fmt.Errorf("proto: integer overflow")
)
