// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: pkg/logproto/indexgateway.proto

package logproto

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	stats "github.com/grafana/loki/v3/pkg/logqlmodel/stats"
	github_com_prometheus_common_model "github.com/prometheus/common/model"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type ShardsRequest struct {
	From                github_com_prometheus_common_model.Time `protobuf:"varint,1,opt,name=from,proto3,customtype=github.com/prometheus/common/model.Time" json:"from"`
	Through             github_com_prometheus_common_model.Time `protobuf:"varint,2,opt,name=through,proto3,customtype=github.com/prometheus/common/model.Time" json:"through"`
	Query               string                                  `protobuf:"bytes,3,opt,name=query,proto3" json:"query"`
	TargetBytesPerShard uint64                                  `protobuf:"varint,4,opt,name=targetBytesPerShard,proto3" json:"targetBytesPerShard"`
}

func (m *ShardsRequest) Reset()      { *m = ShardsRequest{} }
func (*ShardsRequest) ProtoMessage() {}
func (*ShardsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d27585148d0a52c8, []int{0}
}
func (m *ShardsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ShardsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ShardsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ShardsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardsRequest.Merge(m, src)
}
func (m *ShardsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ShardsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ShardsRequest proto.InternalMessageInfo

func (m *ShardsRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *ShardsRequest) GetTargetBytesPerShard() uint64 {
	if m != nil {
		return m.TargetBytesPerShard
	}
	return 0
}

type ShardsResponse struct {
	Shards     []Shard      `protobuf:"bytes,1,rep,name=shards,proto3" json:"shards"`
	Statistics stats.Result `protobuf:"bytes,2,opt,name=statistics,proto3" json:"statistics"`
	// If present, includes the chunk refs for each shard,
	// therefore the length will be equal to the length of the `shards` field.
	ChunkGroups []ChunkRefGroup `protobuf:"bytes,3,rep,name=chunkGroups,proto3" json:"chunkGroups"`
}

func (m *ShardsResponse) Reset()      { *m = ShardsResponse{} }
func (*ShardsResponse) ProtoMessage() {}
func (*ShardsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d27585148d0a52c8, []int{1}
}
func (m *ShardsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ShardsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ShardsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ShardsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardsResponse.Merge(m, src)
}
func (m *ShardsResponse) XXX_Size() int {
	return m.Size()
}
func (m *ShardsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ShardsResponse proto.InternalMessageInfo

func (m *ShardsResponse) GetShards() []Shard {
	if m != nil {
		return m.Shards
	}
	return nil
}

func (m *ShardsResponse) GetStatistics() stats.Result {
	if m != nil {
		return m.Statistics
	}
	return stats.Result{}
}

func (m *ShardsResponse) GetChunkGroups() []ChunkRefGroup {
	if m != nil {
		return m.ChunkGroups
	}
	return nil
}

type Shard struct {
	Bounds FPBounds            `protobuf:"bytes,1,opt,name=bounds,proto3" json:"bounds"`
	Stats  *IndexStatsResponse `protobuf:"bytes,2,opt,name=stats,proto3" json:"stats"`
}

func (m *Shard) Reset()      { *m = Shard{} }
func (*Shard) ProtoMessage() {}
func (*Shard) Descriptor() ([]byte, []int) {
	return fileDescriptor_d27585148d0a52c8, []int{2}
}
func (m *Shard) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Shard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Shard.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Shard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard.Merge(m, src)
}
func (m *Shard) XXX_Size() int {
	return m.Size()
}
func (m *Shard) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard.DiscardUnknown(m)
}

var xxx_messageInfo_Shard proto.InternalMessageInfo

func (m *Shard) GetBounds() FPBounds {
	if m != nil {
		return m.Bounds
	}
	return FPBounds{}
}

func (m *Shard) GetStats() *IndexStatsResponse {
	if m != nil {
		return m.Stats
	}
	return nil
}

// FPBounds is identical to the definition in `pkg/storage/bloom/v1/bounds.FingerprintBounds`
// which ensures we can cast between them without allocations.
type FPBounds struct {
	Min github_com_prometheus_common_model.Fingerprint `protobuf:"varint,1,opt,name=min,proto3,casttype=github.com/prometheus/common/model.Fingerprint" json:"min"`
	Max github_com_prometheus_common_model.Fingerprint `protobuf:"varint,2,opt,name=max,proto3,casttype=github.com/prometheus/common/model.Fingerprint" json:"max"`
}

func (m *FPBounds) Reset()      { *m = FPBounds{} }
func (*FPBounds) ProtoMessage() {}
func (*FPBounds) Descriptor() ([]byte, []int) {
	return fileDescriptor_d27585148d0a52c8, []int{3}
}
func (m *FPBounds) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FPBounds) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FPBounds.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FPBounds) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FPBounds.Merge(m, src)
}
func (m *FPBounds) XXX_Size() int {
	return m.Size()
}
func (m *FPBounds) XXX_DiscardUnknown() {
	xxx_messageInfo_FPBounds.DiscardUnknown(m)
}

var xxx_messageInfo_FPBounds proto.InternalMessageInfo

func (m *FPBounds) GetMin() github_com_prometheus_common_model.Fingerprint {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *FPBounds) GetMax() github_com_prometheus_common_model.Fingerprint {
	if m != nil {
		return m.Max
	}
	return 0
}

func init() {
	proto.RegisterType((*ShardsRequest)(nil), "indexgatewaypb.ShardsRequest")
	proto.RegisterType((*ShardsResponse)(nil), "indexgatewaypb.ShardsResponse")
	proto.RegisterType((*Shard)(nil), "indexgatewaypb.Shard")
	proto.RegisterType((*FPBounds)(nil), "indexgatewaypb.FPBounds")
}

func init() { proto.RegisterFile("pkg/logproto/indexgateway.proto", fileDescriptor_d27585148d0a52c8) }

var fileDescriptor_d27585148d0a52c8 = []byte{
	// 751 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0xbf, 0x4f, 0xdb, 0x40,
	0x14, 0xf6, 0x91, 0x84, 0xc2, 0xa5, 0x30, 0x1c, 0xad, 0x62, 0x05, 0xb0, 0xa3, 0x2c, 0x4d, 0x17,
	0xbb, 0x82, 0xa1, 0x6a, 0x25, 0x24, 0xea, 0x4a, 0x89, 0x10, 0x14, 0x51, 0x83, 0x18, 0x2a, 0xb5,
	0xaa, 0x13, 0x0e, 0xc7, 0xc2, 0xf6, 0x05, 0xdf, 0xb9, 0x0d, 0x5b, 0xc7, 0xaa, 0x53, 0xff, 0x82,
	0x4e, 0x1d, 0xfa, 0xa7, 0x30, 0x32, 0xa2, 0x0e, 0x56, 0x31, 0x4b, 0x95, 0x89, 0xb9, 0x53, 0xe5,
	0x3b, 0x3b, 0x31, 0x21, 0x48, 0xb4, 0x8b, 0xef, 0xee, 0x7d, 0xdf, 0xfb, 0xee, 0xfd, 0xca, 0x05,
	0xaa, 0xbd, 0x23, 0x5b, 0x77, 0x89, 0xdd, 0x0b, 0x08, 0x23, 0xba, 0xe3, 0x1f, 0xe0, 0xbe, 0x6d,
	0x31, 0xfc, 0xd1, 0x3a, 0xd1, 0xb8, 0x09, 0xcd, 0xe7, 0x6d, 0xbd, 0x76, 0xf5, 0x81, 0x4d, 0x6c,
	0x22, 0xd8, 0xc9, 0x4e, 0xb0, 0xaa, 0x8b, 0xd7, 0x64, 0xb2, 0x4d, 0x0a, 0xd6, 0x52, 0xf0, 0xd8,
	0xf5, 0xc8, 0x01, 0x76, 0x75, 0xca, 0x2c, 0x46, 0xc5, 0x57, 0x30, 0xea, 0xdf, 0xa6, 0xe0, 0xdc,
	0x6e, 0xd7, 0x0a, 0x0e, 0xa8, 0x89, 0x8f, 0x43, 0x4c, 0x19, 0xda, 0x84, 0xc5, 0xc3, 0x80, 0x78,
	0x32, 0xa8, 0x81, 0x46, 0xc1, 0x78, 0x7a, 0x1a, 0xa9, 0xd2, 0xcf, 0x48, 0x7d, 0x64, 0x3b, 0xac,
	0x1b, 0xb6, 0xb5, 0x0e, 0xf1, 0xf4, 0x5e, 0x40, 0x3c, 0xcc, 0xba, 0x38, 0xa4, 0x7a, 0x87, 0x78,
	0x1e, 0xf1, 0x75, 0xae, 0xae, 0xed, 0x39, 0x1e, 0x1e, 0x44, 0x2a, 0x77, 0x37, 0xf9, 0x17, 0xed,
	0xc1, 0x7b, 0xac, 0x1b, 0x90, 0xd0, 0xee, 0xca, 0x53, 0x5c, 0xef, 0xf9, 0xbf, 0xeb, 0x65, 0x0a,
	0x66, 0xb6, 0x41, 0x2a, 0x2c, 0x1d, 0x87, 0x38, 0x38, 0x91, 0x0b, 0x35, 0xd0, 0x98, 0x35, 0x66,
	0x07, 0x91, 0x2a, 0x0c, 0xa6, 0x58, 0xd0, 0x06, 0x5c, 0x60, 0x56, 0x60, 0x63, 0x66, 0x9c, 0x30,
	0x4c, 0x77, 0x70, 0xc0, 0x53, 0x94, 0x8b, 0x35, 0xd0, 0x28, 0x1a, 0x95, 0x41, 0xa4, 0x4e, 0x82,
	0xcd, 0x49, 0xc6, 0x7a, 0x0c, 0xe0, 0x7c, 0x56, 0x20, 0xda, 0x23, 0x3e, 0xc5, 0x68, 0x0d, 0x4e,
	0x53, 0x6e, 0x91, 0x41, 0xad, 0xd0, 0x28, 0xaf, 0x3c, 0xd4, 0xae, 0x77, 0x4a, 0xe3, 0x7c, 0x63,
	0x3e, 0x49, 0x75, 0x10, 0xa9, 0x29, 0xd9, 0x4c, 0x57, 0xf4, 0x02, 0xc2, 0xa4, 0x03, 0x0e, 0x65,
	0x4e, 0x87, 0xf2, 0xb2, 0x94, 0x57, 0xe6, 0x34, 0xd1, 0x14, 0x13, 0xd3, 0xd0, 0x65, 0x06, 0x4a,
	0x5d, 0x73, 0x44, 0x33, 0xb7, 0x47, 0xdb, 0xb0, 0xdc, 0xe9, 0x86, 0xfe, 0x51, 0x2b, 0x20, 0x61,
	0x8f, 0xca, 0x05, 0x1e, 0x46, 0x45, 0x1b, 0x76, 0xff, 0x65, 0x02, 0x9a, 0xf8, 0x90, 0xe3, 0xc6,
	0x42, 0xaa, 0x96, 0xf7, 0x31, 0xf3, 0x87, 0xfa, 0x67, 0x00, 0x4b, 0x3c, 0x68, 0xb4, 0x0e, 0xa7,
	0xdb, 0x24, 0xf4, 0x79, 0x6e, 0x49, 0x60, 0xf2, 0x78, 0x6e, 0xcd, 0x1d, 0x83, 0xe3, 0xa3, 0xf4,
	0x04, 0xdf, 0x4c, 0x57, 0xb4, 0x06, 0x4b, 0x3c, 0x97, 0x34, 0xb3, 0xa5, 0x51, 0x54, 0x1b, 0x89,
	0xd2, 0x6e, 0x82, 0x65, 0xa5, 0x14, 0xad, 0xe3, 0x74, 0x53, 0x2c, 0xf5, 0xef, 0x00, 0xce, 0x64,
	0x77, 0xa0, 0x4d, 0x58, 0xf0, 0x1c, 0x9f, 0x87, 0x52, 0x34, 0x9e, 0x0d, 0x22, 0x35, 0x39, 0xfe,
	0x89, 0x54, 0xed, 0x0e, 0xd3, 0xd3, 0x74, 0x7c, 0x1b, 0x07, 0xbd, 0xc0, 0xf1, 0x99, 0x99, 0xb8,
	0x71, 0x31, 0xab, 0xcf, 0xc3, 0xca, 0xc4, 0xac, 0xfe, 0x7f, 0x89, 0x59, 0xfd, 0x95, 0x2f, 0x25,
	0x78, 0x9f, 0xe7, 0xd3, 0x12, 0x95, 0x41, 0x1b, 0x10, 0xbe, 0x4e, 0x66, 0x8f, 0x1b, 0xd1, 0xe2,
	0x28, 0xeb, 0x91, 0x35, 0xfd, 0x85, 0x55, 0x97, 0x26, 0x83, 0xa2, 0x24, 0x4f, 0x00, 0xda, 0x82,
	0xe5, 0x16, 0x66, 0x59, 0x0f, 0x51, 0x8e, 0x9e, 0x33, 0x67, 0x62, 0xcb, 0xb7, 0xa0, 0x42, 0xad,
	0x2e, 0xa1, 0x26, 0x9c, 0x6d, 0x61, 0xb6, 0x8b, 0x03, 0x07, 0x53, 0x54, 0xbd, 0xc6, 0x16, 0xc6,
	0x4c, 0x69, 0x71, 0x22, 0x36, 0xd4, 0x79, 0x07, 0x2b, 0x5b, 0x56, 0x1b, 0xbb, 0xdb, 0x96, 0x87,
	0x69, 0x93, 0x04, 0xaf, 0x30, 0x0b, 0x9c, 0x4e, 0x72, 0x42, 0x8d, 0x91, 0xe7, 0x2d, 0x94, 0xec,
	0x8e, 0xca, 0x18, 0x33, 0xa7, 0xff, 0x1e, 0xca, 0xdc, 0xb4, 0x6f, 0xb9, 0xe1, 0xf8, 0x05, 0x8f,
	0xc7, 0xdc, 0x26, 0x70, 0xee, 0x70, 0x43, 0x0b, 0xce, 0x24, 0x89, 0x25, 0x63, 0x96, 0x6f, 0x50,
	0x7e, 0x2c, 0x6f, 0x34, 0xe8, 0xe6, 0xcc, 0xd6, 0x25, 0xb4, 0xce, 0x4b, 0xba, 0x4f, 0xdc, 0xd0,
	0xc3, 0x28, 0x77, 0xa1, 0xb0, 0x64, 0x2a, 0xf2, 0x4d, 0x60, 0xa8, 0xb0, 0x25, 0x9a, 0x22, 0x1e,
	0x84, 0xe5, 0x89, 0xef, 0xc7, 0x30, 0x1a, 0xe5, 0x36, 0x38, 0x1b, 0x18, 0xe3, 0xed, 0xd9, 0x85,
	0x22, 0x9d, 0x5f, 0x28, 0xd2, 0xd5, 0x85, 0x02, 0x3e, 0xc5, 0x0a, 0xf8, 0x11, 0x2b, 0xe0, 0x34,
	0x56, 0xc0, 0x59, 0xac, 0x80, 0x5f, 0xb1, 0x02, 0x7e, 0xc7, 0x8a, 0x74, 0x15, 0x2b, 0xe0, 0xeb,
	0xa5, 0x22, 0x9d, 0x5d, 0x2a, 0xd2, 0xf9, 0xa5, 0x22, 0xbd, 0xc9, 0x3f, 0xc1, 0x76, 0x60, 0x1d,
	0x5a, 0xbe, 0xa5, 0xbb, 0xe4, 0xc8, 0xd1, 0x3f, 0xac, 0xea, 0xf9, 0x3f, 0x95, 0xf6, 0x34, 0x5f,
	0x56, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0xc1, 0xeb, 0x83, 0x96, 0xb2, 0x06, 0x00, 0x00,
}

func (this *ShardsRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ShardsRequest)
	if !ok {
		that2, ok := that.(ShardsRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.From.Equal(that1.From) {
		return false
	}
	if !this.Through.Equal(that1.Through) {
		return false
	}
	if this.Query != that1.Query {
		return false
	}
	if this.TargetBytesPerShard != that1.TargetBytesPerShard {
		return false
	}
	return true
}
func (this *ShardsResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ShardsResponse)
	if !ok {
		that2, ok := that.(ShardsResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Shards) != len(that1.Shards) {
		return false
	}
	for i := range this.Shards {
		if !this.Shards[i].Equal(&that1.Shards[i]) {
			return false
		}
	}
	if !this.Statistics.Equal(&that1.Statistics) {
		return false
	}
	if len(this.ChunkGroups) != len(that1.ChunkGroups) {
		return false
	}
	for i := range this.ChunkGroups {
		if !this.ChunkGroups[i].Equal(&that1.ChunkGroups[i]) {
			return false
		}
	}
	return true
}
func (this *Shard) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Shard)
	if !ok {
		that2, ok := that.(Shard)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Bounds.Equal(&that1.Bounds) {
		return false
	}
	if !this.Stats.Equal(that1.Stats) {
		return false
	}
	return true
}
func (this *FPBounds) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*FPBounds)
	if !ok {
		that2, ok := that.(FPBounds)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Min != that1.Min {
		return false
	}
	if this.Max != that1.Max {
		return false
	}
	return true
}
func (this *ShardsRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&logproto.ShardsRequest{")
	s = append(s, "From: "+fmt.Sprintf("%#v", this.From)+",\n")
	s = append(s, "Through: "+fmt.Sprintf("%#v", this.Through)+",\n")
	s = append(s, "Query: "+fmt.Sprintf("%#v", this.Query)+",\n")
	s = append(s, "TargetBytesPerShard: "+fmt.Sprintf("%#v", this.TargetBytesPerShard)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ShardsResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&logproto.ShardsResponse{")
	if this.Shards != nil {
		vs := make([]*Shard, len(this.Shards))
		for i := range vs {
			vs[i] = &this.Shards[i]
		}
		s = append(s, "Shards: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "Statistics: "+strings.Replace(this.Statistics.GoString(), `&`, ``, 1)+",\n")
	if this.ChunkGroups != nil {
		vs := make([]*ChunkRefGroup, len(this.ChunkGroups))
		for i := range vs {
			vs[i] = &this.ChunkGroups[i]
		}
		s = append(s, "ChunkGroups: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Shard) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&logproto.Shard{")
	s = append(s, "Bounds: "+strings.Replace(this.Bounds.GoString(), `&`, ``, 1)+",\n")
	if this.Stats != nil {
		s = append(s, "Stats: "+fmt.Sprintf("%#v", this.Stats)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FPBounds) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&logproto.FPBounds{")
	s = append(s, "Min: "+fmt.Sprintf("%#v", this.Min)+",\n")
	s = append(s, "Max: "+fmt.Sprintf("%#v", this.Max)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringIndexgateway(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// IndexGatewayClient is the client API for IndexGateway service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IndexGatewayClient interface {
	/// QueryIndex reads the indexes required for given query & sends back the batch of rows
	/// in rpc streams
	QueryIndex(ctx context.Context, in *QueryIndexRequest, opts ...grpc.CallOption) (IndexGateway_QueryIndexClient, error)
	/// GetChunkRef returns chunk reference that match the provided label matchers
	GetChunkRef(ctx context.Context, in *GetChunkRefRequest, opts ...grpc.CallOption) (*GetChunkRefResponse, error)
	GetSeries(ctx context.Context, in *GetSeriesRequest, opts ...grpc.CallOption) (*GetSeriesResponse, error)
	LabelNamesForMetricName(ctx context.Context, in *LabelNamesForMetricNameRequest, opts ...grpc.CallOption) (*LabelResponse, error)
	LabelValuesForMetricName(ctx context.Context, in *LabelValuesForMetricNameRequest, opts ...grpc.CallOption) (*LabelResponse, error)
	// Note: this MUST be the same as the variant defined in
	// logproto.proto on the Querier service.
	GetStats(ctx context.Context, in *IndexStatsRequest, opts ...grpc.CallOption) (*IndexStatsResponse, error)
	// Note: this MUST be the same as the variant defined in
	// logproto.proto on the Querier service.
	GetVolume(ctx context.Context, in *VolumeRequest, opts ...grpc.CallOption) (*VolumeResponse, error)
	// GetShards is an optimized implemented shard-planning implementation
	// on the index gateway and not on the ingester.
	GetShards(ctx context.Context, in *ShardsRequest, opts ...grpc.CallOption) (IndexGateway_GetShardsClient, error)
}

type indexGatewayClient struct {
	cc *grpc.ClientConn
}

func NewIndexGatewayClient(cc *grpc.ClientConn) IndexGatewayClient {
	return &indexGatewayClient{cc}
}

func (c *indexGatewayClient) QueryIndex(ctx context.Context, in *QueryIndexRequest, opts ...grpc.CallOption) (IndexGateway_QueryIndexClient, error) {
	stream, err := c.cc.NewStream(ctx, &_IndexGateway_serviceDesc.Streams[0], "/indexgatewaypb.IndexGateway/QueryIndex", opts...)
	if err != nil {
		return nil, err
	}
	x := &indexGatewayQueryIndexClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type IndexGateway_QueryIndexClient interface {
	Recv() (*QueryIndexResponse, error)
	grpc.ClientStream
}

type indexGatewayQueryIndexClient struct {
	grpc.ClientStream
}

func (x *indexGatewayQueryIndexClient) Recv() (*QueryIndexResponse, error) {
	m := new(QueryIndexResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *indexGatewayClient) GetChunkRef(ctx context.Context, in *GetChunkRefRequest, opts ...grpc.CallOption) (*GetChunkRefResponse, error) {
	out := new(GetChunkRefResponse)
	err := c.cc.Invoke(ctx, "/indexgatewaypb.IndexGateway/GetChunkRef", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *indexGatewayClient) GetSeries(ctx context.Context, in *GetSeriesRequest, opts ...grpc.CallOption) (*GetSeriesResponse, error) {
	out := new(GetSeriesResponse)
	err := c.cc.Invoke(ctx, "/indexgatewaypb.IndexGateway/GetSeries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *indexGatewayClient) LabelNamesForMetricName(ctx context.Context, in *LabelNamesForMetricNameRequest, opts ...grpc.CallOption) (*LabelResponse, error) {
	out := new(LabelResponse)
	err := c.cc.Invoke(ctx, "/indexgatewaypb.IndexGateway/LabelNamesForMetricName", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *indexGatewayClient) LabelValuesForMetricName(ctx context.Context, in *LabelValuesForMetricNameRequest, opts ...grpc.CallOption) (*LabelResponse, error) {
	out := new(LabelResponse)
	err := c.cc.Invoke(ctx, "/indexgatewaypb.IndexGateway/LabelValuesForMetricName", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *indexGatewayClient) GetStats(ctx context.Context, in *IndexStatsRequest, opts ...grpc.CallOption) (*IndexStatsResponse, error) {
	out := new(IndexStatsResponse)
	err := c.cc.Invoke(ctx, "/indexgatewaypb.IndexGateway/GetStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *indexGatewayClient) GetVolume(ctx context.Context, in *VolumeRequest, opts ...grpc.CallOption) (*VolumeResponse, error) {
	out := new(VolumeResponse)
	err := c.cc.Invoke(ctx, "/indexgatewaypb.IndexGateway/GetVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *indexGatewayClient) GetShards(ctx context.Context, in *ShardsRequest, opts ...grpc.CallOption) (IndexGateway_GetShardsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_IndexGateway_serviceDesc.Streams[1], "/indexgatewaypb.IndexGateway/GetShards", opts...)
	if err != nil {
		return nil, err
	}
	x := &indexGatewayGetShardsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type IndexGateway_GetShardsClient interface {
	Recv() (*ShardsResponse, error)
	grpc.ClientStream
}

type indexGatewayGetShardsClient struct {
	grpc.ClientStream
}

func (x *indexGatewayGetShardsClient) Recv() (*ShardsResponse, error) {
	m := new(ShardsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// IndexGatewayServer is the server API for IndexGateway service.
type IndexGatewayServer interface {
	/// QueryIndex reads the indexes required for given query & sends back the batch of rows
	/// in rpc streams
	QueryIndex(*QueryIndexRequest, IndexGateway_QueryIndexServer) error
	/// GetChunkRef returns chunk reference that match the provided label matchers
	GetChunkRef(context.Context, *GetChunkRefRequest) (*GetChunkRefResponse, error)
	GetSeries(context.Context, *GetSeriesRequest) (*GetSeriesResponse, error)
	LabelNamesForMetricName(context.Context, *LabelNamesForMetricNameRequest) (*LabelResponse, error)
	LabelValuesForMetricName(context.Context, *LabelValuesForMetricNameRequest) (*LabelResponse, error)
	// Note: this MUST be the same as the variant defined in
	// logproto.proto on the Querier service.
	GetStats(context.Context, *IndexStatsRequest) (*IndexStatsResponse, error)
	// Note: this MUST be the same as the variant defined in
	// logproto.proto on the Querier service.
	GetVolume(context.Context, *VolumeRequest) (*VolumeResponse, error)
	// GetShards is an optimized implemented shard-planning implementation
	// on the index gateway and not on the ingester.
	GetShards(*ShardsRequest, IndexGateway_GetShardsServer) error
}

// UnimplementedIndexGatewayServer can be embedded to have forward compatible implementations.
type UnimplementedIndexGatewayServer struct {
}

func (*UnimplementedIndexGatewayServer) QueryIndex(req *QueryIndexRequest, srv IndexGateway_QueryIndexServer) error {
	return status.Errorf(codes.Unimplemented, "method QueryIndex not implemented")
}
func (*UnimplementedIndexGatewayServer) GetChunkRef(ctx context.Context, req *GetChunkRefRequest) (*GetChunkRefResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChunkRef not implemented")
}
func (*UnimplementedIndexGatewayServer) GetSeries(ctx context.Context, req *GetSeriesRequest) (*GetSeriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSeries not implemented")
}
func (*UnimplementedIndexGatewayServer) LabelNamesForMetricName(ctx context.Context, req *LabelNamesForMetricNameRequest) (*LabelResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LabelNamesForMetricName not implemented")
}
func (*UnimplementedIndexGatewayServer) LabelValuesForMetricName(ctx context.Context, req *LabelValuesForMetricNameRequest) (*LabelResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LabelValuesForMetricName not implemented")
}
func (*UnimplementedIndexGatewayServer) GetStats(ctx context.Context, req *IndexStatsRequest) (*IndexStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStats not implemented")
}
func (*UnimplementedIndexGatewayServer) GetVolume(ctx context.Context, req *VolumeRequest) (*VolumeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVolume not implemented")
}
func (*UnimplementedIndexGatewayServer) GetShards(req *ShardsRequest, srv IndexGateway_GetShardsServer) error {
	return status.Errorf(codes.Unimplemented, "method GetShards not implemented")
}

func RegisterIndexGatewayServer(s *grpc.Server, srv IndexGatewayServer) {
	s.RegisterService(&_IndexGateway_serviceDesc, srv)
}

func _IndexGateway_QueryIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(QueryIndexRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(IndexGatewayServer).QueryIndex(m, &indexGatewayQueryIndexServer{stream})
}

type IndexGateway_QueryIndexServer interface {
	Send(*QueryIndexResponse) error
	grpc.ServerStream
}

type indexGatewayQueryIndexServer struct {
	grpc.ServerStream
}

func (x *indexGatewayQueryIndexServer) Send(m *QueryIndexResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _IndexGateway_GetChunkRef_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetChunkRefRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IndexGatewayServer).GetChunkRef(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/indexgatewaypb.IndexGateway/GetChunkRef",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IndexGatewayServer).GetChunkRef(ctx, req.(*GetChunkRefRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IndexGateway_GetSeries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSeriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IndexGatewayServer).GetSeries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/indexgatewaypb.IndexGateway/GetSeries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IndexGatewayServer).GetSeries(ctx, req.(*GetSeriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IndexGateway_LabelNamesForMetricName_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelNamesForMetricNameRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IndexGatewayServer).LabelNamesForMetricName(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/indexgatewaypb.IndexGateway/LabelNamesForMetricName",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IndexGatewayServer).LabelNamesForMetricName(ctx, req.(*LabelNamesForMetricNameRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IndexGateway_LabelValuesForMetricName_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelValuesForMetricNameRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IndexGatewayServer).LabelValuesForMetricName(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/indexgatewaypb.IndexGateway/LabelValuesForMetricName",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IndexGatewayServer).LabelValuesForMetricName(ctx, req.(*LabelValuesForMetricNameRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IndexGateway_GetStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IndexStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IndexGatewayServer).GetStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/indexgatewaypb.IndexGateway/GetStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IndexGatewayServer).GetStats(ctx, req.(*IndexStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IndexGateway_GetVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IndexGatewayServer).GetVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/indexgatewaypb.IndexGateway/GetVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IndexGatewayServer).GetVolume(ctx, req.(*VolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IndexGateway_GetShards_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ShardsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(IndexGatewayServer).GetShards(m, &indexGatewayGetShardsServer{stream})
}

type IndexGateway_GetShardsServer interface {
	Send(*ShardsResponse) error
	grpc.ServerStream
}

type indexGatewayGetShardsServer struct {
	grpc.ServerStream
}

func (x *indexGatewayGetShardsServer) Send(m *ShardsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _IndexGateway_serviceDesc = grpc.ServiceDesc{
	ServiceName: "indexgatewaypb.IndexGateway",
	HandlerType: (*IndexGatewayServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetChunkRef",
			Handler:    _IndexGateway_GetChunkRef_Handler,
		},
		{
			MethodName: "GetSeries",
			Handler:    _IndexGateway_GetSeries_Handler,
		},
		{
			MethodName: "LabelNamesForMetricName",
			Handler:    _IndexGateway_LabelNamesForMetricName_Handler,
		},
		{
			MethodName: "LabelValuesForMetricName",
			Handler:    _IndexGateway_LabelValuesForMetricName_Handler,
		},
		{
			MethodName: "GetStats",
			Handler:    _IndexGateway_GetStats_Handler,
		},
		{
			MethodName: "GetVolume",
			Handler:    _IndexGateway_GetVolume_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "QueryIndex",
			Handler:       _IndexGateway_QueryIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetShards",
			Handler:       _IndexGateway_GetShards_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "pkg/logproto/indexgateway.proto",
}

func (m *ShardsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ShardsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ShardsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TargetBytesPerShard != 0 {
		i = encodeVarintIndexgateway(dAtA, i, uint64(m.TargetBytesPerShard))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Query) > 0 {
		i -= len(m.Query)
		copy(dAtA[i:], m.Query)
		i = encodeVarintIndexgateway(dAtA, i, uint64(len(m.Query)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Through != 0 {
		i = encodeVarintIndexgateway(dAtA, i, uint64(m.Through))
		i--
		dAtA[i] = 0x10
	}
	if m.From != 0 {
		i = encodeVarintIndexgateway(dAtA, i, uint64(m.From))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ShardsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ShardsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ShardsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ChunkGroups) > 0 {
		for iNdEx := len(m.ChunkGroups) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ChunkGroups[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintIndexgateway(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	{
		size, err := m.Statistics.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintIndexgateway(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	if len(m.Shards) > 0 {
		for iNdEx := len(m.Shards) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Shards[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintIndexgateway(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Shard) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Shard) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Shard) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Stats != nil {
		{
			size, err := m.Stats.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIndexgateway(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	{
		size, err := m.Bounds.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintIndexgateway(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *FPBounds) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FPBounds) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FPBounds) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Max != 0 {
		i = encodeVarintIndexgateway(dAtA, i, uint64(m.Max))
		i--
		dAtA[i] = 0x10
	}
	if m.Min != 0 {
		i = encodeVarintIndexgateway(dAtA, i, uint64(m.Min))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintIndexgateway(dAtA []byte, offset int, v uint64) int {
	offset -= sovIndexgateway(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ShardsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.From != 0 {
		n += 1 + sovIndexgateway(uint64(m.From))
	}
	if m.Through != 0 {
		n += 1 + sovIndexgateway(uint64(m.Through))
	}
	l = len(m.Query)
	if l > 0 {
		n += 1 + l + sovIndexgateway(uint64(l))
	}
	if m.TargetBytesPerShard != 0 {
		n += 1 + sovIndexgateway(uint64(m.TargetBytesPerShard))
	}
	return n
}

func (m *ShardsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Shards) > 0 {
		for _, e := range m.Shards {
			l = e.Size()
			n += 1 + l + sovIndexgateway(uint64(l))
		}
	}
	l = m.Statistics.Size()
	n += 1 + l + sovIndexgateway(uint64(l))
	if len(m.ChunkGroups) > 0 {
		for _, e := range m.ChunkGroups {
			l = e.Size()
			n += 1 + l + sovIndexgateway(uint64(l))
		}
	}
	return n
}

func (m *Shard) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Bounds.Size()
	n += 1 + l + sovIndexgateway(uint64(l))
	if m.Stats != nil {
		l = m.Stats.Size()
		n += 1 + l + sovIndexgateway(uint64(l))
	}
	return n
}

func (m *FPBounds) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Min != 0 {
		n += 1 + sovIndexgateway(uint64(m.Min))
	}
	if m.Max != 0 {
		n += 1 + sovIndexgateway(uint64(m.Max))
	}
	return n
}

func sovIndexgateway(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozIndexgateway(x uint64) (n int) {
	return sovIndexgateway(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ShardsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ShardsRequest{`,
		`From:` + fmt.Sprintf("%v", this.From) + `,`,
		`Through:` + fmt.Sprintf("%v", this.Through) + `,`,
		`Query:` + fmt.Sprintf("%v", this.Query) + `,`,
		`TargetBytesPerShard:` + fmt.Sprintf("%v", this.TargetBytesPerShard) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ShardsResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForShards := "[]Shard{"
	for _, f := range this.Shards {
		repeatedStringForShards += strings.Replace(strings.Replace(f.String(), "Shard", "Shard", 1), `&`, ``, 1) + ","
	}
	repeatedStringForShards += "}"
	repeatedStringForChunkGroups := "[]ChunkRefGroup{"
	for _, f := range this.ChunkGroups {
		repeatedStringForChunkGroups += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForChunkGroups += "}"
	s := strings.Join([]string{`&ShardsResponse{`,
		`Shards:` + repeatedStringForShards + `,`,
		`Statistics:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Statistics), "Result", "stats.Result", 1), `&`, ``, 1) + `,`,
		`ChunkGroups:` + repeatedStringForChunkGroups + `,`,
		`}`,
	}, "")
	return s
}
func (this *Shard) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Shard{`,
		`Bounds:` + strings.Replace(strings.Replace(this.Bounds.String(), "FPBounds", "FPBounds", 1), `&`, ``, 1) + `,`,
		`Stats:` + strings.Replace(fmt.Sprintf("%v", this.Stats), "IndexStatsResponse", "IndexStatsResponse", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FPBounds) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FPBounds{`,
		`Min:` + fmt.Sprintf("%v", this.Min) + `,`,
		`Max:` + fmt.Sprintf("%v", this.Max) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringIndexgateway(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ShardsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIndexgateway
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ShardsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ShardsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field From", wireType)
			}
			m.From = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndexgateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.From |= github_com_prometheus_common_model.Time(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Through", wireType)
			}
			m.Through = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndexgateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Through |= github_com_prometheus_common_model.Time(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndexgateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIndexgateway
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIndexgateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetBytesPerShard", wireType)
			}
			m.TargetBytesPerShard = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndexgateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TargetBytesPerShard |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIndexgateway(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIndexgateway
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIndexgateway
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ShardsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIndexgateway
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ShardsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ShardsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Shards", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndexgateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIndexgateway
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIndexgateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Shards = append(m.Shards, Shard{})
			if err := m.Shards[len(m.Shards)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Statistics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndexgateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIndexgateway
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIndexgateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Statistics.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChunkGroups", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndexgateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIndexgateway
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIndexgateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ChunkGroups = append(m.ChunkGroups, ChunkRefGroup{})
			if err := m.ChunkGroups[len(m.ChunkGroups)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIndexgateway(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIndexgateway
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIndexgateway
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Shard) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIndexgateway
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Shard: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Shard: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bounds", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndexgateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIndexgateway
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIndexgateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Bounds.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndexgateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIndexgateway
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIndexgateway
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stats == nil {
				m.Stats = &IndexStatsResponse{}
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIndexgateway(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIndexgateway
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIndexgateway
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FPBounds) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIndexgateway
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FPBounds: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FPBounds: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Min", wireType)
			}
			m.Min = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndexgateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Min |= github_com_prometheus_common_model.Fingerprint(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			m.Max = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndexgateway
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Max |= github_com_prometheus_common_model.Fingerprint(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIndexgateway(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIndexgateway
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIndexgateway
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipIndexgateway(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowIndexgateway
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowIndexgateway
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowIndexgateway
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthIndexgateway
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthIndexgateway
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowIndexgateway
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipIndexgateway(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthIndexgateway
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthIndexgateway = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowIndexgateway   = fmt.Errorf("proto: integer overflow")
)
