// Code generated by bpf2go; DO NOT EDIT.
//go:build arm64

package ebpf

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"

	"github.com/cilium/ebpf"
)

type NetConnInitiatorKey struct {
	LowIp      struct{ In6U struct{ U6Addr8 [16]uint8 } }
	HighIp     struct{ In6U struct{ U6Addr8 [16]uint8 } }
	LowIpPort  uint16
	HighIpPort uint16
}

type NetFlowId NetFlowIdT

type NetFlowIdT struct {
	SrcIp             struct{ In6U struct{ U6Addr8 [16]uint8 } }
	DstIp             struct{ In6U struct{ U6Addr8 [16]uint8 } }
	IfIndex           uint32
	EthProtocol       uint16
	SrcPort           uint16
	DstPort           uint16
	TransportProtocol uint8
	Pad               [1]uint8
}

type NetFlowMetrics NetFlowMetricsT

type NetFlowMetricsT struct {
	Bytes           uint64
	StartMonoTimeNs uint64
	EndMonoTimeNs   uint64
	Packets         uint32
	Flags           uint16
	IfaceDirection  uint8
	Initiator       uint8
	Errno           uint8
	Pad             [7]uint8
}

type NetFlowRecordT struct {
	Metrics NetFlowMetrics
	Id      NetFlowId
	Pad     [4]uint8
}

// LoadNet returns the embedded CollectionSpec for Net.
func LoadNet() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_NetBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load Net: %w", err)
	}

	return spec, err
}

// LoadNetObjects loads Net and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*NetObjects
//	*NetPrograms
//	*NetMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadNetObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadNet()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// NetSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type NetSpecs struct {
	NetProgramSpecs
	NetMapSpecs
	NetVariableSpecs
}

// NetProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type NetProgramSpecs struct {
	BeylaEgressFlowParse  *ebpf.ProgramSpec `ebpf:"beyla_egress_flow_parse"`
	BeylaIngressFlowParse *ebpf.ProgramSpec `ebpf:"beyla_ingress_flow_parse"`
}

// NetMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type NetMapSpecs struct {
	AggregatedFlows *ebpf.MapSpec `ebpf:"aggregated_flows"`
	ConnInitiators  *ebpf.MapSpec `ebpf:"conn_initiators"`
	DirectFlows     *ebpf.MapSpec `ebpf:"direct_flows"`
	FlowDirections  *ebpf.MapSpec `ebpf:"flow_directions"`
}

// NetVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type NetVariableSpecs struct {
	Ip4in6            *ebpf.VariableSpec `ebpf:"ip4in6"`
	Sampling          *ebpf.VariableSpec `ebpf:"sampling"`
	TraceMessages     *ebpf.VariableSpec `ebpf:"trace_messages"`
	UnusedFlowId      *ebpf.VariableSpec `ebpf:"unused_flow_id"`
	UnusedFlowMetrics *ebpf.VariableSpec `ebpf:"unused_flow_metrics"`
	UnusedFlowRecord  *ebpf.VariableSpec `ebpf:"unused_flow_record"`
}

// NetObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadNetObjects or ebpf.CollectionSpec.LoadAndAssign.
type NetObjects struct {
	NetPrograms
	NetMaps
	NetVariables
}

func (o *NetObjects) Close() error {
	return _NetClose(
		&o.NetPrograms,
		&o.NetMaps,
	)
}

// NetMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadNetObjects or ebpf.CollectionSpec.LoadAndAssign.
type NetMaps struct {
	AggregatedFlows *ebpf.Map `ebpf:"aggregated_flows"`
	ConnInitiators  *ebpf.Map `ebpf:"conn_initiators"`
	DirectFlows     *ebpf.Map `ebpf:"direct_flows"`
	FlowDirections  *ebpf.Map `ebpf:"flow_directions"`
}

func (m *NetMaps) Close() error {
	return _NetClose(
		m.AggregatedFlows,
		m.ConnInitiators,
		m.DirectFlows,
		m.FlowDirections,
	)
}

// NetVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to LoadNetObjects or ebpf.CollectionSpec.LoadAndAssign.
type NetVariables struct {
	Ip4in6            *ebpf.Variable `ebpf:"ip4in6"`
	Sampling          *ebpf.Variable `ebpf:"sampling"`
	TraceMessages     *ebpf.Variable `ebpf:"trace_messages"`
	UnusedFlowId      *ebpf.Variable `ebpf:"unused_flow_id"`
	UnusedFlowMetrics *ebpf.Variable `ebpf:"unused_flow_metrics"`
	UnusedFlowRecord  *ebpf.Variable `ebpf:"unused_flow_record"`
}

// NetPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadNetObjects or ebpf.CollectionSpec.LoadAndAssign.
type NetPrograms struct {
	BeylaEgressFlowParse  *ebpf.Program `ebpf:"beyla_egress_flow_parse"`
	BeylaIngressFlowParse *ebpf.Program `ebpf:"beyla_ingress_flow_parse"`
}

func (p *NetPrograms) Close() error {
	return _NetClose(
		p.BeylaEgressFlowParse,
		p.BeylaIngressFlowParse,
	)
}

func _NetClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed net_arm64_bpfel.o
var _NetBytes []byte
