// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package tpinjector

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"

	"github.com/cilium/ebpf"
)

type bpfConnectionInfoT struct {
	S_addr [16]uint8
	D_addr [16]uint8
	S_port uint16
	D_port uint16
}

type bpfCpSupportDataT struct {
	T_key      bpfTraceKeyT
	RealClient uint8
	Pad        [7]uint8
}

type bpfEgressKeyT struct {
	S_port uint16
	D_port uint16
}

type bpfMsgBufferT struct {
	Buf [256]uint8
	Pos uint16
}

type bpfPidConnectionInfoT struct {
	Conn bpfConnectionInfoT
	Pid  uint32
}

type bpfPidKeyT struct {
	Tid uint32
	Pid uint32
	Ns  uint32
}

type bpfSslArgsT struct {
	Ssl    uint64
	Buf    uint64
	LenPtr uint64
	Flags  uint64
}

type bpfSslPidConnectionInfoT struct {
	P_conn    bpfPidConnectionInfoT
	OrigDport uint16
	Pad       [6]uint8
}

type bpfTpInfoPidT struct {
	Tp struct {
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid     uint32
	Valid   uint8
	Written uint8
	ReqType uint8
	Pad     [1]uint8
}

type bpfTraceKeyT struct {
	ExtraId uint64
	P_key   bpfPidKeyT
	Pad     [4]uint8
}

type bpfTraceMapKeyT struct {
	Conn bpfConnectionInfoT
	Type uint32
}

// loadBpf returns the embedded CollectionSpec for bpf.
func loadBpf() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load bpf: %w", err)
	}

	return spec, err
}

// loadBpfObjects loads bpf and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*bpfObjects
//	*bpfPrograms
//	*bpfMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func loadBpfObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := loadBpf()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// bpfSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfSpecs struct {
	bpfProgramSpecs
	bpfMapSpecs
	bpfVariableSpecs
}

// bpfProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfProgramSpecs struct {
	BeylaPacketExtender           *ebpf.ProgramSpec `ebpf:"beyla_packet_extender"`
	BeylaPacketExtenderWriteMsgTp *ebpf.ProgramSpec `ebpf:"beyla_packet_extender_write_msg_tp"`
	BeylaSockmapTracker           *ebpf.ProgramSpec `ebpf:"beyla_sockmap_tracker"`
}

// bpfMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfMapSpecs struct {
	ActiveNodejsIds      *ebpf.MapSpec `ebpf:"active_nodejs_ids"`
	ActiveSslConnections *ebpf.MapSpec `ebpf:"active_ssl_connections"`
	ActiveSslReadArgs    *ebpf.MapSpec `ebpf:"active_ssl_read_args"`
	ActiveSslWriteArgs   *ebpf.MapSpec `ebpf:"active_ssl_write_args"`
	ActiveUnixSocks      *ebpf.MapSpec `ebpf:"active_unix_socks"`
	CloneMap             *ebpf.MapSpec `ebpf:"clone_map"`
	CpSupportConnectInfo *ebpf.MapSpec `ebpf:"cp_support_connect_info"`
	EgressKeyMem         *ebpf.MapSpec `ebpf:"egress_key_mem"`
	Events               *ebpf.MapSpec `ebpf:"events"`
	ExtenderJumpTable    *ebpf.MapSpec `ebpf:"extender_jump_table"`
	IncomingTraceMap     *ebpf.MapSpec `ebpf:"incoming_trace_map"`
	MsgBuffers           *ebpf.MapSpec `ebpf:"msg_buffers"`
	NodejsParentMap      *ebpf.MapSpec `ebpf:"nodejs_parent_map"`
	OutgoingTraceMap     *ebpf.MapSpec `ebpf:"outgoing_trace_map"`
	PidCache             *ebpf.MapSpec `ebpf:"pid_cache"`
	PidConnectionInfoMem *ebpf.MapSpec `ebpf:"pid_connection_info_mem"`
	ServerTraces         *ebpf.MapSpec `ebpf:"server_traces"`
	SockDir              *ebpf.MapSpec `ebpf:"sock_dir"`
	SslToConn            *ebpf.MapSpec `ebpf:"ssl_to_conn"`
	TpCharBufMem         *ebpf.MapSpec `ebpf:"tp_char_buf_mem"`
	TpInfoMem            *ebpf.MapSpec `ebpf:"tp_info_mem"`
	TraceMap             *ebpf.MapSpec `ebpf:"trace_map"`
	ValidPids            *ebpf.MapSpec `ebpf:"valid_pids"`
}

// bpfVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpfVariableSpecs struct {
	EXTEND_SIZE       *ebpf.VariableSpec `ebpf:"EXTEND_SIZE"`
	INVALID_POS       *ebpf.VariableSpec `ebpf:"INVALID_POS"`
	TP                *ebpf.VariableSpec `ebpf:"TP"`
	TP_PREFIX         *ebpf.VariableSpec `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE    *ebpf.VariableSpec `ebpf:"TP_PREFIX_SIZE"`
	DisableBlackBoxCp *ebpf.VariableSpec `ebpf:"disable_black_box_cp"`
	FilterPids        *ebpf.VariableSpec `ebpf:"filter_pids"`
	Ip4ip6Prefix      *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	Unused            *ebpf.VariableSpec `ebpf:"unused"`
	UnusedHttp2       *ebpf.VariableSpec `ebpf:"unused_http2"`
	WakeupDataBytes   *ebpf.VariableSpec `ebpf:"wakeup_data_bytes"`
}

// bpfObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfObjects struct {
	bpfPrograms
	bpfMaps
	bpfVariables
}

func (o *bpfObjects) Close() error {
	return _BpfClose(
		&o.bpfPrograms,
		&o.bpfMaps,
	)
}

// bpfMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfMaps struct {
	ActiveNodejsIds      *ebpf.Map `ebpf:"active_nodejs_ids"`
	ActiveSslConnections *ebpf.Map `ebpf:"active_ssl_connections"`
	ActiveSslReadArgs    *ebpf.Map `ebpf:"active_ssl_read_args"`
	ActiveSslWriteArgs   *ebpf.Map `ebpf:"active_ssl_write_args"`
	ActiveUnixSocks      *ebpf.Map `ebpf:"active_unix_socks"`
	CloneMap             *ebpf.Map `ebpf:"clone_map"`
	CpSupportConnectInfo *ebpf.Map `ebpf:"cp_support_connect_info"`
	EgressKeyMem         *ebpf.Map `ebpf:"egress_key_mem"`
	Events               *ebpf.Map `ebpf:"events"`
	ExtenderJumpTable    *ebpf.Map `ebpf:"extender_jump_table"`
	IncomingTraceMap     *ebpf.Map `ebpf:"incoming_trace_map"`
	MsgBuffers           *ebpf.Map `ebpf:"msg_buffers"`
	NodejsParentMap      *ebpf.Map `ebpf:"nodejs_parent_map"`
	OutgoingTraceMap     *ebpf.Map `ebpf:"outgoing_trace_map"`
	PidCache             *ebpf.Map `ebpf:"pid_cache"`
	PidConnectionInfoMem *ebpf.Map `ebpf:"pid_connection_info_mem"`
	ServerTraces         *ebpf.Map `ebpf:"server_traces"`
	SockDir              *ebpf.Map `ebpf:"sock_dir"`
	SslToConn            *ebpf.Map `ebpf:"ssl_to_conn"`
	TpCharBufMem         *ebpf.Map `ebpf:"tp_char_buf_mem"`
	TpInfoMem            *ebpf.Map `ebpf:"tp_info_mem"`
	TraceMap             *ebpf.Map `ebpf:"trace_map"`
	ValidPids            *ebpf.Map `ebpf:"valid_pids"`
}

func (m *bpfMaps) Close() error {
	return _BpfClose(
		m.ActiveNodejsIds,
		m.ActiveSslConnections,
		m.ActiveSslReadArgs,
		m.ActiveSslWriteArgs,
		m.ActiveUnixSocks,
		m.CloneMap,
		m.CpSupportConnectInfo,
		m.EgressKeyMem,
		m.Events,
		m.ExtenderJumpTable,
		m.IncomingTraceMap,
		m.MsgBuffers,
		m.NodejsParentMap,
		m.OutgoingTraceMap,
		m.PidCache,
		m.PidConnectionInfoMem,
		m.ServerTraces,
		m.SockDir,
		m.SslToConn,
		m.TpCharBufMem,
		m.TpInfoMem,
		m.TraceMap,
		m.ValidPids,
	)
}

// bpfVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfVariables struct {
	EXTEND_SIZE       *ebpf.Variable `ebpf:"EXTEND_SIZE"`
	INVALID_POS       *ebpf.Variable `ebpf:"INVALID_POS"`
	TP                *ebpf.Variable `ebpf:"TP"`
	TP_PREFIX         *ebpf.Variable `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE    *ebpf.Variable `ebpf:"TP_PREFIX_SIZE"`
	DisableBlackBoxCp *ebpf.Variable `ebpf:"disable_black_box_cp"`
	FilterPids        *ebpf.Variable `ebpf:"filter_pids"`
	Ip4ip6Prefix      *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	Unused            *ebpf.Variable `ebpf:"unused"`
	UnusedHttp2       *ebpf.Variable `ebpf:"unused_http2"`
	WakeupDataBytes   *ebpf.Variable `ebpf:"wakeup_data_bytes"`
}

// bpfPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to loadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpfPrograms struct {
	BeylaPacketExtender           *ebpf.Program `ebpf:"beyla_packet_extender"`
	BeylaPacketExtenderWriteMsgTp *ebpf.Program `ebpf:"beyla_packet_extender_write_msg_tp"`
	BeylaSockmapTracker           *ebpf.Program `ebpf:"beyla_sockmap_tracker"`
}

func (p *bpfPrograms) Close() error {
	return _BpfClose(
		p.BeylaPacketExtender,
		p.BeylaPacketExtenderWriteMsgTp,
		p.BeylaSockmapTracker,
	)
}

func _BpfClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpf_x86_bpfel.o
var _BpfBytes []byte
