/**
 * A {@link TopologicalOperator} that assigns each node a unique layer.
 *
 * @packageDocumentation
 */
import { LayeringOperator } from ".";
/**
 * A layering that assigns every node a distinct layer, creating a topological
 * layout.
 *
 * This combined with topological coordinate assignment can be thought of as an
 * alternative to {@link ZherebkoOperator}. The latter generally produces more
 * pleasing layouts, but both are options. This operator is
 *
 * Assigns every node a distinct layer. This layering operator is often only
 * useful in conjunction with topological coordinate assignment. This layering
 * is very fast, but it may make other steps take longer due to the many
 * created dummy nodes.
 *
 * Create with {@link topological}.
 *
 * <img alt="topological example" src="media://sugi-topological-opt-topological.png" width="1000">
 */
export declare type TopologicalOperator = LayeringOperator<unknown, unknown>;
/**
 * Create a topological layering.
 */
export declare function topological(...args: never[]): TopologicalOperator;
