import { LayeringOperator } from ".";
/**
 * A {@link LayeringOperator} that restricts the layout to have a maximum
 * width.
 *
 * Assigns every node a layer such that the width, not counting dummy nodes, is
 * always less than some constant. This can result in tall graphs, but is also
 * reasonably fast. If the max width is set to zero (the default), the width
 * will instead be set to the square root of the number of nodes.
 *
 * This method is reasonably fast, but can results in long edges which make the
 * decrossing phase more difficult. Also note that setting {@link width |
 * `width`} to 1 is roughly equivalent to topological layering.
 *
 * Create with {@link coffmanGraham}.
 *
 * <img alt="Coffman-Graham example" src="media://sugi-coffmangraham-opt-quad.png" width="400">
 */
export interface CoffmanGrahamOperator extends LayeringOperator<unknown, unknown> {
    /**
     * Set the maximum width of any layer. If set to 0, the width is set to the
     * rounded square root of the number of nodes. (default: 0)
     */
    width(maxWidth: number): CoffmanGrahamOperator;
    /** Get the operators maximum width. */
    width(): number;
}
/**
 * Create a default {@link CoffmanGrahamOperator}, bundled as
 * {@link layeringCoffmanGraham}.
 */
export declare function coffmanGraham(...args: never[]): CoffmanGrahamOperator;
