/**
 * A {@link DfsOperator} heuristic for quickly producing reasonable crossings.
 * This is intended for use as an initialization step.
 *
 * @packageDocumentation
 */
import { DecrossOperator } from ".";
/**
 * Depth first search operator
 *
 * This is a fast heuristic that runs a depth first search, incrementally
 * adding nodes to their appropriate layer.
 */
export interface DfsOperator extends DecrossOperator<unknown, unknown> {
    /**
     * Sets whether the dfs should be top down or bottom up. (default: true)
     */
    topDown(val: boolean): DfsOperator;
    /**
     * Get the current number of passes
     */
    topDown(): boolean;
}
/**
 * Create a default {@link DfsOperator}, bundled as
 * {@link decrossDfs}.
 */
export declare function dfs(...args: never[]): DfsOperator;
