import { jsx } from 'react/jsx-runtime';
import Editor, { loader } from '@monaco-editor/react';
import * as monaco from 'monaco-editor';
import { useCallback } from 'react';
import '@grafana/data';
import { useTheme2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import defineThemes from './theme.js';

loader.config({ monaco });
const ReactMonacoEditor = (props) => {
  const { beforeMount, options, ...restProps } = props;
  const theme = useTheme2();
  const onMonacoBeforeMount = useCallback(
    (monaco2) => {
      defineThemes(monaco2, theme);
      beforeMount == null ? void 0 : beforeMount(monaco2);
    },
    [beforeMount, theme]
  );
  return /* @__PURE__ */ jsx(
    Editor,
    {
      ...restProps,
      options: {
        ...options,
        fontFamily: theme.typography.code.fontFamily
      },
      theme: theme.isDark ? "grafana-dark" : "grafana-light",
      beforeMount: onMonacoBeforeMount
    }
  );
};

export { ReactMonacoEditor };
//# sourceMappingURL=ReactMonacoEditor.js.map
