import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import * as React from 'react';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { Alert } from '../Alert/Alert.js';
import { Icon } from '../Icon/Icon.js';

const InfoBox = React.memo(
  React.forwardRef(
    ({ title, className, children, branded, url, urlTitle, onDismiss, severity = "info", ...otherProps }, ref) => {
      const styles = useStyles2(getStyles);
      return (
        // component is deprecated so no point fixing this
        // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
        /* @__PURE__ */ jsxs(Alert, { severity, className, ...otherProps, ref, title, children: [
          /* @__PURE__ */ jsx("div", { children }),
          url && /* @__PURE__ */ jsxs("a", { href: url, className: cx("external-link", styles.docsLink), target: "_blank", rel: "noreferrer", children: [
            /* @__PURE__ */ jsx(Icon, { name: "book" }),
            " ",
            urlTitle || "Read more"
          ] })
        ] })
      );
    }
  )
);
InfoBox.displayName = "InfoBox";
const getStyles = (theme) => ({
  docsLink: css({
    display: "inline-block",
    marginTop: theme.spacing(2)
  })
});

export { InfoBox };
//# sourceMappingURL=InfoBox.js.map
